SET QUOTED_IDENTIFIER ON

DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'
DECLARE @miniBrandId NVARCHAR(64) = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'MiniBrandId'), '0')
DECLARE @uniqueId VARCHAR(64) = '720BB139-AB8F-431B-B484-C144D140FE7D'
BEGIN TRY
	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = @uniqueId)
	BEGIN
		IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = N'Secure Agent Install' AND modified =0 )
		BEGIN
			UPDATE GXGlobalParam 
			SET modified = @nowTime 
			WHERE name = N'Secure Agent Install' AND modified =0
		END
		ELSE
		BEGIN
			INSERT INTO GXGlobalParam VALUES(N'Secure Agent Install', '1', @nowTime, 0)
		END
    END

	IF @miniBrandId = '114'
	BEGIN	
		IF EXISTS (SELECT 1 FROM GXGlobalParam WHERE name = N'IsMSPCommcell' AND modified =0 )
		BEGIN
			UPDATE GXGlobalParam 
			SET value = '1'
			WHERE name = N'IsMSPCommcell' AND modified =0
		END
		ELSE
		BEGIN
			INSERT INTO GXGlobalParam VALUES(N'IsMSPCommcell', '1', @nowTime, 0)
		END
	END	
	
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)
        VALUES (@uniqueId, 'SetSecureAgentInstall', 'Script to set secure agent install', @nowTime, 16/*SIM_ID_GX_REL110*/, 0, 18)
END TRY
BEGIN CATCH
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
EXIT_SP:
SELECT @errorCode, @errorString

