SET QUOTED_IDENTIFIER ON

DECLARE @errorCode INT = 0
DECLARE @errorString VARCHAR(MAX) = 'Success'
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())

DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)			
	    			
-- Do this only for OEM 113 - Edge Drive			
IF @oem <> 113			
   return

--Set lock down
EXEC  AppInsertGlobalParam
            @isPIT = 1,
            @createdTime = @nowTime,
            @name = N'Secure Agent Install',
            @newValue = N'1'

--Set Webconsole login to show only My Data
EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'CvFeaturesList',
            @newValue = N'32769'
			
--Enable Quota Feature for commcell
IF EXISTS (SELECT * FROM APP_AdvanceSettings WHERE keyName = 'EnableFSQuotaManagement')
BEGIN
	DELETE APP_AdvanceSettings WHERE keyName = 'EnableFSQuotaManagement'
END

INSERT INTO [CommServ].[dbo].[APP_AdvanceSettings]
           ([entityId]
           ,[keyName]
           ,[type]
           ,[relativePath]
           ,[value]
           ,[enabled]
           ,[deleted]
           ,[entityType]
           ,[sourceId]
           ,[sourceEntityType])
     VALUES
           (2
           ,'EnableFSQuotaManagement'
           ,'INTEGER'
           ,'CommServDB.GxGlobalParam'
           ,'1'
           ,1
           ,0
           ,3
           ,0
           ,0
		   )

--Enable Quota Feature on GUI
IF EXISTS (SELECT * FROM APP_AdvanceSettings WHERE keyName = 'bEnableFSQuotaManagementGUI')
BEGIN
	DELETE APP_AdvanceSettings WHERE keyName = 'bEnableFSQuotaManagementGUI'
END

INSERT INTO [CommServ].[dbo].[APP_AdvanceSettings]
           ([entityId]
           ,[keyName]
           ,[type]
           ,[relativePath]
           ,[value]
           ,[enabled]
           ,[deleted]
           ,[entityType]
           ,[sourceId]
           ,[sourceEntityType])
     VALUES
           (2
           ,'bEnableFSQuotaManagementGUI'
           ,'BOOLEAN'
           ,'CommServDB.Console'
           ,'true'
           ,1
           ,0
           ,3
           ,0
           ,0
		   )
			
--Assign all client owner capabilities to Laptop Clients group
DECLARE @laptopCGId INT = (SELECT id FROM App_Clientgroup WHERE name = 'Laptop Clients' AND flag = 4096)
IF @laptopCGId > 0
BEGIN
       IF NOT EXISTS (SELECT * FROM UMUserandGroupEntityAssociation WHERE entityType = 2572 AND objectId = @laptopCGId AND userId = 0 AND groupId = 0 AND providerId = 0)
       BEGIN
              INSERT INTO [UMUserandGroupEntityAssociation]
                        ([userId]
                        ,[groupId]
                        ,[providerId]
                        ,[capabilities]
                        ,[entityType]
                        ,[objectId]
                        ,[ownerUserId])
              VALUES
                        (0
                        ,0
                        ,0
                        ,(select SUM(POWER(2.0, id-1)) FROM UMCapability)
                        ,2572
                        ,@laptopCGId
                        ,1)
       END
       ELSE
              UPDATE UMUserandGroupEntityAssociation
              SET capabilities = (select SUM(POWER(2.0, id-1)) FROM UMCapability)
              WHERE entityType = 2572 AND objectId = @laptopCGId AND userId = 0 AND groupId = 0 AND providerId = 0

		--this is for inserting into new security tables from v11
		DECLARE @clientGroupOwnerConfigureXML XML = '<App_SecurityAssociationForEntityList>
															<ownerAssociations>
																<categoryPermission categoriesPermissionOperationType="1">
																	<!-- configure all permissions for this client group owner capabilities -->
																	<categoriesPermissionList _type_="123"/>
																</categoryPermission>
															</ownerAssociations>
													</App_SecurityAssociationForEntityList>'

		EXEC sec_setSecurityAssociationsFromEntity @clientGroupOwnerConfigureXML, 1, 0, 0, 28, @laptopCGId, 0, 0, 0, 0, 0, 0, 0, 0
END


--Generate Auth code			
IF NOT EXISTS (SELECT 1 FROM UMGroups WITH (NOLOCK) WHERE name = 'Laptop users')
BEGIN
	INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsProviderId, email, lastCredSetTime)
		VALUES( 1,0,0,1,'Laptop users', '', 2, NEWID(), 0, '', 0)
END

EXEC  AppInsertGlobalParam
            @isPIT = 1,
            @createdTime = @nowTime,
            @name = N'UserRegistration',
            @newValue = N'1'

IF NOT EXISTS (SELECT 1 FROM CloudAuthorization WHERE authCode = 'EDGESIGNUP')
BEGIN
INSERT INTO cloudAuthorization
VALUES('EDGESIGNUP', '', 288, '', 1, 'Edge authcode', DATEDIFF(s, '1970-01-01 00:00:00', GETDATE()), -1, -1)
END

--Assign Installation capability to Laptop Users group
DECLARE @laptopUsersGroupId INT = (SELECT id FROM UMGroups WHERE name = 'Laptop users')
DECLARE @capabilityId INT = 7				--the name is changed from v11. Let us not depend on name anymore. This is macro EV_MANAGE_INSTALLATION

IF NOT EXISTS (SELECT * FROM UMGroupCapability WHERE groupId = @laptopUsersGroupId AND capabilityId = @capabilityid) 
BEGIN
    INSERT INTO UMGroupCapability (groupId, capabilityId, flag) 
        SELECT @laptopUsersGroupId, @capabilityId, 0		
END

IF NOT EXISTS (SELECT * FROM UMSecurityAssociations WHERE userOrGroupId = @laptopUsersGroupId AND isUser = 0 AND permissionId = 65 AND entityTYpe1 = 1 AND entityID1 = 2)
	--According to Anand, we need to insert Install Client for this user group on commcell level	
	INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityTYpe1, entityID1, authorId) 
		SELECT @laptopUsersGroupId, 0, 0, 65, 1, 2, 1				--CAT_COMMCELL_INSTALL_CLIENT (instead of depending on name, hard-coding the id directly from macro)		
		--SELECT @laptopUsersGroupId, 0, 0, CAT_COMMCELL_INSTALL_CLIENT, COMMCELL_ENTITY, DEFAULT_COMMCELL_ID, US_ADMIN_USER_ID


--Generate Download URL and add it to GxGlobalParam
DECLARE @PackageUrlWin64 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
DECLARE @PackageUrlWin32 NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'
DECLARE @PackageUrlMac NVARCHAR(MAX) = 'https://cloud.commvault.com/edge/'

DECLARE @releaseId INT = 11
DECLARE @highestSP INT = 1
DECLARE @minorSP   INT 

IF EXISTS(SELECT 1 FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
AND EXISTS(SELECT 1 FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1)
BEGIN
	SET @releaseId = (SELECT release FROM simAllGalaxyRel WHERE id = (SELECT releaseId FROM APP_Client WHERE id = 2))
	SET @highestSP = ISNULL((SELECT HighestSP FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 1)
	SET @minorSP = ISNULL((SELECT SpMinorVersion FROM SimInstalledPackages WHERE ClientId = 2 AND simPackageID = 1), 0)

	SET @PackageUrlWin64 = @PackageUrlWin64 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
	SET @PackageUrlWin32 = @PackageUrlWin32 + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))
	SET @PackageUrlMac = @PackageUrlMac + CAST(@releaseId AS NVARCHAR(10)) + '/' + CAST(@highestSP AS NVARCHAR(10))

	IF @minorSP = 0
	BEGIN
		SET @PackageUrlWin64 = @PackageUrlWin64 + '/Edge_x64.exe'
		SET @PackageUrlWin32 = @PackageUrlWin32 + '/Edge_x86.exe'
		SET @PackageUrlMac = @PackageUrlMac + '/Edge_Mac.dmg'
	END
	ELSE
	BEGIN
		SET @PackageUrlWin64 = @PackageUrlWin64 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x64.exe'
		SET @PackageUrlWin32 = @PackageUrlWin32 + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_x86.exe'
		SET @PackageUrlMac = @PackageUrlMac + '/' + CAST(@minorSP AS NVARCHAR(10)) + '/Edge_Mac.dmg'
	END
	
END
ELSE
BEGIN
	SET @PackageUrlWin64 = @PackageUrlWin64 + '11/1/Edge_x64.exe'
	SET @PackageUrlWin32 = @PackageUrlWin32 + '11/1/Edge_x86.exe'
	SET @PackageUrlMac = @PackageUrlMac + '11/1/Edge_Mac.dmg'
END

EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlWin64',
            @newValue = @PackageUrlWin64

EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlWin32',
            @newValue = @PackageUrlWin32

EXEC  AppInsertGlobalParam
            @isPIT = 0,
            @createdTime = @nowTime,
            @name = N'PackageUrlMac',
            @newValue = @PackageUrlMac
			
			
ExitSP:
IF ISNULL(@errorCode,0) > 0
BEGIN
	RAISERROR (@errorString, 15, 1)
END
