DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    
-- Do this only for OEM 106 - Virtual Server
IF @oem <> 106
   return

-- Also delete subscription based alerts which are created from global param here for VSA OEM since they are not applicable. 



-- For existing alerts, we will remove criterias where not needed
-- Remove skipped criteria for aux copy job failed from existing alerts
delete NTSelCriteria
from NTSelCriteria inner join NTNotificationRule
on NTSelCriteria.ruleId = NTnotificationRule.id
where NTSelCriteria.availCriteriaid=4
and NTnotificationRule.notificationName='Aux copy job Failed'

delete NTSelCriteria
from NTSelCriteria inner join NTNotificationRule
on NTSelCriteria.ruleId = NTnotificationRule.id
where NTSelCriteria.availCriteriaid=57
and NTnotificationRule.notificationName='Data aging job failure'

Update NTnotificationRule
set notificationName='Data aging job failed'
where NTnotificationRule.notificationName='Data aging job failure'

delete NTSelCriteria
from NTSelCriteria inner join NTNotificationRule
on NTSelCriteria.ruleId = NTnotificationRule.id
where NTSelCriteria.availCriteriaid=54
and NTnotificationRule.notificationName='Dedup DB reconstruction job failed'

delete NTSelCriteria
from NTSelCriteria inner join NTNotificationRule
on NTSelCriteria.ruleId = NTnotificationRule.id
where NTSelCriteria.availCriteriaid=31
and NTnotificationRule.notificationName='Device went offline'

delete NTSelCriteria
from NTSelCriteria inner join NTNotificationRule
on NTSelCriteria.ruleId = NTnotificationRule.id
where NTSelCriteria.availCriteriaid=57
and NTnotificationRule.notificationName='DR backup job failed'

Update NTnotificationRule
set notificationName='Disaster recovery job failed'
where NTnotificationRule.notificationName='DR backup job failed'


DECLARE	@errorCode			as integer = 0
DECLARE @errorString		as nvarchar(max) = ''
DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /></CVGui_CommCellTreeNode>'
DECLARE @allClientXmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="2" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allStoragePolicyXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="16" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allMAsXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="10" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allLibrariesXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="8" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
DECLARE @masterGroupId		as integer  = ISNULL((Select top 1 ID from UMGroups where name='master'),1)	--_US_ADMIN_GROUP__
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @localeId			AS integer		= 1
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE @persistTimeSeconds AS integer		= 0
DECLARE @SelCriteriaId		integer
DECLARE @createdAlertsId	INT = 1
DECLARE @thisCriteria		int
DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
--
---
----  FOR CURSOR -----
DECLARE @alertId			INTEGER
DECLARE @alertType			INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @isAlertEnabled		bit
DECLARE @cursorXmlEntities  nvarchar(MAX)
--
--
DECLARE @alertsToAdd table (
		alertId				int primary key,
		alertType			int Not Null,
		notificationName	nvarchar(128),
		description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max),
		isAlertEnabled		bit,
		xmlEntities			nvarchar(MAX)
)
DECLARE @criteriasToAdd table (
		alertId				int ,
		criteriaId			int ,
		criteriaParamType	int,
		criteriaParamValue	int,
		criteriaParamUnit	int
		primary key(alertId,criteriaId)
)
----------------------
DECLARE	@thisAlertId		integer
SET @errorCode	= 0
SET @errorString= ''
BEGIN TRY
	BEGIN TRAN
	
	DECLARE @htmldefaultTemplateForAuxCopyAlert nvarchar(max)
	DECLARE @textdefaultTemplateForAuxCopyAlert nvarchar(max)
	set @htmldefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media that got copied: &lt;COPIED MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copied data size: &lt;COPIED DATA SIZE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">&nbsp;</td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Media that got copied: <COPIED MEDIA LIST> MsgNewLine_MsgTab_ Copied data size: <COPIED DATA SIZE> MsgNewLine_MsgTab_'
	
	Insert into @criteriasToAdd
	select @createdAlertsId,5,2,4,5
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			2,
			'Aux copy job Failed',
			'Default alert for aux Copy job failed',
			@textdefaultTemplateForAuxCopyAlert,
			@htmldefaultTemplateForAuxCopyAlert	,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataAgingAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataAgingAlert nvarchar(max)
	set @htmldefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Media Barcode List: &lt;PRUNED MEDIA BARCODE LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Jobs Count: &lt;PRUNED JOBS COUNT&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">&nbsp;</td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Pruned Media Barcode List: <PRUNED MEDIA BARCODE LIST> MsgNewLine_MsgTab_ Pruned Jobs Count: <PRUNED JOBS COUNT> MsgNewLine_MsgTab_'
	
	Insert @alertsToAdd values(
			@createdAlertsId,
			1,
			'Data aging job failed',
			'Default alert for data aging job failure',
			@textdefaultTemplateForDataAgingAlert,
			@htmldefaultTemplateForDataAgingAlert	,
			0,
			@XmlEntities
		)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDDBReconAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDDBReconAlert nvarchar(max)
	set @htmldefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">&nbsp;</td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			55,
			'Dedup DB reconstruction job failed',
			'Default Dedup DB reconstruction Job failed alert',
			@textdefaultTemplateForDDBReconAlert,
			@htmldefaultTemplateForDDBReconAlert,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDeviceOfflineAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDeviceOfflineAlert nvarchar(max)
	set @htmldefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Library Name: &lt;LIBRARY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Mount Path: &lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drivepool: &lt;DRIVEPOOL NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drive: &lt;DRIVE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Offline Since: &lt;OFFLINE SINCE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">&nbsp;</td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Library Name: <LIBRARY NAME> MsgNewLine_MsgTab_ Mount Path: <SPAREPOOL/MOUNTPATH NAME> MsgNewLine_MsgTab_ Drivepool: <DRIVEPOOL NAME> MsgNewLine_MsgTab_ Drive: <DRIVE NAME> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_  Offline Since:  <OFFLINE SINCE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			21,
			'Device went offline',
			'Default Device went offline alert',
			@textdefaultTemplateForDeviceOfflineAlert,
			@htmldefaultTemplateForDeviceOfflineAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,29,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	
	Insert @alertsToAdd values(
			@createdAlertsId,
			21,
			'Mount path went offline',
			'Default Mount path went offline alert',
			@textdefaultTemplateForDeviceOfflineAlert,
			@htmldefaultTemplateForDeviceOfflineAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,31,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	
	DECLARE @htmldefaultTemplateForDRAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDRAlert nvarchar(max)
	set @htmldefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Level: &lt;LEVEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">&nbsp;</td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Level: <LEVEL> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			5,
			'Disaster recovery job failed',
			'Default DR Backup Job Failure Alert',
			@textdefaultTemplateForDRAlert,
			@htmldefaultTemplateForDRAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	
	DECLARE @htmldefaultTemplate nvarchar(max)
	DECLARE @textdefaultTemplate nvarchar(max)
	set @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table align="center" cellpadding="0" width="600" cellspacing="0" style="border-top-style: solid; border-bottom-width: 0px; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-right-color: #dedede; border-left-style: solid; border-top-width: 0px; border-left-color: #dedede; border-top-color: #dedede; border-right-style: solid; border-bottom-color: #dedede" border="1">  <tr>  <td>  <center>  <table id="contentTbl" align="center" cellpadding="0" cellspacing="0" width="600" border="0">  <tr style="background-color: #666666">  <td align="left" valign="middle">  <div style="margin-left: 10px; margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="6" color="#EEEEEE">&lt;ALERT NAME&gt; </font>  </div>  </td>  </tr>  <tr>  <td align="left" width="100%" colspan="1">  <ul>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">User: &lt;USER NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Job ID: &lt;JOB ID&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Server: &lt;CLIENT NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Collection: &lt;SUBCLIENT NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Backup Level: &lt;LEVEL&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Start Time: &lt;START TIME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">End Time: &lt;END TIME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Name: &lt;VIRTUAL MACHINE NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Host Name: &lt;VIRTUAL MACHINE HOST NAME&gt;</font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Failure reason for Virtual Machine Backup: &lt;VM FAILURE REASON&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Backup Status: &lt;VM STATUS&gt; </font>  </li>  </ul>  </td>  </tr>  <tr style="background-color: #666666">  <td align="left" colspan="1">&nbsp; </td></tr>  </table>  </center>  </td>  </tr>  </table>'
	set @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Backup Level: <LEVEL> MsgNewLine_MsgTab_ Storage Policies Used: <STORAGE POLICIES USED> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Protected Counts: <PROTECTED COUNT> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_ Virtual Machine Name: <VIRTUAL MACHINE NAME> MsgNewLine_MsgTab_ Virtual Machine Backup Status:  <VM STATUS> MsgNewLine_MsgTab_ Failure reason for Virtual Machine Backup:  <VM FAILURE REASON> MsgNewLine_MsgTab_ Virtual Machine Host Name: <VIRTUAL MACHINE HOST NAME> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'VM Backup failed',
			'Default alert when VM backup fails',
			@textdefaultTemplate,
			@htmldefaultTemplate,
			0,
			@allClientXmlEntities
	)
	
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'VM Backup succeeded',
			'Default alert when VM backup succeeds',
			@textdefaultTemplate,
			@htmldefaultTemplate,
			0,
			@allClientXmlEntities
	)
	
	Insert into @criteriasToAdd
	select @createdAlertsId,1,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'VM Backup succeeded with errors',
			'Default alert when VM backup succeeds',
			@textdefaultTemplate,
			@htmldefaultTemplate,
			0,
			@allClientXmlEntities
	)
	
	Insert into @criteriasToAdd
	select @createdAlertsId,57,NULL,NULL,NULL
	
	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
	DECLARE newDefaultAlertsCursor CURSOR FOR
	SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , isAlertEnabled, XmlEntities
		FROM @alertsToAdd
	OPEN newDefaultAlertsCursor
	FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
	WHILE @@FETCH_STATUS = 0
	BEGIN
		-- Check whether this alert is already present. If so, dont insert again.
		if exists(select 1 from NTNotificationRule
			where notificationName=@notificationName and revision=1
		)
		begin
			FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
			continue
		end
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
		select						categoryId,				@alertType,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@adminID,
									0,						2049,	-- 1 DefaultLocale US-English .. Create  default alerts in disabled state
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@cursorXmlEntities ,
									2,				newid()
				from NTAlerttype where id = @alertType
		SET @thisAlertId = @@Identity
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
		select criteriaId,1,@thisAlertId,0,0,0
		from @criteriasToAdd
		where alertId = @alertId
		SET @SelCriteriaId = @@identity
		if exists(select 1 from @criteriasToAdd where alertId = @alertId and criteriaParamType is not null and
			criteriaParamValue is not null and criteriaParamUnit is not null)
		begin
			INSERT NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)
			select id,0,criteriaParamType,criteriaParamValue,criteriaParamUnit,0
			from NTSelcriteria , @criteriasToAdd newCriterias
			where NTSelcriteria.ruleid = @thisAlertId
			and newCriterias.alertId = @alertId
			and newCriterias.criteriaParamType is not null and
			newCriterias.criteriaParamValue is not null and newCriterias.criteriaParamUnit is not null
		end
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
		INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
									 --
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
               			 0, 0, 0, 0, 2,
						 '', '', '', '', 1, @msgFmtHtml)
		Insert into NTnotificationGroups(NTNotificationId,groupId,escalationLevel)
		select @thisAlertId,@masterGroupId,1
		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
		END	
		Update NTNotificationrule
		set status = status|1024
		where notificationname in ('VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors')
		and revision>0
	END TRY
 BEGIN CATCH
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
