print '... Populating Table: DCPackageRepository'

DECLARE @InstallPath nvarchar(512)
DECLARE @PackagePlatformMapId INT
DECLARE @PkgPlatformMapAttr INT
DECLARE @VFlags INT
DECLARE @VAttr INT
DECLARE @CommCellGroupEntity INT
DECLARE @PackageUserVisibility INT
DECLARE @EveryoneGUID varchar(128)
DECLARE @PackageIdx64 int
DECLARE @PackageId32bit int
DECLARE @PackageIdMac int
DECLARE @PackageId int
DECLARE @SystemAttr int
DECLARE @CategoryId int
DECLARE @SubCategoryId int
DECLARE @PackageServerId INT
DECLARE @PlatformId INT
DECLARE @ProductVersionId INT
DECLARE @DownloadTypeId INT
DECLARE @localErrorMsg  varchar(512) = ''
DECLARE @localErrorCode INT = 0
DECLARE @logicalError INT = 0

IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'MiniBrandId' AND value = '113' AND modified = 0)
BEGIN
	SELECT @logicalError = 0, @localErrorCode = 0, @localErrorMsg = 'Skipping creation of DC package repository enties, OEM Id is not Laptop download trial.'
	GOTO ExitLine
END

BEGIN TRY
	BEGIN TRAN

	SELECT @InstallPath = install_dir + '\Packages\' FROM APP_Platform WITH(NOLOCK) WHERE ClientId = 2 AND platformType = 1

	PRINT 'Found install path from DB:[' + @InstallPath + ']'

	--When we make this a qscript, we need to ask for client name of web server so that we can find client id and put entry into this table.
	IF NOT EXISTS (Select * from DCPackageRepository a WITH(NOLOCK) where a.ClientId = 2)
	BEGIN
		INSERT INTO DCPackageRepository (ClientId, RepositoryType, NetworkPath, VirtualPath, DomainUserName, Password, RepositoryName,CreatedBy, CreateTime)
		SELECT id, 1, '', '', '', '', 'Web Server - ' + Name, 1, GETUTCDATE()
		FROM APP_CLIENT WITH(NOLOCK)
		WHERE Id = 2
	END

	SELECT @PackageServerId = PackageRepositoryId FROM DCPackageRepository WITH(NOLOCK) WHERE ClientId = 2

	print '... Populating Table: DCCategory'

	SELECT @SystemAttr = EntryValue FROM DCReference WITH(NOLOCK) WHERE TypeName = 'Attribute' AND EntryName = 'SystemSaved'
	IF NOT EXISTS (SELECT * FROM DCCategory WITH(NOLOCK) WHERE CategoryName = 'Edge')
	BEGIN
		   INSERT INTO DCCategory (CategoryName, CreateTime, Description, ModifiedTime, Attribute)
		   SELECT 'Edge', GETUTCDATE(), '', NULL, @SystemAttr
	END

	SELECT @CategoryId = CategoryId FROM DCCategory WITH(NOLOCK) WHERE CategoryName = 'Edge'

	print '... Populating Table: DCSubCategory'

	IF NOT EXISTS (SELECT * FROM DCSubCategory WITH(NOLOCK) WHERE SubCategoryName = 'LapTop' and CategoryId = @CategoryId)
	BEGIN
		   INSERT INTO DCSubCategory (SubCategoryName, CreateTime, Description, ModifiedTime, CategoryId, Attribute)
		   SELECT 'LapTop', GETUTCDATE(), '', NULL, @CategoryId, @SystemAttr
	END

	SELECT @SubCategoryId = SubCategoryId FROM DCSubCategory WITH(NOLOCK) WHERE SubCategoryName = 'LapTop'
	SELECT @ProductVersionId = ProductVersionId FROM DCProductVersion WITH(NOLOCK) WHERE Name = '10.0'
	SELECT @DownloadTypeId = DownloadTypeId FROM DCDownloadType WITH(NOLOCK) WHERE DownloadType = 'Exe'

	SELECT @PackageId = PackageId from DCPackage WITH(NOLOCK) WHERE PackageName = 'x64 LAPTOP Package' AND ProductVersionId = @ProductVersionId

	IF ISNULL(@PackageId, 0) = 0
	BEGIN
		print '... Populating Table: DCPackage: Inserting Laptop 64 bit package'

		INSERT INTO DCPackage (
			PackageName,Description,Location,
			PackageRepositoryId,PackageSize,CategoryId,
			SubCategoryId,DownloadTypeId,ProductVersionId,
			RecutNumberId,Notification,RemoteSecureAccessLink,
			BOLLink,StartDate,EndDate,
			IconImage,DownloadAction,PackageStatus,
			PackageXML,CreateTime,ModifiedTime,
			Attribute,CreatedBy,ModifiedBy,
			VendorID,ReadMeLocation
			)
		SELECT 'x64 LAPTOP Package' AS PackageName, 'Use this for the first install on each computer' AS Description, @InstallPath + 'Win64_Install.exe' AS Location, 
		@PackageServerId AS PackageRepositoryId, 82017224 AS PackageSize, @CategoryId AS CategoryId, 
		@SubCategoryId AS SubCategoryId, @DownloadTypeId AS DownloadTypeId, @ProductVersionId AS ProductVersionId, 
		NULL as RecutNumberId, '' as Notification, '' AS RemoteSecureAccessLink, 
		'' AS BOLLink, GetUtcDate() AS StartDate, NULL AS EndDate, 
		'' AS IconImage, 1 AS DownloadAction, 0 AS PackageStatus, 
		'<extraPropContainer><extraProperties name="rank" value="1" /></extraPropContainer>' AS PackageXML, GETUTCDATE() AS CreateTime, NULL AS ModifiedTime, 
		0 AS Attribute, 1 AS CreatedBy, NULL AS ModifiedBy, 
		NULL AS VendorID, '' AS ReadMeLocation

		SELECT @PackageId = @@IDENTITY
	END
	ELSE
	BEGIN
		print '... Entry in table DCPackage already exists for Laptop 64 bit package'
	END

	SELECT @PackageIdx64 = @PackageId
	Select @PlatformId = PlatformId FROM DCPlatform WITH(NOLOCK) WHERE PlatformName = 'Windows-x64'
	Select @PackagePlatformMapId = PackagePlatformMappingId, @PkgPlatformMapAttr = Attribute FROM DCPackagePlatform WITH(NOLOCK) WHERE PackageId = @PackageId AND PlatformId = @PlatformId

	IF ISNULL(@PackagePlatformMapId, 0) > 0
	BEGIN
		if @PkgPlatformMapAttr & 4 = 0
		BEGIN
			print '... Entry in table DCPackagePlatform already exists for Laptop 64 bit package'
		END
		ELSE
		BEGIN
			UPDATE DCPackagePlatform
			SET Attribute = Attribute & ~4
			WHERE PackagePlatformMappingId = @PackagePlatformMapId
		END
	END
	ELSE
	BEGIN
		print '... Populating Table: DCPackagePlatform: Inserting package platform information for Laptop 64 bit package'

		INSERT INTO DCPackagePlatform (PlatformId, PackageId, CreateTime, Attribute)
		SELECT @PlatformId, @PackageId, GETUTCDATE(), @SystemAttr
	END

	SET @PackageId = NULL -- reset before re-use
	SELECT @PackageId = PackageId from DCPackage WITH(NOLOCK) WHERE PackageName = 'Win32 LAPTOP Package' AND ProductVersionId = @ProductVersionId

	IF ISNULL(@PackageId, 0) = 0
	BEGIN
		print '... Populating Table: DCPackage: Inserting Laptop 32 bit package'

		INSERT INTO DCPackage (
			PackageName,Description,Location,
			PackageRepositoryId,PackageSize,CategoryId,
			SubCategoryId,DownloadTypeId,ProductVersionId,
			RecutNumberId,Notification,RemoteSecureAccessLink,
			BOLLink,StartDate,EndDate,
			IconImage,DownloadAction,PackageStatus,
			PackageXML,CreateTime,ModifiedTime,
			Attribute,CreatedBy,ModifiedBy,
			VendorID,ReadMeLocation
			)
		SELECT 'Win32 LAPTOP Package' AS PackageName, 'Use this for the first install on each computer' AS Description, @InstallPath + 'Win32_Install.exe' AS Location, 
		@PackageServerId AS PackageRepositoryId, 71739424 AS PackageSize, @CategoryId AS CategoryId, 
		@SubCategoryId AS SubCategoryId, @DownloadTypeId AS DownloadTypeId, @ProductVersionId AS ProductVersionId, 
		NULL as RecutNumberId, '' as Notification, '' AS RemoteSecureAccessLink, 
		'' AS BOLLink, GetUtcDate() AS StartDate, NULL AS EndDate, 
		'' AS IconImage, 1 AS DownloadAction, 0 AS PackageStatus, 
		'<extraPropContainer><extraProperties name="rank" value="2" /></extraPropContainer>' AS PackageXML, GETUTCDATE() AS CreateTime, NULL AS ModifiedTime, 
		0 AS Attribute, 1 AS CreatedBy, NULL AS ModifiedBy, 
		NULL AS VendorID, '' AS ReadMeLocation

		SELECT @PackageId = @@IDENTITY
	END
	ELSE
	BEGIN
		print '... Entry in table DCPackage already exists for Laptop 32 bit package'
	END

	SELECT @PackageId32bit = @PackageId
	SELECT @PlatformId = NULL, @PackagePlatformMapId = NULL, @PkgPlatformMapAttr = NULL -- reset before re-use
	Select @PlatformId = PlatformId FROM DCPlatform WITH(NOLOCK) WHERE PlatformName = 'Windows-x86'
	Select @PackagePlatformMapId = PackagePlatformMappingId, @PkgPlatformMapAttr = Attribute FROM DCPackagePlatform WITH(NOLOCK) WHERE PackageId = @PackageId AND PlatformId = @PlatformId

	IF ISNULL(@PackagePlatformMapId, 0) > 0
	BEGIN
		if @PkgPlatformMapAttr & 4 = 0
		BEGIN
			print '... Entry in table DCPackagePlatform already exists for Laptop 32 bit package'
		END
		ELSE
		BEGIN
			UPDATE DCPackagePlatform
			SET Attribute = Attribute & ~4
			WHERE PackagePlatformMappingId = @PackagePlatformMapId
		END
	END
	ELSE
	BEGIN
		print '... Populating Table: DCPackagePlatform: Inserting package platform information for Laptop 32 bit package'

		INSERT INTO DCPackagePlatform (PlatformId, PackageId, CreateTime, Attribute)
		SELECT @PlatformId, @PackageId, GETUTCDATE(), @SystemAttr
	END

	SET @PackageId = NULL -- reset before re-use
	SELECT @PackageId = PackageId from DCPackage WITH(NOLOCK) WHERE PackageName = 'MAC LAPTOP Package' AND ProductVersionId = @ProductVersionId

	IF ISNULL(@PackageId, 0) = 0
	BEGIN
		print '... Populating Table: DCPackage: Inserting Laptop MAC package'

		SET @DownloadTypeId = NULL
		SELECT @DownloadTypeId = DownloadTypeId FROM DCDownloadType WHERE DownloadType = 'Media Kit'

		INSERT INTO DCPackage (
			PackageName,Description,Location,
			PackageRepositoryId,PackageSize,CategoryId,
			SubCategoryId,DownloadTypeId,ProductVersionId,
			RecutNumberId,Notification,RemoteSecureAccessLink,
			BOLLink,StartDate,EndDate,
			IconImage,DownloadAction,PackageStatus,
			PackageXML,CreateTime,ModifiedTime,
			Attribute,CreatedBy,ModifiedBy,
			VendorID,ReadMeLocation
			)
		SELECT 'MAC LAPTOP Package' AS PackageName, 'Use this for the first install on each computer' AS Description, @InstallPath + 'Mac_Install.dmg' AS Location, 
		@PackageServerId AS PackageRepositoryId, 61521347 AS PackageSize, @CategoryId AS CategoryId, 
		@SubCategoryId AS SubCategoryId, @DownloadTypeId AS DownloadTypeId, @ProductVersionId AS ProductVersionId, 
		NULL as RecutNumberId, '' as Notification, '' AS RemoteSecureAccessLink, 
		'' AS BOLLink, GetUtcDate() AS StartDate, NULL AS EndDate, 
		'' AS IconImage, 1 AS DownloadAction, 0 AS PackageStatus, 
		'<extraPropContainer><extraProperties name="rank" value="3" /></extraPropContainer>' AS PackageXML, GETUTCDATE() AS CreateTime, NULL AS ModifiedTime, 
		0 AS Attribute, 1 AS CreatedBy, NULL AS ModifiedBy, 
		NULL AS VendorID, '' AS ReadMeLocation

		SELECT @PackageId = @@IDENTITY
	END
	ELSE
	BEGIN
		print '... Entry in table DCPackage already exists for Laptop MAC package'
	END

	SELECT @PackageIdMac = @PackageId
	SELECT @PlatformId = NULL, @PackagePlatformMapId = NULL, @PkgPlatformMapAttr = NULL -- reset before re-use
	Select @PlatformId = PlatformId FROM DCPlatform WITH(NOLOCK) WHERE PlatformName = 'MAC'
	Select @PackagePlatformMapId = PackagePlatformMappingId, @PkgPlatformMapAttr = Attribute FROM DCPackagePlatform WITH(NOLOCK) WHERE PackageId = @PackageId AND PlatformId = @PlatformId

	IF ISNULL(@PackagePlatformMapId, 0) > 0
	BEGIN
		if @PkgPlatformMapAttr & 4 = 0
		BEGIN
			print '... Entry in table DCPackagePlatform already exists for Laptop MAC package'
		END
		ELSE
		BEGIN
			UPDATE DCPackagePlatform
			SET Attribute = Attribute & ~4
			WHERE PackagePlatformMappingId = @PackagePlatformMapId
		END
	END
	ELSE
	BEGIN
		print '... Populating Table: DCPackagePlatform: Inserting package platform information for Laptop MAC package'

		INSERT INTO DCPackagePlatform (PlatformId, PackageId, CreateTime, Attribute)
		SELECT @PlatformId, @PackageId, GETUTCDATE(), @SystemAttr
	END

	print '... Populating Table: DCPackageVisiblity'

	SELECT @CommCellGroupEntity = EntryValue FROM DCReference WITH(NOLOCK) where TypeName = 'SecuredEntity' AND EntryName = 'CommCellGroup'
	SELECT @PackageUserVisibility = EntryValue FROM DCReference WITH(NOLOCK) where TypeName = 'PackageUserFlag' AND EntryName = 'VisibleTo'
	SELECT @EveryoneGUID = GUID FROM UMGroups WITH(NOLOCK) WHERE Name = 'everyone'

	DECLARE @idx INT = 0

	IF @EveryoneGUID IS NULL
	BEGIN
		SELECT @logicalError = 1, @localErrorCode = 1, @localErrorMsg = 'Script failed creating package because user group with name everyone not found'
		GOTO ExitLine
	END
	ELSE
	BEGIN
		WHILE @idx < 3
		BEGIN
			SELECT @VFlags = NULL, @VAttr = NULL
			PRINT 'Iteration #[' + convert(varchar, @idx) + '] of visibility insertion' 
			IF @idx = 0
			BEGIN
				SET @PackageId = @PackageIdx64
				PRINT 'Ensuring visibility for x64 laptop package'
			END
			ELSE IF @idx = 1
			BEGIN
				SET @PackageId = @PackageId32bit
				PRINT 'Ensuring visibility for Win32 laptop package'
			END
			ELSE IF @idx = 2
			BEGIN				
				SET @PackageId = @PackageIdMac
				PRINT 'Ensuring visibility for MAC laptop package'				
			END

			SELECT @VFlags = X.VisbilityFlags, @VAttr = X.Attribute FROM DCPackageVisibility X WITH(NOLOCK) WHERE X.PackageId = @PackageId AND X.SecuredEntityGuid = @EveryoneGUID  

			--if record exist update, else insert into DCPackageVisiblity
			IF ISNULL(@VAttr, 0) > 0 
			BEGIN
				PRINT 'Updating visibility for PackageId = ' + CONVERT(VARCHAR, @PackageId) + ' and SecuredEntityGuid = ' + @EveryoneGUID
				
				UPDATE DCPackageVisibility
				SET VisbilityFlags = VisbilityFlags | @PackageUserVisibility, 
				SecuredEntityType = @CommCellGroupEntity,
				Attribute = (CASE WHEN Attribute & 4 = 4 THEN Attribute & ~4 ELSE Attribute END)
				WHERE PackageId = @PackageId AND SecuredEntityGuid = @EveryoneGUID 
			END
			BEGIN
				PRINT 'Inserting visibility for PackageId = ' + CONVERT(VARCHAR, @PackageId) + ' and SecuredEntityGuid = ' + @EveryoneGUID
				
				INSERT INTO DCPackageVisibility (SecuredEntityGuid, SecuredEntityType, PackageId, VisbilityFlags, Attribute, CreateTime, ModifiedTime)
				SELECT @EveryoneGUID AS SecuredEntityGuid, @CommCellGroupEntity AS SecuredEntityType, @PackageId AS PackageId, 
				@PackageUserVisibility AS VisbilityFlags, @SystemAttr AS Attribute, GETUTCDATE() AS CreateTime, NULL AS ModifiedTime
			END
			SET @idx = @idx + 1
		END
	END

	COMMIT TRAN
	print 'Completed running script successfully'
END TRY
BEGIN CATCH
	ROLLBACK TRAN
	SELECT @logicalError = 0, @localErrorMsg = ERROR_MESSAGE(),  @localErrorCode = ERROR_NUMBER()
END CATCH

ExitLine:
IF @logicalError = 1
BEGIN
	ROLLBACK TRAN
END
IF ISNULL(@localErrorCode,0) > 0
BEGIN
	RAISERROR (@localErrorMsg, 15, 1)
END
