SET QUOTED_IDENTIFIER ON

DECLARE @subclientPolicyName  NVARCHAR(MAX) = 'WindowsPolicy'
DECLARE @storagePolicyID INT = 1
DECLARE @userId  INT = 1



DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())

DECLARE @subclientPolicyId INT
DECLARE @defaultsubclientId  INT


DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    
-- Do this only for OEM 113 - Edge brand

IF @oem <> 113
   return



IF EXISTS (SELECT 1 FROM APP_BackupSetName WITH (NOLOCK) WHERE name = @subclientPolicyName AND status & 0x80 <> 0) --CV_STATUS_POLICY_BSET
BEGIN
	SET @errorCode = 2
	SET @errorString = N'Skipping creation of windows subclient policy, subclient policy WindowsPolicy is already available.'
    GOTO EXIT_SP
END
BEGIN TRY

    INSERT INTO APP_BackupSetName
        VALUES(@subclientPolicyName, @nowTime, @nowTime, 0x80, 0, 0, 2, NEWID())

    SET @subclientPolicyId = (SELECT id FROM APP_BackupSetName with(nolock) WHERE name = @subclientPolicyName)
    
	--Insert into APP_BackupSetProp
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Associated subclient Policy Ida Type', 7, '2', @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Subclient Policy Create UserId', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0)
    INSERT INTO APP_BackupSetProp
        VALUES(@subclientPolicyId, 'Use Change Journal', 2, '0', @nowTime, 0, 0)
    
    --Insert into APP_Application
    INSERT INTO APP_Application
        VALUES( 2 , 1030, 1, @subclientPolicyId, 0, @storagePolicyID, @storagePolicyID, @nowTime, @nowTime, 'default', 8, 0, 0, 2, NEWID())

    SET @defaultsubclientId = SCOPE_IDENTITY()
    --Insert into APP_SubclientProp
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last data SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'last log SP', 10, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys: pre post option', 10, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS Enabled', 2, '1', @nowTime, 0,0)
    INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS for System State', 2, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'prepost password', 1, '3cfe3eeb854e8aa64e0155bec019674d5', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'System State', 2, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'System State on Full Backup Only', 2, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'sys:nStreams', 7, '2', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Block Size', 7, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'FLR Hash Min File Size', 7, '0', @nowTime, 0,0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
        VALUES(@defaultsubclientId, 'Use VSS Options', 7, '2', @nowTime, 0,0)



	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 1, '\%Documents%', @nowTime, 0, 0)
	
	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 1, '\%Desktop%', @nowTime, 0, 0)
	
	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 1, '\%Music%', @nowTime, 0, 0)
	
	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 1, '\%Pictures%', @nowTime, 0, 0)
	
	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 1, '\%Videos%', @nowTime, 0, 0)
		
    INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId)
		VALUES (@defaultsubclientId, 3, '\%Temporary Files%', @nowTime, 0, 0)

    
END TRY
BEGIN CATCH
--CATCH_HANDLING_MACRO
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
EXIT_SP:
SELECT @errorCode, @errorString

