
SET NOCOUNT ON

DECLARE @userGroupAdminName   AS NVARCHAR(MAX) = N'master'
DECLARE @userGroupRestoreName AS NVARCHAR(MAX) = N'Restore operator'
DECLARE @userGroupBackupName  AS NVARCHAR(MAX) = N'Backup operator'
DECLARE @userGroupMasterName  AS NVARCHAR(MAX) = N'master'

-- User group flags are defined in a following way:
-- -- GF_GROUP_ENABLED   0x0001
-- -- GF_GROUP_DELETED   0x0002
-- -- GF_GROUP_PROTECTED 0x8000
DECLARE @userGroupFlag AS INT = (CONVERT(int, 0x8000) + CONVERT(int, 0x0001))
DECLARE @groupId AS INT = 0


DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    
-- Do this only for OEM 106 - Virtual Server
IF @oem <> 106
   return



-- if group with name '@userGroupAdminName' does not exist then create one
IF NOT EXISTS (SELECT * FROM UMGroups WHERE (name = @userGroupAdminName) AND (origCCId = 2)) BEGIN

    -- if group '@userGroupMasterName' exists then rename it
    IF EXISTS (SELECT * FROM UMGroups WHERE (name = @userGroupMasterName) AND (origCCId = 2)) BEGIN

        UPDATE UMGroups SET name = @userGroupAdminName WHERE (name = @userGroupMasterName) AND (origCCId = 2) 

    END 
    -- if group 'master' does not exist then create it
    ELSE BEGIN

        -- create group 
        INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID])
        VALUES              (@userGroupFlag, 1, 1, 1, @userGroupAdminName, N'VWeb Administrative Group', 2, NEWID())

        -- getting id of newly created user group
        SET @groupId = SCOPE_IDENTITY()

        -- populate capability table : what vweb admin user is able to do : basicaly everything
        INSERT INTO UMGroupCapability(groupId, capabilityId, flag)
        VALUES  (@groupId,  1, 0),
                (@groupId,  2, 0),
                (@groupId,  3, 0),
                (@groupId,  4, 0),
                (@groupId,  5, 0),
                (@groupId,  6, 0),
                (@groupId,  7, 0),
                (@groupId,  8, 0),
                (@groupId,  9, 0),
                (@groupId, 10, 0),
                (@groupId, 11, 0),
                (@groupId, 12, 0),
                (@groupId, 13, 0),
                (@groupId, 14, 0),
                (@groupId, 15, 0),
                (@groupId, 16, 0),
                (@groupId, 18, 0),
                (@groupId, 20, 0),
                (@groupId, 22, 0),
                (@groupId, 24, 0),
                (@groupId, 25, 0),
                (@groupId, 26, 0),
                (@groupId, 27, 0),
                (@groupId, 29, 0),
                (@groupId, 31, 0),
                (@groupId, 32, 0),
                (@groupId, 33, 0),
                (@groupId, 34, 0),
                (@groupId, 35, 0),
                (@groupId, 36, 0),
                (@groupId, 38, 0),
                (@groupId, 39, 0),
                (@groupId, 40, 0),
                (@groupId, 41, 0),
                (@groupId, 42, 0)
   
    END

END

IF NOT EXISTS (SELECT * FROM UMGroups WHERE (name = @userGroupRestoreName) AND (origCCId = 2)) BEGIN

    INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID])
    VALUES              (@userGroupFlag, 0, 1, 1, @userGroupRestoreName, N'VWeb Restore Operators Group', 2, NEWID())

    -- getting id of newly created user group
    SET @groupId = SCOPE_IDENTITY()

    -- populate capability table : what vweb restore operator is able to do
    INSERT INTO UMGroupCapability(groupId, capabilityId, flag)
    VALUES  (@groupId,  2, 0),  -- * Agent Management
            (@groupId,  3, 0),  -- * Agent Scheduling
            (@groupId, 13, 0),  -- * Browse
            (@groupId, 15, 0),  -- * Report Management
            (@groupId, 16, 0),  -- * Job Management
            (@groupId, 18, 0),  -- * Alert Management
            (@groupId, 20, 0),  -- * In Place Recover 
            (@groupId, 22, 0),  -- * Out of Place Recover
            (@groupId, 24, 0),  -- * EndUser Access
            (@groupId, 25, 0),  -- * Compliance Search 
            (@groupId, 36, 0),  -- Recover and Download
            (@groupId, 38, 0),  -- * Live Browse 
            (@groupId, 39, 0),  -- * In Place Full Machine Recovery  
            (@groupId, 42, 0)   -- * Out of Place Full Machine Recovery
END

IF NOT EXISTS (SELECT * FROM UMGroups WHERE (name = @userGroupBackupName) AND (origCCId = 2)) BEGIN

INSERT INTO UMGroups(groupFlags, allCapabilities, allAssociations, selfAssociation, name, [description], origCCId, [GUID])
VALUES              (@userGroupFlag, 0, 1, 1, @userGroupBackupName, N'VWeb Backup Operators Group', 2, NEWID())

    -- getting id of newly created user group
SET @groupId = SCOPE_IDENTITY()

-- populate capability table : what vweb backup operator is able to do
INSERT INTO UMGroupCapability(groupId, capabilityId, flag)
VALUES  (@groupId,  2, 0),  -- Agent Management
        (@groupId,  3, 0),  -- Agent Scheduling
        (@groupId,  4, 0),  -- Storage Policy Management
        (@groupId,  7, 0),  -- Install capability
        (@groupId,  8, 0),  -- Library Management
        (@groupId, 10, 0),  -- MediaAgent Management
        (@groupId, 11, 0),  -- Library Administration
        (@groupId, 12, 0),  -- Data Protection Operations
        (@groupId, 16, 0),  -- Job Management
        (@groupId, 18, 0)   -- Alert Management

END


