SET QUOTED_IDENTIFIER ON
BEGIN TRANSACTION
DECLARE @errorCode INT = 0
DECLARE @scgExitCode INT
DECLARE @scgExitMsg VARCHAR(1024)
DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
DECLARE @createAsUserID INT     
IF NOT EXISTS (select * from GXGlobalParam where name='oldreleasenumber')
	BEGIN
		DECLARE @scgId INTEGER
		DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
		DECLARE @ownerId int = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
		DECLARE @masterRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)			--can we assume "1" ? 
			--IF NOT EXISTS (SELECT * from app_clientgroup where name = 'Virtual Clients')
			--BEGIN
			--	DECLARE @VirtualClientsGroupRuleQuery nvarchar (max) = 'select id from app_client where (dbo.scgGetClientProps(id,  ''='', ''3'' ) = 1)'

			--	insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
			--		values('Virtual Clients', 'Selects Clients which are virtual', 0x1000, 0, @ownerId, 0, '0', '', 2)
			--	SET @scgId = @@IDENTITY
			--	insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
			--		values (@scgId, 
				--		'<scgRule op="0"><rules><rule propID="2" filterID="100" value="3" secValue="Virtual" propType="4" /></rules></scgRule>',
				--		@VirtualClientsGroupRuleQuery,
				--		1, 0, '0')
			--	INSERT INTO [UMUserandGroupEntityAssociation]
			--         ([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
			--     VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)

			--END

		IF NOT EXISTS (SELECT * from app_clientgroup where name = 'Media Agents')
		BEGIN
					-- converted to SCG V2
					DECLARE @MediaAgentsGroupRuleQuery nvarchar (max) --SCG V1 = 'select id from app_client where ( dbo.scgGetClientProps(id,  ''='', ''5'' ) = 1 )'

					insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
					values('Media Agents', 'Selects Clients which have media agents installed', 0x1000, 0, @ownerId, 0, '0', '', 2)
					SET @scgId = @@IDENTITY

					SET @scgExitCode = 0
					SET @scgExitMsg = ''
					--SCG_PKID_CLIENT_PROP=2=prodID
					DECLARE @maSCGRule NVARCHAR(1024) = '<scgRule op="0"><rules><rule propID="2" filterID="100" value="5" secValue="Media_Agent" propType="4" /></rules></scgRule>'
					EXEC APPSCGV2GenerateQueryParams @maSCGRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @MediaAgentsGroupRuleQuery OUTPUT

					IF (@scgExitCode <> 0)
					BEGIN
						PRINT 'Failed to create MediaAgent Smart Client Group.'
						SET @errorCode = 1
						GOTO END_OF_PROC
					END

					insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
					values(@scgId, 
						@maSCGRule,
						@MediaAgentsGroupRuleQuery,
						1, 0, '0')
					INSERT INTO [UMUserandGroupEntityAssociation]
					([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
					VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)

					--can we call sec_setCreatorForEntity stored procedure from here ? 
					INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
						SELECT @masterRoleId, 0, @masterUserGroupId, 0, 28, @scgId, 1, 1

					EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/, @scgId, @createAsUserID OUTPUT

					UPDATE APP_ClientGroup
					SET userId = @createAsUserID
					WHERE id = @scgID 
					
		END

		IF NOT EXISTS (SELECT * from app_clientgroup where name = 'Laptop Clients')
		BEGIN

						DECLARE @LaptopClientsGroupRuleQuery nvarchar (max) -- SCG V1 = 'select id from app_client where ( dbo.scgGetClientProps(id,  ''='', ''7'' ) = 1 )'

						insert into app_clientgroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId) 
						values('Laptop Clients', 'Selects Clients which are laptop', 0x1000, 0, @ownerId, 0, '0', '', 2)
						SET @scgId = @@IDENTITY

						SET @scgExitCode = 0
						SET @scgExitMsg = ''
						--SCG_PKID_CLIENT_PROP=2=prodID
						DECLARE @lcSCGRule NVARCHAR(1024) = '<scgRule op="0"><rules><rule propID="2" filterID="100" value="7" secValue="Laptop Client" propType="4" /></rules></scgRule>'
						EXEC APPSCGV2GenerateQueryParams @lcSCGRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @LaptopClientsGroupRuleQuery OUTPUT

						IF (@scgExitCode <> 0)
						BEGIN
							PRINT 'Failed to create Laptop Smart Client Group.'
							SET @errorCode = 1
							GOTO END_OF_PROC
						END

						insert into app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
						values(@scgId, 
							@lcSCGRule,
							@LaptopClientsGroupRuleQuery,
							1, 0, '0')
						INSERT INTO [UMUserandGroupEntityAssociation]
						([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
						VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)

						INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId) 
							SELECT @masterRoleId, 0, @masterUserGroupId, 0, 28, @scgId, 1, 1

						EXEC sec_getCreateAsUserId 28 /*CLIENT_GROUP_ENTITY*/, @scgId, @createAsUserID OUTPUT

						UPDATE APP_ClientGroup
						SET userId = @createAsUserID
						WHERE id = @scgID

						-- Update xml entity list for default subscription based alerts to laptop clients client group.
						DECLARE @dloClientGroup INT = ISNULL((SELECT MAX(id) FROM APP_ClientGroup WHERE flag&4096=4096 AND name = 'Laptop Clients'), 0)
						if (@dloClientGroup>0)
						begin
							DECLARE @xmlEntities		AS nvarchar(MAX)= ''
							set @xmlEntities = '<CVGui_CommCellTreeNode><associations _type_="28" clientGroupId="'+convert(nvarchar(max),@dloClientGroup)+'" clientGroupName="Laptop Clients" /></CVGui_CommCellTreeNode>'
							update NTnotificationRule
							set xmlEntityList=@xmlEntities
							where revision=1
							and notificationName in ('No backup for last 4 days','No backup for last 3 days','Restore job failed')
							and (status & 128)>0 --NT_STATUS_LAPTOP_ALERT
						end	

                        -- UPDATE XML ENTITY LIST FOR DEFAULT INSTALL SCHEDULES.
	                    DECLARE @xmlClients	XML = '<TMMsg_JobOption><adminOpts><updateOption commcellId="2" ignoreRunningJobs="1" invokeLevel="1" removeIntersectingDiag="1" rebootClient="0"><installUpdatesJobType installUpdates="1" undoUpdates="0" upgradeClients="0" /><clientAndClientGroups _type_="2" /><clientAndClientGroups _type_="27" /><clientAndClientGroups clientGroupId="'+CAST(@scgId AS VARCHAR(10))+'" _type_="28"><flags exclude="1" /></clientAndClientGroups></updateOption></adminOpts></TMMsg_JobOption>'
	                    DECLARE @xmlLaptops	XML = '<TMMsg_JobOption><adminOpts><updateOption commcellId="2" ignoreRunningJobs="1" invokeLevel="1" removeIntersectingDiag="1" rebootClient="0"><installUpdatesJobType installUpdates="1" undoUpdates="0" upgradeClients="0" /><clientAndClientGroups clientGroupId="'+CAST(@scgId AS VARCHAR(10))+'" _type_="28" /></updateOption></adminOpts><commonOpts><automaticSchedulePattern maxBackupInterval="72" maxBackupIntervalMinutes="0" minBackupInterval="36" minBackupIntervalMinutes="0" minSyncInterval="0" minSyncIntervalMinutes="0" ignoreOpWindowPastMaxInterval="0" /></commonOpts></TMMsg_JobOption>'

						IF object_id('tempdb.dbo.#subTask_InfoTable') is not null 
							DROP TABLE #subTask_InfoTable

						CREATE TABLE #subTask_InfoTable (subTaskId INT, flags INT, id INT, jobXML XML)

						INSERT INTO #subTask_InfoTable
						SELECT S.subTaskId, S.flags, O.id, O.value
						FROM TM_SubTask S
						JOIN TM_SubTaskOptions O ON O.subTaskId = S.subTaskId AND S.flags&0x2080 <> 0 AND O.optionId = 239177580

						UPDATE #subTask_InfoTable
						SET jobXML.modify('replace value of (/clientAndClientGroups[1]/@clientGroupId)[1] with sql:variable("@scgId")')
						WHERE jobXML.value('/clientAndClientGroups[1]/@clientGroupId', 'INT') = 0

						UPDATE TM_SubTaskOptions
						SET value = CAST(T.jobXML AS NVARCHAR(MAX))
						FROM
						(
							SELECT id, jobXML
							FROM #subTask_InfoTable
						) T
						WHERE T.id = TM_SubTaskOptions.id

            			UPDATE TM_SubTaskXMLOptions SET xmlValue = @xmlLaptops WHERE subTaskId IN (SELECT subTaskId FROM #subTask_InfoTable WHERE flags&0x2000=0x2000)

            			UPDATE TM_SubTaskXMLOptions SET xmlValue = @xmlClients WHERE subTaskId IN (SELECT subTaskId FROM #subTask_InfoTable WHERE flags&0x80=0x80)

						DELETE #subTask_InfoTable

						INSERT INTO #subTask_InfoTable
						SELECT S.subTaskId, S.flags, O.id, O.value
						FROM TM_SubTask S
						JOIN TM_JobOptions O ON O.subTaskId = S.subTaskId AND S.flags&0x2080 <> 0 AND O.optionId = 239177580 AND O.modified = 0

						UPDATE #subTask_InfoTable
						SET jobXML.modify('replace value of (/clientAndClientGroups[1]/@clientGroupId)[1] with sql:variable("@scgId")')
						WHERE jobXML.value('/clientAndClientGroups[1]/@clientGroupId', 'INT') = 0

						UPDATE TM_JobOptions
						SET value = CAST(T.jobXML AS NVARCHAR(MAX))
						FROM
						(
							SELECT id, jobXML
							FROM #subTask_InfoTable
						) T
						WHERE T.id = TM_JobOptions.id

            			UPDATE TM_JobXMLOptions SET xmlValue = @xmlLaptops WHERE jobId = 0 AND subTaskId IN (SELECT subTaskId FROM #subTask_InfoTable WHERE flags&0x2000=0x2000)

            			UPDATE TM_JobXMLOptions SET xmlValue = @xmlClients WHERE jobId = 0 AND subTaskId IN (SELECT subTaskId FROM #subTask_InfoTable WHERE flags&0x80=0x80)

						IF object_id('tempdb.dbo.#subTask_InfoTable') is not null 
							DROP TABLE #subTask_InfoTable
		END
	END

END_OF_PROC:

IF (@errorCode = 0)
BEGIN
	COMMIT TRANSACTION
END
ELSE
BEGIN
	ROLLBACK TRANSACTION
END


