
DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
DECLARE @isJson INT = 1
IF EXISTS (SELECT 1 FROM GxGlobalParam with(nolock) WHERE name = 'bEnableJsonConsoleAlert' AND value = 'false' AND modified = 0)
	SET @isJson = 0
DECLARE @isVSAOEM int = 0
-- Do this only for OEM 106 - Virtual Server 
IF @oem = 106 
begin
	set @isVSAOEM = 1
end

declare  @errorCode integer         
declare  @errorString varchar(1024)   

set @errorCode = 0
set @errorString  = ''
-- First check the CS release. This SP has to be executed only for freshly installed CS and not for upgraded CS
-- this sql runs only on fresh installs, we dont need a check for it

DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())

DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /></CVGui_CommCellTreeNode>'
DECLARE @allClientXmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="2" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allStoragePolicyXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="16" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allMAsXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="10" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'
DECLARE @allLibrariesXmlEntities AS nvarchar(MAX)= '<CVGui_CommCellTreeNode xmlns:xsi="http:--www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="CVGui_CommCellTreeNodeType.xsd"><trackingSchedules /><trackingJobs /><associations _type_="8" clientGroupId="0" clientGroupName="" clientId="0" clientName="" applicationId="0" appName="" instanceId="0" instanceName="" backupsetId="0" backupsetName="" subclientId="0" subclientName="" mediaAgentId="0" mediaAgentName="" schedulePolicyId="0" schedulePolicyName="" libraryId="0" libraryName="" storagePolicyId="0" storagePolicyName="" copyId="0" copyName="" trackingPolicyId="0" trackingPolicyName="" workflowId="0" workflowName="" policyId="0" policyName="" criteriaId="0" criteriaName="" /></CVGui_CommCellTreeNode>'

DECLARE @adminID			as integer		= ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
DECLARE @masterGroupId		as integer  = ISNULL((Select top 1 ID from UMGroups where name='master'),1)	--_US_ADMIN_GROUP__
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @localeId			AS integer		= 1
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE @persistTimeSeconds AS integer		= 0
DECLARE @SelCriteriaId		integer
DECLARE @createdAlertsId	INT = 1
DECLARE @thisCriteria		int
DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
--
---
----  FOR CURSOR -----
DECLARE @alertId			INTEGER
DECLARE @alertType			INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @isAlertEnabled		bit
DECLARE @cursorXmlEntities  nvarchar(MAX)
--
--
DECLARE @alertsToAdd table (
		alertId				int primary key,
		alertType			int Not Null,
		notificationName	nvarchar(128),
		description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max),
		isAlertEnabled		bit,
		xmlEntities			nvarchar(MAX)
)
DECLARE @criteriasToAdd table (
		alertId				int ,
		criteriaId			int ,
		criteriaParamType	int,
		criteriaParamValue	int,
		criteriaParamUnit	int
		primary key(alertId,criteriaId)
)
----------------------
DECLARE	@thisAlertId		integer
SET @errorCode	= 0
SET @errorString= ''
BEGIN TRY
	BEGIN TRAN
		-- CLEANUP FOR TESTING PURPOSES ONLY!
	--UPDATE NTNotificationRule SET status=2, revision = 0 where status = @status			-- Logically Delete old Alerts
	DECLARE @htmldefaultTemplateForAuxCopyFallenBehindAlert nvarchar(max)
	DECLARE @textdefaultTemplateForAuxCopyFallenBehindAlert nvarchar(max)
	set @htmldefaultTemplateForAuxCopyFallenBehindAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Size of Data to be Copied: &lt;SIZE OF DATA TOBE COPIED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number of Media to be Copied: &lt;MEDIA TOBE COPIED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number of Jobs to be Copied: &lt;JOBS TOBE COPIED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Oldest Job End Date: &lt;OLDEST JOB ENDDATE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media that got copied: &lt;COPIED MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copied data size: &lt;COPIED DATA SIZE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForAuxCopyFallenBehindAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_  Size of Data to be Copied: <SIZE OF DATA TOBE COPIED> MsgNewLine_MsgTab_ Number of Media to be Copied: <MEDIA TOBE COPIED COUNT> MsgNewLine_MsgTab_ Number of Jobs to be Copied: <JOBS TOBE COPIED> MsgNewLine_MsgTab_ Oldest Job End Date: <OLDEST JOB ENDDATE> MsgNewLine_MsgTab_  Media that got copied: <COPIED MEDIA LIST> MsgNewLine_MsgTab_ Copied data size: <COPIED DATA SIZE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			2,
			'Aux copy fallen behind',
			'Default alert for aux Copy fallen behind ',
			@textdefaultTemplateForAuxCopyFallenBehindAlert,
			@htmldefaultTemplateForAuxCopyFallenBehindAlert,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,56,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForAuxCopyAlert nvarchar(max)
	DECLARE @textdefaultTemplateForAuxCopyAlert nvarchar(max)
	set @htmldefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media that got copied: &lt;COPIED MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copied data size: &lt;COPIED DATA SIZE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForAuxCopyAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Media that got copied: <COPIED MEDIA LIST> MsgNewLine_MsgTab_ Copied data size: <COPIED DATA SIZE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			2,
			'Aux copy job delayed',
			'Default alert for aux Copy job delayed',
			@textdefaultTemplateForAuxCopyAlert,
			@htmldefaultTemplateForAuxCopyAlert	,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,5,2,4,5
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			2,
			'Aux copy job failed',
			'Default alert for aux Copy job failed',
			@textdefaultTemplateForAuxCopyAlert,
			@htmldefaultTemplateForAuxCopyAlert	,
			0,
			@allStoragePolicyXmlEntities
	)
		Insert into @criteriasToAdd
		select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForClientAlert nvarchar(max)
	DECLARE @textdefaultTemplateForClientAlert nvarchar(max)
	set @htmldefaultTemplateForClientAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Property Modifications: </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Agent Type: &lt;AGENT TYPE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Instance: &lt;INSTANCE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Set: &lt;BACKUPSET NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Subclient: &lt;SUBCLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Low: &lt;DISK SPACE LOW Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left: &lt;DISK SPACE INFO&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Available: &lt;FREE SPACE&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForClientAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Property Modifications: MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_ ============================================================================================================== MsgNewLine_MsgTab_ Disk Space Low: <DISK SPACE LOW Y/N> MsgNewLine_MsgTab_ Media/Space left: <DISK SPACE INFO> MsgNewLine_MsgTab_ Disk Space Available: <FREE SPACE> MsgNewLine_MsgTab_ =============================================================================================================='
	Insert @alertsToAdd values(
			@createdAlertsId,
			10,
			'Low disk space on client',
			'Default alert for client disk space low',
			@textdefaultTemplateForClientAlert,
			@htmldefaultTemplateForClientAlert	,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,18,NULL,NULL,NULL -- disk space low
	union
	select @createdAlertsId,77,NULL,NULL,NULL -- job results directory disk space low
	union
	select @createdAlertsId,79,NULL,NULL,NULL -- Galaxy directory disk space low
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataAgingAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataAgingAlert nvarchar(max)
	set @htmldefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Media Barcode List: &lt;PRUNED MEDIA BARCODE LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Pruned Jobs Count: &lt;PRUNED JOBS COUNT&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDataAgingAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Pruned Media Barcode List: <PRUNED MEDIA BARCODE LIST> MsgNewLine_MsgTab_ Pruned Jobs Count: <PRUNED JOBS COUNT> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			1,
			'Data aging job failed',
			'Default alert for data aging job failure',
			@textdefaultTemplateForDataAgingAlert,
			@htmldefaultTemplateForDataAgingAlert	,
			0,
			@XmlEntities
		)
		Insert into @criteriasToAdd
		select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataProtAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataProtAlert nvarchar(max)
	set @htmldefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Client: &lt;CLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Agent Type: &lt;AGENT TYPE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Instance: &lt;INSTANCE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Set: &lt;BACKUPSET NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Subclient: &lt;SUBCLIENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Backup Level: &lt;LEVEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policies Used: &lt;STORAGE POLICIES USED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Protected Counts: &lt;PROTECTED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failed Counts: &lt;FAILED COUNT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Current Backup Size: &lt;CURRENT BACKUP SIZE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Previous Job ID: &lt;PREVIOUS JOBID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Previous Backup Size: &lt;PREVIOUS BACKUP SIZE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Percentage Change: &lt;PERCENTAGE CHANGE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Backup Level: <LEVEL> MsgNewLine_MsgTab_ Storage Policies Used: <STORAGE POLICIES USED> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Protected Counts: <PROTECTED COUNT> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_  Current Backup Size: <CURRENT BACKUP SIZE> MsgNewLine_MsgTab_ Previous Job ID: <PREVIOUS JOBID> MsgNewLine_MsgTab_ Previous Backup Size: <PREVIOUS BACKUP SIZE> MsgNewLine_MsgTab_ Percentage Change: <PERCENTAGE CHANGE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'Decrease in data size',
			'Default Decrease in data size alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,53,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'Increase in data size',
			'Default Increase in data size Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,52,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			3,
			'Backup job failed',
			'Default backup job failed Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			0,
			@allClientXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDDBReconAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDDBReconAlert nvarchar(max)
	set @htmldefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Storage Policy Name: &lt;SP NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Copy Name: &lt;COPY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDDBReconAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Storage Policy Name: <SP NAME> MsgNewLine_MsgTab_ Copy Name: <COPY NAME> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			55,
			'Dedup DB reconstruction job failed',
			'Default Dedup DB reconstruction Job failed alert',
			@textdefaultTemplateForDDBReconAlert,
			@htmldefaultTemplateForDDBReconAlert,
			0,
			@allStoragePolicyXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDeviceOfflineAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDeviceOfflineAlert nvarchar(max)
	set @htmldefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Library Name: &lt;LIBRARY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Mount Path: &lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drivepool: &lt;DRIVEPOOL NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drive: &lt;DRIVE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Offline Since: &lt;OFFLINE SINCE&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDeviceOfflineAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Library Name: <LIBRARY NAME> MsgNewLine_MsgTab_ Mount Path: <SPAREPOOL/MOUNTPATH NAME> MsgNewLine_MsgTab_ Drivepool: <DRIVEPOOL NAME> MsgNewLine_MsgTab_ Drive: <DRIVE NAME> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_  Offline Since:  <OFFLINE SINCE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			21,
			'Device went offline',
			'Default Device went offline alert',
			@textdefaultTemplateForDeviceOfflineAlert,
			@htmldefaultTemplateForDeviceOfflineAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,29,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	-- Mount path went offline is created for VSA oem only. 
	if @isVSAOEM=1
	begin
		Insert @alertsToAdd values(
            @createdAlertsId,
            21,
            'Mount path went offline',
            'Default Mount path went offline alert',
            @textdefaultTemplateForDeviceOfflineAlert,
            @htmldefaultTemplateForDeviceOfflineAlert,
            0,
            @allLibrariesXmlEntities
		)
		Insert into @criteriasToAdd
		select @createdAlertsId,31,NULL,NULL,NULL
    
		set @createdAlertsId = @createdAlertsId + 1
	end

	DECLARE @htmldefaultTemplateForDRAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDRAlert nvarchar(max)
	set @htmldefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Job ID: &lt;JOB ID&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Level: &lt;LEVEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Start Time: &lt;START TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Scheduled Time: &lt;SCHEDULE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">End Time: &lt;END TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Error Code: &lt;ERR CODE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForDRAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Level: <LEVEL> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			5,
			'Disaster recovery job failed',
			'Default DR Backup Job Failure Alert',
			@textdefaultTemplateForDRAlert,
			@htmldefaultTemplateForDRAlert,
			0,
			@XmlEntities
	)
		Insert into @criteriasToAdd
		select @createdAlertsId,3,NULL,NULL,NULL
	
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForLibManAlert nvarchar(max)
	DECLARE @textdefaultTemplateForLibManAlert nvarchar(max)
	set @htmldefaultTemplateForLibManAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Status: &lt;STATUS&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Library Name: &lt;LIBRARY NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">SparePool/Mount Path: &lt;SPAREPOOL/MOUNTPATH NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drivepool: &lt;DRIVEPOOL NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Drive: &lt;DRIVE NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">MediaAgent Name: &lt;MEDIAAGENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media label: &lt;MEDIA LABEL&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left (excluding reserve space): &lt;MEDIA SPACE LEFT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Failure Reason: &lt;FAILURE REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Other library: &lt;OTHER LIBRARY&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Reason: &lt;RECALL REASON&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Expiration Time: &lt;RECALL EXPIRE TIME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Recall Destination: &lt;RECALL DESTINATION&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media List: &lt;MEDIA LIST&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForLibManAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Library Name: <LIBRARY NAME> MsgNewLine_MsgTab_ SparePool/Mount Path: <SPAREPOOL/MOUNTPATH NAME> MsgNewLine_MsgTab_ Drivepool: <DRIVEPOOL NAME> MsgNewLine_MsgTab_ Drive: <DRIVE NAME> MsgNewLine_MsgTab_ MediaAgent Name: <MEDIAAGENT NAME> MsgNewLine_MsgTab_ Media label: <MEDIA LABEL> MsgNewLine_MsgTab_ Media/Space left (excluding reserve space): <MEDIA SPACE LEFT> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Other library: <OTHER LIBRARY> MsgNewLine_MsgTab_ Recall Reason: <RECALL REASON> MsgNewLine_MsgTab_ Recall Expiration Time: <RECALL EXPIRE TIME> MsgNewLine_MsgTab_ Recall Destination: <RECALL DESTINATION> MsgNewLine_MsgTab_ Media List: <MEDIA LIST> MsgNewLine_MsgTab_  Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			17,
			'Insufficient storage on library',
			'Default Insufficient Storage on library alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,22,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			17,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Library maintenance required',
			'Default Library Maintenance Required alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,26,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			17,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Media mount and usage error',
			'Default Media mount and usage error alert',
			@textdefaultTemplateForLibManAlert,
			@htmldefaultTemplateForLibManAlert,
			0,
			@allLibrariesXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,25,NULL,NULL,NULL
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @textdefaultTemplateForMAAlert nvarchar(max)
	DECLARE @htmldefaultTemplateForMAAlert nvarchar(max)
	set @htmldefaultTemplateForMAAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">MediaAgent Name: &lt;MEDIAAGENT NAME&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Media/Space left (excluding reserve space): &lt;DISK SPACE INFO&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Low: &lt;DISK SPACE LOW Y/N&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Disk Space Available: &lt;FREE SPACE&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Condition Cleared: &lt;CONDITION CLEARED Y/N&gt; </font> </li> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForMAAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ MediaAgent Name: <MEDIAAGENT NAME> MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_ Media/Space left (excluding reserve space): <DISK SPACE INFO> MsgNewLine_MsgTab_ Disk Space Low: <DISK SPACE LOW Y/N> MsgNewLine_MsgTab_ Disk Space Available: <FREE SPACE> MsgNewLine_MsgTab_ Condition Cleared: <CONDITION CLEARED Y/N> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			13,					-- 'NT_ALERTTYPE_DATA_RECOV'
			'Disk space low on media agent',
			'Default MA Disk space low alert',
			@textdefaultTemplateForMAAlert,
			@htmldefaultTemplateForMAAlert,
			0,
			@allMAsXmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,18,NULL,NULL,NULL -- disk space low
	union
	select @createdAlertsId,78,NULL,NULL,NULL -- index cache directory disk space low
	union
	select @createdAlertsId,79,NULL,NULL,NULL -- Galaxy directory disk space low
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @textdefaultTemplateForLicenseAlert nvarchar(max)
	DECLARE @htmldefaultTemplateForLicenseAlert nvarchar(max)
	set @htmldefaultTemplateForLicenseAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table width="600" border="1" style="border-left-style: solid; border-right-color: #dedede; border-bottom-color: #dedede; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-top-width: 0px; border-bottom-width: 0px; border-left-color: #dedede; border-top-style: solid; border-top-color: #dedede; border-right-style: solid" cellpadding="0" align="center" cellspacing="0"> <tr> <td> <center> <table width="600" id="contentTbl" border="0" cellpadding="0" align="center" cellspacing="0"> <tr style="background-color: #666666"> <td align="left" valign="middle"> <div style="margin-bottom: 4px; margin-left: 10px; margin-top: 4px"> <font color="#EEEEEE" face="Helvetica,sans-serif" size="6">&lt;ALERT NAME&gt; </font> </div> </td> </tr> <tr> <td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>CommCell: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;COMMCELL NAME&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Type: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Criteria: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;DETECTED CRITERIA&gt;</font></strong> </ul> <ul style="margin-bottom: 4px; margin-top: 4px"> <font face="Helvetica,sans-serif" size="4"><strong>Detected Time: </strong></font><strong><font color="#660000" face="Helvetica,sans-serif" size="4">&lt;TIME&gt;</font></strong> </ul> </td> </tr> <tr> <td width="100%" colspan="1" align="left"> <ul> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">User: &lt;USER NAME&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Comments: &lt;COMMENT&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">License Expired: &lt;LICENSE EXPIRED&gt; </font> </li> <li style="margin-bottom: 4px; margin-top: 4px"> <font color="#000000" face="Helvetica,sans-serif" size="3">Number Of Days Left For License Expiration: &lt;NO. OF DAYS LEFT FOR LICENSE EXPIRY&gt; </font> </li> <font color="#000000" face="Helvetica,sans-serif" size="3">MsgHrzSep </font> </ul> </td> </tr> <tr style="background-color: #666666"> <td colspan="1" align="left">  </td> </tr> </table> </center> </td> </tr> </table>'
	set @textdefaultTemplateForLicenseAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ ============================================================================================================== MsgNewLine_MsgTab_ Comments: <COMMENT> MsgNewLine_MsgTab_  License Expired: <LICENSE EXPIRED> MsgNewLine_MsgTab_ Number Of Days Left For License Expiration: <NO. OF DAYS LEFT FOR LICENSE EXPIRY> MsgNewLine_MsgTab_  ============================================================================================================== MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
			60,
			'License consumed exceeds 80%',
			'Default License Consumption Alert',
			@textdefaultTemplateForLicenseAlert,
			@htmldefaultTemplateForLicenseAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,60,1,80,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
			60,
			'License expires within 7 days',
			'Default License Expiration alert',
			@textdefaultTemplateForLicenseAlert,
			@htmldefaultTemplateForLicenseAlert,
			0,
			@XmlEntities
	)
	Insert into @criteriasToAdd
	select @createdAlertsId,58,7,7,15
	set @createdAlertsId = @createdAlertsId + 1
	
	DECLARE @htmldefaultTemplate nvarchar(max) = ''
    DECLARE @textdefaultTemplate nvarchar(max) = ''

	if @isVSAOEM=1
	begin

		set @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table align="center" cellpadding="0" width="600" cellspacing="0" style="border-top-style: solid; border-bottom-width: 0px; border-left-width: 0px; border-right-width: 0px; border-bottom-style: solid; border-right-color: #dedede; border-left-style: solid; border-top-width: 0px; border-left-color: #dedede; border-top-color: #dedede; border-right-style: solid; border-bottom-color: #dedede" border="1">  <tr>  <td>  <center>  <table id="contentTbl" align="center" cellpadding="0" cellspacing="0" width="600" border="0">  <tr style="background-color: #666666">  <td align="left" valign="middle">  <div style="margin-left: 10px; margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="6" color="#EEEEEE">&lt;ALERT NAME&gt; </font>  </div>  </td>  </tr>  <tr>  <td align="left" width="100%" colspan="1">  <ul>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">User: &lt;USER NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Job ID: &lt;JOB ID&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Server: &lt;CLIENT NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Collection: &lt;SUBCLIENT NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Backup Level: &lt;LEVEL&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Start Time: &lt;START TIME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">End Time: &lt;END TIME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Name: &lt;VIRTUAL MACHINE NAME&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Host Name: &lt;VIRTUAL MACHINE HOST NAME&gt;</font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Failure reason for Virtual Machine Backup: &lt;VM FAILURE REASON&gt; </font>  </li>  <li style="margin-top: 4px; margin-bottom: 4px">  <font face="Helvetica,sans-serif" size="3" color="#000000">Virtual Machine Backup Status: &lt;VM STATUS&gt; </font>  </li>  </ul>  </td>  </tr>  <tr style="background-color: #666666">  <td align="left" colspan="1">&nbsp; </td></tr>  </table>  </center>  </td>  </tr>  </table>'
		set @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Backup Level: <LEVEL> MsgNewLine_MsgTab_ Storage Policies Used: <STORAGE POLICIES USED> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Protected Counts: <PROTECTED COUNT> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_ Virtual Machine Name: <VIRTUAL MACHINE NAME> MsgNewLine_MsgTab_ Virtual Machine Backup Status:  <VM STATUS> MsgNewLine_MsgTab_ Failure reason for Virtual Machine Backup:  <VM FAILURE REASON> MsgNewLine_MsgTab_ Virtual Machine Host Name: <VIRTUAL MACHINE HOST NAME> MsgNewLine_MsgTab_'
		Insert @alertsToAdd values(
				@createdAlertsId,
				3,
				'VM Backup failed',
				'Default alert when VM backup fails',
				@textdefaultTemplate,
				@htmldefaultTemplate,
				0,
				@allClientXmlEntities
		)
    
		Insert into @criteriasToAdd
		select @createdAlertsId,3,NULL,NULL,NULL
		set @createdAlertsId = @createdAlertsId + 1
    
		Insert @alertsToAdd values(
				@createdAlertsId,
				3,
				'VM Backup succeeded',
				'Default alert when VM backup succeeds',
				@textdefaultTemplate,
				@htmldefaultTemplate,
				0,
				@allClientXmlEntities
		)
    
		Insert into @criteriasToAdd
		select @createdAlertsId,1,NULL,NULL,NULL
		set @createdAlertsId = @createdAlertsId + 1
    
		Insert @alertsToAdd values(
				@createdAlertsId,
				3,
				'VM Backup succeeded with errors',
				'Default alert when VM backup succeeds',
				@textdefaultTemplate,
				@htmldefaultTemplate,
				0,
				@allClientXmlEntities
		)
    
		Insert into @criteriasToAdd
		select @createdAlertsId,57,NULL,NULL,NULL
	end
	
	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursorVWeb') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursorVWeb') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursorVWeb
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursorVWeb') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursorVWeb') = -1 )
		DEALLOCATE newDefaultAlertsCursorVWeb
	DECLARE newDefaultAlertsCursorVWeb CURSOR FOR
		SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , isAlertEnabled, XmlEntities
		   FROM @alertsToAdd
	OPEN newDefaultAlertsCursorVWeb
		FETCH NEXT FROM newDefaultAlertsCursorVWeb INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
		WHILE @@FETCH_STATUS = 0
		BEGIN
		-- Check whether this alert is already present. If so, dont insert again.
		if exists(select 1 from NTNotificationRule
			where notificationName=@notificationName and revision=1
		)
		begin
			FETCH NEXT FROM newDefaultAlertsCursorVWeb INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
			continue
		end
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
		select						categoryId,				@alertType,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@adminID,
									0,						(1 | 2048),
								        -- 1 DefaultLocale US-English .. Create  default alerts in disabled state
									-- 2048 for for specifying the alert is systam generated.
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@cursorXmlEntities ,
									2,				newid()
				from NTAlerttype where id = @alertType
		SET @thisAlertId = @@Identity
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
		select criteriaId,1,@thisAlertId,0,0,0
		from @criteriasToAdd
		where alertId = @alertId
		SET @SelCriteriaId = @@identity
		if exists(select 1 from @criteriasToAdd where alertId = @alertId and criteriaParamType is not null and
			criteriaParamValue is not null and criteriaParamUnit is not null)
		begin
			INSERT NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)
			select id,0,criteriaParamType,criteriaParamValue,criteriaParamUnit,0
			from NTSelcriteria , @criteriasToAdd newCriterias
			where NTSelcriteria.ruleid = @thisAlertId
			and newCriterias.alertId = @alertId
			and newCriterias.criteriaParamType is not null and
			newCriterias.criteriaParamValue is not null and newCriterias.criteriaParamUnit is not null
		end
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
									 --
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
               			 0, 0, 0, 0, 2,
						 '', '', '', '', 1, @msgFmtHtml)
		Insert into NTnotificationGroups(NTNotificationId,groupId,escalationLevel)
		select @thisAlertId,@masterGroupId,1
		FETCH NEXT FROM newDefaultAlertsCursorVWeb INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
	END
	
	Update NTNotificationrule
    set status = status|1024
    where notificationname in ('VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors')
    and revision>0

	-- For VM specific alerts, we should set agent type filter also.
	Insert into NTnotificationProp(componentNameId, attrName,attrtype,attrval, created,modified)
	select id,'App Type Filter',7,106,@nowTime,0
	from NTNotificationrule
	where notificationname in ('VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors')
    and revision>0
	and id not in
	(
		select componentNameId from NTnotificationProp
		where attrName='App Type Filter'
		and attrval='106'
		and modified=0
	)
    
    -- Enable all these alerts created above for VWeb. 
    Update NTNotificationrule
    set status = status-1
    where notificationname in ('Aux copy fallen behind','Aux copy job delayed','Aux copy job Failed','Low disk space on client','Data aging job failed',
    'Decrease in data size','Increase in data size','Backup job failed','Dedup DB reconstruction job failed','Device went offline',
    'Mount path went offline','Disaster recovery job failed','Insufficient storage on library','Library maintenance required',
    'Media mount and usage error','Disk space low on media agent','License consumed exceeds 80%','License expires within 7 days',
     'VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors',
     'No backup for last 7 days','No recent DDB backup','Updates available for download')    
    and revision>0
    and (status&1)>0
    
    -- Enable console alert notification also for these alerts 
    Update NTNotificationrule
    set notifType = notifType | 8192
    where notificationname in ('Aux copy fallen behind','Aux copy job delayed','Aux copy job Failed','Low disk space on client','Data aging job failed',
    'Decrease in data size','Increase in data size','Backup job failed','Dedup DB reconstruction job failed','Device went offline',
    'Mount path went offline','Disaster recovery job failed','Insufficient storage on library','Library maintenance required',
    'Media mount and usage error','Disk space low on media agent','License consumed exceeds 80%','License expires within 7 days',
     'VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors',
     'No backup for last 7 days','No recent DDB backup','Updates available for download')
    and revision>0    
	IF @isJson = 1
	BEGIN
		DECLARE @consoleAlerts TABLE(alertId INT, alertName VARCHAR(256), jsonFormat NVARCHAR(MAX))
		INSERT INTO @consoleAlerts
		SELECT id , notificationName ,'' FROM NTNotificationRule WHERE notificationName in ('Aux copy fallen behind','Aux copy job delayed',
			'Aux copy job Failed','Low disk space on client','Data aging job failed',
			'Decrease in data size','Increase in data size','Backup job failed','Dedup DB reconstruction job failed','Device went offline',
			'Mount path went offline','Disaster recovery job failed','Insufficient storage on library','Library maintenance required',
			'Media mount and usage error','Disk space low on media agent','License consumed exceeds 80%','License expires within 7 days',
			'VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors',
			'No backup for last 7 days','No recent DDB backup','Updates available for download') and revision>0

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Storage Policy Name":"<SP NAME>","Copy Name":"<COPY NAME>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>","Size of Data to be Copied":"<SIZE OF DATA TOBE COPIED>","Number of Jobs to be Copied":"<JOBS TOBE COPIED>","Oldest Job End Date":"<OLDEST JOB ENDDATE>","Estimated Time Needed For Copying":"<COPY HOURS>","Alert Reason":"<ALERT REASON>","Warning":"<WARNING>","Condition Cleared":"<CONDITION CLEARED Y/N>","Comments":"<COMMENT>","Media that got copied":"<COPIED MEDIA LIST>","Copied data size":"<COPIED DATA SIZE>"}'
		WHERE alertName in ('Aux copy fallen behind','Aux copy job delayed','Aux copy job Failed')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Status":"<STATUS>","Client":"<CLIENT DISPLAY NAME>","Agent Type":"<AGENT TYPE NAME>","Instance":"<INSTANCE NAME>","Backup Set":"<BACKUPSET NAME>","Subclient":"<SUBCLIENT NAME>","Comments":"<COMMENT>","Disk Space Low":"<DISK SPACE LOW Y/N>","Condition Cleared":"<CONDITION CLEARED Y/N>","Media/Space left":"<DISK SPACE INFO>","Disk Space Available":"<FREE SPACE>"}'
		WHERE alertName in ('Low disk space on client')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>","Pruned Media Barcode List":"<PRUNED MEDIA BARCODE LIST>","Pruned Jobs Count":"<PRUNED JOBS COUNT>"}'
		WHERE alertName in ('Data aging job failed')	
	
		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Client":"<CLIENT DISPLAY NAME>","Agent Type":"<AGENT TYPE NAME>","Instance":"<INSTANCE NAME>","Backup Set":"<BACKUPSET NAME>","Subclient":"<SUBCLIENT NAME>","Backup Level":"<LEVEL>","Storage Policies Used":"<STORAGE POLICIES USED>","Virtual Machine Name":"<VIRTUAL MACHINE NAME>","Virtual Machine Host Name":"<VIRTUAL MACHINE HOST NAME>","Virtual Machine Backup Status":"<VM STATUS>","Failure reason for Virtual Machine Backup":"<VM FAILURE REASON>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>","Protected Counts":"<PROTECTED COUNT>","Failed Counts":"<FAILED COUNT>","Previous Job ID":"<PREVIOUS JOBID>","Current Backup Size":"<CURRENT BACKUP SIZE>","Previous Backup Size":"<PREVIOUS BACKUP SIZE>","Percentage Change":"<PERCENTAGE CHANGE>","Additional Information ":"<ADDITIONAL VM INFO>"}'
		WHERE alertName in ('Decrease in data size','Increase in data size')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Storage Policy Name":"<SP NAME>","Copy Name":"<COPY NAME>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>"}'
		WHERE alertName in ('Dedup DB reconstruction job failed')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Status":"<STATUS>","Library Name":"<LIBRARY NAME>","Mount Path":"<SPAREPOOL/MOUNTPATH NAME>","Drivepool":"<DRIVEPOOL NAME>","Drive":"<DRIVE NAME>","Failure Reason":"<FAILURE REASON>","Condition Cleared":"<CONDITION CLEARED Y/N>","Offline Since":"<OFFLINE SINCE>"}'
		WHERE alertName in ('Device went offline','Mount path went offline')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Level":"<LEVEL>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>"}'
		WHERE alertName in ('Disaster recovery job failed')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Status":"<STATUS>","Library Name":"<LIBRARY NAME>","SparePool/Mount Path":"<SPAREPOOL/MOUNTPATH NAME>","Drivepool":"<DRIVEPOOL NAME>","Drive":"<DRIVE NAME>","MediaAgent Name":"<MEDIAAGENT NAME>","Media label":"<MEDIA LABEL>","Media/Space left (excluding reserve space)":"<MEDIA SPACE LEFT>","Failure Reason":"<FAILURE REASON>","Other library":"<OTHER LIBRARY>","Recall Reason":"<RECALL REASON>","Recall Expiration Time":"<RECALL EXPIRE TIME>","Recall Destination":"<RECALL DESTINATION>","Media List":"<MEDIA LIST>","Condition Cleared":"<CONDITION CLEARED Y/N>"}'
		WHERE alertName in ('Insufficient storage on library','Library maintenance required','Media mount and usage error')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","MediaAgent Name":"<MEDIAAGENT NAME>","Comments":"<COMMENT>","Status":"<STATUS>","Media/Space left (excluding reserve space)":"<DISK SPACE INFO>","Disk Space Low":"<DISK SPACE LOW Y/N>","Disk Space Available":"<FREE SPACE>","Condition Cleared":"<CONDITION CLEARED Y/N>"}'
		WHERE alertName in ('Disk space low on media agent')
	
		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Comments":"<COMMENT>","License Expired":"<LICENSE EXPIRED>","Number Of Days Left For License Expiration":"<NO. OF DAYS LEFT FOR LICENSE EXPIRY>"}'
		WHERE alertName in ('License consumed exceeds 80%','License expires within 7 days')
	
		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Client":"<CLIENT DISPLAY NAME>","Agent Type":"<AGENT TYPE NAME>","Instance":"<INSTANCE NAME>","Backup Set":"<BACKUPSET NAME>","Subclient":"<SUBCLIENT NAME>","Backup Level":"<LEVEL>","Storage Policies Used":"<STORAGE POLICIES USED>","Virtual Machine Name":"<VIRTUAL MACHINE NAME>","Virtual Machine Host Name":"<VIRTUAL MACHINE HOST NAME>","Virtual Machine Backup Status":"<VM STATUS>","Failure reason for Virtual Machine Backup":"<VM FAILURE REASON>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>","Protected Counts":"<PROTECTED COUNT>","Failed Counts":"<FAILED COUNT>","Additional Information ":"<ADDITIONAL VM INFO>"}'
		WHERE alertName in ('VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors','Backup job failed')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Job ID":"<JOB ID>","Status":"<STATUS>","Client":"<CLIENT DISPLAY NAME>","Agent Type":"<AGENT TYPE NAME>","Instance":"<INSTANCE NAME>","Backup Set":"<BACKUPSET NAME>","Subclient":"<SUBCLIENT NAME>","Backup Level":"<LEVEL>","Storage Policies Used":"<STORAGE POLICIES USED>","Virtual Machine Name":"<VIRTUAL MACHINE NAME>","Virtual Machine Host Name":"<VIRTUAL MACHINE HOST NAME>","Virtual Machine Backup Status":"<VM STATUS>","Failure reason for Virtual Machine Backup":"<VM FAILURE REASON>","Start Time":"<START TIME>","Scheduled Time":"<SCHEDULE TIME>","End Time":"<END TIME>","Error Code":"<ERR CODE>","Failure Reason":"<FAILURE REASON>","Protected Counts":"<PROTECTED COUNT>","Failed Counts":"<FAILED COUNT>","Not backed up since":"<NO SUCCESSFUL JOB SINCE>","Date of last recorded backup":"<DATE OF LAST SUCCESSFUL JOB>","Time of last recorded backup":"<TIME OF LAST SUCCESSFUL JOB>","Additional Information ":"<ADDITIONAL VM INFO>"}'
		WHERE alertName in ('No backup for last 7 days')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Event ID":"<EVENT ID>","Monitoring Criteria":"<MONITORING CRITERIA STRING>","Severity":"<EVENT SEVERITY>","Job ID":"<JOB ID>","Event Date":"<EVENT DATE>","Program":"<EVENT PROGRAM>","Client":"<CLIENT DISPLAY NAME>","Description":"<DESCRIPTION>"}'
		WHERE alertName in ('No recent DDB backup')

		UPDATE @consoleAlerts SET jsonFormat = '{"Alert":"<ALERT NAME>","Type":"<ALERT CATEGORY - ALERT TYPE>","Detected Criteria":"<DETECTED CRITERIA>","Is escalated":"<IS ESCALATED?>","Detected Time":"<TIME>","CommCell":"<COMMCELL NAME>","User":"<USER NAME>","Contents":"<CONTENTS>"}'
		WHERE alertName in ('Updates available for download')
		--new json template
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
								SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
								baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
		SELECT NTNotificationId, 8192, 1, formatString, N'',
               				 0, 0, 0, 0, 2,
							 '', '', '', '', 1, jsonFormat
		FROM NTMessageFormat INNER JOIN @consoleAlerts ON NTmessageFormat.NTNotificationId = alertId
		WHERE messageType=1
		and escalationLevel=1
		and NTnotificationID not in
		(
			SELECT NTnotificationID FROM NTmessageFormat
			WHERE messageType=8192
		)
	END
	ELSE
	BEGIN 
	    INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
		SELECT NTNotificationId, 8192, 1, formatString, N'',
               				 0, 0, 0, 0, 2,
							 '', '', '', '', 1, formatStringHtml
		FROM NTMessageFormat
		WHERE messageType=1
		and escalationLevel=1
		and NTNotificationId in 
		(
			SELECT id FROM NTnotificationRule
			WHERE notificationname in ('Aux copy fallen behind','Aux copy job delayed','Aux copy job Failed','Low disk space on client','Data aging job failed',
			'Decrease in data size','Increase in data size','Backup job failed','Dedup DB reconstruction job failed','Device went offline',
			'Mount path went offline','Disaster recovery job failed','Insufficient storage on library','Library maintenance required',
			'Media mount and usage error','Disk space low on media agent','License consumed exceeds 80%','License expires within 7 days',
			'VM Backup succeeded','VM Backup failed','VM Backup succeeded with errors',
			'No backup for last 7 days','No recent DDB backup','Updates available for download')
			and revision>0    
		)
		and NTnotificationID not in
		(
			SELECT NTnotificationID FROM NTmessageFormat
			WHERE messageType=8192
		)
	END
END TRY
 BEGIN CATCH
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()     
 END CATCH
 	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursorVWeb') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursorVWeb') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursorVWeb
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursorVWeb') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursorVWeb') = -1 )
		DEALLOCATE newDefaultAlertsCursorVWeb

IF @errorCode = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
	
