REM @ECHO OFF
REM Script to handle Updating the root directory in simPackage based on the Brand
REM This script should return 0 for success or non zero for failure.

REM Protect the environment variables from being altered/polluted because of this script being run.
SETLOCAL

ECHO ========================================
ECHO Post Install Script
ECHO %DATE% %TIME%
ECHO ========================================

SET RetCode=0

REM *********************************************
REM STEP 1 
REM Check for the OEM ID
REM *********************************************
SET ERRORLEVEL=0

REM SET BRANDPRODUCTNAME=NetApp
REM SET BRANDPRODUCTNAME=Simpana

IF "%BRANDPRODUCTNAME%"=="" GOTO AllDone

ECHO DECLARE @oldValue VARCHAR(256) > "%~dp0BrandPackageSelectionRoot.sql"
ECHO DECLARE @newValue VARCHAR(256) >> "%~dp0BrandPackageSelectionRoot.sql"

ECHO SET @oldValue = 'Simpana/' >> "%~dp0BrandPackageSelectionRoot.sql"
ECHO SET @newValue = '%BRANDPRODUCTNAME%/' >> "%~dp0BrandPackageSelectionRoot.sql"

ECHO UPDATE SimPackage >> "%~dp0BrandPackageSelectionRoot.sql"
ECHO SET hierarchy = Replace(hierarchy, @oldValue, @newValue) >> "%~dp0BrandPackageSelectionRoot.sql"
ECHO WHERE Hierarchy like (@oldValue + '%%') >> "%~dp0BrandPackageSelectionRoot.sql"

REM attrib -R "%~dp0PostInstall.lst"
REM echo BrandPackageSelectionRoot.sql >> "%~dp0PostInstall.lst"

:AllDone

ECHO Exiting with error code %RetCode%
ECHO ON
@EXIT /b %RetCode%

