SET QUOTED_IDENTIFIER ON


DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())

BEGIN TRY

		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name='skipInitialSetup' )
		BEGIN
			EXEC  AppInsertGlobalParam
						@isPIT = 0,
						@createdTime = @nowTime,
						@name = N'skipInitialSetup',
						@newValue = N'false'
		END

		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name='skipAutoSettingOwnerPermission' and modified = 0)
		BEGIN
			-- Insert a flag to skip setting permissions at company scg
			EXEC  AppInsertGlobalParam
						@isPIT = 0,
						@createdTime = @nowTime,
						@name = N'skipAutoSettingOwnerPermission',
						@newValue = N'1'

			-- Move owner permissions at company client group to commcell for all fresh installs to avoid any regression/backward compatibility issues.
			DECLARE @adminUserId INT = (SELECT TOP 1 id FROM UMUsers WITH(NOLOCK) WHERE flags & 0x40 <> 0)
			-- Get all permissions from Tenant admin role and set it at CC level owner permissions. 
			--#define UM_ROLE_TENANT_ADMIN    256     
			DECLARE @roleId INT = (SELECT id FROM UMROLES WITH(NOLOCK) where (flags &256 = 256))
			DECLARE @rolePropertiesXML XML = '<Security_GetRolesPropertiesRequest listPropertyLevel="20">
																   <roleEntity roleId="'+ CAST(@roleId AS VARCHAR(10)) +'" roleName="Tenant Admin"/>
																   <processinginstructioninfo>
																		 <user userId="'+ CAST(@adminUserId AS VARCHAR(10)) + '"/>                                                     
																   </processinginstructioninfo>
															</Security_GetRolesPropertiesRequest>'
			EXEC sec_getRoleDetailList @rolePropertiesXML OUTPUT
			-- The above call will give us all permissions associated with the role specified in the request. 
			-- Then we can substitute that categoryPermission from the response, into Commcell owner XML. 
			DECLARE @ccOwnerPermissionsXML XML = (
																   SELECT 
																   (
																		  SELECT                                                              
																		  (
																				-- 2 is Add
																				 SELECT  2 AS '@categoriesPermissionOperationType',
																					   @rolePropertiesXML.query('Security_GetRolesPropertiesResponse/roleProperties/categoryPermission/categoriesPermissionList')
																				 FOR XML PATH('categoryPermission'), TYPE
																		  )FOR XML PATH ('ownerAssociations'), TYPE
																   )FOR XML PATH ('App_SecurityAssociationForEntityList')
																   
													)
			-- Set owner permissions at entityType (1) id: (2) for  Commcell 
			EXEC sec_setSecurityAssociationsFromEntity @ccOwnerPermissionsXML, @adminUserId, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0

		END
     
END TRY
BEGIN CATCH

    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
SELECT @errorCode, @errorString
