SET QUOTED_IDENTIFIER ON


DECLARE @errorCode INT = 0
DECLARE @errorString NVARCHAR(MAX) = N'Success'

DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())

BEGIN TRY

		IF NOT EXISTS (SELECT TOP 1 * FROM GXGlobalParam WHERE name='skipInitialSetup' )
		BEGIN
			EXEC  AppInsertGlobalParam
						@isPIT = 0,
						@createdTime = @nowTime,
						@name = N'skipInitialSetup',
						@newValue = N'false'
			SET @errorCode = @@ERROR
			
			IF  @errorCode <> 0
			BEGIN
				SET @errorString = 'ERROR: Failed to set Coresetup flag for Adminconsole.'
				GOTO ERROR_EXIT
			END
		END
        
        IF NOT EXISTS (SELECT TOP 1 * FROM GXGlobalParam WHERE name='Set Default Plan Automatically' )
		BEGIN
			EXEC  AppInsertGlobalParam
						@isPIT = 0,
						@createdTime = @nowTime,
						@name = N'Set Default Plan Automatically',
						@newValue = N'1'
			SET @errorCode = @@ERROR
			
			IF  @errorCode <> 0
			BEGIN
				SET @errorString = 'ERROR: Failed to set Default plan setting flag for Adminconsole.'
				GOTO ERROR_EXIT
			END
		END
       
END TRY
BEGIN CATCH
--CATCH_HANDLING_MACRO
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
SELECT @errorCode, @errorString
