DECLARE	@currentTime	INTEGER		= dbo.GetUnixTime(GetUTCDate())
DECLARE	@MajorBrandId	INTEGER		= 1
DECLARE	@MiniBrandId	INTEGER		= 113
DECLARE	@MiniBrandName	VARCHAR(64)	= 'Commvault Edge'
DECLARE	@globalPropName	VARCHAR(64)	= 'MiniBrandId'
DECLARE @propList	TABLE (t_propName VARCHAR(MAX), t_propVal VARCHAR(MAX))
INSERT INTO @propList VALUES ('e-mail',	'edge@company.com')


DECLARE @oem INT = ISNULL((SELECT CAST(value AS INT) FROM gxglobalparam WHERE name = 'MiniBrandId'), 0)
    
-- Do this only for OEM 113 - Edge brand

IF @oem <> 113
   return



-- 1) update simMiniBrand table
IF not exists (select * from simMiniBrand where miniBrandId = @MiniBrandId and oemId = @MajorBrandId)
BEGIN
	INSERT INTO simMiniBrand (miniBrandId, oemId, name)
		VALUES(@MiniBrandId, @MajorBrandId, @MiniBrandName)
END

-- 1.1) update simOEMProp
UPDATE	simOEMProp
SET	value = t_propVal
FROM	@propList
WHERE	OemId = @MiniBrandId and name = t_propName

INSERT INTO simOEMProp(OemId, name, value)
SELECT	@MiniBrandId, t_propName, t_propVal
FROM	@propList
WHERE	NOT EXISTS (select * from simOEMProp T where T.OemId = @MiniBrandId and T.name = t_propName)

-- 2) insert into GXGlobalParam table
IF not exists (select * from GXGlobalParam where name = @globalPropName)
	INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES(@globalPropName, CAST(@MiniBrandId AS VARCHAR(64)), @currentTime, 0)
ELSE
	UPDATE GXGlobalParam SET value = CAST(@MiniBrandId AS VARCHAR(64)) WHERE name = @globalPropName

