DECLARE @newMiniBrandID                      INT=112
DECLARE @majorBrandToDeriveFrom   INT=1
DECLARE @newMiniBrandName              VARCHAR(256)='HP Snap Manager'

IF not exists (select * from simMiniBrand where miniBrandId = @newMiniBrandID and oemId = @majorBrandToDeriveFrom)
BEGIN
    INSERT INTO simMiniBrand (miniBrandId, oemId, name)
        VALUES(@newMiniBrandID, @majorBrandToDeriveFrom, @newMiniBrandName)
END

IF not exists (select * from GXGlobalParam where name = 'MiniBrandId')
    INSERT INTO GXGlobalParam (name, value, created, modified)
        SELECT 'MiniBrandId', CAST(@newMiniBrandID AS NVARCHAR(64)), dbo.GetUnixTime(GETUTCDATE()), 0
ELSE
    UPDATE GXGlobalParam SET value = CAST(@newMiniBrandID AS NVARCHAR(64)) WHERE name = 'MiniBrandId'