DECLARE	@currentTime	INTEGER		= dbo.GetUnixTime(GetUTCDate())
DECLARE	@MajorBrandId	INTEGER		= 1
DECLARE	@MiniBrandId	INTEGER		= 109
DECLARE	@MiniBrandName	VARCHAR(64)	= 'Cloud Backup'
DECLARE	@globalPropName	VARCHAR(64)	= 'MiniBrandId'
DECLARE @propList	TABLE (t_propName VARCHAR(MAX), t_propVal VARCHAR(MAX))
--INSERT INTO @propList VALUES ('LinkToDocumentationWebSite',		'http://documentation.commvault.com/fujitsu/')
--INSERT INTO @propList VALUES ('SendLogsDefaultFTPSite',			'ftp.ts.fujitsu.com')
--INSERT INTO @propList VALUES ('SendLogsDefaultFTPUser',			'fe_esm')
--INSERT INTO @propList VALUES ('SendLogsDefaultFTPPassword',		'35e41e1b4d1e9e50dfeb0346e4fa8abfe3e4aa8829593a4ea')
--INSERT INTO @propList VALUES ('SendLogsDefaultHTTPSite')
--INSERT INTO @propList VALUES ('SendLogsDefaultHTTPUser')
--INSERT INTO @propList VALUES ('SendLogsDefaultHTTPPassword')
--INSERT INTO @propList VALUES ('SendLogsDefaultNotificationEmail',	'esm-support@ts.fujitsu.com')
--INSERT INTO @propList VALUES ('SendLogsDefaultRecipient',		'esm-support@ts.fujitsu.com')
--INSERT INTO @propList VALUES ('e-mail',					'esm-support@ts.fujitsu.com')

-- 1) update simMiniBrand table
IF not exists (select * from simMiniBrand where miniBrandId = @MiniBrandId and oemId = @MajorBrandId)
BEGIN
	INSERT INTO simMiniBrand (miniBrandId, oemId, name)
		VALUES(@MiniBrandId, @MajorBrandId, @MiniBrandName)
END

-- 1.1) update simOEMProp
UPDATE	simOEMProp
SET	value = t_propVal
FROM	@propList
WHERE	OemId = @MiniBrandId and name = t_propName

INSERT INTO simOEMProp(OemId, name, value)
SELECT	@MiniBrandId, t_propName, t_propVal
FROM	@propList
WHERE	NOT EXISTS (select * from simOEMProp T where T.OemId = @MiniBrandId and T.name = t_propName)

-- 2) insert into GXGlobalParam table
IF not exists (select * from GXGlobalParam where name = @globalPropName)
	INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES(@globalPropName, CAST(@MiniBrandId AS VARCHAR(64)), @currentTime, 0)
ELSE
	UPDATE GXGlobalParam SET value = CAST(@MiniBrandId AS VARCHAR(64)) WHERE name = @globalPropName

