USE master

DECLARE @windows TINYINT = 1
DECLARE @linux TINYINT = 2
DECLARE @osType TINYINT = 0
DECLARE @versionSQL NVARCHAR(MAX)

SET @versionSQL = @@VERSION
SET @osType = IIF((@versionSQL LIKE '%%Linux%%'), @linux, @windows) -- '%%Linux%%' is used so that it is not parsed as a format specifier in cpp layer.

DECLARE @procName VARCHAR(256)
SET	@procName = '%s'

DECLARE @output NVARCHAR(MAX)
SET	@output = ''

IF (@osType = @windows)
BEGIN
	IF EXISTS (SELECT * FROM sysObjects WHERE name = @procName)
	BEGIN
		SET @output = @output + 'Extended Procedure already exists, dropping it...' 
		EXEC sp_dropextendedproc @procName
	END

	SET @output = @output + 'Adding Extended Procedure' 
	EXEC sp_addextendedproc @procName, '%s\%s'

	PRINT @output
END
GO
