
SET NOCOUNT ON 

DECLARE @output			VARCHAR(MAX)
DECLARE @newline		CHAR
DECLARE @tabDelim		CHAR
DECLARE @licToRemove		TABLE (t_id int, t_name varchar(MAX))
DECLARE @appTypeToRemove	TABLE (t_clientId int, t_appTypeId int)

SET @newline	= char(13)
SET @tabDelim	= char(9)
SET @output	= 'UpdateSimTable start ...' + @newline

-- 1) Some obsolete license type is found in license table: SQL BackTrack OBSI
INSERT INTO @licToRemove
SELECT id, short_name FROM simLicAppTypeV2 WHERE short_name in ('SQL BackTrack OBSI', 'MediaAgent for Unix')
IF EXISTS (select * from @licToRemove)
BEGIN
	IF EXISTS (select * from licUsage where lictype in (select t_id from @licToRemove))
	BEGIN
		RAISERROR('Some obsolete license types are still used in licUsage table', 16, 1)
		SELECT 2
		RETURN
	END

	DELETE simAppTypeLicTypeMap WHERE simLicAppType IN (select t_id from @licToRemove)
	DELETE simLicAppTypeV2 WHERE id IN (select t_id from @licToRemove)
	SET @output = @output + '------------------------------' + @newline
	SET @output = @output + 'Deleted obsolete license type:' + @newline
	SELECT  @output = @output + t_name + @newline from @licToRemove
END

/*
2) & 3) Not to change patchInfo table. Just skip those updateInfo rows duing upgrade.
-- 2) updateInfo table contains records for pseudo clients: NAS NNMP, Oracle RAC
INSERT INTO @appTypeToRemove
SELECT DISTINCT clientId, appTypeId
FROM	patchInfo 
WHERE	appTypeId IN (select type FROM APP_iDAType WHERE name in ('NAS NDMP', 'Oracle RAC'))
IF EXISTS (select * from @appTypeToRemove)
BEGIN
	DELETE patchInfo FROM @appTypeToRemove WHERE clientId = t_clientId AND appTypeId = t_appTypeId
	SET @output = @output + '------------------------------' + @newline
	SET @output = @output + 'Deleted pseudo clients from patchInfo table:' + @newline
	SELECT @output = @output + (select name from APP_client where id = t_clientId) + (select name from APP_iDAType where type = t_appTypeId) + @newline FROM @appTypeToRemove
END

-- 3) remove Qnet agent rows
DECLARE @clientId	INTEGER
DECLARE @QNetApptypes	TABLE (t_appTypeId INT)

SET @clientId = (SELECT clientId FROM APP_CommCell WHERE id = 2)
INSERT INTO @QNetApptypes
SELECT type FROM APP_iDAType WHERE name IN ('QNet Agent', 'QNET Agent DB on CommServer')
DELETE patchInfo WHERE clientId = @clientId AND appTypeId IN (SELECT t_appTypeId FROM @QNetApptypes)
DELETE licUsage WHERE appType IN (SELECT t_appTypeId FROM @QNetApptypes)
SET @output = @output + '------------------------------' + @newline
SET @output = @output + 'Updated patchInfo/LicUsage table for QNet agent' + @newline

*/

-- 4) MR 32263: CS job result dir. should be populated at the time of DBupgrade.
DECLARE	@jobResultDir	nvarchar(255)
SELECT @jobResultDir = jobResultDir FROM App_Client WHERE id=2
IF @jobResultDir = '' OR @jobResultDir = 'NO DIR'
BEGIN
	SELECT @jobResultDir = install_dir FROM APP_Platform where clientId=2 and platformType=1
	SET @jobResultDir = replace(@jobResultDir, 'CommServe', 'iDataAgent\JobResults')

	UPDATE App_Client SET jobResultDir=@jobResultDir where id=2

	SET @output = @output + '------------------------------' + @newline
	SET @output = @output + 'Updated Job result directory for CS -- ' + @jobResultDir + @newline
END

-- 5) Delete dangling licUsage rows
DECLARE @DanglingLicUsageToFix	TABLE (t_id INT, t_clId INT, t_appType INT, t_licType INT, t_oldRel INT)

INSERT INTO @DanglingLicUsageToFix
SELECT	L.id, L.cid, L.appType, L.licType, L.releaseId
FROM	licUsage L JOIN APP_client C ON C.id = L.cid 
WHERE	LicType NOT IN (71, 10, 26) AND OpType = 'Install' AND (L.releaseId < C.releaseId OR (C.status & 0x2) > 0)

DELETE @DanglingLicUsageToFix
WHERE	EXISTS (select * from licUsage where cid = t_clid AND LicType = 16777216 AND optype = 'Install')
	AND
	NOT EXISTS (select * from APP_Client where id = t_clid AND (status & 0x2) = 0)
	AND
	NOT EXISTS (select * from APP_iDAName where clientId = t_clid AND appTypeId = t_appType AND (status & 0x2) = 0)

INSERT INTO @DanglingLicUsageToFix
SELECT id, cid, appType, licType, releaseId
FROM LicUsage
WHERE licType NOT IN (10, 26, 71) AND NOT EXISTS (select * from APP_client C where C.id = cid) AND optype = 'Install'

IF EXISTS (select * from @DanglingLicUsageToFix)
BEGIN
	DELETE LicUsage FROM @DanglingLicUsageToFix WHERE Id = t_Id
	SET @output = @output + '------------------------------' + @newline
	SET @output = @output + 'Deleted dangling licUsage rows:' + @newline
	SELECT @output = @output + 	ISNULL((select name from APP_client where id = t_clId), 'DELETED_CLIENT:' + CAST(t_clId AS VARCHAR(65))) + @tabDelim +
					ISNULL((select name from APP_iDAType where type = t_appType), 'UNKNOWN AGENT') + @tabDelim +
					ISNULL((select short_name from simLicAppTypeV2 where id = t_licType), 'UNKNOWN LICENSE') + @tabDelim +
					ISNULL((select release from simAllGalaxyRel where id = t_oldRel), 'UNKNOWN RELEASE') + @newline FROM @DanglingLicUsageToFix
END

-- build output & return

SET @output = @output + '------------------------------' + @newline
SET @output = @output + 'UpdateSimTable completed' + @newline
PRINT @output

SELECT 0
