IF	EXISTS (SELECT * FROM sysobjects WHERE type = 'u' AND name = 'JMPhase_old') AND
	EXISTS (SELECT * FROM sysobjects WHERE type = 'u' AND name = 'JMOpTable_old')
BEGIN 

	-- 9.0 and above
	-- There is no easy way to check the version here. So check the column to find out if it is upgrade from 9.0 or above
	-- @Gokul
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMPhase_old' AND COLUMN_NAME = 'enableTotalRunningTime')
	BEGIN
		EXEC sp_executesql N'
			UPDATE	JMPhase 
			SET		Restartable = JPO.Restartable, 
					maxRestarts = JPO.maxRestarts, 
					restartInterval = JPO.restartInterval, 
					preemptable = JPO.preemptable,
					enableTotalRunningTime = JPO.enableTotalRunningTime,
					totalRunningTime = JPO.totalRunningTime,
					killJobIfRunningTimeExpires = JPO.killJobIfRunningTimeExpires
					
			FROM	JMPhase JPN, 
					JMPhase_old JPO, 
					(	SELECT	newOpId = OTN.id, oldOpId = OTO.id 
						FROM	JMOpTable_old OTO, JMOpTable OTN 
						WHERE	OTO.appTypeType = OTN.appTypeType AND OTO.operation = OTN.operation) X 
			WHERE	JPN.optableId = X.newOpId AND JPO.optableId = X.oldOpId AND JPO.phase = JPN.phase AND JPO.name = JPN.name'
	END
	-- Pre 9.0
	ELSE
	BEGIN
		EXEC sp_executesql N'
			UPDATE	JMPhase 
			SET		Restartable = JPO.Restartable, 
					maxRestarts = JPO.maxRestarts, 
					restartInterval = JPO.restartInterval, 
					preemptable = JPO.preemptable
			FROM	JMPhase JPN, 
					JMPhase_old JPO, 
					(	SELECT	newOpId = OTN.id, oldOpId = OTO.id 
						FROM	JMOpTable_old OTO, JMOpTable OTN 
						WHERE	OTO.appTypeType = OTN.appTypeType AND OTO.operation = OTN.operation) X 
			WHERE	JPN.optableId = X.newOpId AND JPO.optableId = X.oldOpId AND JPO.phase = JPN.phase AND JPO.name = JPN.name'
	END

	DROP TABLE JMPhase_old 
	DROP TABLE JMOpTable_old 

	-- For 10.0, Virtualize ME job is restartable in Restore phases
	UPDATE JMPhase 
	SET maxRestarts = 5, restartInterval = 4320
	WHERE opTableId = (SELECT id FROM JMOpTable 
					   WHERE operation = 89) -- Virtualize ME
	AND phase IN (3, 4)

END

RETURN
