DECLARE @clientId	INTEGER
DECLARE @CSPackageTbl	TABLE (t_packageId INT, t_isQNet INT)

SET @clientId = (SELECT clientId FROM APP_platform WHERE platformType = 1)
INSERT INTO @CSPackageTbl
SELECT	simPackageId, 1 
FROM	simPackageMap JOIN APP_iDAType On apptype = type 
WHERE	name IN ('QNet Agent', 'QNET Agent DB on CommServer')
INSERT INTO @CSPackageTbl
SELECT	simPackageId, 0 
FROM	simPackageMap JOIN APP_iDAType On apptype = type
WHERE	name IN ('CommServe Management', 'CommClient Management', 'CommServe Database', 'Java Gui')

INSERT INTO APP_ClientProp
        (componentNameId, 
        attrName, 
        attrType, 
        attrVal, 
        created, 
        modified)
SELECT  clientID, N'PackageStateForId ' + CAST(simPackageID as nvarchar(64)), 2, N'1', dbo.getUNIXTime(GETDATE()), 0
FROM    (select clientID, simPackageID from SimInstalledPackages where simPackageID = 702 and clientID = 2) T
WHERE   NOT EXISTS (select * from APP_ClientProp A where A.componentNameId = T.ClientId AND attrName = N'PackageStateForId ' + CAST(simPackageID as nvarchar(64)))

DELETE	SimInstalledPackages
WHERE	clientId = @clientId AND simPackageID NOT IN (SELECT t_packageId FROM @CSPackageTbl)

DECLARE @simPackageID int
DECLARE SIPCursor CURSOR FOR
	SELECT simPackageID
	FROM SimInstalledPackages 
	WHERE clientId = @clientId AND simPackageID IN (SELECT t_packageId FROM @CSPackageTbl WHERE t_isQNet = 0)

OPEN SIPCursor
FETCH FROM SIPCursor INTO @simPackageID

WHILE @@FETCH_STATUS = 0
BEGIN
	EXEC simSetInstalledPackage 0, @clientId, 0, @simPackageID, 0, '', 0, 0, 'None', 'None', '', 1, 0, 0, '', '', 0, 0, ''
	FETCH FROM SIPCursor INTO @simPackageID
END

CLOSE SIPCursor
DEALLOCATE SIPCursor

DECLARE @attrName VARCHAR(1024) = 'CSSyncAfterDBUpgrade'
IF EXISTS (select * from GXGlobalParam where name = @attrName)
	UPDATE GXGlobalParam SET value = '1' WHERE name = @attrName 
ELSE
	INSERT INTO GXGlobalParam VALUES(@attrName, '1', dbo.GetUnixTime(getDate()), 0)
