-- UpgradeType is not reliable outside DBUpgrade context.
-- So, we cannot have checks based on UpgradeType outside DBUpgrade.
-- We will always go thru with the script when called.
-- The only thing that will be conditionally done is,
-- creating/updating sqlexec_cv login.
-- This part will be skipped when the script is called 
-- DBUpgrade (to cover out of place dbupgrades).
-- Other than that, this script is called by only installer.
-- Whenever installer calls this script, it is guaranteed to pass in
-- a valid password. We will create the login if it doesnt exist
-- or update the password if it already does exist.
-- This will extraneous effort for service pack upgrades and build to build
-- upgrades, but there is no reliable way to know.
/* DECLARE @UpgradeType INTEGER = 1 /* UPGRADETYPE_RELEASE */
-- Table will not be present in case of v9, v10 upgrade install. So the initial value of 1 will be retained.
-- Table is empty in case of fresh installation. So the initial value of 1 will be retained.
-- Table will have the upgrade type in case of dbupgrade. 
IF OBJECT_ID ('DBUpgradeSteps') IS NOT NULL
	SELECT @UpgradeType = [Status] FROM DBUpgradeSteps WHERE Step = 'UpgradeType'
IF @UpgradeType <> 1 /* UPGRADETYPE_RELEASE */
BEGIN
    PRINT 'Skip creating DB user mappings as this is not release upgrade. [' +  CONVERT (CHAR(1), @UpgradeType) + '].'
    RETURN
END */

-- By default CSDB's dbo is supposed to be associated with sa.
-- But on some customer Commserves we see that it is associated
-- with sqladmin_cv due to manual changes in db config, even though 
-- it is not really required. And this interferes with the config
-- changes for sqlexec_cv - making sqladmin_cv a db_owner.
-- So, reset dbo association with sa before proceeding.
DECLARE @DBOLogin VARCHAR(128)
SELECT @DBOLogin = SUSER_SNAME(owner_sid) FROM master.sys.databases WHERE database_id = DB_ID()
IF @DBOLogin = 'sqladmin_cv'
BEGIN
	IF EXISTS (SELECT * FROM sys.syslogins WHERE name = 'sa')
	BEGIN
		EXEC sp_changedbowner 'sa'
		PRINT 'Reset Commserv dbo login mapping to sa.'
	END
	ELSE
	BEGIN
		DECLARE @SALogin VARCHAR(128)
		SELECT @SALogin = name FROM sys.syslogins WHERE sid = 0x01 
		DECLARE @errorString NVARCHAR(MAX);
		SET		@errorString = 'Cannot proceed. Commserv dbo cannot be mapped to login ' + @DBOLogin + '. To resume Install/Upgrade, either manually map dbo to a different login (or temporarily rename ' + @SALogin + ' login back to sa).'
		RAISERROR (@errorString, 15, 1)
		RETURN
	END
END

DECLARE @Mode NVARCHAR(MAX) = '%s'

IF @Mode = 'Install'
BEGIN
	-- Clean up existing login.
	IF EXISTS (SELECT name FROM master..syslogins WHERE name = 'sqlexec_cv') 
		DROP LOGIN sqlexec_cv

	-- Create new login.
	CREATE LOGIN [sqlexec_cv] WITH PASSWORD='[password]', 
								DEFAULT_DATABASE=[master], 
								DEFAULT_LANGUAGE=[us_english], 
								CHECK_EXPIRATION=OFF, 
								CHECK_POLICY=OFF 
END

-- Clean up existing database user and database role.
IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'sqlexec_cv')
	DROP USER sqlexec_cv
	
IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'db_cvexecutor')
BEGIN
	-- Some setups have unexpected users in db_cvexecutor. Remove them first.
	DECLARE @CSDBMemberToRemove sysname = ''
	BEGIN TRY
		DECLARE CurCSDBMembersToRemove CURSOR FOR
		SELECT MMBR.name FROM sys.database_role_members MAP, sys.database_principals ROLE, sys.database_principals MMBR
		WHERE 
			MAP.role_principal_id = ROLE.principal_id AND 
			ROLE.name = 'db_cvexecutor' AND
			MMBR.principal_id = MAP.member_principal_id AND
			MMBR.name <> 'sqlexec_cv'

		OPEN CurCSDBMembersToRemove
		FETCH NEXT FROM CurCSDBMembersToRemove INTO @CSDBMemberToRemove

		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC sp_droprolemember 'db_cvexecutor', @CSDBMemberToRemove
			PRINT 'Removed user from role db_cvexecutor: ' + @CSDBMemberToRemove
			FETCH NEXT FROM CurCSDBMembersToRemove INTO @CSDBMemberToRemove
		END

		CLOSE CurCSDBMembersToRemove
		DEALLOCATE CurCSDBMembersToRemove
	END TRY
	BEGIN CATCH
		PRINT 'Cannot remove extra members from role db_cvexecutor. ' + @CSDBMemberToRemove
		PRINT ERROR_MESSAGE ()
	END CATCH

	-- Now actually remove the role.
	DROP ROLE db_cvexecutor
END

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'sqladmin_cv')
	DROP USER sqladmin_cv

-- New executor database role.
CREATE ROLE db_cvexecutor
-- Be able to SELECT/INSERT/UPDATE/DELETE
EXEC sp_addrolemember 'db_datareader', 'db_cvexecutor'
EXEC sp_addrolemember 'db_datawriter', 'db_cvexecutor'
-- Be able to execute stored procedures.
GRANT EXECUTE on schema::dbo TO db_cvexecutor

-- Create a database user from the role.
CREATE USER sqlexec_cv FOR LOGIN sqlexec_cv
EXEC sp_addrolemember 'db_cvexecutor', 'sqlexec_cv'

-- If a stored procedure requires higher privileges, it will be created with "EXECUTE AS 'sqladmin_cv'".
-- For this to work, sqladmin_cv needs to be a db user.
CREATE USER sqladmin_cv FOR LOGIN sqladmin_cv
EXEC sp_addrolemember 'db_owner', 'sqladmin_cv'

-- To be able to say EXECUTE AS USER or EXECUTE AS LOGIN.
-- This one is in the hands of the developer.
GRANT IMPERSONATE ON USER::sqladmin_cv to db_cvexecutor
USE master
GRANT IMPERSONATE ON LOGIN::sqladmin_cv to sqlexec_cv

-- For execute permission on extended stored procs.
USE master

IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'sqlexec_cv')
	DROP USER sqlexec_cv
	
IF EXISTS (SELECT * FROM sys.database_principals WHERE name = 'db_cvmasterexecutor')
BEGIN
	-- Some setups have unexpected users in db_cvmasterexecutor. Remove them first.
	DECLARE @MasterDBMemberToRemove sysname = ''
	BEGIN TRY
		DECLARE CurMasterDBMembersToRemove CURSOR FOR
		SELECT MMBR.name FROM sys.database_role_members MAP, sys.database_principals ROLE, sys.database_principals MMBR
		WHERE 
			MAP.role_principal_id = ROLE.principal_id AND 
			ROLE.name = 'db_cvmasterexecutor' AND
			MMBR.principal_id = MAP.member_principal_id AND
			MMBR.name <> 'sqlexec_cv'

		OPEN CurMasterDBMembersToRemove
		FETCH NEXT FROM CurMasterDBMembersToRemove INTO @MasterDBMemberToRemove

		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC sp_droprolemember 'db_cvmasterexecutor', @MasterDBMemberToRemove
			PRINT 'Removed user from role db_cvmasterexecutor: ' + @MasterDBMemberToRemove
			FETCH NEXT FROM CurMasterDBMembersToRemove INTO @MasterDBMemberToRemove
		END

		CLOSE CurMasterDBMembersToRemove
		DEALLOCATE CurMasterDBMembersToRemove
	END TRY
	BEGIN CATCH
		PRINT 'Cannot remove extra members from role db_cvmasterexecutor. ' + @MasterDBMemberToRemove
		PRINT ERROR_MESSAGE ()
	END CATCH

	-- Now actually remove the role.
	DROP ROLE db_cvmasterexecutor
END

CREATE ROLE db_cvmasterexecutor 
GRANT EXECUTE on schema::dbo TO db_cvmasterexecutor

CREATE USER sqlexec_cv FOR LOGIN sqlexec_cv 
EXEC sp_addrolemember 'db_cvmasterexecutor', 'sqlexec_cv' 

-- Revert context back to the CSDB.
USE [%s]