DECLARE @tblErrorCode TABLE
(
	errorCode INTEGER
)

DECLARE @xmlPath NVARCHAR(max)
DECLARE @RegistryStaticXMLPath NVARCHAR(max)
DECLARE @AdvanceKeyInfoXMLPath NVARCHAR(max)

SET @xmlPath = N'%s'

SET @RegistryStaticXMLPath = @xmlPath + N'RegKeysToPreserve.xml'
SET @AdvanceKeyInfoXMLPath = @xmlPath + N'AdditionalSettings.xml'

PRINT 'Executing AppAddRegistryStaticList...' 
INSERT INTO @tblErrorCode
EXEC AppAddRegistryStaticList @RegistryStaticXMLPath

IF @@ERROR <> 0
	GOTO CX_ERROR_EXIT_AppAddRegistryStaticList
	
IF EXISTS (SELECT * FROM @tblErrorCode WHERE errorCode <> 0)
	GOTO CX_ERROR_EXIT_AppAddRegistryStaticList

DELETE FROM @tblErrorCode
declare @errorCode integer
PRINT 'Executing AppAddAdvanceKeyInfoList...' 

EXEC @errorCode = AppAddAdvanceKeyInfoList @AdvanceKeyInfoXMLPath

INSERT INTO @tblErrorCode
SELECT @errorCode


IF @@ERROR <> 0
	GOTO CX_ERROR_EXIT_AppAddAdvanceKeyInfoList
	
IF EXISTS (SELECT * FROM @tblErrorCode WHERE errorCode <> 0)
	GOTO CX_ERROR_EXIT_AppAddAdvanceKeyInfoList
ELSE
	GOTO CX_EXIT

CX_EXIT:
	PRINT 'AppAddRegistryStaticList and AppAddAdvanceKeyInfoList executed successfully.' 
	SELECT 0
	RETURN

CX_ERROR_EXIT_AppAddRegistryStaticList:
	PRINT 'Failed to execute AppAddRegistryStaticList.' 
	SELECT 1
	RETURN

CX_ERROR_EXIT_AppAddAdvanceKeyInfoList:
	PRINT 'Failed to execute AppAddAdvanceKeyInfoList.' 
	SELECT 1
	RETURN
		
GO
