SET QUOTED_IDENTIFIER OFF


--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ADD_FUNCTION.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
 GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[utf8_2_ucs]') and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)

BEGIN

  DROP FUNCTION utf8_2_ucs

END

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertRevision]') and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)

BEGIN

  DROP FUNCTION ConvertRevision

END

 GO

CREATE FUNCTION utf8_2_ucs (@inValue varchar(2048))  

RETURNS nvarchar(2048)

AS

BEGIN 

	declare @binValue varbinary(4096)

	declare @outValue nvarchar(2048)

	exec master.dbo.xp_utf8_2_ucs @inValue, @binValue OUTPUT 

	set @outValue = @binValue

	RETURN @outValue

END

 GO

CREATE FUNCTION ConvertRevision ( @oldRevision varchar(20))

RETURNS varchar(20)

AS

BEGIN

	DECLARE @newRevision VARCHAR(20)

	DECLARE @Index1 AS INT

	DECLARE @Index2 AS INT

	DECLARE @Count AS INT

	SET @newRevision = ''

	SET @oldRevision = @oldRevision + '.'

	SET @Count = 0

	SET @Index1 = 1

	SET @Index2 = CHARINDEX('.', @oldRevision)

	WHILE @Index2 <> 0

	BEGIN

	SET @newRevision = @newRevision + REPLICATE('0', 4-(@Index2-@Index1)) + SUBSTRING(@oldRevision, @Index1, @Index2-@Index1)

	SET @Index1 = @Index2+1

	SET @Index2 = CHARINDEX('.', @oldRevision, @Index1)

	SET @Count = @Count + 1

	END

	SET @newRevision = @newRevision + REPLICATE('0', (5-@Count)*4)

	RETURN @newRevision

END

 GO

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/DBCollectInfo.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Can't use DECLARE ... assumes commserv DB!
--+-----------------------------------+
--| Know we have to do an update,		|
--| ea. one has it's own rules!		|
--+-----------------------------------+
	IF EXISTS (select * from sysobjects where id = object_id(N'[dbo].[oldReleaseNumber]') and OBJECTPROPERTY(id, N'IsTable') = 1)

		drop table oldReleaseNumber

	IF NOT EXISTS (SELECT id FROM simAllGalaxyRel WHERE id = 16)

	BEGIN

IF ("DELETE FROM GXGlobalParam WHERE name = 'OldReleaseNumber'" <> '')							
  		SET @sqlString = "DELETE FROM GXGlobalParam WHERE name = 'OldReleaseNumber'"				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GXGlobalParam' AND COLUMN_NAME = 'modified')

		BEGIN

IF ("INSERT INTO GXGlobalParam SELECT TOP 1 'OldReleaseNumber', release FROM simAllGalaxyRel ORDER BY id DESC" <> '')							
  		SET @sqlString = "INSERT INTO GXGlobalParam SELECT TOP 1 'OldReleaseNumber', release FROM simAllGalaxyRel ORDER BY id DESC"				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		END

		ELSE

		BEGIN

IF ("INSERT INTO GXGlobalParam SELECT TOP 1 'OldReleaseNumber', release, 473385600, 0 FROM simAllGalaxyRel ORDER BY ID DESC" <> '')							
  		SET @sqlString = "INSERT INTO GXGlobalParam SELECT TOP 1 'OldReleaseNumber', release, 473385600, 0 FROM simAllGalaxyRel ORDER BY ID DESC"				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		END

	END	

END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ADD_cv_drop_fkeys.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--USE commserv
IF EXISTS (select * from sysobjects where name='cvsp_drop_fkeys')

	drop procedure cvsp_drop_fkeys

--IF EXISTS (select * from GXDBVersions where name='cvsp_drop_fkeys')
--delete from GXDBVersions where name = 'cvsp_drop_fkeys'
	GO

create procedure cvsp_drop_fkeys

  @fromTable varchar(40),

  @fromColumn varChar(40),

  @ToTable varchar(40)

WITH ENCRYPTION AS

declare @fkName     varchar (255)

declare @execString nvarchar (255)

declare @errCode    int

set @errCode = 0

IF object_id('tempdb.dbo.#ffk') is not null DROP TABLE #ffk

CREATE TABLE #ffk

(

	PKTABLE_QUALIFIER		varchar(255),

	PKTABLE_OWNER	varchar(255),

	PKTABLE_NAME	varchar(255),

	PKCOLUMN_NAME	varchar(255),

	FKTABLE_QUALIFIER	varchar(255),

	FKTABLE_OWNER	varchar(255),

	FKTABLE_NAME	varchar(255),

	FKCOLUMN_NAME	varchar(255),

	KEY_SEQ		int,

	UPDATE_RULE	int,

	DELETE_RULE	int,

	FK_NAME	varchar(255),

	PK_NAME	varchar(255),

	DEFERRABILITY	varchar(255)

)

INSERT INTO  #ffk

EXEC  sp_fkeys @fktable_name=@fromTable

DECLARE fkCursor CURSOR FOR

	select distinct  FK_NAME from #ffk 

	where PKTABLE_NAME = @ToTable 

	AND FKCOLUMN_NAME = @fromColumn

OPEN fkCursor

FETCH	NEXT FROM fkCursor INTO @fkName

WHILE	@@FETCH_STATUS = 0

BEGIN

--print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		set @execString = 'alter table ' + @fromTable +' drop ' + @fkName

		exec sp_executesql @execString

		set @errCode = @@error

		IF @errCode <> 0

			break;

		FETCH	NEXT FROM fkCursor INTO @fkName

END

CLOSE fkCursor

DEALLOCATE fkCursor

drop table #ffk

return @errCode

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ADD_cvsp_drop_pk.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--USE commserv
SET QUOTED_IDENTIFIER ON

IF EXISTS (select * from sysobjects where name='cvsp_drop_pk')

	drop procedure cvsp_drop_pk

--IF EXISTS (select * from GXDBVersions where name='cvsp_drop_pk')
--delete from GXDBVersions where name = 'cvsp_drop_pk'
	GO

create procedure cvsp_drop_pk

  @tblName varchar(40)

AS

DECLARE	@fkTable	varchar (40)

DECLARE @keyName	varchar (255)

DECLARE @execString	nvarchar(255)

DECLARE @errCode    	int

SET	@errCode = 0

DECLARE fkCursor CURSOR FOR

	SELECT	DISTINCT object_name(constid), object_name(fkeyid)

	FROM	sysforeignkeys

	WHERE	rkeyid = object_id(@tblName)

OPEN	fkCursor

FETCH	NEXT FROM fkCursor INTO @keyName, @fkTable

WHILE	@@FETCH_STATUS = 0

BEGIN

		SET	@execString = 'ALTER TABLE ' + @fkTable +' DROP CONSTRAINT ' + @keyName

		EXEC sp_executesql @execString

		SET	@errCode = @@error

		IF	@errCode <> 0

			BREAK

		FETCH NEXT FROM fkCursor INTO @keyName, @fkTable

END

CLOSE		fkCursor

DEALLOCATE	fkCursor

IF	@errCode <> 0

	return @errCode

SELECT @keyName = name FROM sysobjects WHERE parent_obj = object_id(@tblName) AND xtype = 'PK'

IF (@keyName IS NOT null)

BEGIN

	SET @execString = 'ALTER TABLE ' + @tblName +' DROP CONSTRAINT ' + @keyName

	EXEC sp_executesql @execString

END

RETURN @@error

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ADD_cv_makeTableColumnsNonNullable.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--USE commserv
IF EXISTS (select * from sysobjects where name='cvsp_makeTableColumnsNonNullable')

	drop procedure cvsp_makeTableColumnsNonNullable

IF EXISTS (select * from GXDBVersions where name='cvsp_makeTableColumnsNonNullable')

	delete from GXDBVersions where name = 'cvsp_makeTableColumnsNonNullable'

	GO

create procedure cvsp_makeTableColumnsNonNullable

  @l_TableName varchar(40)

AS

	DECLARE cur CURSOR STATIC FOR

	SELECT	syscolumns.name,

			systypes.name,

			syscolumns.length

	    FROM sysobjects 

	    INNER JOIN syscolumns ON sysobjects.id = syscolumns.id

		INNER JOIN systypes ON syscolumns.xtype=systypes.xtype

	   WHERE	sysobjects.xtype='U' and 

				systypes.name <> 'sysname' and

				syscolumns.isnullable = 1 and

				sysobjects.name = @l_TableName

	declare @colname varchar(512), @coltype varchar(50), @collength int , @retVal int

	OPEN cur

	SELECT	@retVal = @@ERROR

	IF		@retVal != 0

	BEGIN

			print 'Failed to declare cursor to get table columns'

			GOTO CX_ERROR_EXIT

	END

	FETCH	NEXT FROM cur

	INTO @colname, @coltype, @collength

	SELECT	@retVal = @@ERROR

	IF		@retVal != 0

	BEGIN

			print 'Failed to fetch next column name and type'

			GOTO CX_ERROR_EXIT

	END

	WHILE	@@FETCH_STATUS = 0

	BEGIN

		DECLARE @l_update VARCHAR(MAX)

		DECLARE @l_colchange VARCHAR(MAX)

		set @l_colchange  =

		' ALTER TABLE ' + @l_TableName  + ' ALTER COLUMN ' + @colname +

		' ' + @colType

		IF @colType IN ('int', 'smallint', 'tinyint', 'float', 'bigint')

		BEGIN

			SET @l_update =  'update ' + @l_TableName + 

					' set ' +  @colname + ' = 0 ' +

					' where ' + @colname + ' is null'

		END ELSE 

		IF @colType IN ('xml', 'varchar', 'text', 'ntext', 'nvarchar')

		BEGIN

				SET @l_update =  'update ' + @l_TableName + 

					' set ' +  @colname + ' = '''' ' +

					' where ' + @colname + ' is null'

				IF @colType IN ('varchar', 'nvarchar')

				BEGIN

					IF (@collength = -1) 

					BEGIN

						SET @l_colchange  = @l_colchange   + '(max)'

					END ELSE

					BEGIN

						SET @l_colchange  = @l_colchange  + '(' + cast (@collength as varchar(20)) + ')'

					END

				END

		END ELSE

		BEGIN

			declare @errmsg varchar(255)

			set @errmsg = 'Mark columns non-NULLABLE: ' + @colname + ' is an unsupported datatype (' + @colType

				+ ') ! - cannot change to non-nullable!'

			raiserror (@errmsg, 16,1)

			goto CX_ERROR_EXIT

		END

		exec(@l_update )

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

				print 'Failed to update NULL columns'

				GOTO CX_ERROR_EXIT

		END

		set @l_colchange  = @l_colchange  + ' not null'

		exec(@l_colchange )

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

				print 'Failed to make column not null, statement:' + @l_colchange

				GOTO CX_ERROR_EXIT

		END

		FETCH	NEXT FROM cur

		INTO @colname, @coltype, @collength

		SELECT	@retVal = @@ERROR

		IF		@retVal != 0

		BEGIN

			print 'Failed to fetch next column name and type'

			GOTO CX_ERROR_EXIT

		END

	END

	set @retVal = 0

CX_ERROR_EXIT:

	close cur

	deallocate cur

return @retVal

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ConvertPKeyToUniqIdx.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'GetPrimaryConstraints')

    DROP PROCEDURE GetPrimaryConstraints 

	GO

CREATE PROCEDURE GetPrimaryConstraints (@ObjName varchar(128), @OutTableName varchar(64) = NULL)

AS

BEGIN

--DECLARE @ObjName	varchar(128)
--DECLARE @OutTableName	varchar(64)
	DECLARE @Debug		INTEGER

	SET NOCOUNT ON

	SET @Debug = 0

DECLARE 	@ObjID			int--the object ID of the table
,@CnstDes		nvarchar(4000)--string to build up index desc
,@CnstName		sysname--name of const. currently under consideration
			,@Count			int

			,@CnstID		int

			,@CnstType		character(2)

,@Keys			nvarchar(2126)--LENgth (16*max_identifierLENgth)+(15*2)+(16*3)
--Check to see IF the tabe exists AND initialize @ObjID.
	SELECT @ObjID = object_id(@ObjName)

	IF @ObjID IS NULL

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		RETURN -1

	END

	IF OBJECT_ID('tempdb.dbo.#TableConstraints') IS NOT NULL DROP TABLE #TableConstraints

--Create temp table
	CREATE TABLE #TableConstraints

	(

		TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
		,ConstraintType		INTEGER

		,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
	)

	IF (@Debug = 1)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#TableConstraintsOut') IS NOT NULL DROP TABLE #TableConstraintsOut

--Create temp table
		CREATE TABLE #TableConstraintsOut

		(

			TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
			,ConstraintType		INTEGER

			,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
		)

		SET @ObjName	= 'QSMAgent'

		SET @OutTableName = '#TableConstraintsOut'

	END

--STATIC CURSOR OVER THE TABLE'S CONSTRAINTS
	DECLARE ConstraintCursor CURSOR 

	LOCAL STATIC FOR

	SELECT id, xtype, name 

	FROM sysobjects 

	WHERE parent_obj = @ObjID

		AND xtype IN ('PK', 'UQ', 'D ')	-- ONLY 6.5 sysconstraints objects

	FOR READ ONLY

--Now check out each constraint, figure out its type AND keys and
--save the info IN a temporary table that we'll PRINT out at the END.
	OPEN ConstraintCursor

	FETCH ConstraintCursor INTO @CnstID, @CnstType, @CnstName

	WHILE @@FETCH_STATUS >= 0

	BEGIN

		IF @CnstType IN ('PK','UQ')

		BEGIN

--get IndID AND index description
			DECLARE @IdxID smallint

			SELECT	@IdxID = IndID,

					@CnstDes = CASE WHEN @CnstType = 'PK'

								THEN 'PRIMARY KEY' ELSE 'UNIQUE' END

							 + CASE WHEN (status & 16)=16

								THEN ' (clustered)' ELSE ' (non-clustered)' END

			FROM	sysindexes

			WHERE	name = Object_Name(@CnstID)

					AND ID = @ObjID

--FORmat keys string
DECLARE @ThisKey nvarchar(131)--128+3
			SELECT @Keys = Index_Col(@ObjName, @IdxID, 1), @Count = 2

			IF (IndexKey_Property(@ObjID, @IdxID, 1, 'isdescending') = 1)

				SELECT @Keys = @Keys  + '(-)'

			SELECT @ThisKey = Index_Col(@ObjName, @IdxID, @Count)

			IF ((@ThisKey IS NOT NULL) AND (IndexKey_Property(@ObjID, @IdxID, @Count, 'isdescending') = 1))

				SELECT @ThisKey = @ThisKey + '(-)'

			WHILE (@ThisKey IS NOT NULL)

			BEGIN

				SELECT @Keys = @Keys + ', ' + @ThisKey, @Count = @Count + 1

				SELECT @ThisKey = Index_Col(@ObjName, @IdxID, @Count)

				IF ((@ThisKey IS NOT NULL) AND (IndexKey_Property(@ObjID, @IdxID, @Count, 'isdescending') = 1))

					SELECT @ThisKey = @ThisKey + '(-)'

			END

--ADD TO TABLE
			INSERT INTO #TableConstraints

				(TableName, ConstraintTypeName, ConstraintName, ConstraintString, ConstraintType)

			values (@ObjName, @CnstDes, @CnstName, @Keys, CASE WHEN @CnstType = 'PK' THEN 1 WHEN @CnstType = 'UQ' THEN 2 ELSE 0 END)

		END

		ELSE

		IF (@CnstType = 'D ')

		BEGIN

			SELECT @Count = 1

			SELECT @CnstDes = TEXT FROM syscomments WHERE ID = @CnstID AND colID = @Count

			WHILE @CnstDes IS NOT NULL

			BEGIN

				IF @Count=1

					INSERT INTO	#TableConstraints

						(TableName, ConstraintTypeName, ConstraintName ,ConstraintString, ConstraintType)

					SELECT @ObjName, 'DEFAULT on column ' + col_name(@ObjID ,info),

						@CnstName ,SUBSTRING(@CnstDes,1,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

					FROM sysobjects WHERE ID = @CnstID

				ELSE

					INSERT INTO #TableConstraints (TableName, ConstraintTypeName, ConstraintName,ConstraintString, ConstraintType)

					SELECT	@ObjName, ' ', @CnstName, SUBSTRING(@CnstDes,1,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

				IF LEN(@CnstDes) > 2000

					INSERT INTO #TableConstraints (TableName, ConstraintTypeName, ConstraintName,ConstraintString, ConstraintType)

					SELECT	@ObjName, ' ', @CnstName, SUBSTRING(@CnstDes,2001,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

				SELECT @Count = @Count + 1

				SELECT @CnstDes = NULL

				SELECT @CnstDes = TEXT FROM syscomments WHERE ID = @CnstID AND colID = @Count

			END

		END

		FETCH ConstraintCursor INTO @CnstID, @CnstType, @CnstName

END--of major loop
	DEALLOCATE ConstraintCursor

	IF (@OutTableName IS NOT NULL)

	BEGIN

		EXEC (

			'INSERT INTO ' + @OutTableName + 

			' SELECT * FROM #TableConstraints'

		)

	END

	ELSE

	BEGIN

		SELECT * FROM #TableConstraints

	END

	DROP TABLE #TableConstraints

	IF (@Debug = 1)

	BEGIN

		EXEC ('SELECT * FROM ' + @OutTableName)

		EXEC ('DROP TABLE ' + @OutTableName)

	END

END

	GO

--IF OBJECT_ID('tempdb.dbo.#PrimaryConsts') IS NOT NULL DROP TABLE #PrimaryConsts
--
---- Create temp table
--CREATE TABLE #PrimaryConsts
--(
--TableName		sysname
--,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL   -- 128 FOR name + TEXT FOR DEFAULT
--,ConstraintType		INTEGER
--,ConstraintName		sysname		COLLATE Database_Default NOT NULL
--,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL	-- see @Keys above FOR LENgth descr
--)
--
--EXEC dbo.GetPrimaryConstraints 'CHJobBkpAttemptHistory', #PrimaryConsts
--
--SELECT * FROM #PrimaryConsts
--
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'GetForeignKeys')

    DROP PROCEDURE GetForeignKeys 

	GO

CREATE PROCEDURE GetForeignKeys (@ObjName varchar(128), @OutTableName varchar(64) = NULL)

AS

BEGIN

--DECLARE @ObjName	varchar(128)
--DECLARE @OutTableName	varchar(64)
	DECLARE @Debug		INTEGER

	SET NOCOUNT ON

--SET @Debug = 1
	DECLARE @PKTable	SYSNAME

	DECLARE @FKTable	SYSNAME

	DECLARE @PKColumn	SYSNAME

	DECLARE @FKColumn	SYSNAME

	DECLARE @FKeyName	VARCHAR(255)

	DECLARE @UpdRule	INTEGER

	DECLARE @DelRule	INTEGER

	DECLARE @PKeyString	VARCHAR(255)

	DECLARE @FKeyString	VARCHAR(255)

	IF (OBJECT_ID(@ObjName) IS NULL)

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		return -1

	END

	IF object_id('tempdb.dbo.#SP_FKeysOut') is not null DROP TABLE #SP_FKeysOut

	IF object_id('tempdb.dbo.#RelationShips') is not null DROP TABLE #RelationShips

	CREATE TABLE #SP_FKeysOut

	(

	    PKTABLE_QUALIFIER	varchar(255),

	    PKTABLE_OWNER	varchar(255),

	    PKTABLE_NAME	varchar(255),

	    PKCOLUMN_NAME	varchar(255),

	    FKTABLE_QUALIFIER	varchar(255),

	    FKTABLE_OWNER	varchar(255),

	    FKTABLE_NAME	varchar(255),

	    FKCOLUMN_NAME	varchar(255),

	    KEY_SEQ		int,

	    UPDATE_RULE		int,

	    DELETE_RULE		int,

	    FK_NAME		varchar(255),

	    PK_NAME		varchar(255),

	    DEFERRABILITY	varchar(255)

	)

	CREATE TABLE #RelationShips

	(

		PKTable		varchar(255),

		PKeyString	varchar(512),

		FKTable		varchar(255),

		FKeyString	varchar(512),

		FKeyName	varchar(255),

		DropFKQuery	varchar(1024),

		AddFKQuery	varchar(1024),

	)

	IF (@Debug = 1)

	BEGIN

		IF object_id('tempdb.dbo.#RelationShipsOut') is not null DROP TABLE #RelationShipsOut

		SET @ObjName		= 'CHJobBkpHistory'

		SET @OutTableName	= '#RelationshipsOut'

		CREATE TABLE #RelationShipsOut

		(

			PKTable		varchar(255),

			PKeyString	varchar(512),

			FKTable		varchar(255),

			FKeyString	varchar(512),

			FKeyName	varchar(255),

			DropFKQuery	varchar(1024),

			AddFKQuery	varchar(1024),

		)

	END

	INSERT INTO  #SP_FKeysOut

	EXEC  sp_fkeys @pktable_name=@ObjName

	DECLARE PTable CURSOR

	FOR

	SELECT DISTINCT PKTABLE_NAME, FKTABLE_NAME, FK_NAME, UPDATE_RULE, DELETE_RULE

	FROM #SP_FKeysOut

	OPEN PTable

	FETCH PTable INTO @PKTable, @FKTable, @FKeyName, @UpdRule, @DelRule

	WHILE @@FETCH_STATUS >= 0

	BEGIN

		SET @PKeyString = ''

		SET @FKeyString = ''

		DECLARE PKeys CURSOR 

		FOR

		SELECT PKCOLUMN_NAME, FKCOLUMN_NAME 

		FROM #SP_FKeysOut

		WHERE PKTABLE_NAME = @PKTable

			AND FKTABLE_NAME = @FKTable

		ORDER BY KEY_SEQ ASC

		OPEN PKeys

		FETCH PKeys INTO @PKColumn, @FKColumn

		WHILE @@FETCH_STATUS >= 0

		BEGIN

			SET @PKeyString = CASE WHEN @PKeyString = '' THEN @PKColumn ELSE @PKeyString + ', ' + @PKColumn END

			SET @FKeyString = CASE WHEN @FKeyString = '' THEN @FKColumn ELSE @FKeyString + ', ' + @FKColumn END

			FETCH PKeys INTO @PKColumn, @FKColumn

		END

		CLOSE PKeys

		DEALLOCATE PKeys

		INSERT INTO #RelationShips VALUES (@PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName,

			'ALTER TABLE ' + @FKTABLE + ' DROP ' + @FKeyName,

			'ALTER TABLE ' + @FKTABLE + ' ADD FOREIGN KEY (' + @FKeyString + ') REFERENCES ' + @PKTable + '(' + @PKeyString + ')' + CASE @UpdRule WHEN 0 THEN ' ON UPDATE CASCADE ' ELSE '' END + + CASE @DelRule WHEN 0 THEN ' ON DELETE CASCADE ' ELSE '' END

		)

		FETCH PTable INTO @PKTable, @FKTable, @FKeyName, @UpdRule, @DelRule

	END

	CLOSE PTable

	DEALLOCATE PTable

	IF (@OutTableName IS NOT NULL)

	BEGIN

		EXEC (

			'INSERT INTO ' + @OutTableName + 

			' SELECT * FROM #Relationships'

		)

	END

	ELSE

	BEGIN

		SELECT * FROM #Relationships

	END

	DROP TABLE #SP_FKeysOut

	DROP TABLE #RelationShips

	IF (@Debug = 1)

	BEGIN

		EXEC ('SELECT * FROM ' + @OutTableName)

		EXEC ('DROP TABLE ' + @OutTableName)

	END

END

	GO

--IF object_id('tempdb.dbo.#FKeys') is not null DROP TABLE #FKeys
--
--CREATE TABLE #FKeys
--(
--PKTable		varchar(255),
--PKeyString	varchar(512),
--FKTable		varchar(255),
--FKeyString	varchar(512),
--FKeyName	varchar(255),
--DropFKQuery	varchar(1024),
--AddFKQuery	varchar(1024),
--)
--
--EXEC dbo.GetForeignKeys 'QSMAgent', '#FKeys'
--
--SELECT * FROM #FKeys
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'ConvertPrimaryKeyToUniqueIndex')

    DROP PROCEDURE ConvertPrimaryKeyToUniqueIndex 

	GO

CREATE PROCEDURE ConvertPrimaryKeyToUniqueIndex(@ObjName varchar(255))

AS

BEGIN

	SET NOCOUNT ON

	IF OBJECT_ID('tempdb.dbo.#PKeys') IS NOT NULL DROP TABLE #PKeys

	IF OBJECT_ID('tempdb.dbo.#FKeys') is not null DROP TABLE #FKeys

	DECLARE	@PKTable	varchar(255)

	DECLARE	@PKeyString	varchar(512)

	DECLARE	@FKTable	varchar(255)

	DECLARE	@FKeyString	varchar(512)

	DECLARE	@FKeyName	varchar(255)

	DECLARE	@DropFKQuery	varchar(1024)

	DECLARE	@AddFKQuery	varchar(1024)

	DECLARE	@TableName		sysname

	DECLARE	@ConstraintTypeName	nvarchar(146)

	DECLARE	@ConstraintType		INTEGER

	DECLARE	@ConstraintName		sysname

	DECLARE	@ConstraintString	nvarchar(1800)

	IF (OBJECT_ID(@ObjName) IS NULL)

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		RETURN -1

	END

--Create temp table
	CREATE TABLE #PKeys

	(

		TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
		,ConstraintType		INTEGER

		,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
	)

	CREATE TABLE #FKeys

	(

		PKTable		varchar(255),

		PKeyString	varchar(512),

		FKTable		varchar(255),

		FKeyString	varchar(512),

		FKeyName	varchar(255),

		DropFKQuery	varchar(1024),

		AddFKQuery	varchar(1024),

	)

	EXEC GetPrimaryConstraints @ObjName, '#PKeys'

	EXEC GetForeignKeys @ObjName, '#FKeys'

	IF ((SELECT Count(*) FROM #PKeys) = 0)

	BEGIN

		PRINT 'No Primary Constraints found for [' + @ObjName + '], so no change required.'

		RETURN -2

	END

	IF ((SELECT Count(*) FROM #FKeys) = 0)

		PRINT 'No Foreign Constraints found for [' + @ObjName + ']'

	DECLARE FKeyCursor CURSOR

	FOR

	SELECT * FROM #FKeys

	OPEN FKeycursor

	FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--DROP ALL FOREIGN KEYs to this table.
--SELECT @DropFKQuery
		PRINT 'Executing [' + @DropFKQuery + ']'

		EXEC (@DropFKQuery)

		FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	END

	CLOSE FKeyCursor

--Convert Primary Key to unique non-clustered index with the same set of columns as Primary key.
	DECLARE PKeyCursor CURSOR

	FOR

	SELECT TableName, ConstraintName, ConstraintType, ConstraintString FROM #PKeys

	WHERE ConstraintType IN (1, 2, 3)

	ORDER BY ConstraintType DESC

	OPEN PKeycursor

	FETCH PKeyCursor INTO @TableName, @ConstraintName, @ConstraintType, @ConstraintString

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--DROP ALL Default & Primary Key Constraints on this table.
--SELECT 'ALTER TABLE ' + @TableName + ' DROP ' + @ConstraintName
		PRINT 'Dropping ' + CASE @ConstraintType WHEN 1 THEN 'Primary' WHEN 2 THEN 'Unique' ELSE 'Default' END + ' Constraint [' + @ConstraintName + '] [' + @ConstraintString + ']'

		EXEC ('ALTER TABLE ' + @TableName + ' DROP ' + @ConstraintName)

		IF (@ConstraintType = 1)

		BEGIN

--Recreate Primary Key as a non-clustered Unique Index.
--SELECT 'CREATE UNIQUE NONCLUSTERED INDEX ' + @TableName + '_Idx ON ' + @TableName + '(' + @ConstraintString + ')'
			PRINT 'Adding Unique NonClustered Index [' + @ConstraintString + ']'

			EXEC ('CREATE UNIQUE NONCLUSTERED INDEX ' + @TableName + '_Idx ON ' + @TableName + '(' + @ConstraintString + ')')

		END

		FETCH PKeyCursor INTO @TableName, @ConstraintName, @ConstraintType, @ConstraintString

	END

	CLOSE PKeyCursor

	DEALLOCATE PKeyCursor

--Re-Create the Foreign keys
	OPEN FKeycursor

	FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--CREATE ALL FOREIGN KEYs back to this table.
--SELECT @AddFKQuery
		PRINT 'Executing [' + @AddFKQuery + ']'

		EXEC (@AddFKQuery)

		FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	END

	CLOSE FKeyCursor

	DEALLOCATE FKeyCursor

	DROP TABLE #PKeys

	DROP TABLE #FKeys

END

	GO

--EXEC ConvertPrimaryKeyToUniqueIndex 'Child'
--EXEC ConvertPrimaryKeyToUniqueIndex 'QSMSQLInstance'
--EXEC GetPrimaryConstraints 'QSMExchangeStorageGroup'
--EXEC GetForeignKeys 'QSMExchangeStorageGroup'
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/DBUpgradeSteps.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'DBUpgradeSteps')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'DBUpgradeSteps')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'DBUpgradeSteps'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'DBUpgradeSteps' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'DBUpgradeSteps' +'].'							
  END--   Get @oldRev, compare to '1.3'. Chk for work to do.
    IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DBUpgradeSteps' AND COLUMN_NAME = 'id')

	BEGIN

IF EXISTS (SELECT * FROM sysobjects				
  				WHERE type = 'U' and name = 'DBUpgradeSteps')	
  	BEGIN											
  		EXECUTE @retCode = cvsp_drop_pk 'DBUpgradeSteps'		
  		SET @sqlString = 'DROP TABLE ' + 'DBUpgradeSteps'		
  		EXEC sp_executesql @sqlString				
  		SET @sqlError = @@ERROR						
  		IF @sqlError = 0							
  		BEGIN										
  			DELETE FROM GXDBVersions WHERE name= 'DBUpgradeSteps'	
   PRINT 'RETVAL: 0  TABLE [' + 'DBUpgradeSteps'				+ '] successfully dropped.'			
  		END											
  		ELSE										
   PRINT 'RETVAL: 10 SQL Error: ' + CONVERT(CHAR(8), @sqlError)				+ ' [' + @sqlString + ']'			
  	END												
  	ELSE											
   PRINT 'RETVAL: 0  TABLE [' + 'DBUpgradeSteps'				+ '] already dropped.'
	END


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/TblCommon/DBUpgradeSteps.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--			 Copyright (c) 1998  CommVault Systems, Inc.

--					 All rights reserved.

--

--

--		 This is unpublished proprietary source code of CommVault

--		 Systems, Inc. The copyright notice above does not evidence

--		 any actual or intended publication of such source code.

--

--      Revisions  Author   Description

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblCommon/DBUpgradeSteps.tbl,v $ $Id: DBUpgradeSteps.tbl,v 1.3 2015/04/24 15:30:27 chandru Exp $";

print '... Creating Table: DBUpgradeSteps'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table DBUpgradeSteps (

	id INTEGER NOT NULL IDENTITY (1,1),

	Step varchar(1024)	NOT NULL,

	Status				nvarchar(MAX) NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [DBUpgradeSteps]''

END

--------





insert into GXDBVersions values(1, ''DBUpgradeSteps'',  ''1.3'', ''DBUpgradeSteps'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE DBUpgradeSteps ADD CONSTRAINT DBUpgradeSteps_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [DBUpgradeSteps]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'DBUpgradeSteps')			
  			insert into GXDBVersions VALUES(1, 'DBUpgradeSteps', '0.0', 'DBUpgradeSteps', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'DBUpgradeSteps'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'DBUpgradeSteps' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'DBUpgradeSteps' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/LicUsage.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'LicUsage')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'LicUsage')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'LicUsage'							
  END																			
  IF (@oldRev = '1.7')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'LicUsage' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'LicUsage' +'].'							
  END
--There is no change in table from 9-11.0
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'LicUsage' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'LU_CID_OpTimeUTC')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'LicUsage' +'].[' + 'LU_CID_OpTimeUTC' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'LicUsage' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = @parentID AND name = 'LU_CID')			
      BEGIN																								
  		SET @sqlString = 'CREATE NONCLUSTERED INDEX [' + 'LU_CID' +']' + 'ON [' + 'LicUsage' +']  (' + 'CId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'LicUsage')			
  			insert into GXDBVersions VALUES(1, 'LicUsage', '0.0', 'LicUsage', '')	
  			UPDATE GXDBVersions SET revision = '1.7' WHERE name = 'LicUsage'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'LicUsage' + '] upgraded successfully to '			+ ' revision [' + '1.7' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'LicUsage' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMDrive.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMDrive.upg,v 1.19 2014/04/20 02:51:23 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMDrive')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMDrive')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMDrive'							
  END																			
  IF (@oldRev = '1.52')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMDrive' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMDrive' +'].'							
  END--	 Get @oldRev, compare to '1.52'. Chk for work to do.
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDrive' AND COLUMN_NAME="RMResvRequestId")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMDrive' AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="RMResvRequestId")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = 'ALTER TABLE [' + 'MMDrive' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " DROP COLUMN "+"RMResvRequestId"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDrive' AND COLUMN_NAME="LSCSName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ADD "+"LSCSName" + " "+"nvarchar(256)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDrive' + " SET "+"LSCSName" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ALTER COLUMN "+"LSCSName" + " "+"nvarchar(256)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDrive' AND COLUMN_NAME="LSResStatus")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ADD "+"LSResStatus" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDrive' + " SET "+"LSResStatus" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ALTER COLUMN "+"LSResStatus" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDrive' AND COLUMN_NAME="LSResStr")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ADD "+"LSResStr" + " "+"nvarchar(max)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDrive' + " SET "+"LSResStr" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDrive' + " ALTER COLUMN "+"LSResStr" + " "+"nvarchar(max)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMDrive' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'origCCId')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'MMDrive' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMDrive' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'origDriveId')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'MMDrive' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMDrive')			
  			insert into GXDBVersions VALUES(1, 'MMDrive', '0.0', 'MMDrive', '')	
  			UPDATE GXDBVersions SET revision = '1.52' WHERE name = 'MMDrive'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMDrive' + '] upgraded successfully to '			+ ' revision [' + '1.52' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMDrive' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMExportLocation.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMExportLocation')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMExportLocation')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMExportLocation'							
  END																			
  IF (@oldRev = '1.17')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMExportLocation' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMExportLocation' +'].'							
  END-- Get @oldRev, compare to '1.17'. Chk for work to do.
IF"tinyint"!="integer"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMExportLocation' AND COLUMN_NAME="origCCId" AND DATA_TYPE="tinyint")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMExportLocation' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'MMExportLocation' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'MMExportLocation' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMExportLocation' + " ALTER COLUMN "+"origCCId" + " "+"integer"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'MMExportLocation' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'MMExportLocation' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMExportLocation' AND COLUMN_NAME="ModifiedTime")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMExportLocation' + " ADD "+"ModifiedTime" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMExportLocation' AND xType = 'U')						
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")		
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b										
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')							
  	SET @oldConstraintName = NULL																				
  	IF(@constId IS NOT NULL)																					
  	BEGIN																										
  	SELECT @oldConstraintName = (SELECT name FROM sysobjects WHERE id = @constId)								
  	SET @newConstraintName = "DF_"+"MMExportLocation" + "_"+"origCCId"					
  	IF(@oldConstraintName <> @newConstraintName)																
  	BEGIN																										
  		SET  @sqlString = "sp_rename '" + @oldConstraintName + "','" + @newConstraintName + "', 'object'"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  	END																											
  	END
	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMExportLocation' AND COLUMN_NAME = 'GUID' AND IS_NULLABLE = 'NO')

	BEGIN

		ALTER TABLE MMExportLocation ALTER COLUMN GUID DROP ROWGUIDCOL; 

IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMExportLocation' AND COLUMN_NAME="GUID" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMExportLocation' AND COLUMN_NAME="GUID" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMExportLocation' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="GUID")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMExportLocation' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMExportLocation' + " ALTER COLUMN "+"GUID" + " "+"uniqueidentifier"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMExportLocation' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"GUID"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
		ALTER TABLE MMExportLocation ALTER COLUMN GUID ADD ROWGUIDCOL;

	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMExportLocation' AND xType = 'U')						
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="GUID")		
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b										
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')							
  	SET @oldConstraintName = NULL																				
  	IF(@constId IS NOT NULL)																					
  	BEGIN																										
  	SELECT @oldConstraintName = (SELECT name FROM sysobjects WHERE id = @constId)								
  	SET @newConstraintName = "DF_"+"MMExportLocation" + "_"+"GUID"					
  	IF(@oldConstraintName <> @newConstraintName)																
  	BEGIN																										
  		SET  @sqlString = "sp_rename '" + @oldConstraintName + "','" + @newConstraintName + "', 'object'"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMExportLocation')			
  			insert into GXDBVersions VALUES(1, 'MMExportLocation', '0.0', 'MMExportLocation', '')	
  			UPDATE GXDBVersions SET revision = '1.17' WHERE name = 'MMExportLocation'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMExportLocation' + '] upgraded successfully to '			+ ' revision [' + '1.17' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMExportLocation' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMLibraryHostInfo.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMLibraryHostInfo.upg,v 1.6 2014/06/28 03:59:44 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMLibraryHostInfo')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMLibraryHostInfo')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMLibraryHostInfo'							
  END																			
  IF (@oldRev = '1.7')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMLibraryHostInfo' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMLibraryHostInfo' +'].'							
  END--	 Get @oldRev, compare to '1.7'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibraryHostInfo' AND COLUMN_NAME="HostClientId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMLibraryHostInfo' + " ADD "+"HostClientId" + " "+"INTEGER"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'MMLibraryHostInfo', @fromColumn = 'LibraryControllerId', @toTable = 'MMLibrary'
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMLibraryHostInfo')			
  			insert into GXDBVersions VALUES(1, 'MMLibraryHostInfo', '0.0', 'MMLibraryHostInfo', '')	
  			UPDATE GXDBVersions SET revision = '1.7' WHERE name = 'MMLibraryHostInfo'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMLibraryHostInfo' + '] upgraded successfully to '			+ ' revision [' + '1.7' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMLibraryHostInfo' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMasterPool.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMMasterPool.upg,v 1.10 2015/06/09 21:10:21 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMasterPool')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMasterPool')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMasterPool'							
  END																			
  IF (@oldRev = '1.12')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMasterPool' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMasterPool' +'].'							
  END--	 Get @oldRev, compare to '1.12'. Chk for work to do.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMasterPool' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMasterPool' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMasterPool' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origMasterPoolId")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMasterPool' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMasterPool')			
  			insert into GXDBVersions VALUES(1, 'MMMasterPool', '0.0', 'MMMasterPool', '')	
  			UPDATE GXDBVersions SET revision = '1.12' WHERE name = 'MMMasterPool'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMasterPool' + '] upgraded successfully to '			+ ' revision [' + '1.12' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMasterPool' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMContainer.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMContainer.upg,v 1.12 2015/06/24 21:41:23 abilbrey Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMContainer')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMContainer')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMContainer'							
  END																			
  IF (@oldRev = '1.12')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMContainer' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMContainer' +'].'							
  END--	 Get @oldRev, compare to '1.12'. Chk for work to do.
--Remove default constraint for SIDBStoreId
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMContainer' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'SIDBStoreId')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'MMContainer' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMContainer')			
  			insert into GXDBVersions VALUES(1, 'MMContainer', '0.0', 'MMContainer', '')	
  			UPDATE GXDBVersions SET revision = '1.12' WHERE name = 'MMContainer'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMContainer' + '] upgraded successfully to '			+ ' revision [' + '1.12' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMContainer' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMedia.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMMedia.upg,v 1.19 2015/06/09 21:10:30 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMedia')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMedia')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMedia'							
  END																			
  IF (@oldRev = '1.51')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMedia' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMedia' +'].'							
  END--	 Get @oldRev, compare to '1.51'. Chk for work to do.
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMedia' AND COLUMN_NAME='retentionExpireTime' AND DATA_TYPE='INT')

	BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMedia' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'retentionExpireTime')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'MMMedia' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF("INT"!="bigint")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMedia' AND COLUMN_NAME="retentionExpireTime" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMMedia' + " ALTER COLUMN "+"retentionExpireTime" + " "+"bigint"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMedia' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="ExtendedAttributes")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMedia' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMedia')			
  			insert into GXDBVersions VALUES(1, 'MMMedia', '0.0', 'MMMedia', '')	
  			UPDATE GXDBVersions SET revision = '1.51' WHERE name = 'MMMedia'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMedia' + '] upgraded successfully to '			+ ' revision [' + '1.51' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMedia' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMediaSide.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMMediaSide.upg,v 1.11 2015/06/19 22:58:09 gharidas Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMediaSide')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMediaSide')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMediaSide'							
  END																			
  IF (@oldRev = '1.16')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMediaSide' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMediaSide' +'].'							
  END--	 Get @oldRev, compare to '1.16'. Chk for work to do.
IF("INT"!="bigint")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMediaSide' AND COLUMN_NAME="TotalSpaceMB" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMMediaSide' + " ALTER COLUMN "+"TotalSpaceMB" + " "+"bigint"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF("INT"!="bigint")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMediaSide' AND COLUMN_NAME="FreeBytesMB" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMMediaSide' + " ALTER COLUMN "+"FreeBytesMB" + " "+"bigint"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMediaSide' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="UploadDataMB")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMediaSide' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMediaSide' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="DownloadDataMB")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMediaSide' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMediaSide')			
  			insert into GXDBVersions VALUES(1, 'MMMediaSide', '0.0', 'MMMediaSide', '')	
  			UPDATE GXDBVersions SET revision = '1.16' WHERE name = 'MMMediaSide'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMediaSide' + '] upgraded successfully to '			+ ' revision [' + '1.16' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMediaSide' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMLibrary.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMLibrary.upg,v 1.21 2015/05/22 13:52:12 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMLibrary')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMLibrary')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMLibrary'							
  END																			
  IF (@oldRev = '1.74')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMLibrary' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMLibrary' +'].'							
  END--	 Get @oldRev, compare to '1.74'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME="LibSvrConfig")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ADD "+"LibSvrConfig" + " "+"XML"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																										
  	END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME="LibSvrConfig" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME="LibSvrConfig" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMLibrary' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="LibSvrConfig")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMLibrary' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ALTER COLUMN "+"LibSvrConfig" + " "+"XML"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"LibSvrConfig"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME="WarningWaterMark")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ADD "+"WarningWaterMark" + " "+"INTEGER"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMLibrary' + " SET "+"WarningWaterMark" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ALTER COLUMN "+"WarningWaterMark" + " "+"INTEGER" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME = 'OutOfSpaceAlertInDays')
	BEGIN

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMLibrary' AND COLUMN_NAME="OutOfSpaceAlertInDays")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ADD "+"OutOfSpaceAlertInDays" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMLibrary' + " SET "+"OutOfSpaceAlertInDays" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMLibrary' + " ALTER COLUMN "+"OutOfSpaceAlertInDays" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
    	set @sqlString =  ' DECLARE @alertSetInDays	INT
				SET @alertSetInDays = 0
				IF EXISTS (SELECT * FROM MMConfigs WITH (NOLOCK) WHERE name = "MMCONFIG_DAYS_BEFORE_MAG_LIBRARY_IS_OUT_OF_SPACE")
				BEGIN
				    SELECT @alertSetInDays = value FROM MMConfigs WITH (NOLOCK) WHERE name = "MMCONFIG_DAYS_BEFORE_MAG_LIBRARY_IS_OUT_OF_SPACE"
				DELETE FROM MMConfigs WHERE name = "MMCONFIG_DAYS_BEFORE_MAG_LIBRARY_IS_OUT_OF_SPACE"
				END



				IF(@alertSetInDays > 0)
					UPDATE MMlibrary SET OutOfSpaceAlertInDays = @alertSetInDays where LibraryTypeId = 3'


IF ("" <> '')							
  		SET @sqlString = ""				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMLibrary')			
  			insert into GXDBVersions VALUES(1, 'MMLibrary', '0.0', 'MMLibrary', '')	
  			UPDATE GXDBVersions SET revision = '1.74' WHERE name = 'MMLibrary'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMLibrary' + '] upgraded successfully to '			+ ' revision [' + '1.74' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMLibrary' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMountPath.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMMountPath.upg,v 1.18 2015/05/21 14:16:59 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMountPath')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMountPath')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMountPath'							
  END																			
  IF (@oldRev = '1.40')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMountPath' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMountPath' +'].'							
  END--	 Get @oldRev, compare to '1.40'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMountPath' AND COLUMN_NAME="StagingMountPathId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMMountPath' + " ADD "+"StagingMountPathId" + " "+"INTEGER"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMMountPath' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="StagingMountPathId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'MMMountPath' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'MMMountPath' + '_'+"StagingMountPathId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'MMMountPath' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"StagingMountPathId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMountPath')			
  			insert into GXDBVersions VALUES(1, 'MMMountPath', '0.0', 'MMMountPath', '')	
  			UPDATE GXDBVersions SET revision = '1.40' WHERE name = 'MMMountPath'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMountPath' + '] upgraded successfully to '			+ ' revision [' + '1.40' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMountPath' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMNDMPVendorList.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMNDMPVendorList')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMNDMPVendorList')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMNDMPVendorList'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMNDMPVendorList' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMNDMPVendorList' +'].'							
  END-- Get @oldRev, compare to '1.1'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMNDMPVendorList]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMNDMPVendorList.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMNDMPVendorList.tbl,v $ $Id: MMNDMPVendorList.tbl,v 1.1 2014/09/10 22:49:18 chandru Exp $";

print '... Creating Table: MMNDMPVendorList'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMNDMPVendorList (

	MMNDMPVendorListId		integer NOT NULL,

	HostOsType			NVARCHAR(256)	NOT NULL,

	HostVersion			NVARCHAR(256)	NOT NULL,

	ServerVendor			NVARCHAR(256)	NOT NULL,

	ServerProduct			NVARCHAR(256)	NOT NULL,

	ServerRevision			NVARCHAR(256)	NOT NULL,

	Priority			integer	NOT NULL,

	OsType				integer	NOT NULL,

	Capabilities			integer	NOT NULL,

	GUIVendorName			NVARCHAR(256)	NOT NULL,

	FirmwareRevision		integer	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMNDMPVendorList]''

END

--------





insert into GXDBVersions values(1, ''MMNDMPVendorList'',  ''1.1'', ''MMNDMPVendorList'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMNDMPVendorList ADD CONSTRAINT MMNDMPVendorList_MMNDMPVendorListId_PK 		primary key (MMNDMPVendorListId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMNDMPVendorList]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMNDMPVendorList')			
  			insert into GXDBVersions VALUES(1, 'MMNDMPVendorList', '0.0', 'MMNDMPVendorList', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'MMNDMPVendorList'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMNDMPVendorList' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMNDMPVendorList' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMSpareGroup.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMSpareGroup.upg,v 1.8 2014/04/20 05:36:13 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMSpareGroup')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMSpareGroup')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMSpareGroup'							
  END																			
  IF (@oldRev = '1.23')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMSpareGroup' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMSpareGroup' +'].'							
  END--	 Get @oldRev, compare to '1.23'. Chk for work to do.
--Add missing default spare group -- 10.0
	INSERT INTO MMSpareGroup (SpareGroupName,LibraryId,

								LowWaterMark,SpareGroupType,

								LastUpdateTime,ExternalGUID,

								IsLowWaterMark,LowWaterMarkTime,

								HighWaterMark,Attributes,

								MediaTypeId,UsableSpareCountInLib,

								PrefferedRecordingFormatId

								)

	SELECT DISTINCT

							'Catalog Media', MSP1.LibraryId,

							-1, 128,

							dbo.GetUnixTime(GETDATE()),'',

							0, 0, 0, 0, 0, 0, 0

	FROM MMSpareGroup MSP1

	LEFT OUTER JOIN (SELECT DISTINCT LibraryId 

						FROM MMSpareGroup 

						WHERE SpareGroupType = 128) MSP2

				ON MSP1.LibraryId = MSP2.LibraryId

						WHERE 	MSP2.LibraryId  IS NULL

								AND MSP1.LibraryId > 0

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMSpareGroup')			
  			insert into GXDBVersions VALUES(1, 'MMSpareGroup', '0.0', 'MMSpareGroup', '')	
  			UPDATE GXDBVersions SET revision = '1.23' WHERE name = 'MMSpareGroup'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMSpareGroup' + '] upgraded successfully to '			+ ' revision [' + '1.23' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMSpareGroup' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMVolume.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMVolume.upg,v 1.11 2014/04/20 06:08:29 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMVolume')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMVolume')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMVolume'							
  END																			
  IF (@oldRev = '1.42')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMVolume' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMVolume' +'].'							
  END--	 Get @oldRev, compare to '1.42'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMVolume' AND COLUMN_NAME="FailureErrorCode")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMVolume' + " ADD "+"FailureErrorCode" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMVolume' + " SET "+"FailureErrorCode" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMVolume' + " ALTER COLUMN "+"FailureErrorCode" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMVolume' AND COLUMN_NAME="MMSpareStatus")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMVolume' + " ADD "+"MMSpareStatus" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMVolume' + " SET "+"MMSpareStatus" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMVolume' + " ALTER COLUMN "+"MMSpareStatus" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMVolume')			
  			insert into GXDBVersions VALUES(1, 'MMVolume', '0.0', 'MMVolume', '')	
  			UPDATE GXDBVersions SET revision = '1.42' WHERE name = 'MMVolume'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMVolume' + '] upgraded successfully to '			+ ' revision [' + '1.42' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMVolume' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMTapeCatalogJobInfo.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMTapeCatalogJobInfo.upg,v 1.5 2014/09/11 16:00:06 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMTapeCatalogJobInfo')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMTapeCatalogJobInfo')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMTapeCatalogJobInfo'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMTapeCatalogJobInfo' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMTapeCatalogJobInfo' +'].'							
  END-- Get @oldRev, compare to '1.1'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMTapeCatalogJobInfo]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMTapeCatalogJobInfo.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMTapeCatalogJobInfo.tbl,v $ $Id: MMTapeCatalogJobInfo.tbl,v 1.1 2010/11/19 18:25:03 smohanty Exp $";

--Artificially Bumped up the revision because of the lengths change

print '... Creating Table: MMTapeCatalogJobInfo'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMTapeCatalogJobInfo (

	jobId			integer	NOT NULL,	--Tape Catalog Job Id

	MediaId			integer	NOT NULL,

	xmlString		XML,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMTapeCatalogJobInfo]''

END

--------





insert into GXDBVersions values(1, ''MMTapeCatalogJobInfo'',  ''1.1'', ''MMTapeCatalogJobInfo'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMTapeCatalogJobInfo ADD CONSTRAINT MMTapeCatalogJobInfo_jobId_MediaId_PK 		primary key (jobId, MediaId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMTapeCatalogJobInfo]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMTapeCatalogJobInfo')			
  			insert into GXDBVersions VALUES(1, 'MMTapeCatalogJobInfo', '0.0', 'MMTapeCatalogJobInfo', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'MMTapeCatalogJobInfo'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMTapeCatalogJobInfo' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMTapeCatalogJobInfo' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMGRCSharedMA.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMGRCSharedMA')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMGRCSharedMA')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMGRCSharedMA'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMGRCSharedMA' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMGRCSharedMA' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMGRCSharedMA]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMGRCSharedMA.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMGRCSharedMA.tbl,v $ $Id: MMGRCSharedMA.tbl,v 1.1 2011/07/26 10:09:33 smohanty Exp $";

print '... Creating Table: MMGRCSharedMA'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMGRCSharedMA (

	commcellId			integer	NOT NULL,

	commcellGUID				nvarchar(40) NOT NULL,

	remoteClientId		integer	NOT NULL,

	localClientId		integer	NOT NULL,

	remoteClientName				nvarchar(255) NOT NULL,

	flags				integer default 0	NOT NULL,

	ReserveField1		integer default 0	NOT NULL,

	ReserveField2		integer default 0	NOT NULL,

	ReserveFieldStr				nvarchar(255) default '''' NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMGRCSharedMA]''

END

--------



insert into GXDBVersions values(1, ''MMGRCSharedMA'',  ''1.1'', ''MMGRCSharedMA'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMGRCSharedMA')			
  			insert into GXDBVersions VALUES(1, 'MMGRCSharedMA', '0.0', 'MMGRCSharedMA', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMGRCSharedMA'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMGRCSharedMA' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMGRCSharedMA' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMDataTransferRequest.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMDataTransferRequest.upg,v 1.2 2014/04/19 18:26:03 chandru Exp $

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMDataTransferRequest]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMDataTransferRequest.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMDataTransferRequest.tbl,v $ $Id: MMDataTransferRequest.tbl,v 1.1 2012/02/21 15:05:25 mklose Exp $";

print '... Creating Table: MMDataTransferRequest'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMDataTransferRequest (

	TransferId               	INTEGER NOT NULL IDENTITY (1,1),			-- PRIMARY KEY.

	JobId				integer	NOT NULL,

	Flags				integer	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserveFieldStr			nvarchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMDataTransferRequest]''

END

--------





insert into GXDBVersions values(1, ''MMDataTransferRequest'',  ''1.1'', ''MMDataTransferRequest'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMDataTransferRequest ADD CONSTRAINT MMDataTransferRequest_TransferId_PK 		primary key (TransferId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferRequest]''

END

----------


')
END
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMDataTransferRequest')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMDataTransferRequest')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMDataTransferRequest'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMDataTransferRequest' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMDataTransferRequest' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMDataTransferRequest]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMDataTransferRequest.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMDataTransferRequest.tbl,v $ $Id: MMDataTransferRequest.tbl,v 1.1 2012/02/21 15:05:25 mklose Exp $";

print '... Creating Table: MMDataTransferRequest'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMDataTransferRequest (

	TransferId               	INTEGER NOT NULL IDENTITY (1,1),			-- PRIMARY KEY.

	JobId				integer	NOT NULL,

	Flags				integer	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserveFieldStr			nvarchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMDataTransferRequest]''

END

--------





insert into GXDBVersions values(1, ''MMDataTransferRequest'',  ''1.1'', ''MMDataTransferRequest'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMDataTransferRequest ADD CONSTRAINT MMDataTransferRequest_TransferId_PK 		primary key (TransferId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferRequest]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMDataTransferRequest')			
  			insert into GXDBVersions VALUES(1, 'MMDataTransferRequest', '0.0', 'MMDataTransferRequest', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMDataTransferRequest'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMDataTransferRequest' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMDataTransferRequest' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMDataTransferStreams.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMDataTransferStreams.upg,v 1.3 2014/04/19 18:26:03 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMDataTransferStreams')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMDataTransferStreams')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMDataTransferStreams'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMDataTransferStreams' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMDataTransferStreams' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMDataTransferStreams]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMDataTransferStreams.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMDataTransferStreams.tbl,v $ $Id: MMDataTransferStreams.tbl,v 1.2 2014/02/26 13:24:14 mklose Exp $";

print '... Creating Table: MMDataTransferStreams'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMDataTransferStreams (

	TransferStreamId		INTEGER NOT NULL IDENTITY (1,1),			-- PRIMARY KEY

	TransferId			integer	NOT NULL,	-- REFERENCES TransferId in MMDataTransferRequest Table.

	SourceMAClientId		integer	NOT NULL,

	TargetMAClientId		integer	NOT NULL,

	BytesToCopy			bigint	NOT NULL,

	BytesCopied			bigint	NOT NULL,

	CurrentTransferSpeed		integer	NOT NULL,

	StreamStatus			integer	NOT NULL,

	PercentVerified			integer	NOT NULL,

	Flags				integer	NOT NULL,

	LastUpdateTime			integer	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserveFieldStr			nvarchar(1024)	NOT NULL,

	TotalNumberOfFiles		integer	NOT NULL,

	NumberOfFilesProcessed	integer	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMDataTransferStreams]''

END

--------





insert into GXDBVersions values(1, ''MMDataTransferStreams'',  ''1.2'', ''MMDataTransferStreams'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMDataTransferStreams ADD CONSTRAINT MMDataTransferStreams_TransferStreamId_PK 		primary key (TransferStreamId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferStreams]''

END

----------

ALTER TABLE MMDataTransferStreams  ADD CONSTRAINT MMDataTransferStreams_TransferId_FK	foreign key (TransferId)references	 MMDataTransferRequest(TransferId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferStreams]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreams' AND COLUMN_NAME = 'TotalNumberOfFiles')
	BEGIN

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreams' AND COLUMN_NAME="TotalNumberOfFiles")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreams' + " ADD "+"TotalNumberOfFiles" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDataTransferStreams' + " SET "+"TotalNumberOfFiles" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreams' + " ALTER COLUMN "+"TotalNumberOfFiles" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreams' AND COLUMN_NAME="NumberOfFilesProcessed")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreams' + " ADD "+"NumberOfFilesProcessed" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDataTransferStreams' + " SET "+"NumberOfFilesProcessed" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreams' + " ALTER COLUMN "+"NumberOfFilesProcessed" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF ('update MMDataTransferStreams set TotalNumberOfFiles = ReserveField1, NumberOfFilesProcessed = ReserveField2, ReserveField1 = 0, ReserveField2 = 0 ' <> '')							
  		SET @sqlString = 'update MMDataTransferStreams set TotalNumberOfFiles = ReserveField1, NumberOfFilesProcessed = ReserveField2, ReserveField1 = 0, ReserveField2 = 0 '				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMDataTransferStreams')			
  			insert into GXDBVersions VALUES(1, 'MMDataTransferStreams', '0.0', 'MMDataTransferStreams', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMDataTransferStreams'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMDataTransferStreams' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMDataTransferStreams' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMDataTransferStreamToFiles.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMDataTransferStreamToFiles.upg,v 1.3 2014/04/19 18:26:03 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMDataTransferStreamToFiles')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMDataTransferStreamToFiles')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMDataTransferStreamToFiles'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMDataTransferStreamToFiles' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMDataTransferStreamToFiles' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMDataTransferStreamToFiles]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMDataTransferStreamToFiles.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMDataTransferStreamToFiles.tbl,v $ $Id: MMDataTransferStreamToFiles.tbl,v 1.2 2014/02/26 13:35:45 mklose Exp $";

print '... Creating Table: MMDataTransferStreamToFiles'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMDataTransferStreamToFiles (

	TransferStreamId        integer	NOT NULL,	-- REFERENCES TransferStreamId in MMDataTransferStreams table.

	FileName		varchar(1024)	NOT NULL,

	FileType		integer	NOT NULL,

	ReserveField1		integer	NOT NULL,

	ReserveField2		integer	NOT NULL,

	ReserveFieldStr		nvarchar(1024)	NOT NULL,

	DDBSourcePath	varchar(1024)	NOT NULL,

	DDBTargetPath	varchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMDataTransferStreamToFiles]''

END

--------





insert into GXDBVersions values(1, ''MMDataTransferStreamToFiles'',  ''1.2'', ''MMDataTransferStreamToFiles'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMDataTransferStreamToFiles ADD CONSTRAINT MMDataTransferStreamToFiles_TransferStreamId_PK 		primary key (TransferStreamId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferStreamToFiles]''

END

----------

ALTER TABLE MMDataTransferStreamToFiles  ADD CONSTRAINT MMDataTransferStreamToFiles_TransferStreamId_FK	foreign key (TransferStreamId)references	 MMDataTransferStreams(TransferStreamId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDataTransferStreamToFiles]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreamToFiles' AND COLUMN_NAME = 'DDBSourcePath')
	BEGIN

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreamToFiles' AND COLUMN_NAME="DDBSourcePath")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreamToFiles' + " ADD "+"DDBSourcePath" + " "+"VARCHAR(1024)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDataTransferStreamToFiles' + " SET "+"DDBSourcePath" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreamToFiles' + " ALTER COLUMN "+"DDBSourcePath" + " "+"VARCHAR(1024)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMDataTransferStreamToFiles' AND COLUMN_NAME="DDBTargetPath")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreamToFiles' + " ADD "+"DDBTargetPath" + " "+"VARCHAR(1024)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMDataTransferStreamToFiles' + " SET "+"DDBTargetPath" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMDataTransferStreamToFiles' + " ALTER COLUMN "+"DDBTargetPath" + " "+"VARCHAR(1024)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF ('update MMDataTransferStreamToFiles set DDBSourcePath = FileName,DDBTargetPath = CONVERT(VARCHAR(1024),ReserveFieldStr), FileName = '''', ReserveFieldStr = N'''' ' <> '')							
  		SET @sqlString = 'update MMDataTransferStreamToFiles set DDBSourcePath = FileName,DDBTargetPath = CONVERT(VARCHAR(1024),ReserveFieldStr), FileName = '''', ReserveFieldStr = N'''' '				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMDataTransferStreamToFiles')			
  			insert into GXDBVersions VALUES(1, 'MMDataTransferStreamToFiles', '0.0', 'MMDataTransferStreamToFiles', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMDataTransferStreamToFiles'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMDataTransferStreamToFiles' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMDataTransferStreamToFiles' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMSIDBSubStoreToTransferStream.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMSIDBSubStoreToTransferStream.upg,v 1.3 2014/04/20 05:36:13 chandru Exp $

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMSIDBSubStoreToTransferStream]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMSIDBSubStoreToTransferStream.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMSIDBSubStoreToTransferStream.tbl,v $ $Id: MMSIDBSubStoreToTransferStream.tbl,v 1.4 2014/02/26 13:47:18 mklose Exp $";

print '... Creating Table: MMSIDBSubStoreToTransferStream'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMSIDBSubStoreToTransferStream (

	SubStoreId				integer	NOT NULL,	-- REFERENCES	subStoreId in IdxSIDBSubStore

	CommcellId				integer	NOT NULL,	-- REFERENCES	id in APP_Commcell

	JobId					integer	NOT NULL,

	TransferStreamId		integer	NOT NULL,	-- REFERENCES	TransferStreamId in MMDataTransferStreams

	TargetMAClientId		integer	NOT NULL,	-- REFERENCES	ClientId in MMHost

	TargetStorePath			varchar(1024)	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserverString			nvarchar(1024)	NOT NULL,

	SIDBStoreID				integer	NOT NULL,

	ddbJobStatus			integer	NOT NULL,

	ddbOperationString		varchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMSIDBSubStoreToTransferStream]''

END

--------





insert into GXDBVersions values(1, ''MMSIDBSubStoreToTransferStream'',  ''1.4'', ''MMSIDBSubStoreToTransferStream'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMSIDBSubStoreToTransferStream  ADD CONSTRAINT MMSIDBSubStoreToTransferStream_TargetMAClientId_FK	foreign key (TargetMAClientId)references	 MMHost(ClientId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMSIDBSubStoreToTransferStream]''

END

----------

ALTER TABLE MMSIDBSubStoreToTransferStream  ADD CONSTRAINT MMSIDBSubStoreToTransferStream_TransferStreamId_FK	foreign key (TransferStreamId)references	 MMDataTransferStreams(TransferStreamId) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMSIDBSubStoreToTransferStream]''

END

----------


')
END
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMSIDBSubStoreToTransferStream')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMSIDBSubStoreToTransferStream')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMSIDBSubStoreToTransferStream'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMSIDBSubStoreToTransferStream' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMSIDBSubStoreToTransferStream' +'].'							
  END--	 Get @oldRev, compare to '1.4'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMSIDBSubStoreToTransferStream]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMSIDBSubStoreToTransferStream.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMSIDBSubStoreToTransferStream.tbl,v $ $Id: MMSIDBSubStoreToTransferStream.tbl,v 1.4 2014/02/26 13:47:18 mklose Exp $";

print '... Creating Table: MMSIDBSubStoreToTransferStream'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMSIDBSubStoreToTransferStream (

	SubStoreId				integer	NOT NULL,	-- REFERENCES	subStoreId in IdxSIDBSubStore

	CommcellId				integer	NOT NULL,	-- REFERENCES	id in APP_Commcell

	JobId					integer	NOT NULL,

	TransferStreamId		integer	NOT NULL,	-- REFERENCES	TransferStreamId in MMDataTransferStreams

	TargetMAClientId		integer	NOT NULL,	-- REFERENCES	ClientId in MMHost

	TargetStorePath			varchar(1024)	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserverString			nvarchar(1024)	NOT NULL,

	SIDBStoreID				integer	NOT NULL,

	ddbJobStatus			integer	NOT NULL,

	ddbOperationString		varchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMSIDBSubStoreToTransferStream]''

END

--------





insert into GXDBVersions values(1, ''MMSIDBSubStoreToTransferStream'',  ''1.4'', ''MMSIDBSubStoreToTransferStream'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMSIDBSubStoreToTransferStream  ADD CONSTRAINT MMSIDBSubStoreToTransferStream_TargetMAClientId_FK	foreign key (TargetMAClientId)references	 MMHost(ClientId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMSIDBSubStoreToTransferStream]''

END

----------

ALTER TABLE MMSIDBSubStoreToTransferStream  ADD CONSTRAINT MMSIDBSubStoreToTransferStream_TransferStreamId_FK	foreign key (TransferStreamId)references	 MMDataTransferStreams(TransferStreamId) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMSIDBSubStoreToTransferStream]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMSIDBSubStoreToTransferStream' AND COLUMN_NAME="SIDBStoreID")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ADD "+"SIDBStoreID" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMSIDBSubStoreToTransferStream' + " SET "+"SIDBStoreID" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ALTER COLUMN "+"SIDBStoreID" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMSIDBSubStoreToTransferStream' AND COLUMN_NAME="ddbJobStatus")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ADD "+"ddbJobStatus" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMSIDBSubStoreToTransferStream' + " SET "+"ddbJobStatus" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ALTER COLUMN "+"ddbJobStatus" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMSIDBSubStoreToTransferStream' AND COLUMN_NAME="ddbOperationString")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ADD "+"ddbOperationString" + " "+"VARCHAR(1024)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMSIDBSubStoreToTransferStream' + " SET "+"ddbOperationString" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMSIDBSubStoreToTransferStream' + " ALTER COLUMN "+"ddbOperationString" + " "+"VARCHAR(1024)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
--this table gets cleaned up by ddb move cleanup thread, so if we are upgrading while there are entries present, we have to copy and reset them.
IF ('update MMSIDBSubStoreToTransferStream set SIDBStoreID = ReserveField1, ddbJobStatus = ReserveField2, ddbOperationString = CONVERT(VARCHAR(1024),ReserverString),ReserveField1 = 0,ReserveField2 = 0,ReserverString = N'''' ' <> '')							
  		SET @sqlString = 'update MMSIDBSubStoreToTransferStream set SIDBStoreID = ReserveField1, ddbJobStatus = ReserveField2, ddbOperationString = CONVERT(VARCHAR(1024),ReserverString),ReserveField1 = 0,ReserveField2 = 0,ReserverString = N'''' '				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMSIDBSubStoreToTransferStream')			
  			insert into GXDBVersions VALUES(1, 'MMSIDBSubStoreToTransferStream', '0.0', 'MMSIDBSubStoreToTransferStream', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'MMSIDBSubStoreToTransferStream'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMSIDBSubStoreToTransferStream' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMSIDBSubStoreToTransferStream' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMDiskPerformanceTest.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMDiskPerformanceTest')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMDiskPerformanceTest')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMDiskPerformanceTest'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMDiskPerformanceTest' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMDiskPerformanceTest' +'].'							
  END--	 Get @oldRev, compare to '1.1'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMDiskPerformanceTest]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMDiskPerformanceTest.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMDiskPerformanceTest.tbl,v $ $Id: MMDiskPerformanceTest.tbl,v 1.1 2012/05/23 16:28:07 mklose Exp $";

print '... Creating Table: MMDiskPerformanceTest'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMDiskPerformanceTest (

	PerformanceTestId			INTEGER NOT NULL IDENTITY (1,1),

	JobId						integer	NOT NULL,

	CommcellId					integer	NOT NULL,

	MediaAgentId				integer	NOT NULL,

	MountPoint					varchar(1024)	NOT NULL,

	ResultUpdateTime			integer	NOT NULL,

	TotalTestRunTime			integer	NOT NULL,

	ReadIOPS					integer	NOT NULL,

	WriteIOPS					integer	NOT NULL,

	ReadMBPS					integer	NOT NULL,

	WriteMBPS					integer	NOT NULL,

	TotalIOPS					integer	NOT NULL,

	TotalMBPS					integer	NOT NULL,

	Status 						integer	NOT NULL,	--running or completed or error.

	Flags						integer	NOT NULL,

	TestStartTime				integer	NOT NULL,

	ReserveField1				integer	NOT NULL,

	ReserveField2				integer	NOT NULL,

	ReserverString				nvarchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMDiskPerformanceTest]''

END

--------





insert into GXDBVersions values(1, ''MMDiskPerformanceTest'',  ''1.1'', ''MMDiskPerformanceTest'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMDiskPerformanceTest ADD CONSTRAINT MMDiskPerformanceTest_PerformanceTestId_PK 		primary key (PerformanceTestId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDiskPerformanceTest]''

END

----------

ALTER TABLE MMDiskPerformanceTest  ADD CONSTRAINT MMDiskPerformanceTest_CommcellId_FK	foreign key (CommcellId)references	 APP_CommCell(id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDiskPerformanceTest]''

END

----------

ALTER TABLE MMDiskPerformanceTest  ADD CONSTRAINT MMDiskPerformanceTest_MediaAgentId_FK	foreign key (MediaAgentId)references	 MMHost(ClientId) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMDiskPerformanceTest]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMDiskPerformanceTest')			
  			insert into GXDBVersions VALUES(1, 'MMDiskPerformanceTest', '0.0', 'MMDiskPerformanceTest', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'MMDiskPerformanceTest'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMDiskPerformanceTest' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMDiskPerformanceTest' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMSubstoreToDiskPerf.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMSubstoreToDiskPerf')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMSubstoreToDiskPerf')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMSubstoreToDiskPerf'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMSubstoreToDiskPerf' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMSubstoreToDiskPerf' +'].'							
  END--	 Get @oldRev, compare to '1.1'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMSubstoreToDiskPerf]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMSubstoreToDiskPerf.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMSubstoreToDiskPerf.tbl,v $ $Id: MMSubstoreToDiskPerf.tbl,v 1.1 2012/05/23 16:28:07 mklose Exp $";

print '... Creating Table: MMSubstoreToDiskPerf'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMSubstoreToDiskPerf (

	SIDBStoreId					integer	NOT NULL,

	CommcellId					integer	NOT NULL,

	SubStoreId					integer	NOT NULL,

	PerformanceTestId			integer	NOT NULL,

	ReserveField1			integer	NOT NULL,

	ReserveField2			integer	NOT NULL,

	ReserverString			nvarchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMSubstoreToDiskPerf]''

END

--------





insert into GXDBVersions values(1, ''MMSubstoreToDiskPerf'',  ''1.1'', ''MMSubstoreToDiskPerf'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMSubstoreToDiskPerf  ADD CONSTRAINT MMSubstoreToDiskPerf_PerformanceTestId_FK	foreign key (PerformanceTestId)references	 MMDiskPerformanceTest(PerformanceTestId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMSubstoreToDiskPerf]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMSubstoreToDiskPerf')			
  			insert into GXDBVersions VALUES(1, 'MMSubstoreToDiskPerf', '0.0', 'MMSubstoreToDiskPerf', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'MMSubstoreToDiskPerf'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMSubstoreToDiskPerf' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMSubstoreToDiskPerf' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMountPathMove.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMountPathMove')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMountPathMove')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMountPathMove'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMountPathMove' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMountPathMove' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMMountPathMove]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMMountPathMove.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMMountPathMove.tbl,v $ $Id: MMMountPathMove.tbl,v 1.2 2014/12/03 21:34:33 mklose Exp $";

print '... Creating Table: MMMountPathMove'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMMountPathMove (

	MoveId             	INTEGER NOT NULL IDENTITY (1,1),			-- PRIMARY KEY.

	JobId				integer	NOT NULL,

	StreamId			integer	NOT NULL,

	PhaseId				integer	NOT NULL,

	Flags				integer	NOT NULL,

	Status				integer	NOT NULL,

	ReserveField		integer	NOT NULL,

	ReserveString		varchar(1024)	NOT NULL,

	DeviceId		integer	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMMountPathMove]''

END

--------





insert into GXDBVersions values(1, ''MMMountPathMove'',  ''1.2'', ''MMMountPathMove'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMMountPathMove ADD CONSTRAINT MMMountPathMove_MoveId_PK 		primary key (MoveId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMMountPathMove]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMMountPathMove' AND COLUMN_NAME="DeviceId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'MMMountPathMove' + " ADD "+"DeviceId" + " "+"integer"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'MMMountPathMove' + " SET "+"DeviceId" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'MMMountPathMove' + " ALTER COLUMN "+"DeviceId" + " "+"integer" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMountPathMove')			
  			insert into GXDBVersions VALUES(1, 'MMMountPathMove', '0.0', 'MMMountPathMove', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMMountPathMove'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMountPathMove' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMountPathMove' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMMPMovePhaseToVolume.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMMPMovePhaseToVolume')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMMPMovePhaseToVolume')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMMPMovePhaseToVolume'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMMPMovePhaseToVolume' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMMPMovePhaseToVolume' +'].'							
  END--	 Get @oldRev, compare to '1.1'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMMPMovePhaseToVolume]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMMPMovePhaseToVolume.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMMPMovePhaseToVolume.tbl,v $ $Id: MMMPMovePhaseToVolume.tbl,v 1.1 2014/11/11 07:14:57 mklose Exp $";

print '... Creating Table: MMMPMovePhaseToVolume'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMMPMovePhaseToVolume (

	MoveId             	integer	NOT NULL,	-- PRIMARY KEY.

	VolumeId			integer	NOT NULL,

	Flags				integer	NOT NULL,

	ReserveField1		integer	NOT NULL,

	ReserveString		varchar(1024)	NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMMPMovePhaseToVolume]''

END

--------





insert into GXDBVersions values(1, ''MMMPMovePhaseToVolume'',  ''1.1'', ''MMMPMovePhaseToVolume'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE MMMPMovePhaseToVolume  ADD CONSTRAINT MMMPMovePhaseToVolume_MoveId_FK	foreign key (MoveId)references	 MMMountPathMove(MoveId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [MMMPMovePhaseToVolume]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMMPMovePhaseToVolume')			
  			insert into GXDBVersions VALUES(1, 'MMMPMovePhaseToVolume', '0.0', 'MMMPMovePhaseToVolume', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'MMMPMovePhaseToVolume'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMMPMovePhaseToVolume' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMMPMovePhaseToVolume' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMTmpCIAFilesToPruneFromCIAgedTbl.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: MMTmpCIAFilesToPruneFromCIAgedTbl.upg,v 1.2 2015/05/28 15:40:36 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMTmpCIAFilesToPruneFromCIAgedTbl')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMTmpCIAFilesToPruneFromCIAgedTbl' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMTmpCIAFilesToPruneFromCIAgedTbl' +'].'							
  END-- Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[MMTmpCIAFilesToPruneFromCIAgedTbl]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/MMTmpCIAFilesToPruneFromCIAgedTbl.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/MMTmpCIAFilesToPruneFromCIAgedTbl.tbl,v $ $Id: MMTmpCIAFilesToPruneFromCIAgedTbl.tbl,v 1.2 2015/05/28 15:40:45 chandru Exp $";

print '... Creating Table: MMTmpCIAFilesToPruneFromCIAgedTbl'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table MMTmpCIAFilesToPruneFromCIAgedTbl (

	AFileId     integer NULL,

	CommCellId  integer NULL,

	AppId       integer NULL,

	CloudId     integer NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [MMTmpCIAFilesToPruneFromCIAgedTbl]''

END

--------



insert into GXDBVersions values(1, ''MMTmpCIAFilesToPruneFromCIAgedTbl'',  ''1.2'', ''MMTmpCIAFilesToPruneFromCIAgedTbl'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')
END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="AFileId" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="AFileId" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="AFileId")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ALTER COLUMN "+"AFileId" + " "+"INTEGER"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"AFileId"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="CommCellId" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="CommCellId" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="CommCellId")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ALTER COLUMN "+"CommCellId" + " "+"INTEGER"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"CommCellId"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="AppId" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="AppId" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="AppId")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ALTER COLUMN "+"AppId" + " "+"INTEGER"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"AppId"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="CloudId" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND COLUMN_NAME="CloudId" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="CloudId")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ALTER COLUMN "+"CloudId" + " "+"INTEGER"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"CloudId"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl')			
  			insert into GXDBVersions VALUES(1, 'MMTmpCIAFilesToPruneFromCIAgedTbl', '0.0', 'MMTmpCIAFilesToPruneFromCIAgedTbl', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMTmpCIAFilesToPruneFromCIAgedTbl'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMTmpCIAFilesToPruneFromCIAgedTbl' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/simBinarySet.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: simBinarySet.upg,v 1.11 2014/09/12 03:34:42 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'simBinarySet')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'simBinarySet')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'simBinarySet'							
  END																			
  IF (@oldRev = '1.7')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'simBinarySet' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'simBinarySet' +'].'							
  END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'simBinarySet' AND COLUMN_NAME="processorID")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ADD "+"processorID" + " "+"INTEGER"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'simBinarySet' + " SET "+"processorID" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ALTER COLUMN "+"processorID" + " "+"INTEGER" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'simBinarySet' AND COLUMN_NAME="processorName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ADD "+"processorName" + " "+"VARCHAR(128)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'simBinarySet' + " SET "+"processorName" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ALTER COLUMN "+"processorName" + " "+"VARCHAR(128)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'simBinarySet' AND COLUMN_NAME="procDisplayName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ADD "+"procDisplayName" + " "+"VARCHAR(128)"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'simBinarySet' + " SET "+"procDisplayName" + " = "+"''"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'simBinarySet' + " ALTER COLUMN "+"procDisplayName" + " "+"VARCHAR(128)" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'simBinarySet')			
  			insert into GXDBVersions VALUES(1, 'simBinarySet', '0.0', 'simBinarySet', '')	
  			UPDATE GXDBVersions SET revision = '1.7' WHERE name = 'simBinarySet'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'simBinarySet' + '] upgraded successfully to '			+ ' revision [' + '1.7' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'simBinarySet' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/simPackage.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: simPackage.upg,v 1.54 2014/09/12 03:39:16 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'simPackage')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'simPackage')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'simPackage'							
  END																			
  IF (@oldRev = '1.115')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'simPackage' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'simPackage' +'].'							
  END-- Get @oldRev, compare to '1.115'. Chk for work to do.
--Recreate is required because column was added in the middle
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'simPackage' AND COLUMN_NAME = 'DisplayName')
	BEGIN

EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'simPackageDependency', @fromColumn = 'simDependentPackageId', @toTable = 'simPackage'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'simPackageDependency', @fromColumn = 'simPackageId', @toTable = 'simPackage'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'simInstalledPackages', @fromColumn = 'simPackageId', @toTable = 'simPackage'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'simInstalledPackagesHistory', @fromColumn = 'simPackageId', @toTable = 'simPackage'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'simPackageMap', @fromColumn = 'simPackageId', @toTable = 'simPackage'
IF EXISTS (SELECT * FROM sysobjects				
  				WHERE type = 'U' and name = 'simPackage')	
  	BEGIN											
  		EXECUTE @retCode = cvsp_drop_pk 'simPackage'		
  		SET @sqlString = 'DROP TABLE ' + 'simPackage'		
  		EXEC sp_executesql @sqlString				
  		SET @sqlError = @@ERROR						
  		IF @sqlError = 0							
  		BEGIN										
  			DELETE FROM GXDBVersions WHERE name= 'simPackage'	
   PRINT 'RETVAL: 0  TABLE [' + 'simPackage'				+ '] successfully dropped.'			
  		END											
  		ELSE										
   PRINT 'RETVAL: 10 SQL Error: ' + CONVERT(CHAR(8), @sqlError)				+ ' [' + @sqlString + ']'			
  	END												
  	ELSE											
   PRINT 'RETVAL: 0  TABLE [' + 'simPackage'				+ '] already dropped.'

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[simPackage]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/simPackage.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/simPackage.tbl,v $ $Id: simPackage.tbl,v 1.115 2012/04/03 22:13:11 chandru Exp $";

print '... Creating Table: simPackage'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table simPackage (

	id					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	Name				varchar(256) NOT NULL,

	DisplayName				varchar(256)null,

	Rank				integer null,

	Hierarchy				varchar(256)null,

	DescriptionID		BIGINT	null,			-- message id to get the localized package description.

	InstallableFromGUI	TINYINT DEFAULT 1	NOT NULL,

	SortID				integer DEFAULT 200000	NOT NULL,

	flag			integer DEFAULT 0	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [simPackage]''

END

--------





SET QUOTED_IDENTIFIER OFF



-- ALLOW_COMMENTS_BELOW_HERE:



-- ----------------------------------------------------------------------



--                                                                      



--           Copyright (c) 1998  CommVault Systems, Inc.                



--                  All rights reserved.                                



--                                                                      



--                                                                   



--        This is unpublished proprietary source code of CommVault  



--        Systems, Inc. The copyright notice above does not evidence 



--        any actual or intended publication of such source code. 



-- ----------------------------------------------------------------------*/



SET QUOTED_IDENTIFIER OFF



SET NOCOUNT ON



')
 exec ('

DECLARE @tblRetCode integer  

-- TABLENAME simPackage





-- TABLENAME simPackage



-- For each new release:	SIM_PKG_DEPRECATED_NO_NEW_INSTALL --> SIM_PKG_DEPRECATED_NO_NEW_INSTALL2



--				SIM_PKG_DEPRECATED_IN_REL --> SIM_PKG_DEPRECATED_IN_REL2



--PACKAGES

 									

 IF EXISTS (Select * from simPackage where id = 1)				 													

	UPDATE simPackage																				

	SET name="File System Core",DisplayName="File System Core",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(515 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110000,flag=0	

        WHERE id = 1																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1, "File System Core", "File System Core", null, "Microsoft Windows", (515 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 2)				 													

	UPDATE simPackage																				

	SET name="Base Seed",DisplayName="Base Seed",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 2																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2, "Base Seed", "Base Seed", null, null, null, 0, 200000, 0)



--CS packages

 										

 IF EXISTS (Select * from simPackage where id = 20)				 													

	UPDATE simPackage																				

	SET name="CommServe",DisplayName="CommServe",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules",DescriptionID=(516 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 20																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (20, "CommServe", "CommServe", null, "Packages/Common Technology Engine/CommServe Modules", (516 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 										

 IF EXISTS (Select * from simPackage where id = 21)				 													

	UPDATE simPackage																				

	SET name="Commserve SNMP Enabler",DisplayName="Commserve SNMP Enabler",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules",DescriptionID=(546 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 21																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (21, "Commserve SNMP Enabler", "Commserve SNMP Enabler", null, "Packages/Common Technology Engine/CommServe Modules", (546 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 22)				 													

	UPDATE simPackage																				

	SET name="CommCell Explorer",DisplayName="CommCell Explorer",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules",DescriptionID=(547 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 22																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (22, "CommCell Explorer", "CommCell Explorer", null, "Packages/Common Technology Engine/CommServe Modules", (547 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 												

 IF EXISTS (Select * from simPackage where id = 23)				 													

	UPDATE simPackage																				

	SET name="Workflow Engine",DisplayName="Work Flow",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 23																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (23, "Workflow Engine", "Work Flow", null, "Packages/Common Technology Engine/CommServe Modules", null, 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 171)				 													

	UPDATE simPackage																				

	SET name="ContentStore Mail Server",DisplayName="ContentStore Mail Server",rank=null,Hierarchy="Server",DescriptionID=0,InstallableFromGUI=1,SortID=160006,flag=0	

        WHERE id = 171																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (171, "ContentStore Mail Server", "ContentStore Mail Server", null, "Server", 0, 1, 160006, 0)



--MA packages

 												

 IF EXISTS (Select * from simPackage where id = 51)				 													

	UPDATE simPackage																				

	SET name="MediaAgent",DisplayName="MediaAgent",rank=null,Hierarchy="Server",DescriptionID=(519 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=90000,flag=0	

        WHERE id = 51																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (51, "MediaAgent", "MediaAgent", null, "Server", (519 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 90000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 52)				 													

	UPDATE simPackage																				

	SET name="NDMP Remote Server",DisplayName="NDMP Remote Server",rank=null,Hierarchy="Server",DescriptionID=(539 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=90001,flag=0	

        WHERE id = 52																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (52, "NDMP Remote Server", "NDMP Remote Server", null, "Server", (539 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 90001, 0)

 								

 IF EXISTS (Select * from simPackage where id = 53)				 													

	UPDATE simPackage																				

	SET name="Shared Dynamic Disks",DisplayName="Shared Dynamic Disks",rank=null,Hierarchy="Server",DescriptionID=(567 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=90002,flag=(1 | 2 | (4 | 8))	

        WHERE id = 53																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (53, "Shared Dynamic Disks", "Shared Dynamic Disks", null, "Server", (567 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 90002, (1 | 2 | (4 | 8)))



--SharePoint packages

 												

 IF EXISTS (Select * from simPackage where id = 101)				 													

	UPDATE simPackage																				

	SET name="SharePoint iDataAgent",DisplayName="SharePoint",rank=null,Hierarchy="Applications",DescriptionID=(562 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130013,flag=0	

        WHERE id = 101																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (101, "SharePoint iDataAgent", "SharePoint", null, "Applications", (562 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130013, 0)

 									

 IF EXISTS (Select * from simPackage where id = 102)				 													

	UPDATE simPackage																				

	SET name="SharePoint Archiver",DisplayName="SharePoint Archiver",rank=null,Hierarchy="Applications",DescriptionID=(575 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | 8)	

        WHERE id = 102																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (102, "SharePoint Archiver", "SharePoint Archiver", null, "Applications", (575 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | 8))



--Exchange packages

 												

 IF EXISTS (Select * from simPackage where id = 151)				 													

	UPDATE simPackage																				

	SET name="iDA for Exchange Database",DisplayName="Exchange Database",rank=null,Hierarchy="Applications",DescriptionID=(530 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130001,flag=0	

        WHERE id = 151																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (151, "iDA for Exchange Database", "Exchange Database", null, "Applications", (530 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 152)				 													

	UPDATE simPackage																				

	SET name="iDA for Exchange Mailbox",DisplayName="Exchange Mailbox",rank=null,Hierarchy="Applications",DescriptionID=(531 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130002,flag=0	

        WHERE id = 152																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (152, "iDA for Exchange Mailbox", "Exchange Mailbox", null, "Applications", (531 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130002, 0)

 												

 IF EXISTS (Select * from simPackage where id = 153)				 													

	UPDATE simPackage																				

	SET name="iDA for Exchange Public Folder",DisplayName="Exchange Public Folder",rank=null,Hierarchy="Applications",DescriptionID=(532 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130003,flag=0	

        WHERE id = 153																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (153, "iDA for Exchange Public Folder", "Exchange Public Folder", null, "Applications", (532 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130003, 0)

 									

 IF EXISTS (Select * from simPackage where id = 154)				 													

	UPDATE simPackage																				

	SET name="iDA for Exchange Web Folder",DisplayName="Web Folder",rank=null,Hierarchy="Applications",DescriptionID=(552 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 154																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (154, "iDA for Exchange Web Folder", "Web Folder", null, "Applications", (552 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 												

 IF EXISTS (Select * from simPackage where id = 155)				 													

	UPDATE simPackage																				

	SET name="Exchange Compliance Archiver",DisplayName="Exchange Compliance Archiver",rank=null,Hierarchy="Applications",DescriptionID=(553 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130004,flag=0	

        WHERE id = 155																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (155, "Exchange Compliance Archiver", "Exchange Compliance Archiver", null, "Applications", (553 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130004, 0)

 								

 IF EXISTS (Select * from simPackage where id = 156)				 													

	UPDATE simPackage																				

	SET name="DataArchiver WebProxy Agent for Exchange",DisplayName="DataArchiver WebProxy Agent",rank=null,Hierarchy="Applications",DescriptionID=(568 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=130004,flag=(1 | 2 | (4 | 8))	

        WHERE id = 156																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (156, "DataArchiver WebProxy Agent for Exchange", "DataArchiver WebProxy Agent", null, "Applications", (568 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 130004, (1 | 2 | (4 | 8)))

 												

 IF EXISTS (Select * from simPackage where id = 157)				 													

	UPDATE simPackage																				

	SET name="DataArchiver for Exchange Public Folder",DisplayName="Exchange Public Folder Archiver",rank=null,Hierarchy="Applications",DescriptionID=(569 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130005,flag=0	

        WHERE id = 157																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (157, "DataArchiver for Exchange Public Folder", "Exchange Public Folder Archiver", null, "Applications", (569 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130005, 0)

 									

 IF EXISTS (Select * from simPackage where id = 158)				 													

	UPDATE simPackage																				

	SET name="DataArchiver Agent for Exchange",DisplayName="Archiver",rank=null,Hierarchy="Applications",DescriptionID=(523 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 8)	

        WHERE id = 158																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (158, "DataArchiver Agent for Exchange", "Archiver", null, "Applications", (523 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 8))

 									

 IF EXISTS (Select * from simPackage where id = 159)				 													

	UPDATE simPackage																				

	SET name="DataArchiver Outlook Add-In",DisplayName="Outlook Add-In",rank=null,Hierarchy="Applications",DescriptionID=(585 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=130003,flag=0	

        WHERE id = 159																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (159, "DataArchiver Outlook Add-In", "Outlook Add-In", null, "Applications", (585 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 130003, 0)

 									

 IF EXISTS (Select * from simPackage where id = 172)				 													

	UPDATE simPackage																				

	SET name="Edge Attachment Store",DisplayName="Edge Attachment Store",rank=null,Hierarchy="Applications",DescriptionID=(585 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=130003,flag=0	

        WHERE id = 172																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (172, "Edge Attachment Store", "Edge Attachment Store", null, "Applications", (585 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 130003, 0)

 												

 IF EXISTS (Select * from simPackage where id = 160)				 													

	UPDATE simPackage																				

	SET name="OWA Proxy Enabler",DisplayName="OWA Proxy Enabler",rank=null,Hierarchy="Applications",DescriptionID=(585 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130010,flag=0	

        WHERE id = 160																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (160, "OWA Proxy Enabler", "OWA Proxy Enabler", null, "Applications", (585 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130010, 0)

 									

 IF EXISTS (Select * from simPackage where id = 161)				 													

	UPDATE simPackage																				

	SET name="Edge Uploader",DisplayName="Edge Uploader",rank=null,Hierarchy="Applications",DescriptionID=(827 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=130003,flag=0	

        WHERE id = 161																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (161, "Edge Uploader", "Edge Uploader", null, "Applications", (827 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 130003, 0)



--Lotus Notes packages

 												

 IF EXISTS (Select * from simPackage where id = 201)				 													

	UPDATE simPackage																				

	SET name="iDA for Domino Database",DisplayName="Domino Database",rank=null,Hierarchy="Applications",DescriptionID=(525 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130007,flag=0	

        WHERE id = 201																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (201, "iDA for Domino Database", "Domino Database", null, "Applications", (525 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130007, 0)

 												

 IF EXISTS (Select * from simPackage where id = 202)				 													

	UPDATE simPackage																				

	SET name="iDA for Domino Document",DisplayName="Domino Document",rank=null,Hierarchy="Applications",DescriptionID=(526 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130008,flag=0	

        WHERE id = 202																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (202, "iDA for Domino Document", "Domino Document", null, "Applications", (526 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130008, 0)

 												

 IF EXISTS (Select * from simPackage where id = 203)				 													

	UPDATE simPackage																				

	SET name="Domino DataArchiver",DisplayName="Domino Mailbox Archiver",rank=null,Hierarchy="Applications",DescriptionID=(576 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130009,flag=0	

        WHERE id = 203																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (203, "Domino DataArchiver", "Domino Mailbox Archiver", null, "Applications", (576 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130009, 0)

 									

 IF EXISTS (Select * from simPackage where id = 204)				 													

	UPDATE simPackage																				

	SET name="Domino DataArchiver Client",DisplayName="Notes Add-in",rank=null,Hierarchy="Applications",DescriptionID=(578 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=140003,flag=0	

        WHERE id = 204																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (204, "Domino DataArchiver Client", "Notes Add-in", null, "Applications", (578 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 140003, 0)



--content indexing packages 

 								

 IF EXISTS (Select * from simPackage where id = 251)				 													

	UPDATE simPackage																				

	SET name="Content Indexing Engine",DisplayName="Content Indexing Engine",rank=null,Hierarchy="Search",DescriptionID=(577 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=160000,flag=(1 | 2 | 8)	

        WHERE id = 251																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (251, "Content Indexing Engine", "Content Indexing Engine", null, "Search", (577 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 160000, (1 | 2 | 8))

 									

 IF EXISTS (Select * from simPackage where id = 252)				 													

	UPDATE simPackage																				

	SET name="Web Server",DisplayName="Web Server",rank=null,Hierarchy="Search""::""Packages/Client Modules/Backup & Recovery/Web Based Search & Browse",DescriptionID=(582 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=160001,flag=0	

        WHERE id = 252																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (252, "Web Server", "Web Server", null, "Search""::""Packages/Client Modules/Backup & Recovery/Web Based Search & Browse", (582 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 160001, 0)

 									

 IF EXISTS (Select * from simPackage where id = 253)				 													

	UPDATE simPackage																				

	SET name="Online Content Indexing",DisplayName="Online Content Indexing",rank=null,Hierarchy="Search",DescriptionID=(583 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 253																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (253, "Online Content Indexing", "Online Content Indexing", null, "Search", (583 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 												

 IF EXISTS (Select * from simPackage where id = 255)				 													

	UPDATE simPackage																				

	SET name="Compliance Search",DisplayName="Compliance Search",rank=null,Hierarchy="Server",DescriptionID=0,InstallableFromGUI=1,SortID=160007,flag=0	

        WHERE id = 255																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (255, "Compliance Search", "Compliance Search", null, "Server", 0, 1, 160007, 0)

 													

 IF EXISTS (Select * from simPackage where id = 256)				 													

	UPDATE simPackage																				

	SET name="Authentication Service",DisplayName="Authentication Service",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 256																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (256, "Authentication Service", "Authentication Service", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 												

 IF EXISTS (Select * from simPackage where id = 257)				 													

	UPDATE simPackage																				

	SET name="Search Engine",DisplayName="Search Engine",rank=null,Hierarchy="Server",DescriptionID=(765 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=90001,flag=0	

        WHERE id = 257																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (257, "Search Engine", "Search Engine", null, "Server", (765 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 90001, 0)

 									

 IF EXISTS (Select * from simPackage where id = 259)				 													

	UPDATE simPackage																				

	SET name="Search Advanced Document Type Support",DisplayName="Search Advanced Document Type Support",rank=null,Hierarchy="Search",DescriptionID=(774 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=160006,flag=0	

        WHERE id = 259																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (259, "Search Advanced Document Type Support", "Search Advanced Document Type Support", null, "Search", (774 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 160006, 0)

 									

 IF EXISTS (Select * from simPackage where id = 260)				 													

	UPDATE simPackage																				

	SET name="Multi Lingual Search Engine",DisplayName="Multi Lingual Search Engine",rank=null,Hierarchy="Search",DescriptionID=(775 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=160007,flag=0	

        WHERE id = 260																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (260, "Multi Lingual Search Engine", "Multi Lingual Search Engine", null, "Search", (775 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 160007, 0)

 												

 IF EXISTS (Select * from simPackage where id = 261)				 													

	UPDATE simPackage																				

	SET name="Extended Indexing Engine",DisplayName="Extended Indexing Engine",rank=null,Hierarchy="Search",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 261																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (261, "Extended Indexing Engine", "Extended Indexing Engine", null, "Search", null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 262)				 													

	UPDATE simPackage																				

	SET name="Proxy Server For Content Store",DisplayName="Proxy Server For Content Store",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 262																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (262, "Proxy Server For Content Store", "Proxy Server For Content Store", null, null, null, 0, 200000, 0)



--QR Agents

 								

 IF EXISTS (Select * from simPackage where id = 301)				 													

	UPDATE simPackage																				

	SET name="OSSV Agent",DisplayName="OSSV Agent",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(537 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=180000,flag=(1 | 2)	

        WHERE id = 301																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (301, "OSSV Agent", "OSSV Agent", null, "OSSV Plug-In", (537 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 180000, (1 | 2))

 									

 IF EXISTS (Select * from simPackage where id = 302)				 													

	UPDATE simPackage																				

	SET name="Recovery Director",DisplayName="Recovery Director",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(563 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 302																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (302, "Recovery Director", "Recovery Director", null, "OSSV Plug-In", (563 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 303)				 													

	UPDATE simPackage																				

	SET name="SnapView Enabler for OSSV",DisplayName="SnapView Enabler for OSSV",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(544 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 303																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (303, "SnapView Enabler for OSSV", "SnapView Enabler for OSSV", null, "OSSV Plug-In", (544 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 304)				 													

	UPDATE simPackage																				

	SET name="VSS Enabler for OSSV Plug-in",DisplayName="VSS Enabler for OSSV Plug-in",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(543 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=180004,flag=0	

        WHERE id = 304																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (304, "VSS Enabler for OSSV Plug-in", "VSS Enabler for OSSV Plug-in", null, "OSSV Plug-In", (543 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 180004, 0)

 								

 IF EXISTS (Select * from simPackage where id = 305)				 													

	UPDATE simPackage																				

	SET name="OSSV Enabler",DisplayName="OSSV Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(559 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=180002,flag=(1 | 2)	

        WHERE id = 305																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (305, "OSSV Enabler", "OSSV Enabler", null, "OSSV Plug-In", (559 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 180002, (1 | 2))

 										

 IF EXISTS (Select * from simPackage where id = 306)				 													

	UPDATE simPackage																				

	SET name="SnapVault/SnapMirror ONTAP Enabler",DisplayName="SnapVault/SnapMirror ONTAP Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(560 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 306																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (306, "SnapVault/SnapMirror ONTAP Enabler", "SnapVault/SnapMirror ONTAP Enabler", null, "OSSV Plug-In", (560 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 										

 IF EXISTS (Select * from simPackage where id = 307)				 													

	UPDATE simPackage																				

	SET name="NetApp Snapshot Enabler",DisplayName="NetApp Snapshot Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(581 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 307																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (307, "NetApp Snapshot Enabler", "NetApp Snapshot Enabler", null, "OSSV Plug-In", (581 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)



--DB agents

 												

 IF EXISTS (Select * from simPackage where id = 351)				 													

	UPDATE simPackage																				

	SET name="iDA for DB2",DisplayName="DB2",rank=null,Hierarchy="Database",DescriptionID=(540 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120005,flag=0	

        WHERE id = 351																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (351, "iDA for DB2", "DB2", null, "Database", (540 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120005, 0)

 												

 IF EXISTS (Select * from simPackage where id = 352)				 													

	UPDATE simPackage																				

	SET name="iDA for Oracle",DisplayName="Oracle",rank=null,Hierarchy="Database",DescriptionID=(522 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120006,flag=0	

        WHERE id = 352																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (352, "iDA for Oracle", "Oracle", null, "Database", (522 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120006, 0)

 												

 IF EXISTS (Select * from simPackage where id = 353)				 													

	UPDATE simPackage																				

	SET name="iDA for MSSQL Server",DisplayName="SQL Server",rank=null,Hierarchy="Database",DescriptionID=(529 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120007,flag=0	

        WHERE id = 353																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (353, "iDA for MSSQL Server", "SQL Server", null, "Database", (529 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120007, 0)

 												

 IF EXISTS (Select * from simPackage where id = 354)				 													

	UPDATE simPackage																				

	SET name="SAP on Oracle",DisplayName="SAP for Oracle",rank=null,Hierarchy="Database",DescriptionID=(555 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120008,flag=0	

        WHERE id = 354																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (354, "SAP on Oracle", "SAP for Oracle", null, "Database", (555 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120008, 0)

 												

 IF EXISTS (Select * from simPackage where id = 355)				 													

	UPDATE simPackage																				

	SET name="SAP on MaxDB",DisplayName="SAP for MaxDB",rank=null,Hierarchy="Database",DescriptionID=(565 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120009,flag=0	

        WHERE id = 355																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (355, "SAP on MaxDB", "SAP for MaxDB", null, "Database", (565 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120009, 0)

 												

 IF EXISTS (Select * from simPackage where id = 356)				 													

	UPDATE simPackage																				

	SET name="Sybase iDataAgent",DisplayName="Sybase",rank=null,Hierarchy="Database",DescriptionID=(570 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120010,flag=0	

        WHERE id = 356																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (356, "Sybase iDataAgent", "Sybase", null, "Database", (570 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120010, 0)

 												

 IF EXISTS (Select * from simPackage where id = 358)				 													

	UPDATE simPackage																				

	SET name="MySQL iDataAgent",DisplayName="MySQL",rank=null,Hierarchy="Database",DescriptionID=(606 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120011,flag=0	

        WHERE id = 358																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (358, "MySQL iDataAgent", "MySQL", null, "Database", (606 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120011, 0)

 												

 IF EXISTS (Select * from simPackage where id = 360)				 													

	UPDATE simPackage																				

	SET name="Informix IDA",DisplayName="Informix",rank=null,Hierarchy="Database",DescriptionID=(605 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120012,flag=0	

        WHERE id = 360																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (360, "Informix IDA", "Informix", null, "Database", (605 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120012, 0)

 												

 IF EXISTS (Select * from simPackage where id = 362)				 													

	UPDATE simPackage																				

	SET name="PostgreSQL iDataAgent",DisplayName="PostgreSQL",rank=null,Hierarchy="Database",DescriptionID=(607 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120013,flag=0	

        WHERE id = 362																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (362, "PostgreSQL iDataAgent", "PostgreSQL", null, "Database", (607 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120013, 0)

 												

 IF EXISTS (Select * from simPackage where id = 363)				 													

	UPDATE simPackage																				

	SET name="Documentum Agent",DisplayName="Documentum",rank=null,Hierarchy="Database",DescriptionID=(804 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120014,flag=0	

        WHERE id = 363																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (363, "Documentum Agent", "Documentum", null, "Database", (804 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120014, 0)

 														

 IF EXISTS (Select * from simPackage where id = 718)				 													

	UPDATE simPackage																				

	SET name="RootOfCPUFolder",DisplayName="RootOfCPUFolder",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 718																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (718, "RootOfCPUFolder", "RootOfCPUFolder", null, null, null, 0, 200000, 0)



--SRM packagess

 									

 IF EXISTS (Select * from simPackage where id = 401)				 													

	UPDATE simPackage																				

	SET name="Operations Manager",DisplayName="Operations Manager",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules",DescriptionID=(586 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 401																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (401, "Operations Manager", "Operations Manager", null, "Packages/Common Technology Engine/CommServe Modules", (586 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 								

 IF EXISTS (Select * from simPackage where id = 402)				 													

	UPDATE simPackage																				

	SET name="SRM Windows File System Agent",DisplayName="Standalone SRM for Files",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(587 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=110050,flag=(1 | 2 | (4 | 8))	

        WHERE id = 402																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (402, "SRM Windows File System Agent", "Standalone SRM for Files", null, "Microsoft Windows", (587 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 110050, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 403)				 													

	UPDATE simPackage																				

	SET name="SRM Exchange Agent",DisplayName="SRM",rank=null,Hierarchy="Applications",DescriptionID=(588 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 403																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (403, "SRM Exchange Agent", "SRM", null, "Applications", (588 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 404)				 													

	UPDATE simPackage																				

	SET name="SRM NAS Agent",DisplayName="Standalone SRM for NAS",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(589 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 404																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (404, "SRM NAS Agent", "Standalone SRM for NAS", null, "Microsoft Windows", (589 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 								

 IF EXISTS (Select * from simPackage where id = 405)				 													

	UPDATE simPackage																				

	SET name="SRM SQL Agent",DisplayName="SRM for MSSQL",rank=null,Hierarchy="Database",DescriptionID=(590 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=120020,flag=(1 | 2 | (4 | 8))	

        WHERE id = 405																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (405, "SRM SQL Agent", "SRM for MSSQL", null, "Database", (590 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 120020, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 406)				 													

	UPDATE simPackage																				

	SET name="SRM Oracle Agent",DisplayName="SRM Oracle Agent",rank=null,Hierarchy="Packages/Client Modules/SRM",DescriptionID=(591 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 406																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (406, "SRM Oracle Agent", "SRM Oracle Agent", null, "Packages/Client Modules/SRM", (591 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 407)				 													

	UPDATE simPackage																				

	SET name="SRM NetWare Proxy Agent",DisplayName="SRM NetWare Proxy Agent",rank=null,Hierarchy="Packages/Client Modules/SRM",DescriptionID=(592 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 407																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (407, "SRM NetWare Proxy Agent", "SRM NetWare Proxy Agent", null, "Packages/Client Modules/SRM", (592 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 									

 IF EXISTS (Select * from simPackage where id = 408)				 													

	UPDATE simPackage																				

	SET name="SRM SharePoint Agent",DisplayName="SRM",rank=null,Hierarchy="Applications",DescriptionID=(593 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 408																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (408, "SRM SharePoint Agent", "SRM", null, "Applications", (593 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))



--Replication agents

 												

 IF EXISTS (Select * from simPackage where id = 451)				 													

	UPDATE simPackage																				

	SET name="Continuous Data Replicator",DisplayName="Continuous Data Replicator",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(574 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110002,flag=0	

        WHERE id = 451																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (451, "Continuous Data Replicator", "Continuous Data Replicator", null, "Microsoft Windows", (574 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110002, 0)

 									

 IF EXISTS (Select * from simPackage where id = 452)				 													

	UPDATE simPackage																				

	SET name="Driver for Continuous Data Replicator",DisplayName="Driver for Continuous Data Replicator",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(573 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 452																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (452, "Driver for Continuous Data Replicator", "Driver for Continuous Data Replicator", null, "Microsoft Windows", (573 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 454)				 													

	UPDATE simPackage																				

	SET name="WorkStation Backup",DisplayName="WorkStation Backup",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(601 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 454																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (454, "WorkStation Backup", "WorkStation Backup", null, "Microsoft Windows", (601 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))



--Snapshot-based packages

 									

 IF EXISTS (Select * from simPackage where id = 503)				 													

	UPDATE simPackage																				

	SET name="QSnap",DisplayName="QSnap",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(534 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=195001,flag=0	

        WHERE id = 503																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (503, "QSnap", "QSnap", null, "Microsoft Windows", (534 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 195001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 453)				 													

	UPDATE simPackage																				

	SET name="VSS Provider",DisplayName="VSS Provider",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(584 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110005,flag=0	

        WHERE id = 453																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (453, "VSS Provider", "VSS Provider", null, "Microsoft Windows", (584 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110005, 0)

 												

 IF EXISTS (Select * from simPackage where id = 455)				 													

	UPDATE simPackage																				

	SET name="VSS Hardware Provider",DisplayName="VSS Hardware Provider",rank=null,Hierarchy="Microsoft Windows",DescriptionID=0,InstallableFromGUI=1,SortID=110006,flag=0	

        WHERE id = 455																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (455, "VSS Hardware Provider", "VSS Hardware Provider", null, "Microsoft Windows", 0, 1, 110006, 0)

 												

 IF EXISTS (Select * from simPackage where id = 709)				 													

	UPDATE simPackage																				

	SET name="Data Protection Manager",DisplayName="Data Protection Manager",rank=null,Hierarchy="Applications",DescriptionID=0,InstallableFromGUI=1,SortID=130012,flag=0	

        WHERE id = 709																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (709, "Data Protection Manager", "Data Protection Manager", null, "Applications", 0, 1, 130012, 0)



--driver packages

 												

 IF EXISTS (Select * from simPackage where id = 551)				 													

	UPDATE simPackage																				

	SET name="Driver for File Recalls",DisplayName="Driver for File Archiver",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(541 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110003,flag=0	

        WHERE id = 551																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (551, "Driver for File Recalls", "Driver for File Archiver", null, "Microsoft Windows", (541 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110003, 0)

 												

 IF EXISTS (Select * from simPackage where id = 552)				 													

	UPDATE simPackage																				

	SET name="DataArchiver for Network Storage Client",DisplayName="File Share Archiver Client",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(564 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110004,flag=0	

        WHERE id = 552																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (552, "DataArchiver for Network Storage Client", "File Share Archiver Client", null, "Microsoft Windows", (564 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110004, 0)

 														

 IF EXISTS (Select * from simPackage where id = 554)				 													

	UPDATE simPackage																				

	SET name="1-Touch Recovery",DisplayName="1-Touch Recovery",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 554																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (554, "1-Touch Recovery", "1-Touch Recovery", null, null, null, 0, 200000, 0)



--QNET packages

 											

 IF EXISTS (Select * from simPackage where id = 603)				 													

	UPDATE simPackage																				

	SET name="CommNetExplorer",DisplayName="CommNetExplorer",rank=null,Hierarchy="Packages/Common Technology Engine/CommServe Modules/CommNet",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 603																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (603, "CommNetExplorer", "CommNetExplorer", null, "Packages/Common Technology Engine/CommServe Modules/CommNet", null, 0, 200000, (1 | 2 | (4 | 8)))



--License packages

 												

 IF EXISTS (Select * from simPackage where id = 651)				 													

	UPDATE simPackage																				

	SET name="Licensing Web Application",DisplayName="License Generator",rank=null,Hierarchy="Tools",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 651																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (651, "Licensing Web Application", "License Generator", null, "Tools", null, 0, 200000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 652)				 													

	UPDATE simPackage																				

	SET name="Licensing Server",DisplayName="Licensing Server",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 652																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (652, "Licensing Server", "Licensing Server", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 653)				 													

	UPDATE simPackage																				

	SET name="Licensing Web Service",DisplayName="Licensing Web Service",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 653																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (653, "Licensing Web Service", "Licensing Web Service", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 654)				 													

	UPDATE simPackage																				

	SET name="Licensing Lookup Data Admin Application",DisplayName="Licensing Lookup Data Admin Application",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 654																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (654, "Licensing Lookup Data Admin Application", "Licensing Lookup Data Admin Application", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))



--other packages	

 									

 IF EXISTS (Select * from simPackage where id = 701)				 													

	UPDATE simPackage																				

	SET name="Commcell Console",DisplayName="Commcell Console",rank=null,Hierarchy="Server",DescriptionID=(517 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=100000,flag=0	

        WHERE id = 701																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (701, "Commcell Console", "Commcell Console", null, "Server", (517 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 100000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 702)				 													

	UPDATE simPackage																				

	SET name="File System",DisplayName="File System",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(520 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110001,flag=0	

        WHERE id = 702																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (702, "File System", "File System", null, "Microsoft Windows", (520 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 703)				 													

	UPDATE simPackage																				

	SET name="iDA for Active Directory",DisplayName="Active Directory",rank=null,Hierarchy="Applications",DescriptionID=(521 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130000,flag=0	

        WHERE id = 703																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (703, "iDA for Active Directory", "Active Directory", null, "Applications", (521 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130000, 0)

 											

 IF EXISTS (Select * from simPackage where id = 705)				 													

	UPDATE simPackage																				

	SET name="Standalone File Archiver for Windows Agent",DisplayName="Standalone Archiver for Files",rank=null,Hierarchy="Microsoft Windows",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 8)	

        WHERE id = 705																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (705, "Standalone File Archiver for Windows Agent", "Standalone Archiver for Files", null, "Microsoft Windows", null, 0, 200000, (1 | 8))

 									

 IF EXISTS (Select * from simPackage where id = 704)				 													

	UPDATE simPackage																				

	SET name="File System NAS Restore Enabler",DisplayName="File System NAS Restore Enabler",rank=null,Hierarchy="Microsoft Windows",DescriptionID=(545 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | 8)	

        WHERE id = 704																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (704, "File System NAS Restore Enabler", "File System NAS Restore Enabler", null, "Microsoft Windows", (545 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | 8))

 											

 IF EXISTS (Select * from simPackage where id = 706)				 													

	UPDATE simPackage																				

	SET name="EchoView Enabler for OSSV",DisplayName="EchoView Enabler for OSSV",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 706																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (706, "EchoView Enabler for OSSV", "EchoView Enabler for OSSV", null, "OSSV Plug-In", null, 0, 200000, (1 | 2 | (4 | 8)))

 										

 IF EXISTS (Select * from simPackage where id = 707)				 													

	UPDATE simPackage																				

	SET name="iDA for Image Level",DisplayName="Image Level",rank=null,Hierarchy="Microsoft Windows",DescriptionID=null,InstallableFromGUI=0,SortID=110007,flag=1		

        WHERE id = 707																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (707, "iDA for Image Level", "Image Level", null, "Microsoft Windows", null, 0, 110007, 1)

 														

 IF EXISTS (Select * from simPackage where id = 710)				 													

	UPDATE simPackage																				

	SET name="Media Explorer",DisplayName="Media Explorer",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 710																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (710, "Media Explorer", "Media Explorer", null, null, null, 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 711)				 													

	UPDATE simPackage																				

	SET name="Exchange Offline Mining Tool",DisplayName="Exchange Offline Mining Tool",rank=null,Hierarchy="Applications",DescriptionID=(597 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=130006,flag=0	

        WHERE id = 711																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (711, "Exchange Offline Mining Tool", "Exchange Offline Mining Tool", null, "Applications", (597 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 130006, 0)

 												

 IF EXISTS (Select * from simPackage where id = 712)				 													

	UPDATE simPackage																				

	SET name="SharePoint Offline Mining Tool",DisplayName="SharePoint Offline Mining Tool",rank=null,Hierarchy=null,DescriptionID=(599 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 712																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (712, "SharePoint Offline Mining Tool", "SharePoint Offline Mining Tool", null, null, (599 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 713)				 													

	UPDATE simPackage																				

	SET name="VirtualServer Agent",DisplayName="Virtual Server",rank=null,Hierarchy="Virtualization",DescriptionID=(602 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110500,flag=0	

        WHERE id = 713																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (713, "VirtualServer Agent", "Virtual Server", null, "Virtualization", (602 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110500, 0)

 												

 IF EXISTS (Select * from simPackage where id = 715)				 													

	UPDATE simPackage																				

	SET name="External Data Connector Agent",DisplayName="External Data Connector",rank=null,Hierarchy="Tools",DescriptionID=(803 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=210001,flag=0	

        WHERE id = 715																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (715, "External Data Connector Agent", "External Data Connector", null, "Tools", (803 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 210001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 751)				 													

	UPDATE simPackage																				

	SET name="VPN Access",DisplayName="VPN Access",rank=null,Hierarchy="Tools",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 751																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (751, "VPN Access", "VPN Access", null, "Tools", null, 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 728)				 													

	UPDATE simPackage																				

	SET name="VWeb",DisplayName="VWeb",rank=null,Hierarchy="Server",DescriptionID=0,InstallableFromGUI=1,SortID=100001,flag=0	

        WHERE id = 728																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (728, "VWeb", "VWeb", null, "Server", 0, 1, 100001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 719)				 													

	UPDATE simPackage																				

	SET name="Test Automation",DisplayName="Test Automation",rank=null,Hierarchy="Tools",DescriptionID=0,InstallableFromGUI=1,SortID=210004,flag=0	

        WHERE id = 719																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (719, "Test Automation", "Test Automation", null, "Tools", 0, 1, 210004, 0)

 									

 IF EXISTS (Select * from simPackage where id = 725)				 													

	UPDATE simPackage																				

	SET name="Commserve Failover",DisplayName="Commserve Failover",rank=null,Hierarchy="Tools",DescriptionID=0,InstallableFromGUI=0,SortID=210005,flag=0	

        WHERE id = 725																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (725, "Commserve Failover", "Commserve Failover", null, "Tools", 0, 0, 210005, 0)

 														

 IF EXISTS (Select * from simPackage where id = 716)				 													

	UPDATE simPackage																				

	SET name="PrePost Install Package",DisplayName="PrePost Install Package",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 716																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (716, "PrePost Install Package", "PrePost Install Package", null, null, null, 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 717)				 													

	UPDATE simPackage																				

	SET name="Database Upgrade Package",DisplayName="Database Upgrade",rank=null,Hierarchy="Tools",DescriptionID=(802 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=190004,flag=0	

        WHERE id = 717																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (717, "Database Upgrade Package", "Database Upgrade", null, "Tools", (802 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 190004, 0)

 												

 IF EXISTS (Select * from simPackage where id = 720)				 													

	UPDATE simPackage																				

	SET name="Resource Pack",DisplayName="Resource Pack",rank=null,Hierarchy="Tools",DescriptionID=0,InstallableFromGUI=1,SortID=210000,flag=0	

        WHERE id = 720																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (720, "Resource Pack", "Resource Pack", null, "Tools", 0, 1, 210000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 721)				 													

	UPDATE simPackage																				

	SET name="Resource Pack Limited Use",DisplayName="Advanced Tools",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 721																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (721, "Resource Pack Limited Use", "Advanced Tools", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 722)				 													

	UPDATE simPackage																				

	SET name="Resource Pack Internal Use",DisplayName="Internal Tools",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 722																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (722, "Resource Pack Internal Use", "Internal Tools", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 											

 IF EXISTS (Select * from simPackage where id = 726)				 													

	UPDATE simPackage																				

	SET name="Web Console",DisplayName="Web Console",rank=null,Hierarchy="Server",DescriptionID=null,InstallableFromGUI=1,SortID=100002,flag=0		

        WHERE id = 726																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (726, "Web Console", "Web Console", null, "Server",null, 1, 100002, 0)

 												

 IF EXISTS (Select * from simPackage where id = 727)				 													

	UPDATE simPackage																				

	SET name="Metrics Reporting",DisplayName="Metrics Reporting",rank=null,Hierarchy="Server",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 727																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (727, "Metrics Reporting", "Metrics Reporting", null, "Server", null, 0, 200000, 0)

 									

 IF EXISTS (Select * from simPackage where id = 729)				 													

	UPDATE simPackage																				

	SET name="Content Analyzer",DisplayName="Content Analyzer",rank=null,Hierarchy="Server",DescriptionID=0,InstallableFromGUI=0,SortID=160008,flag=0	

        WHERE id = 729																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (729, "Content Analyzer", "Content Analyzer", null, "Server", 0, 0, 160008, 0)

 									

 IF EXISTS (Select * from simPackage where id = 730)				 													

	UPDATE simPackage																				

	SET name="Cloud Connector",DisplayName="Cloud Connector",rank=null,Hierarchy="Applications",DescriptionID=0,InstallableFromGUI=1,SortID=130011,flag=0	

        WHERE id = 730																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (730, "Cloud Connector", "Cloud Connector", null, "Applications", 0, 1, 130011, 0)



--DB packages

 														

 IF EXISTS (Select * from simPackage where id = 801)				 													

	UPDATE simPackage																				

	SET name="Commserve DB",DisplayName="Commserve DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 801																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (801, "Commserve DB", "Commserve DB", null, null, null, 0, 200000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 802)				 													

	UPDATE simPackage																				

	SET name="SRM services DB",DisplayName="SRM services DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 802																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (802, "SRM services DB", "SRM services DB", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 														

 IF EXISTS (Select * from simPackage where id = 803)				 													

	UPDATE simPackage																				

	SET name="DM2 Web services DB",DisplayName="DM2 Web services DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 803																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (803, "DM2 Web services DB", "DM2 Web services DB", null, null, null, 0, 200000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 804)				 													

	UPDATE simPackage																				

	SET name="Commnet Server DB",DisplayName="Commnet Server DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 804																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (804, "Commnet Server DB", "Commnet Server DB", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 														

 IF EXISTS (Select * from simPackage where id = 805)				 													

	UPDATE simPackage																				

	SET name="License Generator Server DB",DisplayName="License Generator Server DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 805																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (805, "License Generator Server DB", "License Generator Server DB", null, null, null, 0, 200000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 806)				 													

	UPDATE simPackage																				

	SET name="License Generator License DB",DisplayName="License Generator License DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 806																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (806, "License Generator License DB", "License Generator License DB", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 807)				 													

	UPDATE simPackage																				

	SET name="License Generator Front DB",DisplayName="License Generator Front DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 807																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (807, "License Generator Front DB", "License Generator Front DB", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 														

 IF EXISTS (Select * from simPackage where id = 808)				 													

	UPDATE simPackage																				

	SET name="Workflow Engine DB",DisplayName="Workflow Engine DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 808																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (808, "Workflow Engine DB", "Workflow Engine DB", null, null, null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 809)				 													

	UPDATE simPackage																				

	SET name="Metrics Reporting DB",DisplayName="Metrics Reporting DB",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 809																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (809, "Metrics Reporting DB", "Metrics Reporting DB", null, null, null, 0, 200000, 0)



--expired packages

 													

 IF EXISTS (Select * from simPackage where id = 901)				 													

	UPDATE simPackage																				

	SET name="NT FileSystem",DisplayName="NT FileSystem",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 901																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (901, "NT FileSystem", "NT FileSystem", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 902)				 													

	UPDATE simPackage																				

	SET name="SharePoint Database V2",DisplayName="SharePoint Database V2",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 902																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (902, "SharePoint Database V2", "SharePoint Database V2", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 5000)				 													

	UPDATE simPackage																				

	SET name="CommCell Console",DisplayName="CommCell Console",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 5000																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (5000, "CommCell Console", "CommCell Console", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 903)				 													

	UPDATE simPackage																				

	SET name="Open File Handler",DisplayName="Open File Handler",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 903																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (903, "Open File Handler", "Open File Handler", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 904)				 													

	UPDATE simPackage																				

	SET name="Hardware Snap Enabler",DisplayName="Hardware Snap Enabler",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 904																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (904, "Hardware Snap Enabler", "Hardware Snap Enabler", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 905)				 													

	UPDATE simPackage																				

	SET name="Serverless Data Manager",DisplayName="Serverless Data Manager",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 905																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (905, "Serverless Data Manager", "Serverless Data Manager", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 906)				 													

	UPDATE simPackage																				

	SET name="SharePoint Database V1",DisplayName="SharePoint Database V1",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 906																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (906, "SharePoint Database V1", "SharePoint Database V1", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 907)				 													

	UPDATE simPackage																				

	SET name="SharePoint Document",DisplayName="SharePoint Document",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 907																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (907, "SharePoint Document", "SharePoint Document", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 908)				 													

	UPDATE simPackage																				

	SET name="DataArchiver Agent for Network Storage",DisplayName="DataArchiver Agent for Network Storage",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 908																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (908, "DataArchiver Agent for Network Storage", "DataArchiver Agent for Network Storage", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 910)				 													

	UPDATE simPackage																				

	SET name="Exchange Offline Mining Tool for Administrators",DisplayName="Exchange Offline Mining Tool for Administrators",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 910																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (910, "Exchange Offline Mining Tool for Administrators", "Exchange Offline Mining Tool for Administrators", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 911)				 													

	UPDATE simPackage																				

	SET name="NAS",DisplayName="NAS",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 911																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (911, "NAS", "NAS", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 912)				 													

	UPDATE simPackage																				

	SET name="Notes Database",DisplayName="Notes Database",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 912																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (912, "Notes Database", "Notes Database", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 913)				 													

	UPDATE simPackage																				

	SET name="Notes Document",DisplayName="Notes Document",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 913																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (913, "Notes Document", "Notes Document", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 5001)				 													

	UPDATE simPackage																				

	SET name="HW Snap Enabler",DisplayName="HW Snap Enabler",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 5001																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (5001, "HW Snap Enabler", "HW Snap Enabler", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))



--UNIX packages

 												

 IF EXISTS (Select * from simPackage where id = 1002)				 													

	UPDATE simPackage																				

	SET name="File System Core",DisplayName="File System Core",rank=null,Hierarchy="File System",DescriptionID=(515 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110000,flag=0	

        WHERE id = 1002																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1002, "File System Core", "File System Core", null, "File System", (515 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1003)				 													

	UPDATE simPackage																				

	SET name="Base0 Module",DisplayName="Base0 Module",rank=null,Hierarchy=null,DescriptionID=(515 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1003																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1003, "Base0 Module", "Base0 Module", null, null, (515 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1004)				 													

	UPDATE simPackage																				

	SET name="Application Base",DisplayName="Application Base",rank=null,Hierarchy=null,DescriptionID=(515 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1004																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1004, "Application Base", "Application Base", null, null, (515 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, 0)



--Lotus Notes Packages	

 												

 IF EXISTS (Select * from simPackage where id = 1051)				 													

	UPDATE simPackage																				

	SET name="Domino DB IDA",DisplayName="Domino Database",rank=null,Hierarchy="Applications",DescriptionID=(525 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=140000,flag=0	

        WHERE id = 1051																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1051, "Domino DB IDA", "Domino Database", null, "Applications", (525 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 140000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1052)				 													

	UPDATE simPackage																				

	SET name="iDA for Domino Document",DisplayName="Domino Document",rank=null,Hierarchy="Applications",DescriptionID=(526 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=140001,flag=0	

        WHERE id = 1052																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1052, "iDA for Domino Document", "Domino Document", null, "Applications", (526 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 140001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1053)				 													

	UPDATE simPackage																				

	SET name="Domino DataArchiver",DisplayName="Domino Mailbox Archiver",rank=null,Hierarchy="Applications",DescriptionID=(576 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=140002,flag=0	

        WHERE id = 1053																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1053, "Domino DataArchiver", "Domino Mailbox Archiver", null, "Applications", (576 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 140002, 0)



--MISC packages	

 												

 IF EXISTS (Select * from simPackage where id = 1101)				 													

	UPDATE simPackage																				

	SET name="UNIX File System",DisplayName="File System",rank=null,Hierarchy="File System",DescriptionID=(520 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110001,flag=0	

        WHERE id = 1101																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1101, "UNIX File System", "File System", null, "File System", (520 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110001, 0)

 											

 IF EXISTS (Select * from simPackage where id = 1102)				 													

	UPDATE simPackage																				

	SET name="Proxy FileSystem Agent",DisplayName="Proxy FileSystem",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 1102																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1102, "Proxy FileSystem Agent", "Proxy FileSystem", null, "File System", null, 0, 200000, (1 | 2 | (4 | 8)))

 										

 IF EXISTS (Select * from simPackage where id = 1103)				 													

	UPDATE simPackage																				

	SET name="Serverless Data Manager",DisplayName="Serverless Data Manager",rank=null,Hierarchy="Replication",DescriptionID=null,InstallableFromGUI=0,SortID=195001,flag=(1 | 2 | 8)		

        WHERE id = 1103																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1103, "Serverless Data Manager", "Serverless Data Manager", null, "Replication", null, 0, 195001, (1 | 2 | 8))

 								

 IF EXISTS (Select * from simPackage where id = 1104)				 													

	UPDATE simPackage																				

	SET name="Image IDA for UNIX",DisplayName="Image IDA for UNIX",rank=null,Hierarchy="File System",DescriptionID=(551 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=110004,flag=1	

        WHERE id = 1104																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1104, "Image IDA for UNIX", "Image IDA for UNIX", null, "File System", (551 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 110004, 1)

 										

 IF EXISTS (Select * from simPackage where id = 1105)				 													

	UPDATE simPackage																				

	SET name="SCSI Driver",DisplayName="SCSI Driver",rank=null,Hierarchy="Server",DescriptionID=null,InstallableFromGUI=0,SortID=90006,flag=0		

        WHERE id = 1105																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1105, "SCSI Driver", "SCSI Driver", null, "Server", null, 0, 90006, 0)

 											

 IF EXISTS (Select * from simPackage where id = 1106)				 													

	UPDATE simPackage																				

	SET name="Copy Manager Driver",DisplayName="Copy Manager Driver",rank=null,Hierarchy="Replication",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 1106																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1106, "Copy Manager Driver", "Copy Manager Driver", null, "Replication", null, 0, 200000, (1 | 2 | (4 | 8)))

 											

 IF EXISTS (Select * from simPackage where id = 1107)				 													

	UPDATE simPackage																				

	SET name="StorageTek EchoView Enabler",DisplayName="StorageTek EchoView Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 1107																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1107, "StorageTek EchoView Enabler", "StorageTek EchoView Enabler", null, "OSSV Plug-In", null, 0, 200000, (1 | 2 | (4 | 8)))

 										

 IF EXISTS (Select * from simPackage where id = 1109)				 													

	UPDATE simPackage																				

	SET name="Data Archiver for UNIX",DisplayName="Archiver",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=0,SortID=110006,flag=1		

        WHERE id = 1109																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1109, "Data Archiver for UNIX", "Archiver", null, "File System", null, 0, 110006, 1)

 														

 IF EXISTS (Select * from simPackage where id = 1110)				 													

	UPDATE simPackage																				

	SET name="Media Explorer",DisplayName="Media Explorer",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1110																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1110, "Media Explorer", "Media Explorer", null, null, null, 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1112)				 													

	UPDATE simPackage																				

	SET name="Data Classification",DisplayName="Data Classification",rank=null,Hierarchy="Replication",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1112																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1112, "Data Classification", "Data Classification", null, "Replication", null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1113)				 													

	UPDATE simPackage																				

	SET name="File System Filter Driver",DisplayName="File System Filter Driver",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1113																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1113, "File System Filter Driver", "File System Filter Driver", null, null, null, 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1114)				 													

	UPDATE simPackage																				

	SET name="Continuous Data Replicator",DisplayName="Continuous Data Replicator",rank=null,Hierarchy="File System",DescriptionID=(574 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=170000,flag=0	

        WHERE id = 1114																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1114, "Continuous Data Replicator", "Continuous Data Replicator", null, "File System", (574 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 170000, 0)

 											

 IF EXISTS (Select * from simPackage where id = 1115)				 													

	UPDATE simPackage																				

	SET name="OSSV",DisplayName="OSSV",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2)	

        WHERE id = 1115																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1115, "OSSV", "OSSV", null, "OSSV Plug-In", null, 0, 200000, (1 | 2))

 											

 IF EXISTS (Select * from simPackage where id = 1116)				 													

	UPDATE simPackage																				

	SET name="OSSV Enabler",DisplayName="OSSV Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2)	

        WHERE id = 1116																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1116, "OSSV Enabler", "OSSV Enabler", null, "OSSV Plug-In", null, 0, 200000, (1 | 2))

 												

 IF EXISTS (Select * from simPackage where id = 1117)				 													

	UPDATE simPackage																				

	SET name="NetApp SnapShot Enabler",DisplayName="NetApp SnapShot Enabler",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1117																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1117, "NetApp SnapShot Enabler", "NetApp SnapShot Enabler", null, "OSSV Plug-In", null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1118)				 													

	UPDATE simPackage																				

	SET name="CommCell Console",DisplayName="CommCell Console",rank=null,Hierarchy="Server",DescriptionID=null,InstallableFromGUI=1,SortID=100003,flag=0		

        WHERE id = 1118																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1118, "CommCell Console", "CommCell Console", null, "Server", null, 1, 100003, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1119)				 													

	UPDATE simPackage																				

	SET name="1-Touch Boot Server",DisplayName="1-Touch Boot Server",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1119																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1119, "1-Touch Boot Server", "1-Touch Boot Server", null, null, null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1121)				 													

	UPDATE simPackage																				

	SET name="Novell OES Linux FS Agent",DisplayName="Novell OES File System",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=1,SortID=110006,flag=0		

        WHERE id = 1121																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1121, "Novell OES Linux FS Agent", "Novell OES File System", null, "File System", null, 1, 110006, 0)

 										

 IF EXISTS (Select * from simPackage where id = 1122)				 													

	UPDATE simPackage																				

	SET name="Groupwise DB on OES",DisplayName="Groupwise DB on OES",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=0,SortID=110007,flag=(1 | 2 | 4)		

        WHERE id = 1122																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1122, "Groupwise DB on OES", "Groupwise DB on OES", null, "File System", null, 0, 110007, (1 | 2 | 4))

 										

 IF EXISTS (Select * from simPackage where id = 1123)				 													

	UPDATE simPackage																				

	SET name="SRM File System Agent",DisplayName="SRM",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=0,SortID=110020,flag=(1 | 2 | (4 | 8))		

        WHERE id = 1123																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1123, "SRM File System Agent", "SRM", null, "File System", null, 0, 110020, (1 | 2 | (4 | 8)))

 										

 IF EXISTS (Select * from simPackage where id = 1124)				 													

	UPDATE simPackage																				

	SET name="Novell OES Directory Services",DisplayName="Novell OES Directory Services",rank=null,Hierarchy="File System",DescriptionID=null,InstallableFromGUI=0,SortID=110008,flag=(1 | 2 | 4)		

        WHERE id = 1124																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1124, "Novell OES Directory Services", "Novell OES Directory Services", null, "File System", null, 0, 110008, (1 | 2 | 4))

 												

 IF EXISTS (Select * from simPackage where id = 1126)				 													

	UPDATE simPackage																				

	SET name="Documentum Agent",DisplayName="Documentum",rank=null,Hierarchy="Database",DescriptionID=(804 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=110010,flag=0	

        WHERE id = 1126																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1126, "Documentum Agent", "Documentum", null, "Database", (804 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 110010, 0)

 													

 IF EXISTS (Select * from simPackage where id = 1128)				 													

	UPDATE simPackage																				

	SET name="External Data Connector Agent",DisplayName="External Data Connector",rank=null,Hierarchy="Tools",DescriptionID=(803 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=200000,flag=0	

        WHERE id = 1128																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1128, "External Data Connector Agent", "External Data Connector", null, "Tools", (803 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1129)				 													

	UPDATE simPackage																				

	SET name="SAP Archive",DisplayName="SAP Archive",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1129																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1129, "SAP Archive", "SAP Archive", null, null, null, 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1130)				 													

	UPDATE simPackage																				

	SET name="Resource Pack",DisplayName="Resource Pack",rank=null,Hierarchy="Tools",DescriptionID=0,InstallableFromGUI=1,SortID=210000,flag=0	

        WHERE id = 1130																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1130, "Resource Pack", "Resource Pack", null, "Tools", 0, 1, 210000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1131)				 													

	UPDATE simPackage																				

	SET name="Resource Pack Limited Use",DisplayName="Resource Pack Limited Use",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1131																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1131, "Resource Pack Limited Use", "Resource Pack Limited Use", null, null, null, 0, 200000, 0)

 														

 IF EXISTS (Select * from simPackage where id = 1132)				 													

	UPDATE simPackage																				

	SET name="Resource Pack Internal Use",DisplayName="Resource Pack Internal Use",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1132																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1132, "Resource Pack Internal Use", "Resource Pack Internal Use", null, null, null, 0, 200000, 0)

 													

 IF EXISTS (Select * from simPackage where id = 1133)				 													

	UPDATE simPackage																				

	SET name="CDR Predictor",DisplayName="CDR Predictor",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 1133																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1133, "CDR Predictor", "CDR Predictor", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 														

 IF EXISTS (Select * from simPackage where id = 1135)				 													

	UPDATE simPackage																				

	SET name="Web Console",DisplayName="Web Console",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1135																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1135, "Web Console", "Web Console", null, null, null, 0, 200000, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1136)				 													

	UPDATE simPackage																				

	SET name="VirtualServer Agent on UNIX",DisplayName="Virtual Server",rank=null,Hierarchy="Virtualization",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0	

        WHERE id = 1136																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1136, "VirtualServer Agent on UNIX", "Virtual Server", null, "Virtualization", null, 1, 200000, 0)



--DB Agents	

 												

 IF EXISTS (Select * from simPackage where id = 1202)				 													

	UPDATE simPackage																				

	SET name="Sybase Agent",DisplayName="Sybase",rank=null,Hierarchy="Database",DescriptionID=(570 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120005,flag=0	

        WHERE id = 1202																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1202, "Sybase Agent", "Sybase", null, "Database", (570 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120005, 0)

 									

 IF EXISTS (Select * from simPackage where id = 1203)				 													

	UPDATE simPackage																				

	SET name="SybaseIQ Agent",DisplayName="SybaseIQ",rank=null,Hierarchy="Database",DescriptionID=(604 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=120006,flag=0	

        WHERE id = 1203																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1203, "SybaseIQ Agent", "SybaseIQ", null, "Database", (604 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 120006, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1204)				 													

	UPDATE simPackage																				

	SET name="Oracle Agent",DisplayName="Oracle",rank=null,Hierarchy="Database",DescriptionID=(522 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120001,flag=0	

        WHERE id = 1204																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1204, "Oracle Agent", "Oracle", null, "Database", (522 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120001, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1205)				 													

	UPDATE simPackage																				

	SET name="Oracle SAP Agent",DisplayName="SAP for Oracle",rank=null,Hierarchy="Database",DescriptionID=(555 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120002,flag=0	

        WHERE id = 1205																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1205, "Oracle SAP Agent", "SAP for Oracle", null, "Database", (555 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120002, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1206)				 													

	UPDATE simPackage																				

	SET name="SAPMAXDB Agent",DisplayName="SAP for MaxDB",rank=null,Hierarchy="Database",DescriptionID=(565 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120003,flag=0	

        WHERE id = 1206																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1206, "SAPMAXDB Agent", "SAP for MaxDB", null, "Database", (565 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120003, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1207)				 													

	UPDATE simPackage																				

	SET name="DB2 Agent",DisplayName="DB2",rank=null,Hierarchy="Database",DescriptionID=(540 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120004,flag=0	

        WHERE id = 1207																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1207, "DB2 Agent", "DB2", null, "Database", (540 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120004, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1208)				 													

	UPDATE simPackage																				

	SET name="MySQL Agent",DisplayName="MySQL",rank=null,Hierarchy="Database",DescriptionID=(606 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120007,flag=0	

        WHERE id = 1208																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1208, "MySQL Agent", "MySQL", null, "Database", (606 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120007, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1201)				 													

	UPDATE simPackage																				

	SET name="Informix Agent",DisplayName="Informix",rank=null,Hierarchy="Database",DescriptionID=(605 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120008,flag=0	

        WHERE id = 1201																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1201, "Informix Agent", "Informix", null, "Database", (605 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120008, 0)

 												

 IF EXISTS (Select * from simPackage where id = 1209)				 													

	UPDATE simPackage																				

	SET name="Postgre SQL Agent",DisplayName="PostgreSQL",rank=null,Hierarchy="Database",DescriptionID=(607 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=120008,flag=0	

        WHERE id = 1209																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1209, "Postgre SQL Agent", "PostgreSQL", null, "Database", (607 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 120008, 0)

 															

 IF EXISTS (Select * from simPackage where id = 1210)				 													

	UPDATE simPackage																				

	SET name="SAP HANA Agent",DisplayName="SAP for Hana",rank=null,Hierarchy="Database",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 1210																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1210, "SAP HANA Agent", "SAP for Hana", null, "Database", null, 1, 200000, 0)



--MA packages

 												

 IF EXISTS (Select * from simPackage where id = 1301)				 													

	UPDATE simPackage																				

	SET name="MediaAgent",DisplayName="MediaAgent",rank=null,Hierarchy="Server",DescriptionID=(519 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=1,SortID=90004,flag=0	

        WHERE id = 1301																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1301, "MediaAgent", "MediaAgent", null, "Server", (519 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 1, 90004, 0)

 									

 IF EXISTS (Select * from simPackage where id = 1302)				 													

	UPDATE simPackage																				

	SET name="NDMP Remote Server",DisplayName="NDMP Remote Server",rank=null,Hierarchy="Server",DescriptionID=(539 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=90005,flag=0	

        WHERE id = 1302																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1302, "NDMP Remote Server", "NDMP Remote Server", null, "Server", (539 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 90005, 0)

 									

 IF EXISTS (Select * from simPackage where id = 1303)				 													

	UPDATE simPackage																				

	SET name="NAS Restore Enabler",DisplayName="NAS Restore Enabler",rank=null,Hierarchy="File System",DescriptionID=(545 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | 8)	

        WHERE id = 1303																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1303, "NAS Restore Enabler", "NAS Restore Enabler", null, "File System", (545 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | 8))

 														

 IF EXISTS (Select * from simPackage where id = 1304)				 													

	UPDATE simPackage																				

	SET name="SAN Storage Server",DisplayName="SAN Storage Server",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=0	

        WHERE id = 1304																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1304, "SAN Storage Server", "SAN Storage Server", null, null, null, 0, 200000, 0)



--QR Agents	

 								

 IF EXISTS (Select * from simPackage where id = 1351)				 													

	UPDATE simPackage																				

	SET name="OSSV Agent",DisplayName="OSSV Agent",rank=null,Hierarchy="OSSV Plug-In",DescriptionID=(537 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=180005,flag=(1 | 2)	

        WHERE id = 1351																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1351, "OSSV Agent", "OSSV Agent", null, "OSSV Plug-In", (537 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 180005, (1 | 2))



--Snapshot-based packages	

 								

 IF EXISTS (Select * from simPackage where id = 1401)				 													

	UPDATE simPackage																				

	SET name="Qsnap Driver",DisplayName="Qsnap",rank=null,Hierarchy="Replication",DescriptionID=(534 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=195005,flag=0	

        WHERE id = 1401																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (1401, "Qsnap Driver", "Qsnap", null, "Replication", (534 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 195005, 0)



--Netware package

 									

 IF EXISTS (Select * from simPackage where id = 2001)				 													

	UPDATE simPackage																				

	SET name="NetWare File System",DisplayName="NetWare File System",rank=null,Hierarchy="File System",DescriptionID=(520 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))	

        WHERE id = 2001																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2001, "NetWare File System", "NetWare File System", null, "File System", (520 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 2002)				 													

	UPDATE simPackage																				

	SET name="Novell Directory Services",DisplayName="Novell Directory Services",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 2002																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2002, "Novell Directory Services", "Novell Directory Services", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 								

 IF EXISTS (Select * from simPackage where id = 2003)				 													

	UPDATE simPackage																				

	SET name="NetWare MediaAgent",DisplayName="NetWare MediaAgent",rank=null,Hierarchy="Server",DescriptionID=(519 | (CAST(POWER(2, 24) AS BIGINT) * 4)),InstallableFromGUI=0,SortID=90020,flag=(1 | 2 | (4 | 8))	

        WHERE id = 2003																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2003, "NetWare MediaAgent", "NetWare MediaAgent", null, "Server", (519 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 90020, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 2004)				 													

	UPDATE simPackage																				

	SET name="NetWare GroupWise",DisplayName="NetWare GroupWise",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 2004																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2004, "NetWare GroupWise", "NetWare GroupWise", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 2005)				 													

	UPDATE simPackage																				

	SET name="NetWare File System Data Archiver",DisplayName="NetWare File System Data Archiver",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 2005																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2005, "NetWare File System Data Archiver", "NetWare File System Data Archiver", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 													

 IF EXISTS (Select * from simPackage where id = 2006)				 													

	UPDATE simPackage																				

	SET name="NetWare Media Explorer",DisplayName="NetWare Media Explorer",rank=null,Hierarchy=null,DescriptionID=null,InstallableFromGUI=0,SortID=200000,flag=(1 | 2 | (4 | 8))		

        WHERE id = 2006																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (2006, "NetWare Media Explorer", "NetWare Media Explorer", null, null, null, 0, 200000, (1 | 2 | (4 | 8)))

 															

 IF EXISTS (Select * from simPackage where id = 6001)				 													

	UPDATE simPackage																				

	SET name="WinDbg 6.11.1.404",DisplayName="WinDbg 6.11.1.404",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6001																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6001, "WinDbg 6.11.1.404", "WinDbg 6.11.1.404", null, "Other Software Packages", null, 1, 200000, 0)

 															

 IF EXISTS (Select * from simPackage where id = 6002)				 													

	UPDATE simPackage																				

	SET name="Remote CommServe",DisplayName="Remote CommServe",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6002																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6002, "Remote CommServe", "Remote CommServe", null, "Other Software Packages", null, 1, 200000, 0)

 															

 IF EXISTS (Select * from simPackage where id = 6003)				 													

	UPDATE simPackage																				

	SET name="MSSQL Server SP2",DisplayName="MSSQL Server SP2",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6003																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6003, "MSSQL Server SP2", "MSSQL Server SP2", null, "Other Software Packages", null, 1, 200000, 0)

 															

 IF EXISTS (Select * from simPackage where id = 6004)				 													

	UPDATE simPackage																				

	SET name="Mozilla Firefox 5.0.1",DisplayName="Mozilla Firefox 5.0.1",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6004																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6004, "Mozilla Firefox 5.0.1", "Mozilla Firefox 5.0.1", null, "Other Software Packages", null, 1, 200000, 0)

 															

 IF EXISTS (Select * from simPackage where id = 6005)				 													

	UPDATE simPackage																				

	SET name="NotePad++ 5.7",DisplayName="NotePad++ 5.7",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6005																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6005, "NotePad++ 5.7", "NotePad++ 5.7", null, "Other Software Packages", null, 1, 200000, 0)

 															

 IF EXISTS (Select * from simPackage where id = 6006)				 													

	UPDATE simPackage																				

	SET name="Google Chrome 18.0.1025.162",DisplayName="Google Chrome 18.0.1025.162",rank=null,Hierarchy="Other Software Packages",DescriptionID=null,InstallableFromGUI=1,SortID=200000,flag=0			

        WHERE id = 6006																		 			

 ELSE																							

	INSERT INTO simPackage (id, Name, DisplayName, Rank, Hierarchy, DescriptionID, InstallableFromGUI, SortID, Flag)								

	VALUES (6006, "Google Chrome 18.0.1025.162", "Google Chrome 18.0.1025.162", null, "Other Software Packages", null, 1, 200000, 0)







insert into GXDBVersions values(1, ''simPackage'',  ''1.115'', ''simPackage'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE simPackage ADD CONSTRAINT simPackage_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [simPackage]''

END

----------


')
END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'simPackage' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'simPackageDependency_simDependentPackageId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'simPackageDependency' +']' + 'ADD CONSTRAINT [' + 'simPackageDependency_simDependentPackageId_FK' +'] FOREIGN KEY (' + 'simDependentPackageId' + ') REFERENCES ['+ 'simPackage' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'simPackage' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'simPackageDependency_simPackageId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'simPackageDependency' +']' + 'ADD CONSTRAINT [' + 'simPackageDependency_simPackageId_FK' +'] FOREIGN KEY (' + 'simPackageId' + ') REFERENCES ['+ 'simPackage' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'simPackage' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'simInstalledPackages_simPackageID_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'simInstalledPackages' +']' + 'ADD CONSTRAINT [' + 'simInstalledPackages_simPackageID_FK' +'] FOREIGN KEY (' + 'simPackageId' + ') REFERENCES ['+ 'simPackage' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'simPackage' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'simInstalledPackagesHistory_simPackageID_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'simInstalledPackagesHistory' +']' + 'ADD CONSTRAINT [' + 'simInstalledPackagesHistory_simPackageID_FK' +'] FOREIGN KEY (' + 'simPackageId' + ') REFERENCES ['+ 'simPackage' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'simPackage' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'simPackageMap_simPackageId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'simPackageMap' +']' + 'ADD CONSTRAINT [' + 'simPackageMap_simPackageId_FK' +'] FOREIGN KEY (' + 'simPackageId' + ') REFERENCES ['+ 'simPackage' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'simPackage')			
  			insert into GXDBVersions VALUES(1, 'simPackage', '0.0', 'simPackage', '')	
  			UPDATE GXDBVersions SET revision = '1.115' WHERE name = 'simPackage'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'simPackage' + '] upgraded successfully to '			+ ' revision [' + '1.115' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'simPackage' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_CustomCalendar.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_CustomCalendar')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_CustomCalendar')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_CustomCalendar'							
  END																			
  IF (@oldRev = '1.13')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_CustomCalendar' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_CustomCalendar' +'].'							
  END
IF"TINYINT"!="INTEGER"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_CustomCalendar' AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_CustomCalendar' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'APP_CustomCalendar' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'APP_CustomCalendar' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'APP_CustomCalendar' + " ALTER COLUMN "+"origCCId" + " "+"INTEGER"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'APP_CustomCalendar' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'APP_CustomCalendar' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
--IF GUID set to NOT NULL change to NULL for 9.0 Databases that have been upgraded to match 10.0 and 11.0 fresh installs
	IF EXISTS (SELECT 1 WHERE COLUMNPROPERTY(OBJECT_ID('APP_CustomCalendar'), 'GUID', 'AllowsNull') = 0)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

		CREATE TABLE #GuidList (id INT PRIMARY KEY, guid UNIQUEIDENTIFIER)

IF ('INSERT INTO #GuidList SELECT id, GUID FROM APP_CustomCalendar WITH(NOLOCK)' <> '')							
  		SET @sqlString = 'INSERT INTO #GuidList SELECT id, GUID FROM APP_CustomCalendar WITH(NOLOCK)'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME="APP_CustomCalendar" AND COLUMN_NAME="GUID")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name="APP_CustomCalendar" AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="GUID")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = "ALTER TABLE "+"APP_CustomCalendar" +' DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE "+"APP_CustomCalendar" + " DROP COLUMN "+"GUID"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF ('ALTER TABLE APP_CustomCalendar ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_CustomCalendar ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('ALTER TABLE APP_CustomCalendar ADD CONSTRAINT DF_APP_CustomCalendar_GUID DEFAULT (newid()) FOR GUID' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_CustomCalendar ADD CONSTRAINT DF_APP_CustomCalendar_GUID DEFAULT (newid()) FOR GUID'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('UPDATE cc SET GUID = t.GUID FROM APP_CustomCalendar cc,  #GuidList t WHERE t.id = cc.id' <> '')							
  		SET @sqlString = 'UPDATE cc SET GUID = t.GUID FROM APP_CustomCalendar cc,  #GuidList t WHERE t.id = cc.id'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_CustomCalendar')			
  			insert into GXDBVersions VALUES(1, 'APP_CustomCalendar', '0.0', 'APP_CustomCalendar', '')	
  			UPDATE GXDBVersions SET revision = '1.13' WHERE name = 'APP_CustomCalendar'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_CustomCalendar' + '] upgraded successfully to '			+ ' revision [' + '1.13' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_CustomCalendar' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_Client.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_Client')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_Client')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_Client'							
  END																			
  IF (@oldRev = '1.63')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_Client' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_Client' +'].'							
  END
IF"TINYINT"!="INTEGER"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_Client' AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_Client' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'APP_Client' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'APP_Client' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'APP_Client' + " ALTER COLUMN "+"origCCId" + " "+"INTEGER"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'APP_Client' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'APP_Client' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_Client' AND COLUMN_NAME="displayName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_Client' + " ADD "+"displayName" + " "+"nvarchar(255)"		
  			+ " NULL DEFAULT "+"''"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		SET @sqlString = 'UPDATE App_Client SET displayName = name'																			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_Client' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'Client_idx3')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'APP_Client' +'].[' + 'Client_idx3' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_Client' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'gxglobalParam_idx1')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'APP_Client' +'].[' + 'gxglobalParam_idx1' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END--Mistakenly added to App_Client from gxglobalparam.tbl earlier
--4) MR 32263: CS job result dir. should be populated at the time of DBupgrade. (Move this to script file)
	DECLARE @output			VARCHAR(MAX)

	DECLARE @newline		CHAR	

	DECLARE	@jobResultDir	nvarchar(255)

	SET @newline	= char(13)

	SET @output		= ''

	SELECT @jobResultDir = jobResultDir FROM App_Client WHERE id=2

	IF @jobResultDir = '' OR @jobResultDir = 'NO DIR'

	BEGIN

		SELECT @jobResultDir = install_dir FROM APP_Platform where clientId=2 and platformType=1

		SET @jobResultDir = replace(@jobResultDir, 'CommServe', 'iDataAgent\JobResults')

		UPDATE App_Client SET jobResultDir=@jobResultDir where id=2

		SET @output = @output + '------------------------------' + @newline

		SET @output = @output + 'Updated Job result directory for CS -- ' + @jobResultDir + @newline

	END

--IF GUID set to NOT NULL change to NULL for 9.0 Databases that have been upgraded to match 10.0 and 11.0 fresh installs
	IF EXISTS (SELECT 1 WHERE COLUMNPROPERTY(OBJECT_ID('APP_Client'), 'GUID', 'AllowsNull') = 0)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

		CREATE TABLE #GuidList (id INT PRIMARY KEY, guid UNIQUEIDENTIFIER, specialClientFlags INT, displayName nvarchar(255))

IF ('INSERT INTO #GuidList SELECT id, GUID, specialClientFlags, displayName FROM APP_Client WITH(NOLOCK)' <> '')							
  		SET @sqlString = 'INSERT INTO #GuidList SELECT id, GUID, specialClientFlags, displayName FROM APP_Client WITH(NOLOCK)'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
--maintaining current column ordering drop GUID and following columns
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME="APP_Client" AND COLUMN_NAME="GUID")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name="APP_Client" AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="GUID")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = "ALTER TABLE "+"APP_Client" +' DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE "+"APP_Client" + " DROP COLUMN "+"GUID"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME="APP_Client" AND COLUMN_NAME="specialClientFlags")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name="APP_Client" AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="specialClientFlags")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = "ALTER TABLE "+"APP_Client" +' DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE "+"APP_Client" + " DROP COLUMN "+"specialClientFlags"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME="APP_Client" AND COLUMN_NAME="displayName")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name="APP_Client" AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="displayName")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = "ALTER TABLE "+"APP_Client" +' DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE "+"APP_Client" + " DROP COLUMN "+"displayName"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
--now re-add the columns in the same order
IF ('ALTER TABLE APP_Client ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_Client ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('ALTER TABLE APP_Client ADD CONSTRAINT DF_APP_Client_GUID DEFAULT (newid()) FOR GUID' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_Client ADD CONSTRAINT DF_APP_Client_GUID DEFAULT (newid()) FOR GUID'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
--Change specialClientFlags set to NULL change to NOT NULL for 9.0 Databases
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_Client' AND COLUMN_NAME="specialClientFlags")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_Client' + " ADD "+"specialClientFlags" + " "+"INT"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_Client' AND COLUMN_NAME="displayName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_Client' + " ADD "+"displayName" + " "+"NVARCHAR(255)"		
  			+ " NULL DEFAULT "+"''"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
--restore column values
IF ('UPDATE c SET GUID = t.GUID, specialClientFlags = t.specialClientFlags, displayName = t.displayName FROM APP_Client c,  #GuidList t WHERE t.id = c.id' <> '')							
  		SET @sqlString = 'UPDATE c SET GUID = t.GUID, specialClientFlags = t.specialClientFlags, displayName = t.displayName FROM APP_Client c,  #GuidList t WHERE t.id = c.id'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_Client' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'APP_Client_simOperatingSystemId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'APP_Client' +']' + 'ADD CONSTRAINT [' + 'APP_Client_simOperatingSystemId_FK' +'] FOREIGN KEY (' + 'simOperatingSystemId' + ') REFERENCES ['+ 'simOperatingSystem' +'] (' + 'id' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_Client')			
  			insert into GXDBVersions VALUES(1, 'APP_Client', '0.0', 'APP_Client', '')	
  			UPDATE GXDBVersions SET revision = '1.63' WHERE name = 'APP_Client'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_Client' + '] upgraded successfully to '			+ ' revision [' + '1.63' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_Client' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_ClientHistory.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_ClientHistory')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_ClientHistory')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_ClientHistory'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_ClientHistory' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_ClientHistory' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[APP_ClientHistory]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/APP_ClientHistory.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/APP_ClientHistory.tbl,v $ $Id: APP_ClientHistory.tbl,v 1.1 2013/05/28 14:35:08 hkapadia Exp $";

print '... Creating Table: APP_ClientHistory'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table APP_ClientHistory (

	id					integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(255) NOT NULL,

	simOperatingSystemId		integer	NOT NULL,

	net_hostname				nvarchar(255) NOT NULL,

	clientDescription				nvarchar(MAX) NOT NULL,

	releaseId			integer	NOT NULL,

	origCCId			integer		DEFAULT		2	NOT NULL,	-- for CommCell Migration Path

	GUID				uniqueidentifier ROWGUIDCOL,

	displayName			nvarchar(255) DEFAULT '''' NULL,

	deletedTime			integer	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [APP_ClientHistory]''

END

--------





insert into GXDBVersions values(1, ''APP_ClientHistory'',  ''1.1'', ''APP_ClientHistory'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE APP_ClientHistory ADD CONSTRAINT APP_ClientHistory_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_ClientHistory]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_ClientHistory')			
  			insert into GXDBVersions VALUES(1, 'APP_ClientHistory', '0.0', 'APP_ClientHistory', '')	
  			UPDATE GXDBVersions SET revision = '1.1' WHERE name = 'APP_ClientHistory'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_ClientHistory' + '] upgraded successfully to '			+ ' revision [' + '1.1' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_ClientHistory' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_CommCell.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_CommCell')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_CommCell')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_CommCell'							
  END																			
  IF (@oldRev = '1.20')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_CommCell' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_CommCell' +'].'							
  END
IF"INTEGER"!="TINYINT"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_CommCell' AND COLUMN_NAME="type" AND DATA_TYPE="INTEGER")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_CommCell' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="type")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'APP_CommCell' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'APP_CommCell' + " SET "+"type" + " = "+"1" + " WHERE "+"type" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'APP_CommCell' + " ALTER COLUMN "+"type" + " "+"TINYINT"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'APP_CommCell' + '_'+"type" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'APP_CommCell' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"1" + " FOR "+"type"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_CommCell' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="type")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="1") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'APP_CommCell' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'APP_CommCell' + '_'+"type" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'APP_CommCell' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"1" + " FOR "+"type"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
--Move below statement to script file
IF ('IF EXISTS (SELECT 1 from APP_CommCell Where clientid = 0 AND id > 2)
				UPDATE APP_CommCell  SET clientId  = clt.id
				FROM APP_CommCell APC INNER JOIN APP_Client CLT ON APC.csGUID = cast(CLT.GUID as nvarchar(40))
				where APC.clientId = 0 AND APC.id > 2 AND clt.Id <> 2' <> '')							
  		SET @sqlString = 'IF EXISTS (SELECT 1 from APP_CommCell Where clientid = 0 AND id > 2)
				UPDATE APP_CommCell  SET clientId  = clt.id
				FROM APP_CommCell APC INNER JOIN APP_Client CLT ON APC.csGUID = cast(CLT.GUID as nvarchar(40))
				where APC.clientId = 0 AND APC.id > 2 AND clt.Id <> 2'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_CommCell')			
  			insert into GXDBVersions VALUES(1, 'APP_CommCell', '0.0', 'APP_CommCell', '')	
  			UPDATE GXDBVersions SET revision = '1.20' WHERE name = 'APP_CommCell'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_CommCell' + '] upgraded successfully to '			+ ' revision [' + '1.20' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_CommCell' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_CommCellDays.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_CommCellDays')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_CommCellDays')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_CommCellDays'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_CommCellDays' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_CommCellDays' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[APP_CommCellDays]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/APP_CommCellDays.tbl] ---------- 





-- -----------------------------------------------------------------------------------------------------------

-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.

--                                                                                        --------------------

--

-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not

-- evidence any actual or intended publication of such source code.

-- -----------------------------------------------------------------------------------------------------------

-- -----------------------------------------------------------------------------------------------------------

-- Author:	Eugene Volohov

-- Create date: 08/13/2010

-- -----------------------------------------------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/APP_CommCellDays.tbl,v $ $Id: APP_CommCellDays.tbl,v 1.2 2010/09/03 14:10:27 evolohov Exp $";

-- ALLOW_COMMENTS_BELOW_HERE:

print '... Creating Table: APP_CommCellDays'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table APP_CommCellDays (

	CommCellId			integer		NOT NULL,

	DayNum				integer		NOT NULL,

	WkEndActivityOffSetStart	integer		NOT NULL,

	WkEndActivityOffSetEnd		integer		NOT NULL,

	WkEndCoverageOffSetStart	integer		NOT NULL,

	WkEndCoverageOffSetEnd		integer		NOT NULL,

	WkDayActivityOffSetStart	integer		NOT NULL,

	WkDayActivityOffSetEnd		integer		NOT NULL,

	WkDayCoverageOffSetStart	integer		NOT NULL,

	WkdayCoverageOffSetEnd		integer		NOT NULL,

	RelActivityOffSetStart	integer			NOT NULL,

	RelActivityOffSetEnd	integer			NOT NULL,

	ActivityDayStart		integer		NOT NULL,

	ActivityDayEnd			integer		NOT NULL,

	RelCoverageOffSetStart	integer			NOT NULL,

	CoverageDayStart		integer		NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [APP_CommCellDays]''

END

--------





insert into GXDBVersions values(1, ''APP_CommCellDays'',  ''1.2'', ''APP_CommCellDays'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE APP_CommCellDays ADD CONSTRAINT APP_CommCellDays_CommCellId_DayNum_PK 		primary key (CommCellId, DayNum)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_CommCellDays]''

END

----------

ALTER TABLE APP_CommCellDays  ADD CONSTRAINT APP_CommCellDays_CommCellId_FK	foreign key (CommCellId)references	 APP_CommCell(id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_CommCellDays]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_CommCellDays')			
  			insert into GXDBVersions VALUES(1, 'APP_CommCellDays', '0.0', 'APP_CommCellDays', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'APP_CommCellDays'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_CommCellDays' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_CommCellDays' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_CommCellReportProp.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_CommCellReportProp')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_CommCellReportProp')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_CommCellReportProp'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_CommCellReportProp' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_CommCellReportProp' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[APP_CommCellReportProp]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/APP_CommCellReportProp.tbl] ---------- 





-- -----------------------------------------------------------------------------------------------------------

-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.

--                                                                                        --------------------

--

-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not

-- evidence any actual or intended publication of such source code.

-- -----------------------------------------------------------------------------------------------------------

-- -----------------------------------------------------------------------------------------------------------

-- Author:	Eugene Volohov

-- Create date: 08/13/2010

-- -----------------------------------------------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/APP_CommCellReportProp.tbl,v $ $Id: APP_CommCellReportProp.tbl,v 1.2 2010/09/03 14:10:12 evolohov Exp $";

-- ALLOW_COMMENTS_BELOW_HERE:

print '... Creating Table: APP_CommCellReportProp'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table APP_CommCellReportProp (

	CommCellId			integer		NOT NULL,

	TreatWeekend	    integer     NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [APP_CommCellReportProp]''

END

--------





insert into GXDBVersions values(1, ''APP_CommCellReportProp'',  ''1.2'', ''APP_CommCellReportProp'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE APP_CommCellReportProp ADD CONSTRAINT APP_CommCellReportProp_CommCellId_PK 		primary key (CommCellId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_CommCellReportProp]''

END

----------

ALTER TABLE APP_CommCellReportProp  ADD CONSTRAINT APP_CommCellReportProp_CommCellId_FK	foreign key (CommCellId)references	 APP_CommCell(id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_CommCellReportProp]''

END

----------


')
END
--Move insert values to tbl or tblscript
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_CommCellReportProp')			
  			insert into GXDBVersions VALUES(1, 'APP_CommCellReportProp', '0.0', 'APP_CommCellReportProp', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'APP_CommCellReportProp'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_CommCellReportProp' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_CommCellReportProp' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_CommCellProp.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'App_CommCellProp')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'App_CommCellProp')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'App_CommCellProp'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'App_CommCellProp' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'App_CommCellProp' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[APP_CommCellProp]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/APP_CommCellProp.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/APP_CommCellProp.tbl,v $ $Id: APP_CommCellProp.tbl,v 1.3 2011/08/23 12:46:53 pkrishnan Exp $";

-- Added to hold data collection policy params of foregin commcells.

-- Currently we only have events and job realted info here.

print '... Creating Table: APP_CommCellProp'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table APP_CommCellProp (

	CommCellId                         integer                     NOT NULL,

	LastEventID                     integer                     NOT NULL,

	LastEventUpdateTime             DATETIME                    NULL,

	LastJobUpdateTime               DATETIME                    NULL,

	LastCompletedJobUpdateTime      DATETIME                    NULL,

	LastMaxChunkId	  	    bigint default 0	NOT NULL,	--The maximum chunkId that we got during our last sync up with remote cell



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [APP_CommCellProp]''

END

--------





insert into GXDBVersions values(1, ''APP_CommCellProp'',  ''1.3'', ''APP_CommCellProp'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE APP_CommCellProp  ADD CONSTRAINT APP_CommCellProp_CommCellId_FK	foreign key (CommCellId)references	 App_CommCell(Id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [APP_CommCellProp]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'App_CommCellProp')			
  			insert into GXDBVersions VALUES(1, 'App_CommCellProp', '0.0', 'App_CommCellProp', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'App_CommCellProp'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'App_CommCellProp' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'App_CommCellProp' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/CN2DataCollectionPolicy.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
	BEGIN

		IF EXISTS (SELECT * FROM sysobjects WHERE type = 'U' AND name = 'CN2DataCollectionPolicy')			
  	BEGIN																					
  		EXECUTE @retCode = cvsp_drop_pk 'CN2DataCollectionPolicy'											
     		DELETE FROM GXDBVersions WHERE name = 'CN2DataCollectionPolicy'										
          DROP TABLE  CN2DataCollectionPolicy																
  		SET @sqlError = @@error																
  		IF (@sqlError <> 0)																							
  	BEGIN																									
      PRINT 'RETVAL: 99 TABLE ' + 'CN2DataCollectionPolicy' + ' SQL ERROR: [' + CONVERT(CHAR(5), @sqlError) + ']'					
  	RETURN																									
  	END																
  		SET @retCode = 0																	
  		PRINT 'RETVAL: 0	 TABLE ['+'CN2DataCollectionPolicy' +'] Successfully Dropped.'				
  	END

	END

END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/simAdditionalPackage.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: simAdditionalPackage.upg,v 1.6 2014/05/05 20:15:47 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'simAdditionalPackage')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'simAdditionalPackage')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'simAdditionalPackage'							
  END																			
  IF (@oldRev = '1.5')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'simAdditionalPackage' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'simAdditionalPackage' +'].'							
  END-- Get @oldRev, compare to '1.5'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[simAdditionalPackage]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/simAdditionalPackage.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/simAdditionalPackage.tbl,v $ $Id: simAdditionalPackage.tbl,v 1.5 2012/10/16 22:59:28 hkapadia Exp $";

print '... Creating Table: simAdditionalPackage'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table simAdditionalPackage (

	PkgId				integer	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	Name				varchar(256) NOT NULL,

	BinarySetId			integer	NOT NULL,

	OSName				varchar(1024)	NOT NULL,

	InstallCmd			varchar(1024)	NOT NULL,

	PostInstallCmd		varchar(1024)	NOT NULL,

	UnInstallCmd		varchar(1024)	NOT NULL,

	installRetCode		integer DEFAULT 0	NOT NULL,

	uninstallRetCode	integer DEFAULT 0	NOT NULL,

	spare1				integer DEFAULT 0	NOT NULL,

	spare2				varchar(1024) NULL,

	spare3				integer DEFAULT 0	NOT NULL,

	IsAvailable			integer DEFAULT 0	NOT NULL,

	NoMultiselect		integer DEFAULT 0	NOT NULL,

	RebootReq			integer DEFAULT 0	NOT NULL,

	CanUninstall		integer DEFAULT 1	NOT NULL,

	InstallFromShare	integer DEFAULT 0	NOT NULL,

	UninstallFromShare	integer DEFAULT 0	NOT NULL,

	FolderName			varchar(1024)	NOT NULL,

	DisplayName				varchar(256) NOT NULL,

	spare4				varchar(MAX)NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [simAdditionalPackage]''

END

--------





SET QUOTED_IDENTIFIER OFF



')
 exec ('

DECLARE @tblRetCode integer  

-- TABLENAME simAdditionalPackage





-- TABLENAME simAdditionalPackage

DELETE simAdditionalPackage

set @tblRetCode = @@error   

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 98 Table [simAdditionalPackage]''

END

-----------------------------------------------------



SET QUOTED_IDENTIFIER OFF

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6001 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="WinDbg 6.11.1.404", FolderName="WinDbg 6.11.1.404",DisplayName="WinDbg 6.11.1.404",OSName="win32",InstallCmd=''msiexec /qn /i dbg_x86_6.11.1.404.msi'',PostInstallCmd=''Debugging Tools for Windows (x86)\windbg.exe -IS'',UnInstallCmd=''msiexec.exe /qn /x ''	

        WHERE PkgId = 6001 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6001, "WinDbg 6.11.1.404", "WinDbg 6.11.1.404","WinDbg 6.11.1.404",1, "win32",''msiexec /qn /i dbg_x86_6.11.1.404.msi'',''Debugging Tools for Windows (x86)\windbg.exe -IS'',''msiexec.exe /qn /x '')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6001 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="WinDbg 6.11.1.404", FolderName="WinDbg 6.11.1.404",DisplayName="WinDbg 6.11.1.404",OSName="winx64",InstallCmd=''msiexec /qn /i dbg_amd64_6.11.1.404.msi'',PostInstallCmd=''Debugging Tools for Windows (x64)\windbg.exe -IS'',UnInstallCmd=''msiexec.exe /qn /x ''	

        WHERE PkgId = 6001 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6001, "WinDbg 6.11.1.404", "WinDbg 6.11.1.404","WinDbg 6.11.1.404",3, "winx64",''msiexec /qn /i dbg_amd64_6.11.1.404.msi'',''Debugging Tools for Windows (x64)\windbg.exe -IS'',''msiexec.exe /qn /x '')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6002 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="Remote CommServe", FolderName="Remote CommServe",DisplayName="Remote CommServe",OSName="win32",InstallCmd=''Setup.exe /play Install.xml'',PostInstallCmd='''',UnInstallCmd=''quninstallall.exe /q /inst ''	

        WHERE PkgId = 6002 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6002, "Remote CommServe", "Remote CommServe","Remote CommServe",1, "win32",''Setup.exe /play Install.xml'','''',''quninstallall.exe /q /inst '')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6002 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="Remote CommServe", FolderName="Remote CommServe",DisplayName="Remote CommServe",OSName="winx64",InstallCmd=''Setup.exe /play Install.xml'',PostInstallCmd='''',UnInstallCmd=''quninstallall.exe /q /inst ''	

        WHERE PkgId = 6002 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6002, "Remote CommServe", "Remote CommServe","Remote CommServe",3, "winx64",''Setup.exe /play Install.xml'','''',''quninstallall.exe /q /inst '')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6003 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="MSSQL Server SP2", FolderName="MSSQL Server SP2",DisplayName="MSSQL Server SP2",OSName="win32",InstallCmd=''MSSQLSP.exe /ACTION=Patch /Q /instancename=COMMVAULT /HideConsole'',PostInstallCmd='''',UnInstallCmd=''Microsoft SQL Server\100\Setup Bootstrap\Update Cache\KB2285068\ServicePack\setup.exe /ACTION=RemovePatch /Q /instancename=COMMVAULT /HideConsole''	

        WHERE PkgId = 6003 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6003, "MSSQL Server SP2", "MSSQL Server SP2","MSSQL Server SP2",1, "win32",''MSSQLSP.exe /ACTION=Patch /Q /instancename=COMMVAULT /HideConsole'','''',''Microsoft SQL Server\100\Setup Bootstrap\Update Cache\KB2285068\ServicePack\setup.exe /ACTION=RemovePatch /Q /instancename=COMMVAULT /HideConsole'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6003 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="MSSQL Server SP2", FolderName="MSSQL Server SP2",DisplayName="MSSQL Server SP2",OSName="winx64",InstallCmd=''MSSQLSP.exe /ACTION=Patch /Q /instancename=COMMVAULT /HideConsole'',PostInstallCmd='''',UnInstallCmd=''Microsoft SQL Server\100\Setup Bootstrap\Update Cache\KB2285068\ServicePack\setup.exe /ACTION=RemovePatch /Q /instancename=COMMVAULT /HideConsole''	

        WHERE PkgId = 6003 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6003, "MSSQL Server SP2", "MSSQL Server SP2","MSSQL Server SP2",3, "winx64",''MSSQLSP.exe /ACTION=Patch /Q /instancename=COMMVAULT /HideConsole'','''',''Microsoft SQL Server\100\Setup Bootstrap\Update Cache\KB2285068\ServicePack\setup.exe /ACTION=RemovePatch /Q /instancename=COMMVAULT /HideConsole'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6004 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="Mozilla Firefox 5.0.1", FolderName="Mozilla Firefox 5.0.1",DisplayName="Mozilla Firefox 5.0.1",OSName="win32",InstallCmd=''Firefox Setup 5.0.1.exe -ms'',PostInstallCmd='''',UnInstallCmd=''Mozilla Firefox\uninstall\helper.exe /s''	

        WHERE PkgId = 6004 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6004, "Mozilla Firefox 5.0.1", "Mozilla Firefox 5.0.1","Mozilla Firefox 5.0.1",1, "win32",''Firefox Setup 5.0.1.exe -ms'','''',''Mozilla Firefox\uninstall\helper.exe /s'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6004 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="Mozilla Firefox 5.0.1", FolderName="Mozilla Firefox 5.0.1",DisplayName="Mozilla Firefox 5.0.1",OSName="winx64",InstallCmd=''Firefox Setup 5.0.1.exe -ms'',PostInstallCmd='''',UnInstallCmd=''Mozilla Firefox\uninstall\helper.exe /s''	

        WHERE PkgId = 6004 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6004, "Mozilla Firefox 5.0.1", "Mozilla Firefox 5.0.1","Mozilla Firefox 5.0.1",3, "winx64",''Firefox Setup 5.0.1.exe -ms'','''',''Mozilla Firefox\uninstall\helper.exe /s'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6005 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="NotePad++ 5.7", FolderName="NotePad++ 5.7",DisplayName="NotePad++ 5.7",OSName="win32",InstallCmd=''npp.5.7.Installer.exe /S'',PostInstallCmd='''',UnInstallCmd=''Notepad++\uninstall.exe /S''	

        WHERE PkgId = 6005 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6005, "NotePad++ 5.7", "NotePad++ 5.7","NotePad++ 5.7",1, "win32",''npp.5.7.Installer.exe /S'','''',''Notepad++\uninstall.exe /S'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6005 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="NotePad++ 5.7", FolderName="NotePad++ 5.7",DisplayName="NotePad++ 5.7",OSName="winx64",InstallCmd=''npp.5.7.Installer.exe /S'',PostInstallCmd='''',UnInstallCmd=''Notepad++\uninstall.exe /S''	

        WHERE PkgId = 6005 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6005, "NotePad++ 5.7", "NotePad++ 5.7","NotePad++ 5.7",3, "winx64",''npp.5.7.Installer.exe /S'','''',''Notepad++\uninstall.exe /S'')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6006 and BinarySetId = 1)											

	UPDATE simAdditionalPackage 																		

	SET Name="Google Chrome 18.0.1025.162", FolderName="Google Chrome 18.0.1025.162",DisplayName="Google Chrome 18.0.1025.162",OSName="win32",InstallCmd=''msiexec /qn /i GoogleChromeStandaloneEnterprise.msi'',PostInstallCmd='''',UnInstallCmd=''msiexec.exe /qn /x ''	

        WHERE PkgId = 6006 and BinarySetId = 1																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6006, "Google Chrome 18.0.1025.162", "Google Chrome 18.0.1025.162","Google Chrome 18.0.1025.162",1, "win32",''msiexec /qn /i GoogleChromeStandaloneEnterprise.msi'','''',''msiexec.exe /qn /x '')

				

 IF EXISTS (Select * from simAdditionalPackage where PkgId = 6006 and BinarySetId = 3)											

	UPDATE simAdditionalPackage 																		

	SET Name="Google Chrome 18.0.1025.162", FolderName="Google Chrome 18.0.1025.162",DisplayName="Google Chrome 18.0.1025.162",OSName="winx64",InstallCmd=''msiexec /qn /i GoogleChromeStandaloneEnterprise.msi'',PostInstallCmd='''',UnInstallCmd=''msiexec.exe /qn /x ''	

        WHERE PkgId = 6006 and BinarySetId = 3																

 ELSE																						

	INSERT INTO simAdditionalPackage (PkgId, Name, FolderName,DisplayName,BinarySetId, OSName,InstallCmd,PostInstallCmd,UnInstallCmd)					

 	VALUES (6006, "Google Chrome 18.0.1025.162", "Google Chrome 18.0.1025.162","Google Chrome 18.0.1025.162",3, "winx64",''msiexec /qn /i GoogleChromeStandaloneEnterprise.msi'','''',''msiexec.exe /qn /x '')







insert into GXDBVersions values(1, ''simAdditionalPackage'',  ''1.5'', ''simAdditionalPackage'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE simAdditionalPackage ADD CONSTRAINT simAdditionalPackage_PkgId_BinarySetId_PK 		primary key (PkgId,BinarySetId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [simAdditionalPackage]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'simAdditionalPackage')			
  			insert into GXDBVersions VALUES(1, 'simAdditionalPackage', '0.0', 'simAdditionalPackage', '')	
  			UPDATE GXDBVersions SET revision = '1.5' WHERE name = 'simAdditionalPackage'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'simAdditionalPackage' + '] upgraded successfully to '			+ ' revision [' + '1.5' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'simAdditionalPackage' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/GXGlobalParam.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'GXGlobalParam')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'GXGlobalParam')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'GXGlobalParam'							
  END																			
  IF (@oldRev = '1.120')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'GXGlobalParam' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'GXGlobalParam' +'].'							
  END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GXGlobalParam' AND COLUMN_NAME = 'id')
	BEGIN

IF ('sp_rename ''GxGlobalParam'', ''GxGlobalParam_old''' <> '')							
  		SET @sqlString = 'sp_rename ''GxGlobalParam'', ''GxGlobalParam_old'''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('DELETE FROM GXDBVersions where name = ''GxGlobalParam'' and type = 1' <> '')							
  		SET @sqlString = 'DELETE FROM GXDBVersions where name = ''GxGlobalParam'' and type = 1'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[GXGlobalParam]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/GXGlobalParam.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/GXGlobalParam.tbl,v $ $Id: GXGlobalParam.tbl,v 1.120 2013/04/04 21:44:40 chandru Exp $";

print '... Creating Table: GXGlobalParam'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table GXGlobalParam (

	id					INTEGER NOT NULL IDENTITY (1,1),			-- PRIMARY KEY FOR THIS TABLE

	name				nvarchar(64) NOT NULL,

	value				nvarchar(max) NOT NULL,

	created				INTEGER  NOT NULL,

	modified			INTEGER  NOT NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [GXGlobalParam]''

END

--------





create unique nonclustered index gxglobalParam_idx1 on GXGlobalParam (id, name);



create index gxglobalParam_idx2 on GXGlobalParam (name, modified);

 

-- NOTE: TABLE DATA MOVED TO GXGlobalParam.script



insert into GXDBVersions values(1, ''GXGlobalParam'',  ''1.120'', ''GXGlobalParam'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')
END
		INSERT GxGlobalParam (name, value, created, modified)

			SELECT name, ISNULL(value, N''), 473385600, 0						-- (date = January 1, 1985)

			FROM GxGlobalParam_old

		DROP TABLE GxGlobalParam_old

	END

--The following query should be moved to App_Client
	SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'App_Client' AND xType = 'U')				

    IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'gxglobalParam_idx1')						

    BEGIN																								

		SET @sqlString = 'DROP INDEX [App_Client].[gxglobalParam_idx1]'							

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'GXGlobalParam' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'gxglobalParam_idx1')					
      BEGIN																								
  		SET @sqlString = 'CREATE UNIQUE INDEX [' + 'gxglobalParam_idx1' +']' + 'ON [' + 'GXGlobalParam' +']  (' + 'id, name' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'GXGlobalParam')			
  			insert into GXDBVersions VALUES(1, 'GXGlobalParam', '0.0', 'GXGlobalParam', '')	
  			UPDATE GXDBVersions SET revision = '1.120' WHERE name = 'GXGlobalParam'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'GXGlobalParam' + '] upgraded successfully to '			+ ' revision [' + '1.120' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'GXGlobalParam' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/GxSQLSPID_Info.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'GxSQLSPID_Info')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'GxSQLSPID_Info')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'GxSQLSPID_Info'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'GxSQLSPID_Info' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'GxSQLSPID_Info' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[GxSQLSPID_Info]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/GxSQLSPID_Info.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/GxSQLSPID_Info.tbl,v $ $Id: GxSQLSPID_Info.tbl,v 1.4 2012/08/09 14:52:06 mklose Exp $";

print '... Creating Table: GxSQLSPID_Info'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table GxSQLSPID_Info (

	SPInfoId				INTEGER NOT NULL IDENTITY (1,1),

	atime					DATETIME,

	SPID 					integer	NOT NULL,

	originalGroupId 		integer	NOT NULL,

	blockedBy               INTEGER	NOT NULL,

	waittime                INTEGER	NOT NULL,

	waittype                INTEGER	NOT NULL,

	objectid                INTEGER	NOT NULL,

	objectname              VARCHAR(256)	NOT NULL,

	lastwaittype       		NVARCHAR(32)	NOT NULL,

	waitresource      		NVARCHAR(128)	NOT NULL,

	cpu                     INTEGER	NOT NULL,

	physical_io        		INTEGER	NOT NULL,

	memusage                INTEGER	NOT NULL,

	open_tran               INTEGER	NOT NULL,

	status                  NVARCHAR(64)	NOT NULL,

	hostprocess      		NVARCHAR(8)	NOT NULL,

	cmd                     NVARCHAR(128)	NOT NULL,

	LastCommand				VARCHAR(max)null,

	last_batch              DATETIME,

	login_time              DATETIME,

	sql_handle              BINARY(20),

	stmt_start              INTEGER	NOT NULL,

	stmt_end                INTEGER	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [GxSQLSPID_Info]''

END

--------





CREATE INDEX GxSQLSPID_Info_SPID_last_batch ON GxSQLSPID_Info(last_batch,SPID)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [GxSQLSPID_Info]''

END

----------



CREATE INDEX GxSQLSPID_Info_originalGroupId on GxSQLSPID_Info(originalGroupId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [GxSQLSPID_Info]''

END

----------





insert into GXDBVersions values(1, ''GxSQLSPID_Info'',  ''1.4'', ''GxSQLSPID_Info'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE GxSQLSPID_Info ADD CONSTRAINT GxSQLSPID_Info_SPInfoId_PK 		primary key (SPInfoId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [GxSQLSPID_Info]''

END

----------


')
END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'GxSQLSPID_Info' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'GxSQLSPID_Info_originalGroupId')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'GxSQLSPID_Info_originalGroupId' +']' + 'ON [' + 'GxSQLSPID_Info' +']  (' + 'originalGroupId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'GxSQLSPID_Info')			
  			insert into GXDBVersions VALUES(1, 'GxSQLSPID_Info', '0.0', 'GxSQLSPID_Info', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'GxSQLSPID_Info'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'GxSQLSPID_Info' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'GxSQLSPID_Info' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/GXUniqueSQLScriptExecTracking.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: GXUniqueSQLScriptExecTracking.upg,v 1.2 2015/07/12 17:53:07 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'GXUniqueSQLScriptExecTracking')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'GXUniqueSQLScriptExecTracking')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'GXUniqueSQLScriptExecTracking'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'GXUniqueSQLScriptExecTracking' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'GXUniqueSQLScriptExecTracking' +'].'							
  END-- Get @oldRev, compare to '1.2'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[GXUniqueSQLScriptExecTracking]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/GXUniqueSQLScriptExecTracking.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/GXUniqueSQLScriptExecTracking.tbl,v $ $Id: GXUniqueSQLScriptExecTracking.tbl,v 1.2 2015/07/12 17:53:17 chandru Exp $";

print '... Creating Table: GXUniqueSQLScriptExecTracking'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table GXUniqueSQLScriptExecTracking (

	SqlScriptGUID			UNIQUEIDENTIFIER NOT NULL,

	Name					VARCHAR(256)	NOT NULL,

	Description				NVARCHAR(MAX) NOT NULL,

	CreatedTime				INT	NOT NULL,

	CreatedRelId			INT	NOT NULL,

	ExpireTime				INT	NOT NULL,

	ExpireRelId				INT	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [GXUniqueSQLScriptExecTracking]''

END

--------





CREATE INDEX GXUniqueSQLScriptExecTracking_Name_Idx ON GXUniqueSQLScriptExecTracking (Name)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [GXUniqueSQLScriptExecTracking]''

END

----------





insert into GXDBVersions values(1, ''GXUniqueSQLScriptExecTracking'',  ''1.2'', ''GXUniqueSQLScriptExecTracking'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE GXUniqueSQLScriptExecTracking ADD CONSTRAINT GXUniqueSQLScriptExecTracking_SqlScriptGUID_PK 		primary key (SqlScriptGUID)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [GXUniqueSQLScriptExecTracking]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'GXUniqueSQLScriptExecTracking')			
  			insert into GXDBVersions VALUES(1, 'GXUniqueSQLScriptExecTracking', '0.0', 'GXUniqueSQLScriptExecTracking', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'GXUniqueSQLScriptExecTracking'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'GXUniqueSQLScriptExecTracking' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'GXUniqueSQLScriptExecTracking' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMDSProviders.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMDSProviders')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMDSProviders')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMDSProviders'							
  END																			
  IF (@oldRev = '1.37')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMDSProviders' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMDSProviders' +'].'							
  END
IF"tinyint"!="integer"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMDSProviders' AND COLUMN_NAME="origCCId" AND DATA_TYPE="tinyint")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMDSProviders' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'UMDSProviders' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'UMDSProviders' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'UMDSProviders' + " ALTER COLUMN "+"origCCId" + " "+"integer"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'UMDSProviders' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'UMDSProviders' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMDSProviders' AND COLUMN_NAME="ownerId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMDSProviders' + " ADD "+"ownerId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"1"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMDSProviders' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="resourceId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMDSProviders' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMDSProviders' + '_'+"resourceId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMDSProviders' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"resourceId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMDSProviders')			
  			insert into GXDBVersions VALUES(1, 'UMDSProviders', '0.0', 'UMDSProviders', '')	
  			UPDATE GXDBVersions SET revision = '1.37' WHERE name = 'UMDSProviders'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMDSProviders' + '] upgraded successfully to '			+ ' revision [' + '1.37' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMDSProviders' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMusers.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: UMUsers.upg,v 1.16 2015/06/01 14:06:59 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMUsers')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMUsers')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMUsers'							
  END																			
  IF (@oldRev = '1.29')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMUsers' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMUsers' +'].'							
  END--	 Get @oldRev, compare to '1.29'. Chk for work to do.
IF"TINYINT"!="INTEGER"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUsers' AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUsers' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'UMUsers' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'UMUsers' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'UMUsers' + " ALTER COLUMN "+"origCCId" + " "+"INTEGER"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'UMUsers' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'UMUsers' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
	IF NOT EXISTS (SELECT * FROM UMUSERS WHERE id = -30)

	BEGIN

		SET IDENTITY_INSERT UMUsers ON

--Insert dummy user id: -30
		INSERT INTO UMUsers (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified, 

						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId) 

		VALUES(-30, "Dummy WebReports Tag User", 'Dummy WebReports Tag user is referred in DM2DocTags and UserToTagXML tables.', "_+_DummyWebReportsTagUser_", 'Password Disabled', 'No Email', (CASE WHEN getUTCdate() < '01/01/1970' THEN 0 ELSE datediff(second, '01/01/1970', getUTCdate()) END), 0, 0, 0, 2 | 4, 0, 

						0,    '',    0,             0,            0)		

		/*				

IF ("INSERT INTO UMUsers (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId)		VALUES(-30, "Dummy WebReports Tag User", 'Dummy WebReports Tag user is referred in DM2DocTags and UserToTagXML tables.', "_+_DummyWebReportsTagUser_", 'Password Disabled', 'No Email', @nowTime, 0, 0, 0, @user_perm |@user_hide, 0,						0,    '',    0,             0,            0) " <> '')							
  		SET @sqlString = "INSERT INTO UMUsers (id, name, description, login, password, email, datePasswordSet, dateExpires, policy, enabled, flags, modified,						pVer, Pager, lastLogInTime, credSetTime, umDSproviderId)		VALUES(-30, "Dummy WebReports Tag User", 'Dummy WebReports Tag user is referred in DM2DocTags and UserToTagXML tables.', "_+_DummyWebReportsTagUser_", 'Password Disabled', 'No Email', @nowTime, 0, 0, 0, @user_perm |@user_hide, 0,						0,    '',    0,             0,            0) "				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		*/

		SET IDENTITY_INSERT UMUsers OFF

	END

IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUsers' AND COLUMN_NAME="description" AND IS_NULLABLE = 'YES'))			
  	BEGIN				
  		SET @sqlString = "UPDATE " + 'UMUsers' + " SET "+"description" + " = "+"''" + " WHERE "+"description" + " is NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END		
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'UMUsers' AND COLUMN_NAME="description"							
  		IF  (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUsers' AND xType = 'U')								
  			SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="description")			
  			SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  			WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF(@constId IS NOT NULL)																			
  			BEGIN																								
  				SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'UMUsers' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'UMUsers' + " ALTER COLUMN "+"description" + " "+"NVARCHAR(MAX)"		
  			+ " NOT NULL" 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF(LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'UMUsers' + " ADD CONSTRAINT " + @cName + " DEFAULT " + @DefaultValAttr + " FOR "+"description"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMUsers')			
  			insert into GXDBVersions VALUES(1, 'UMUsers', '0.0', 'UMUsers', '')	
  			UPDATE GXDBVersions SET revision = '1.29' WHERE name = 'UMUsers'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMUsers' + '] upgraded successfully to '			+ ' revision [' + '1.29' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMUsers' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMUserCredentials.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMUserCredentials')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMUserCredentials')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMUserCredentials'							
  END																			
  IF (@oldRev = '1.11')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMUserCredentials' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMUserCredentials' +'].'							
  END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="taskId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"taskId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="workflowId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"workflowId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="logMonitoringPolicyId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"logMonitoringPolicyId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="arrayId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"arrayId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="cloudId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"cloudId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="userGroupId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"userGroupId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="providerId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"providerId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId1")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId1" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId2")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId2" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId3")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId3" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId4")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId4" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId5")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId5" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId6")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId6" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId7")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId7" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId8")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId8" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="entityId9")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"entityId9" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="clientGroupId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"clientGroupId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"clientGroupId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="clientId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"clientId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"clientId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="appTypeId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"appTypeId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"appTypeId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="instanceId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"instanceId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"instanceId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="backupsetId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"backupsetId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"backupsetId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="subClientId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"subClientId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"subClientId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="mediaAgentId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"mediaAgentId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"mediaAgentId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="libraryId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"libraryId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"libraryId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="archGroupId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"archGroupId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"archGroupId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="vtContainerId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"vtContainerId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"vtContainerId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="vtPolicyId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"vtPolicyId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"vtPolicyId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="vtShelfId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'UMUserCredentials' + '_'+"vtShelfId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"vtShelfId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_2')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMUserCredentials' +'].[' + 'UMUserCredentials_2' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE CLUSTERED INDEX [' + 'UMUserCredentials_userId_idx' +']' + 'ON [' + 'UMUserCredentials' +']  (' + 'userId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="permissionBitArray")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"permissionBitArray" + " "+"varbinary(2000)"		
  			+ " NOT NULL DEFAULT "+"0x0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="extendedPermissionBitArray")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD "+"extendedPermissionBitArray" + " "+"varbinary(2000)"		
  			+ " NOT NULL DEFAULT "+"0x0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_filtered')					
      BEGIN   
  		SET @sqlString = 'SET QUOTED_IDENTIFIER ON '  																					
  		SET @sqlString += 'CREATE INDEX [' + 'UMUserCredentials_userId_filtered' +']' + 'ON [' + 'UMUserCredentials' +']  (' + 'userId' + ') INCLUDE ('+ 'capabilities,permissionBitArray,extendedPermissionBitArray' + ') WHERE ('+'[commcellId]=(2) AND [clientid]=(0) AND [clientgroupid]=(0) AND [mediaAgentId]=(0) AND [libraryId]=(0) AND [archGroupId]=(0) AND [taskId]=(0) AND [vtContainerId]=(0) AND [vtPolicyId]=(0) AND [vtShelfId]=(0) AND [reviewSetId]=(0) AND [querySetId]=(0) AND [downloadSetId]=(0) AND [tagId]=(0) AND [legalHoldId]=(0) AND [ermId]=(0) AND [cdPolicyId]=(0) AND [complianceReportId]=(0) AND [workflowId]=(0) AND [logMonitoringPolicyId]=(0) AND [arrayId]=(0) AND [cloudId]=(0) AND [userGroupId]=(0) AND [providerId]=(0) AND [entityId1]=(0) AND [entityId2]=(0) AND [entityId3]=(0) AND [entityId4]=(0) AND [entityId5]=(0) AND [entityId6]=(0) AND [entityId7]=(0) AND [entityId8]=(0) AND [entityId9]=(0)'+') '							 
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered')					
      BEGIN   
  		SET @sqlString = 'SET QUOTED_IDENTIFIER ON '  																					
  		SET @sqlString += 'CREATE INDEX [' + 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered' +']' + 'ON [' + 'UMUserCredentials' +']  (' + 'userId,clientId,appTypeId,instanceId,backupsetId,subClientId' + ') INCLUDE ('+ 'capabilities,permissionBitArray,extendedPermissionBitArray' + ') WHERE ('+'clientId<>0'+') '							 
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
		IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME = 'capabilities' AND IS_NULLABLE = 'YES'))	

		BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_filtered')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMUserCredentials_userId_filtered' +'] ON [' + 'UMUserCredentials' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered' +'] ON [' + 'UMUserCredentials' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="capabilities" AND IS_NULLABLE = 'YES'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'UMUserCredentials' AND COLUMN_NAME="capabilities"							
  		IF NOT (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "DELETE FROM " + 'UMUserCredentials' + " WHERE "+"capabilities" + " IS NULL"																			
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																												
  		END																									
  		ELSE																								
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="capabilities")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'UMUserCredentials' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ALTER COLUMN "+"capabilities" + " "+"bigint"		
  		+ " NOT NULL" 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'UMUserCredentials' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"capabilities"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_filtered')					
      BEGIN   
  		SET @sqlString = 'SET QUOTED_IDENTIFIER ON '  																					
  		SET @sqlString += 'CREATE INDEX [' + 'UMUserCredentials_userId_filtered' +']' + 'ON [' + 'UMUserCredentials' +']  (' + 'userId' + ') INCLUDE ('+ 'capabilities,permissionBitArray,extendedPermissionBitArray' + ') WHERE ('+'[commcellId]=(2) AND [clientid]=(0) AND [clientgroupid]=(0) AND [mediaAgentId]=(0) AND [libraryId]=(0) AND [archGroupId]=(0) AND [taskId]=(0) AND [vtContainerId]=(0) AND [vtPolicyId]=(0) AND [vtShelfId]=(0) AND [reviewSetId]=(0) AND [querySetId]=(0) AND [downloadSetId]=(0) AND [tagId]=(0) AND [legalHoldId]=(0) AND [ermId]=(0) AND [cdPolicyId]=(0) AND [complianceReportId]=(0) AND [workflowId]=(0) AND [logMonitoringPolicyId]=(0) AND [arrayId]=(0) AND [cloudId]=(0) AND [userGroupId]=(0) AND [providerId]=(0) AND [entityId1]=(0) AND [entityId2]=(0) AND [entityId3]=(0) AND [entityId4]=(0) AND [entityId5]=(0) AND [entityId6]=(0) AND [entityId7]=(0) AND [entityId8]=(0) AND [entityId9]=(0)'+') '							 
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMUserCredentials' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered')					
      BEGIN   
  		SET @sqlString = 'SET QUOTED_IDENTIFIER ON '  																					
  		SET @sqlString += 'CREATE INDEX [' + 'UMUserCredentials_userId_clientId_appTypeId_instanceId_backupSetId_subclientId_filtered' +']' + 'ON [' + 'UMUserCredentials' +']  (' + 'userId,clientId,appTypeId,instanceId,backupsetId,subClientId' + ') INCLUDE ('+ 'capabilities,permissionBitArray,extendedPermissionBitArray' + ') WHERE ('+'clientId<>0'+') '							 
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
		END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMUserCredentials')			
  			insert into GXDBVersions VALUES(1, 'UMUserCredentials', '0.0', 'UMUserCredentials', '')	
  			UPDATE GXDBVersions SET revision = '1.11' WHERE name = 'UMUserCredentials'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMUserCredentials' + '] upgraded successfully to '			+ ' revision [' + '1.11' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMUserCredentials' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
    END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_iDAType.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: APP_IDAType.upg,v 1.23 2015/06/24 18:25:09 chandru Exp $
BEGIN

    SET QUOTED_IDENTIFIER OFF

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_IDAType')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_IDAType')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_IDAType'							
  END																			
  IF (@oldRev = '1.121')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_IDAType' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_IDAType' +'].'							
  END-- Get @oldRev, compare to '1.121'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_IDAType' AND COLUMN_NAME="displayName")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_IDAType' + " ADD "+"displayName" + " "+"varchar(255)"		
  			+ " NOT NULL DEFAULT "+"''"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_IDAType' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="displayName")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="''") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'APP_IDAType' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'APP_IDAType' + '_'+"displayName" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'APP_IDAType' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"''" + " FOR "+"displayName"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_IDAType' AND COLUMN_NAME="indexSpaceSaver")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_IDAType' + " ADD "+"indexSpaceSaver" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_IDAType')			
  			insert into GXDBVersions VALUES(1, 'APP_IDAType', '0.0', 'APP_IDAType', '')	
  			UPDATE GXDBVersions SET revision = '1.121' WHERE name = 'APP_IDAType'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_IDAType' + '] upgraded successfully to '			+ ' revision [' + '1.121' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_IDAType' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END	

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_iDAType_post.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: APP_IDAType_post.upg,v 1.6 2014/05/04 04:54:55 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/APP_IDAType.script,v $ $Id: APP_IDAType.script,v 1.119 2015/07/15 21:16:29 xsui Exp $";

-- For 9.0, we are adding a column 'isCWEjobValid' and on update, preserving some of the existing settings where before all were being overwritten  -SKatz

-- Preserve:  priority, updateRecoSec, chunksizeMB, updateIntervalSec

--

--


DECLARE @gpBackslashString        NVARCHAR(2)

DECLARE @empty			         NVARCHAR(2)

DECLARE @exMbPubFolderDefContent	NVARCHAR(10)

DECLARE @tblRetCode integer

set @gpBackslashString	= "\"

set @empty = ""

set @exMbPubFolderDefContent = "\\MB"

SET NOCOUNT ON

SET QUOTED_IDENTIFIER OFF
	
 IF EXISTS (Select * from APP_iDAType where type = 0)												 
     UPDATE APP_idaType SET name = "Default Application Type Name", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Default Application Type Name",												 
							indexSpaceSaver = 1											
                            WHERE type =0															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (0, "Default Application Type Name", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Default Application Type Name", 1)

/* PROTOTYPE

Most defs in appMgrDbDefines.h, some in EvSecurityConst.h. '|' below indicates logical "OR" (Choose 1), not bitwise "OR".

type					CV_APPTYPE_??,

name					CV_APPTYPE_??_NAME, 

treeType				[1 | 2 | 3],

AppGroup1				100001,

priority				["6" | "0"],					

caseSensitivity			["0" | "1"],

dirOrder				["0" | "1" | "2"],

dirDelim				@gpBackslashString | @exMbPubFolderDefContent | "/" ,

updateRecoSec			["300"|"300"|"300"]

chunkSizeMB				["4096" | "16384" ],

updateIntervalSec		["300" | "300" | "300"]

*/
	
 IF EXISTS (Select * from APP_iDAType where type = 1)												 
     UPDATE APP_idaType SET name = "Windows NT File System", treeType = 1, appGroup1 = 100001,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =1															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1, "Windows NT File System", 1, 100001, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 3)												 
     UPDATE APP_idaType SET name = "Informix Database", treeType = 3, appGroup1 = 100003,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Informix",												 
							indexSpaceSaver = 1											
                            WHERE type =3															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (3, "Informix Database", 3, 100003, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Informix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 4)												 
     UPDATE APP_idaType SET name = "SQL Server", treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = "SQL Server",												 
							indexSpaceSaver = 1											
                            WHERE type =4															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (4, "SQL Server", 2, 100004, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 81, 0,"SQL Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 5)												 
     UPDATE APP_idaType SET name = "Sybase Database", treeType = 3, appGroup1 = 100005,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Sybase",												 
							indexSpaceSaver = 1											
                            WHERE type =5															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (5, "Sybase Database", 3, 100005, "0", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Sybase", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 6)												 
     UPDATE APP_idaType SET name = "Unix Notes Database", treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Database",												 
							indexSpaceSaver = 1											
                            WHERE type =6															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (6, "Unix Notes Database", 3, 100006, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 59, 0,"Notes Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 7)												 
     UPDATE APP_idaType SET name = "Notes Document", treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 1,											 
							displayName = "Notes Document",												 
							indexSpaceSaver = 1											
                            WHERE type =7															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (7, "Notes Document", 3, 100007, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 60, 1,"Notes Document", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 8)												 
     UPDATE APP_idaType SET name = "Exchange 5.5 Mailbox", treeType = 1, appGroup1 = 100008,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox",												 
							indexSpaceSaver = 1											
                            WHERE type =8															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (8, "Exchange 5.5 Mailbox", 1, 100008, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 54, 1,"Exchange Mailbox", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 9)												 
     UPDATE APP_idaType SET name = "Exchange 5.5 Database", treeType = 3, appGroup1 = 100009,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Database",												 
							indexSpaceSaver = 1											
                            WHERE type =9															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (9, "Exchange 5.5 Database", 3, 100009, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 53, 0,"Exchange Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 13)												 
     UPDATE APP_idaType SET name = "NAS", treeType = 1, appGroup1 = 100013,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "NAS",												 
							indexSpaceSaver = 1											
                            WHERE type =13															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (13, "NAS", 1, 100013, "6", "1", "1",				 
	           "/", "300", "16384", "300", 0, 1,"NAS", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 14)												 
     UPDATE APP_idaType SET name = "Exchange 2000 Mailbox", treeType = 1, appGroup1 = 100014,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox",												 
							indexSpaceSaver = 1											
                            WHERE type =14															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (14, "Exchange 2000 Mailbox", 1, 100014, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 54, 1,"Exchange Mailbox", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 15)												 
     UPDATE APP_idaType SET name = "Exchange 2000 Database", treeType = 3, appGroup1 = 100015,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Database",												 
							indexSpaceSaver = 1											
                            WHERE type =15															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (15, "Exchange 2000 Database", 3, 100015, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 53, 0,"Exchange Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1000)												 
     UPDATE APP_idaType SET name = "CommServe Management", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommServe StorageManager",												 
							indexSpaceSaver = 1											
                            WHERE type =1000															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1000, "CommServe Management", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommServe StorageManager", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1001)												 
     UPDATE APP_idaType SET name = "CommClient Management", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "iDataAgent Base",												 
							indexSpaceSaver = 1											
                            WHERE type =1001															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1001, "CommClient Management", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"iDataAgent Base", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1002)												 
     UPDATE APP_idaType SET name = "MediaAgent Management", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "MediaAgent",												 
							indexSpaceSaver = 1											
                            WHERE type =1002															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1002, "MediaAgent Management", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"MediaAgent", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 11)												 
     UPDATE APP_idaType SET name = "Windows 2000 File System", treeType = 1, appGroup1 = 100011,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =11															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (11, "Windows 2000 File System", 1, 100011, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 10)												 
     UPDATE APP_idaType SET name = "Novell Directory Services", treeType = 1, appGroup1 = 100010,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "2", dirdelim = ".",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Novell Directory Services",												 
							indexSpaceSaver = 1											
                            WHERE type =10															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (10, "Novell Directory Services", 1, 100010, "6", "0", "2",				 
	           ".", "300", "4096", "300", 0, 1,"Novell Directory Services", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 12)												 
     UPDATE APP_idaType SET name = "NetWare File System", treeType = 1, appGroup1 = 100012,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 12,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =12															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (12, "NetWare File System", 1, 100012, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 12, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 16)												 
     UPDATE APP_idaType SET name = "SQL Server", treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = "SQL Server",												 
							indexSpaceSaver = 1											
                            WHERE type =16															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (16, "SQL Server", 2, 100004, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 81, 0,"SQL Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 17)												 
     UPDATE APP_idaType SET name = "HP-UX File System", treeType = 1, appGroup1 = 100017,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =17															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (17, "HP-UX File System", 1, 100017, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 18)												 
     UPDATE APP_idaType SET name = "HP-UX 64bit File System", treeType = 1, appGroup1 = 100018,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =18															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (18, "HP-UX 64bit File System", 1, 100018, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 19)												 
     UPDATE APP_idaType SET name = "Solaris File System", treeType = 1, appGroup1 = 100019,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =19															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (19, "Solaris File System", 1, 100019, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 20)												 
     UPDATE APP_idaType SET name = "Solaris 64bit File System", treeType = 1, appGroup1 = 100020,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =20															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (20, "Solaris 64bit File System", 1, 100020, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 21)												 
     UPDATE APP_idaType SET name = "AIX File System", treeType = 1, appGroup1 = 100021,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =21															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (21, "AIX File System", 1, 100021, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 22)												 
     UPDATE APP_idaType SET name = "Oracle Database", treeType = 3, appGroup1 = 100022,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = "Oracle",												 
							indexSpaceSaver = 1											
                            WHERE type =22															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (22, "Oracle Database", 3, 100022, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 22, 0,"Oracle", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 23)												 
     UPDATE APP_idaType SET name = "Oracle8 Serverless Database", treeType = 3, appGroup1 = 100023,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = "Oracle8 Serverless Database",												 
							indexSpaceSaver = 1											
                            WHERE type =23															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (23, "Oracle8 Serverless Database", 3, 100023, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 22, 0,"Oracle8 Serverless Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 2)												 
     UPDATE APP_idaType SET name = "Oracle Database", treeType = 3, appGroup1 = 100002,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 22,														 
							isCWEjobValid = 0,											 
							displayName = "Oracle Database",												 
							indexSpaceSaver = 1											
                            WHERE type =2															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (2, "Oracle Database", 3, 100002, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 22, 0,"Oracle Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1003)												 
     UPDATE APP_idaType SET name = "NAS MediaAgent Client", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NetApp NAS",												 
							indexSpaceSaver = 1											
                            WHERE type =1003															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1003, "NAS MediaAgent Client", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NetApp NAS", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 24)												 
     UPDATE APP_idaType SET name = "Serverless Data Manager", treeType = 3, appGroup1 = 100024,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Serverless Data Manager",												 
							indexSpaceSaver = 1											
                            WHERE type =24															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (24, "Serverless Data Manager", 3, 100024, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 1,"Serverless Data Manager", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 25)												 
     UPDATE APP_idaType SET name = "ProxyHost", treeType = 1, appGroup1 = 100025,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "ProxyHost",												 
							indexSpaceSaver = 1											
                            WHERE type =25															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (25, "ProxyHost", 1, 100025, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"ProxyHost", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 26)												 
     UPDATE APP_idaType SET name = "FasTrax Exchange Mailbox", treeType = 1, appGroup1 = 100026,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 54,														 
							isCWEjobValid = 0,											 
							displayName = "FasTrax Exchange Mailbox",												 
							indexSpaceSaver = 1											
                            WHERE type =26															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (26, "FasTrax Exchange Mailbox", 1, 100026, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 54, 0,"FasTrax Exchange Mailbox", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 27)												 
     UPDATE APP_idaType SET name = "FasTrax Exchange Database", treeType = 3, appGroup1 = 100027,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = "FasTrax Exchange Database",												 
							indexSpaceSaver = 1											
                            WHERE type =27															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (27, "FasTrax Exchange Database", 3, 100027, "6", "0", "1",				 
	           @gpBackslashString, "300", "16384", "300", 53, 0,"FasTrax Exchange Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 28)												 
     UPDATE APP_idaType SET name = "FasTrax File System", treeType = 1, appGroup1 = 100028,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "FasTrax File System",												 
							indexSpaceSaver = 1											
                            WHERE type =28															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (28, "FasTrax File System", 1, 100028, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"FasTrax File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 29)												 
     UPDATE APP_idaType SET name = "Linux File System", treeType = 1, appGroup1 = 100029,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =29															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (29, "Linux File System", 1, 100029, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 30)												 
     UPDATE APP_idaType SET name = "FasTrax Exchange 2000 Mailbox", treeType = 1, appGroup1 = 100030,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 54,														 
							isCWEjobValid = 0,											 
							displayName = "FasTrax Exchange 2000 Mailbox",												 
							indexSpaceSaver = 1											
                            WHERE type =30															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (30, "FasTrax Exchange 2000 Mailbox", 1, 100030, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 54, 0,"FasTrax Exchange 2000 Mailbox", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 31)												 
     UPDATE APP_idaType SET name = "FasTrax Exchange 2000 Database", treeType = 3, appGroup1 = 100031,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = "FasTrax Exchange 2000 Database",												 
							indexSpaceSaver = 1											
                            WHERE type =31															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (31, "FasTrax Exchange 2000 Database", 3, 100031, "6", "0", "1",				 
	           @gpBackslashString, "300", "16384", "300", 53, 0,"FasTrax Exchange 2000 Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 32)												 
     UPDATE APP_idaType SET name = "SharePoint Database", treeType = 3, appGroup1 = 100032,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SharePoint Database",												 
							indexSpaceSaver = 1											
                            WHERE type =32															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (32, "SharePoint Database", 3, 100032, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SharePoint Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 33)												 
     UPDATE APP_idaType SET name = "Windows File System", treeType = 1, appGroup1 = 100033,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =33															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (33, "Windows File System", 1, 100033, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 34)												 
     UPDATE APP_idaType SET name = "Windows XP 64-bit File System", treeType = 1, appGroup1 = 100034,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =34															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (34, "Windows XP 64-bit File System", 1, 100034, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 35)												 
     UPDATE APP_idaType SET name = "Exchange Public Folder", treeType = 1, appGroup1 = 100035,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Public Folder",												 
							indexSpaceSaver = 1											
                            WHERE type =35															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (35, "Exchange Public Folder", 1, 100035, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 0, 0,"Exchange Public Folder", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 36)												 
     UPDATE APP_idaType SET name = "Unix Tru64 64-bit File System", treeType = 1, appGroup1 = 100036,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =36															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (36, "Unix Tru64 64-bit File System", 1, 100036, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 38)												 
     UPDATE APP_idaType SET name = "Proxy Client File System", treeType = 1, appGroup1 = 100038,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Proxy Client File System",												 
							indexSpaceSaver = 1											
                            WHERE type =38															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (38, "Proxy Client File System", 1, 100038, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"Proxy Client File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 39)												 
     UPDATE APP_idaType SET name = "Software Data Mover", treeType = 1, appGroup1 = 100039,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Software Data Mover",												 
							indexSpaceSaver = 1											
                            WHERE type =39															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (39, "Software Data Mover", 1, 100039, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"Software Data Mover", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1004)												 
     UPDATE APP_idaType SET name = "NDMP MediaAgent Client", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NDMP Remote Tape Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1004															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1004, "NDMP MediaAgent Client", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NDMP Remote Tape Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 40)												 
     UPDATE APP_idaType SET name = "ProxyHost on Unix", treeType = 1, appGroup1 = 100040,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "ProxyHost",												 
							indexSpaceSaver = 1											
                            WHERE type =40															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (40, "ProxyHost on Unix", 1, 100040, "6", "1", "1",				 
	           "/", "300", "4096", "300", 0, 1,"ProxyHost", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 41)												 
     UPDATE APP_idaType SET name = "Active Directory", treeType = 1, appGroup1 = 100041,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "2", dirdelim = ",",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Active Directory",												 
							indexSpaceSaver = 1											
                            WHERE type =41															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (41, "Active Directory", 1, 100041, "6", "0", "2",				 
	           ",", "300", "4096", "300", 0, 0,"Active Directory", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1005)												 
     UPDATE APP_idaType SET name = "Copy Manager", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Copy Manager",												 
							indexSpaceSaver = 1											
                            WHERE type =1005															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1005, "Copy Manager", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Copy Manager", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1006)												 
     UPDATE APP_idaType SET name = "EZ Browse Media Agent", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "EZ Browse Media Agent",												 
							indexSpaceSaver = 1											
                            WHERE type =1006															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1006, "EZ Browse Media Agent", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"EZ Browse Media Agent", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 42)												 
     UPDATE APP_idaType SET name = "Windows 2003 32-bit File System", treeType = 1, appGroup1 = 100042,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =42															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (42, "Windows 2003 32-bit File System", 1, 100042, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 43)												 
     UPDATE APP_idaType SET name = "Windows 2003 64-bit File System", treeType = 1, appGroup1 = 100043,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =43															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (43, "Windows 2003 64-bit File System", 1, 100043, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 44)												 
     UPDATE APP_idaType SET name = "Exchange 2000 Web Folder", treeType = 1, appGroup1 = 100044,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Web Folder",												 
							indexSpaceSaver = 1											
                            WHERE type =44															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (44, "Exchange 2000 Web Folder", 1, 100044, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 0, 0,"Exchange Web Folder", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 45)												 
     UPDATE APP_idaType SET name = "Exchange 2000 Mailbox Archiver", treeType = 1, appGroup1 = 100045,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =45															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (45, "Exchange 2000 Mailbox Archiver", 1, 100045, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 53, 1,"Exchange Mailbox Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 46)												 
     UPDATE APP_idaType SET name = "SharePoint Document", treeType = 1, appGroup1 = 100046,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SharePoint Document",												 
							indexSpaceSaver = 1											
                            WHERE type =46															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (46, "SharePoint Document", 1, 100046, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 0, 0,"SharePoint Document", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 47)												 
     UPDATE APP_idaType SET name = "OSSV Plug-in on Windows", treeType = 1, appGroup1 = 100047,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "OSSV Plug-in",												 
							indexSpaceSaver = 1											
                            WHERE type =47															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (47, "OSSV Plug-in on Windows", 1, 100047, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"OSSV Plug-in", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 48)												 
     UPDATE APP_idaType SET name = "Serverless Data Manager on Unix", treeType = 1, appGroup1 = 100048,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Serverless Data Manager on Unix",												 
							indexSpaceSaver = 1											
                            WHERE type =48															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (48, "Serverless Data Manager on Unix", 1, 100048, "6", "1", "1",				 
	           "/", "300", "4096", "300", 0, 1,"Serverless Data Manager on Unix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1007)												 
     UPDATE APP_idaType SET name = "CommVault Software Snapshot", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QSnap",												 
							indexSpaceSaver = 1											
                            WHERE type =1007															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1007, "CommVault Software Snapshot", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QSnap", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 49)												 
     UPDATE APP_idaType SET name = "Unigraphics", treeType = 1, appGroup1 = 100049,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unigraphics",												 
							indexSpaceSaver = 1											
                            WHERE type =49															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (49, "Unigraphics", 1, 100049, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Unigraphics", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 50)												 
     UPDATE APP_idaType SET name = "OSSV Plug-in on Unix", treeType = 1, appGroup1 = 100050,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "OSSV Plug-in",												 
							indexSpaceSaver = 1											
                            WHERE type =50															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (50, "OSSV Plug-in on Unix", 1, 100050, "6", "1", "1",				 
	           "/", "300", "4096", "300", 0, 1,"OSSV Plug-in", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 51)												 
     UPDATE APP_idaType SET name = "Notes Database", treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Database",												 
							indexSpaceSaver = 1											
                            WHERE type =51															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (51, "Notes Database", 3, 100006, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 59, 0,"Notes Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 52)												 
     UPDATE APP_idaType SET name = "Unix Notes Document", treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Document",												 
							indexSpaceSaver = 1											
                            WHERE type =52															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (52, "Unix Notes Document", 3, 100007, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 60, 0,"Notes Document", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 37)												 
     UPDATE APP_idaType SET name = "DB2", treeType = 3, appGroup1 = 100037,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DB2",												 
							indexSpaceSaver = 1											
                            WHERE type =37															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (37, "DB2", 3, 100037, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"DB2", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 53)												 
     UPDATE APP_idaType SET name = "Exchange Database", treeType = 3, appGroup1 = 100053,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 53,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Database",												 
							indexSpaceSaver = 1											
                            WHERE type =53															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (53, "Exchange Database", 3, 100053, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 53, 0,"Exchange Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 54)												 
     UPDATE APP_idaType SET name = "Exchange Mailbox", treeType = 1, appGroup1 = 100054,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 54,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox",												 
							indexSpaceSaver = 1											
                            WHERE type =54															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (54, "Exchange Mailbox", 1, 100054, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 54, 1,"Exchange Mailbox", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 55)												 
     UPDATE APP_idaType SET name = "Exchange Web Folder", treeType = 1, appGroup1 = 100055,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange Web Folder",												 
							indexSpaceSaver = 1											
                            WHERE type =55															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (55, "Exchange Web Folder", 1, 100055, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 0, 0,"Exchange Web Folder", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 56)												 
     UPDATE APP_idaType SET name = "Exchange Mailbox Archiver", treeType = 1, appGroup1 = 100056,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =56															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (56, "Exchange Mailbox Archiver", 1, 100056, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"Exchange Mailbox Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 57)												 
     UPDATE APP_idaType SET name = "Exchange 5.5 Mailbox Archiver", treeType = 1, appGroup1 = 100057,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Mailbox Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =57															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (57, "Exchange 5.5 Mailbox Archiver", 1, 100057, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"Exchange Mailbox Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 58)												 
     UPDATE APP_idaType SET name = "Windows File Archiver", treeType = 1, appGroup1 = 100058,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = "File Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =58															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (58, "Windows File Archiver", 1, 100058, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 58, 1,"File Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 59)												 
     UPDATE APP_idaType SET name = "Notes Database", treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Database",												 
							indexSpaceSaver = 1											
                            WHERE type =59															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (59, "Notes Database", 3, 100006, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 59, 0,"Notes Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 60)												 
     UPDATE APP_idaType SET name = "Notes Document", treeType = 3, appGroup1 = 100007,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 60,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Document",												 
							indexSpaceSaver = 1											
                            WHERE type =60															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (60, "Notes Document", 3, 100007, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 60, 0,"Notes Document", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 61)												 
     UPDATE APP_idaType SET name = "SAP for Oracle", treeType = 3, appGroup1 = 100061,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SAP for Oracle",												 
							indexSpaceSaver = 1											
                            WHERE type =61															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (61, "SAP for Oracle", 3, 100061, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SAP for Oracle", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 62)												 
     UPDATE APP_idaType SET name = "DB2 on Unix", treeType = 3, appGroup1 = 100062,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DB2",												 
							indexSpaceSaver = 1											
                            WHERE type =62															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (62, "DB2 on Unix", 3, 100062, "6", "1", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"DB2", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1008)												 
     UPDATE APP_idaType SET name = "OSSV Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QREnabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1008															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1008, "OSSV Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QREnabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1009)												 
     UPDATE APP_idaType SET name = "NAS Restore Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NAS Restore Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1009															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1009, "NAS Restore Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NAS Restore Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1010)												 
     UPDATE APP_idaType SET name = "Centerra", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 33,														 
							isCWEjobValid = 0,											 
							displayName = "Centera",												 
							indexSpaceSaver = 1											
                            WHERE type =1010															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1010, "Centerra", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 33, 0,"Centera", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1011)												 
     UPDATE APP_idaType SET name = "CommCell Explorer", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommCell Explorer",												 
							indexSpaceSaver = 1											
                            WHERE type =1011															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1011, "CommCell Explorer", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommCell Explorer", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1012)												 
     UPDATE APP_idaType SET name = "SNMP Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SNMP Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1012															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1012, "SNMP Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SNMP Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1013)												 
     UPDATE APP_idaType SET name = "OSSV Enabler Snap View", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QREnabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1013															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1013, "OSSV Enabler Snap View", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QREnabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1014)												 
     UPDATE APP_idaType SET name = "Java Gui", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Java Gui",												 
							indexSpaceSaver = 1											
                            WHERE type =1014															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1014, "Java Gui", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Java Gui", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1015)												 
     UPDATE APP_idaType SET name = "MMC Gui", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "MMC Gui",												 
							indexSpaceSaver = 1											
                            WHERE type =1015															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1015, "MMC Gui", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"MMC Gui", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 64)												 
     UPDATE APP_idaType SET name = "SGI FileSystem", treeType = 1, appGroup1 = 100064,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =64															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (64, "SGI FileSystem", 1, 100064, "6", "1", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 65)												 
     UPDATE APP_idaType SET name = "Image Level", treeType = 1, appGroup1 = 100065,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Image Level",												 
							indexSpaceSaver = 1											
                            WHERE type =65															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (65, "Image Level", 1, 100065, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 1,"Image Level", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 63)												 
     UPDATE APP_idaType SET name = "MAC FileSystem", treeType = 1, appGroup1 = 100063,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =63															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (63, "MAC FileSystem", 1, 100063, "6", "1", "1",				 
	           "/", "300", "4096", "300", 0, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1016)												 
     UPDATE APP_idaType SET name = "Content Indexing Engine", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Content Indexing",												 
							indexSpaceSaver = 1											
                            WHERE type =1016															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1016, "Content Indexing Engine", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Content Indexing", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1017)												 
     UPDATE APP_idaType SET name = "Echo View Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Echo View Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1017															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1017, "Echo View Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Echo View Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1018)												 
     UPDATE APP_idaType SET name = "QNet Agent", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QNet Agent",												 
							indexSpaceSaver = 1											
                            WHERE type =1018															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1018, "QNet Agent", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QNet Agent", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 66)												 
     UPDATE APP_idaType SET name = "Unix File Archiver", treeType = 1, appGroup1 = 100066,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = "File Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =66															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (66, "Unix File Archiver", 1, 100066, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 58, 1,"File Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1019)												 
     UPDATE APP_idaType SET name = "Vault Tracker Enterprise", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Vault Tracker Enterprise",												 
							indexSpaceSaver = 1											
                            WHERE type =1019															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1019, "Vault Tracker Enterprise", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Vault Tracker Enterprise", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1020)												 
     UPDATE APP_idaType SET name = "Magnetic Library", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Disk Library Connector (DDO)",												 
							indexSpaceSaver = 1											
                            WHERE type =1020															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1020, "Magnetic Library", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Disk Library Connector (DDO)", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1021)												 
     UPDATE APP_idaType SET name = "Data Encryption", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Encryption",												 
							indexSpaceSaver = 1											
                            WHERE type =1021															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1021, "Data Encryption", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Encryption", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1022)												 
     UPDATE APP_idaType SET name = "Data Verification", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Verification",												 
							indexSpaceSaver = 1											
                            WHERE type =1022															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1022, "Data Verification", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Verification", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1023)												 
     UPDATE APP_idaType SET name = "Data Multiplexing", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Multiplexing",												 
							indexSpaceSaver = 1											
                            WHERE type =1023															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1023, "Data Multiplexing", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Multiplexing", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1024)												 
     UPDATE APP_idaType SET name = "Commcell Migration", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommCell Migration",												 
							indexSpaceSaver = 1											
                            WHERE type =1024															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1024, "Commcell Migration", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommCell Migration", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 67)												 
     UPDATE APP_idaType SET name = "Exchange Compliance Archiver", treeType = 1, appGroup1 = 100067,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Compliance Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =67															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (67, "Exchange Compliance Archiver", 1, 100067, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"Exchange Compliance Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 68)												 
     UPDATE APP_idaType SET name = "Exchange 5.5 Compliance Archiver", treeType = 1, appGroup1 = 100068,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Exchange Compliance Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =68															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (68, "Exchange 5.5 Compliance Archiver", 1, 100068, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"Exchange Compliance Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1025)												 
     UPDATE APP_idaType SET name = "Galaxy Compliance", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "WORM Support",												 
							indexSpaceSaver = 1											
                            WHERE type =1025															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1025, "Galaxy Compliance", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"WORM Support", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1026)												 
     UPDATE APP_idaType SET name = "Grid Store", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Grid Store",												 
							indexSpaceSaver = 1											
                            WHERE type =1026															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1026, "Grid Store", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Grid Store", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1027)												 
     UPDATE APP_idaType SET name = "Optical Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Optical Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1027															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1027, "Optical Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Optical Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 69)												 
     UPDATE APP_idaType SET name = "SharePoint Server Database", treeType = 3, appGroup1 = 100069,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SharePoint Server Database",												 
							indexSpaceSaver = 1											
                            WHERE type =69															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (69, "SharePoint Server Database", 3, 100069, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SharePoint Server Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 70)												 
     UPDATE APP_idaType SET name = "SQL Server", treeType = 2, appGroup1 = 100004,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = "SQL Server",												 
							indexSpaceSaver = 1											
                            WHERE type =70															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (70, "SQL Server", 2, 100004, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 81, 0,"SQL Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 71)												 
     UPDATE APP_idaType SET name = "GroupWise DB", treeType = 3, appGroup1 = 100071,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "GroupWise DB",												 
							indexSpaceSaver = 1											
                            WHERE type =71															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (71, "GroupWise DB", 3, 100071, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"GroupWise DB", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 72)												 
     UPDATE APP_idaType SET name = "Recovery Director", treeType = 1, appGroup1 = 100072,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Recovery Director",												 
							indexSpaceSaver = 1											
                            WHERE type =72															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (72, "Recovery Director", 1, 100072, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Recovery Director", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 73)												 
     UPDATE APP_idaType SET name = "File Share Archiver", treeType = 1, appGroup1 = 100073,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 58,														 
							isCWEjobValid = 1,											 
							displayName = "File Share Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =73															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (73, "File Share Archiver", 1, 100073, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 58, 1,"File Share Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1029)												 
     UPDATE APP_idaType SET name = "Open Systems SnapVault (OSSV)", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Open Systems SnapVault (OSSV)",												 
							indexSpaceSaver = 1											
                            WHERE type =1029															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1029, "Open Systems SnapVault (OSSV)", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Open Systems SnapVault (OSSV)", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 74)												 
     UPDATE APP_idaType SET name = "FreeBSD", treeType = 1, appGroup1 = 100074,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "File System",												 
							indexSpaceSaver = 1											
                            WHERE type =74															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (74, "FreeBSD", 1, 100074, "6", "0", "1",				 
	           "/", "300", "4096", "300", 33, 1,"File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 75)												 
     UPDATE APP_idaType SET name = "Image Level On Unix", treeType = 1, appGroup1 = 100075,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Image Level on Unix",												 
							indexSpaceSaver = 1											
                            WHERE type =75															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (75, "Image Level On Unix", 1, 100075, "6", "0", "1",				 
	           "/", "300", "4096", "300", 0, 1,"Image Level on Unix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 76)												 
     UPDATE APP_idaType SET name = "Image Level ProxyHost", treeType = 1, appGroup1 = 100076,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Image Level ProxyHost",												 
							indexSpaceSaver = 1											
                            WHERE type =76															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (76, "Image Level ProxyHost", 1, 100076, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"Image Level ProxyHost", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1031)												 
     UPDATE APP_idaType SET name = "ONTAP support for SnapVault", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "ONTAP support for SnapVault",												 
							indexSpaceSaver = 1											
                            WHERE type =1031															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1031, "ONTAP support for SnapVault", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"ONTAP support for SnapVault", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 77)												 
     UPDATE APP_idaType SET name = "Unix Notes Database", treeType = 3, appGroup1 = 100006,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 59,														 
							isCWEjobValid = 0,											 
							displayName = "Notes Database",												 
							indexSpaceSaver = 1											
                            WHERE type =77															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (77, "Unix Notes Database", 3, 100006, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 59, 0,"Notes Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 78)												 
     UPDATE APP_idaType SET name = "SharePoint Server", treeType = 1, appGroup1 = 100078,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 78,														 
							isCWEjobValid = 1,											 
							displayName = "Sharepoint Server",												 
							indexSpaceSaver = 1											
                            WHERE type =78															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (78, "SharePoint Server", 1, 100078, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 78, 1,"Sharepoint Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1032)												 
     UPDATE APP_idaType SET name = "1-Touch Server for Unix", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "1-Touch Server for Unix",												 
							indexSpaceSaver = 1											
                            WHERE type =1032															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1032, "1-Touch Server for Unix", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"1-Touch Server for Unix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1030)												 
     UPDATE APP_idaType SET name = "Subclient Policy", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Subclient Policy",												 
							indexSpaceSaver = 1											
                            WHERE type =1030															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1030, "Subclient Policy", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Subclient Policy", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 79)												 
     UPDATE APP_idaType SET name = "SAP for MAX DB", treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SAP for MAX DB",												 
							indexSpaceSaver = 1											
                            WHERE type =79															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (79, "SAP for MAX DB", 3, 100079, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SAP for MAX DB", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1035)												 
     UPDATE APP_idaType SET name = "Content Addressed Storage", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Content Addressed Storage",												 
							indexSpaceSaver = 1											
                            WHERE type =1035															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1035, "Content Addressed Storage", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Content Addressed Storage", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1036)												 
     UPDATE APP_idaType SET name = "DVD Support", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DVD Support",												 
							indexSpaceSaver = 1											
                            WHERE type =1036															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1036, "DVD Support", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"DVD Support", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1037)												 
     UPDATE APP_idaType SET name = "UDO Support", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "UDO Support",												 
							indexSpaceSaver = 1											
                            WHERE type =1037															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1037, "UDO Support", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"UDO Support", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1038)												 
     UPDATE APP_idaType SET name = "CommCell Readiness Check", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommCell Readiness Check",												 
							indexSpaceSaver = 1											
                            WHERE type =1038															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1038, "CommCell Readiness Check", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommCell Readiness Check", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1039)												 
     UPDATE APP_idaType SET name = "Advanced FileSystem iDA Options", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Advanced FileSystem iDA Options",												 
							indexSpaceSaver = 1											
                            WHERE type =1039															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1039, "Advanced FileSystem iDA Options", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Advanced FileSystem iDA Options", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1040)												 
     UPDATE APP_idaType SET name = "1-Touch Server for Windows", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "1-Touch Server for Windows",												 
							indexSpaceSaver = 1											
                            WHERE type =1040															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1040, "1-Touch Server for Windows", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"1-Touch Server for Windows", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1041)												 
     UPDATE APP_idaType SET name = "Erase Data", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Erase Data",												 
							indexSpaceSaver = 1											
                            WHERE type =1041															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1041, "Erase Data", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Erase Data", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1042)												 
     UPDATE APP_idaType SET name = "Client Groups", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Client Groups",												 
							indexSpaceSaver = 1											
                            WHERE type =1042															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1042, "Client Groups", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Client Groups", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1043)												 
     UPDATE APP_idaType SET name = "FileSystem Accelerator", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "FileSystem Accelerator",												 
							indexSpaceSaver = 1											
                            WHERE type =1043															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1043, "FileSystem Accelerator", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"FileSystem Accelerator", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1044)												 
     UPDATE APP_idaType SET name = "Dynamic Mount Path Sharing", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Dynamic Mount Path Sharing",												 
							indexSpaceSaver = 1											
                            WHERE type =1044															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1044, "Dynamic Mount Path Sharing", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Dynamic Mount Path Sharing", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1045)												 
     UPDATE APP_idaType SET name = "Unix Base Package", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix Base Package",												 
							indexSpaceSaver = 1											
                            WHERE type =1045															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1045, "Unix Base Package", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix Base Package", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1046)												 
     UPDATE APP_idaType SET name = "Unix Copy Manager", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix Copy Manager",												 
							indexSpaceSaver = 1											
                            WHERE type =1046															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1046, "Unix Copy Manager", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix Copy Manager", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1047)												 
     UPDATE APP_idaType SET name = "Unix Block Filter", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix Block Filter",												 
							indexSpaceSaver = 1											
                            WHERE type =1047															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1047, "Unix Block Filter", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix Block Filter", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1048)												 
     UPDATE APP_idaType SET name = "Unix NAS iDataAgent", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix NAS iDataAgent",												 
							indexSpaceSaver = 1											
                            WHERE type =1048															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1048, "Unix NAS iDataAgent", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix NAS iDataAgent", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1049)												 
     UPDATE APP_idaType SET name = "Galaxy SCSI Driver", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Galaxy SCSI Driver",												 
							indexSpaceSaver = 1											
                            WHERE type =1049															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1049, "Galaxy SCSI Driver", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Galaxy SCSI Driver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1050)												 
     UPDATE APP_idaType SET name = "Unused Apple MAC", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unused Apple MAC",												 
							indexSpaceSaver = 1											
                            WHERE type =1050															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1050, "Unused Apple MAC", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unused Apple MAC", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1051)												 
     UPDATE APP_idaType SET name = "Unused for Apple MAC", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unused for Apple MAC",												 
							indexSpaceSaver = 1											
                            WHERE type =1051															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1051, "Unused for Apple MAC", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unused for Apple MAC", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1033)												 
     UPDATE APP_idaType SET name = "1-Touch Server for Unix", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "1-Touch Server for Unix",												 
							indexSpaceSaver = 1											
                            WHERE type =1033															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1033, "1-Touch Server for Unix", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"1-Touch Server for Unix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1052)												 
     UPDATE APP_idaType SET name = "Advanced Copy Features", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Advanced Copy Features",												 
							indexSpaceSaver = 1											
                            WHERE type =1052															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1052, "Advanced Copy Features", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Advanced Copy Features", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1053)												 
     UPDATE APP_idaType SET name = "Advanced Media Management Features", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Advanced Media Management Features",												 
							indexSpaceSaver = 1											
                            WHERE type =1053															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1053, "Advanced Media Management Features", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Advanced Media Management Features", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 80)												 
     UPDATE APP_idaType SET name = "Oracle RAC", treeType = 1, appGroup1 = 100080,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Oracle RAC",												 
							indexSpaceSaver = 1											
                            WHERE type =80															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (80, "Oracle RAC", 1, 100080, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Oracle RAC", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 81)												 
     UPDATE APP_idaType SET name = "SQL Server", treeType = 1, appGroup1 = 100004,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 81,														 
							isCWEjobValid = 0,											 
							displayName = "SQL Server",												 
							indexSpaceSaver = 1											
                            WHERE type =81															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (81, "SQL Server", 1, 100004, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 81, 0,"SQL Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 82)												 
     UPDATE APP_idaType SET name = "Exchange PF Archiver", treeType = 1, appGroup1 = 100082,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @exMbPubFolderDefContent,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Exchange PF Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =82															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (82, "Exchange PF Archiver", 1, 100082, "6", "0", @empty,				 
	           @exMbPubFolderDefContent, "300", "4096", "300", 0, 0,"Exchange PF Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 83)												 
     UPDATE APP_idaType SET name = "NetWare File Archiver", treeType = 1, appGroup1 = 100083,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 12,														 
							isCWEjobValid = 1,											 
							displayName = "File Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =83															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (83, "NetWare File Archiver", 1, 100083, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 12, 1,"File Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 84)												 
     UPDATE APP_idaType SET name = "Continuous Data Replicator", treeType = 1, appGroup1 = 100084,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Continuous Data Replicator",												 
							indexSpaceSaver = 1											
                            WHERE type =84															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (84, "Continuous Data Replicator", 1, 100084, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Continuous Data Replicator", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 85)												 
     UPDATE APP_idaType SET name = "Data Classification", treeType = 1, appGroup1 = 100085,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Classification Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =85															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (85, "Data Classification", 1, 100085, "6", "0", "1",				 
	           "/", "300", "4096", "300", 0, 0,"Data Classification Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 86)												 
     UPDATE APP_idaType SET name = "OES File System on Linux", treeType = 1, appGroup1 = 100086,				 
                            casesensitivity = "1",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "OES File System",												 
							indexSpaceSaver = 1											
                            WHERE type =86															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (86, "OES File System on Linux", 1, 100086, "6", "1", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"OES File System", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 87)												 
     UPDATE APP_idaType SET name = "Image Level ProxyHost on Unix", treeType = 1, appGroup1 = 100087,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Image Level ProxyHost on Unix",												 
							indexSpaceSaver = 1											
                            WHERE type =87															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (87, "Image Level ProxyHost on Unix", 1, 100087, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Image Level ProxyHost on Unix", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 88)												 
     UPDATE APP_idaType SET name = "Centera", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 33,														 
							isCWEjobValid = 0,											 
							displayName = "Centera",												 
							indexSpaceSaver = 1											
                            WHERE type =88															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (88, "Centera", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 33, 0,"Centera", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1055)												 
     UPDATE APP_idaType SET name = "NDMP Tape Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NDMP Tape Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1055															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1055, "NDMP Tape Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NDMP Tape Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1056)												 
     UPDATE APP_idaType SET name = "Vault Tracker", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Vault Tracker",												 
							indexSpaceSaver = 1											
                            WHERE type =1056															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1056, "Vault Tracker", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Vault Tracker", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1059)												 
     UPDATE APP_idaType SET name = "Recovery Points", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Recovery Points",												 
							indexSpaceSaver = 1											
                            WHERE type =1059															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1059, "Recovery Points", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Recovery Points", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1061)												 
     UPDATE APP_idaType SET name = "Open File Handler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QSnap",												 
							indexSpaceSaver = 1											
                            WHERE type =1061															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1061, "Open File Handler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QSnap", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1062)												 
     UPDATE APP_idaType SET name = "CommServe Database", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommServe Database",												 
							indexSpaceSaver = 1											
                            WHERE type =1062															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1062, "CommServe Database", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommServe Database", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1060)												 
     UPDATE APP_idaType SET name = "QNET Agent DB on CommServer", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "QNET Agent DB on CommServer",												 
							indexSpaceSaver = 1											
                            WHERE type =1060															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1060, "QNET Agent DB on CommServer", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"QNET Agent DB on CommServer", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 89)												 
     UPDATE APP_idaType SET name = "MS SharePoint Archiver", treeType = 3, appGroup1 = 100089,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 89,														 
							isCWEjobValid = 0,											 
							displayName = "MS Sharepoint Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =89															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (89, "MS SharePoint Archiver", 3, 100089, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 89, 0,"MS Sharepoint Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 90)												 
     UPDATE APP_idaType SET name = "Domino Mailbox Archiver", treeType = 3, appGroup1 = 100090,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Domino Mailbox Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =90															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (90, "Domino Mailbox Archiver", 3, 100090, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Domino Mailbox Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 91)												 
     UPDATE APP_idaType SET name = "DPM", treeType = 1, appGroup1 = 100091,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DPM",												 
							indexSpaceSaver = 1											
                            WHERE type =91															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (91, "DPM", 1, 100091, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"DPM", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1064)												 
     UPDATE APP_idaType SET name = "Content Index Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Content Indexing Engine",												 
							indexSpaceSaver = 1											
                            WHERE type =1064															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1064, "Content Index Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Content Indexing Engine", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1065)												 
     UPDATE APP_idaType SET name = "Online Content Indexing", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Online Content Indexing",												 
							indexSpaceSaver = 1											
                            WHERE type =1065															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1065, "Online Content Indexing", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Online Content Indexing", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1066)												 
     UPDATE APP_idaType SET name = "Filer Snapshot", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Network Appliance Snapshot Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1066															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1066, "Filer Snapshot", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Network Appliance Snapshot Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 93)												 
     UPDATE APP_idaType SET name = "Content Indexing Agent", treeType = 1, appGroup1 = 100093,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Online Content Indexing",												 
							indexSpaceSaver = 1											
                            WHERE type =93															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (93, "Content Indexing Agent", 1, 100093, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"Online Content Indexing", 1)

	---------------	
	
 IF EXISTS (Select * from APP_iDAType where type = 1067)												 
     UPDATE APP_idaType SET name = "File Replication Driver", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "File Replication Driver",												 
							indexSpaceSaver = 1											
                            WHERE type =1067															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1067, "File Replication Driver", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"File Replication Driver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1068)												 
     UPDATE APP_idaType SET name = "FSDM Driver", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "FSDM Driver",												 
							indexSpaceSaver = 1											
                            WHERE type =1068															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1068, "FSDM Driver", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"FSDM Driver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1069)												 
     UPDATE APP_idaType SET name = "OSSV VSS Provider", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "OSSV VSS Provider",												 
							indexSpaceSaver = 1											
                            WHERE type =1069															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1069, "OSSV VSS Provider", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"OSSV VSS Provider", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1070)												 
     UPDATE APP_idaType SET name = "Desktop Search Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Desktop Search Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1070															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1070, "Desktop Search Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Desktop Search Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1071)												 
     UPDATE APP_idaType SET name = "CDR VSS Provider", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CDR VSS Provider",												 
							indexSpaceSaver = 1											
                            WHERE type =1071															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1071, "CDR VSS Provider", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CDR VSS Provider", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1072)												 
     UPDATE APP_idaType SET name = "Shared Dynamic Disk", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Shared Dynamic Disk",												 
							indexSpaceSaver = 1											
                            WHERE type =1072															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1072, "Shared Dynamic Disk", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Shared Dynamic Disk", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1073)												 
     UPDATE APP_idaType SET name = "Active Directory Signon", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Active Directory Signon",												 
							indexSpaceSaver = 1											
                            WHERE type =1073															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1073, "Active Directory Signon", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Active Directory Signon", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1074)												 
     UPDATE APP_idaType SET name = "Desktop Search Server Database", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Desktop Search Server Database",												 
							indexSpaceSaver = 1											
                            WHERE type =1074															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1074, "Desktop Search Server Database", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Desktop Search Server Database", 1)

		/*
	
 IF EXISTS (Select * from APP_iDAType where type = CV_APPTYPE_SQL_BACKTRACK_OBSI)												 
     UPDATE APP_idaType SET name = CV_APPTYPE_SQL_BACKTRACK_OBSI_NAME, treeType = 3, appGroup1 = CV_APPTYPE_GP1_SQL_BACKTRACK_OBSI,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = {13},												 
							indexSpaceSaver = {14}											
                            WHERE type =CV_APPTYPE_SQL_BACKTRACK_OBSI															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (CV_APPTYPE_SQL_BACKTRACK_OBSI, CV_APPTYPE_SQL_BACKTRACK_OBSI_NAME, 3, CV_APPTYPE_GP1_SQL_BACKTRACK_OBSI, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,{13}, {14})

		*/
	
 IF EXISTS (Select * from APP_iDAType where type = 1075)												 
     UPDATE APP_idaType SET name = "Compliance Search", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Compliance Search",												 
							indexSpaceSaver = 1											
                            WHERE type =1075															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1075, "Compliance Search", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Compliance Search", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1076)												 
     UPDATE APP_idaType SET name = "Single Instance Store", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data De-Duplication Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1076															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1076, "Single Instance Store", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data De-Duplication Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1077)												 
     UPDATE APP_idaType SET name = "Auxiliary Copy Encryption", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Auxiliary Copy Encryption",												 
							indexSpaceSaver = 1											
                            WHERE type =1077															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1077, "Auxiliary Copy Encryption", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Auxiliary Copy Encryption", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 120)												 
     UPDATE APP_idaType SET name = "SharePoint Search Connector", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SharePoint Search Connector",												 
							indexSpaceSaver = 1											
                            WHERE type =120															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (120, "SharePoint Search Connector", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SharePoint Search Connector", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1078)												 
     UPDATE APP_idaType SET name = "OWA Proxy Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "MS Outlook Web Access Proxy",												 
							indexSpaceSaver = 1											
                            WHERE type =1078															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1078, "OWA Proxy Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"MS Outlook Web Access Proxy", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1082)												 
     UPDATE APP_idaType SET name = "SRM Services", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM Services",												 
							indexSpaceSaver = 1											
                            WHERE type =1082															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1082, "SRM Services", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM Services", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1080)												 
     UPDATE APP_idaType SET name = "SRM Services DB", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM Services DB",												 
							indexSpaceSaver = 1											
                            WHERE type =1080															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1080, "SRM Services DB", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM Services DB", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 600)												 
     UPDATE APP_idaType SET name = "SRM Agent For Windows File Systems", treeType = 3, appGroup1 = 100600,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "SRM for Windows File Systems",												 
							indexSpaceSaver = 1											
                            WHERE type =600															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (600, "SRM Agent For Windows File Systems", 3, 100600, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 1,"SRM for Windows File Systems", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 601)												 
     UPDATE APP_idaType SET name = "SRM Agent For Oracle", treeType = 3, appGroup1 = 100601,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for Oracle",												 
							indexSpaceSaver = 1											
                            WHERE type =601															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (601, "SRM Agent For Oracle", 3, 100601, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"SRM for Oracle", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 602)												 
     UPDATE APP_idaType SET name = "SRM Agent For SQL Server", treeType = 3, appGroup1 = 100602,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for SQL Server",												 
							indexSpaceSaver = 1											
                            WHERE type =602															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (602, "SRM Agent For SQL Server", 3, 100602, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"SRM for SQL Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 603)												 
     UPDATE APP_idaType SET name = "SRM Agent For Network Attached Storage", treeType = 3, appGroup1 = 100603,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "SRM for Network Attached Storage",												 
							indexSpaceSaver = 1											
                            WHERE type =603															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (603, "SRM Agent For Network Attached Storage", 3, 100603, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"SRM for Network Attached Storage", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 604)												 
     UPDATE APP_idaType SET name = "SRM Agent For NetWare", treeType = 3, appGroup1 = 100604,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "SRM for Netware",												 
							indexSpaceSaver = 1											
                            WHERE type =604															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (604, "SRM Agent For NetWare", 3, 100604, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"SRM for Netware", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 605)												 
     UPDATE APP_idaType SET name = "SRM Agent For UNIX File Systems", treeType = 3, appGroup1 = 100605,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "SRM for UNIX File Systems",												 
							indexSpaceSaver = 1											
                            WHERE type =605															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (605, "SRM Agent For UNIX File Systems", 3, 100605, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 1,"SRM for UNIX File Systems", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 606)												 
     UPDATE APP_idaType SET name = "SRM Agent For Exchange", treeType = 3, appGroup1 = 100606,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for Exchange",												 
							indexSpaceSaver = 1											
                            WHERE type =606															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (606, "SRM Agent For Exchange", 3, 100606, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"SRM for Exchange", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 607)												 
     UPDATE APP_idaType SET name = "SRM Agent For SharePoint", treeType = 3, appGroup1 = 100607,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for Sharepoint",												 
							indexSpaceSaver = 1											
                            WHERE type =607															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (607, "SRM Agent For SharePoint", 3, 100607, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"SRM for Sharepoint", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1081)												 
     UPDATE APP_idaType SET name = "Proxy File Share Archiver", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Proxy File Share Archiver",												 
							indexSpaceSaver = 1											
                            WHERE type =1081															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1081, "Proxy File Share Archiver", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Proxy File Share Archiver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1083)												 
     UPDATE APP_idaType SET name = "Media Explorer", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Media Explorer",												 
							indexSpaceSaver = 1											
                            WHERE type =1083															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1083, "Media Explorer", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Media Explorer", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1079)												 
     UPDATE APP_idaType SET name = "Legal Hold", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Legal Hold",												 
							indexSpaceSaver = 1											
                            WHERE type =1079															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1079, "Legal Hold", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Legal Hold", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 103)												 
     UPDATE APP_idaType SET name = "DB2 MultiNode", treeType = 3, appGroup1 = 100103,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DB2 MultiNode",												 
							indexSpaceSaver = 1											
                            WHERE type =103															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (103, "DB2 MultiNode", 3, 100103, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"DB2 MultiNode", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 104)												 
     UPDATE APP_idaType SET name = "MySQL", treeType = 3, appGroup1 = 100104,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = "/",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "MySQL",												 
							indexSpaceSaver = 1											
                            WHERE type =104															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (104, "MySQL", 3, 100104, "0", "0", "1",				 
	           "/", "300", "16384", "300", 0, 0,"MySQL", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 106)												 
     UPDATE APP_idaType SET name = "Virtual Server", treeType = 1, appGroup1 = 100106,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 1,											 
							displayName = "Virtual Server",												 
							indexSpaceSaver = 1											
                            WHERE type =106															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (106, "Virtual Server", 1, 100106, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 1,"Virtual Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 105)												 
     UPDATE APP_idaType SET name = "CI For Exchange Mailbox", treeType = 1, appGroup1 = 100105,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CI for Exchange",												 
							indexSpaceSaver = 1											
                            WHERE type =105															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (105, "CI For Exchange Mailbox", 1, 100105, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"CI for Exchange", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 107)												 
     UPDATE APP_idaType SET name = "Workstation Backup", treeType = 1, appGroup1 = 100107,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Workstation Backup",												 
							indexSpaceSaver = 1											
                            WHERE type =107															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (107, "Workstation Backup", 1, 100107, "6", "0", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Workstation Backup", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1090)												 
     UPDATE APP_idaType SET name = "Workstation Backup Policy", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Workstation Backup Policy",												 
							indexSpaceSaver = 1											
                            WHERE type =1090															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1090, "Workstation Backup Policy", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Workstation Backup Policy", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1084)												 
     UPDATE APP_idaType SET name = "Unix Base Zero Package", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix Base Zero Package",												 
							indexSpaceSaver = 1											
                            WHERE type =1084															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1084, "Unix Base Zero Package", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix Base Zero Package", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1085)												 
     UPDATE APP_idaType SET name = "Unix File Replication Driver", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Unix File Replication Driver",												 
							indexSpaceSaver = 1											
                            WHERE type =1085															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1085, "Unix File Replication Driver", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Unix File Replication Driver", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1089)												 
     UPDATE APP_idaType SET name = "Offline Mining Sharepoint Tool", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Offline Mining Enabler for SharePoint",												 
							indexSpaceSaver = 1											
                            WHERE type =1089															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1089, "Offline Mining Sharepoint Tool", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Offline Mining Enabler for SharePoint", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1086)												 
     UPDATE APP_idaType SET name = "Offline Mining Exhange Admin Tool", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Offline Mining Exhange Admin Tool",												 
							indexSpaceSaver = 1											
                            WHERE type =1086															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1086, "Offline Mining Exhange Admin Tool", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Offline Mining Exhange Admin Tool", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1087)												 
     UPDATE APP_idaType SET name = "Offline Mining Exhange User Tool", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Offline Mining Enabler for Exchange",												 
							indexSpaceSaver = 1											
                            WHERE type =1087															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1087, "Offline Mining Exhange User Tool", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Offline Mining Enabler for Exchange", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1091)												 
     UPDATE APP_idaType SET name = "Office Communication Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Office Communications Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1091															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1091, "Office Communication Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Office Communications Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1092)												 
     UPDATE APP_idaType SET name = "Snap Backup", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Hardware Snapshot Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1092															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1092, "Snap Backup", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Hardware Snapshot Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 650)												 
     UPDATE APP_idaType SET name = "SRM Proxy Agent for Oracle", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM Proxy Agent for Oracle",												 
							indexSpaceSaver = 1											
                            WHERE type =650															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (650, "SRM Proxy Agent for Oracle", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM Proxy Agent for Oracle", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 651)												 
     UPDATE APP_idaType SET name = "SRM Proxy Agent for NAS", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM Proxy Agent for NAS",												 
							indexSpaceSaver = 1											
                            WHERE type =651															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (651, "SRM Proxy Agent for NAS", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM Proxy Agent for NAS", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 652)												 
     UPDATE APP_idaType SET name = "SRM Proxy Agent for Netware", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM Proxy Agent for Netware",												 
							indexSpaceSaver = 1											
                            WHERE type =652															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (652, "SRM Proxy Agent for Netware", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM Proxy Agent for Netware", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1098)												 
     UPDATE APP_idaType SET name = "Microsoft Office Sharepoint Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "ERM Connector",												 
							indexSpaceSaver = 1											
                            WHERE type =1098															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1098, "Microsoft Office Sharepoint Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"ERM Connector", 1)

--'CV_APPTYPE_EXCHANGE_DM_WEB_PROXY' is an older pseudo appType, but for some reason never added to this table.
	
 IF EXISTS (Select * from APP_iDAType where type = 1063)												 
     UPDATE APP_idaType SET name = "DM Web Proxy", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "DM Web Proxy",												 
							indexSpaceSaver = 1											
                            WHERE type =1063															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1063, "DM Web Proxy", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"DM Web Proxy", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1099)												 
     UPDATE APP_idaType SET name = "AD offline Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Offline Mining Enabler for Active Directory",												 
							indexSpaceSaver = 1											
                            WHERE type =1099															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1099, "AD offline Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Offline Mining Enabler for Active Directory", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1100)												 
     UPDATE APP_idaType SET name = "Block Level De-Duplication", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Block Level De-Duplication",												 
							indexSpaceSaver = 1											
                            WHERE type =1100															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1100, "Block Level De-Duplication", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Block Level De-Duplication", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1101)												 
     UPDATE APP_idaType SET name = "Tape De-Duplication", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Tape De-Duplication",												 
							indexSpaceSaver = 1											
                            WHERE type =1101															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1101, "Tape De-Duplication", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Tape De-Duplication", 1)

--9.0 AppTypes
	
 IF EXISTS (Select * from APP_iDAType where type = 121)												 
     UPDATE APP_idaType SET name = "Metrics Reporting Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Metrics Reporting Server",												 
							indexSpaceSaver = 1											
                            WHERE type =121															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (121, "Metrics Reporting Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Metrics Reporting Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 122)												 
     UPDATE APP_idaType SET name = "Monitored Ops Clients", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Monitored Ops Client",												 
							indexSpaceSaver = 1											
                            WHERE type =122															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (122, "Monitored Ops Clients", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Monitored Ops Client", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1107)												 
     UPDATE APP_idaType SET name = "CommNet Explorer", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommNet Explorer",												 
							indexSpaceSaver = 1											
                            WHERE type =1107															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1107, "CommNet Explorer", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommNet Explorer", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1102)												 
     UPDATE APP_idaType SET name = "CommNet SNMP Enabler", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommNet SNMP Enabler",												 
							indexSpaceSaver = 1											
                            WHERE type =1102															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1102, "CommNet SNMP Enabler", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommNet SNMP Enabler", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1103)												 
     UPDATE APP_idaType SET name = "Developer License", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Developer License",												 
							indexSpaceSaver = 1											
                            WHERE type =1103															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1103, "Developer License", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Developer License", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1104)												 
     UPDATE APP_idaType SET name = "CommNet Browser", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommNet Browser",												 
							indexSpaceSaver = 1											
                            WHERE type =1104															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1104, "CommNet Browser", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommNet Browser", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1105)												 
     UPDATE APP_idaType SET name = "Catalog Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Catalog Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1105															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1105, "Catalog Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Catalog Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 125)												 
     UPDATE APP_idaType SET name = "PostgreSQL", treeType = 3, appGroup1 = 100125,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "PostgreSQL",												 
							indexSpaceSaver = 1											
                            WHERE type =125															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (125, "PostgreSQL", 3, 100125, "0", "0", "1",				 
	           @empty, "300", "16384", "300", 0, 0,"PostgreSQL", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 124)												 
     UPDATE APP_idaType SET name = "Object Link", treeType = 1, appGroup1 = 100124,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Object Link",												 
							indexSpaceSaver = 1											
                            WHERE type =124															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (124, "Object Link", 1, 100124, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"Object Link", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 126)												 
     UPDATE APP_idaType SET name = "Sybase IQ", treeType = 3, appGroup1 = 100126,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Sybase IQ",												 
							indexSpaceSaver = 1											
                            WHERE type =126															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (126, "Sybase IQ", 3, 100126, "0", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Sybase IQ", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 127)												 
     UPDATE APP_idaType SET name = "External Data Connector", treeType = 1, appGroup1 = 100127,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "External Data Connector",												 
							indexSpaceSaver = 1											
                            WHERE type =127															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (127, "External Data Connector", 1, 100127, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"External Data Connector", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1106)												 
     UPDATE APP_idaType SET name = "CommNet Server DB", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CommNet Server DB",												 
							indexSpaceSaver = 1											
                            WHERE type =1106															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1106, "CommNet Server DB", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CommNet Server DB", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 128)												 
     UPDATE APP_idaType SET name = "Documentum", treeType = 1, appGroup1 = 100128,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Documentum",												 
							indexSpaceSaver = 1											
                            WHERE type =128															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (128, "Documentum", 1, 100128, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"Documentum", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1117)												 
     UPDATE APP_idaType SET name = "SRM for Virtual Server", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for Virtual Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1117															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1117, "SRM for Virtual Server", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM for Virtual Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 654)												 
     UPDATE APP_idaType SET name = "SRM for Lotus Notes", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SRM for Lotus Notes",												 
							indexSpaceSaver = 1											
                            WHERE type =654															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (654, "SRM for Lotus Notes", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SRM for Lotus Notes", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1108)												 
     UPDATE APP_idaType SET name = "File Level Enabler for SRM", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "File Level Enabler for SRM",												 
							indexSpaceSaver = 1											
                            WHERE type =1108															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1108, "File Level Enabler for SRM", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"File Level Enabler for SRM", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1111)												 
     UPDATE APP_idaType SET name = "Library Sharing Across CommCells", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Library Sharing Across CommCells",												 
							indexSpaceSaver = 1											
                            WHERE type =1111															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1111, "Library Sharing Across CommCells", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Library Sharing Across CommCells", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1112)												 
     UPDATE APP_idaType SET name = "Client Side DeDuplication", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Client Side DeDuplication",												 
							indexSpaceSaver = 1											
                            WHERE type =1112															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1112, "Client Side DeDuplication", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Client Side DeDuplication", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1113)												 
     UPDATE APP_idaType SET name = "Cloud Storage", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Cloud Storage",												 
							indexSpaceSaver = 1											
                            WHERE type =1113															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1113, "Cloud Storage", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Cloud Storage", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1114)												 
     UPDATE APP_idaType SET name = "SAP ArchiveLink", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SAP ArchiveLink",												 
							indexSpaceSaver = 1											
                            WHERE type =1114															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1114, "SAP ArchiveLink", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"SAP ArchiveLink", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1115)												 
     UPDATE APP_idaType SET name = "Agentless Data collection for SRM", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Agentless Data collection for SRM",												 
							indexSpaceSaver = 1											
                            WHERE type =1115															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1115, "Agentless Data collection for SRM", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Agentless Data collection for SRM", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 130)												 
     UPDATE APP_idaType SET name = "Other External Agent", treeType = 1, appGroup1 = 100130,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Other External Agent",												 
							indexSpaceSaver = 1											
                            WHERE type =130															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (130, "Other External Agent", 1, 100130, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 0, 0,"Other External Agent", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 131)												 
     UPDATE APP_idaType SET name = "Object Store", treeType = 1, appGroup1 = 100124,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Object Store",												 
							indexSpaceSaver = 1											
                            WHERE type =131															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (131, "Object Store", 1, 100124, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 0, 0,"Object Store", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1119)												 
     UPDATE APP_idaType SET name = "Data Protection Enterprise infrastructure", treeType = 0, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Protection Enterprise infrastructure",												 
							indexSpaceSaver = 1											
                            WHERE type =1119															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1119, "Data Protection Enterprise infrastructure", 0, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Protection Enterprise infrastructure", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1121)												 
     UPDATE APP_idaType SET name = "Data Archive Enterprise infrastructure", treeType = 0, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Archive Enterprise infrastructure",												 
							indexSpaceSaver = 1											
                            WHERE type =1121															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1121, "Data Archive Enterprise infrastructure", 0, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Archive Enterprise infrastructure", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1125)												 
     UPDATE APP_idaType SET name = "Search Engine", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "CTE Search Server",												 
							indexSpaceSaver = 1											
                            WHERE type =1125															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1125, "Search Engine", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"CTE Search Server", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1122)												 
     UPDATE APP_idaType SET name = "NetApp Cloud", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NetApp Cloud",												 
							indexSpaceSaver = 1											
                            WHERE type =1122															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1122, "NetApp Cloud", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NetApp Cloud", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1123)												 
     UPDATE APP_idaType SET name = "NetApp Snap Management", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "NetApp Snap Management",												 
							indexSpaceSaver = 1											
                            WHERE type =1123															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1123, "NetApp Snap Management", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"NetApp Snap Management", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1126)												 
     UPDATE APP_idaType SET name = "Workflow DB", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Workflow DB",												 
							indexSpaceSaver = 1											
                            WHERE type =1126															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1126, "Workflow DB", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Workflow DB", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1127)												 
     UPDATE APP_idaType SET name = "Workflow Engine", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Workflow Engine",												 
							indexSpaceSaver = 1											
                            WHERE type =1127															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1127, "Workflow Engine", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Workflow Engine", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1140)												 
     UPDATE APP_idaType SET name = "Advanced document", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Advanced document",												 
							indexSpaceSaver = 1											
                            WHERE type =1140															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1140, "Advanced document", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Advanced document", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1128)												 
     UPDATE APP_idaType SET name = "Dell Snap Management", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Dell Snap Management",												 
							indexSpaceSaver = 1											
                            WHERE type =1128															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1128, "Dell Snap Management", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Dell Snap Management", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1129)												 
     UPDATE APP_idaType SET name = "Virtual Machines", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Virtual Machines",												 
							indexSpaceSaver = 1											
                            WHERE type =1129															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1129, "Virtual Machines", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Virtual Machines", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1130)												 
     UPDATE APP_idaType SET name = "Protected Mailboxes", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Protected Mailboxes",												 
							indexSpaceSaver = 1											
                            WHERE type =1130															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1130, "Protected Mailboxes", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Protected Mailboxes", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1131)												 
     UPDATE APP_idaType SET name = "Archived Mailboxes", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Archived Mailboxes",												 
							indexSpaceSaver = 1											
                            WHERE type =1131															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1131, "Archived Mailboxes", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Archived Mailboxes", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1132)												 
     UPDATE APP_idaType SET name = "Content indexed Mailboxes", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Content indexed Mailboxes",												 
							indexSpaceSaver = 1											
                            WHERE type =1132															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1132, "Content indexed Mailboxes", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Content indexed Mailboxes", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1133)												 
     UPDATE APP_idaType SET name = "Disk Library Space (TB)", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Disk Library Space (TB)",												 
							indexSpaceSaver = 1											
                            WHERE type =1133															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1133, "Disk Library Space (TB)", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Disk Library Space (TB)", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1134)												 
     UPDATE APP_idaType SET name = "Dedupe Store Space (TB)", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Dedupe Store Space (TB)",												 
							indexSpaceSaver = 1											
                            WHERE type =1134															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1134, "Dedupe Store Space (TB)", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Dedupe Store Space (TB)", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1135)												 
     UPDATE APP_idaType SET name = "Content Indexing Advanced Linguistic Support", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Content Indexing Advanced Linguistic Support",												 
							indexSpaceSaver = 1											
                            WHERE type =1135															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1135, "Content Indexing Advanced Linguistic Support", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Content Indexing Advanced Linguistic Support", 1)

-- THIS IS A "PSEUDO TYPE", USED FOR CCP ONLY (modeled afer winFS)
	
 IF EXISTS (Select * from APP_iDAType where type = 1137)												 
     UPDATE APP_idaType SET name = "All Agents", treeType = 1, appGroup1 = 100033,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "All Agents",												 
							indexSpaceSaver = 1											
                            WHERE type =1137															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1137, "All Agents", 1, 100033, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"All Agents", 1)

-- Content Indexed Object
	
 IF EXISTS (Select * from APP_iDAType where type = 1138)												 
     UPDATE APP_idaType SET name = "Content Indexed Object", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Content Indexed Object",												 
							indexSpaceSaver = 1											
                            WHERE type =1138															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1138, "Content Indexed Object", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"Content Indexed Object", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 133)												 
     UPDATE APP_idaType SET name = "Online Accounts - Mail", treeType = 1, appGroup1 = 100001,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Online Accounts - Mail",												 
							indexSpaceSaver = 1											
                            WHERE type =133															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (133, "Online Accounts - Mail", 1, 100001, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 33, 1,"Online Accounts - Mail", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 134)												 
     UPDATE APP_idaType SET name = "Online Accounts - Media", treeType = 1, appGroup1 = 100001,				 
                            casesensitivity = "1",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Online Accounts - Media",												 
							indexSpaceSaver = 1											
                            WHERE type =134															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (134, "Online Accounts - Media", 1, 100001, "6", "1", @empty,				 
	           @empty, "300", "4096", "300", 33, 1,"Online Accounts - Media", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1139)												 
     UPDATE APP_idaType SET name = "Extended Indexing Engine", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Extended Indexing Engine",												 
							indexSpaceSaver = 1											
                            WHERE type =1139															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1139, "Extended Indexing Engine", 1, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Extended Indexing Engine", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 135)												 
     UPDATE APP_idaType SET name = "SAP HANA", treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SAP HANA",												 
							indexSpaceSaver = 1											
                            WHERE type =135															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (135, "SAP HANA", 3, 100079, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SAP HANA", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1143)												 
     UPDATE APP_idaType SET name = "Data Protection Snapshot", treeType = 0, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Protection Snapshot",												 
							indexSpaceSaver = 1											
                            WHERE type =1143															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1143, "Data Protection Snapshot", 0, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Protection Snapshot", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1144)												 
     UPDATE APP_idaType SET name = "Data Protection Replication", treeType = 0, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Data Protection Replication",												 
							indexSpaceSaver = 1											
                            WHERE type =1144															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1144, "Data Protection Replication", 0, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Data Protection Replication", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 136)												 
     UPDATE APP_idaType SET name = "SAP HANA", treeType = 3, appGroup1 = 100079,				 
                            casesensitivity = "0",		    			 						
                            dirorder = @empty, dirdelim = @empty,								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "SAP HANA",												 
							indexSpaceSaver = 1											
                            WHERE type =136															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (136, "SAP HANA", 3, 100079, "6", "0", @empty,				 
	           @empty, "300", "16384", "300", 0, 0,"SAP HANA", 1)

-- usage based Licenses
	
 IF EXISTS (Select * from APP_iDAType where type = 1146)												 
     UPDATE APP_idaType SET name = "CPU Sockets on Hypervisor Hosts", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "CPU Sockets on Hypervisor Hosts",												 
							indexSpaceSaver = 1											
                            WHERE type =1146															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1146, "CPU Sockets on Hypervisor Hosts", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"CPU Sockets on Hypervisor Hosts", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1147)												 
     UPDATE APP_idaType SET name = "Protected Virtual Machines", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Protected Virtual Machines",												 
							indexSpaceSaver = 1											
                            WHERE type =1147															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1147, "Protected Virtual Machines", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"Protected Virtual Machines", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1148)												 
     UPDATE APP_idaType SET name = "Virtual Machine Provisioning", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Virtual Machine Provisioning",												 
							indexSpaceSaver = 1											
                            WHERE type =1148															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1148, "Virtual Machine Provisioning", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"Virtual Machine Provisioning", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1149)												 
     UPDATE APP_idaType SET name = "Virtual Machine Archiving", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Virtual Machine Archiving",												 
							indexSpaceSaver = 1											
                            WHERE type =1149															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1149, "Virtual Machine Archiving", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"Virtual Machine Archiving", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1150)												 
     UPDATE APP_idaType SET name = "Virtual Machine Snapshot", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "Virtual Machine Snapshot",												 
							indexSpaceSaver = 1											
                            WHERE type =1150															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1150, "Virtual Machine Snapshot", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"Virtual Machine Snapshot", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1151)												 
     UPDATE APP_idaType SET name = "CPU Socket Based Virtual Machine Snapshot", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "CPU Socket Based Virtual Machine Snapshot",												 
							indexSpaceSaver = 1											
                            WHERE type =1151															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1151, "CPU Socket Based Virtual Machine Snapshot", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"CPU Socket Based Virtual Machine Snapshot", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1152)												 
     UPDATE APP_idaType SET name = "End point users", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "End point users",												 
							indexSpaceSaver = 1											
                            WHERE type =1152															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1152, "End point users", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"End point users", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1153)												 
     UPDATE APP_idaType SET name = "End point sharing users", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "End point sharing users",												 
							indexSpaceSaver = 1											
                            WHERE type =1153															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1153, "End point sharing users", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"End point sharing users", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1154)												 
     UPDATE APP_idaType SET name = "End point E-discovery users", treeType = 1, appGroup1 = 0,				 
                            casesensitivity = "0",		    			 						
                            dirorder = "1", dirdelim = @gpBackslashString,								
							ccpType = 33,														 
							isCWEjobValid = 1,											 
							displayName = "End point E-discovery users",												 
							indexSpaceSaver = 1											
                            WHERE type =1154															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1154, "End point E-discovery users", 1, 0, "6", "0", "1",				 
	           @gpBackslashString, "300", "4096", "300", 33, 1,"End point E-discovery users", 1)
	
 IF EXISTS (Select * from APP_iDAType where type = 1161)												 
     UPDATE APP_idaType SET name = "Application Class Virtual", treeType = 0, appGroup1 = 0,				 
                            casesensitivity = "Invalid Property",		    			 						
                            dirorder = "Invalid Property", dirdelim = "Invalid Property",								
							ccpType = 0,														 
							isCWEjobValid = 0,											 
							displayName = "Application Class Virtual",												 
							indexSpaceSaver = 1											
                            WHERE type =1161															 
 ELSE																									 
	INSERT INTO APP_iDAType (type, name, treeType, AppGroup1, priority, casesensitivity, dirorder,       
	                          dirdelim,  updateRecoSec, chunksizeMB, updateIntervalSec, ccpType, 		 
							  isCWEjobValid, displayName, indexSpaceSaver)		 													 
	VALUES (1161, "Application Class Virtual", 0, 0, "Invalid Property", "Invalid Property", "Invalid Property",				 
	           "Invalid Property", "Invalid Property", "Invalid Property", "Invalid Property", 0, 0,"Application Class Virtual", 1)

SET NOCOUNT OFF



END	

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_ComponentProp.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_ComponentProp')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_ComponentProp')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_ComponentProp'							
  END																			
  IF (@oldRev = '1.10')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_ComponentProp' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_ComponentProp' +'].'							
  END
--Change APP_ComponentProp set to NOT NULL change to NULL for 9.0 Databases that have been upgraded to match 10.0 and 11.0 fresh installs
	IF EXISTS (SELECT 1 WHERE COLUMNPROPERTY(OBJECT_ID('APP_ComponentProp'), 'stringVal', 'AllowsNull') = 0)

	BEGIN

IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_ComponentProp' AND COLUMN_NAME="stringVal" AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SELECT	@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'APP_ComponentProp' AND COLUMN_NAME="stringVal" AND DATA_TYPE="OLDCOLTYPE"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_ComponentProp' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="stringVal")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'APP_ComponentProp' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'APP_ComponentProp' + " ALTER COLUMN "+"stringVal" + " "+"NVARCHAR(MAX)"		
  		+ " NULL " 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'APP_ComponentProp' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"stringVal"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_ComponentProp')			
  			insert into GXDBVersions VALUES(1, 'APP_ComponentProp', '0.0', 'APP_ComponentProp', '')	
  			UPDATE GXDBVersions SET revision = '1.10' WHERE name = 'APP_ComponentProp'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_ComponentProp' + '] upgraded successfully to '			+ ' revision [' + '1.10' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_ComponentProp' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_IDATypeHandlingInfo.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_IDATypeHandlingInfo')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_IDATypeHandlingInfo')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_IDATypeHandlingInfo'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_IDATypeHandlingInfo' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_IDATypeHandlingInfo' +'].'							
  END--	 Get @oldRev, compare to '1.3'. Chk for work to do.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_IDATypeHandlingInfo' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="ignoreJobRetention")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'APP_IDATypeHandlingInfo' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'APP_IDATypeHandlingInfo' + '_'+"ignoreJobRetention" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'APP_IDATypeHandlingInfo' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"ignoreJobRetention"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_IDATypeHandlingInfo' AND COLUMN_NAME="ignoreJobRetention")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'APP_IDATypeHandlingInfo' + " ADD "+"ignoreJobRetention" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_IDATypeHandlingInfo')			
  			insert into GXDBVersions VALUES(1, 'APP_IDATypeHandlingInfo', '0.0', 'APP_IDATypeHandlingInfo', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'APP_IDATypeHandlingInfo'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_IDATypeHandlingInfo' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_IDATypeHandlingInfo' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_ClientFileContentStorage.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_ClientFileContentStorage')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_ClientFileContentStorage')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_ClientFileContentStorage'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_ClientFileContentStorage' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_ClientFileContentStorage' +'].'							
  END
EXECUTE @retCode = cvsp_drop_pk 'APP_ClientFileContentStorage'
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_ClientFileContentStorage')			
  			insert into GXDBVersions VALUES(1, 'APP_ClientFileContentStorage', '0.0', 'APP_ClientFileContentStorage', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'APP_ClientFileContentStorage'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_ClientFileContentStorage' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_ClientFileContentStorage' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_ApplicationHistory.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
	BEGIN

		IF EXISTS (SELECT * FROM sysobjects WHERE type = 'U' AND name = 'APP_ApplicationHistory')			
  	BEGIN																					
  		EXECUTE @retCode = cvsp_drop_pk 'APP_ApplicationHistory'											
     		DELETE FROM GXDBVersions WHERE name = 'APP_ApplicationHistory'										
          DROP TABLE  APP_ApplicationHistory																
  		SET @sqlError = @@error																
  		IF (@sqlError <> 0)																							
  	BEGIN																									
      PRINT 'RETVAL: 99 TABLE ' + 'APP_ApplicationHistory' + ' SQL ERROR: [' + CONVERT(CHAR(5), @sqlError) + ']'					
  	RETURN																									
  	END																
  		SET @retCode = 0																	
  		PRINT 'RETVAL: 0	 TABLE ['+'APP_ApplicationHistory' +'] Successfully Dropped.'				
  	END

	END

END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/App_FileTypeAndExtensions.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'App_FileTypeAndExtensions')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'App_FileTypeAndExtensions')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'App_FileTypeAndExtensions'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'App_FileTypeAndExtensions' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'App_FileTypeAndExtensions' +'].'							
  END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[App_FileTypeAndExtensions]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/App_FileTypeAndExtensions.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/App_FileTypeAndExtensions.tbl,v $ $Id: App_FileTypeAndExtensions.tbl,v 1.4 2013/10/01 07:46:33 mupadhyay Exp $";

print '... Creating Table: App_FileTypeAndExtensions'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table App_FileTypeAndExtensions (

	typeName		nvarchar(128)	NOT NULL,

	extension		nvarchar(128) NULL



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [App_FileTypeAndExtensions]''

END

--------



insert into GXDBVersions values(1, ''App_FileTypeAndExtensions'',  ''1.4'', ''App_FileTypeAndExtensions'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'App_FileTypeAndExtensions')			
  			insert into GXDBVersions VALUES(1, 'App_FileTypeAndExtensions', '0.0', 'App_FileTypeAndExtensions', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'App_FileTypeAndExtensions'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'App_FileTypeAndExtensions' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'App_FileTypeAndExtensions' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UserToTagXML.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN	

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UserToTagXML')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UserToTagXML')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UserToTagXML'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UserToTagXML' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UserToTagXML' +'].'							
  END--   Get @oldRev, compare to '1.3'. Chk for work

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UserToTagXML]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UserToTagXML.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UserToTagXML.tbl,v $ $Id: UserToTagXML.tbl,v 1.3 2014/10/15 14:11:10 chandru Exp $";

print '... Creating Table: UserToTagXML'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UserToTagXML (

	userid				int	NOT NULL,

	TagXML 				XML,



CONSTRAINT PK_UserToTagXML_userid PRIMARY KEY (userid),

) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UserToTagXML]''

END

--------





insert into GXDBVersions values(1, ''UserToTagXML'',  ''1.3'', ''UserToTagXML'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UserToTagXML  ADD CONSTRAINT UserToTagXML_userid_FK	foreign key (userid)references	 UMUsers(id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UserToTagXML]''

END

----------


')
END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UserToTagXML' AND xType = 'U')				
  	IF NOT EXISTS (SELECT * FROM	sys.foreign_keys WHERE	name = 'UserToTagXML_userid_FK' AND delete_referential_action = 1 AND parent_object_id = @parentID)
	BEGIN

IF ('DELETE FROM UserToTagXML WHERE userId NOT IN (SELECT id FROM UMUsers)' <> '')							
  		SET @sqlString = 'DELETE FROM UserToTagXML WHERE userId NOT IN (SELECT id FROM UMUsers)'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UserToTagXML' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'UserToTagXML_userid_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'UserToTagXML' +']' + 'ADD CONSTRAINT [' + 'UserToTagXML_userid_FK' +'] FOREIGN KEY (' + 'userid' + ') REFERENCES ['+ 'UMUsers' +'] (' + 'id' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UserToTagXML')			
  			insert into GXDBVersions VALUES(1, 'UserToTagXML', '0.0', 'UserToTagXML', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'UserToTagXML'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UserToTagXML' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UserToTagXML' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMEntityProp.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMEntityProp')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMEntityProp')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMEntityProp'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMEntityProp' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMEntityProp' +'].'							
  END-- Get @oldRev, compare to '1.2'. Chk for work to do.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'MMEntityProp' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'MMEntityProp_CommCellId_EntityId_EntityType_propertyName_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'MMEntityProp'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'MMEntityProp' +']' + 'ADD CONSTRAINT [' + 'MMEntityProp_CommCellId_EntityId_EntityType_propertyName_PK' +'] PRIMARY KEY (' + 'CommCellId, EntityId, EntityType, propertyName' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMEntityProp')			
  			insert into GXDBVersions VALUES(1, 'MMEntityProp', '0.0', 'MMEntityProp', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'MMEntityProp'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMEntityProp' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMEntityProp' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archTask.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN		

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archTask')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archTask')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archTask'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archTask' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archTask' +'].'							
  END--	 Get @oldRev, compare to '1.3'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archTask' AND COLUMN_NAME="percentCorruptLimit")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archTask' + " ADD "+"percentCorruptLimit" + " "+"SMALLINT"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archTask' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="percentCorruptLimit")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archTask' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archTask' + '_'+"percentCorruptLimit" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archTask' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"percentCorruptLimit"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archTask')			
  			insert into GXDBVersions VALUES(1, 'archTask', '0.0', 'archTask', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'archTask'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archTask' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archTask' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archGroup.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archGroup.upg,v 1.42 2015/06/01 21:48:55 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archGroup')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archGroup')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archGroup'							
  END																			
  IF (@oldRev = '1.49')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archGroup' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archGroup' +'].'							
  END--	 Get @oldRev, compare to '1.49'. Chk for work to do.
--+-----------------------------------+
--| Know we have to do an update,		|
--| ea. one has it's own rules!		|
--+-----------------------------------+
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroup' AND COLUMN_NAME="origCCcommCellID" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroup' + " ALTER COLUMN "+"origCCcommCellID" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroup' AND COLUMN_NAME="SubclientExtensionTimeStamp")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroup' + " ADD "+"SubclientExtensionTimeStamp" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroup' AND COLUMN_NAME="SubclientExtensionTimeStampEncrypted")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroup' + " ADD "+"SubclientExtensionTimeStampEncrypted" + " "+"VARCHAR(2048)"		
  			+ " NOT NULL DEFAULT "+"''"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroup' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="TimeZoneType")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroup' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroup' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="TimeZone")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroup' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archGroup')			
  			insert into GXDBVersions VALUES(1, 'archGroup', '0.0', 'archGroup', '')	
  			UPDATE GXDBVersions SET revision = '1.49' WHERE name = 'archGroup'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archGroup' + '] upgraded successfully to '			+ ' revision [' + '1.49' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archGroup' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archGroupCopy.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archGroupCopy.upg,v 1.93 2015/05/21 09:56:46 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archGroupCopy')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archGroupCopy')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archGroupCopy'							
  END																			
  IF (@oldRev = '1.66')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archGroupCopy' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archGroupCopy' +'].'							
  END--	 Get @oldRev, compare to '1.66'. Chk for work to do.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="isSnapCopy")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"isSnapCopy" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"isSnapCopy"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="isMirrorCopy")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"isMirrorCopy" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"isMirrorCopy"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="NWWriteSpeed")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"NWWriteSpeed" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"NWWriteSpeed"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="SIDBSnapIntervalHours")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"SIDBSnapIntervalHours" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"SIDBSnapIntervalHours"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="siloAppId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"siloAppId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"siloAppId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="nDataInstance")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"nDataInstance" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"nDataInstance"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="description")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="''") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"description" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"''" + " FOR "+"description"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="dedupeFlags")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"dedupeFlags" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"dedupeFlags"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="blockCacheValidDays")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"blockCacheValidDays" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"blockCacheValidDays"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="nSiloStreams")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="1") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"nSiloStreams" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"1" + " FOR "+"nSiloStreams"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="silosInCache")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"silosInCache" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"silosInCache"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="siloRestoreMAClientId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"siloRestoreMAClientId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"siloRestoreMAClientId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="siloRestoreClientId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"siloRestoreClientId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"siloRestoreClientId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="sealStoreTaskId")			
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') ="0") 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'archGroupCopy' + '_'+"sealStoreTaskId" + '_DF'									
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD CONSTRAINT " + @cName + " DEFAULT "+"0" + " FOR "+"sealStoreTaskId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="origCCcommCellID" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ALTER COLUMN "+"origCCcommCellID" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="extendedFlags")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD "+"extendedFlags" + " "+"BIGINT"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="destMediaCopyId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD "+"destMediaCopyId" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="maxCacheDBSizeMB")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD "+"maxCacheDBSizeMB" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="DDBLimitExtensionTimeStamp")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD "+"DDBLimitExtensionTimeStamp" + " "+"integer"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="DDBLimitExtensionTimeStampEncrypted")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " ADD "+"DDBLimitExtensionTimeStampEncrypted" + " "+"VARCHAR(2048)"		
  			+ " NOT NULL DEFAULT "+"''"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archGroupCopy' AND COLUMN_NAME="maxSizeAllowedMB")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archGroupCopy' AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="maxSizeAllowedMB")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = 'ALTER TABLE [' + 'archGroupCopy' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE " + 'archGroupCopy' + " DROP COLUMN "+"maxSizeAllowedMB"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archGroupCopy')			
  			insert into GXDBVersions VALUES(1, 'archGroupCopy', '0.0', 'archGroupCopy', '')	
  			UPDATE GXDBVersions SET revision = '1.66' WHERE name = 'archGroupCopy'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archGroupCopy' + '] upgraded successfully to '			+ ' revision [' + '1.66' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archGroupCopy' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archAgingRule.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archAgingRule.upg,v 1.17 2015/05/22 04:34:35 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archAgingRule')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archAgingRule')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archAgingRule'							
  END																			
  IF (@oldRev = '1.24')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archAgingRule' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archAgingRule' +'].'							
  END--	 Get @oldRev, compare to '1.24'. Chk for work to do.
--+-----------------------------------+
--| Know we have to do an update,		|
--| ea. one has it's own rules!		|
--+-----------------------------------+
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archAgingRule' AND COLUMN_NAME="retentionJobs")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archAgingRule' + " ADD "+"retentionJobs" + " "+"INTEGER"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE archAgingRule												SET retentionJobs =  ISNULL(EP.intVal, 0)												FROM archAgingRule AR LEFT OUTER JOIN MMEntityProp EP												ON  EP.propertyName = 'retentionJobs'													AND EP.EntityId = AR.copyId													AND EP.EntityType = 2													AND EP.propDataType = 1"																			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		SET @sqlString = "ALTER TABLE " + 'archAgingRule' + " ALTER COLUMN "+"retentionJobs" + " "+"INTEGER" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archAgingRule' AND COLUMN_NAME="minutesSinceDayStarts")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archAgingRule' + " ADD "+"minutesSinceDayStarts" + " "+"INTEGER"		
  			+ " NOT NULL DEFAULT "+"0"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archAgingRule' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'retentionJobs')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'archAgingRule' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archAgingRule')			
  			insert into GXDBVersions VALUES(1, 'archAgingRule', '0.0', 'archAgingRule', '')	
  			UPDATE GXDBVersions SET revision = '1.24' WHERE name = 'archAgingRule'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archAgingRule' + '] upgraded successfully to '			+ ' revision [' + '1.24' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archAgingRule' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable (if no errors)  & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archFile.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archFile.upg,v 1.61 2014/11/17 22:44:46 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archFile')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archFile')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archFile'							
  END																			
  IF (@oldRev = '1.55')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archFile' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archFile' +'].'							
  END--	 Get @oldRev, compare to '1.55'. Chk for work to do.
--+-----------------------------------+
--| Know we have to do an update,		|
--| ea. one has it's own rules!		|
--+-----------------------------------+
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFile' AND COLUMN_NAME = 'name' AND DATA_TYPE = 'VARCHAR')

	BEGIN				

--VARCHAR_TO_NVARCHAR('name', CVA_ARCHFILE_NAME_LEN)
		SET @sqlString = "ALTER TABLE archFile ADD N_name NVARCHAR(2048)"			

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
--SET @sqlString = "UPDATE archFile SET N_name = ISNULL( utfName, dbo.utf8_2_ucs(AF.name)) FROM archFile AF LEFT OUTER JOIN (SELECT cs_afname, name, dbo.utf8_2_ucs(name) utfName FROM archFile GROUP BY cs_afname, name HAVING	COUNT(*) > 10) AS T  ON AF.cs_afname = T.cs_afname"
--EXEC_IT(99, '')
		SET @sqlString = "UPDATE archFile SET N_name = dbo.utf8_2_ucs(name) WHERE cs_afname <> checksum('') AND cs_afname <> checksum('Not named')"							

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET @sqlString = "UPDATE archFile SET N_name = N'' WHERE cs_afname = checksum('')"							

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET @sqlString = "UPDATE archFile SET N_name = N'Not named' WHERE cs_afname = checksum('Not named')"							

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF EXISTS (SELECT name FROM sysindexes WHERE name = 'arfl_idx4') DROP INDEX archFile.arfl_idx4

IF ('ALTER TABLE archFile DROP COLUMN cs_afname' <> '')							
  		SET @sqlString = 'ALTER TABLE archFile DROP COLUMN cs_afname'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET @sqlString = "ALTER TABLE archFile ALTER COLUMN name NVARCHAR(2048) NOT NULL"	

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET @sqlString = "UPDATE archFile SET name = N_name"												

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET @sqlString = "ALTER TABLE archFile DROP COLUMN N_name"

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		SET ARITHABORT ON

		ALTER TABLE archFile ADD cs_afname AS checksum(name)

		SET QUOTED_IDENTIFIER ON

		CREATE INDEX arfl_idx4 ON archFile (cs_afname)

		CREATE INDEX arfl_idx5 on archFile (cloudId)

		/* Using the macro to drop PK

		DECLARE @sqlstring1 NVARCHAR(1024)

		DECLARE @constrName NVARCHAR(255)

		SET @sqlstring1 = 'ALTER TABLE [dbo].[archFile] DROP CONSTRAINT'  

     	SELECT @constrName = name FROM sysobjects WHERE parent_obj = object_id('archFile') AND xtype = 'PK'

     	SET @sqlstring1 = @sqlstring1 + N' [' + @constrName + ']'

     	EXEC sp_executesql @sqlstring1

		*/

EXECUTE @retCode = cvsp_drop_pk 'archFile'
--SET QUOTED_IDENTIFIER ON
IF ('ALTER TABLE archFile ALTER COLUMN commCellId integer NOT NULL' <> '')							
  		SET @sqlString = 'ALTER TABLE archFile ALTER COLUMN commCellId integer NOT NULL'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
--EXEC_IT(99, 'ALTER TABLE archFile ADD CONSTRAINT archFile_id_commCellId_PK primary key (id, commCellId)')
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFile' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'archFile_id_commCellId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'archFile'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'archFile' +']' + 'ADD CONSTRAINT [' + 'archFile_id_commCellId_PK' +'] PRIMARY KEY (' + 'id, commCellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFile' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'archFile_appId_isValid')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'archFile_appId_isValid' +']' + 'ON [' + 'archFile' +']  (' + 'appId,isValid' + ') INCLUDE ('+ 'id, commCellId, archGroupId, fileType, cTime, jobId,backupLevel' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archFile')			
  			insert into GXDBVersions VALUES(1, 'archFile', '0.0', 'archFile', '')	
  			UPDATE GXDBVersions SET revision = '1.55' WHERE name = 'archFile'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archFile' + '] upgraded successfully to '			+ ' revision [' + '1.55' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archFile' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archFileCopy.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archFileCopy.upg,v 1.52 2015/05/21 10:09:38 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archFileCopy')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archFileCopy')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archFileCopy'							
  END																			
  IF (@oldRev = '1.40')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archFileCopy' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archFileCopy' +'].'							
  END-- Get @oldRev, compare to '1.40'. Chk for work to do.
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME = 'commCellId' AND DATA_TYPE = 'TINYINT')

	BEGIN																														

EXECUTE @retCode = cvsp_drop_pk 'archFileCopy'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'archFileCopy', @fromColumn = 'archFileId', @toTable = 'archFile'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'archFileCopy', @fromColumn = 'commCellId', @toTable = 'archFile'
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME="commCellId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archFileCopy' + " ALTER COLUMN "+"commCellId" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFileCopy' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'archFileCopy_archFileId_commCellId_archCopyId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'archFileCopy'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'archFileCopy' +']' + 'ADD CONSTRAINT [' + 'archFileCopy_archFileId_commCellId_archCopyId_PK' +'] PRIMARY KEY (' + 'archFileId, commCellId, archCopyId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

--Creates if does not exists
	IF NOT EXISTS (	SELECT	* FROM	sys.foreign_keys

					WHERE	parent_object_id = OBJECT_ID('archFileCopy') 

					AND referenced_object_id = OBJECT_ID('archFile'))

	BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFileCopy' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'archFileCopy_archFileId_commCellId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'archFileCopy' +']' + 'ADD CONSTRAINT [' + 'archFileCopy_archFileId_commCellId_FK' +'] FOREIGN KEY (' + 'archFileId, commCellId' + ') REFERENCES ['+ 'archFile' +'] (' + 'id, commCellId' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME = 'agedby' AND DATA_TYPE = 'INT')

	BEGIN																														

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFileCopy' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'agedBy')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'archFileCopy' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF("INT"!="BIGINT")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME="agedby" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archFileCopy' + " ALTER COLUMN "+"agedby" + " "+"BIGINT"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
	END

	IF NOT EXISTS (

					SELECT IndexName = ind.name, ColumnName = col.name

					FROM sys.indexes ind 

							INNER JOIN sys.index_columns ic ON  ind.object_id = ic.object_id and ind.index_id = ic.index_id 

							INNER JOIN sys.columns col ON ic.object_id = col.object_id and ic.column_id = col.column_id 

					WHERE	ind.name = 'afc_idx1'

							AND col.name = 'isValid')

	BEGIN

IF ('DROP INDEX archFileCopy.afc_idx1' <> '')							
  		SET @sqlString = 'DROP INDEX archFileCopy.afc_idx1'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('CREATE INDEX afc_idx1 ON archFileCopy(archCopyId, isValid)' <> '')							
  		SET @sqlString = 'CREATE INDEX afc_idx1 ON archFileCopy(archCopyId, isValid)'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME="encKey" AND 
  		(CASE WHEN CHARACTER_MAXIMUM_LENGTH = -1 THEN "MAX" ELSE CAST(CHARACTER_MAXIMUM_LENGTH AS VARCHAR(20)) END) !="1024")			
  	BEGIN																														
  		SELECT	@DataType = DATA_TYPE,																							
  				@IsNullableAttr = (CASE WHEN IS_NULLABLE = 'NO' THEN ' NOT NULL ' ELSE ' NULL ' END),							
  				@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)							
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'archFileCopy' AND COLUMN_NAME="encKey"							
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFileCopy' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="encKey")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'archFileCopy' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'archFileCopy' + " ALTER COLUMN "+"encKey" + " " + @DataType + "("+"1024" + ") "			
  		+ " " + @IsNullableAttr 																				
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  		IF (LEN(@DefaultValAttr) > 0)																			
  		BEGIN																									
  			SET @sqlString = "ALTER TABLE " + 'archFileCopy' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"encKey"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																						
  		END																										
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archFileCopy' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="mediaType")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archFileCopy' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archFileCopy')			
  			insert into GXDBVersions VALUES(1, 'archFileCopy', '0.0', 'archFileCopy', '')	
  			UPDATE GXDBVersions SET revision = '1.40' WHERE name = 'archFileCopy'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archFileCopy' + '] upgraded successfully to '			+ ' revision [' + '1.40' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archFileCopy' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archChunk.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archChunk.upg,v 1.31 2014/09/13 21:30:25 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archChunk')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archChunk')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archChunk'							
  END																			
  IF (@oldRev = '1.37')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archChunk' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archChunk' +'].'							
  END--	 Get @oldRev, compare to '1.37'. Chk for work to do.
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunk' AND COLUMN_NAME = 'commCellId' AND DATA_TYPE = 'TINYINT')

	BEGIN																														

EXECUTE @retCode = cvsp_drop_pk 'archChunk'
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunk' AND COLUMN_NAME="commCellId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunk' + " ALTER COLUMN "+"commCellId" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunk' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'archChunk_id_commCellId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'archChunk'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'archChunk' +']' + 'ADD CONSTRAINT [' + 'archChunk_id_commCellId_PK' +'] PRIMARY KEY (' + 'id, commCellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

IF(("TINYINT"!="INTEGER")																
  		AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunk'										
  								AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT"))			
  	BEGIN																														
  		SELECT	@IsNullableAttr = (CASE WHEN IS_NULLABLE = 'NO' THEN ' NOT NULL ' ELSE ' NULL ' END),							
  				@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'archChunk' AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT"		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunk' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'archChunk' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = "ALTER TABLE " + 'archChunk' + " ALTER COLUMN "+"origCCId" + " "+"INTEGER"		
  		+ " " + @IsNullableAttr 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = "ALTER TABLE " + 'archChunk' + " ADD CONSTRAINT " + @cName  + " DEFAULT " + @DefaultValAttr + " FOR "+"origCCId"		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunk' AND COLUMN_NAME = 'agedby' AND DATA_TYPE = 'INT')

	BEGIN																														

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunk' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'agedBy')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'archChunk' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF("INT"!="BIGINT")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunk' AND COLUMN_NAME="agedby" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunk' + " ALTER COLUMN "+"agedby" + " "+"BIGINT"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunk' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'archChunk_physicalSize_logicalSize_createTime')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'archChunk_physicalSize_logicalSize_createTime' +']' + 'ON [' + 'archChunk' +']  (' + 'physicalSize,logicalSize,createTime' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archChunk')			
  			insert into GXDBVersions VALUES(1, 'archChunk', '0.0', 'archChunk', '')	
  			UPDATE GXDBVersions SET revision = '1.37' WHERE name = 'archChunk'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archChunk' + '] upgraded successfully to '			+ ' revision [' + '1.37' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archChunk' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archChunkMapping.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: archChunkMapping.upg,v 1.33 2015/05/21 09:56:50 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archChunkMapping')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archChunkMapping')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archChunkMapping'							
  END																			
  IF (@oldRev = '1.20')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archChunkMapping' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archChunkMapping' +'].'							
  END-- Get @oldRev, compare to '1.20'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME="jobId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ADD "+"jobId" + " "+"INTEGER"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE archChunkMapping SET jobId = B.jobId FROM archChunkMapping A, archFile B WHERE B.id = A.archFileId AND B.commCellId = A.commCellId"																			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ALTER COLUMN "+"jobId" + " "+"INTEGER" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'archChunkMapping_jobId')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'archChunkMapping_jobId' +']' + 'ON [' + 'archChunkMapping' +']  (' + 'jobId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="jobId")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'archChunkMapping' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME = 'commCellId' AND DATA_TYPE = 'TINYINT')

	BEGIN																														

EXECUTE @retCode = cvsp_drop_pk 'archChunkMapping'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'archChunkMapping', @fromColumn = 'archChunkId', @toTable = 'archChunk'
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'archChunkMapping', @fromColumn = 'archFileId', @toTable = 'archFileCopy'
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME="commCellId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ALTER COLUMN "+"commCellId" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
IF("TINYINT"!="INTEGER")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME="chunkCommCellId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ALTER COLUMN "+"chunkCommCellId" + " "+"INTEGER"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'archChunkMapping_archChunkId_archFileId_commCellId_chunkCommcellId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'archChunkMapping'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'archChunkMapping' +']' + 'ADD CONSTRAINT [' + 'archChunkMapping_archChunkId_archFileId_commCellId_chunkCommcellId_PK' +'] PRIMARY KEY (' + 'archChunkId, archFileId, commCellId, chunkCommcellId' + ') ON [' + 'cx_archdata' +']' 		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')								
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'archChunkMapping_archChunkId_chunkCommCellId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'archChunkMapping' +']' + 'ADD CONSTRAINT [' + 'archChunkMapping_archChunkId_chunkCommCellId_FK' +'] FOREIGN KEY (' + 'archChunkId, chunkCommCellId' + ') REFERENCES ['+ 'archChunk' +'] (' + 'id, commCellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'archChunkMapping_archFileId_commCellId_archCopyId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'archChunkMapping' +']' + 'ADD CONSTRAINT [' + 'archChunkMapping_archFileId_commCellId_archCopyId_FK' +'] FOREIGN KEY (' + 'archFileId, commCellId, archCopyId' + ') REFERENCES ['+ 'archFileCopy' +'] (' + 'archFileId, commCellId, archCopyId' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME = 'agedby' AND DATA_TYPE = 'INT')

	BEGIN																														

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'archChunkMapping' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'agedBy')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'archChunkMapping' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF("INT"!="BIGINT")																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME="agedby" AND DATA_TYPE="INT")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ALTER COLUMN "+"agedby" + " "+"BIGINT"		
  		+ " NOT NULL "																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME = 'unCompSize')
	BEGIN

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'archChunkMapping' AND COLUMN_NAME="unCompSize")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'archChunkMapping' + " ADD "+"unCompSize" + " "+"BIGINT"		
  			+ " NOT NULL DEFAULT "+"-1"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
		IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo

		CREATE TABLE #tmpJobSizeInfo (

			JobId INT NOT NULL, CommCellId INT NOT NULL, totalBackupSize REAL, totalAppSize REAL, totalIndexSize REAL, OpId INT, 

 			PRIMARY KEY (JobId, CommCellId))

		INSERT INTO #tmpJobSizeInfo

		SELECT	JobId, CommCellId, ISNULL(totalBackupSize, 0), totalAppSize = ISNULL(totalUncompBytes, 0), 0, JOP.id

		FROM	JMBkpStats J LEFT OUTER JOIN JMOpTable JOP WITH (NOLOCK) ON J.opType = JOP.operation  AND J.appType = JOP.appTypeType  

		WHERE	dataStatus <> 2

		INSERT INTO #tmpJobSizeInfo

		SELECT	JobId, CommCellId, ISNULL(totalBackupSize, 0), totalAppSize = (CASE WHEN (ISNULL(uncompBytes, 0) != 0) THEN ISNULL(uncompBytes, 0) ELSE ISNULL(totalBackupSize, 0) END), 0, JOP.id

		FROM	JMAdminJobStatsTable J LEFT OUTER JOIN JMOpTable JOP WITH (NOLOCK) ON J.opType = JOP.operation  AND JOP.appTypeType IN (1000)

		WHERE	dataStatus <> 2

				AND opType IN (11, 64)

--Calculate Index Size for Backup jobs
		UPDATE #tmpJobSizeInfo

		SET totalIndexSize = TMP.totalIndexSize

		FROM #tmpJobSizeInfo JS, (	SELECT T.JobId, T.CommCellId, SUM(ISNULL(JBAS.unCompBytes, 0)) AS totalIndexSize

																FROM 	#tmpJobSizeInfo T, JMBkpAtmptStats JBAS WITH (NOLOCK), JMPhase JMP WITH (NOLOCK) 

																WHERE	T.JobId = JBAS.JobId

																AND		T.CommCellId = JBAS.CommCellId

																AND 	T.OpId = JMP.opTableId

																AND 	JBAS.phase = JMP.phase 

																AND 	(JMP.name = 'Archive Index' OR JMP.startExec = 'archiveIndex.exe')

																GROUP BY T.JobId, T.CommCellId) TMP

		WHERE JS.JobID = TMP.JobId

			AND JS.CommCellId = TMP.CommCellId

--Calculate Index Size for DR Backup and Info Management (Legalhold) jobs
		UPDATE #tmpJobSizeInfo

		SET totalIndexSize = TMP.totalIndexSize

		FROM #tmpJobSizeInfo JS, (	SELECT T.JobId, T.CommCellId, SUM(ISNULL(JBAS.unCompBytes, 0)) AS totalIndexSize

																FROM 	#tmpJobSizeInfo T, JMAdminJobAttemptStatsTable JBAS WITH (NOLOCK), JMPhase JMP WITH (NOLOCK) 

																WHERE	T.JobId = JBAS.JobId

																AND		T.CommCellId = JBAS.CommCellId

																AND 	T.OpId = JMP.opTableId

																AND 	JBAS.phaseNum = JMP.phase 

																AND 	(JMP.name = 'Archive Index' OR JMP.startExec = 'archiveIndex.exe')

																GROUP BY T.JobId, T.CommCellId) TMP

		WHERE JS.JobID = TMP.JobId

				AND JS.CommCellId = TMP.CommCellId

IF ("UPDATE archChunkMapping SET unCompSize = (CASE WHEN totalBackupSize > 0 THEN CAST((((totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END) FROM	#tmpJobSizeInfo J WHERE	archChunkMapping.JobId = J.JobId AND archChunkMapping.CommCellId = J.CommCellId" <> '')							
  		SET @sqlString = "UPDATE archChunkMapping SET unCompSize = (CASE WHEN totalBackupSize > 0 THEN CAST((((totalAppSize+totalIndexSize)*physicalSize)/totalBackupSize) AS BIGINT) ELSE physicalSize END) FROM	#tmpJobSizeInfo J WHERE	archChunkMapping.JobId = J.JobId AND archChunkMapping.CommCellId = J.CommCellId"				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF OBJECT_ID('tempdb.dbo.#tmpJobSizeInfo') IS NOT NULL DROP TABLE #tmpJobSizeInfo

	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archChunkMapping')			
  			insert into GXDBVersions VALUES(1, 'archChunkMapping', '0.0', 'archChunkMapping', '')	
  			UPDATE GXDBVersions SET revision = '1.20' WHERE name = 'archChunkMapping'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archChunkMapping' + '] upgraded successfully to '			+ ' revision [' + '1.20' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archChunkMapping' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update GXDBVersions & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/APP_BackupSetName.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'APP_BackupSetName')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'APP_BackupSetName')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'APP_BackupSetName'							
  END																			
  IF (@oldRev = '1.23')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'APP_BackupSetName' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'APP_BackupSetName' +'].'							
  END
IF"TINYINT"!="INTEGER"																	
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'APP_BackupSetName' AND COLUMN_NAME="origCCId" AND DATA_TYPE="TINYINT")			
  	BEGIN																														
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'APP_BackupSetName' AND xType = 'U')													
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="origCCId")				
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET		@cName = NULL																				
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  				SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				SET  @sqlString = 'ALTER TABLE [' + 'APP_BackupSetName' +']' +'DROP CONSTRAINT [' + @cName + ']'	
  				IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		SET @sqlString = "UPDATE " + 'APP_BackupSetName' + " SET "+"origCCId" + " = "+"2" + " WHERE "+"origCCId" + " IS NULL "		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'APP_BackupSetName' + " ALTER COLUMN "+"origCCId" + " "+"INTEGER"		
  			+ " NOT NULL"																										
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (@cName IS NULL)																										
  			SET @cName = 'APP_BackupSetName' + '_'+"origCCId" + '_DF'														
  		SET @sqlString = "ALTER TABLE " + 'APP_BackupSetName' + " ADD CONSTRAINT " + @cName  + " DEFAULT "+"2" + " FOR "+"origCCId"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
--IF GUID set to NOT NULL change to NULL for 9.0 Databases that have been upgraded to match 10.0 and 11.0 fresh installs
	IF EXISTS (SELECT 1 WHERE COLUMNPROPERTY(OBJECT_ID('APP_BackupSetName'), 'GUID', 'AllowsNull') = 0)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

		CREATE TABLE #GuidList (id INT PRIMARY KEY, guid UNIQUEIDENTIFIER)

IF ('INSERT INTO #GuidList SELECT id, GUID FROM APP_BackupSetName WITH(NOLOCK)' <> '')							
  		SET @sqlString = 'INSERT INTO #GuidList SELECT id, GUID FROM APP_BackupSetName WITH(NOLOCK)'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME="APP_BackupSetName" AND COLUMN_NAME="GUID")			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name="APP_BackupSetName" AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="GUID")			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = "ALTER TABLE "+"APP_BackupSetName" +' DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = "ALTER TABLE "+"APP_BackupSetName" + " DROP COLUMN "+"GUID"	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
IF ('ALTER TABLE APP_BackupSetName ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_BackupSetName ADD GUID UNIQUEIDENTIFIER NULL ROWGUIDCOL'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('ALTER TABLE APP_BackupSetName ADD CONSTRAINT DF_APP_BackupSetName_GUID DEFAULT (newid()) FOR GUID' <> '')							
  		SET @sqlString = 'ALTER TABLE APP_BackupSetName ADD CONSTRAINT DF_APP_BackupSetName_GUID DEFAULT (newid()) FOR GUID'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('UPDATE bs SET GUID = t.GUID FROM APP_BackupSetName bs,  #GuidList t WHERE t.id = bs.id' <> '')							
  		SET @sqlString = 'UPDATE bs SET GUID = t.GUID FROM APP_BackupSetName bs,  #GuidList t WHERE t.id = bs.id'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
		IF OBJECT_ID('tempdb.dbo.#GuidList') IS NOT NULL 

			DROP TABLE #GuidList

	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'APP_BackupSetName')			
  			insert into GXDBVersions VALUES(1, 'APP_BackupSetName', '0.0', 'APP_BackupSetName', '')	
  			UPDATE GXDBVersions SET revision = '1.23' WHERE name = 'APP_BackupSetName'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'APP_BackupSetName' + '] upgraded successfully to '			+ ' revision [' + '1.23' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'APP_BackupSetName' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END
GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/archFileEdgeDrive.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'archFileEdgeDrive')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'archFileEdgeDrive')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'archFileEdgeDrive'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'archFileEdgeDrive' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'archFileEdgeDrive' +'].'							
  END--	 Get @oldRev, compare to '1.3'. Chk for work to do.

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[archFileEdgeDrive]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/archFileEdgeDrive.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- commCellUrl_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/archFileEdgeDrive.Tbl,v $ $Id: archFileEdgeDrive.Tbl,v 1.3 2015/07/07 20:26:48 chandru Exp $";

print '... Creating Table: archFileEdgeDrive'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table archFileEdgeDrive (

	archFileId		integer	NOT NULL,

	commCellId		integer	NOT NULL,

	fileType		integer	NOT NULL,

	flags			integer	NOT NULL,

	jobId			integer	NOT NULL,

	appId			integer	NOT NULL,

	clientId		integer	NOT NULL,

	WebServerId		integer	NOT NULL,

	CloudId			integer	NOT NULL,

	AFDeleteTime	integer	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [archFileEdgeDrive]''

END

--------





create index archFileEdgeDrive_appId_Idx on archFileEdgeDrive (appId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [archFileEdgeDrive]''

END

----------



create index archFileEdgeDrive_archFileId_CommCellId_Idx on archFileEdgeDrive (archFileId, commCellId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [archFileEdgeDrive]''

END

----------



insert into GXDBVersions values(1, ''archFileEdgeDrive'',  ''1.3'', ''archFileEdgeDrive'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

-------------------------------------------------------------




')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'archFileEdgeDrive')			
  			insert into GXDBVersions VALUES(1, 'archFileEdgeDrive', '0.0', 'archFileEdgeDrive', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'archFileEdgeDrive'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'archFileEdgeDrive' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'archFileEdgeDrive' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/evMsg.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: evMsg.upg,v 1.20 2014/11/05 14:35:35 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'evMsg')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'evMsg')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'evMsg'							
  END																			
  IF (@oldRev = '1.24')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'evMsg' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'evMsg' +'].'							
  END--	 Get @oldRev, compare to '1.24'. Chk for work to do.
	IF EXISTS (	SELECT name

				FROM sysobjects

				WHERE	xtype = 'U'

						AND name = 'evMsg'

						AND OBJECTPROPERTY(id, 'TableHasIdentity') = 1)

	BEGIN

--We rename the table EvMsg and recreate (need to remove the identity property for id)
EXECUTE @retCode = cvsp_drop_pk 'evMsg'
IF ('sp_rename ''evMsg'', ''evMsg_old''' <> '')							
  		SET @sqlString = 'sp_rename ''evMsg'', ''evMsg_old'''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
IF ('DELETE FROM GXDBVersions where name = ''evMsg'' and type = 1' <> '')							
  		SET @sqlString = 'DELETE FROM GXDBVersions where name = ''evMsg'' and type = 1'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[evMsg]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/evMsg.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/evMsg.tbl,v $ $Id: evMsg.tbl,v 1.24 2012/04/29 04:52:09 junlu Exp $";

print '... Creating Table: evMsg'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table evMsg (

	id					INTEGER	NOT NULL,	-- PRIMARY KEY FOR THIS TABLE

	timeSource     INTEGER  NOT NULL,	-- UNIX time event occured accord. to src computer

	timeServer     INTEGER  NOT NULL,	-- UNIX time when the event was rec''d by the EMS

	severity       integer	NOT NULL,	-- the level EL_INFO, EL_MINOR, EL_MAJOR, EL_CRITICAL

	ack            integer	NOT NULL,	-- Does this event require acknowledgement?

	acked          integer	NOT NULL,	-- Has the event been acknowledged?

	type           integer	NOT NULL,	-- ET_USER or ET_SYSTEM

	paramNum       integer	NOT NULL,	-- Number of parameters assoc. w/ this message

	messageId      integer	NOT NULL,	-- The event message Identifier.

	jobId_h	 integer	NOT NULL,

	jobId_l	 integer	NOT NULL,

	clientID       integer	NOT NULL,	-- f-key to client(id)

	commCellID     integer	NOT NULL,	-- f-key to commCell(id)

	userID         integer	NOT NULL,	-- f-key to users(id)

	subsystemID    integer	NOT NULL,	-- f-key to subsystem(id)

	client				varchar(128) NOT NULL,

	commCell				varchar(128) NOT NULL,

	userName				varchar(128) NOT NULL,

	subsystem				varchar(128) NOT NULL,

	msgEnglish				varchar(1024) NOT NULL,

	repeatCount    integer	NOT NULL,

	lastOccurrence INTEGER  NOT NULL,

	nextPost       INTEGER  NOT NULL,

	mediaId					integer	NOT NULL,

	driveId					integer	NOT NULL,

	libraryId				integer	NOT NULL,

	maClientId			integer	NOT NULL,



) on cx_eventdata



create index evMsg_idx2 on evMsg (timeSource, type) on cx_eventindex

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [evMsg]''

END

----------



create index evMsg_idx3 on evMsg (userID)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [evMsg]''

END

----------



create index evMsg_idx4 on evMsg (jobId_h, jobId_l) on cx_eventindex

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [evMsg]''

END

----------



create index EvMsg_MessageId_LastOccurence_JobId ON EvMsg (MessageId, lastOccurrence, JobId_l)

 



insert into GXDBVersions values(1, ''evMsg'',  ''1.24'', ''evMsg'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE evMsg ADD CONSTRAINT evMsg_id_commCellID_PK 		primary key (id,commCellID)on cx_eventdata



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [evMsg]''

END

----------


')
END
--Drop primary key on new created table (This speeds up insert and updates while doing upgrade on large data)
EXECUTE @retCode = cvsp_drop_pk 'evMsg'
--transfer old data
		INSERT INTO EvMsg SELECT * FROM evMsg_old

		DROP TABLE evMsg_old

--Need to do this because, we are going to create a foreign key constraint for evParam table which will reference evMsg
IF ('UPDATE evMsg SET commCellID = 2' <> '')							
  		SET @sqlString = 'UPDATE evMsg SET commCellID = 2'				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END
--Again create the primary constraint
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'evMsg' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'evMsg_id_commCellID_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'evMsg'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'evMsg' +']' + 'ADD CONSTRAINT [' + 'evMsg_id_commCellID_PK' +'] PRIMARY KEY (' + 'id,commCellID' + ') ON [' + 'cx_eventdata' +']' 		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'evMsg')			
  			insert into GXDBVersions VALUES(1, 'evMsg', '0.0', 'evMsg', '')	
  			UPDATE GXDBVersions SET revision = '1.24' WHERE name = 'evMsg'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'evMsg' + '] upgraded successfully to '			+ ' revision [' + '1.24' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'evMsg' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/evParam.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: evParam.upg,v 1.13 2014/11/17 13:56:50 mupadhyay Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'evParam')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'evParam')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'evParam'							
  END																			
  IF (@oldRev = '1.16')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'evParam' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'evParam' +'].'							
  END--	 Get @oldRev, compare to '1.16'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'evParam' AND COLUMN_NAME="commCellId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'evParam' + " ADD "+"commCellId" + " "+"INTEGER"		
  			+ " NOT NULL DEFAULT "+"2"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'evParam' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'evParam_evMsgId_position_commcellId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'evParam'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'evParam' +']' + 'ADD CONSTRAINT [' + 'evParam_evMsgId_position_commcellId_PK' +'] PRIMARY KEY (' + 'evMsgId, position,commcellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
EXECUTE @retCode = cvsp_drop_fkeys @fromTable = 'evParam', @fromColumn = 'evMsgId', @toTable = 'evMsg'
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'evParam' AND xType = 'U')				
  	IF NOT EXISTS (SELECT * FROM	sys.foreign_keys WHERE	name = 'evParam_evMsgId_commcellId_FK' AND delete_referential_action = 1 AND parent_object_id = @parentID)
	BEGIN 

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'evParam' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'evParam_evMsgId_commcellId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'evParam' +']' + 'ADD CONSTRAINT [' + 'evParam_evMsgId_commcellId_FK' +'] FOREIGN KEY (' + 'evMsgId,commcellId' + ') REFERENCES ['+ 'evMsg' +'] (' + 'id,commcellId' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'evParam')			
  			insert into GXDBVersions VALUES(1, 'evParam', '0.0', 'evParam', '')	
  			UPDATE GXDBVersions SET revision = '1.16' WHERE name = 'evParam'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'evParam' + '] upgraded successfully to '			+ ' revision [' + '1.16' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'evParam' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/EvMsgCache.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: EvMsgCache.upg,v 1.3 2014/05/04 05:37:48 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'EvMsgCache')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'EvMsgCache')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'EvMsgCache'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'EvMsgCache' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'EvMsgCache' +'].'							
  END--	 Get @oldRev, compare to '1.2'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'EvMsgCache' AND COLUMN_NAME="commCellId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'EvMsgCache' + " ADD "+"commCellId" + " "+"INTEGER"		
  			+ " NOT NULL DEFAULT "+"2"																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'EvMsgCache' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'EvMsgCache_evMsgId_LocaleId_commcellId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'EvMsgCache'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'EvMsgCache' +']' + 'ADD CONSTRAINT [' + 'EvMsgCache_evMsgId_LocaleId_commcellId_PK' +'] PRIMARY KEY (' + 'evMsgId, LocaleId,commcellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'EvMsgCache')			
  			insert into GXDBVersions VALUES(1, 'EvMsgCache', '0.0', 'EvMsgCache', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'EvMsgCache'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'EvMsgCache' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'EvMsgCache' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/SchedHoliday.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: schedHoliday.upg,v 1.16 2015/06/10 14:10:20 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'schedHoliday')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'schedHoliday')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'schedHoliday'							
  END																			
  IF (@oldRev = '1.9')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'schedHoliday' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'schedHoliday' +'].'							
  END--	 Get @oldRev, compare to '1.9'. Chk for work to do.
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'schedHoliday' AND COLUMN_NAME="vtPolicyId")			
  	BEGIN																														
  		SET @sqlString = "ALTER TABLE " + 'schedHoliday' + " ADD "+"vtPolicyId" + " "+"INTEGER"			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "UPDATE " + 'schedHoliday' + " SET "+"vtPolicyId" + " = "+"0"		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = "ALTER TABLE " + 'schedHoliday' + " ALTER COLUMN "+"vtPolicyId" + " "+"INTEGER" + " NOT NULL"					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'schedHoliday' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME="vtPolicyId")			
  	SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  	WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	SET @cName = NULL																						
  	IF(@constId IS NOT NULL)																				
  	BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'schedHoliday' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'schedHoliday' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'SchedHoliday_id_startYear_startMonth_startDay_startHour_startMinute_startSecond_endYear_endMonth_endDay_endHour_end_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'schedHoliday'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'schedHoliday' +']' + 'ADD CONSTRAINT [' + 'SchedHoliday_id_startYear_startMonth_startDay_startHour_startMinute_startSecond_endYear_endMonth_endDay_endHour_end_PK' +'] PRIMARY KEY (' + 'id, startYear, startMonth, startDay, startHour, startMinute, startSecond, endYear, endMonth, endDay, endHour, endMinute, endSecond,clientId,groupId,vtPolicyId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'schedHoliday')			
  			insert into GXDBVersions VALUES(1, 'schedHoliday', '0.0', 'schedHoliday', '')	
  			UPDATE GXDBVersions SET revision = '1.9' WHERE name = 'schedHoliday'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'schedHoliday' + '] upgraded successfully to '			+ ' revision [' + '1.9' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'schedHoliday' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/JMSaveBkpJob.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: JMSaveBkpJob.upg,v 1.7 2014/05/05 04:46:48 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'JMSaveBkpJob')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'JMSaveBkpJob')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'JMSaveBkpJob'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'JMSaveBkpJob' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'JMSaveBkpJob' +'].'							
  END-- Get @oldRev, compare to '1.4'. Chk for work to do.
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'JMSaveBkpJob')			
  			insert into GXDBVersions VALUES(1, 'JMSaveBkpJob', '0.0', 'JMSaveBkpJob', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'JMSaveBkpJob'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'JMSaveBkpJob' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'JMSaveBkpJob' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!
END

GO
IF @@error <> 0 RETURN
GO




--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/JMSchedulerRunOptions.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--$Id: JMSchedulerRunOptions.upg,v 1.3 2014/05/05 04:46:48 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'JMSchedulerRunOptions')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'JMSchedulerRunOptions')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'JMSchedulerRunOptions'							
  END																			
  IF (@oldRev = '1.1')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'JMSchedulerRunOptions' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'JMSchedulerRunOptions' +'].'							
  END-- Get @oldRev, compare to '1.1'. Chk for work to do.
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions W