

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/oracleTableSpaces.upg] ---------- 

--$Id: oracleTableSpaces.upg,v 1.9.2.3 2019/08/20 04:17:21 abilbrey Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'OracleTableSpaces')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'OracleTableSpaces')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'OracleTableSpaces'							
  END																			
  IF (@oldRev = '1.12')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'OracleTableSpaces' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'OracleTableSpaces' +'].'							
  END-- Get @oldRev, compare to '1.12'. Chk for work to do.

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OracleTableSpaces' AND COLUMN_NAME='pdbId')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'OracleTableSpaces'+ ' ADD ' +'pdbId'+ ' ' +'integer'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OracleTableSpaces' AND xType = 'U')								
  	SELECT @colID = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME='pdbId')			
  	SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  	IF NOT EXISTS (	SELECT	*																						
  					FROM	sys.default_constraints																					
  					WHERE	parent_object_id = @parentID AND parent_column_id = @colID AND REPLACE(REPLACE(definition, '(', ''), ')', '') = @macroValue) 
  	BEGIN			
  		SELECT @constId = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  		WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		SET @cName = NULL																						
  		IF(@constId IS NOT NULL)																				
  		BEGIN		
  		SELECT @cName = (SELECT name FROM sysobjects WHERE id = @constId)							
  		SET  @sqlString = 'ALTER TABLE [' + 'OracleTableSpaces' + ']' + 'DROP CONSTRAINT [' + @cName + ']'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END																									
  		IF(@cName IS NULL)																						
  		SET @cName = 'OracleTableSpaces' + '_'+'pdbId' + '_DF'									
  		SET @sqlString = 'ALTER TABLE ' + 'OracleTableSpaces' + ' ADD CONSTRAINT ' + @cName + ' DEFAULT ' + @macroValue+ ' FOR ' +'pdbId'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OracleTableSpaces' AND COLUMN_NAME='highwatermark')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'OracleTableSpaces'+ ' ADD ' +'highwatermark'+ ' ' +'integer'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OracleTableSpaces' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'oracleTableSpaces_pdbId_Idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'oracleTableSpaces_pdbId_Idx' +']' + 'ON [' + 'OracleTableSpaces' +']  (' + 'pdbId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OracleTableSpaces' AND xType = 'U')				
  	IF NOT EXISTS (SELECT * FROM	sys.foreign_keys WHERE	name = 'oracleTableSpaces_instId_FK' AND parent_object_id = @parentID)

BEGIN

	DECLARE @maxJobsToPruneInBatch INT = 25000

	DECLARE @errVal INT

	DECLARE @retVal INT

	DECLARE @rowCnt INT

    WHILE (1 = 1)

    BEGIN 

		DELETE	TOP (@maxJobsToPruneInBatch)	O

		FROM	oracleTableSpaces O

			LEFT OUTER JOIN APP_InstanceName I

				ON O.instId = I.id

		WHERE	I.id IS NULL

		SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT

        IF @errVal != 0 

        BEGIN

            SET @retVal = @errVal

            BREAK

        END

        IF @rowCnt = 0

            BREAK 

	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OracleTableSpaces' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'oracleTableSpaces_instId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'OracleTableSpaces' +']' + 'ADD CONSTRAINT [' + 'oracleTableSpaces_instId_FK' +'] FOREIGN KEY (' + 'instId' + ') REFERENCES ['+ 'APP_InstanceName' +'] (' + 'id' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'OracleTableSpaces')			
  			insert into GXDBVersions VALUES(1, 'OracleTableSpaces', '0.0', 'OracleTableSpaces', '')	
  			UPDATE GXDBVersions SET revision = '1.12' WHERE name = 'OracleTableSpaces'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'OracleTableSpaces' + '] upgraded successfully to '			+ ' revision [' + '1.12' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'OracleTableSpaces' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return

END

GO
IF @@error <> 0 RETURN
GO
