

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMSecurityAssociations.upg] ---------- 

BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMSecurityAssociations')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMSecurityAssociations')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMSecurityAssociations'							
  END																			
  IF (@oldRev = '1.10')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMSecurityAssociations' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMSecurityAssociations' +'].'							
  END-- Get @oldRev, compare to '1.10'. Chk for work to do.

--Create a new table in case this does not exist, since from 10.0 to 11.0 upgrade, this table wont even exist

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMSecurityAssociations]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl,v $ $Id: UMSecurityAssociations.tbl,v 1.5.48.9 2019/11/04 16:27:10 mklose Exp $";

print '... Creating Table: UMSecurityAssociations'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMSecurityAssociations (

	roleId 						INT   DEFAULT 0	NOT NULL,	--when role is associated

	permissionId                INT   DEFAULT 0	NOT NULL,	--when permission is associated directly

	userOrGroupId 				INT	NOT NULL,	--user Id or user Group Id

	isUser 						INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	isRoleAllowed 				INT 	DEFAULT 1	NOT NULL,	--when set to 0 means that role is denied

	propagateToChildObjects 	INT 	DEFAULT 1	NOT NULL,	--flag to indicate whether the association should propagate to child objects

	roleValidityDate 			INT 	DEFAULT 0	NOT NULL,	--expiration date for this association (UTC)

	timeZone 					INT 	DEFAULT 0	NOT NULL,	--time zone for this expiration date (used only to send data back to GUI)

	exclude 					INT 	DEFAULT 0	NOT NULL,	--if some entity needs to be excluded from parent selection

	entityType1 				INT		DEFAULT 0	NOT NULL,	--the 5 entity hierarchy on which association is done

	entityId1 					INT		DEFAULT 0	NOT NULL,

	entityType2 				INT		DEFAULT 0	NOT NULL,

	entityId2 					INT		DEFAULT 0	NOT NULL,

	entityType3 				INT		DEFAULT 0	NOT NULL,

	entityId3 					INT		DEFAULT 0	NOT NULL,

	entityType4 				INT		DEFAULT 0	NOT NULL,

	entityId4 					INT		DEFAULT 0	NOT NULL,

	entityType5 				INT		DEFAULT 0	NOT NULL,

	entityId5 					INT		DEFAULT 0	NOT NULL,

	includeAll					INT		DEFAULT 0	NOT NULL,	--to indicate whether all entities of this entity type is selected or not

	isCreator					INT     DEFAULT 0	NOT NULL,	--flag to indicate whether this row corresponds to a entity creator (permissions are hard-coded in code)

	authorId					INT		DEFAULT 0	NOT NULL,	--this is a column for future reference- to indicate which user has done this operation

	companyId					INT		DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this security association is made for.

	securityId                          INTEGER NOT NULL IDENTITY (1,1),             	--this is a primary key column



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMSecurityAssociations]''

END

--------





create clustered index UMSecurityAssociations_isUser_userOrGroupId on UMSecurityAssociations(isUser,userOrGroupId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (isUser,userOrGroupId,entityType1,entityId1,includeAll) INCLUDE(roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_includeAll on UMSecurityAssociations(isUser,userOrGroupId,includeAll)  INCLUDE (entityType1,roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create unique nonclustered index UMSecurityAssociations_roleId_permissionId_isUser_userOrGroupId_entity_isCreator on UMSecurityAssociations (roleId, permissionId, isUser, userOrGroupId, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, isCreator)



CREATE NONCLUSTERED INDEX UMSecurityAssociations_All_EntityIds_idx ON UMSecurityAssociations (entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator)



WITH(FILLFACTOR=90)



create nonclustered index UMSecurityAssociations_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (entityType1, entityId1, includeAll) include (isUser, userOrGroupId, roleId, permissionId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create nonclustered index UMSecurityAssociations_entityType1_companyId_isCreator_idx on UMSecurityAssociations (entityType1, companyId, isCreator)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------





insert into GXDBVersions values(1, ''UMSecurityAssociations'',  ''1.5.48.9'', ''UMSecurityAssociations'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMSecurityAssociations ADD CONSTRAINT UMSecurityAssociations_securityId_PK 		primary key (securityId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_companyId_FK	foreign key(companyId)references	 UMDSProviders(id) on delete cascade



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_permissionId_FK	foreign key(permissionId)references	 UMPermissions(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_roleId_FK	foreign key(roleId)references	 UMRoles(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME = 'entityType1')

    BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'securityAssociations_idx2')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMSecurityAssociations' +'].[' + 'securityAssociations_idx2' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'securityAssociations_idx3')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMSecurityAssociations' +'].[' + 'securityAssociations_idx3' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'securityAssociations_idx4')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMSecurityAssociations' +'].[' + 'securityAssociations_idx4' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType')			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME='entityType')			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = 'ALTER TABLE [' + 'UMSecurityAssociations' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' DROP COLUMN ' +'entityType'	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId')			
  	BEGIN																							
  		SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
  		SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME='entityId')			
  		SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  					WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  		IF (@constId IS NOT NULL)																			
  		BEGIN																								
  			  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  			  SET  @sqlString = 'ALTER TABLE [' + 'UMSecurityAssociations' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  			  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  		END 
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' DROP COLUMN ' +'entityId'	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType1')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityType1'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId1')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityId1'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType2')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityType2'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId2')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityId2'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType3')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityType3'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId3')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityId3'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType4')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityType4'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId4')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityId4'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityType5')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityType5'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='entityId5')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'entityId5'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_userId_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_userId_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'userId, entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_userGroupId_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_userGroupId_eType1_eId1_eType2_eId2_eType3_eId3_eType4_eId4_eType5_eId5_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'userGroupId, entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

    END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='includeAll')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'includeAll'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME = 'permissionId')

	BEGIN

--build to build upgrade
		IF EXISTS (SELECT roleID FROM UMSecurityAssociations)

		BEGIN

			IF  EXISTS(SELECT * FROM sysObjects where id=object_id(N'[dbo].[UMSecurityAssociationsTemp]') and OBJECTPROPERTY(id,N'isTable')=1)

			BEGIN

				SET @sqlString = 'DROP TABLE UMSecurityAssociationsTemp '

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

			END                       

			SET @sqlString='
					SELECT roleId,userId,usergroupId,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll
							INTO UMSecurityAssociationsTemp
							FROM UMSecurityAssociations'


IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

IF EXISTS (SELECT * FROM sysobjects				
  				WHERE type = 'U' and name = 'UMSecurityAssociations')	
  	BEGIN											
  		EXECUTE @retCode = cvsp_drop_pk 'UMSecurityAssociations'		
  		SET @sqlString = 'DROP TABLE ' + 'UMSecurityAssociations'		
  		EXEC sp_executesql @sqlString				
  		SET @sqlError = @@ERROR						
  		IF @sqlError = 0							
  		BEGIN										
  			DELETE FROM GXDBVersions WHERE name= 'UMSecurityAssociations'	
   PRINT 'RETVAL: 0  TABLE [' + 'UMSecurityAssociations'				+ '] successfully dropped.'			
  		END											
  		ELSE										
   PRINT 'RETVAL: 10 SQL Error: ' + CONVERT(CHAR(8), @sqlError)				+ ' [' + @sqlString + ']'			
  	END												
  	ELSE											
   PRINT 'RETVAL: 0  TABLE [' + 'UMSecurityAssociations'				+ '] already dropped.'


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMSecurityAssociations]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl,v $ $Id: UMSecurityAssociations.tbl,v 1.5.48.9 2019/11/04 16:27:10 mklose Exp $";

print '... Creating Table: UMSecurityAssociations'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMSecurityAssociations (

	roleId 						INT   DEFAULT 0	NOT NULL,	--when role is associated

	permissionId                INT   DEFAULT 0	NOT NULL,	--when permission is associated directly

	userOrGroupId 				INT	NOT NULL,	--user Id or user Group Id

	isUser 						INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	isRoleAllowed 				INT 	DEFAULT 1	NOT NULL,	--when set to 0 means that role is denied

	propagateToChildObjects 	INT 	DEFAULT 1	NOT NULL,	--flag to indicate whether the association should propagate to child objects

	roleValidityDate 			INT 	DEFAULT 0	NOT NULL,	--expiration date for this association (UTC)

	timeZone 					INT 	DEFAULT 0	NOT NULL,	--time zone for this expiration date (used only to send data back to GUI)

	exclude 					INT 	DEFAULT 0	NOT NULL,	--if some entity needs to be excluded from parent selection

	entityType1 				INT		DEFAULT 0	NOT NULL,	--the 5 entity hierarchy on which association is done

	entityId1 					INT		DEFAULT 0	NOT NULL,

	entityType2 				INT		DEFAULT 0	NOT NULL,

	entityId2 					INT		DEFAULT 0	NOT NULL,

	entityType3 				INT		DEFAULT 0	NOT NULL,

	entityId3 					INT		DEFAULT 0	NOT NULL,

	entityType4 				INT		DEFAULT 0	NOT NULL,

	entityId4 					INT		DEFAULT 0	NOT NULL,

	entityType5 				INT		DEFAULT 0	NOT NULL,

	entityId5 					INT		DEFAULT 0	NOT NULL,

	includeAll					INT		DEFAULT 0	NOT NULL,	--to indicate whether all entities of this entity type is selected or not

	isCreator					INT     DEFAULT 0	NOT NULL,	--flag to indicate whether this row corresponds to a entity creator (permissions are hard-coded in code)

	authorId					INT		DEFAULT 0	NOT NULL,	--this is a column for future reference- to indicate which user has done this operation

	companyId					INT		DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this security association is made for.

	securityId                          INTEGER NOT NULL IDENTITY (1,1),             	--this is a primary key column



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMSecurityAssociations]''

END

--------





create clustered index UMSecurityAssociations_isUser_userOrGroupId on UMSecurityAssociations(isUser,userOrGroupId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (isUser,userOrGroupId,entityType1,entityId1,includeAll) INCLUDE(roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_includeAll on UMSecurityAssociations(isUser,userOrGroupId,includeAll)  INCLUDE (entityType1,roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create unique nonclustered index UMSecurityAssociations_roleId_permissionId_isUser_userOrGroupId_entity_isCreator on UMSecurityAssociations (roleId, permissionId, isUser, userOrGroupId, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, isCreator)



CREATE NONCLUSTERED INDEX UMSecurityAssociations_All_EntityIds_idx ON UMSecurityAssociations (entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator)



WITH(FILLFACTOR=90)



create nonclustered index UMSecurityAssociations_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (entityType1, entityId1, includeAll) include (isUser, userOrGroupId, roleId, permissionId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create nonclustered index UMSecurityAssociations_entityType1_companyId_isCreator_idx on UMSecurityAssociations (entityType1, companyId, isCreator)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------





insert into GXDBVersions values(1, ''UMSecurityAssociations'',  ''1.5.48.9'', ''UMSecurityAssociations'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMSecurityAssociations ADD CONSTRAINT UMSecurityAssociations_securityId_PK 		primary key (securityId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_companyId_FK	foreign key(companyId)references	 UMDSProviders(id) on delete cascade



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_permissionId_FK	foreign key(permissionId)references	 UMPermissions(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_roleId_FK	foreign key(roleId)references	 UMRoles(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------


')
END
			SET @sqlString='
							INSERT INTO UMSecurityAssociations (roleId,permissionId,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId)
							SELECT roleId,0, CASE  WHEN userId<>0 THEN userId ELSE userGroupId END, 


							       CASE WHEN userId<>0 THEN 1  

								    WHEN userGroupId<>0 THEN 0 END,						isRoleAllowed,propagateToChildObjects,roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,0,0
							FROM UMSecurityAssociationsTemp
							WHERE userId<>0 OR usergroupId<>0
							DROP TABLE UMSecurityAssociationsTemp '


IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

		END

		ELSE

		BEGIN

IF EXISTS (SELECT * FROM sysobjects				
  				WHERE type = 'U' and name = 'UMSecurityAssociations')	
  	BEGIN											
  		EXECUTE @retCode = cvsp_drop_pk 'UMSecurityAssociations'		
  		SET @sqlString = 'DROP TABLE ' + 'UMSecurityAssociations'		
  		EXEC sp_executesql @sqlString				
  		SET @sqlError = @@ERROR						
  		IF @sqlError = 0							
  		BEGIN										
  			DELETE FROM GXDBVersions WHERE name= 'UMSecurityAssociations'	
   PRINT 'RETVAL: 0  TABLE [' + 'UMSecurityAssociations'				+ '] successfully dropped.'			
  		END											
  		ELSE										
   PRINT 'RETVAL: 10 SQL Error: ' + CONVERT(CHAR(8), @sqlError)				+ ' [' + @sqlString + ']'			
  	END												
  	ELSE											
   PRINT 'RETVAL: 0  TABLE [' + 'UMSecurityAssociations'				+ '] already dropped.'


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMSecurityAssociations]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMSecurityAssociations.tbl,v $ $Id: UMSecurityAssociations.tbl,v 1.5.48.9 2019/11/04 16:27:10 mklose Exp $";

print '... Creating Table: UMSecurityAssociations'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMSecurityAssociations (

	roleId 						INT   DEFAULT 0	NOT NULL,	--when role is associated

	permissionId                INT   DEFAULT 0	NOT NULL,	--when permission is associated directly

	userOrGroupId 				INT	NOT NULL,	--user Id or user Group Id

	isUser 						INT	NOT NULL,	--flag which when set to 1 indicates that the id in userOrGroupId column is userId else user Group Id

	isRoleAllowed 				INT 	DEFAULT 1	NOT NULL,	--when set to 0 means that role is denied

	propagateToChildObjects 	INT 	DEFAULT 1	NOT NULL,	--flag to indicate whether the association should propagate to child objects

	roleValidityDate 			INT 	DEFAULT 0	NOT NULL,	--expiration date for this association (UTC)

	timeZone 					INT 	DEFAULT 0	NOT NULL,	--time zone for this expiration date (used only to send data back to GUI)

	exclude 					INT 	DEFAULT 0	NOT NULL,	--if some entity needs to be excluded from parent selection

	entityType1 				INT		DEFAULT 0	NOT NULL,	--the 5 entity hierarchy on which association is done

	entityId1 					INT		DEFAULT 0	NOT NULL,

	entityType2 				INT		DEFAULT 0	NOT NULL,

	entityId2 					INT		DEFAULT 0	NOT NULL,

	entityType3 				INT		DEFAULT 0	NOT NULL,

	entityId3 					INT		DEFAULT 0	NOT NULL,

	entityType4 				INT		DEFAULT 0	NOT NULL,

	entityId4 					INT		DEFAULT 0	NOT NULL,

	entityType5 				INT		DEFAULT 0	NOT NULL,

	entityId5 					INT		DEFAULT 0	NOT NULL,

	includeAll					INT		DEFAULT 0	NOT NULL,	--to indicate whether all entities of this entity type is selected or not

	isCreator					INT     DEFAULT 0	NOT NULL,	--flag to indicate whether this row corresponds to a entity creator (permissions are hard-coded in code)

	authorId					INT		DEFAULT 0	NOT NULL,	--this is a column for future reference- to indicate which user has done this operation

	companyId					INT		DEFAULT 0	NOT NULL,	--this column refers to the company Id of this user / group to which this security association is made for.

	securityId                          INTEGER NOT NULL IDENTITY (1,1),             	--this is a primary key column



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMSecurityAssociations]''

END

--------





create clustered index UMSecurityAssociations_isUser_userOrGroupId on UMSecurityAssociations(isUser,userOrGroupId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (isUser,userOrGroupId,entityType1,entityId1,includeAll) INCLUDE(roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create index UMSecurityAssociations_isUser_userOrGroupId_includeAll on UMSecurityAssociations(isUser,userOrGroupId,includeAll)  INCLUDE (entityType1,roleId,permissionId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create unique nonclustered index UMSecurityAssociations_roleId_permissionId_isUser_userOrGroupId_entity_isCreator on UMSecurityAssociations (roleId, permissionId, isUser, userOrGroupId, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, isCreator)



CREATE NONCLUSTERED INDEX UMSecurityAssociations_All_EntityIds_idx ON UMSecurityAssociations (entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator)



WITH(FILLFACTOR=90)



create nonclustered index UMSecurityAssociations_entityType1_entityId1_includeAll_idx on UMSecurityAssociations (entityType1, entityId1, includeAll) include (isUser, userOrGroupId, roleId, permissionId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------



create nonclustered index UMSecurityAssociations_entityType1_companyId_isCreator_idx on UMSecurityAssociations (entityType1, companyId, isCreator)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------





insert into GXDBVersions values(1, ''UMSecurityAssociations'',  ''1.5.48.9'', ''UMSecurityAssociations'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMSecurityAssociations ADD CONSTRAINT UMSecurityAssociations_securityId_PK 		primary key (securityId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_companyId_FK	foreign key(companyId)references	 UMDSProviders(id) on delete cascade



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_permissionId_FK	foreign key(permissionId)references	 UMPermissions(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------

ALTER TABLE UMSecurityAssociations  ADD CONSTRAINT UMSecurityAssociations_roleId_FK	foreign key(roleId)references	 UMRoles(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMSecurityAssociations]''

END

----------


')
END
		END

	END	

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE id = OBJECT_ID(N'[dbo].[UMSecurityAssociationsTrigger]') AND OBJECTPROPERTY(id, N'IsTrigger') = 1)

BEGIN

  DROP TRIGGER [dbo].[UMSecurityAssociationsTrigger]

  DELETE FROM GXDBVersions WHERE name = 'UMSecurityAssociationsTrigger' AND type = 6

END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_All_EntityIds_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_All_EntityIds_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,isCreator' + ') WITH (FILLFACTOR = ' + '90' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_roleId_permissionId_isUser_userOrGroupId_entity_isCreator')					
      BEGIN																								
  		SET @sqlString = 'CREATE UNIQUE INDEX [' + 'UMSecurityAssociations_roleId_permissionId_isUser_userOrGroupId_entity_isCreator' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'roleId, permissionId, isUser, userOrGroupId, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, isCreator' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_entityType1_entityId1')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMSecurityAssociations' +'].[' + 'UMSecurityAssociations_entityType1_entityId1' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_entityType1_entityId1_includeAll_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_entityType1_entityId1_includeAll_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'entityType1, entityId1, includeAll' + ') INCLUDE ('+ 'isUser, userOrGroupId, roleId, permissionId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'UMSecurityAssociations' +'].[' + 'UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1_includeAll_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'UMSecurityAssociations_isUser_userOrGroupId_entityType1_entityId1_includeAll_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'isUser,userOrGroupId,entityType1,entityId1,includeAll' + ') INCLUDE ('+ 'roleId, permissionId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='companyId')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'companyId'+ ' ' +'INTEGER'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
  	IF NOT EXISTS (SELECT * FROM	sys.foreign_keys WHERE	name = 'UMSecurityAssociations_companyId_FK' AND delete_referential_action = 1 AND parent_object_id = @parentID)

BEGIN    

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')				
  	IF NOT EXISTS (SELECT  name FROM sys.foreign_keys WHERE parent_object_id = @parentID AND name = 'UMSecurityAssociations_companyId_FK')	
  	BEGIN																								
  		SET @sqlString = 'ALTER TABLE [' + 'UMSecurityAssociations' +']' + 'ADD CONSTRAINT [' + 'UMSecurityAssociations_companyId_FK' +'] FOREIGN KEY (' + 'companyId' + ') REFERENCES ['+ 'UMDSProviders' +'] (' + 'id' + ') ON DELETE CASCADE'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = @parentID AND name = 'UMSecurityAssociations_entityType1_companyId_isCreator_idx')			
      BEGIN																								
  		SET @sqlString = 'CREATE NONCLUSTERED INDEX [' + 'UMSecurityAssociations_entityType1_companyId_isCreator_idx' +']' + 'ON [' + 'UMSecurityAssociations' +']  (' + 'entityType1, companyId, isCreator' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMSecurityAssociations' AND COLUMN_NAME='securityId')           
      BEGIN                                                                                                                       
          SET @sqlString = 'ALTER TABLE ' + 'UMSecurityAssociations'+ ' ADD ' +'securityId'+ ' ' +'INTEGER'+ ' IDENTITY(' +'1'+ ',' +'1'    
              + ') NOT NULL '                                                                                                         
          IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END                                                                                                         
      END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMSecurityAssociations' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF (@keyname IS NULL OR @keyname != 'UMSecurityAssociations_securityId_PK')														
  	BEGIN																								
  		IF (@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'UMSecurityAssociations'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'UMSecurityAssociations' +']' + 'ADD CONSTRAINT [' + 'UMSecurityAssociations_securityId_PK' +'] PRIMARY KEY (' + 'securityId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMSecurityAssociations')			
  			insert into GXDBVersions VALUES(1, 'UMSecurityAssociations', '0.0', 'UMSecurityAssociations', '')	
  			UPDATE GXDBVersions SET revision = '1.10' WHERE name = 'UMSecurityAssociations'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMSecurityAssociations' + '] upgraded successfully to '			+ ' revision [' + '1.10' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMSecurityAssociations' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!

END

GO
IF @@error <> 0 RETURN
GO
