

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMRoles.upg] ---------- 

BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMRoles')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMRoles')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMRoles'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMRoles' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMRoles' +'].'							
  END-- Get @oldRev, compare to '1.4'. Chk for work to do.

--Create a new table in case this does not exist, since from 10.0 to 11.0 upgrade, this table wont even exist

IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMRoles]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMRoles.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMRoles.tbl,v $ $Id: UMRoles.tbl,v 1.2.60.3 2017/11/16 06:07:41 jswaminathan Exp $";

print '... Creating Table: UMRoles'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMRoles (

	id 						INTEGER NOT NULL IDENTITY (1,1),

	commcellId 			    integer    DEFAULT 2	NOT NULL,

	name   					NVARCHAR(255),	-- roles name NOT NULL

	description               NVARCHAR(3072),	-- roles description NOT NULL

	disabled             		integer	NOT NULL,	-- is this roles disabled

	isPrivate   				integer	NOT NULL,	-- keeping it as isPrivate instead of private since private is a keyword in cpp

	flags						integer	NOT NULL,	--to indicate DUMMY, DEFAULT, HIDDEN, etc

	ownerId                   integer	NOT NULL,

	created 					INTEGER  NOT NULL,

	modified 					INTEGER  NOT NULL,

	GUID                      uniqueidentifier ROWGUIDCOL,      	-- for Unique identification across CommCells

	xmlProperties				xml,										--for storing any properties that get added in the form of xml

	capabilitiesBitMask		bigint NOT NULL default 0,

	permissionsString			varchar(512) NOT NULL default ''''



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMRoles]''

END

--------





ALTER TABLE UMRoles ADD CONSTRAINT

DF_UMRoles_GUID DEFAULT (newid()) FOR GUID

create unique index roles_idx2 on UMRoles(name)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMRoles]''

END

----------



CREATE UNIQUE NONCLUSTERED INDEX UMRoles_disabled_id_idx ON UMRoles (disabled,id) WITH (FILLFACTOR = 90)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMRoles]''

END

----------





insert into GXDBVersions values(1, ''UMRoles'',  ''1.2.60.3'', ''UMRoles'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMRoles ADD CONSTRAINT UMRoles_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMRoles]''

END

----------


')
END
--If this is upgrade from 9.0 or 10.0 to 11.0, then the table itself would have the new columns
--If this is a build-to-build upgrade from lesser build to current build in 11.0, then the table column would be altered
--if the name is old column name. If not it will just leave it untouched
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'roleDisabled')			
  		AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'disabled')	
  	BEGIN																										
  		SET @sqlString = 'sp_rename ''' + 'UMRoles' + '.' + 'roleDisabled' + ''', ''' + 'disabled' + ''', ''COLUMN''' 			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'roleVisibility')			
  		AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'isPrivate')	
  	BEGIN																										
  		SET @sqlString = 'sp_rename ''' + 'UMRoles' + '.' + 'roleVisibility' + ''', ''' + 'isPrivate' + ''', ''COLUMN''' 			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'roleFlags')			
  		AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME = 'flags')	
  	BEGIN																										
  		SET @sqlString = 'sp_rename ''' + 'UMRoles' + '.' + 'roleFlags' + ''', ''' + 'flags' + ''', ''COLUMN''' 			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																							
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMRoles' AND xType = 'U')								
  	IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMRoles_disabled_id_idx')					
  	BEGIN																								
  	SET @sqlString = 'CREATE UNIQUE INDEX [' + 'UMRoles_disabled_id_idx' +']' + 'ON [' + 'UMRoles' +']  (' + 'disabled, id' + ')  WITH (FILLFACTOR = '	 + '90' +	')'		
  	IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME='capabilitiesBitMask')			
  	BEGIN																														
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMRoles'+ ' ADD ' +'capabilitiesBitMask'+ ' ' +'bigint'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'UMRoles' AND COLUMN_NAME='permissionsString')			
  	BEGIN																														
  		SET @macroValue=''''			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'UMRoles'+ ' ADD ' +'permissionsString'+ ' ' +'varchar(512)'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMRoles')			
  			insert into GXDBVersions VALUES(1, 'UMRoles', '0.0', 'UMRoles', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'UMRoles'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMRoles' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMRoles' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!

END

GO
IF @@error <> 0 RETURN
GO
