

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMOperators.upg] ---------- 

--$Id: UMOperators.upg,v 1.1.2.1 2019/05/02 09:01:17 abilbrey Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON				-- Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMOperators')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMOperators')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMOperators'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMOperators' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMOperators' +'].'							
  END					-- Get @oldRev, compare to '1.2'. Chk for work to do.


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMOperators]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMOperators.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

--

-- -----------------------------------------------------------------------------

--           Table name: UMOperators

--           Description: This table contains operators and their roles

--						  for each company.

--                        Roles on this table will ultimately be applied

--						  on the hidden impersonated company user when he

--						  switches to the company.

--						  Not adding this into Security table as we need to

--						  differentiate between classic and operator associations

--						  and the switcher functionality is only for operators.

--			 Authors: jswaminathan

-- -----------------------------------------------------------------------------

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMOperators.tbl,v $ $Id: UMOperators.tbl,v 1.1.2.1 2019/05/02 09:01:11 abilbrey Exp $";

print '... Creating Table: UMOperators'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMOperators (

	id INT NOT NULL IDENTITY (1,1),	-- primary key for this table.

	companyId INT	NOT NULL,	-- company Id.

	isUser INT	NOT NULL,	-- specifies whether user or group. (Same as Security associations table)

	userOrGroupId INT	NOT NULL,	-- contains user / group Id. (Same as Security associations table)

	roleId INT	NOT NULL,	-- explicit role Id selected in UI for this operator.

	flags INT	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMOperators]''

END

--------





CREATE UNIQUE NONCLUSTERED INDEX UMOperators_companyId_isUser_userOrGroupId_roleId ON UMOperators (companyId, isUser, userOrGroupId, roleId)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMOperators]''

END

----------



CREATE NONCLUSTERED INDEX UMOperators_isUser_userOrGroupId_Idx ON UMOperators(isUser, userOrGroupId) INCLUDE (companyId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMOperators]''

END

----------





insert into GXDBVersions values(1, ''UMOperators'',  ''1.1.2.1'', ''UMOperators'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMOperators ADD CONSTRAINT UMOperators_id_PK 		primary key (id);



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMOperators]''

END

----------

ALTER TABLE UMOperators  ADD CONSTRAINT UMOperators_companyId_FK	FOREIGN KEY (companyId)references	 UMDSProviders (id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMOperators]''

END

----------

ALTER TABLE UMOperators  ADD CONSTRAINT UMOperators_roleId_FK	FOREIGN KEY (roleId)references	 UMRoles (id) ON DELETE CASCADE



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMOperators]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMOperators')			
  			insert into GXDBVersions VALUES(1, 'UMOperators', '0.0', 'UMOperators', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'UMOperators'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMOperators' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMOperators' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!					-- GET HERE, OLD REVISION IS UNKNOWN TO UPGRADE!

END

GO
IF @@error <> 0 RETURN
GO
