

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/UMDM2EntityCapability.upg] ---------- 

--$Id: UMDM2EntityCapability.upg,v 1.3.66.2 2019/03/27 01:00:47 ksundaram Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON-- Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'UMDM2EntityCapability')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'UMDM2EntityCapability')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'UMDM2EntityCapability'							
  END																			
  IF (@oldRev = '1.3')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'UMDM2EntityCapability' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'UMDM2EntityCapability' +'].'							
  END-- Get @oldRev, compare to '1.3'. Chk for work to do.


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[UMDM2EntityCapability]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/UMDM2EntityCapability.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--

--

--      Revisions  Author   Description

--      ---------  -------  ---------------------------------------------

--

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/UMDM2EntityCapability.tbl,v $ $Id: UMDM2EntityCapability.tbl,v 1.2.278.2 2019/03/27 01:00:50 ksundaram Exp $";

print '... Creating Table: UMDM2EntityCapability'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table UMDM2EntityCapability (

	id					INTEGER NOT NULL IDENTITY (1,1),

	entityType		   integer NOT NULL,

	capabilityId    bigint NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [UMDM2EntityCapability]''

END

--------





CREATE UNIQUE NONCLUSTERED INDEX UMDM2EntityCapability_entityType_capabilityId_idx ON UMDM2EntityCapability	(entityType, capabilityId)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [UMDM2EntityCapability]''

END

----------





insert into GXDBVersions values(1, ''UMDM2EntityCapability'',  ''1.2.278.2'', ''UMDM2EntityCapability'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE UMDM2EntityCapability ADD CONSTRAINT UMDM2EntityCapability_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [UMDM2EntityCapability]''

END

----------


')
END
--we have seen duplicate records in UMDM2EntityCapability table causing issue for review set functionality
--clean up such records here
	IF EXISTS (SELECT TOP 1 entityType, capabilityId FROM UMDM2EntityCapability GROUP BY entityType, capabilityId HAVING COUNT(*) > 1)

	BEGIN

		;WITH CTE

		AS 

		(

			SELECT ROW_NUMBER() OVER (PARTITION BY entityType, capabilityId ORDER BY id) as RowNum  FROM UMDM2EntityCapability

		)

		DELETE FROM CTE WHERE RowNum > 1

	END

--Add unique constraint so that duplicate records can be avoided in future for entityType
--it does not make sense to store same capability mapping more than once for given entity type
--
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'UMDM2EntityCapability' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'UMDM2EntityCapability_entityType_capabilityId_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE UNIQUE INDEX [' + 'UMDM2EntityCapability_entityType_capabilityId_idx' +']' + 'ON [' + 'UMDM2EntityCapability' +']  (' + 'entityType, capabilityId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'UMDM2EntityCapability')			
  			insert into GXDBVersions VALUES(1, 'UMDM2EntityCapability', '0.0', 'UMDM2EntityCapability', '')	
  			UPDATE GXDBVersions SET revision = '1.3' WHERE name = 'UMDM2EntityCapability'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'UMDM2EntityCapability' + '] upgraded successfully to '			+ ' revision [' + '1.3' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'UMDM2EntityCapability' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!

END

GO
IF @@error <> 0 RETURN
GO
