

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/SchedTimeZoneToRegion.upg] ---------- 

BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'SchedTimeZoneToRegion')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'SchedTimeZoneToRegion')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'SchedTimeZoneToRegion'							
  END																			
  IF (@oldRev = '1.2')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'SchedTimeZoneToRegion' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'SchedTimeZoneToRegion' +'].'							
  END		-- Get @oldRev, compare to '1.2'. Chk for work to do.


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[SchedTimeZoneToRegion]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/SchedTimeZoneToRegion.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/SchedTimeZoneToRegion.tbl,v $ $Id: SchedTimeZoneToRegion.tbl,v 1.1.2.1 2017/04/27 17:42:34 abilbrey Exp $";

-- Statically populated table from entries that can be possibly stored in the Windows TimeZone Registry mapped to regionId

-- https://technet.microsoft.com/en-us/library/cc749073(v=ws.10).aspx

-- https://msdn.microsoft.com/en-us/library/ms912391(v=winembedded.11).aspx

--

-- Other TimeZone name

-- https://en.wikipedia.org/wiki/List_of_time_zone_abbreviations

--

-- timeZoneID is populatedby mapping SchedTimeZone..TimeZoneStdName to (via join) SchedTimeZoneToRegion..tzStdName to SchedTimeZone..TimeZoneID

-- during  buildTimeZonesTable() processing.

-- http://ncvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/AppMgr/Service/AppManService.cpp#1110

--

print '... Creating Table: SchedTimeZoneToRegion'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table SchedTimeZoneToRegion (

	id					INTEGER NOT NULL IDENTITY (1,1),

	tzStdName			nvarchar(255)	NOT NULL,

	regionId			integer	NOT NULL,

	timeZoneID			integer default 0	NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [SchedTimeZoneToRegion]''

END

--------





CREATE UNIQUE CLUSTERED INDEX SchedTimeZoneToRegion_tzStdName_idx ON SchedTimeZoneToRegion (tzStdName) WITH (FILLFACTOR=95)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [SchedTimeZoneToRegion]''

END

----------



CREATE NONCLUSTERED INDEX SchedTimeZoneToRegion_regionId_timeZoneID_idx ON SchedTimeZoneToRegion (regionId, timeZoneID) WITH (FILLFACTOR=95)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [SchedTimeZoneToRegion]''

END

----------





insert into GXDBVersions values(1, ''SchedTimeZoneToRegion'',  ''1.1.2.1'', ''SchedTimeZoneToRegion'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE SchedTimeZoneToRegion ADD CONSTRAINT SchedTimeZoneToRegion_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [SchedTimeZoneToRegion]''

END

----------

ALTER TABLE SchedTimeZoneToRegion  ADD CONSTRAINT SchedTimeZoneToRegion_regionId_FK	foreign key (regionId)references	 SchedTimeZoneRegion(regionId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [SchedTimeZoneToRegion]''

END

----------


')
END
IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'SchedTimeZoneToRegion')			
  			insert into GXDBVersions VALUES(1, 'SchedTimeZoneToRegion', '0.0', 'SchedTimeZoneToRegion', '')	
  			UPDATE GXDBVersions SET revision = '1.2' WHERE name = 'SchedTimeZoneToRegion'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'SchedTimeZoneToRegion' + '] upgraded successfully to '			+ ' revision [' + '1.2' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'SchedTimeZoneToRegion' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!

END

GO
IF @@error <> 0 RETURN
GO
