

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/OraclePluggableDBs.upg] ---------- 

--$Id: OraclePluggableDBs.upg,v 1.4.52.3 2017/06/07 19:57:13 chandru Exp $
BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--Declare/Initialize @oldRev, @oldVal, @retCode
SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'OraclePluggableDBs')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'OraclePluggableDBs')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'OraclePluggableDBs'							
  END																			
  IF (@oldRev = '1.5')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'OraclePluggableDBs' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'OraclePluggableDBs' +'].'							
  END-- Get @oldRev, compare to '1.5'. Chk for work to do.


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[OraclePluggableDBs]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/OraclePluggableDBs.tbl] ---------- 





-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/OraclePluggableDBs.tbl,v $ $Id: OraclePluggableDBs.tbl,v 1.4.52.3 2017/06/07 19:57:32 chandru Exp $";

print '... Creating Table: OraclePluggableDBs'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table OraclePluggableDBs (

	pdbId               INTEGER NOT NULL IDENTITY (1,1),                     	-- serial field for unqiue key and tablespace id

	name                varchar(64),	-- Same as Job Manager jobID NOT NULL

	instId              integer	NOT NULL,	-- Instance Id to joing with AppManager Instance properties

	created             INTEGER  NOT NULL,	-- Time at which Tablespace was inserted into table

	deleteFlag          integer	NOT NULL,	-- 0 = not deleted, 1 = deleted

	deleted             INTEGER  NOT NULL,	-- Time at which Oracle PDB was deleted

	modified            INTEGER  NOT NULL,	-- last time tablespace was updated

	opType              integer	NOT NULL,	-- type of entry, for browse or for backup

	dbAttributes		xml,			    	-- Attributes of DB

	dbId				bigint					NOT NULL,	--dbId of the PDB



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [OraclePluggableDBs]''

END

--------





create index oraclePluggable_name_Idx on OraclePluggableDBs (Name)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [OraclePluggableDBs]''

END

----------



create index oraclePluggable_InstId_Idx on OraclePluggableDBs (InstId)

 

set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [OraclePluggableDBs]''

END

----------



create index oraclePluggable_DbId_Idx on OraclePluggableDBs(DbId);

 



insert into GXDBVersions values(1, ''OraclePluggableDBs'',  ''1.4.52.3'', ''OraclePluggableDBs'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE OraclePluggableDBs ADD CONSTRAINT OraclePluggableDBs_pdbId_PK 		primary key (pdbId)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [OraclePluggableDBs]''

END

----------


')
END
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OraclePluggableDBs' AND COLUMN_NAME='dbId')			
  	BEGIN																													
  		SET @sqlString = 'ALTER TABLE ' + 'OraclePluggableDBs'+ '  ADD ' +'dbId'+ '  ' +'bigint'			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'UPDATE ' + 'OraclePluggableDBs'+ '  SET ' +'dbId' + '  = ' + @macroValue		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = 'ALTER TABLE ' + 'OraclePluggableDBs'+ '  ALTER COLUMN ' +'dbId'+ '  ' +'bigint' + '  NOT NULL'					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OraclePluggableDBs' AND COLUMN_NAME = 'dbId' AND DATA_TYPE = 'INT')

BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OraclePluggableDBs' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'oraclePluggable_DbId_Idx')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'OraclePluggableDBs' +'].[' + 'oraclePluggable_DbId_Idx' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF(('INT'!='bigint')																
  		AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'OraclePluggableDBs'										
  								AND COLUMN_NAME='dbId' AND DATA_TYPE='INT'))			
  	BEGIN																														
  		SELECT	@IsNullableAttr = (CASE WHEN IS_NULLABLE = 'NO' THEN ' NOT NULL ' ELSE ' NULL ' END),							
  				@DefaultValAttr = (CASE WHEN COLUMN_DEFAULT IS NULL THEN '' ELSE COLUMN_DEFAULT END)				
  		FROM INFORMATION_SCHEMA.COLUMNS																							
  		WHERE TABLE_NAME = 'OraclePluggableDBs' AND COLUMN_NAME='dbId' AND DATA_TYPE='INT'		
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OraclePluggableDBs' AND xType = 'U')								
  			SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME='dbId')			
  			SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  						WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  			IF (@constId IS NOT NULL)																			
  			BEGIN																								
  				  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  				  SET  @sqlString = 'ALTER TABLE [' + 'OraclePluggableDBs' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  				  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  			END																									
  		END																										
  		SET @sqlString = 'ALTER TABLE ' + 'OraclePluggableDBs'+ ' ALTER COLUMN ' +'dbId'+ ' ' +'bigint'		
  		+ ' ' + @IsNullableAttr 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		IF (LEN(@DefaultValAttr) > 0)																		
  		BEGIN																								
  			SET @sqlString = 'ALTER TABLE ' + 'OraclePluggableDBs' + ' ADD CONSTRAINT ' + @cName  + ' DEFAULT ' + @DefaultValAttr+ ' FOR ' +'dbId'		
  			IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  		END																									
  	END

END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'OraclePluggableDBs' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'oraclePluggable_DbId_Idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'oraclePluggable_DbId_Idx' +']' + 'ON [' + 'OraclePluggableDBs' +']  (' + 'dbId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'OraclePluggableDBs')			
  			insert into GXDBVersions VALUES(1, 'OraclePluggableDBs', '0.0', 'OraclePluggableDBs', '')	
  			UPDATE GXDBVersions SET revision = '1.5' WHERE name = 'OraclePluggableDBs'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'OraclePluggableDBs' + '] upgraded successfully to '			+ ' revision [' + '1.5' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'OraclePluggableDBs' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return

END

GO
IF @@error <> 0 RETURN
GO
