

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/MMConfigs.upg] ---------- 

--$Id: MMConfigs.upg,v 1.18.68.1 2019/06/18 16:47:18 chandru Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'MMConfigs')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'MMConfigs')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'MMConfigs'							
  END																			
  IF (@oldRev = '1.53')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'MMConfigs' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'MMConfigs' +'].'							
  END--	 Get @oldRev, compare to '1.53'. Chk for work to do.

	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS WHERE CONSTRAINT_NAME = 'MMConfigs_Chk_ValueInRange')

	BEGIN

--Let's fix the config params that we already know to violate the constraint
		IF EXISTS(SELECT 1 FROM MMConfigs WHERE (value NOT BETWEEN nMin AND nMax) OR (nMin = nMax))

		BEGIN

			/*

			Following nMin or nMax values were modified at some point in original insert script, but the upgraded setups never got this column modified.

			I'm checking for nMin > instead of nMin != (or nMax < instead of nMax != ) because it is safer to increase the range. 

			If for any unknown reason the existing nMin was already much lower, or nMax was already much higher, I do not want to decrease the range now and potentially risk making an existing value as out of range.

			*/

UPDATE MMConfigs SET nMin = 1

WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_ARCH_TABLE_PRUNING_LOGS' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'DA_CONFIG_DAYS_TO_KEEP_CN_JOBDATACOSTHISTORY' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'DA_CONFIG_NUMBER_OF_DAYS_OF_DATA_TO_KEEP_GENERIC_HISTORY' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMCONFIG_CONTENT_INDEXING_PRUN_DAYS' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMCONFIG_DASHCOPY_JOB_CHUNK_INFO_HISTORY_PRUN_DAYS' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMS2_CONFIG_STRING_MOUNT_HISTORY_PRUN_DAYS' AND nMin > 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMS2_TAPE_STATE_HISTORY_RETENTION_DAYS' AND nMin > 1

UPDATE MMConfigs SET nMax = 2147483647

WHERE name = 'MMS2_CONFIG_SNAP_CHECK_DANGLING_AFC_LAST_RUN_TIME' AND nMax < 2147483647

UPDATE MMConfigs SET nMax = 50

WHERE name = 'MMS2_CONFIG_STRING_AUXCOPY_MAX_CHUNKS_PER_COPY_REQ' AND nMax < 50

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMS2_CONFIG_STRING_INITIAL_THREAD_COUNT' AND nMin > 1

UPDATE MMConfigs SET nMax = 1

WHERE name = 'MMS2_CONFIG_STRING_SKIP_CHUNKS' AND nMax < 1

UPDATE MMConfigs SET nMin = 1

WHERE name = 'MMS2_CONFIG_STRING_VAULTTRACKER_ALERTS_INTERVAL_MIN' AND nMin > 1

UPDATE MMConfigs SET nMax = 60

WHERE name = 'MMS2_CONFIG_STRING_VAULTTRACKER_ALERTS_INTERVAL_MIN' AND nMax < 60

UPDATE MMConfigs SET nMax = 1

WHERE name = 'MMCONFIG_SELECTIVE_COPY_MODIFY_PERIOD' AND nMax < 1

UPDATE MMConfigs SET nMin = 0

WHERE name = 'MMCONFIG_SHOW_ALL_OS_MEDIA_AGENTS' AND nMin > 0

UPDATE MMConfigs SET nMin = 0

WHERE name = 'MMCONFIG_INFINI_STORE_NUMBER_OF_SUBCLIENTS' AND nMin > 0

			/*These are not in use any more. Let's get rid of these*/

			DELETE MMConfigs WHERE name IN ('MMCONFIG_AVG_QI_TIME_LIMIT_TO_STOP_JOBS_PERCENT', 'MMS2_CONFIG_STRING_AUXCOPY_LOW_WATERMARK_FOR_REQESTING_MORE_CHUNKS')			

		END

ALTER TABLE MMConfigs WITH NOCHECK ADD CONSTRAINT MMConfigs_Chk_ValueInRange CHECK (Value BETWEEN nMin AND nMax)--BETWEEN is 'inclusive' if you are wondering
	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'MMConfigs')			
  			insert into GXDBVersions VALUES(1, 'MMConfigs', '0.0', 'MMConfigs', '')	
  			UPDATE GXDBVersions SET revision = '1.53' WHERE name = 'MMConfigs'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'MMConfigs' + '] upgraded successfully to '			+ ' revision [' + '1.53' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'MMConfigs' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return

END

GO
IF @@error <> 0 RETURN
GO
