

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/JMJobDataStats.upg] ---------- 

--$Id: JMJobDataStats.upg,v 1.38.2.11 2020/12/14 22:13:55 abilbrey Exp $
BEGIN--Need a Batch to return out of for concatenated scripts
DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @oldDataType         nvarchar(64)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	DECLARE @ct_msg			VARCHAR(1024) = ''	
  	DECLARE @ct_tcMsg		VARCHAR(1024) = ''	
  	DECLARE @nl				VARCHAR(3) = CHAR(13) + CHAR(10)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON--   Declare/Initialize @oldRev, @oldVal, @retCode

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'JMJobDataStats')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'JMJobDataStats')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'JMJobDataStats'							
  END																			
  IF (@oldRev = '1.54')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'JMJobDataStats' +'] does NOT require upgrade.'	
  	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'JMJobDataStats' +'].'							
  END--	 Get @oldRev, compare to '1.54'. Chk for work to do.

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME = 'agedby' AND DATA_TYPE = 'INT')

	BEGIN																														

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'agedBy')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'JMJobDataStats' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END

SET @oldDataType='INT'	
  	IF(@oldDataType LIKE '%char%')				
  	BEGIN										
  		IF(@oldDataType LIKE '%(%)%')			
  		BEGIN									
  			SET @oldDataType = SUBSTRING(@oldDataType, 0, CHARINDEX('(', @oldDataType, 0))	
  		END										
  	END			
  	IF (@oldDataType!='BIGINT')																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='agedby' AND DATA_TYPE = @oldDataType)			
  	BEGIN																														
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ ' ALTER COLUMN ' +'agedby'+ ' ' +'BIGINT'		
  		+ ' NOT NULL '																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

	END

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME = 'RCPolicyId')			
  		AND NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME = 'flags')	
  	BEGIN																										
  		SET @sqlString = 'sp_rename ''' + 'JMJobDataStats' + '.' + 'RCPolicyId' + ''', ''' + 'flags' + ''', ''COLUMN''' 			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	BEGIN TRY								
  	EXEC sp_executesql @sqlString			
  	END TRY									
  	BEGIN CATCH 							
  		SET @sqlError = @@error					
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'			
  		;THROW 								
      END CATCH																							
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='flags')			
  	BEGIN																													
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ '  ADD ' +'flags'+ '  ' +'INTEGER'			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'UPDATE ' + 'JMJobDataStats'+ '  SET ' +'flags' + '  = ' + @macroValue		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ '  ALTER COLUMN ' +'flags'+ '  ' +'INTEGER' + '  NOT NULL'					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END

--Previous releases can have default constraint as they are created with loose sql scripts.
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'flags')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'JMJobDataStats' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_idx6')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'JMJobDataStats_idx6' +']' + 'ON [' + 'JMJobDataStats' +']  (' + 'copiedTime' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SET @oldDataType='int'	
  	IF(@oldDataType LIKE '%char%')				
  	BEGIN										
  		IF(@oldDataType LIKE '%(%)%')			
  		BEGIN									
  			SET @oldDataType = SUBSTRING(@oldDataType, 0, CHARINDEX('(', @oldDataType, 0))	
  		END										
  	END			
  	IF (@oldDataType!='bigint')																
  			AND EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='manualRetentionEndTime' AND DATA_TYPE = @oldDataType)			
  	BEGIN																														
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ ' ALTER COLUMN ' +'manualRetentionEndTime'+ ' ' +'bigint'		
  		+ ' NOT NULL '																											
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

--Dropping default constraint added in upgrade code from 9.0
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
  	SELECT @colID    = (SELECT colid FROM syscolumns WHERE id = @parentID AND NAME = 'sizeOnMedia')			
  	SELECT @constId  = (SELECT a.constid FROM sysconstraints a, sysobjects b							
  				WHERE a.id = @parentID AND a.colid = @colid and a.constid = b.id and b.xtype = 'D')		
  	IF (@constId IS NOT NULL)																			
  	BEGIN																								
  		  SELECT @cName    = (SELECT name FROM sysobjects WHERE id=@constId)							
  		  SET  @sqlString = 'ALTER TABLE [' + 'JMJobDataStats' +']' +'DROP CONSTRAINT [' + @cName + ']'		
  		  IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																				
  	END

--changed index for SCG SQL Function, dbo.scgV2ClientHasPinnedJob, performance for parrallel scaling issue
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_idx2')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'JMJobDataStats' +'].[' + 'JMJobDataStats_idx2' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_appId_disabled_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'JMJobDataStats_appId_disabled_idx' +']' + 'ON [' + 'JMJobDataStats' +']  (' + 'appId, disabled' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

--Improve Performance of RptOneDaySLA SP (used for SLA reports)
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_archGrpCopyId_opType_copiedTime_idx')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'JMJobDataStats_archGrpCopyId_opType_copiedTime_idx' +']' + 'ON [' + 'JMJobDataStats' +']  (' + 'archGrpCopyId, opType, copiedTime' + ') INCLUDE ('+ 'jobId, status, commCellId' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

--Improve Performance of MMGetDDbEngineDetails.sp
SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_idx3')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'JMJobDataStats' +'].[' + 'JMJobDataStats_idx3' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='jobSelectionTime')			
  	BEGIN																													
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ '  ADD ' +'jobSelectionTime'+ '  ' +'bigint'			
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @macroValue='0'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'UPDATE ' + 'JMJobDataStats'+ '  SET ' +'jobSelectionTime' + '  = ' + @macroValue		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ '  ALTER COLUMN ' +'jobSelectionTime'+ '  ' +'bigint' + '  NOT NULL'					
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																			
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME = 'auxCopyStatus')

BEGIN

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='auxCopyStatus')			
  	BEGIN																														
  		SET @macroValue='-1'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ ' ADD ' +'auxCopyStatus'+ ' ' +'smallint'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'JMJobDataStats' AND COLUMN_NAME='unCompSize')			
  	BEGIN																														
  		SET @macroValue='-1'			
  	IF(@macroValue <> '')			
  	BEGIN			
  		IF(ISNUMERIC(@macroValue) = 1)			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = 'NULL')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue LIKE '{%}')			
  		BEGIN			
  			SET @macroValue = SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2)			
  		END			
  		ELSE IF(@macroValue LIKE '"%"')			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(SUBSTRING(@macroValue, 2, LEN(@macroValue) - 2), '''', '''''') + ''''			
  		END			
  		ELSE IF(@macroValue LIKE '0x%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE IF(@macroValue = '''')		
  		BEGIN			
  			SET @macroValue = ''''''			
  		END			
  		ELSE IF(@macroValue LIKE '%(%)%')			
  		BEGIN			
  			SET @macroValue = @macroValue			
  		END			
  		ELSE			
  		BEGIN			
  			SET @macroValue = '''' + REPLACE(@macroValue, '''', '''''') + ''''			
  		END			
  	END			
  	ELSE			
  	BEGIN			
  		SET @macroValue = ''''''			
  	END		
  		SET @sqlString = 'ALTER TABLE ' + 'JMJobDataStats'+ ' ADD ' +'unCompSize'+ ' ' +'bigint'		
  			+ ' NOT NULL DEFAULT ' + @macroValue																	
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

	DECLARE @rowsFetched  int = 0                                                                                                                                                                                                                    

	DECLARE @rowOffset    int = 0                                                                                                                                                                                                                                    

	DECLARE @rowsInBatch  int = 20000     

	IF (OBJECT_ID('tempdb..#tempJMJobDataStats') IS NOT NULL) 		DROP TABLE #tempJMJobDataStats	

	CREATE TABLE #tempJMJobDataStats (

		jobId			integer,

		commCellId		smallint,

		archGrpCopyId	smallint,

		dataType		tinyint,

		primary key (jobId,archGrpCopyId,dataType,commCellId)

		)

	WHILE 1=1                                                                                                                                                                                                                                           

	BEGIN                                                                                                                                                                                     

		DELETE FROM #tempJMJobDataStats

		INSERT	INTO #tempJMJobDataStats

		SELECT	JDS.JobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType

		FROM	JMJobDataStats JDS

		ORDER BY	JDS.JobId, JDS.commCellId, JDS.archGrpCopyId, JDS.dataType OFFSET @rowOffset ROWS FETCH NEXT @rowsInBatch ROWS ONLY;

		SELECT @rowsFetched = @@ROWCOUNT;

		SET @sqlString = 'UPDATE	JDS

						SET		unCompSize = T.unCompSize,

								auxCopyStatus = (CASE WHEN JDS.Status != 1000 THEN JDS.Status ELSE -1 END)

						FROM	JMJobDataStats JDS,

								(SELECT	JDSI.JobId, JDSI.commCellId, JDSI.archGrpCopyId, JDSI.dataType, (CASE WHEN MIN(AFC.unCompSize) = -1 THEN -1 ELSE SUM(AFC.unCompSize) END) unCompSize

								FROM	' +	'#tempJMJobDataStats' + ' JDSI, archFile AF, archFileCopy AFC

								WHERE	JDSI.JobId = AF.JobId

										AND JDSI.CommCellId = AF.CommCellId

										AND JDSI.dataType = AF.fileType

										AND AF.id = AFC.archFileId

										AND AF.commCellId = AFC.commCellId

										AND JDSI.archGrpCopyId = AFC.archCopyId

								GROUP BY JDSI.JobId, JDSI.commCellId, JDSI.archGrpCopyId, JDSI.dataType) T

						WHERE	JDS.JobId = T.JobId

								AND JDS.commCellId = T.commCellId

								AND JDS.archGrpCopyId = T.archGrpCopyId

								AND JDS.dataType = T.dataType'

IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END

        SELECT @rowOffset = @rowOffset + @rowsFetched                                                                                                                                      

        IF @rowsFetched = 0                                                                                                                                                                                                     

            BREAK                                                                                                                                                                 

	END

	IF (OBJECT_ID('tempdb..#tempJMJobDataStats') IS NOT NULL) 		DROP TABLE #tempJMJobDataStats	

END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')				
      IF EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_archGrpCopyId_status_Idx')						
      BEGIN																								
  		SET @sqlString = 'DROP INDEX [' + 'JMJobDataStats' +'].[' + 'JMJobDataStats_archGrpCopyId_status_Idx' +']'							
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
      IF NOT EXISTS (SELECT * FROM sysindexes WHERE id = @parentID AND name = 'JMJobDataStats_archGrpCopyId_status_Idx2')					
      BEGIN																								
  		SET @sqlString = 'CREATE INDEX [' + 'JMJobDataStats_archGrpCopyId_status_Idx2' +']' + 'ON [' + 'JMJobDataStats' +']  (' + 'archGrpCopyId, status' + ') INCLUDE ('+ 'archGrpId,disabled,appId,jobId,commCellId,dataType,archCheckStatus,sizeOnMedia' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

--need to check existence of primary key JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK') AND type in (N'PK'))

BEGIN

SELECT @parentID = (SELECT id FROM sysobjects WHERE name = 'JMJobDataStats' AND xType = 'U')								
  	SELECT @keyname = (SELECT  name FROM sysobjects WHERE parent_obj = @parentID AND xtype = 'PK')		
  	IF(@keyname IS NULL OR @keyname != 'JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK')														
  	BEGIN																								
  		IF(@keyname IS NOT NULL)																		
  		BEGIN																							
  			EXECUTE @retCode = cvsp_drop_pk 'JMJobDataStats'													
  		END																								
  		SET @sqlString = 'ALTER TABLE [' + 'JMJobDataStats' + ']' + 'ADD CONSTRAINT [' + 'JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK' + '] PRIMARY KEY (' + 'jobId,archGrpCopyId,dataType,commCellId' + ') WITH (FILLFACTOR = ' + '90' + ')'		
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																					
  	END

END

ELSE

BEGIN

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '90'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_jobId_archGrpCopyId_dataType_commCellId_PK' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '90' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_appId_disabled_idx'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '85'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_appId_disabled_idx' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '85' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_idx4'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '90'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_idx4' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '90' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_idx5'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '95'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_idx5' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '95' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_idx6'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '95'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_idx6' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '95' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_archGrpCopyId_opType_copiedTime_idx'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '95'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_archGrpCopyId_opType_copiedTime_idx' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '95' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF EXISTS(												
  		SELECT 1												
  		FROM sys.sysindexes i WITH(NOLOCK)						
  			INNER JOIN sys.sysobjects o WITH(NOLOCK) ON			
  				i.id = o.id AND o.xtype = 'U'					
  		WHERE													
  			i.name = 'JMJobDataStats_archGrpCopyId_status_Idx2'									
  			AND o.name = 'JMJobDataStats'							
  			AND i.OrigFillFactor <> '90'				
  	)															
  	BEGIN														
  		SET @sqlString = 'ALTER INDEX [' + 'JMJobDataStats_archGrpCopyId_status_Idx2' + ']' + 'ON [' + 'JMJobDataStats' + ']  REBUILD WITH (ONLINE = OFF, FILLFACTOR  = ' + '90' + ')'	     
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END											
  	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'JMJobDataStats')			
  			insert into GXDBVersions VALUES(1, 'JMJobDataStats', '0.0', 'JMJobDataStats', '')	
  			UPDATE GXDBVersions SET revision = '1.54' WHERE name = 'JMJobDataStats'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'JMJobDataStats' + '] upgraded successfully to '			+ ' revision [' + '1.54' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'JMJobDataStats' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!-- Update cvTable & return

END

GO
IF @@error <> 0 RETURN
GO
