

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/DBMaintenanceCreateTempdbGrowthTables.upg] ---------- 

--*/
--This script will called by DBMaintenance (@DBMaintMode = 1) to create the tables
--required for tempdb growth detection logging.
--This script will also be called by DBUpgrade/InstallUpdates (@DBMaintMode = 0) to recreate tables
--with schema changes. Otherwise DB updates for proc CV_LogTempDBSizeAndQueries (that
--refer to these schema changes) will not execute.
--11/22/2019: All of the logic in this script will be inside a TRY/CATCH,
--so that databaseupgrade doesnt fail due to any errors in the script.
BEGIN TRY

DECLARE @DBMaintMode INT = 0

--Caller is expected to create this before firing this script.
IF OBJECT_ID('tempdb.dbo.#DBMaintModeSwitch') IS NOT NULL

	SET @DBMaintMode = 1

IF NOT EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'troubleshooting') AND @DBMaintMode = 1

	CREATE DATABASE [troubleshooting] 

IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'troubleshooting')

	ALTER DATABASE [troubleshooting] SET RECOVERY SIMPLE

IF OBJECT_ID('troubleshooting..tempdbgrowth_queries') IS null AND @DBMaintMode = 1

BEGIN

	EXEC ('CREATE TABLE [troubleshooting].[dbo].[tempdbgrowth_queries](

			[queryid] [int] IDENTITY(1,1) NOT NULL,

			[querytext] [nvarchar](max) NULL

	) ON [PRIMARY]')

END

IF OBJECT_ID('troubleshooting..tempdbgrowth_query_details') IS null AND @DBMaintMode = 1

BEGIN

	EXEC ('CREATE TABLE [troubleshooting].[dbo].[tempdbgrowth_query_details](

			[queryid] [int] NULL,

			[sql_handle] [varbinary](64) NOT NULL,

			[statement_start_offset] [int] NOT NULL,

			[statement_end_offset] [int] NOT NULL,

			[plan_generation_num] [bigint] NOT NULL,

			[plan_handle] [varbinary](64) NOT NULL,

			[creation_time] [datetime] NOT NULL,

			[last_execution_time] [datetime] NOT NULL,

			[execution_count] [bigint] NOT NULL,

			[total_worker_time] [bigint] NOT NULL,

			[last_worker_time] [bigint] NOT NULL,

			[min_worker_time] [bigint] NOT NULL,

			[max_worker_time] [bigint] NOT NULL,

			[total_physical_reads] [bigint] NOT NULL,

			[last_physical_reads] [bigint] NOT NULL,

			[min_physical_reads] [bigint] NOT NULL,

			[max_physical_reads] [bigint] NOT NULL,

			[total_logical_writes] [bigint] NOT NULL,

			[last_logical_writes] [bigint] NOT NULL,

			[min_logical_writes] [bigint] NOT NULL,

			[max_logical_writes] [bigint] NOT NULL,

			[total_logical_reads] [bigint] NOT NULL,

			[last_logical_reads] [bigint] NOT NULL,

			[min_logical_reads] [bigint] NOT NULL,

			[max_logical_reads] [bigint] NOT NULL,

			[total_clr_time] [bigint] NOT NULL,

			[last_clr_time] [bigint] NOT NULL,

			[min_clr_time] [bigint] NOT NULL,

			[max_clr_time] [bigint] NOT NULL,

			[total_elapsed_time] [bigint] NOT NULL,

			[last_elapsed_time] [bigint] NOT NULL,

			[min_elapsed_time] [bigint] NOT NULL,

			[max_elapsed_time] [bigint] NOT NULL,

			[query_hash] [binary](8) NOT NULL,

			[query_plan_hash] [binary](8) NOT NULL,

			[query_plan] [nvarchar](max) NULL

	) ON [PRIMARY]')

END

--Table schema change. Drop table and recreate if these columns aren't there.
--If the table exists but doesn't have the latest columns, drop the table.
--Create the table if you just dropped the table or if you are in DBMaint mode.
DECLARE @RecreateTable INT = 0

IF OBJECT_ID('troubleshooting..tempdbgrowth') IS NOT NULL AND

	NOT EXISTS (select * from sys.columns

	where object_id = object_id('tempdbgrowth')

	and name in ('user_page_alloc_count', 'internal_page_alloc_count', 'second_highest_tempdb_usage', 'max_physical_io'))

BEGIN

	EXEC ('DROP TABLE [troubleshooting].[dbo].[tempdbgrowth]')

	SET @RecreateTable = 1

END

IF @RecreateTable = 1 OR (OBJECT_ID('troubleshooting..tempdbgrowth') IS null AND @DBMaintMode = 1)

BEGIN

	EXEC ('CREATE TABLE [troubleshooting].[dbo].[tempdbgrowth](

			[Growtime] [datetime] NULL,

			[queryId] [int] NULL,

			[curDBSize] [float] NULL,

			[programName] [varchar](128) NULL,

			[hostprocess] [varchar](10) NULL,

			[threadid] [int] NULL,

			[last_batch] [datetime] NULL,

			[user_page_alloc_count] [int] NULL,

			[internal_page_alloc_count] [int] NULL,

			[physical_io] [int] NULL,

			[cpu] [int] NULL,

			[dbccinputbuffer] [nvarchar](max) NULL,

			[stmt_start] [int] NULL,

			[stmt_end] [int] NULL,

			[second_highest_tempdb_usage] [int] NULL,

			[max_physical_io] [int] NULL

	) ON [PRIMARY]')

END

IF OBJECT_ID('troubleshooting..tempDBSize') IS null AND @DBMaintMode = 1 

BEGIN

	EXEC ('CREATE TABLE [troubleshooting].[dbo].[tempDBSize](

			[growtime] [datetime] NULL,

			[DBsize] [float] NULL

	) ON [PRIMARY]')

END

IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'troubleshooting')

BEGIN

	EXEC('USE troubleshooting

	DBCC SHRINKFILE (troubleshooting_Log, 1)')

END

END TRY

BEGIN CATCH

--CATCH_HANDLING_MACRO seems to have some issue in .upg
--DB_SQL keeps throwing WARNING!!! CATCH_HANDLING_MACRO found outside Catch Block
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

	ERROR MESSAGE: ' + ERROR_MESSAGE() + '

	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

END CATCH

GO
IF @@error <> 0 RETURN
GO
