

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/ConvertPKeyToUniqIdx.upg] ---------- 

--USE commserv
SET QUOTED_IDENTIFIER OFF
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'GetPrimaryConstraints')

    DROP PROCEDURE GetPrimaryConstraints 

	GO

CREATE PROCEDURE GetPrimaryConstraints (@ObjName varchar(128), @OutTableName varchar(64) = NULL)

AS

BEGIN

--DECLARE @ObjName	varchar(128)
--DECLARE @OutTableName	varchar(64)
	DECLARE @Debug		INTEGER

	SET NOCOUNT ON

	SET @Debug = 0

DECLARE 	@ObjID			int--the object ID of the table
,@CnstDes		nvarchar(4000)--string to build up index desc
,@CnstName		sysname--name of const. currently under consideration
			,@Count			int

			,@CnstID		int

			,@CnstType		character(2)

,@Keys			nvarchar(2126)--LENgth (16*max_identifierLENgth)+(15*2)+(16*3)
--Check to see IF the tabe exists AND initialize @ObjID.
	SELECT @ObjID = object_id(@ObjName)

	IF @ObjID IS NULL

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		RETURN -1

	END

	IF OBJECT_ID('tempdb.dbo.#TableConstraints') IS NOT NULL DROP TABLE #TableConstraints

--Create temp table
	CREATE TABLE #TableConstraints

	(

		TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
		,ConstraintType		INTEGER

		,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
	)

	IF (@Debug = 1)

	BEGIN

		IF OBJECT_ID('tempdb.dbo.#TableConstraintsOut') IS NOT NULL DROP TABLE #TableConstraintsOut

--Create temp table
		CREATE TABLE #TableConstraintsOut

		(

			TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
			,ConstraintType		INTEGER

			,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
		)

		SET @ObjName	= 'QSMAgent'

		SET @OutTableName = '#TableConstraintsOut'

	END

--STATIC CURSOR OVER THE TABLE'S CONSTRAINTS
	DECLARE ConstraintCursor CURSOR 

	LOCAL STATIC FOR

	SELECT id, xtype, name 

	FROM sysobjects 

	WHERE parent_obj = @ObjID

		AND xtype IN ('PK', 'UQ', 'D ')	-- ONLY 6.5 sysconstraints objects

	FOR READ ONLY

--Now check out each constraint, figure out its type AND keys and
--save the info IN a temporary table that we'll PRINT out at the END.
	OPEN ConstraintCursor

	FETCH ConstraintCursor INTO @CnstID, @CnstType, @CnstName

	WHILE @@FETCH_STATUS >= 0

	BEGIN

		IF @CnstType IN ('PK','UQ')

		BEGIN

--get IndID AND index description
			DECLARE @IdxID smallint

			SELECT	@IdxID = IndID,

					@CnstDes = CASE WHEN @CnstType = 'PK'

								THEN 'PRIMARY KEY' ELSE 'UNIQUE' END

							 + CASE WHEN (status & 16)=16

								THEN ' (clustered)' ELSE ' (non-clustered)' END

			FROM	sysindexes

			WHERE	name = Object_Name(@CnstID)

					AND ID = @ObjID

--FORmat keys string
DECLARE @ThisKey nvarchar(131)--128+3
			SELECT @Keys = Index_Col(@ObjName, @IdxID, 1), @Count = 2

			IF (IndexKey_Property(@ObjID, @IdxID, 1, 'isdescending') = 1)

				SELECT @Keys = @Keys  + '(-)'

			SELECT @ThisKey = Index_Col(@ObjName, @IdxID, @Count)

			IF ((@ThisKey IS NOT NULL) AND (IndexKey_Property(@ObjID, @IdxID, @Count, 'isdescending') = 1))

				SELECT @ThisKey = @ThisKey + '(-)'

			WHILE (@ThisKey IS NOT NULL)

			BEGIN

				SELECT @Keys = @Keys + ', ' + @ThisKey, @Count = @Count + 1

				SELECT @ThisKey = Index_Col(@ObjName, @IdxID, @Count)

				IF ((@ThisKey IS NOT NULL) AND (IndexKey_Property(@ObjID, @IdxID, @Count, 'isdescending') = 1))

					SELECT @ThisKey = @ThisKey + '(-)'

			END

--ADD TO TABLE
			INSERT INTO #TableConstraints

				(TableName, ConstraintTypeName, ConstraintName, ConstraintString, ConstraintType)

			values (@ObjName, @CnstDes, @CnstName, @Keys, CASE WHEN @CnstType = 'PK' THEN 1 WHEN @CnstType = 'UQ' THEN 2 ELSE 0 END)

		END

		ELSE

		IF (@CnstType = 'D ')

		BEGIN

			SELECT @Count = 1

			SELECT @CnstDes = TEXT FROM syscomments WHERE ID = @CnstID AND colID = @Count

			WHILE @CnstDes IS NOT NULL

			BEGIN

				IF @Count=1

					INSERT INTO	#TableConstraints

						(TableName, ConstraintTypeName, ConstraintName ,ConstraintString, ConstraintType)

					SELECT @ObjName, 'DEFAULT on column ' + col_name(@ObjID ,info),

						@CnstName ,SUBSTRING(@CnstDes,1,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

					FROM sysobjects WHERE ID = @CnstID

				ELSE

					INSERT INTO #TableConstraints (TableName, ConstraintTypeName, ConstraintName,ConstraintString, ConstraintType)

					SELECT	@ObjName, ' ', @CnstName, SUBSTRING(@CnstDes,1,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

				IF LEN(@CnstDes) > 2000

					INSERT INTO #TableConstraints (TableName, ConstraintTypeName, ConstraintName,ConstraintString, ConstraintType)

					SELECT	@ObjName, ' ', @CnstName, SUBSTRING(@CnstDes,2001,2000), CASE WHEN @CnstType = 'D ' THEN 3 ELSE 0 END

				SELECT @Count = @Count + 1

				SELECT @CnstDes = NULL

				SELECT @CnstDes = TEXT FROM syscomments WHERE ID = @CnstID AND colID = @Count

			END

		END

		FETCH ConstraintCursor INTO @CnstID, @CnstType, @CnstName

END--of major loop
	DEALLOCATE ConstraintCursor

	IF (@OutTableName IS NOT NULL)

	BEGIN

		EXEC (

			'INSERT INTO ' + @OutTableName + 

			' SELECT * FROM #TableConstraints'

		)

	END

	ELSE

	BEGIN

		SELECT * FROM #TableConstraints

	END

	DROP TABLE #TableConstraints

	IF (@Debug = 1)

	BEGIN

		EXEC ('SELECT * FROM ' + @OutTableName)

		EXEC ('DROP TABLE ' + @OutTableName)

	END

END

	GO

--IF OBJECT_ID('tempdb.dbo.#PrimaryConsts') IS NOT NULL DROP TABLE #PrimaryConsts
--
---- Create temp table
--CREATE TABLE #PrimaryConsts
--(
--TableName		sysname
--,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL   -- 128 FOR name + TEXT FOR DEFAULT
--,ConstraintType		INTEGER
--,ConstraintName		sysname		COLLATE Database_Default NOT NULL
--,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL	-- see @Keys above FOR LENgth descr
--)
--
--EXEC dbo.GetPrimaryConstraints 'CHJobBkpAttemptHistory', #PrimaryConsts
--
--SELECT * FROM #PrimaryConsts
--
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'GetForeignKeys')

    DROP PROCEDURE GetForeignKeys 

	GO

CREATE PROCEDURE GetForeignKeys (@ObjName varchar(128), @OutTableName varchar(64) = NULL)

AS

BEGIN

--DECLARE @ObjName	varchar(128)
--DECLARE @OutTableName	varchar(64)
	DECLARE @Debug		INTEGER

	SET NOCOUNT ON

--SET @Debug = 1
	DECLARE @PKTable	SYSNAME

	DECLARE @FKTable	SYSNAME

	DECLARE @PKColumn	SYSNAME

	DECLARE @FKColumn	SYSNAME

	DECLARE @FKeyName	VARCHAR(255)

	DECLARE @UpdRule	INTEGER

	DECLARE @DelRule	INTEGER

	DECLARE @PKeyString	VARCHAR(255)

	DECLARE @FKeyString	VARCHAR(255)

	IF (OBJECT_ID(@ObjName) IS NULL)

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		return -1

	END

	IF object_id('tempdb.dbo.#SP_FKeysOut') is not null DROP TABLE #SP_FKeysOut

	IF object_id('tempdb.dbo.#RelationShips') is not null DROP TABLE #RelationShips

	CREATE TABLE #SP_FKeysOut

	(

	    PKTABLE_QUALIFIER	varchar(255),

	    PKTABLE_OWNER	varchar(255),

	    PKTABLE_NAME	varchar(255),

	    PKCOLUMN_NAME	varchar(255),

	    FKTABLE_QUALIFIER	varchar(255),

	    FKTABLE_OWNER	varchar(255),

	    FKTABLE_NAME	varchar(255),

	    FKCOLUMN_NAME	varchar(255),

	    KEY_SEQ		int,

	    UPDATE_RULE		int,

	    DELETE_RULE		int,

	    FK_NAME		varchar(255),

	    PK_NAME		varchar(255),

	    DEFERRABILITY	varchar(255)

	)

	CREATE TABLE #RelationShips

	(

		PKTable		varchar(255),

		PKeyString	varchar(512),

		FKTable		varchar(255),

		FKeyString	varchar(512),

		FKeyName	varchar(255),

		DropFKQuery	varchar(1024),

		AddFKQuery	varchar(1024),

	)

	IF (@Debug = 1)

	BEGIN

		IF object_id('tempdb.dbo.#RelationShipsOut') is not null DROP TABLE #RelationShipsOut

		SET @ObjName		= 'CHJobBkpHistory'

		SET @OutTableName	= '#RelationshipsOut'

		CREATE TABLE #RelationShipsOut

		(

			PKTable		varchar(255),

			PKeyString	varchar(512),

			FKTable		varchar(255),

			FKeyString	varchar(512),

			FKeyName	varchar(255),

			DropFKQuery	varchar(1024),

			AddFKQuery	varchar(1024),

		)

	END

	INSERT INTO  #SP_FKeysOut

	EXEC  sp_fkeys @pktable_name=@ObjName

	DECLARE PTable CURSOR

	FOR

	SELECT DISTINCT PKTABLE_NAME, FKTABLE_NAME, FK_NAME, UPDATE_RULE, DELETE_RULE

	FROM #SP_FKeysOut

	OPEN PTable

	FETCH PTable INTO @PKTable, @FKTable, @FKeyName, @UpdRule, @DelRule

	WHILE @@FETCH_STATUS >= 0

	BEGIN

		SET @PKeyString = ''

		SET @FKeyString = ''

		DECLARE PKeys CURSOR 

		FOR

		SELECT PKCOLUMN_NAME, FKCOLUMN_NAME 

		FROM #SP_FKeysOut

		WHERE PKTABLE_NAME = @PKTable

			AND FKTABLE_NAME = @FKTable

		ORDER BY KEY_SEQ ASC

		OPEN PKeys

		FETCH PKeys INTO @PKColumn, @FKColumn

		WHILE @@FETCH_STATUS >= 0

		BEGIN

			SET @PKeyString = CASE WHEN @PKeyString = '' THEN @PKColumn ELSE @PKeyString + ', ' + @PKColumn END

			SET @FKeyString = CASE WHEN @FKeyString = '' THEN @FKColumn ELSE @FKeyString + ', ' + @FKColumn END

			FETCH PKeys INTO @PKColumn, @FKColumn

		END

		CLOSE PKeys

		DEALLOCATE PKeys

		INSERT INTO #RelationShips VALUES (@PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName,

			'ALTER TABLE ' + @FKTABLE + ' DROP ' + @FKeyName,

			'ALTER TABLE ' + @FKTABLE + ' ADD FOREIGN KEY (' + @FKeyString + ') REFERENCES ' + @PKTable + '(' + @PKeyString + ')' + CASE @UpdRule WHEN 0 THEN ' ON UPDATE CASCADE ' ELSE '' END + + CASE @DelRule WHEN 0 THEN ' ON DELETE CASCADE ' ELSE '' END

		)

		FETCH PTable INTO @PKTable, @FKTable, @FKeyName, @UpdRule, @DelRule

	END

	CLOSE PTable

	DEALLOCATE PTable

	IF (@OutTableName IS NOT NULL)

	BEGIN

		EXEC (

			'INSERT INTO ' + @OutTableName + 

			' SELECT * FROM #Relationships'

		)

	END

	ELSE

	BEGIN

		SELECT * FROM #Relationships

	END

	DROP TABLE #SP_FKeysOut

	DROP TABLE #RelationShips

	IF (@Debug = 1)

	BEGIN

		EXEC ('SELECT * FROM ' + @OutTableName)

		EXEC ('DROP TABLE ' + @OutTableName)

	END

END

	GO

--IF object_id('tempdb.dbo.#FKeys') is not null DROP TABLE #FKeys
--
--CREATE TABLE #FKeys
--(
--PKTable		varchar(255),
--PKeyString	varchar(512),
--FKTable		varchar(255),
--FKeyString	varchar(512),
--FKeyName	varchar(255),
--DropFKQuery	varchar(1024),
--AddFKQuery	varchar(1024),
--)
--
--EXEC dbo.GetForeignKeys 'QSMAgent', '#FKeys'
--
--SELECT * FROM #FKeys
--USE CommServ
IF EXISTS (SELECT * FROM sysobjects WHERE Name = 'ConvertPrimaryKeyToUniqueIndex')

    DROP PROCEDURE ConvertPrimaryKeyToUniqueIndex 

	GO

CREATE PROCEDURE ConvertPrimaryKeyToUniqueIndex(@ObjName varchar(255))

AS

BEGIN

	SET NOCOUNT ON

	IF OBJECT_ID('tempdb.dbo.#PKeys') IS NOT NULL DROP TABLE #PKeys

	IF OBJECT_ID('tempdb.dbo.#FKeys') is not null DROP TABLE #FKeys

	DECLARE	@PKTable	varchar(255)

	DECLARE	@PKeyString	varchar(512)

	DECLARE	@FKTable	varchar(255)

	DECLARE	@FKeyString	varchar(512)

	DECLARE	@FKeyName	varchar(255)

	DECLARE	@DropFKQuery	varchar(1024)

	DECLARE	@AddFKQuery	varchar(1024)

	DECLARE	@TableName		sysname

	DECLARE	@ConstraintTypeName	nvarchar(146)

	DECLARE	@ConstraintType		INTEGER

	DECLARE	@ConstraintName		sysname

	DECLARE	@ConstraintString	nvarchar(1800)

	IF (OBJECT_ID(@ObjName) IS NULL)

	BEGIN

		PRINT 'Table [' + @ObjName + '] not found in Database [' + DB_Name() + ']'

		RETURN -1

	END

--Create temp table
	CREATE TABLE #PKeys

	(

		TableName		sysname

,ConstraintTypeName	nvarchar(146)	COLLATE Database_Default NOT NULL--128 FOR name + TEXT FOR DEFAULT
		,ConstraintType		INTEGER

		,ConstraintName		sysname		COLLATE Database_Default NOT NULL

,ConstraintString	nvarchar(1800)	COLLATE Database_Default NULL--see @Keys above FOR LENgth descr
	)

	CREATE TABLE #FKeys

	(

		PKTable		varchar(255),

		PKeyString	varchar(512),

		FKTable		varchar(255),

		FKeyString	varchar(512),

		FKeyName	varchar(255),

		DropFKQuery	varchar(1024),

		AddFKQuery	varchar(1024),

	)

	EXEC GetPrimaryConstraints @ObjName, '#PKeys'

	EXEC GetForeignKeys @ObjName, '#FKeys'

	IF ((SELECT Count(*) FROM #PKeys) = 0)

	BEGIN

		PRINT 'No Primary Constraints found for [' + @ObjName + '], so no change required.'

		RETURN -2

	END

	IF ((SELECT Count(*) FROM #FKeys) = 0)

		PRINT 'No Foreign Constraints found for [' + @ObjName + ']'

	DECLARE FKeyCursor CURSOR

	FOR

	SELECT * FROM #FKeys

	OPEN FKeycursor

	FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--DROP ALL FOREIGN KEYs to this table.
--SELECT @DropFKQuery
		PRINT 'Executing [' + @DropFKQuery + ']'

		EXEC (@DropFKQuery)

		FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	END

	CLOSE FKeyCursor

--Convert Primary Key to unique non-clustered index with the same set of columns as Primary key.
	DECLARE PKeyCursor CURSOR

	FOR

	SELECT TableName, ConstraintName, ConstraintType, ConstraintString FROM #PKeys

	WHERE ConstraintType IN (1, 2, 3)

	ORDER BY ConstraintType DESC

	OPEN PKeycursor

	FETCH PKeyCursor INTO @TableName, @ConstraintName, @ConstraintType, @ConstraintString

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--DROP ALL Default & Primary Key Constraints on this table.
--SELECT 'ALTER TABLE ' + @TableName + ' DROP ' + @ConstraintName
		PRINT 'Dropping ' + CASE @ConstraintType WHEN 1 THEN 'Primary' WHEN 2 THEN 'Unique' ELSE 'Default' END + ' Constraint [' + @ConstraintName + '] [' + @ConstraintString + ']'

		EXEC ('ALTER TABLE ' + @TableName + ' DROP ' + @ConstraintName)

		IF (@ConstraintType = 1)

		BEGIN

--Recreate Primary Key as a non-clustered Unique Index.
--SELECT 'CREATE UNIQUE NONCLUSTERED INDEX ' + @TableName + '_Idx ON ' + @TableName + '(' + @ConstraintString + ')'
			PRINT 'Adding Unique NonClustered Index [' + @ConstraintString + ']'

			EXEC ('CREATE UNIQUE NONCLUSTERED INDEX ' + @TableName + '_Idx ON ' + @TableName + '(' + @ConstraintString + ')')

		END

		FETCH PKeyCursor INTO @TableName, @ConstraintName, @ConstraintType, @ConstraintString

	END

	CLOSE PKeyCursor

	DEALLOCATE PKeyCursor

--Re-Create the Foreign keys
	OPEN FKeycursor

	FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	WHILE (@@FETCH_STATUS >= 0)

	BEGIN

--CREATE ALL FOREIGN KEYs back to this table.
--SELECT @AddFKQuery
		PRINT 'Executing [' + @AddFKQuery + ']'

		EXEC (@AddFKQuery)

		FETCH FKeyCursor INTO @PKTable, @PKeyString, @FKTable, @FKeyString, @FKeyName, @DropFKQuery, @AddFKQuery

	END

	CLOSE FKeyCursor

	DEALLOCATE FKeyCursor

	DROP TABLE #PKeys

	DROP TABLE #FKeys

END

	GO

--EXEC ConvertPrimaryKeyToUniqueIndex 'Child'
--EXEC ConvertPrimaryKeyToUniqueIndex 'QSMSQLInstance'
--EXEC GetPrimaryConstraints 'QSMExchangeStorageGroup'
--EXEC GetForeignKeys 'QSMExchangeStorageGroup'
GO
IF @@error <> 0 RETURN
GO


