

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/CT_EnableCSDbChangeTracking.upg] ---------- 

BEGIN--Need a Batch to return out of for concatenated scripts


SET QUOTED_IDENTIFIER ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/CT_EnableCSDbChangeTracking.script,v $ $Id: CT_EnableCSDbChangeTracking.script,v 1.1.2.1 2018/04/11 13:17:40 abilbrey Exp $";

--**================================================================

--** NOTE file included in CT_EnableCSDbChangeTracking.upg File

--** NOTE file included in CT_EnableCSDbChangeTracking.tbl File

--**================================================================

DECLARE @now INT = DATEDIFF(SECOND, '01/01/1970', GETUTCDATE())

BEGIN TRY

	SET NOCOUNT ON

	DECLARE @sqlCmd			NVARCHAR(MAX)

	DECLARE @exitCode		INT = 0

	DECLARE @exitMsg		VARCHAR(1024) = ''

	DECLARE @msg			VARCHAR(MAX) = ''

	DECLARE @tcMsg			VARCHAR(1024) = ''

	-- Get Databases with Change Tracking ON

	DECLARE @ChangeTrackDb TABLE (

		dbName			SYSNAME PRIMARY KEY,

		isAutoClean		INT,

		retention		INT,

		retPeriod		NVARCHAR(32)

	)
	INSERT INTO @ChangeTrackDb


		SELECT

			db.name,

			is_auto_cleanup_on,

			retention_period,

			retention_period_units_desc

		FROM sys.change_tracking_databases ct WITH(NOLOCK)

			INNER JOIN sys.databases db WITH(NOLOCK) ON

				ct.database_id = db.database_id

	-- Is Change Tracking enabled for the given database?

	DECLARE @CTEnabled		TINYINT = 0

	SELECT 

		@CTEnabled = 1

	FROM @ChangeTrackDb

	WHERE dbName = DB_NAME()		-- normally should be CommServ, allows for out-of-place upgrades

	-- Enable Change Tracking on the Database if not enabled

	IF (@CTEnabled = 0)

	BEGIN

		DECLARE @retentionDays	NVARCHAR(10) = N'3'		-- hold change tracking for 3 days before cleaning up

		DECLARE @dbName			SYSNAME = DB_NAME()		-- normally should be CommServ, allows for out-of-place upgrades

		SET @tcMsg = 'Failure to enable SQL Server Change Tracking on ' + @dbName + ' Database.'

		SET @sqlCmd = N'ALTER DATABASE ' + @dbName + N' SET CHANGE_TRACKING = ON (CHANGE_RETENTION = ' + @retentionDays + N' DAYS,AUTO_CLEANUP = ON)'

		EXEC(@sqlCmd)

		SET @msg = 'SQL Server Change Tracking enabled for database [' + DB_NAME() + ']'

		PRINT @msg

	END	

	ELSE

	BEGIN

		SET @msg = 'SQL Server Change Tracking already enabled for database [' + DB_NAME() + ']'

		PRINT @msg

	END

END TRY

BEGIN CATCH

	PRINT  'CHANGE TRACKING CSDB SETUP: INSIDE CATCH BLOCK WITH FOLLOWING ERROR:

		ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '

		PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '

		ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '

		ERROR MESSAGE: ' + ERROR_MESSAGE() + '

		ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '

		ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	IF (@tcMsg <> '')

	BEGIN

		PRINT @tcMsg

	END

	RAISERROR(@tcMsg, 16, 1)

END CATCH


END

GO
IF @@error <> 0 RETURN
GO
