

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/CSProactiveDBMaintainanceJobDisable.upg] ---------- 

--======================================================================================================
--This Script disables the CSProactiveDBMaintainanceJob SQL Agent Job while DbUpgrade is executing
--======================================================================================================
SET QUOTED_IDENTIFIER ON

GO
SET NOCOUNT ON

DECLARE @script VARCHAR(128) = 'Script: Disabling CSProactiveDBMaintainanceJob SQL Agent Job - '

DECLARE @jobName NVARCHAR(128) = N'CSProactiveDBMaintainanceJob'

DECLARE @jobId UNIQUEIDENTIFIER

DECLARE @enabled TINYINT

DECLARE @opName VARCHAR(100) = 'None'

Declare @rc INT = 0

SELECT

	@jobId = job_id,

	@enabled = enabled

FROM msdb.dbo.sysjobs WITH(NOLOCK)

WHERE

	name = @jobName

PRINT @script + ' Starting for JobId [' + ISNULL(CAST(@jobId AS VARCHAR(60)), 'NULL') + ']'

IF @jobId IS NULL

BEGIN

--PRINT @script + 'SQL Agent JobName [' + @jobName + '] not configured'
	SET @opName = 'NOT Configured'

	GOTO PROC_END

END

DECLARE @running TINYINT = 0

SELECT

    @running = 	CASE

					WHEN a.start_execution_date IS NOT NULL AND a.stop_execution_date IS NULL THEN 1

					ELSE 0

				END

FROM msdb.dbo.sysjobs_view j WITH(NOLOCK)

	INNER JOIN msdb.dbo.sysjobactivity a WITH(NOLOCK) ON

		j.job_id = a.job_id

WHERE 

	a.session_id = (

		SELECT MAX(s.session_id) FROM msdb.dbo.sysjobactivity s WITH(NOLOCK) WHERE s.job_id = @jobId

	)

    AND j.job_id = @jobId

IF @running = 1

BEGIN

--PRINT @script + 'Stopping JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + ']'
	SET @opName = 'Stopped'

	EXEC @rc = msdb..sp_stop_job @job_id = @jobId

END

IF @enabled = 0

BEGIN

--Customer has disabled it
--PRINT @script + 'Customer has disabled JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + ']'
		SET @opName = 'Customer Disabled'

END

ELSE IF @jobId IS NOT NULL

	AND @enabled = 1

BEGIN

--PRINT @script + 'Disabling JobName [' + @jobName + '] JobId [' + CAST(@jobId AS VARCHAR(128)) + ']'
	SET @opName += ' Disabled'

	EXEC @rc = msdb..sp_update_job @job_id = @jobId, @enabled = 0

--Insert record to notify PostUpgrade to enable the job when done
	DECLARE @sqlCmd NVARCHAR(MAX) = N''

	DECLARE @dt NVARCHAR(12) = CAST(dbo.GetUnixTime(GETUTCDATE()) AS NVARCHAR(128))

	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'GXGlobalParam' AND COLUMN_NAME = 'created')

	BEGIN

		SET @sqlCmd = 'INSERT INTO GXGlobalParam (name, value, created, modified) VALUES (''' + @jobName + '_DbUpgrade'', ''1'', ' + @dt + ', 0)'

	END

	ELSE

	BEGIN

		SET @sqlCmd = 'INSERT INTO GXGlobalParam (name, value) VALUES (''' + @jobName + '_DbUpgrade'', ''1'')'

	END

	EXEC(@sqlCmd)

END

PROC_END:

	PRINT @script + ' Completed [' + @opName + '] jobCode [' + CAST(@rc AS VARCHAR(12)) + ']'

GO
IF @@error <> 0 RETURN
GO
