

--  ------------  Generated from [../../../Source/CommServer/Db/Upgrade/App_Plan.upg] ---------- 

BEGIN

DECLARE @oldRev CHAR(20)    		
  	DECLARE @oldVal CHAR(256)			
  	DECLARE @retCode   INTEGER			
  	DECLARE @sqlError  INTEGER			
  	SET     @retCode = 0              	
  	DECLARE @sqlString nvarchar(MAX)	
  	DECLARE @macroValue nvarchar(MAX)	
      DECLARE @parentID INTEGER				
      DECLARE @tName nvarchar(128)			
      DECLARE @colID INTEGER					
      DECLARE @constId INTEGER				
      DECLARE @cName   nvarchar(128)			
  	DECLARE @oldConstraintName   nvarchar(128)	
  	DECLARE @newConstraintName   nvarchar(128)	
  	DECLARE @keyname   nvarchar(128)		
      DECLARE @dbName   nvarchar(128)			
  	DECLARE @IsNullableAttr VARCHAR(100)	
  	DECLARE @DefaultValAttr NVARCHAR(MAX)	
  	DECLARE @DataType     NVARCHAR(	256)	
  	SET ROWCOUNT 0							
  	SET NOCOUNT ON

SELECT @dbName = DB_NAME()													
  SELECT @oldRev = (SELECT revision FROM GXDBVersions WHERE name = 'App_Plan')	
  IF (@oldRev IS NULL)														
  BEGIN                 														
      SET @oldRev = '0.0'														
  END																			
  IF NOT EXISTS (SELECT * FROM sysobjects										
  WHERE type = 'U'															
  AND name = 'App_Plan')														
  BEGIN																		
  	SET @oldRev = '0.0'														
  	DELETE FROM GXDBVersions WHERE name = 'App_Plan'							
  END																			
  IF (@oldRev = '1.4')       												
  BEGIN																		
      PRINT 'RETVAL: 0   Table [' +'App_Plan' +'] does NOT require upgrade.'	
  END																			
  else																		
  BEGIN																		
      PRINT 'Upgrading Table [' +'App_Plan' +'].'							
  END


IF NOT EXISTS (select * from sysobjects where id = object_id(N'[dbo].[App_Plan]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN



--  ------------  Generated from [../../../Source/CommServer/Db/Tbl/App_Plan.tbl] ---------- 





-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright (c) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        This is unpublished proprietary source code of CommVault

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Tbl/App_Plan.tbl,v $ $Id: App_Plan.tbl,v 1.1.2.4 2017/02/10 22:23:41 sjohnson Exp $";

print '... Creating Table: App_Plan'

exec ('



DECLARE @tblRetCode integer

Set NOCOUNT ON





create table App_Plan (

	id		    INTEGER NOT NULL IDENTITY (1,1),

	name        nvarchar(255)	NOT NULL,

	GUID        uniqueidentifier ROWGUIDCOL NULL,

	type        int	NOT NULL,	-- 1 - dlo, 2 - msp, ...                                                -- Definition is in Api.x enum PlanType

	subType     int	NOT NULL,	-- 16777223 - dlo, 33554437 -msp  server, 33554439 - msp laptop, ...    -- Definition is in Api.x enum PlanMask

	pclass      int	NOT NULL,	-- 0 - master, 1 - template, 2 - default, ...                           -- Definition is in Api.x enum PlanClass

	ownerId	    int		   NULL,

	created		INTEGER  NOT NULL,

	modified	INTEGER  NOT NULL,

	origCCId    int	NOT NULL,

	flag		integer NOT NULL,

	description				nvarchar(max) NOT NULL,



) 

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

		set @tblRetCode = @@error;

		print ''RETVAL: 10 Table [App_Plan]''

END

--------





create unique index App_Plan_OwnerTypeName_Idx on App_Plan(ownerId, subType, name)



set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 99 Table [App_Plan]''

END

----------



alter table App_Plan add constraint DF_APP_Plan_GUID default (newid()) for GUID

alter table App_Plan add constraint DF_APP_Plan_class default (3) for pclass

alter table App_Plan add constraint CH_APP_Plan_Name check (name <> '''')



insert into GXDBVersions values(1, ''App_Plan'',  ''1.1.2.4'', ''App_Plan'', '''')

set @tblRetCode = @@error

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 10 Table [GXDBVersions]''

END

ALTER TABLE App_Plan ADD CONSTRAINT App_Plan_id_PK 		primary key (id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [App_Plan]''

END

----------

ALTER TABLE App_Plan  ADD CONSTRAINT App_Plan_ownerId_FK	foreign key (ownerId)references	 UMUsers(id)



set @tblRetCode = @@error 

if (@tblRetCode <> 0)

BEGIN

	set @tblRetCode = @@error;

	print ''RETVAL: 02 Table [App_Plan]''

END

----------


')
END
--it does not matter what version of the table we are trying to upgrade. As long as column with offensive name exists
--it has to be renamed
    IF EXISTS(SELECT * FROM sys.columns WHERE Name = N'class' AND Object_ID = Object_ID(N'App_Plan')) BEGIN

--column exists
        EXEC sp_rename 'dbo.App_Plan.class', 'pclass', 'COLUMN'

    END

--it does not matter what version of the table we are trying to upgrade. As long as ownerId column is not nullable
--it should be updated. Macro will check whether column is nullable or not
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'App_Plan' AND COLUMN_NAME='ownerId' AND IS_NULLABLE = 'NO'))			
  	BEGIN																														
  		SET @sqlString = 'ALTER TABLE ' + 'App_Plan'+ ' ALTER COLUMN ' +'ownerId'+ ' ' +'INT'		
  		+ ' NULL ' 																								
  		IF ('' <> '')							
  		SET @sqlString = ''				
  	SET @retCode = 0						
  	EXEC sp_executesql @sqlString			
  	SET @sqlError = @@error					
  	IF (@sqlError <> 0)						
  	BEGIN									
  		IF (99 > @retCode)				
  	  		SET @retCode = 99			
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), 99) + ' [' + @sqlString + ']' + ' SQL Error: ' + CONVERT(CHAR(8), @sqlError)		+ ' [' + @sqlString + ']'						
  		IF (@retCode > 10)					
  			RETURN							
  	END																											
  	END

--it does not matter what version of the table we are trying to upgrade. As long as index contains 'type' column
--it should be updated
	IF EXISTS(SELECT * FROM sys.columns C INNER JOIN sys.index_columns IC ON ((IC.object_id = C.object_id) AND (IC.column_id = C.column_id))

                                          INNER JOIN sys.indexes        I ON I.object_id = IC.object_id

			  WHERE I.name = 'App_Plan_OwnerTypeName_Idx' AND C.name = 'type') 

	BEGIN

		DROP INDEX [App_Plan_OwnerTypeName_Idx] ON [dbo].[App_Plan]

		CREATE UNIQUE NONCLUSTERED INDEX [App_Plan_OwnerTypeName_Idx] ON [dbo].[App_Plan]

		(

			[ownerId] ASC, [subType] ASC, [name] ASC

		)

	END

IF (@retCode < 10)													
  	BEGIN																
  		IF NOT EXISTS (SELECT * FROM GXDBVersions WHERE name = 'App_Plan')			
  			insert into GXDBVersions VALUES(1, 'App_Plan', '0.0', 'App_Plan', '')	
  			UPDATE GXDBVersions SET revision = '1.4' WHERE name = 'App_Plan'		
   PRINT 'RETVAL: ' + CONVERT(CHAR(3), @retCode) + 'Table [' + 'App_Plan' + '] upgraded successfully to '			+ ' revision [' + '1.4' + '].'										
  	END																	
  	else																
  		PRINT 'RETVAL: ' + CONVERT(CHAR(5), @retCode) + ' TABLE ' + 'App_Plan' + ' Upgrade Completed with Errors.'  
  	RETURN			   -- No more upgrade for this TABLE!

END

GO
IF @@error <> 0 RETURN
GO
