

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/sec_upgradeSecurityForArray.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- 

--		Script for Array permissions upgrade

--		This script assigns Array Management permission to users who have Administrative Management at CS or Storage Array level. 

--   

-- ------------------------------------------------------------------------------------------------------*/

declare @errorCode int = 0

declare @errorString nvarchar(maX) = N''

declare @guidForArray uniqueidentifier = '4197529F-6AF1-482B-B0A2-25EBDD4C1729'

DECLARE @curUtcDateTime BIGINT = datediff(second, '01/01/1970', GetUTCdate())       

DECLARE @globalParamPlanUpdateExec INT = 0

SELECT @globalParamPlanUpdateExec = 1 FROM

    GXUniqueSQLScriptExecTracking gp WITH(NOLOCK) WHERE

    gp.SqlScriptGUID = @guidForArray

IF (@globalParamPlanUpdateExec = 0)        -- not done, create the activity monitoring dashboard

BEGIN

	BEGIN TRY

	BEGIN TRAN

		--Handle permission for existing data source	

		--  Insert permission 'Array Management' when 'Administrative management' permission is present for Commcell level.

		INSERT UMSecurityAssociations(roleId, permissionId ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId )

SELECT distinct 0, 244 ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId

		FROM UMSecurityAssociations UMSANew

WHERE permissionId = 1 AND ((entityType1 = 1 and entityId1=2 /*Default commcell ID*/) OR entityType1 = 153)

		and not exists(SELECT 1 FROM UMSecurityAssociations UMSAOld

where UMSAOld.roleId=0 AND UMSAOld.permissionId= 244  and UMSAOld.userOrGroupId=UMSANew.userOrGroupId

			and UMSAOld.isUser=UMSANew.isUser 

			and UMSAOld.entityType1=UMSANew.entityType1 and UMSAOld.entityId1=UMSANew.entityId1

			and UMSAOld.entityType2=UMSANew.entityType2 and UMSAOld.entityId2=UMSANew.entityId2

			and UMSAOld.entityType3=UMSANew.entityType3 and UMSAOld.entityId3=UMSANew.entityId3

			and UMSAOld.entityType4=UMSANew.entityType4 and UMSAOld.entityId4=UMSANew.entityId4

			and UMSAOld.entityType5=UMSANew.entityType5 and UMSAOld.entityId5=UMSANew.entityId5

			)

		--  Insert permission 'Array Management' when 'Administrative management' permission is present for a role which is assigned to user at Commcell level.

		INSERT UMSecurityAssociations(roleId, permissionId ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects, roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId )

SELECT distinct 0, 244 ,userOrGroupId,isUser,isRoleAllowed,propagateToChildObjects,   roleValidityDate,timeZone,exclude,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeAll,isCreator,authorId

		FROM UMSecurityAssociations UMSANew

WHERE roleId IN (SELECT UMRolesWithPermissionsExpanded.roleId FROM UMRolesWithPermissionsExpanded WHERE permissionId= 1)

AND  ((entityType1 = 1 and entityId1=2 /*Default commcell ID*/) OR entityType1 = 153)

		 and not exists(SELECT 1 FROM UMSecurityAssociations UMSAOld

where UMSAOld.roleId=0 AND UMSAOld.permissionId= 244  and UMSAOld.userOrGroupId=UMSANew.userOrGroupId

			and UMSAOld.isUser=UMSANew.isUser 

			and UMSAOld.entityType1=UMSANew.entityType1 and UMSAOld.entityId1=UMSANew.entityId1

			and UMSAOld.entityType2=UMSANew.entityType2 and UMSAOld.entityId2=UMSANew.entityId2

			and UMSAOld.entityType3=UMSANew.entityType3 and UMSAOld.entityId3=UMSANew.entityId3

			and UMSAOld.entityType4=UMSANew.entityType4 and UMSAOld.entityId4=UMSANew.entityId4

			and UMSAOld.entityType5=UMSANew.entityType5 and UMSAOld.entityId5=UMSANew.entityId5

			)

		INSERT GXUniqueSQLScriptExecTrackINg(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)

		VALUES(@guidForArray,'UpgradeSecurityForArray','Upgrade Security For Array',@curUtcDateTime,16,0,18)

	END TRY

	BEGIN CATCH	 

     set @errorCode = ERROR_NUMBER()

     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()

	END CATCH

	 IF @errorCode = 0

		COMMIT TRAN

	ELSE 

		ROLLBACK TRAN

END

