

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/sec_setCompanyIdScript.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--                                                                      

--           Copyright (c) 1998  CommVault Systems, Inc.                

--                  All rights reserved.                                

--                                                                      

--                                                                   

--        This is unpublished proprietary source code of CommVault  

--        Systems, Inc. The copyright notice above does not evidence 

--        any actual or intended publication of such source code. 

-- ----------------------------------------------------------------------*/

-- 

-- ----------------------------------------------------------------------

--                                                                      

--   Any security association / owner association made should be updated

--   with their company Id in UMCompanyAssociations table. 

--   

--   

--   This is upgrade script for existing entries. 

-- 

--   After this file, there should not be any more inserts / updates 

--	 into UMSecurityAssociations / UMOwners script because by the time 

--	 this happens, trigger would not be created. (on fresh installs).

--

--   Author: jswaminathan

-- ----------------------------------------------------------------------*/

DECLARE @nowTime INTEGER

SET @nowTime =  datediff(second, '01/01/1970', GetUTCdate()) 

-- Updating the company ID for existing security associations 

DECLARE @companyIdUpgradeGUID VARCHAR(MAX) = '781B27C1-31A3-4A92-B6B1-16E64507DB03'

IF NOT EXISTS (

					SELECT 1

					FROM GXUniqueSQLScriptExecTracking

					WHERE

						SqlScriptGUID = @companyIdUpgradeGUID

			  )

BEGIN

	UPDATE Sec 

SET companyId = CASE WHEN P.serviceType = 5 THEN P.id

						 WHEN P.ownerCompany <> 0 THEN P.ownerCompany

						 ELSE 0 

					END

	FROM UMSecurityAssociations Sec 

		LEFT JOIN UMUsers U				-- This is a one-time script. So running it with LEFT JOIN is fine. 

			ON Sec.isUser = 1 AND U.id = Sec.userOrGroupId 

		LEFT JOIN UMGroups G

			ON Sec.isUser = 0 AND G.id = Sec.userOrGroupId 

		INNER JOIN UMDSProviders P 

			ON 

				(

					(Sec.isUser = 1 AND P.id = U.umdsProviderId)

					OR 

					(Sec.isUser = 0 AND P.id = G.umdsProviderId)

				)

	UPDATE Sec 

SET companyId = CASE WHEN P.serviceType = 5 THEN P.id

						 WHEN P.ownerCompany <> 0 THEN P.ownerCompany

						 ELSE 0 

					END

	FROM UMOwners Sec 

		LEFT JOIN UMUsers U

			ON Sec.isUser = 1 AND U.id = Sec.userOrGroupId 

		LEFT JOIN UMGroups G

			ON Sec.isUser = 0 AND G.id = Sec.userOrGroupId 

		INNER JOIN UMDSProviders P 

			ON 

				(

					(Sec.isUser = 1 AND P.id = U.umdsProviderId)

					OR 

					(Sec.isUser = 0 AND P.id = G.umdsProviderId)

				)
	INSERT INTO GXUniqueSQLScriptExecTracking (SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES(@companyIdUpgradeGUID, 'SetCompanyIdUMSecurityAssociations', 'Setting company Id in UMSecurityAssociations', @nowTime, 16, 0, 18)

END

