

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/archGroupCopy.script] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 2015  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

DECLARE @upgradeFromRelease INTEGER = 0

DECLARE @upgradeFromSPMajor INTEGER = 0

DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())

IF EXISTS (SELECT 1 FROM sysobjects WHERE id = OBJECT_ID(N'[dbo].[DBUpgradeSteps]') and OBJECTPROPERTY(id, N'IsTable') = 1)

BEGIN

		SELECT @upgradeFromRelease = CAST(Status AS INTEGER)

		FROM   DBUpgradeSteps

		WHERE  Step = 'UpgradeFromRelease'

		SELECT @upgradeFromSPMajor = CAST(Status AS INTEGER)

		FROM   DBUpgradeSteps

		WHERE  Step = 'UpgradeFromSPMajor'

END

IF (@upgradeFromRelease = 14)

BEGIN

UPDATE archGroupCopy SET flags = (flags|8388608) WHERE encType > 0 AND ((dedupeFlags & 262144) > 0)

END

IF ((@upgradeFromRelease = 14) OR (@upgradeFromRelease = 15))

BEGIN

-- Set passThrough flag for the default option when upg from v9/v10 to v11

-- for non-dedup copies which have this option selected - copy encrypted data with existing cipher - the v11 upgrade equivalent is to switch to reencrypt option.

-- make sure no other enc flag is already set.

-- UPDATE archGroupCopy - to help search

UPDATE AGC

SET AGC.flags = (CASE WHEN ((AGC.encType = 0) AND (AGC.encKeyLen = 0)) THEN AGC.flags | 1048576 WHEN ((AGC.encType > 0) AND (AGC.encKeyLen > 0)) THEN AGC.flags | 8388608 END)

FROM archGroupCopy AGC

WHERE AGC.flags & 1048576 = 0

AND AGC.flags & 8388608 = 0

AND AGC.flags & 2097152 = 0

AND AGC.flags & 4194304 = 0

AND AGC.id NOT IN (SELECT defaultCopy FROM archGroup)

AND AGC.id NOT IN (SELECT defaultSnapCopy FROM archGroup)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '57acffd9-301c-4314-8402-c4c8ef1d78db')

BEGIN

	-- execute below only if version we are running on is v11.

IF EXISTS (SELECT 1 FROM simAllGalaxyRel WHERE id = 16)

	BEGIN

		UPDATE 	archGroupCopy

SET 	extendedFlags = extendedFlags | 2048

		WHERE 	destMediaCopyId > 0
		INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('57acffd9-301c-4314-8402-c4c8ef1d78db', 'OverrideRetentionOfDependentGlobalPolicyScript', 'Update script to set the Override retention flag for existing Global Policy dependent copies', @nowTime, 16, 0, 17)

	END

END

IF (((@upgradeFromRelease = 14) OR (@upgradeFromRelease = 15) OR (@upgradeFromRelease = 16 AND @upgradeFromSPMajor <= 2))

	AND NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '68893a21-7912-4594-91ab-1575c0fa9af9'))

BEGIN

	UPDATE archGroupCopy

SET extendedFlags = extendedFlags | 1024

	WHERE EXISTS (SELECT 1 FROM archFileCopy AFC WITH (READUNCOMMITTED) WHERE AFC.archCopyId = archGroupCopy.id AND AFC.encKeyType > 0)

	OR EXISTS (	SELECT 1 

				FROM archCopySIDBStore CS WITH (READUNCOMMITTED), archFileSIDBKeys S WITH (READUNCOMMITTED) 

				WHERE archGroupCopy.id = CS.copyId

AND ((CS.Flags & 4) > 0)

					AND CS.SIDBStoreId = S.SIDBStoreId)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('68893a21-7912-4594-91ab-1575c0fa9af9', 'EnableArchFileEncOnCopyScript', 'Update script to set the encrypted AF exist flag for existing GDSP copies', @nowTime, 16, 0, 17)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '2AD7BA3B-B62D-43C2-A5F0-3D9E16412E4A')

BEGIN

	-- we are executing below on v11 only so no additional version check is needed.

	UPDATE archGroupCopy

SET extendedFlags = extendedFlags | 65536

WHERE (((dedupeFlags & 134217728) > 0) OR ((extendedFlags & 2) > 0)

OR ((extendedFlags & 8192) > 0))
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('2AD7BA3B-B62D-43C2-A5F0-3D9E16412E4A', 'OverrideEncryptionOfDependentGlobalPolicyScript', 'Update script to set the Override encryption flag for existing Global Policy dependent copies', @nowTime, 16, 0, 17)

END

--Set dependent primary encryption flag on global policy if re-encrypt is set

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '5181CC94-0C60-45DF-9BB7-36F71AA82FE7')

BEGIN

	UPDATE 	archGroupCopy

SET 	extendedFlags = extendedFlags | 262144 /*CVA_ENCRYPT_ON_DEPENDENT_PRIMARY*/

	WHERE 	(

(dedupeFlags & 268435456) > 0  /*CVA_HOST_GLOBAL_DEDUP_STORE_FLAG*/

OR (extendedFlags & 1) > 0 /*CVA_GLOBAL_AUXCOPY_POLICY_FLAG*/

OR (extendedFlags & 4096) > 0 /*CVA_GLOBAL_STORAGE_POLICY_FLAG*/

			)

AND (flags & 8388608) > 0 /*CVA_AUXCOPY_REENCRYPT_DATA_FLAG*/
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('5181CC94-0C60-45DF-9BB7-36F71AA82FE7', 'SetDependentPrimaryEncryptionFlagScript', 'Set dependent primary encryption flag on global policy if re-encrypt is set', @nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'D4DFBF70-55EC-4283-AD52-214040051D6E')

BEGIN

	-- If there is a replica/Vault copy or a mirror copy on a storage policy that does not have a DFM, then set the copy as Default Replica/Vault or Default Mirror copy.

	UPDATE	AGC

SET		AGC.extendedFlags = extendedFlags | 524288

	FROM	archGroupCopy AGC 

			INNER JOIN ArchGroup AG (NOLOCK) ON AGC.archGroupId = AG.id

			LEFT OUTER JOIN ArchGroupControlHost AGCH (NOLOCK) ON AGCH.ArchGroupId = AGC.archGroupId

	WHERE	AGCH.ArchGroupId IS NULL

			AND AGC.id <> AG.defaultSnapCopy

			AND AGC.isSnapCopy = 1

AND (AGC.extendedFlags & 256) > 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('D4DFBF70-55EC-4283-AD52-214040051D6E', 'SetDefaultReplicaCopyScript', 'Update script to set the default flag for replica copies.', @nowTime, 16, 0, 17)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'A1618E1E-05B8-48CD-A0E4-B550C11A673E')

BEGIN

	--

	-- Set "Via Media Password" for DR copies if "No Access" is set

	-- "No Access" is not supported for DR copies since we can't restore CS DB in case of Disaster 

	--

	UPDATE 	AGC

SET		flags = AGC.flags | 131072 /*CVA_STORE_KEY_ON_MEDIA*/

	FROM	ArchGroupCopy AGC, ArchGroup AG

	WHERE	AGC.archGroupId = AG.id

AND AG.type = 2 /*CVA_COMMSERVE_ER_SP*/

AND (AGC.flags & 131072) = 0

	--

	-- Reverse sync encryption settings to global copy if all dependent copies have same encryption settings

	--

	UPDATE	AGC

SET		flags = AGC.flags & ~(1048576 | 8388608 | 2097152 | 4194304) & ~131072 | G.MinEncMode | G.MinStoreKeyOnMedia,

			encType = G.MinEncType,

			encKeyLen = G.MinEncKeyLen

	FROM	ArchGroupCopy AGC,

			(	

				SELECT  GC.id, 

MIN(DC.flags & (1048576 | 8388608 | 2097152 | 4194304)) MinEncMode, MAX(DC.flags & (1048576 | 8388608 | 2097152 | 4194304)) MaxEncMode,

						MIN(DC.encType) MinEncType, MAX(DC.encType) MaxEncType,

						MIN(DC.encKeyLen) MinEncKeyLen, MAX(DC.encKeyLen) MaxEncKeyLen,

MIN(DC.flags & 131072) MinStoreKeyOnMedia, MAX(DC.flags & 131072) MaxStoreKeyOnMedia

				FROM	ArchGroupCopy DC 

						INNER JOIN archCopyToGlobalPolicy DC2GP ON DC.id = DC2GP.copyId

						INNER JOIN archGroup GP ON DC2GP.globalPolicyId = GP.id,

						ArchGroupCopy GC

				WHERE	(

							--GDSP

							(

								GP.defaultCopy = GC.id 

AND (GC.dedupeFlags & 268435456) > 0

AND (DC.dedupeFlags & 134217728) > 0

							)

							--GACP

							OR 

							(

								DC.destMediaCopyId = GC.id 

AND (GC.extendedFlags & 1) > 0

							)

						)

AND (GC.flags & (1048576 | 8388608 | 2097152 | 4194304)) = 1048576

						AND GC.encType = 0

						AND GC.encKeyLen = 0			

				GROUP BY GC.id

			) AS G

	WHERE	G.id = AGC.id 

			AND G.MinEncMode = G.MaxEncMode

			AND G.MinEncType = G.MaxEncType

			AND G.MinEncKeyLen = G.MaxEncKeyLen

			AND G.MinStoreKeyOnMedia = G.MaxStoreKeyOnMedia

	--		

	-- For GDSP set re-encryption if encrypt on primary is set vice versa.

	-- if encryption is selected then we should encrypt on all dependent copies regardless of primary or secondary

	-- Mixing encrypted and unencrypted data on GDSP is not supported.

	--

	UPDATE 	ArchGroupCopy

SET		flags = flags & ~(1048576 | 8388608 | 2097152 | 4194304) | 8388608 /*CVA_AUXCOPY_REENCRYPT_DATA_FLAG*/,

extendedFlags = extendedFlags | 262144 /*CVA_ENCRYPT_ON_DEPENDENT_PRIMARY*/

WHERE	(dedupeFlags & 268435456) > 0  /*CVA_HOST_GLOBAL_DEDUP_STORE_FLAG*/

			AND 

			(

((flags & 8388608) > 0 AND (extendedFlags & 262144) = 0)

OR ((flags & 8388608) = 0 AND (extendedFlags & 262144) > 0)

			)

	IF @@ROWCOUNT > 0

	BEGIN

		-- Sync encryption settings to dependent copies

		UPDATE	DC

SET		flags = DC.flags & ~((1048576 | 8388608 | 2097152 | 4194304) | 131072) | (GC.flags & ((1048576 | 8388608 | 2097152 | 4194304) | 131072)),

				encType = GC.encType,

				encKeyLen = GC.encKeyLen

		FROM	ArchGroupCopy DC

				INNER JOIN archCopyToGlobalPolicy DC2GP ON DC.id = DC2GP.copyId

				INNER JOIN archGroup GP ON DC2GP.globalPolicyId = GP.id,

				ArchGroupCopy GC

WHERE	(DC.extendedFlags & 65536) = 0

				AND 

				(

					--GDSP

					(

						GP.defaultCopy = GC.id 

AND (GC.dedupeFlags & 268435456) > 0

AND (DC.dedupeFlags & 134217728) > 0

					)

					--GACP

					OR 

					(

						DC.destMediaCopyId = GC.id 

AND (GC.extendedFlags & 1) > 0

					)

				)

				AND 

				(

(DC.flags & ((1048576 | 8388608 | 2097152 | 4194304) | 131072)) <> (GC.flags & ((1048576 | 8388608 | 2097152 | 4194304) | 131072))

					OR DC.encType <> GC.encType

					OR DC.encKeyLen <> GC.encKeyLen

				)

	END

	--

	-- Remove override encryption flag if dependent copy has same settings as global copy

	--

	UPDATE	DC

SET		extendedFlags = DC.extendedFlags & ~65536

	FROM	ArchGroupCopy DC

			LEFT OUTER JOIN archCopyToGlobalPolicy DC2GP ON DC.id = DC2GP.copyId

			LEFT OUTER JOIN archGroup GP ON DC2GP.globalPolicyId = GP.id,

			ArchGroupCopy GC

WHERE	(DC.extendedFlags & 65536) > 0

			AND 

			(

				--GDSP

				(

					GP.defaultCopy = GC.id 

AND (GC.dedupeFlags & 268435456) > 0

AND (DC.dedupeFlags & 134217728) > 0

				)

				--GACP

				OR 

				(

					DC.destMediaCopyId = GC.id 

AND (GC.extendedFlags & 1) > 0

				)

			)

AND (DC.flags & ((1048576 | 8388608 | 2097152 | 4194304) | 131072)) = (GC.flags & ((1048576 | 8388608 | 2097152 | 4194304) | 131072))

			AND DC.encType = GC.encType

			AND DC.encKeyLen = GC.encKeyLen
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('A1618E1E-05B8-48CD-A0E4-B550C11A673E', 'SP13EncryptionChanges', 'Update encryption settings.', @nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'F1F7E21C-485A-4FF2-945B-A207ED4BB924')

BEGIN

	--

	-- Set passthrough flag if no encryption flag is set

	-- We assume passthrough as default if no flag is set in pipeline 

	-- so setting flag to cover any conditions where we explicitly check for passthrough flag 

	--

	UPDATE 	ArchGroupCopy

SET		flags = flags | 1048576

WHERE	(flags & (1048576 | 8388608 | 2097152 | 4194304)) = 0

			AND id > 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('F1F7E21C-485A-4FF2-945B-A207ED4BB924', 'SetPassthruFlag', 'Set passthrough flag for copies not having any encryption flag set.', @nowTime, 16, 0, 16 + 1)

END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'B2B88928-B075-4C00-BC7B-C786350D7149')

BEGIN

	UPDATE 	archGroupCopy

	SET 	sourceCopyId = 0

	WHERE 	sourceCopyId = id AND id <> 0
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('B2B88928-B075-4C00-BC7B-C786350D7149', 'ResetSourceCopyId', 'Reset SourceCopyId for copies pointing to itself due to bug in command line update.', @nowTime, 16, 0, 16 + 1)

END

--set CVA_DEDUP_INACTIVE_FLAG_SET_ON_DEPENDENT if dependent copy has temp disable dedup set

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = '6A85FBFE-7132-4D07-B6BC-3FC329FEA342')

BEGIN

	UPDATE	DepCopy

SET		dedupeFlags |= 32

	FROM	archGroupCopy DepCopy

			INNER JOIN archCopyToGlobalPolicy ACTG ON DepCopy.id = ACTG.copyId

			INNER JOIN archGroup GlobalSP ON ACTG.globalPolicyId = GlobalSP.id

			INNER JOIN archGroupCopy GlobalCopy ON GlobalSP.defaultCopy = GlobalCopy.id

WHERE	DepCopy.dedupeFlags & (134217728|1048576) = (134217728|1048576)

AND (DepCopy.dedupeFlags & 1048576) <> (GlobalCopy.dedupeFlags & 1048576)
	INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('6A85FBFE-7132-4D07-B6BC-3FC329FEA342', 'SetOverrideGDSPDedupInactiveFlag', 'Set override flag on copies with temporarily disable dedupe flag.', @nowTime, 16, 0, 16 + 1)

END

IF EXISTS(	SELECT	1 

			FROM	MMEntityProp MP 

			WHERE	MP.EntityType = 2 /*MM_STORAGE_POLICY_COPY_TYPE*/	

					AND MP.PropertyName = 'AuxCopyEndTime' /*MM_ENTITY_PROP_AUXCOPY_END_TIME_SQL*/	

					AND MP.CommCellId = 2)

BEGIN

		UPDATE	AGC	

		SET		description = (CASE WHEN ((LEN(AGC.description) = 0) OR (CHARINDEX('Backups On or Before: ', AGC.description) = 1)) THEN ''

									WHEN ((LEN(AGC.description) > 1) AND (CHARINDEX('Backups On or Before: ', AGC.description) > 1)) THEN SUBSTRING(AGC.description, 1, CHARINDEX('Backups On or Before: ', AGC.description)-1)

									ELSE AGC.description

								END),

				endTime = MP.intVal	

		FROM	archGroupCopy AGC, MMEntityProp MP	

		WHERE	AGC.id = MP.EntityId	

				AND MP.EntityType = 2 /*MM_STORAGE_POLICY_COPY_TYPE*/	

				AND MP.PropertyName = 'AuxCopyEndTime' /*MM_ENTITY_PROP_AUXCOPY_END_TIME_SQL*/	

				AND MP.CommCellId = 2

		DELETE FROM	MMEntityProp	

		WHERE	EntityType = 2 /*MM_STORAGE_POLICY_COPY_TYPE*/	

				AND PropertyName = 'AuxCopyEndTime' /*MM_ENTITY_PROP_AUXCOPY_END_TIME_SQL*/	

				AND CommCellId = 2

END

IF OBJECT_ID('tempdb.dbo.#dedupeCopies') IS NOT NULL 

    DROP TABLE #dedupeCopies

    CREATE TABLE #dedupeCopies (copyId INT PRIMARY KEY)
    INSERT INTO #dedupeCopies


    SELECT AGC.id

    FROM    archGroupCopy AGC  INNER JOIN ArchGroup AG (NOLOCK) ON AGC.archGroupId = AG.id

    WHERE    AGC.id <> AG.defaultCopy

AND  dedupeFlags &(8388608 | 524288) = (8388608 | 524288)

--unset network optimized flag when read optimized flag is set 

IF @@ROWCOUNT > 0

 BEGIN

   UPDATE	AGC

SET		dedupeFlags =  dedupeFlags & ~ 524288

	FROM	archGroupCopy AGC INNER JOIN #dedupeCopies D

	ON	AGC.id = D.copyId

   DROP TABLE #dedupeCopies

 END

IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTracking WHERE SqlScriptGUID = 'ec49d73c-af47-11ea-b3de-0242ac130004')

BEGIN

  IF OBJECT_ID('tempdb.dbo.#dedupeStoragepolicies') IS NOT NULL 

    DROP TABLE #dedupeStoragepolicies

  CREATE TABLE #dedupeStoragepolicies (spId INT PRIMARY KEY)
  INSERT INTO #dedupeStoragepolicies


	SELECT DISTINCT AGC.archGroupId FROM archGroupCopy AGC INNER JOIN archGroup AG 

	ON  AG.id = AGC.archGroupId 

WHERE (AG.flags & 32) = 0 AND

	      AGC.dedupeFlags&262144 >0

  UPDATE AG

SET 	flags  = flags|32

  FROM	archGroup AG INNER JOIN #dedupeStoragepolicies SP ON AG.id = SP.spId

  DROP TABLE #dedupeStoragepolicies
  INSERT INTO GXUniqueSQLScriptExecTracking(SqlScriptGUID, Name, Description, CreatedTime, CreatedRelId, ExpireTime, ExpireRelId)


VALUES ('ec49d73c-af47-11ea-b3de-0242ac130004', 'ResetDedupeFlag', 'Reset Dedupelication flag for storagepolicies which contains atlease one deduplication copy.', @nowTime, 16, 0, 16 + 1)

END

--force plan associated snap copies to use storage pool.

IF EXISTS(		select agc.id

				FROM archGroup ag

					INNER JOIN archGroupCopy agc on agc.archGroupid = ag.id

WHERE ag.flags & 536870912 > 0

					AND agc.isSnapCopy = 1

					AND NOT EXISTS(SELECT 1 FROM archCopyToGlobalPolicy acgp WHERE acgp.copyid = agc.id) 

			)

BEGIN

	DECLARE @snapCopyId INT = 0

	DECLARE @storagePoolId INT = NULL

	CREATE TABLE #tempRet (retcode int)

	DECLARE cur CURSOR LOCAL FOR

	select agc.id

	FROM archGroup ag

		INNER JOIN archGroupCopy agc on agc.archGroupid = ag.id

WHERE ag.flags & 536870912 > 0

		AND agc.isSnapCopy = 1

		AND NOT EXISTS(SELECT 1 FROM archCopyToGlobalPolicy acgp WHERE acgp.copyid = agc.id)

	OPEN cur

	FETCH NEXT FROM cur INTO @snapCopyId

	WHILE @@FETCH_STATUS = 0

	BEGIN

		BEGIN TRY

			SET @storagePoolId = NULL

			;with snapCopyDrivePools

			AS	(

				SELECT DrivePoolId FROM MMDataPath WHERE CopyID = @snapCopyId

			)

			SELECT TOP 1 @storagePoolId = GAG.id 

			from archGroup GAG

				 INNER JOIN MMDataPath DP ON GAG.defaultCopy = DP.copyId

				 INNER JOIN snapCopyDrivePools SDP ON DP.DrivePoolId = SDP.DrivePoolId

			WHERE GAG.id > 1 

AND GAG.flags & (256 | 16384 | 8388608 | 33554432) > 0

			GROUP BY GAG.id

			ORDER BY COUNT(DP.DrivePoolId) DESC

			IF @storagePoolId IS NOT NULL

			BEGIN

				BEGIN TRAN

				UPDATE MG

				SET MG.DrivePoolId = 0, MG.SpareGroupId = 0, MG.DesiredMediaTypeId = 0, MG.RecordingFormatId = 0, MG.DataPathId = 0

				FROM MMMediaGroup MG

					INNER JOIN archStream s ON s.MediaGroupId = mg.MediaGroupId 

				WHERE s.archGroupCopyId = @snapCopyId

				DELETE FROM MMDataPath WHERE copyId = @snapCopyId
				INSERT INTO #tempRet


					EXEC archCopyUseGlobalPolicy @snapCopyId, @storagePoolId, 0/*reserve*/

				IF EXISTS(SELECT 1 FROM #tempRet where retcode > 0)

					ROLLBACK TRAN

				ELSE

					COMMIT TRAN

			END

		END TRY

		BEGIN CATCH

			IF @@TRANCOUNT > 0 

				ROLLBACK TRAN

		END CATCH

		FETCH NEXT FROM cur INTO @snapCopyId

	END

	CLOSE cur

END

