

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WF_Definition.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WF_Definition.script,v $ $Id: WF_Definition.script,v 1.70.12.10 2020/02/14 23:15:05 chandru Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

--workflow updates have been moved to individual scripts WFD_*.script

-- -------------------------------------------------------------------------------------------------------------------------

--	Chandru:

--	With every service pack recut we adapted following procedure to save the time during fresh installs at customer site, 

--		1.	We restore RTM database 

--		2.	Apply all database updates

--			a.	Here APP_Platform table will be empty and following condition should work fine

--			IF NOT EXISTS (SELECT   * FROM APP_Platform)

--			BEGIN

--			                                                

--			END

--		3.	Detach the database and copy them to service pack DVD

-- -------------------------------------------------------------------------------------------------------------------------

-- Following script will be used as postscripts for workflows.

-- This block gets executed only with new installations.

-- If any default Workflow needs to be removed,

--   add the delete statement here along with removing entry from list file.

-- -------------------------------------------------------------------------------------------------------------------------

DECLARE @WorkflowsToDelete TABLE (wfname nvarchar(1024))

IF NOT EXISTS( SELECT 1 FROM App_Client WHERE id = 2)

BEGIN	
	INSERT INTO @WorkflowsToDelete VALUES ('Unix Crash Crawler Deployer')

	INSERT INTO @WorkflowsToDelete VALUES ('DRTestingWorkflow')		

	INSERT INTO @WorkflowsToDelete VALUES ('Change Index Server')	

	INSERT INTO @WorkflowsToDelete VALUES ('DDB Seeding')

	INSERT INTO @WorkflowsToDelete VALUES ('DM2CacheDirectoryMove')

	INSERT INTO @WorkflowsToDelete VALUES ('Generate Auth Code')

	INSERT INTO @WorkflowsToDelete VALUES ('SearchEngineIndexUpgrader')

	INSERT INTO @WorkflowsToDelete VALUES ('Documentum SQL DB Inplace Restore')

	INSERT INTO @WorkflowsToDelete VALUES ('SAP MaxDB')

	INSERT INTO @WorkflowsToDelete VALUES ('SQL-Documentum Backup')

	INSERT INTO @WorkflowsToDelete VALUES ('SQL-Documentum Restore')

	INSERT INTO @WorkflowsToDelete VALUES ('Enable EdgeDrive and shares of deleted AD')

	INSERT INTO @WorkflowsToDelete VALUES ('IndexServerDirectoryMove')

	INSERT INTO @WorkflowsToDelete VALUES ('ReviewSetMigration')

	INSERT INTO @WorkflowsToDelete VALUES ('AddMediaAgentToGlobalDedupStoragePolicy')

	INSERT INTO @WorkflowsToDelete VALUES ('System Discovery for NAS')

	INSERT INTO @WorkflowsToDelete VALUES ('CleanUp Objectstore data')

	INSERT INTO @WorkflowsToDelete VALUES ('CreateClusterClients')

	INSERT INTO @WorkflowsToDelete VALUES ('Laptop Registration')


END
INSERT INTO @WorkflowsToDelete VALUES ('DefaultAlarm')


--delete these workflow on both fresh as well as upgraded setup
INSERT INTO @WorkflowsToDelete VALUES ('IndexServerDirectoryMove')

INSERT INTO @WorkflowsToDelete VALUES ('P2VCIIndexMove')

INSERT INTO @WorkflowsToDelete VALUES ('Analytics')

INSERT INTO @WorkflowsToDelete VALUES ('Modify Auxiliary Copy End Time')

INSERT INTO @WorkflowsToDelete VALUES ('Mark Auxiliary Copy Inactive after Auxiliary Copy End Time')


--

IF EXISTS (select * from WF_Definition where Name = 'Change Index Server' and revision = CONCAT('$','Revision',': 1.3 $'))
	INSERT INTO @WorkflowsToDelete VALUES ('Change Index Server')


-- remove failover workflows from commserver default list

IF EXISTS (select 1 from WF_Definition where Name = 'FailoverTestBootVM' and flags & 4 > 0)
	INSERT INTO @WorkflowsToDelete VALUES ('FailoverTestBootVM')


IF EXISTS (select 1 from WF_Definition where Name = 'PlannedFailover' and flags & 4 > 0)
	INSERT INTO @WorkflowsToDelete VALUES ('PlannedFailover')


IF EXISTS (select 1 from WF_Definition where Name = 'UnplannedFailOver' and flags & 4 > 0)
	INSERT INTO @WorkflowsToDelete VALUES ('UnplannedFailOver')


IF EXISTS (select 1 from WF_Definition where Name = 'VSAFailbackVM' and flags & 4 > 0)
	INSERT INTO @WorkflowsToDelete VALUES ('VSAFailbackVM')


UPDATE [TM_Task] SET deleted = 1 WHERE taskId IN (

	SELECT taskId FROM TM_AssocEntity WHERE workflowId IN (Select WorkflowId From WF_Definition Where Name IN ('DefaultAlarm', 'Mark Auxiliary Copy Inactive after Auxiliary Copy End Time'))

)

DELETE	FROM TM_AssocWorkFlowEntity 

WHERE workflowId IN (Select WorkflowId From WF_Definition Where Name IN ('DefaultAlarm', 'Mark Auxiliary Copy Inactive after Auxiliary Copy End Time'))

DELETE	WF_Activity

FROM	WF_Activity A

	INNER JOIN WF_Definition D

		ON A.ActivityId = D.ActivityId

	INNER JOIN @WorkflowsToDelete WD

		ON D.name = WD.wfname

DELETE	WF_Definition

FROM	WF_Definition D

	INNER JOIN @WorkflowsToDelete T

		ON D.Name = T.wfname

