

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_WIATracerDeletion.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_WIATracerDeletion.script,v $ $Id: WFD_WIATracerDeletion.script,v 1.1.2.1 2018/09/26 09:21:59 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @definition		XML

DECLARE @version		INT

DECLARE @flags			INT

DECLARE @guid			VARCHAR(40)

DECLARE @revision		NVARCHAR(255)

SET @revision = '$Revision: 1.1.2.1 $'

SET @version = 1

SET @flags = 6

SET @guid = '3872B411-422F-4D44-AE3F-22B6F98D0217'

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="This workflow deletes a configured SQL Agent WIA Tracer Job" executeOnWeb="0" inputs="&lt;inputs /&gt;" interactive="0" isHtmlDescription="0" name="Diagnostic WIA Tracer Deletion" outputs="&lt;outputs /&gt;" revision="$Revision: 1.1.2.1 $" tags="" uniqueGuid="cda7fe43-81fa-4756-9614-bf318b9c34d5" variables="&lt;variables /&gt;" webHidden="0" workflowId="0">

  <schema>

    <outputs className="" name="outputs" type="" />

    <variables className="" name="variables" type="" />

    <inputs className="" name="inputs" type="" />

    <config className="" name="configuration" type="" />

  </schema>

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="CommServDBQuery_3" commented="0" originalStyle="" sourceX="70" sourceY="60" status="0" style="defaultEdge" targetX="150" targetY="60" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1536684482924" description="executes queries against a commcell database" displayName="WIA Tracer" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_3" waitSetting="0" width="159" x="161" y="41">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;SELECT TOP 1&amp;#xD;&#xD;&#xA;    1&amp;#xD;&#xD;&#xA;FROM msdb.dbo.sysjobs WITH(NOLOCK)&amp;#xD;&#xD;&#xA;WHERE&amp;#xD;&#xD;&#xA;    name = N''WIA_TracerJob''&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_1" commented="0" originalStyle="" status="0" style="defaultEdge" transitionIndex="0" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536862597415" description="if/else based decision" displayName="WIA Tracer&#xD;&#xA;Exists" height="80" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="130" x="176" y="140">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_3/resultSets/rowCount} == 1&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_1" commented="0" displayName="NO" originalStyle="" points="240.0,270.0" status="0" style="defaultEdge" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="CommServDBQuery_4" commented="0" displayName="YES" originalStyle="" sourceX="230" sourceY="180" status="0" style="defaultEdge" targetX="410" targetY="180" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536862641770" description="Ends the workflow" displayName="Nothing To Do" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_1" waitSetting="0" width="108" x="186" y="305">

    <onExit language="1" script="logger.info(&quot;No SQL Agent WIA Tracer Job configured&quot;);" />

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;SQL Agent WIA Tracer Job not configured&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536695341754" description="executes queries against a commcell database" displayName="Delete WIA Tracer" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="152" x="406" y="162">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;SET NOCOUNT ON;&amp;#xD;&#xD;&#xA;USE TroubleShooting;&amp;#xD;&#xD;&#xA;DECLARE @rc INT;&amp;#xD;&#xD;&#xA;EXEC @rc = WIATracerSQLAgentJob @opCode=2;&amp;#xD;&#xD;&#xA;IF @rc = 0&amp;#xD;&#xD;&#xA;    SELECT 1&amp;#xD;&#xD;&#xA;    &amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_2" commented="0" originalStyle="" sourceX="480" sourceY="180" status="0" style="defaultEdge" targetX="650" targetY="180" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536862942762" description="if/else based decision" displayName="Deleted" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="100" x="650" y="128">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/CommServDBQuery_4/resultSets/rowCount} == 1&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_2" commented="0" displayName="YES" originalStyle="" status="0" style="defaultEdge" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="WorkflowEnd_3" commented="0" displayName="NO" originalStyle="" status="0" style="defaultEdge" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536863135981" description="Ends the workflow" displayName="Success" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_2" waitSetting="0" width="106" x="652" y="290">

    <onExit language="1" script="logger.info(&quot;Successfully deleted SQL Agent WIA Tracer Job&quot;);" />

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;COMPLETED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Successfully deleted SQL Agent WIA Tracer Job&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1536863275534" description="Ends the workflow" displayName="Failure" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=commvault.cte.workflow.activities.EndActivity" uniqueName="WorkflowEnd_3" waitSetting="0" width="106" x="840" y="160">

    <onExit language="1" script="logger.info(&quot;Failure to deleted SQL Agent WIA Tracer Job&quot;);" />

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;Failure to deleted SQL Agent WIA Tracer Job&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <onStart language="1" script="logger.info(&quot;WIA Tracer De-configuration Started&quot;);&#xD;&#xA;" />

</workflow>

'

-- Update Work Flow Definition

IF EXISTS (select * from sysobjects where name='WFDUpdateWorkFlowDefinition')		-- Not sure if the Update Team has completed their changes, Database Upgrade Team yes

BEGIN

	DECLARE @wfName NVARCHAR(255)

	SELECT

		@wfName = d.value('@name', 'NVARCHAR(255)')

	FROM @definition.nodes('/workflow') w(d)

	PRINT 'Updating Work Flow Definition: ' + @wfName

	DECLARE @rc INT

	EXEC @rc = WFDUpdateWorkFlowDefinition @guid, @version, @flags, @revision, @definition

END

ELSE

BEGIN

	-- Old Way - TO BE DELETED once SP and Function can be called from Script Files

	DECLARE @nowTime		INT

	DECLARE @nowDt			DATETIME

	DECLARE @name			NVARCHAR(255)

	DECLARE @description	NVARCHAR(MAX)

	DECLARE @workflowId		INT

	DECLARE @currentFlags	INT

	DECLARE @currentRevision NVARCHAR(255)

	SET @nowDt = GETUTCDATE()

	SET @nowTime = datediff(second, '01/01/1970', @nowDt)

	SELECT

		@name = d.value('@name', 'NVARCHAR(255)'),

		@description = d.value('@description', 'NVARCHAR(MAX)')

	FROM @definition.nodes('/workflow') w(d)

	SELECT 

		@workflowId = WorkflowId, 

		@version = Version, 

		@currentFlags = flags, 

		@currentRevision = revision 

	FROM WF_Definition 

	WHERE Name = @name

	IF (@workflowId IS NULL)

	BEGIN
		INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)


			VALUES (@name, @description, @definition, @version, @nowDt, @nowDt, 1, @flags, @revision, @guid)

		SET @workflowId = SCOPE_IDENTITY()
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


			VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

	ELSE

	BEGIN

		IF ((@currentFlags & 4) > 0 OR (@flags & (8|16)) > 0) AND (@currentRevision <> @revision)

		BEGIN

			SET @version = @version + 1

			UPDATE WF_Definition

				SET Description = @description, 

					Definition = @definition, 

					Version = @version,

					Modified = @nowDt,

					revision = @revision, 

					uniqueGuid = @guid,

					flags = CASE

								WHEN ((@flags & (8|16))) > 0 THEN @flags

								ELSE flags		-- no change

							END

			WHERE 

				workFlowId = @workflowId
			INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


				VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

		END

	END

END

