

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_VSABackupForOracleRACWithVRDM.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- -----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @definition     XML

DECLARE @version        INT

DECLARE @flags          INT

DECLARE @guid           VARCHAR(40)

DECLARE @revision       NVARCHAR(255)

DECLARE @description nvarchar(MAX)

DECLARE @workflowId int

DECLARE @currentFlags INT

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @version = 1

SET @flags = 6

SET @guid = 'a6d17d37-a2b2-405a-a6cd-240719b91cb8'

SET @description = 'Workflow to Backup RAC with VRDM configuration' 

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Workflow to Backup RAC with VRDM configuration. It runs VSA backup of the VM and archivelog backups for the RAC instances."

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;VSAClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;displayName />&lt;/VSAClient>&lt;VSASubclient class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;OracleClient class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>&lt;clientName />&lt;clientId />&lt;/OracleClient>&lt;BackupSet class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>defaultBackupSet&lt;/BackupSet>&lt;ArchiveLogBackup class=&quot;java.lang.Boolean&quot; _list_=&quot;true&quot;>true&lt;/ArchiveLogBackup>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" manualPercentageComplete="0"

    name="VSABackupForOracleRACWithVRDM" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.4 $" tags=""

    uniqueGuid="a5075b11-e9ff-4775-ab46-ed870de03f06"

    variables="&lt;variables>&lt;InstanceList class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="1"

                name="InstanceList" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" name="inputs" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="VSA Client" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="VSAClient" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="displayName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="VSA Backup Set" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="BackupSet"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="VSA SubClient" documentation="" hidden="0"

                inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="VSASubclient"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2" defaultValue=""

                displayName="Oracle Client" documentation="" hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="OracleClient" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.String"

                    defaultValue="" inputType="java.lang.String"

                    listType="0" name="displayName" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    defaultValue="" inputType="java.lang.Integer"

                    listType="0" name="clientId" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.Boolean"

                controlHidden="0" controlType="5" defaultValue=""

                displayName="Archive Log Backup"

                documentation="Select Archive log backup for point in time recovery"

                hidden="0" inputType="java.lang.Boolean" listType="1"

                maximumValue="" minimumValue="" name="ArchiveLogBackup"

                readOnly="0" required="0" searchable="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="278" targetY="59"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1559248528217"

        description="Execute a script on a remote machine"

        displayName="quiesce the databases on oracle client" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteScript"

        uniqueName="ExecuteScript_1" waitSetting="0" width="296" x="130" y="42">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/OracleClient/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;#!/bin/sh&amp;#xD;&#xd;&#xa;#no of oracle instance running&amp;#xD;&#xd;&#xa;ORACLE_NUM=0&amp;#xD;&#xd;&#xa;dbs=&quot;&quot;&amp;#xD;&#xd;&#xa;GetRacSIDList()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        dbname=$1&amp;#xD;&#xd;&#xa;        oracle_home=$2&amp;#xD;&#xd;&#xa;        crspath=`ps -aef|grep crsd.bin|grep -v grep|awk ''{print $8}''`&amp;#xD;&#xd;&#xa;        if [ -z &quot;$crspath&quot; ]; #not a rac server&amp;#xD;&#xd;&#xa;        then&amp;#xD;&#xd;&#xa;                return 1&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;        grid_home=`dirname $crspath`&amp;#xD;&#xd;&#xa;        retVal=`$grid_home/crsctl status resource -t -w  &quot;DATABASE_TYPE = RAC&quot;|grep $dbname`&amp;#xD;&#xd;&#xa;        if [ -z &quot;$retVal&quot; ]; #not a rac database&amp;#xD;&#xd;&#xa;        then&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;        export ORACLE_HOME=$oracle_home&amp;#xD;&#xd;&#xa;        sidNames=`$oracle_home/bin/srvctl status database -d $dbname|grep running|awk ''{print $2}''`&amp;#xD;&#xd;&#xa;        printf -v dbs &quot;$dbs\n$sidNames&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        return 0&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;GetInstanceList()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        dbs=`egrep -i &quot;:Y|:N&quot;  /etc/oratab | cut -d&quot;:&quot; -f1  | grep -v &quot;\#&quot; | grep -v &quot;\*&quot; | grep -v &quot;^+&quot; | grep -v &quot;^-&quot;`&amp;#xD;&#xd;&#xa;        for db in $dbs&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_SID=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''/ora_pmon_/ { n = split($NF, a, &quot;ora_pmon_&quot;); if(n &amp;gt; 1) printf(&quot;%s&quot;,  a[n]); }''`&amp;#xD;&#xd;&#xa;                if [ -z &quot;$ORACLE_SID&quot; ];&amp;#xD;&#xd;&#xa;                then&amp;#xD;&#xd;&#xa;                    #SID is not same as DBNAME, lets get SID names&amp;#xD;&#xd;&#xa;                    oracle_home=`cat /etc/oratab | grep &quot;^$db&quot; | cut -d &quot;:&quot; -f2`&amp;#xD;&#xd;&#xa;                    if [ -z $oracle_home ];&amp;#xD;&#xd;&#xa;                    then&amp;#xD;&#xd;&#xa;                        echo &quot;$db is not found in oratab&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                    else&amp;#xD;&#xd;&#xa;                        GetRacSIDList $db $oracle_home&amp;#xD;&#xd;&#xa;                    fi&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;                done&amp;#xD;&#xd;&#xa;        for db in $dbs&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;            ORACLE_SID=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''/ora_pmon_/ { n = split($NF, a, &quot;ora_pmon_&quot;); if(n &amp;gt; 1) printf(&quot;%s&quot;,  a[n]); }''`&amp;#xD;&#xd;&#xa;            if [ -z &quot;$ORACLE_SID&quot; ];&amp;#xD;&#xd;&#xa;            then&amp;#xD;&#xd;&#xa;                echo &quot;$db is down. skipping&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                            continue;&amp;#xD;&#xd;&#xa;            fi&amp;#xD;&#xd;&#xa;            ORACLE_USER=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | cut -d &quot; &quot; -f1`&amp;#xD;&#xd;&#xa;            ORACLE_HOME=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''{print $2}'' | xargs pwdx | awk ''{print $2}'' | sed -e ''s/\/dbs//g''`&amp;#xD;&#xd;&#xa;            echo &quot;found active Oracle instance  ORACLE_SID=$ORACLE_SID, ORACLE_HOME=$ORACLE_HOME, ORACLE_USER=$ORACLE_USER&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;            ORACLE_USER_LIST[$ORACLE_NUM]=&quot;$ORACLE_USER&quot;&amp;#xD;&#xd;&#xa;            ORACLE_HOME_LIST[$ORACLE_NUM]=&quot;$ORACLE_HOME&quot;&amp;#xD;&#xd;&#xa;            ORACLE_SID_LIST[$ORACLE_NUM]=&quot;$ORACLE_SID&quot;&amp;#xD;&#xd;&#xa;            ORACLE_NUM=$((ORACLE_NUM+1))&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;QuiesceAllInstances()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        num=0&amp;#xD;&#xd;&#xa;        while [[ $num -lt $ORACLE_NUM ]]&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_USER=${ORACLE_USER_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_HOME=${ORACLE_HOME_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_SID=${ORACLE_SID_LIST[$num]}&amp;#xD;&#xd;&#xa;                num=$((num+1))&amp;#xD;&#xd;&#xa;                SQLPLUS=$ORACLE_HOME/bin/sqlplus&amp;#xD;&#xd;&#xa;                CONN_NAME=&quot;/ as sysdba&quot;&amp;#xD;&#xd;&#xa;                export ORACLE_SID ORACLE_HOME&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #check if sqlplus exists&amp;#xD;&#xd;&#xa;                if [ ! -f ${SQLPLUS} ];then&amp;#xD;&#xd;&#xa;                echo &quot;Unable to find sqlplus executable at ${SQLPLUS} &quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                echo $(date) begin quiescing Oracle SID $ORACLE_SID SQLPLUS=$SQLPLUS &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su $ORACLE_USER -c &quot;&amp;#xD;&#xd;&#xa;$SQLPLUS -S /nolog  &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;        connect / as sysdba&amp;#xD;&#xd;&#xa;        alter database begin backup;&amp;#xD;&#xd;&#xa;        exit;&amp;#xD;&#xd;&#xa;EOF&quot; | tee -a $LOGDIR/$LOGFILE | grep -E -v &quot;ORA-01146|ORA-01110&quot; | grep -v &quot;grep&quot; | grep -c &quot;ORA-&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #if quiesce is completed, we do not get any ORA- errors and $? will be non-zero&amp;#xD;&#xd;&#xa;                if [ &quot;$?&quot; -ne 0 ]; then&amp;#xD;&#xd;&#xa;                        echo $(date) quiescing Oracle SID $ORACLE_SID: success  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                else&amp;#xD;&#xd;&#xa;                        echo $(date) quiescing Oracle SID $ORACLE_SID: Failure  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                        return 1&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;      #quiesced all instances successfully&amp;#xD;&#xd;&#xa;        return 0&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;UnQuiesceAllInstances()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        unq_ret=0&amp;#xD;&#xd;&#xa;        num=0&amp;#xD;&#xd;&#xa;        while [[ $num -lt $ORACLE_NUM ]]&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_USER=${ORACLE_USER_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_HOME=${ORACLE_HOME_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_SID=${ORACLE_SID_LIST[$num]}&amp;#xD;&#xd;&#xa;                num=$((num+1))&amp;#xD;&#xd;&#xa;                SQLPLUS=$ORACLE_HOME/bin/sqlplus&amp;#xD;&#xd;&#xa;                CONN_NAME=&quot;/ as sysdba&quot;&amp;#xD;&#xd;&#xa;                export ORACLE_SID ORACLE_HOME&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #check if sqlplus exists&amp;#xD;&#xd;&#xa;                if [ ! -f ${SQLPLUS} ];then&amp;#xD;&#xd;&#xa;                echo &quot;Unable to find sqlplus executable at ${SQLPLUS} &quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                echo $(date) begin unquiescing Oracle SID $ORACLE_SID SQLPLUS=$SQLPLUS &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su $ORACLE_USER -c &quot;&amp;#xD;&#xd;&#xa;$SQLPLUS -S /nolog  &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;        connect / as sysdba&amp;#xD;&#xd;&#xa;        alter database end backup;&amp;#xD;&#xd;&#xa;        alter system archive log current;&amp;#xD;&#xd;&#xa;        exit;&amp;#xD;&#xd;&#xa;EOF&quot; | tee -a $LOGDIR/$LOGFILE | grep -E -v &quot;ORA-01142&quot; | grep -v &quot;grep&quot; | grep -c &quot;ORA-&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #if unquiesce is completed, we do not get any ORA- errors and $? will be non-zero&amp;#xD;&#xd;&#xa;                if [ &quot;$?&quot; -ne 0 ]; then&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: success  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                else&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: Failure  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                        # continue unquiecing the next instance as we do not want to leave anything quiesced&amp;#xD;&#xd;&#xa;                        # return 1&amp;#xD;&#xd;&#xa;                        unq_ret=1&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        #quiesced all instances successfully&amp;#xD;&#xd;&#xa;        return $unq_ret&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;LOGDIR=/tmp&amp;#xD;&#xd;&#xa;LOGFILE=quiesce.log&amp;#xD;&#xd;&#xa;export LOGDIR LOGFILE&amp;#xD;&#xd;&#xa;ret=0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;echo $1 $(date ;id;hostname) &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;# get all running Oracle instances&amp;#xD;&#xd;&#xa;GetInstanceList&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;#quiesce all Oracle instances&amp;#xD;&#xd;&#xa;if [ &quot;$1&quot; = &quot;quiesce&quot; ]; then&amp;#xD;&#xd;&#xa;        QuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa; fi&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;        #unquiesce all Oracle instances&amp;#xD;&#xd;&#xa;        UnQuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;exit $ret&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>quiesce&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Execute_1" commented="0" originalStyle=""

            points="" sourceX="278" sourceY="59" status="0"

            style="defaultEdge" targetX="239" targetY="132"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559249304873" description=""

        displayName="Backup VSA SubClient" height="43" interactive="0"

        jobMode="0" name="Execute"

        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

        uniqueName="Execute_1" waitSetting="0" width="186" x="452" y="39">

        <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;appName&amp;gt;Virtual Server&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupsetName&amp;gt;xpath:{/workflow/inputs/BackupSet}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;clientName&amp;gt;xpath:{/workflow/inputs/VSAClient/clientName}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;instanceName/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subclientName&amp;gt;xpath:{/workflow/inputs/VSASubclient}&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupLevel&amp;gt;FULL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;collectMetaInfo/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;createNewIndex/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;enforceTransactionLogUsage&amp;gt;true&amp;lt;/enforceTransactionLogUsage&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;followMountPoints&amp;gt;true&amp;lt;/followMountPoints&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;skipConsistencyCheck/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;useCatalogServer/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;doNotTruncateLog&amp;gt;false&amp;lt;/doNotTruncateLog&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;incLevel/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;mediaOpt/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;runIncrementalBackup/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;sybaseSkipFullafterLogBkp&amp;gt;false&amp;lt;/sybaseSkipFullafterLogBkp&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;truncateLogsOnSource&amp;gt;false&amp;lt;/truncateLogsOnSource&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;vsaBackupOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupFailedVMsOnly/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/vsaBackupOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;perfJobOpts/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;operationType&amp;gt;BACKUP&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTaskType&amp;gt;BACKUP&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&lt;/inputXml>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="XPathQuery_2" commented="0"

            originalStyle="" points="" sourceX="239" sourceY="132"

            status="0" style="defaultEdge" targetX="465" targetY="132"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559249613624"

        description="Execute a script on a remote machine"

        displayName="unquiesce the databases on oracle client"

        height="76" interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteScript"

        uniqueName="ExecuteScript_2" waitSetting="0" width="328" x="715" y="487">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/OracleClient/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;#!/bin/sh&amp;#xD;&#xd;&#xa;#no of oracle instance running&amp;#xD;&#xd;&#xa;ORACLE_NUM=0&amp;#xD;&#xd;&#xa;dbs=&quot;&quot;&amp;#xD;&#xd;&#xa;GetRacSIDList()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        dbname=$1&amp;#xD;&#xd;&#xa;        oracle_home=$2&amp;#xD;&#xd;&#xa;        crspath=`ps -aef|grep crsd.bin|grep -v grep|awk ''{print $8}''`&amp;#xD;&#xd;&#xa;        if [ -z &quot;$crspath&quot; ]; #not a rac server&amp;#xD;&#xd;&#xa;        then&amp;#xD;&#xd;&#xa;                return 1&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;        grid_home=`dirname $crspath`&amp;#xD;&#xd;&#xa;        retVal=`$grid_home/crsctl status resource -t -w  &quot;DATABASE_TYPE = RAC&quot;|grep $dbname`&amp;#xD;&#xd;&#xa;        if [ -z &quot;$retVal&quot; ]; #not a rac database&amp;#xD;&#xd;&#xa;        then&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;        export ORACLE_HOME=$oracle_home&amp;#xD;&#xd;&#xa;        sidNames=`$oracle_home/bin/srvctl status database -d $dbname|grep running|awk ''{print $2}''`&amp;#xD;&#xd;&#xa;        printf -v dbs &quot;$dbs\n$sidNames&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        return 0&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;GetInstanceList()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        dbs=`egrep -i &quot;:Y|:N&quot;  /etc/oratab | cut -d&quot;:&quot; -f1  | grep -v &quot;\#&quot; | grep -v &quot;\*&quot; | grep -v &quot;^+&quot; | grep -v &quot;^-&quot;`&amp;#xD;&#xd;&#xa;        for db in $dbs&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_SID=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''/ora_pmon_/ { n = split($NF, a, &quot;ora_pmon_&quot;); if(n &amp;gt; 1) printf(&quot;%s&quot;,  a[n]); }''`&amp;#xD;&#xd;&#xa;                if [ -z &quot;$ORACLE_SID&quot; ];&amp;#xD;&#xd;&#xa;                then&amp;#xD;&#xd;&#xa;                    #SID is not same as DBNAME, lets get SID names&amp;#xD;&#xd;&#xa;                    oracle_home=`cat /etc/oratab | grep &quot;^$db&quot; | cut -d &quot;:&quot; -f2`&amp;#xD;&#xd;&#xa;                    if [ -z $oracle_home ];&amp;#xD;&#xd;&#xa;                    then&amp;#xD;&#xd;&#xa;                        echo &quot;$db is not found in oratab&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                    else&amp;#xD;&#xd;&#xa;                        GetRacSIDList $db $oracle_home&amp;#xD;&#xd;&#xa;                    fi&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;                done&amp;#xD;&#xd;&#xa;        for db in $dbs&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;            ORACLE_SID=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''/ora_pmon_/ { n = split($NF, a, &quot;ora_pmon_&quot;); if(n &amp;gt; 1) printf(&quot;%s&quot;,  a[n]); }''`&amp;#xD;&#xd;&#xa;            if [ -z &quot;$ORACLE_SID&quot; ];&amp;#xD;&#xd;&#xa;            then&amp;#xD;&#xd;&#xa;                echo &quot;$db is down. skipping&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                            continue;&amp;#xD;&#xd;&#xa;            fi&amp;#xD;&#xd;&#xa;            ORACLE_USER=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | cut -d &quot; &quot; -f1`&amp;#xD;&#xd;&#xa;            ORACLE_HOME=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''{print $2}'' | xargs pwdx | awk ''{print $2}'' | sed -e ''s/\/dbs//g''`&amp;#xD;&#xd;&#xa;            echo &quot;found active Oracle instance  ORACLE_SID=$ORACLE_SID, ORACLE_HOME=$ORACLE_HOME, ORACLE_USER=$ORACLE_USER&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;            ORACLE_USER_LIST[$ORACLE_NUM]=&quot;$ORACLE_USER&quot;&amp;#xD;&#xd;&#xa;            ORACLE_HOME_LIST[$ORACLE_NUM]=&quot;$ORACLE_HOME&quot;&amp;#xD;&#xd;&#xa;            ORACLE_SID_LIST[$ORACLE_NUM]=&quot;$ORACLE_SID&quot;&amp;#xD;&#xd;&#xa;            ORACLE_NUM=$((ORACLE_NUM+1))&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;UnQuiesceAllInstances()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        unq_ret=0&amp;#xD;&#xd;&#xa;        num=0&amp;#xD;&#xd;&#xa;        while [[ $num -lt $ORACLE_NUM ]]&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_USER=${ORACLE_USER_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_HOME=${ORACLE_HOME_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_SID=${ORACLE_SID_LIST[$num]}&amp;#xD;&#xd;&#xa;                num=$((num+1))&amp;#xD;&#xd;&#xa;                SQLPLUS=$ORACLE_HOME/bin/sqlplus&amp;#xD;&#xd;&#xa;                CONN_NAME=&quot;/ as sysdba&quot;&amp;#xD;&#xd;&#xa;                export ORACLE_SID ORACLE_HOME&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #check if sqlplus exists&amp;#xD;&#xd;&#xa;                if [ ! -f ${SQLPLUS} ];then&amp;#xD;&#xd;&#xa;                echo &quot;Unable to find sqlplus executable at ${SQLPLUS} &quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                echo $(date) begin unquiescing Oracle SID $ORACLE_SID SQLPLUS=$SQLPLUS &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su $ORACLE_USER -c &quot;&amp;#xD;&#xd;&#xa;$SQLPLUS -S /nolog  &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;        connect / as sysdba&amp;#xD;&#xd;&#xa;        alter database end backup;&amp;#xD;&#xd;&#xa;        alter system archive log current;&amp;#xD;&#xd;&#xa;        exit;&amp;#xD;&#xd;&#xa;EOF&quot; | tee -a $LOGDIR/$LOGFILE | grep -E -v &quot;ORA-01142&quot; | grep -v &quot;grep&quot; | grep -c &quot;ORA-&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #if unquiesce is completed, we do not get any ORA- errors and $? will be non-zero&amp;#xD;&#xd;&#xa;                if [ &quot;$?&quot; -ne 0 ]; then&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: success  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                else&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: Failure  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                        # continue unquiecing the next instance as we do not want to leave anything quiesced&amp;#xD;&#xd;&#xa;                        # return 1&amp;#xD;&#xd;&#xa;                        unq_ret=1&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        #quiesced all instances successfully&amp;#xD;&#xd;&#xa;        return $unq_ret&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;LOGDIR=/tmp&amp;#xD;&#xd;&#xa;LOGFILE=quiesce.log&amp;#xD;&#xd;&#xa;export LOGDIR LOGFILE&amp;#xD;&#xd;&#xa;ret=0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;echo $1 $(date ;id;hostname) &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;# get all running Oracle instances&amp;#xD;&#xd;&#xa;GetInstanceList&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;#quiesce all Oracle instances&amp;#xD;&#xd;&#xa;if [ &quot;$1&quot; = &quot;quiesce&quot; ]; then&amp;#xD;&#xd;&#xa;        QuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa; fi&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;        #unquiesce all Oracle instances&amp;#xD;&#xd;&#xa;        UnQuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;exit $ret&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>unquiesce&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Switch_3" commented="0" originalStyle=""

            points="" sourceX="879" sourceY="525" status="0"

            style="defaultEdge" targetX="1106" targetY="642"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559250200274" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="132" y="679">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Workflow Execution Completed Successfully&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559275010622"

        description="retrieves a list of values from xml"

        displayName="Get JobID" height="34" interactive="0" jobMode="0"

        name="XPathQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.XMLQueryActivity"

        uniqueName="XPathQuery_2" waitSetting="0" width="100" x="679" y="43">

        <inputs val="&lt;inputs>&lt;xml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Execute_1/outputXml}&lt;/xml>&lt;xpath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/TMMsg_CreateTaskResp/jobIds[1]/@val&lt;/xpath>&lt;outputType class=&quot;workflow.types.SimpleType&quot; _list_=&quot;false&quot;>String&lt;/outputType>&lt;outputAsList class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/outputAsList>&lt;/inputs>"/>

        <transition activity="Job_1" commented="0" originalStyle=""

            points="922.0,63.0" sourceX="729" sourceY="60" status="0"

            style="defaultEdge" targetX="740" targetY="146"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559312154977"

        description="iterates a group of activities over a list of values"

        displayName="Archivelog Backups ForEach Instance" height="353"

        interactive="0" jobMode="0" name="ForEach"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ForEach_1" waitSetting="0" width="352" x="307" y="520">

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <superProcess>

            <Start commented="0" continueOnFailure="0"

                created="1559312154977" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="102" y="32">

                <inputs val="&lt;inputs />"/>

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="162"

                    sourceY="47" status="0" style="defaultEdge"

                    targetX="153" targetY="96" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Start>

            <Activity commented="0" continueOnFailure="0"

                created="1559312508362" description=""

                displayName="Oracle standalone backups" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="Execute_2" waitSetting="0" width="186"

                x="15" y="193">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;UTF-8&quot; standalone=&quot;no&quot; ?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;appName&amp;gt;Oracle&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;backupsetName&amp;gt;default&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[1]}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;instanceName&amp;gt;xpath:{/workflow/ForEach_1/row/col[3]}&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subclientName&amp;gt;ArchiveLog&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;backupLevel&amp;gt;&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;enforceTransactionLogUsage&amp;gt;true&amp;lt;/enforceTransactionLogUsage&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;followMountPoints&amp;gt;true&amp;lt;/followMountPoints&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;skipConsistencyCheck&amp;gt;false&amp;lt;/skipConsistencyCheck&amp;gt;&amp;#xD;&#xd;&#xa;            &amp;lt;useCatalogServer&amp;gt;true&amp;lt;/useCatalogServer&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;/dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;doNotTruncateLog&amp;gt;false&amp;lt;/doNotTruncateLog&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;incLevel&amp;gt;BEFORE_SYNTH&amp;lt;/incLevel&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;mediaOpt/&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;runIncrementalBackup&amp;gt;true&amp;lt;/runIncrementalBackup&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;sybaseSkipFullafterLogBkp&amp;gt;false&amp;lt;/sybaseSkipFullafterLogBkp&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;truncateLogsOnSource&amp;gt;false&amp;lt;/truncateLogsOnSource&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;          &amp;lt;perfJobOpts/&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;operationType&amp;gt;BACKUP&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;subTaskType&amp;gt;BACKUP&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xd;&#xa;    &amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&lt;/inputXml>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1560137560180"

                description="if/else based decision"

                displayName="Is RAC ?" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="100" x="120" y="83">

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ForEach_1/row/col[2]}.equals(&quot;Oracle RAC&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

                <transition activity="Execute_3" commented="0"

                    displayName="yes" originalStyle=""

                    points="275.0,133.0" sourceX="170" sourceY="133"

                    status="0" style="defaultEdge" targetX="246"

                    targetY="190" transitionIndex="0" value="True" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="Execute_2" commented="0"

                    displayName="no" originalStyle=""

                    points="65.0,133.0" sourceX="170" sourceY="133"

                    status="0" style="defaultEdge" targetX="84"

                    targetY="182" transitionIndex="0" value="False"

                    x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1560138051348" description=""

                displayName="RAC backups" height="34" interactive="0"

                jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationExecute"

                uniqueName="Execute_3" waitSetting="0" width="106"

                x="223" y="195">

                <inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&amp;lt;?xml version=&quot;1.0&quot; encoding=&quot;ISO-8859-1&quot;?&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;associations&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;appName&amp;gt;Oracle RAC&amp;lt;/appName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupsetName/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[1]}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;instanceName&amp;gt;xpath:{/workflow/ForEach_1/row/col[3]}&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subclientName&amp;gt;ArchiveLog&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/associations&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;options&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupLevel&amp;gt;FULL&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;createNewIndex&amp;gt;false&amp;lt;/createNewIndex&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;enforceTransactionLogUsage&amp;gt;false&amp;lt;/enforceTransactionLogUsage&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;followMountPoints&amp;gt;true&amp;lt;/followMountPoints&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;skipConsistencyCheck&amp;gt;false&amp;lt;/skipConsistencyCheck&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;useCatalogServer&amp;gt;false&amp;lt;/useCatalogServer&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/dataOpt&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;doNotTruncateLog&amp;gt;false&amp;lt;/doNotTruncateLog&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;incLevel&amp;gt;BEFORE_SYNTH&amp;lt;/incLevel&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;mediaOpt/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;oracleOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupArchLogOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;!--Enable Backup Archive Log--&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupArchiveLog&amp;gt;true&amp;lt;/backupArchiveLog&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupArchiveLogCriteria&amp;gt;ALL&amp;lt;/backupArchiveLogCriteria&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;endLSN&amp;gt;1&amp;lt;/endLSN&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;startLSN&amp;gt;1&amp;lt;/startLSN&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/backupArchLogOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;cumulative&amp;gt;false&amp;lt;/cumulative&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;deleteArchLogOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;backupArchiveLogCriteria&amp;gt;NONE&amp;lt;/backupArchiveLogCriteria&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/deleteArchLogOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;level&amp;gt;1&amp;lt;/level&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;tag/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/oracleOptions&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;runIncrementalBackup&amp;gt;true&amp;lt;/runIncrementalBackup&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;sybaseSkipFullafterLogBkp&amp;gt;false&amp;lt;/sybaseSkipFullafterLogBkp&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;truncateLogsOnSource&amp;gt;false&amp;lt;/truncateLogsOnSource&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;perfJobOpts/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/options&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTask&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;operationType&amp;gt;BACKUP&amp;lt;/operationType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;subTaskType&amp;gt;BACKUP&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/subTask&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/subTasks&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;task&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;taskType/&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/task&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xd;&#xa;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&lt;/inputXml>&lt;escapeXml class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/escapeXml>&lt;commandArgs class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

        </superProcess>

        <activitySchema>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

        </activitySchema>

        <transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" points="" sourceX="483" sourceY="696"

            status="0" style="defaultEdge" targetX="196" targetY="643"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1559832231064"

        description="executes queries against a commcell database"

        displayName="CommServDBQuery" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="143"

        x="800" y="709">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>DECLARE @phyClientID INT= ''xpath:{/workflow/inputs/OracleClient/clientId}''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT APP_Client.name, APP_iDAType.displayName, APP_InstanceName.name&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;FROM   APP_Application&amp;#xD;&#xd;&#xa;INNER JOIN  APP_Client&amp;#xD;&#xd;&#xa;      ON APP_Application.clientId=APP_Client.id&amp;#xD;&#xd;&#xa;      INNER JOIN APP_InstanceName&amp;#xD;&#xd;&#xa;      ON APP_Application.instance = APP_InstanceName.id&amp;#xD;&#xd;&#xa;&#x9;  INNER JOIN APP_iDAType&amp;#xD;&#xd;&#xa;&#x9;  on APP_Application.appTypeId=APP_iDAType.type&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHERE  appTypeId = 22 AND clientID = @phyClientID and (subclientStatus &amp;amp; 262144) &amp;lt;&amp;gt; 0 AND APP_InstanceName.name not like (''+%'')&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;UNION&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;SELECT APP_Client.name, APP_iDAType.displayName, APP_InstanceName.name&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;FROM   APP_Application&amp;#xD;&#xd;&#xa;INNER JOIN  APP_Client&amp;#xD;&#xd;&#xa;      ON APP_Application.clientId=APP_Client.id&amp;#xD;&#xd;&#xa;      INNER JOIN APP_InstanceName&amp;#xD;&#xd;&#xa;      ON APP_Application.instance = APP_InstanceName.id&amp;#xD;&#xd;&#xa;&#x9;  INNER JOIN APP_iDAType&amp;#xD;&#xd;&#xa;&#x9;  on APP_Application.appTypeId=APP_iDAType.type&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;WHERE  appTypeId = 80 AND instance in (SELECT instaceId FROM APP_OracleRACInstance WHERE clientID = @phyClientId )&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;       AND (subclientStatus &amp;amp; 262144) &amp;lt;&amp;gt; 0&amp;#xD;&#xd;&#xa;&#x9;   AND APP_InstanceName.name not like (''+%'')&amp;#xD;&#xd;&#xa;&#x9;   &amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="708.0,632.0" sourceX="946" sourceY="205" status="0"

            style="defaultEdge" targetX="629" targetY="208"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560960662404" description="switch based decision"

        displayName="Check Current Status" height="178" interactive="0"

        jobMode="0" name="Switch"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_1" waitSetting="0" width="200" x="836" y="232">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/Job_1/job/status}&lt;/expression>&lt;/inputs>"/>

        <transition activity="ExecuteScript_2" commented="0"

            displayName="Completed" originalStyle="" points=""

            sourceX="1030" sourceY="60" status="0" style="defaultEdge"

            targetX="1031" targetY="170" transitionIndex="0"

            value="Completed" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Delay_2" commented="0"

            displayName="Waiting" originalStyle="" points="630.0,324.0"

            sourceX="901" sourceY="201" status="0" style="defaultEdge"

            targetX="1037" targetY="115" transitionIndex="0"

            value="Waiting" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Delay_3" commented="0"

            displayName="Queued " originalStyle="" points="808.0,326.0"

            sourceX="901" sourceY="201" status="0" style="defaultEdge"

            targetX="772" targetY="269" transitionIndex="0"

            value="Queued" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Delay_1" commented="0"

            displayName="Running" offsetX="-33" offsetY="0"

            originalStyle="" points="798.0,188.0" sourceX="936"

            sourceY="321" status="0" style="defaultEdge" targetX="793"

            targetY="211" transitionIndex="0" value="Running" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Script_3" commented="0"

            displayName="Suspended" offsetX="-3" offsetY="-1"

            originalStyle="" points="" sourceX="890" sourceY="146"

            status="0" style="defaultEdge" targetX="985" targetY="235"

            transitionIndex="0" value="suspended" x="0" y="1">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Script_4" commented="0"

            displayName="FAILED" originalStyle="" points=""

            sourceX="890" sourceY="146" status="0" style="defaultEdge"

            targetX="1140" targetY="163" transitionIndex="0"

            value="FAILED" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="ExecuteScript_4" commented="0"

            displayName="Killed" offsetX="-78" offsetY="1"

            originalStyle="" points="1156.0,484.0" sourceX="901"

            sourceY="201" status="0" style="defaultEdge" targetX="1123"

            targetY="428" transitionIndex="0" value="Killed" x="1" y="-2">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="JobControl_2" commented="0"

            displayName="Pending" offsetX="-96" offsetY="0"

            originalStyle="" points="1135.0,321.0" sourceX="890"

            sourceY="146" status="0" style="defaultEdge" targetX="1042"

            targetY="51" transitionIndex="0" value="Pending" x="1" y="17">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Script_5" commented="0"

            displayName="Terminated" originalStyle=""

            points="1214.0,320.0" sourceX="936" sourceY="321" status="0"

            style="defaultEdge" targetX="1310" targetY="403"

            transitionIndex="0" value="Terminated" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560961063633"

        description="activity to delay the workflow execution in minutes"

        displayName="Sleep 30 sec&#xd;&#xa;" height="52" interactive="0"

        jobMode="0" name="Delay"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.DelayActivity"

        uniqueName="Delay_1" waitSetting="0" width="103" x="742" y="185">

        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>30&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

        <transition activity="Job_1" commented="0" originalStyle=""

            points="750.0,162.0" sourceX="764" sourceY="210" status="0"

            style="defaultEdge" targetX="844" targetY="128"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560961685866" description=""

        displayName="Fetch Job Status" height="34" interactive="0"

        jobMode="0" name="Job"

        namespaceUri="commvault.cte.workflow.activities.cmd.list"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.cmd.list.ListJob"

        uniqueName="Job_1" waitSetting="0" width="125" x="867" y="117">

        <inputs val="&lt;inputs>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/XPathQuery_2/result}&lt;/jobId>&lt;jobType class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Backup&lt;/jobType>&lt;jobStatus class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/VSAClient/clientName}&lt;/client>&lt;dataAgent class=&quot;workflow.types.cmd.DataAgent&quot; _list_=&quot;false&quot;>Q_VIRTUAL_SERVER&lt;/dataAgent>&lt;instance class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>VMWare&lt;/instance>&lt;backupSet class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/BackupSet}&lt;/backupSet>&lt;subClient class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/VSASubclient}&lt;/subClient>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" originalStyle=""

            points="938.0,197.0" sourceX="742" sourceY="151" status="0"

            style="defaultEdge" targetX="893" targetY="146"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560963382686" description=""

        displayName="Kill VSA Backup" height="34" interactive="0"

        jobMode="0" name="JobControl"

        namespaceUri="commvault.cte.workflow.activities.cmd.operation"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.cmd.operation.OperationJobControl"

        uniqueName="JobControl_2" waitSetting="0" width="134" x="1426" y="304">

        <inputs val="&lt;inputs>&lt;operation class=&quot;workflow.types.cmd.JobOperation&quot; _list_=&quot;false&quot;>kill&lt;/operation>&lt;jobId class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>xpath:{/workflow/XPathQuery_2/result}&lt;/jobId>&lt;priority class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

        <transition activity="ExecuteScript_4" commented="0"

            originalStyle="" points="" sourceX="1493" sourceY="321"

            status="0" style="defaultEdge" targetX="1550" targetY="523"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560963391854"

        description="Execute a script on a remote machine"

        displayName="unquiesce the databases on oracle client"

        height="76" interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ExecuteScript"

        uniqueName="ExecuteScript_4" waitSetting="0" width="328"

        x="1386" y="485">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/OracleClient/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot; _list_=&quot;false&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>#!/bin/sh&amp;#xD;&#xd;&#xa;#no of oracle instance running&amp;#xD;&#xd;&#xa;ORACLE_NUM=0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;GetInstanceList()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        dbs=`egrep -i &quot;:Y|:N&quot;  /etc/oratab | cut -d&quot;:&quot; -f1  | grep -v &quot;\#&quot; | grep -v &quot;\*&quot; | grep -v &quot;^+&quot; | grep -v &quot;^-&quot;`&amp;#xD;&#xd;&#xa;        for db in $dbs&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_SID=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | awk ''/ora_pmon_/ { n = split($NF, a, &quot;ora_pmon_&quot;); if(n &amp;gt; 1) printf(&quot;%s&quot;,  a[n]); }''`&amp;#xD;&#xd;&#xa;                if [ -z &quot;$ORACLE_SID&quot; ];&amp;#xD;&#xd;&#xa;                then&amp;#xD;&#xd;&#xa;                        echo &quot;$db is down. skipping&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                        continue;&amp;#xD;&#xd;&#xa;                else&amp;#xD;&#xd;&#xa;                        ORACLE_USER=`ps -ef | grep ora_pmon_$db | grep -v &quot;grep&quot; | cut -d &quot; &quot; -f1`&amp;#xD;&#xd;&#xa;                        ORACLE_HOME=`cat /etc/oratab | grep &quot;^$db&quot; | cut -d &quot;:&quot; -f2`&amp;#xD;&#xd;&#xa;                        echo &quot;found active Oracle instance  ORACLE_SID=$ORACLE_SID, ORACLE_HOME=$ORACLE_HOME, ORACLE_USER=$ORACLE_USER&quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                        ORACLE_USER_LIST[$ORACLE_NUM]=&quot;$ORACLE_USER&quot;&amp;#xD;&#xd;&#xa;                        ORACLE_HOME_LIST[$ORACLE_NUM]=&quot;$ORACLE_HOME&quot;&amp;#xD;&#xd;&#xa;                        ORACLE_SID_LIST[$ORACLE_NUM]=&quot;$ORACLE_SID&quot;&amp;#xD;&#xd;&#xa;                        ORACLE_NUM=$((ORACLE_NUM+1))&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;UnQuiesceAllInstances()&amp;#xD;&#xd;&#xa;{&amp;#xD;&#xd;&#xa;        unq_ret=0&amp;#xD;&#xd;&#xa;        num=0&amp;#xD;&#xd;&#xa;        while [[ $num -lt $ORACLE_NUM ]]&amp;#xD;&#xd;&#xa;        do&amp;#xD;&#xd;&#xa;                ORACLE_USER=${ORACLE_USER_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_HOME=${ORACLE_HOME_LIST[$num]}&amp;#xD;&#xd;&#xa;                ORACLE_SID=${ORACLE_SID_LIST[$num]}&amp;#xD;&#xd;&#xa;                num=$((num+1))&amp;#xD;&#xd;&#xa;                SQLPLUS=$ORACLE_HOME/bin/sqlplus&amp;#xD;&#xd;&#xa;                CONN_NAME=&quot;/ as sysdba&quot;&amp;#xD;&#xd;&#xa;                export ORACLE_SID ORACLE_HOME&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #check if sqlplus exists&amp;#xD;&#xd;&#xa;                if [ ! -f ${SQLPLUS} ];then&amp;#xD;&#xd;&#xa;                echo &quot;Unable to find sqlplus executable at ${SQLPLUS} &quot; &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                return 1;&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                echo $(date) begin unquiescing Oracle SID $ORACLE_SID SQLPLUS=$SQLPLUS &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;su $ORACLE_USER -c &quot;&amp;#xD;&#xd;&#xa;$SQLPLUS -S /nolog  &amp;lt;&amp;lt;EOF&amp;#xD;&#xd;&#xa;        connect / as sysdba&amp;#xD;&#xd;&#xa;        alter database end backup;&amp;#xD;&#xd;&#xa;        alter system archive log current;&amp;#xD;&#xd;&#xa;        exit;&amp;#xD;&#xd;&#xa;EOF&quot; | tee -a $LOGDIR/$LOGFILE | grep -E -v &quot;ORA-01142&quot; | grep -v &quot;grep&quot; | grep -c &quot;ORA-&quot;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;                #if unquiesce is completed, we do not get any ORA- errors and $? will be non-zero&amp;#xD;&#xd;&#xa;                if [ &quot;$?&quot; -ne 0 ]; then&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: success  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                else&amp;#xD;&#xd;&#xa;                        echo $(date) unquiescing Oracle SID $ORACLE_SID: Failure  &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;                        # continue unquiecing the next instance as we do not want to leave anything quiesced&amp;#xD;&#xd;&#xa;                        # return 1&amp;#xD;&#xd;&#xa;                        unq_ret=1&amp;#xD;&#xd;&#xa;                fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        done&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;        #quiesced all instances successfully&amp;#xD;&#xd;&#xa;        return $unq_ret&amp;#xD;&#xd;&#xa;}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;LOGDIR=/tmp&amp;#xD;&#xd;&#xa;LOGFILE=quiesce.log&amp;#xD;&#xd;&#xa;export LOGDIR LOGFILE&amp;#xD;&#xd;&#xa;ret=0&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;echo $1 $(date ;id;hostname) &amp;gt;&amp;gt; $LOGDIR/$LOGFILE&amp;#xD;&#xd;&#xa;# get all running Oracle instances&amp;#xD;&#xd;&#xa;GetInstanceList&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;#quiesce all Oracle instances&amp;#xD;&#xd;&#xa;if [ &quot;$1&quot; = &quot;quiesce&quot; ]; then&amp;#xD;&#xd;&#xa;        QuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa; fi&amp;#xD;&#xd;&#xa;else&amp;#xD;&#xd;&#xa;        #unquiesce all Oracle instances&amp;#xD;&#xd;&#xa;        UnQuiesceAllInstances&amp;#xD;&#xd;&#xa;        if [ $? -ne 0 ] ; then&amp;#xD;&#xd;&#xa;                ret=1&amp;#xD;&#xd;&#xa;        fi&amp;#xD;&#xd;&#xa;fi&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;exit $ret&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>unquiesce&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_3" commented="0"

            originalStyle="" points="" sourceX="1550" sourceY="523"

            status="0" style="defaultEdge" targetX="1795" targetY="523"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560963588978" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_3" waitSetting="0" width="106" x="1742" y="506">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>VM Backup did not complete successfully. Please check the vsbkp and WorkfFlowEngine log files.&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560966509786"

        description="activity to delay the workflow execution in minutes"

        displayName="Sleep 30 sec" height="33" interactive="0"

        jobMode="0" name="Delay"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.DelayActivity"

        uniqueName="Delay_2" waitSetting="0" width="104" x="585" y="239">

        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>30&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

        <transition activity="Job_1" commented="0" originalStyle=""

            points="616.0,184.0" sourceX="1074" sourceY="115" status="0"

            style="defaultEdge" targetX="933" targetY="49"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560966850932"

        description="activity to delay the workflow execution in minutes"

        displayName="Sleep 30 sec" height="34" interactive="0"

        jobMode="0" name="Delay"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.DelayActivity"

        uniqueName="Delay_3" waitSetting="0" width="104" x="526" y="385">

        <inputs val="&lt;inputs>&lt;delayLength class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>30&lt;/delayLength>&lt;delayInterval class=&quot;workflow.types.DelayInterval&quot; _list_=&quot;false&quot;>Seconds&lt;/delayInterval>&lt;/inputs>"/>

        <transition activity="Job_1" commented="0" originalStyle=""

            points="540.0,253.0" sourceX="745" sourceY="260" status="0"

            style="defaultEdge" targetX="858" targetY="58"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560968062247"

        description="activity to execute code snippets in the selected language"

        displayName="Proceed to Kill" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_3" waitSetting="0" width="124" x="1398" y="168">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

        <transition activity="JobControl_2" commented="0"

            originalStyle="" points="" sourceX="1321" sourceY="171"

            status="0" style="defaultEdge" targetX="1327" targetY="372"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560968107546"

        description="activity to execute code snippets in the selected language"

        displayName="Proceed to unquiesce" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_4" waitSetting="0" width="180" x="1280" y="65">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

        <transition activity="ExecuteScript_4" commented="0"

            originalStyle="" points="1613.0,202.0" sourceX="1141"

            sourceY="188" status="0" style="defaultEdge" targetX="1255"

            targetY="336" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1560976907307"

        description="activity to execute code snippets in the selected language"

        displayName="Proceed to Kill" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ScriptActivity"

        uniqueName="Script_5" waitSetting="0" width="124" x="1340" y="400">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;&quot; />&lt;/inputs>"/>

        <transition activity="JobControl_2" commented="0"

            originalStyle="" points="" sourceX="1402" sourceY="417"

            status="0" style="defaultEdge" targetX="1458" targetY="317"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1584934542517" description="switch based decision"

        displayName="Switch" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_3" waitSetting="0" width="100" x="1093" y="806">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/ArchiveLogBackup}&lt;/expression>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_1" commented="0"

            displayName="LogBackupUp" originalStyle="" points=""

            sourceX="1115" sourceY="804" status="0" style="defaultEdge"

            targetX="940" targetY="730" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_1" commented="0"

            displayName="NoLogBackup" originalStyle="" points=""

            sourceX="1224" sourceY="719" status="0" style="defaultEdge"

            targetX="175" targetY="709" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>'

-- Update Work Flow Definition

DECLARE @name NVARCHAR(256)

SELECT

    @name = d.value('@name', 'NVARCHAR(256)'),

	@description = d.value('@description', 'NVARCHAR(256)')

FROM @definition.nodes('/workflow') w(d)

IF not exists (select 1 from WF_Definition where uniqueGuid = @guid OR Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE uniqueGuid = @guid OR Name = @name

	if(@currentFlags&6>0 and (@currentRevision <> @revision))

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE WorkflowId = @workflowId

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE WorkflowId = @workflowId

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END
