

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_UnixCrashCrawler.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_UnixCrashCrawler.script,v $ $Id: WFD_UnixCrashCrawler.script,v 1.3 2015/06/05 16:36:29 csunderland Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.3 $'

SET @name = 'Unix Crash Crawler Deployer'

SET @description = 'Deploys UNIX crawler (on Linux/Solaris/AIX client)'

SET @version = 1

SET @flags = 14

SET @definition = '<workflow apiMode="0"

    description="Deploys UNIX crawler (On Linux/Solaris/AIX client)"

    inputSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_3a6104e5-99f4-4341-a561-84f372909327&quot; targetNamespace=&quot;S_3a6104e5-99f4-4341-a561-84f372909327&quot;>&lt;xs:element name=&quot;inputs&quot;>&lt;xs:complexType>&lt;xs:sequence />&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    inputs="&lt;inputs />" interactive="0" isHtmlDescription="0"

    name="WF_ALLClients"

    outputSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_2a2ea773-c2ac-4060-ab25-d079822cd040&quot; targetNamespace=&quot;S_2a2ea773-c2ac-4060-ab25-d079822cd040&quot;>&lt;xs:element name=&quot;outputs&quot;>&lt;xs:complexType>&lt;xs:sequence />&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    outputs="&lt;outputs />" revision="$Revision: 1.3 $"

    uniqueGuid="5e928293-c8ed-4786-ab93-383dcb224411"

    variableSchema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_a735fe05-5d65-4088-a5a7-61536c3be19b&quot; targetNamespace=&quot;S_a735fe05-5d65-4088-a5a7-61536c3be19b&quot;>&lt;xs:element name=&quot;variables&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;results&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; maxOccurs=&quot;unbounded&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;Failures&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; maxOccurs=&quot;unbounded&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;Success&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; maxOccurs=&quot;unbounded&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;controlType>TEXTBOX&lt;/controlType>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:schema>"

    variables="&lt;variables>&lt;results class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;Failures class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;Success class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;/variables>" workflowId="0">

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="-13" y="251">

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="17" sourceY="269"

            status="0" style="defaultEdge" targetX="124" targetY="270"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs />"/>

    </Start>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type=""/>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                defaultValue="" displayName="" documentation=""

                hidden="0" inputType="java.lang.String" listType="1"

                name="results" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="Failures" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="Success" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

    </schema>

    <Activity commented="0" continueOnFailure="0"

        created="1375455796166"

        description="iterates a group of activities over a list of values"

        displayName="ForEach" height="517" interactive="0"

        name="ForEach" namespaceUri="commvault.cte.workflow.activities"

        originalStyle=""

        schema="&lt;xs:schema xmlns:xs=&quot;http://www.w3.org/2001/XMLSchema&quot; xmlns:tns=&quot;S_12ee6acc-6c62-4e68-a2b8-2290371eb573&quot; xmlns:workflow.types.data=&quot;workflow.types.data&quot; targetNamespace=&quot;S_12ee6acc-6c62-4e68-a2b8-2290371eb573&quot;>&lt;xs:import namespace=&quot;workflow.types.data&quot; schemaLocation=&quot;workflow.types.data&quot; />&lt;xs:complexType name=&quot;ForEach&quot;>&lt;xs:sequence>&lt;xs:element name=&quot;inputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;name&quot; type=&quot;xs:string&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;values&quot; type=&quot;xs:anyType&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;numberOfParallelExecutions&quot; type=&quot;xs:integer&quot; minOccurs=&quot;0&quot; default=&quot;1&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;xs:element name=&quot;continueOnFailure&quot; type=&quot;xs:boolean&quot; minOccurs=&quot;0&quot; default=&quot;false&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;xs:element name=&quot;outputs&quot;>&lt;xs:complexType>&lt;xs:sequence>&lt;xs:element name=&quot;row&quot; type=&quot;workflow.types.data:DataRow&quot; minOccurs=&quot;0&quot; default=&quot;&quot;>&lt;xs:annotation>&lt;xs:appinfo>&lt;readOnly>false&lt;/readOnly>&lt;displayName>&lt;/displayName>&lt;/xs:appinfo>&lt;xs:documentation>&lt;/xs:documentation>&lt;/xs:annotation>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:element>&lt;/xs:sequence>&lt;/xs:complexType>&lt;/xs:schema>"

        skipAttempt="0" style="swimlane" uniqueName="ForEach_1"

        waitSetting="0" width="785" x="330" y="79">

        <superProcess>

            <Activity commented="0" continueOnFailure="1"

                created="1375449724518" description=""

                displayName="Check Readiness" height="34"

                interactive="0" maxRestarts="0" name="CheckReady"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=CheckReady" uniqueName="CheckReady_1"

                waitSetting="0" width="142" x="30" y="97">

                <transition activity="Decision_1" commented="0"

                    originalStyle="" points="" sourceX="435"

                    sourceY="52" status="0" style="defaultEdge"

                    targetX="456" targetY="341" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;reportType class=&quot;workflow.types.cmd.ReportInformationType&quot;>Summary&lt;/reportType>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; />&lt;token class=&quot;java.lang.String&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1375450349003"

                description="if/else based decision"

                displayName="Ready ?" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_1"

                waitSetting="0" width="115" x="234" y="65">

                <transition activity="ExecuteCommand_1" commented="0"

                    displayName="Yes" originalStyle="" points=""

                    sourceX="291" sourceY="115" status="0"

                    style="defaultEdge" targetX="421" targetY="111"

                    transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="AddToList_1" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="291" sourceY="115" status="0"

                    style="defaultEdge" targetX="281" targetY="264"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/CheckReady_1/exitCode} == 0&lt;/expression>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1345146725290"

                description="Execute a list of commands"

                displayName="Fetch" height="34" interactive="0"

                maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_1" waitSetting="0"

                width="147" x="429" y="97">

                <transition activity="ExecuteCommand_2" commented="0"

                    originalStyle="" points="" sourceX="490"

                    sourceY="113" status="0" style="defaultEdge"

                    targetX="490" targetY="160" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>cvpscp.exe&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>-pw ''cv_uslinux642'' root@uslinux642.commvault.com:/crash-crawler/ClientSide/* /tmp&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1372250537261"

                description="Execute a list of commands"

                displayName="Permissions" height="34" interactive="0"

                maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_2" waitSetting="0"

                width="147" x="425" y="157">

                <transition activity="ExecuteCommand_3" commented="0"

                    originalStyle="" points="" sourceX="498"

                    sourceY="174" status="0" style="defaultEdge"

                    targetX="498" targetY="227" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>chmod&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>+x /tmp/crashcrawlerv2.sh /tmp/crashinstaller /tmp/log&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="1"

                created="1372250642600"

                description="Execute a list of commands"

                displayName="Install" height="34" interactive="0"

                maxRestarts="0" name="ExecuteCommand"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=ExecuteCommand"

                uniqueName="ExecuteCommand_3" waitSetting="0"

                width="147" x="424" y="221">

                <transition activity="Decision_2" commented="0"

                    originalStyle="" points="" sourceX="497"

                    sourceY="238" status="0" style="defaultEdge"

                    targetX="498" targetY="286" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;command class=&quot;java.lang.String&quot;>/tmp/crashinstaller&lt;/command>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1375464597545"

                description="if/else based decision"

                displayName="Installed ?" height="100" interactive="0"

                name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="Decision_2"

                waitSetting="0" width="100" x="448" y="283">

                <transition activity="AddToList_1" commented="0"

                    displayName="No" originalStyle="" points=""

                    sourceX="498" sourceY="333" status="0"

                    style="defaultEdge" targetX="294" targetY="272"

                    transitionIndex="0" value="false" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="AddToList_2" commented="0"

                    displayName="Yes" originalStyle="" sourceX="498"

                    sourceY="333" status="0" style="defaultEdge"

                    targetX="670" targetY="408" transitionIndex="0"

                    value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_3/exitCode} == 0&lt;/expression>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1375464922311"

                description="utility to add objects to a list"

                displayName="AddToFailures" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_1"

                waitSetting="0" width="124" x="234" y="255">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/Failures}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

            <Activity commented="0" continueOnFailure="0"

                created="1375464960990"

                description="utility to add objects to a list"

                displayName="AddToSuccess" height="34" interactive="0"

                name="AddToList"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=AddToList" uniqueName="AddToList_2"

                waitSetting="0" width="151" x="607" y="407">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/Success}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[1]}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

            <Start commented="0" continueOnFailure="0"

                created="1375455796166" description=""

                displayName="Start" height="30" interactive="0"

                name="Start" originalStyle="" skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_2" waitSetting="0" width="120" x="34" y="38">

                <transition activity="CheckReady_1" commented="0"

                    originalStyle="" points="" sourceX="107"

                    sourceY="50" status="0" style="defaultEdge"

                    targetX="113" targetY="152" transitionIndex="0"

                    x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs />"/>

            </Start>

        </superProcess>

        <transition activity="Email_1" commented="0" originalStyle=""

            points="" sourceX="503" sourceY="269" status="0"

            style="defaultEdge" targetX="1001" targetY="239"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>1&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>false&lt;/continueOnFailure>&lt;/inputs>"/>

        <activitySchema>

            <inputs>

                <children className="java.lang.String"

                    inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object"

                    inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1"

                    inputType="java.lang.Integer"

                    name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean"

                    defaultValue="false" inputType="java.lang.Boolean"

                    name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

            <outputs name="outputs">

                <children attribute="0"

                    className="workflow.types.data.DataRow"

                    defaultValue="" hidden="0"

                    inputType="workflow.types.data.DataRow" listType="0"

                    name="row" type="{workflow.types.data}DataRow">

                    <children attribute="0" className="java.lang.Object"

                        defaultValue="" hidden="0"

                        inputType="java.lang.Object" listType="1"

                        name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

        </activitySchema>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1375450577974"

        description="Sends an email to a list of users"

        displayName="Summary Email" height="34" interactive="0"

        name="Email" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Email"

        uniqueName="Email_1" waitSetting="0" width="133" x="1340" y="319">

        <inputs val="&lt;inputs>&lt;email class=&quot;workflow.types.Email&quot;>&lt;from class=&quot;java.lang.String&quot; />&lt;to class=&quot;java.lang.String&quot;>gparihar@commvault.com&lt;/to>&lt;cc class=&quot;java.lang.String&quot; />&lt;bcc class=&quot;java.lang.String&quot; />&lt;subject class=&quot;java.lang.String&quot;>UNIX Crash Crawler Deployment Report&lt;/subject>&lt;attachments class=&quot;java.lang.String&quot; />&lt;body class=&quot;java.lang.String&quot;>** Summary Report **&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CS:  xpath:{/workflow/system/commCellName}&amp;#xD;&#xd;&#xa;WFEngine:  xpath:{/workflow/system/workflowEngine/clientName}&amp;#xD;&#xd;&#xa;JobId:  xpath:{/workflow/system/jobId}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Success Clients :&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;xpath:{/workflow/variables/Success}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;Failure Clients :&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;xpath:{/workflow/variables/Failures}&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&lt;/body>&lt;html class=&quot;java.lang.Boolean&quot;>false&lt;/html>&lt;repeatInterval />&lt;/email>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1375689718592"

        description="executes queries against the commserv database"

        displayName="Retrieve clients" height="34" interactive="0"

        name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="162"

        x="118" y="252">

        <transition activity="ForEach_1" commented="0" originalStyle=""

            points="" sourceX="199" sourceY="269" status="0"

            style="defaultEdge" targetX="349" targetY="88"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT A.name&amp;#xD;&#xd;&#xa;From [CommServ].[dbo].[APP_Client] A&amp;#xD;&#xd;&#xa;INNER JOIN [CommServ].[dbo].[simOperatingSystem] B&amp;#xD;&#xd;&#xa;ON A.simOperatingSystemId = B.id&amp;#xD;&#xd;&#xa;WHERE B.Name IN (''Linux'',''SunOS'')&lt;/query>&lt;/inputs>"/>

    </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


