

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_StorageProvisioning.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_StorageProvisioning.script,v $ $Id: WFD_StorageProvisioning.script,v 1.6.2.2 2020/10/04 00:58:18 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.6.2.2 $'

SET @name = 'Storage Provisioning'

SET @description = 'Workflow to Provision New Storage'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow  apiMode="0" config="&lt;configuration />"

    description="Workflow to Provision New Storage"

    inputs="&lt;inputs>&lt;MMSProvManageLUNReq_Msg class=&quot;java.lang.String&quot; />&lt;/inputs>"

    interactive="1" isHtmlDescription="0" name="Storage Provisioning"

    outputs="&lt;outputs>&lt;MMSProvManageLUNResp_Msg class=&quot;workflow.types.XML&quot; />&lt;/outputs>"

    revision="$Revision: 1.6.2.2 $"

    uniqueGuid="b2064626-97d1-4d1a-ba3e-f5fc85977059"

    variables="&lt;variables>&lt;errorCode class=&quot;java.lang.Integer&quot; />&lt;errorString class=&quot;java.lang.String&quot; />&lt;RequestString class=&quot;java.lang.String&quot; />&lt;AttributeXML class=&quot;java.lang.String&quot; />&lt;instanceName class=&quot;java.lang.String&quot; />&lt;RequestStringWJId class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>" workflowId="0">

<schema>

	<outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type="">

		<children attribute="0" className="workflow.types.XML"

                controlType="1" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="workflow.types.XML" listType="0"

                name="MMSProvManageLUNResp_Msg" readOnly="0"

                required="0" type="{workflow.types}XML"/>

	</outputs>

	<variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

		<children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="errorCode" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="errorString" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="RequestString" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="AttributeXML" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="instanceName" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="RequestStringWJId" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

	</variables>

	<inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

		<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" name="MMSProvManageLUNReq_Msg" readOnly="0"

                required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

	</inputs>

	<config className="" name="" type=""/>

</schema>

<Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="47" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="63" x="73" y="301">

	<inputs val="&lt;inputs />"/>

	<inputs val=""/>

	<transition activity="ParseInput" commented="0" originalStyle=""

            points="" sourceX="93" sourceY="320" status="0"

            style="defaultEdge" targetX="229" targetY="313"

            transitionIndex="0" x="0" y="0">

		<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

	</transition>

</Start>

<Activity commented="0" continueOnFailure="0"

        created="1411677567064"

        description="creates a super process group"

        displayName="ProcessBlock" height="562" interactive="0"

        jobMode="0" maxRestarts="0" name="ProcessBlock"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="swimlane"

        uniqueName="ProcessBlock_3" waitSetting="0" width="671" x="575" y="43">

	<inputs val="&lt;inputs>&lt;inputs />&lt;/inputs>"/>

		<inputs val=""/>

		<superProcess>

			<Start commented="0" continueOnFailure="0"

                created="1411677567064" description=""

                displayName="Start" height="30" interactive="0"

                jobMode="0" name="Start" originalStyle=""

                skipAttempt="0"

                style="label;fillColor=#FFFF33;gradientColor=#FFFF00"

                uniqueName="Start_4" waitSetting="0" width="120" x="271" y="60">

				<inputs val="&lt;inputs />"/>

				<inputs val=""/>

				<transition activity="ManageLunRequest" commented="0"

                    originalStyle="" points="" sourceX="193"

                    sourceY="84" status="0" style="defaultEdge"

                    targetX="201" targetY="146" transitionIndex="0"

                    x="100" y="39">

					<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

				</transition>

			</Start>

			<Activity commented="0" continueOnFailure="0"

                created="1421107373936" description=""

                displayName="Manage LUN Request" height="34"

                interactive="0" jobMode="0" name="Execute"

                namespaceUri="commvault.cte.workflow.activities.cmd.operation"

                originalStyle="" skipAttempt="0"

                style="label;image=Execute"

                uniqueName="ManageLunRequest" waitSetting="0"

                width="170" x="248" y="135">

				<inputs val="&lt;inputs>&lt;inputXml class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/RequestStringWJId}&lt;/inputXml>&lt;commandArgs class=&quot;java.lang.String&quot; />&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

					<inputs val=""/>

					<transition activity="ValidateResponse" commented="0"

                    originalStyle="" points="" sourceX="333"

                    sourceY="152" status="0" style="defaultEdge"

                    targetX="333" targetY="233" transitionIndex="0"

                    x="0" y="0">

						<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

					</transition>

				</Activity>

				<Activity commented="0" continueOnFailure="0"

                created="1421107615177"

                description="returns a message to the caller of the workflow"

                displayName="To the Web Server" height="34"

                interactive="0" jobMode="0" name="GenericResponse"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=GenericResponse"

                uniqueName="ToWebServerSuccess" waitSetting="0"

                width="154" x="26" y="352">

					<inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/errorCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/AttributeXML}&lt;/errorMessage>&lt;/inputs>"/>

						<inputs val=""/>

					</Activity>

					<Activity commented="0" continueOnFailure="0"

                created="1425398169487"

                description="returns a message to the caller of the workflow"

                displayName="To the Web Server" height="34"

                interactive="0" jobMode="0" name="GenericResponse"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=GenericResponse"

                uniqueName="ToWebServerFailure" waitSetting="0"

                width="154" x="501" y="351">

						<onExit language="1" script="String sErrorMsg = workflow.getVariable(&quot;errorString&quot;);&#xd;&#xa;workflow.setFailed(sErrorMsg);&#xd;&#xa;"/>

						<inputs val="&lt;inputs>&lt;errorCode class=&quot;java.lang.Integer&quot;>xpath:{/workflow/variables/errorCode}&lt;/errorCode>&lt;errorMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/AttributeXML}&lt;/errorMessage>&lt;/inputs>"/>

							<inputs val=""/>

						</Activity>

						<Activity commented="0" continueOnFailure="0"

                created="1425398315705"

                description="if/else based decision"

                displayName="Make Decision" height="100" interactive="0"

                jobMode="0" name="Decision"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="rhombus;fontStyle=1" uniqueName="MakeDecision"

                waitSetting="0" width="151" x="256" y="319">

							<inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ValidateResponse/output}&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

								<inputs val=""/>

								<transition activity="ToWebServerFailure" commented="0"

                    displayName="false" originalStyle="" points=""

                    sourceX="306" sourceY="369" status="0"

                    style="defaultEdge" targetX="462" targetY="457"

                    transitionIndex="0" value="false" x="0" y="0">

									<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

								</transition>

								<transition activity="ToWebServerSuccess" commented="0"

                    displayName="True" originalStyle="" points=""

                    sourceX="331" sourceY="369" status="0"

                    style="defaultEdge" targetX="116" targetY="369"

                    transitionIndex="0" value="true" x="0" y="0">

									<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

								</transition>

							</Activity>

							<Activity commented="0" continueOnFailure="0"

                created="1425400619408"

                description="activity to execute code snippets in the selected language"

                displayName="Validate Response" height="34"

                interactive="0" jobMode="0" name="Script"

                namespaceUri="commvault.cte.workflow.activities"

                originalStyle="" skipAttempt="0"

                style="label;image=Script" uniqueName="ValidateResponse"

                waitSetting="0" width="151" x="256" y="223">

								<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.StorageProvisioning.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    String sRespXML = &amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;    boolean bManageOpResult = false;&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    MMSProvManageLUNResp oManageLunResp = (MMSProvManageLUNResp)XMLDecoder.decode(xpath:{/workflow/ManageLunRequest/commandOutput}); &amp;#xD;&amp;#xA;    MMSProvInfo oMMSProvInfo = oManageLunResp.getSprovInfo();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Error Code[&amp;quot; + oMMSProvInfo.getErrorCode() + &amp;quot;]&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;                         &amp;#xD;&amp;#xA;    if(oMMSProvInfo.getErrorCode() == 0)&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;ManageLUN operation successful&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        sRespXML = XMLEncoder.encode(oManageLunResp);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;AttributeXML&amp;quot;, sRespXML);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;errorCode&amp;quot;, oMMSProvInfo.getErrorCode());&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;errorString&amp;quot;, oMMSProvInfo.getErrorString());        &amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        bManageOpResult = true;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;ManageLUN operation failed&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        MMSProvManageLUNResp oManageLunRespToGUI = new MMSProvManageLUNResp();&amp;#xD;&amp;#xA;        MMSProvInfo oMMSProvInfoToGUI = new MMSProvInfo();&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        oMMSProvInfoToGUI.setErrorCode(oMMSProvInfo.getErrorCode());&amp;#xD;&amp;#xA;        oMMSProvInfoToGUI.setErrorString(oMMSProvInfo.getErrorString());&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        oManageLunRespToGUI.setSprovInfo(oMMSProvInfoToGUI);&amp;#xD;&amp;#xA;        sRespXML = XMLEncoder.encode(oManageLunRespToGUI);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;AttributeXML&amp;quot;, sRespXML);&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;errorCode&amp;quot;, oMMSProvInfo.getErrorCode());&amp;#xD;&amp;#xA;        workflow.setVariable(&amp;quot;errorString&amp;quot;, oMMSProvInfo.getErrorString());&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        bManageOpResult = false;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    return bManageOpResult;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while validating the response:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

									<inputs val=""/>

									<transition activity="MakeDecision" commented="0"

                    originalStyle="" points="" sourceX="331"

                    sourceY="240" status="0" style="defaultEdge"

                    targetX="327" targetY="340" transitionIndex="0"

                    x="0" y="0">

										<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

									</transition>

								</Activity>

							</superProcess>

							<activitySchema>

								<outputs attribute="0" className="" defaultValue=""

                listType="0" name="outputs" required="1" type=""/>

								<inputs attribute="0" className="" defaultValue=""

                listType="0" name="inputs" required="1" type=""/>

							</activitySchema>

						</Activity>

						<Activity commented="0" continueOnFailure="0"

        created="1411685124115"

        description="activity to execute code snippets in the selected language"

        displayName="Parse Input" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="ParseInput" waitSetting="0" width="119" x="216" y="307">

							<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;try &amp;#xD;&amp;#xA;{    &amp;#xD;&amp;#xA;    String reqXML = xpath:{/workflow/inputs/MMSProvManageLUNReq_Msg};&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RequestString&amp;quot;, reqXML);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Before adding the Job ID----------------------[&amp;quot; + reqXML + &amp;quot;]&amp;quot; );&amp;#xD;&amp;#xA;} &amp;#xD;&amp;#xA;catch (Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while converting XML to String. Error Details:&amp;quot;+ e.getMessage());         &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

								<inputs val=""/>

								<transition activity="AddJobId" commented="0" originalStyle=""

            points="" sourceX="300" sourceY="243" status="0"

            style="defaultEdge" targetX="434" targetY="239"

            transitionIndex="0" x="-14" y="48">

									<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

								</transition>

							</Activity>

							<Activity commented="0" continueOnFailure="0"

        created="1425332044577"

        description="activity to execute code snippets in the selected language"

        displayName="Add Job ID" height="34" interactive="0" jobMode="0"

        name="Script" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="AddJobId" waitSetting="0" width="102" x="383" y="307">

								<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.StorageProvisioning.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    MMSProvManageLUNReq oManageLunReq = (MMSProvManageLUNReq)XMLDecoder.decode(workflow.getVariable(&amp;quot;RequestString&amp;quot;)); &amp;#xD;&amp;#xA;    long lJobId = xpath:{/workflow/system/jobId};&amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;JOB ID is----------------------[&amp;quot; + xpath:{/workflow/system/jobId} + &amp;quot;]&amp;quot; );&amp;#xD;&amp;#xA;    oManageLunReq.getSprovInfo().getSprovParam().getSprovCommon().setJobId(lJobId);      &amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    String sReqXML = XMLEncoder.encode(oManageLunReq);&amp;#xD;&amp;#xA;    workflow.setVariable(&amp;quot;RequestStringWJId&amp;quot;, sReqXML);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;JOB ID set----------------------[&amp;quot; + workflow.getVariable(&amp;quot;RequestStringWJId&amp;quot;) + &amp;quot;]&amp;quot; );&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while adding JobId:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

									<inputs val=""/>

									<transition activity="ProcessBlock_3" commented="0"

            originalStyle="" points="" sourceX="464" sourceY="196"

            status="0" style="defaultEdge" targetX="583" targetY="52"

            transitionIndex="0" x="0" y="0">

										<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

									</transition>

								</Activity>

							</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

