

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_SnapProtectForOpenSystems.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_SnapProtectForOpenSystems.script,v $ $Id: WFD_SnapProtectForOpenSystems.script,v 1.6.2.7 2020/10/04 00:49:38 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.6.2.7 $'

SET @name = 'SnapProtect for Open Systems'

SET @description = 'Workflow to run SnapProtect for Open Systems based Snap Backups which backup data from windows and unix hosts to NetApp destination filers.'

SET @version = 1

DECLARE @value nvarchar(max) = ''

SELECT @value = ISNULL(value, '') FROM GXGlobalParam WHERE name = 'MiniBrandId'

IF (@value = '105' OR @value = '115')

BEGIN

    SET @flags = 14

END

ELSE

BEGIN

    SET @flags = 30

END

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Workflow to run SnapProtect for Open Systems based Snap Backups which backup data from windows and unix hosts to NetApp destination filers." executeOnWeb="0" inputs="&lt;inputs&gt;&lt;storagePolicy class=&quot;commvault.msgs.CvEntities.StoragePolicyEntity&quot;&gt;&lt;storagePolicyName /&gt;&lt;storagePolicyId /&gt;&lt;/storagePolicy&gt;&lt;backupType class=&quot;java.lang.String&quot;&gt;FULL&lt;/backupType&gt;&lt;followMountPaths class=&quot;java.lang.Boolean&quot;&gt;true&lt;/followMountPaths&gt;&lt;/inputs&gt;" interactive="0" isHtmlDescription="0" name="SnapProtect for Open Systems" outputs="&lt;outputs /&gt;" revision="$Revision: 1.6.2.7 $" tags="" uniqueGuid="68a41f8d-ca04-4926-93c0-b711703c1e44" variables="&lt;variables&gt;&lt;backupJobs class=&quot;java.lang.Long&quot; _list_=&quot;true&quot; /&gt;&lt;timeoutJobs class=&quot;java.lang.Long&quot; _list_=&quot;true&quot; /&gt;&lt;maxBackupTimeMinutes class=&quot;java.lang.Integer&quot;&gt;5&lt;/maxBackupTimeMinutes&gt;&lt;failedClients class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;/variables&gt;" webHidden="0" workflowId="24">

  <onStart language="1" script="String sql = &quot;Select a.jobId From JMAdminJobInfoTable a INNER JOIN JMJobInfo j ON a.jobId = j.jobId INNER JOIN JMJobStats s ON a.jobId = s.jobId Where s.status = 1 AND a.workFlowId = &quot; + xpath:{/workflow/system/workflow/workflowId} + &quot; AND j.jobDescription = ''&quot; + xpath:{/workflow/inputs/storagePolicy/storagePolicyName} + &quot;''&quot;;&#xD;&#xA;DataSet ds = csdb.execute(sql);&#xD;&#xA;if (ds.hasNext()) {&#xD;&#xA;    String msg = &quot;found running workflow job [&quot; + ds.get(&quot;jobId&quot;) + &quot;] for storage policy [&quot; + xpath:{/workflow/inputs/storagePolicy/storagePolicyName} + &quot;]&quot;;&#xD;&#xA;    logger.error(msg);&#xD;&#xA;    workflow.setFailed(msg);&#xD;&#xA;}&#xD;&#xA;" />

  <schema>

    <inputs attribute="0" className="" listType="0" name="inputs" required="1" type="">

      <children attribute="0" className="commvault.msgs.CvEntities.StoragePolicyEntity" controlType="2" defaultValue="" displayName="Storage Policy" hidden="0" inputType="commvault.msgs.CvEntities.StoragePolicyEntity" listType="0" name="storagePolicy" required="1" type="{commvault.msgs.CvEntities}StoragePolicyEntity">

        <children attribute="0" className="java.lang.String" inputType="java.lang.String" listType="0" name="storagePolicyName" required="0" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children attribute="0" className="java.lang.Integer" inputType="java.lang.Integer" listType="0" name="storagePolicyId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      </children>

      <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="Backup Type" hidden="0" inputType="java.lang.String" listType="0" name="backupType" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

        <options val="FULL" />

        <options val="INCREMENTAL" />

        <options val="DIFFERENTIAL" />

      </children>

      <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" hidden="0" inputType="java.lang.Boolean" listType="0" name="followMountPaths" required="1" type="{http://www.w3.org/2001/XMLSchema}boolean" />

    </inputs>

    <variables attribute="0" className="" listType="0" name="variables" required="1" type="">

      <children attribute="0" className="java.lang.Long" defaultValue="" hidden="0" inputType="java.lang.Long" listType="1" name="backupJobs" required="0" type="{http://www.w3.org/2001/XMLSchema}long" />

      <children attribute="0" className="java.lang.Long" defaultValue="" hidden="0" inputType="java.lang.Long" listType="1" name="timeoutJobs" required="0" type="{http://www.w3.org/2001/XMLSchema}long" />

      <children attribute="0" className="java.lang.Integer" defaultValue="" hidden="0" inputType="java.lang.Integer" listType="0" name="maxBackupTimeMinutes" required="0" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" defaultValue="" hidden="0" inputType="java.lang.String" listType="1" name="failedClients" required="0" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs attribute="0" className="" listType="0" name="outputs" required="1" type="" />

    <config className="" name="" type="" />

  </schema>

  <formProperties css="" javaScript="" />

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="63" x="33" y="33">

    <onEnter language="1" script="&#xD;&#xA;" />

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="UpdateJobDescription_1" commented="0" originalStyle="" points="" sourceX="64" sourceY="51" status="0" style="defaultEdge" targetX="154" targetY="50" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1358356450934" description="executes queries against the commserv database" displayName="Get Subclients" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_1" waitSetting="0" width="136" x="46" y="123">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;exec archGroupAssociatedClients xpath:{/workflow/Script_10/output}, 1&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Script_14" commented="0" originalStyle="" points="" sourceX="114" sourceY="140" status="0" style="defaultEdge" targetX="123" targetY="224" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1358356568630" description="iterates a group of activities over a list of values" displayName="ForEach" height="559" interactive="0" jobMode="0" maxRestarts="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0" width="565" x="31" y="272">

    <activitySchema>

      <inputs>

        <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      </inputs>

      <outputs name="outputs">

        <children attribute="0" className="workflow.types.data.DataRow" defaultValue="" hidden="0" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

          <children attribute="0" className="java.lang.Object" defaultValue="" hidden="0" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        </children>

      </outputs>

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;row&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot;&gt;xpath:{/workflow/CommServDBQuery_1/resultSets/row}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;&gt;java:{xpath:{/workflow/CommServDBQuery_1/resultSets/row}.size()}&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;&gt;false&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_11" commented="0" originalStyle="" points="" sourceX="313" sourceY="551" status="0" style="defaultEdge" targetX="611" targetY="263" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1358356568630" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2" waitSetting="0" width="120" x="19" y="35">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Script_12" commented="0" originalStyle="" points="" sourceX="79" sourceY="50" status="0" style="defaultEdge" targetX="223" targetY="48" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="1" created="1358356662455" description="" displayName="Start Backup" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=Execute" uniqueName="Execute_1" waitSetting="0" width="124" x="187" y="101">

        <onExit language="1" script="if (activity.exitCode == 0)&#xD;&#xA;{&#xD;&#xA;    if (activity.outputXml != null &amp;&amp; activity.outputXml.length() &gt; 0)&#xD;&#xA;    {&#xD;&#xA;        XML response = utils.parseXml(activity.outputXml);&#xD;&#xA;        if (response.getName().equals(&quot;TMMsg_GenericResp&quot;))&#xD;&#xA;        {&#xD;&#xA;            activity.exitCode = Integer.parseInt(response.selectSingleNode(&quot;string(/TMMsg_GenericResp/@errorCode)&quot;));&#xD;&#xA;            activity.commandOutput = response.selectSingleNode(&quot;string(/TMMsg_GenericResp/@errorMessage)&quot;);&#xD;&#xA;        }&#xD;&#xA;    } &#xD;&#xA;    else &#xD;&#xA;    {&#xD;&#xA;        activity.exitCode = -1;&#xD;&#xA;        activity.commandOutput = &quot;failed to retrieve xml response&quot;;&#xD;&#xA;    }&#xD;&#xA;}" />

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot;&gt;&amp;lt;TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;  &amp;lt;taskInfo&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;associations&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;appName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;appTypeName&quot;]}&amp;lt;/appName&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;backupsetName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;backupSetName&quot;]}&amp;lt;/backupsetName&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;clientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;clientName&quot;]}&amp;lt;/clientName&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;instanceName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;instanceName&quot;]}&amp;lt;/instanceName&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;subclientName&amp;gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;subclientName&quot;]}&amp;lt;/subclientName&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;/associations&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;subTasks&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;options originalJobId=&quot;xpath:{/workflow/system/jobId}&quot;&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;backupOpts&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;backupLevel&amp;gt;xpath:{/workflow/Script_13/output}&amp;lt;/backupLevel&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;dataOpt&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;bkpFilesProctedByFS&amp;gt;true&amp;lt;/bkpFilesProctedByFS&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;collectHotFixInformation&amp;gt;true&amp;lt;/collectHotFixInformation&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;collectSysInfo&amp;gt;false&amp;lt;/collectSysInfo&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;createNewIndex&amp;gt;false&amp;lt;/createNewIndex&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;enableIndexCheckPointing&amp;gt;false&amp;lt;/enableIndexCheckPointing&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;enforceTransactionLogUsage&amp;gt;true&amp;lt;/enforceTransactionLogUsage&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;followMountPoints&amp;gt;xpath:{/workflow/inputs/followMountPaths}&amp;lt;/followMountPoints&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;ignorErrorInSynthFull&amp;gt;false&amp;lt;/ignorErrorInSynthFull&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;skipCatalogPhaseForSnapBackup&amp;gt;false&amp;lt;/skipCatalogPhaseForSnapBackup&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;skipConsistencyCheck&amp;gt;false&amp;lt;/skipConsistencyCheck&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;spaceReclamation&amp;gt;false&amp;lt;/spaceReclamation&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;stopDhcpService&amp;gt;true&amp;lt;/stopDhcpService&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;stopWinService&amp;gt;true&amp;lt;/stopWinService&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;useCatalogServer&amp;gt;true&amp;lt;/useCatalogServer&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;verifySynthFull&amp;gt;true&amp;lt;/verifySynthFull&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/dataOpt&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;dataPathOpt&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;drive/&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;drivePool/&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;library/&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;mediaAgent/&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/dataPathOpt&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;doNotTruncateLog&amp;gt;false&amp;lt;/doNotTruncateLog&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;incLevel&amp;gt;BEFORE_SYNTH&amp;lt;/incLevel&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;mediaOpt&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;allowOtherSchedulesToUseMediaSet&amp;gt;true&amp;lt;/allowOtherSchedulesToUseMediaSet&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;markMediaFullOnSuccess&amp;gt;false&amp;lt;/markMediaFullOnSuccess&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;numberofDays&amp;gt;30&amp;lt;/numberofDays&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;reserveResourcesBeforeScan&amp;gt;false&amp;lt;/reserveResourcesBeforeScan&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;retentionJobType&amp;gt;STORAGE_POLICY_DEFAULT&amp;lt;/retentionJobType&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;startNewMedia&amp;gt;false&amp;lt;/startNewMedia&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/mediaOpt&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;runIncrementalBackup&amp;gt;true&amp;lt;/runIncrementalBackup&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;sybaseSkipFullafterLogBkp&amp;gt;false&amp;lt;/sybaseSkipFullafterLogBkp&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;truncateLogsOnSource&amp;gt;false&amp;lt;/truncateLogsOnSource&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;vaultTrackerOpt&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;excludeMediaNotCopied&amp;gt;false&amp;lt;/excludeMediaNotCopied&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;exportLocation/&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;exportMediaAfterJobFinishes&amp;gt;false&amp;lt;/exportMediaAfterJobFinishes&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;filterMediaByRetention&amp;gt;false&amp;lt;/filterMediaByRetention&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;inTransitLocation/&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;mediaStatus&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;active&amp;gt;false&amp;lt;/active&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;all&amp;gt;false&amp;lt;/all&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;bad&amp;gt;true&amp;lt;/bad&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;full&amp;gt;true&amp;lt;/full&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;overwriteProtected&amp;gt;true&amp;lt;/overwriteProtected&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;/mediaStatus&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;mediaWithExtendedRetentionJobs&amp;gt;false&amp;lt;/mediaWithExtendedRetentionJobs&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;trackTransit&amp;gt;false&amp;lt;/trackTransit&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;useVirtualMailSlots&amp;gt;false&amp;lt;/useVirtualMailSlots&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/vaultTrackerOpt&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;/backupOpts&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;commonOpts&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;!--User Description for the job--&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;jobDescription&amp;gt;Started by Replication workflow job [xpath:{/workflow/system/jobId}]&amp;lt;/jobDescription&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;jobRetryOpts&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;enableNumberOfRetries&amp;gt;false&amp;lt;/enableNumberOfRetries&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;killRunningJobWhenTotalRunningTimeExpires&amp;gt;false&amp;lt;/killRunningJobWhenTotalRunningTimeExpires&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;numberOfRetries&amp;gt;0&amp;lt;/numberOfRetries&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;runningTime&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;enableTotalRunningTime&amp;gt;false&amp;lt;/enableTotalRunningTime&amp;gt;&amp;#xD;&#xD;&#xA;              &amp;lt;totalRunningTime&amp;gt;01:00:00&amp;lt;/totalRunningTime&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;/runningTime&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/jobRetryOpts&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;perfJobOpts/&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;startUpOpts&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;priority&amp;gt;166&amp;lt;/priority&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;startInSuspendedState&amp;gt;false&amp;lt;/startInSuspendedState&amp;gt;&amp;#xD;&#xD;&#xA;            &amp;lt;useDefaultPriority&amp;gt;true&amp;lt;/useDefaultPriority&amp;gt;&amp;#xD;&#xD;&#xA;          &amp;lt;/startUpOpts&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;/commonOpts&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;restoreOptions/&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;/options&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;subTask&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;operationType&amp;gt;BACKUP&amp;lt;/operationType&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;subTaskType&amp;gt;BACKUP&amp;lt;/subTaskType&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;/subTask&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;/subTasks&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;task&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;alert&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;alertName&amp;gt;&amp;lt;/alertName&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;/alert&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;initiatedFrom&amp;gt;COMMANDLINE&amp;lt;/initiatedFrom&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;policyType&amp;gt;DATA_PROTECTION&amp;lt;/policyType&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;taskFlags&amp;gt;&amp;#xD;&#xD;&#xA;        &amp;lt;disabled&amp;gt;false&amp;lt;/disabled&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;/taskFlags&amp;gt;&amp;#xD;&#xD;&#xA;      &amp;lt;taskType&amp;gt;IMMEDIATE&amp;lt;/taskType&amp;gt;&amp;#xD;&#xD;&#xA;    &amp;lt;/task&amp;gt;&amp;#xD;&#xD;&#xA;  &amp;lt;/taskInfo&amp;gt;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;lt;/TMMsg_CreateTaskReq&amp;gt;&amp;#xD;&#xD;&#xA;&lt;/inputXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="254" sourceY="125" status="0" style="defaultEdge" targetX="252" targetY="211" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358357361794" description="retrieves a list of values from xml" displayName="Get Job ID" height="34" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=XPathQuery" uniqueName="XPathQuery_1" waitSetting="0" width="124" x="365" y="193">

        <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/Execute_1/outputXml}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot;&gt;/TMMsg_CreateTaskResp/jobIds[1]/@val&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot;&gt;true&lt;/outputAsList&gt;&lt;/inputs&gt;" />

        <transition activity="GxGlobalTimeout" commented="0" originalStyle="" points="" sourceX="427" sourceY="210" status="0" style="defaultEdge" targetX="432" targetY="282" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358357605560" description="utility to add objects to a list" displayName="Add Success" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_1" waitSetting="0" width="112" x="28" y="330">

        <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/backupJobs}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot;&gt;xpath:{/workflow/XPathQuery_1/result}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358361717552" description="if/else based decision" displayName="Ready?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="100" x="187" y="298">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/Script_7/output}==0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="AddToList_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="239" sourceY="368" status="0" style="defaultEdge" targetX="89" targetY="363" transitionIndex="0" value="true" x="-2" y="185">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Decision_9" commented="0" displayName="No" originalStyle="" points="" sourceX="237" sourceY="348" status="0" style="defaultEdge" targetX="243" targetY="481" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358516159745" description="if/else based decision" displayName="Success?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="100" x="202" y="159">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/Execute_1/exitCode}==0&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="AddToList_3" commented="0" displayName="No" originalStyle="" points="" sourceX="246" sourceY="239" status="0" style="defaultEdge" targetX="108" targetY="235" transitionIndex="0" value="false" x="9" y="80">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="XPathQuery_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="244" sourceY="257" status="0" style="defaultEdge" targetX="357" targetY="257" transitionIndex="0" value="true" x="9" y="80">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1359981113084" description="utility to add objects to a list" displayName="AddToList" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_2" waitSetting="0" width="102" x="326" y="475">

        <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/timeoutJobs}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot;&gt;xpath:{/workflow/XPathQuery_1/result}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

        <transition activity="Script_8" commented="0" originalStyle="" points="" sourceX="244" sourceY="443" status="0" style="defaultEdge" targetX="87" targetY="447" transitionIndex="0" x="9" y="22">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1359981131727" description="utility to add objects to a list" displayName="Add Failure" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_3" waitSetting="0" width="105" x="38" y="192">

        <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/failedClients}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;clientName&quot;]}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1366228046757" description="activity to execute code snippets in the selected language" displayName="Wait" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_7" waitSetting="0" width="100" x="368" y="331">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;&amp;#xD;&amp;#xA;//RETURN STATUSES&amp;#xD;&amp;#xA;//0 - SUCCESSFULL&amp;#xD;&amp;#xA;//1 - DFM JOB TIMED OUT&amp;#xD;&amp;#xA;//2 - DFM JOB FAILED&amp;#xD;&amp;#xA;//5 - BACKUP JOB COMPLETED&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;long lastUpdateTime = new Date().getTime();&amp;#xD;&amp;#xA;long unCompBytes = 0;&amp;#xD;&amp;#xA;long timeOutMinutes = 2880; //2 days&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/GxGlobalTimeout/resultSets[1]/row[1]/col[1]} != null) {&amp;#xD;&amp;#xA;    long to = Long.parseLong(xpath:{/workflow/GxGlobalTimeout/resultSets[1]/row[1]/col[1]});&amp;#xD;&amp;#xA;    if (to &amp;gt; 0) {&amp;#xD;&amp;#xA;        timeOutMinutes = to;&amp;#xD;&amp;#xA;    } &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;logger.info(&amp;quot;using timeout value of [&amp;quot; + timeOutMinutes + &amp;quot;] minutes&amp;quot;);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String jobId = xpath:{/workflow/XPathQuery_1/result}.get(0);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;DataSet checkDS;&amp;#xD;&amp;#xA;String checkSql = &amp;quot;select cast(ISNULL(data, -1) As INT) as data from JMMisc where jobId=&amp;quot;+jobId+&amp;quot; and itemType=18&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;DataSet progressDS;&amp;#xD;&amp;#xA;String progressSql = &amp;quot;Select unCompBytes From JMBkpJobInfo Where jobId = &amp;quot;+jobId;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;DataSet statusDS;&amp;#xD;&amp;#xA;String statusSql = &amp;quot;Select * from JMJobStats where jobid = &amp;quot;+jobId;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;while (true)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    checkDS = csdb.execute(checkSql);&amp;#xD;&amp;#xA;    if (checkDS.hasNext()) {&amp;#xD;&amp;#xA;        if (checkDS.get(&amp;quot;data&amp;quot;) == 0) {&amp;#xD;&amp;#xA;            //not started&amp;#xD;&amp;#xA;        } else if (checkDS.get(&amp;quot;data&amp;quot;) == 1) {&amp;#xD;&amp;#xA;            //running&amp;#xD;&amp;#xA;        } else if (checkDS.get(&amp;quot;data&amp;quot;) == 2) {&amp;#xD;&amp;#xA;            //ready&amp;#xD;&amp;#xA;            return 0;&amp;#xD;&amp;#xA;        } else if (checkDS.get(&amp;quot;data&amp;quot;) == 3) {&amp;#xD;&amp;#xA;            //failed&amp;#xD;&amp;#xA;            logger.error(&amp;quot;DFM for backup job [&amp;quot; + jobId + &amp;quot;] failed&amp;quot;);&amp;#xD;&amp;#xA;            return 2;&amp;#xD;&amp;#xA;        } else if (checkDS.get(&amp;quot;data&amp;quot;) == 4) {&amp;#xD;&amp;#xA;            //completed with errors&amp;#xD;&amp;#xA;            logger.error(&amp;quot;DFM for backup job [&amp;quot; + jobId + &amp;quot;] completed with errors&amp;quot;);&amp;#xD;&amp;#xA;            return 2;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        //logger.info(&amp;quot;could not find JMMisc row for backup job [&amp;quot; + jobId + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    long now = new Date().getTime();&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    progressDS = csdb.execute(progressSql);&amp;#xD;&amp;#xA;    if (progressDS.hasNext()) {&amp;#xD;&amp;#xA;        if (progressDS.get(&amp;quot;unCompBytes&amp;quot;) &amp;gt; unCompBytes) {&amp;#xD;&amp;#xA;            unCompBytes = progressDS.get(&amp;quot;unCompBytes&amp;quot;);&amp;#xD;&amp;#xA;            lastUpdateTime = now;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;could not find JMBkpJobInfo row for backup job [&amp;quot; + jobId + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    long diff = (now - lastUpdateTime) / (60 * 1000);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    if (diff &amp;gt;= timeOutMinutes) {&amp;#xD;&amp;#xA;        logger.error(&amp;quot;DFM for backup job [&amp;quot; + jobId + &amp;quot;] timed out&amp;quot;);&amp;#xD;&amp;#xA;        return 1;&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    statusDS = csdb.execute(statusSql);&amp;#xD;&amp;#xA;    if (statusDS.hasNext()) {&amp;#xD;&amp;#xA;        if (statusDS.get(&amp;quot;status&amp;quot;) &amp;gt; 1) {&amp;#xD;&amp;#xA;            logger.error(&amp;quot;backup job [&amp;quot; + jobId + &amp;quot;] completed before dfm status was retrieved&amp;quot;);&amp;#xD;&amp;#xA;            return 5;&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;    } else {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;could not find JMJobStats row for backup job [&amp;quot; + jobId + &amp;quot;]&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;   &amp;#xD;&amp;#xA;    Thread.sleep(60 * 1000);&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="426" sourceY="343" status="0" style="defaultEdge" targetX="252" targetY="342" transitionIndex="0" x="9" y="80">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1366228124916" description="activity to execute code snippets in the selected language" displayName="Kill Desc" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_8" waitSetting="0" width="100" x="452" y="475">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if (xpath:{/workflow/Script_7/output} == 1)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return &amp;quot;DFM timed out&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (xpath:{/workflow/Script_7/output} == 2)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    return &amp;quot;DFM failed&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return &amp;quot;unknown&amp;quot;;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_3" commented="0" originalStyle="" points="" sourceX="91" sourceY="443" status="0" style="defaultEdge" targetX="95" targetY="379" transitionIndex="0" x="9" y="22">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1366228152826" description="" displayName="Kill Job" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=Execute" uniqueName="Execute_3" waitSetting="0" width="97" x="453" y="421">

        <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot;&gt;&amp;lt;JobManager_PerformMultiCellJobOpReq&amp;#xD;&#xD;&#xA;&#x9;message=&quot;1&quot; operationDescription=&quot;xpath:{/workflow/Script_8/output}&quot;&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;jobOpReq operationType=&quot;3&quot;&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&amp;lt;jobs jobId=&quot;xpath:{/workflow/XPathQuery_1/result}&quot; /&amp;gt;&amp;#xD;&#xD;&#xA;&#x9;&amp;lt;/jobOpReq&amp;gt;&amp;#xD;&#xD;&#xA;&amp;lt;/JobManager_PerformMultiCellJobOpReq&amp;gt;&lt;/inputXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1367426412500" description="if/else based decision" displayName="Completed" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_9" waitSetting="0" width="100" x="187" y="442">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/Script_7/output}==5&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="AddToList_4" commented="0" displayName="Yes" originalStyle="" points="" sourceX="237" sourceY="492" status="0" style="defaultEdge" targetX="99" targetY="496" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="AddToList_2" commented="0" displayName="No" originalStyle="" points="" sourceX="237" sourceY="492" status="0" style="defaultEdge" targetX="350" targetY="492" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1367426609763" description="utility to add objects to a list" displayName="Add Failure" height="34" interactive="0" jobMode="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_4" waitSetting="0" width="105" x="30" y="475">

        <inputs val="&lt;inputs&gt;&lt;addToList class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/failedClients}&lt;/addToList&gt;&lt;itemToAdd class=&quot;java.lang.Object&quot;&gt;xpath:{/workflow/ForEach_1/row/col[@name=&quot;clientName&quot;]}&lt;/itemToAdd&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1367590042645" description="activity to execute code snippets in the selected language" displayName="Check Subclient" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_12" waitSetting="0" width="135" x="189" y="33">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;//HIDE HIDDEN&amp;#xD;&amp;#xA;if (((xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;appTypeId&amp;quot;]} == 84) || (xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;appTypeId&amp;quot;]} == 107)) &amp;amp;&amp;amp; (xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subClientFlags&amp;quot;]} &amp;amp; 8) == 8) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;skipping processing subclient [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]}+&amp;quot;] on client [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;clientName&amp;quot;]}+&amp;quot;] since subclient is CDR/WBA and is marked hidden&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//CV_STATUS_UNINSTALLED&amp;#xD;&amp;#xA;if ((xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subClientFlags&amp;quot;]} &amp;amp; 2) == 2) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;skipping processing subclient [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]}+&amp;quot;] on client [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;clientName&amp;quot;]}+&amp;quot;] since subclient is marked uninstalled&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//CV_STATUS_DELETED&amp;#xD;&amp;#xA;if ((xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subClientFlags&amp;quot;]} &amp;amp; 4) == 4) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;skipping processing subclient [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]}+&amp;quot;] on client [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;clientName&amp;quot;]}+&amp;quot;] since subclient is marked deleted&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//CV_STATUS_DUMMY&amp;#xD;&amp;#xA;if ((xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subClientFlags&amp;quot;]} &amp;amp; 16) == 16) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;skipping processing subclient [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]}+&amp;quot;] on client [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;clientName&amp;quot;]}+&amp;quot;] since subclient is a dummy subclient&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;//CV_STATUS_HIDDEN&amp;#xD;&amp;#xA;if ((xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subClientFlags&amp;quot;]} &amp;amp; 32) == 32) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;skipping processing subclient [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]}+&amp;quot;] on client [&amp;quot;+xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;clientName&amp;quot;]}+&amp;quot;] since subclient is marked hidden&amp;quot;);&amp;#xD;&amp;#xA;    return false;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;return true;&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Script_13" commented="0" originalStyle="" points="" sourceX="256" sourceY="52" status="0" style="defaultEdge" targetX="444" targetY="51" transitionIndex="0" x="0" y="0">

          <condition language="1" script="return activity.output == true;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1368554928108" description="activity to execute code snippets in the selected language" displayName="Backup Type" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_13" waitSetting="0" width="114" x="374" y="33">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;int appTypeId = xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;appTypeId&amp;quot;]}; &amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (appTypeId == 81) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;switching backup level of sql subclient [&amp;quot; + xpath:{/workflow/ForEach_1/row/col[@name=&amp;quot;subclientName&amp;quot;]} + &amp;quot;] to full&amp;quot;);&amp;#xD;&amp;#xA;    return &amp;quot;FULL&amp;quot;;&amp;#xD;&amp;#xA;} else {&amp;#xD;&amp;#xA;    return xpath:{/workflow/inputs/backupType};&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

        <transition activity="Execute_1" commented="0" originalStyle="" points="426.0,116.0" sourceX="437" sourceY="51" status="0" style="defaultEdge" targetX="262" targetY="125" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1390860919477" description="executes queries against the commserv database" displayName="Get Timeout" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="GxGlobalTimeout" waitSetting="0" width="111" x="366" y="262">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;Select value From GXGlobalParam Where name = ''SPOSWorkFlowTimeOut''&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="Script_7" commented="0" originalStyle="" points="" sourceX="421" sourceY="279" status="0" style="defaultEdge" targetX="423" targetY="345" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1358529594099" description="updates the job description for the workflow" displayName="Set Description" height="34" interactive="0" jobMode="0" name="UpdateJobDescription" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=UpdateJobDescription" uniqueName="UpdateJobDescription_1" waitSetting="0" width="134" x="118" y="34">

    <inputs val="&lt;inputs&gt;&lt;operation class=&quot;workflow.types.cmd.AppendOverwrite&quot;&gt;overwrite&lt;/operation&gt;&lt;jobDescription class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/inputs/storagePolicy}&lt;/jobDescription&gt;&lt;/inputs&gt;" />

    <transition activity="Script_10" commented="0" originalStyle="" points="" sourceX="185" sourceY="51" status="0" style="defaultEdge" targetX="318" targetY="50" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1359980154349" description="activity to execute code snippets in the selected language" displayName="Get StartTime" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_3" waitSetting="0" width="122" x="256" y="194">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;return new Date().getTime();&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="ForEach_1" commented="0" originalStyle="" points="" sourceX="477" sourceY="131" status="0" style="defaultEdge" targetX="480" targetY="186" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1360006353557" description="executes queries against the commserv database" displayName="Get Inc Policy" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_7" waitSetting="0" width="138" x="472" y="34">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;select isnull(incrsp, 0) as incrsp from archgroup where id = xpath:{/workflow/Script_10/output}&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Decision_8" commented="0" originalStyle="" points="" sourceX="505" sourceY="51" status="0" style="defaultEdge" targetX="513" targetY="126" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1360008411487" description="if/else based decision" displayName="Has Inc?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_8" waitSetting="0" width="109" x="494" y="90">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/CommServDBQuery_7/resultSets[1]/row[1]/col[1]} &amp;gt; 0&lt;/expression&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_6" commented="0" displayName="Yes" originalStyle="" points="" sourceX="508" sourceY="140" status="0" style="defaultEdge" targetX="511" targetY="231" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="Execute_2" commented="0" displayName="No" offsetX="1" offsetY="0" originalStyle="" points="" sourceX="512" sourceY="140" status="0" style="defaultEdge" targetX="377" targetY="132" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1360008415325" description="Ends the workflow" displayName="Fail Workflow" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_6" waitSetting="0" width="123" x="485" y="220">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot;&gt;storage policy [xpath:{/workflow/inputs/storagePolicy}] has different inc policy [xpath:{/workflow/CommServDBQuery_7/resultSets[1]/row[1]/col[2]}]&lt;/failureMessage&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="1" created="1360165213581" description="creates a super process group" displayName="Try Block" height="574" interactive="0" jobMode="0" maxRestarts="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_1" waitSetting="0" width="862" x="642" y="25">

    <activitySchema>

      <inputs attribute="0" listType="0" name="inputs" required="1" />

      <outputs attribute="0" listType="0" name="outputs" required="1" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <transition activity="ProcessBlock_2" commented="0" originalStyle="" points="" sourceX="1027" sourceY="271" status="2" style="defaultEdge" targetX="1022" targetY="542" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1360165213581" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_3" waitSetting="0" width="84" x="20" y="121">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_6" commented="0" originalStyle="" points="" sourceX="59" sourceY="187" status="0" style="defaultEdge" targetX="151" targetY="187" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1359988497060" description="if/else based decision" displayName="Can Start?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_6" waitSetting="0" width="100" x="137" y="86">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/backupJobs}.size() &amp;gt; 0&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="Script_5" commented="0" displayName="No" offsetX="-4" offsetY="-12" originalStyle="" points="187.0,62.0" sourceX="147" sourceY="387" status="0" style="defaultEdge" targetX="161" targetY="520" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_4" commented="0" displayName="Yes" originalStyle="" points="" sourceX="147" sourceY="387" status="0" style="defaultEdge" targetX="268" targetY="205" transitionIndex="0" value="true" x="-512" y="-32">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1358606824238" description="Execute a list of commands" displayName="Start Master Process" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_1" waitSetting="0" width="168" x="504" y="119">

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;&gt;xpath:{/workflow/XPathQuery_2/result}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; /&gt;&lt;command class=&quot;java.lang.String&quot;&gt;LREPCoordinator&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot;&gt;-DFMJobStart -h xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[3]} -l xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[4]} -p xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[5]} -n xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[6]} -j xpath:{/workflow/system/jobId} -d xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[1]} -r xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[2]} -s xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]} -cn xpath:{/workflow/XPathQuery_2/result}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_7" commented="0" originalStyle="" points="" sourceX="588" sourceY="192" status="0" style="defaultEdge" targetX="762" targetY="186" transitionIndex="0" x="-512" y="-32">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358607113676" description="executes queries against the commserv database" displayName="Record DFM Job" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="162" x="471" y="223">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE     @JobId int = xpath:{/workflow/system/jobId}&amp;#xD;&#xD;&#xA;DECLARE     @archGroupId int = xpath:{/workflow/Script_10/output}&amp;#xD;&#xD;&#xA;DECLARE     @dataSetId int = xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[1]}&amp;#xD;&#xD;&#xA;DECLARE     @dfmJobId int = xpath:{/workflow/ExecuteCommand_1/commandOutput}&amp;#xD;&#xD;&#xA;DECLARE     @extRelationId int = xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[2]}&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO SMExternalJobMapHist&amp;#xD;&#xD;&#xA;SELECT      @JobId, 2, AG.defaultSnapCopy, CH.ControlHostId, @dataSetId, 0, 0, @dfmJobId, 0, N'''', 0, GetUTCDate(), 0, 0, 0, N''''&amp;#xD;&#xD;&#xA;FROM  archGroup AG, ArchGroupControlHost CH&amp;#xD;&#xD;&#xA;WHERE AG.id = @archGroupId&amp;#xD;&#xD;&#xA;   AND AG.id = CH.ArchGroupId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;INSERT INTO JMMisc&amp;#xD;&#xD;&#xA;select @JobId, 0, 17, 0, 0, @dfmJobId, 2&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="WaitForJobCompletion_1" commented="0" originalStyle="" points="" sourceX="776" sourceY="423" status="0" style="defaultEdge" targetX="580" targetY="423" transitionIndex="0" x="-534" y="92">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857782341" description="waits until the list of jobs completes" displayName="Wait for backups" height="34" interactive="0" jobMode="0" name="WaitForJobCompletion" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WaitForJobCompletion" uniqueName="WaitForJobCompletion_1" waitSetting="0" width="159" x="278" y="223">

        <inputs val="&lt;inputs&gt;&lt;jobId class=&quot;java.lang.Integer&quot;&gt;xpath:{/workflow/variables/backupJobs}&lt;/jobId&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_3" commented="0" originalStyle="" points="" sourceX="338" sourceY="296" status="0" style="defaultEdge" targetX="147" targetY="298" transitionIndex="0" x="-81" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857806008" description="if/else based decision" displayName="Success?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_4" waitSetting="0" width="100" x="197" y="280">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/WaitForJobCompletion_1/successful} &amp;amp;&amp;amp; xpath:{/workflow/variables/timeoutJobs}.size()==0 &amp;amp;&amp;amp; xpath:{/workflow/variables/failedClients}.size()==0&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_1" commented="0" displayName="Yes" offsetX="-3" offsetY="-2" originalStyle="" points="" sourceX="363" sourceY="687" status="0" style="defaultEdge" targetX="218" targetY="682" transitionIndex="0" value="true" x="-683" y="81">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_2" commented="0" displayName="No" originalStyle="" points="" sourceX="247" sourceY="330" status="0" style="defaultEdge" targetX="256" targetY="453" transitionIndex="0" value="false" x="-171" y="5">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857832608" description="Ends the workflow" displayName="Completed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_1" waitSetting="0" width="119" x="374" y="313">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;COMPLETED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857848434" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_2" waitSetting="0" width="119" x="190" y="421">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;COMPLETED_WITH_ERRORS&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot;&gt;one or more backup jobs failed to complete&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1359986336497" description="executes queries against the commserv database" displayName="Get DataSet Id" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="140" x="304" y="119">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE @archGroupId INT = xpath:{/workflow/Script_10/output}&amp;#xD;&#xD;&#xA;DECLARE @ourdataSetId INT&amp;#xD;&#xD;&#xA;DECLARE @DFMdataSetId INT&amp;#xD;&#xD;&#xA;DECLARE @extRelationId INT&amp;#xD;&#xD;&#xA;DECLARE @ControlHostId INT&amp;#xD;&#xD;&#xA;DECLARE @SMArrayId NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @SMHostUserName NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @SMHostPassword NVARCHAR(2048)&amp;#xD;&#xD;&#xA;DECLARE @SMHostPortNumber INT&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @defaultSnapCopy int&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @defaultSnapCopy = defaultSnapCopy from ArchGroup WITH(NOLOCK) where id = @archGroupId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @ourdataSetId = SMD.DataSetId, @extRelationId = SMR.ExtRelationId&amp;#xD;&#xD;&#xA;FROM SMDataSetToSubClientMap SMD WITH(NOLOCK) inner join SMRelation SMR WITH(NOLOCK) ON SMD.SMRelationId = SMR.SMRelationId&amp;#xD;&#xD;&#xA;INNER JOIN SMCopyToRelationMap SMCR WITH(NOLOCK) ON SMCR.ArchGroupCopyId = @defaultSnapCopy AND SMCR.SMRelationId = SMR.SMRelationId&amp;#xD;&#xD;&#xA;WHERE SMD.AppId = 0 AND SMD.ArchGroupId = @archGroupId AND SMD.Flags &amp;amp; 1 &amp;gt; 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @DFMdataSetId=ExtDataSetId from SMDataSet where DatasetId=@ourdataSetId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @ControlHostId = AGC.ControlHostId  from ArchGroupControlHost AGC where AGC.ArchGroupId=@archGroupId&amp;#xD;&#xD;&#xA;select @SMArrayId=SMCH.SMArrayId, @SMHostUserName=SMCH.SMHostUserName, @SMHostPassword=SMCH.SMHostPassword, @SMHostPortNumber=SMCH.SMHostPortNumber from SMControlHost SMCH where SMCH.ControlHostId=@ControlHostId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @credsAssocId INT = -1&amp;#xD;&#xD;&#xA;SET @credsAssocId = (SELECT CredentialId FROM SMControlHost WITH (NOLOCK) WHERE ControlHostId=@ControlHostId) &amp;#xD;&#xD;&#xA;IF @credsAssocId &amp;gt; 0 --update credentials from credential manager&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;DECLARE @Creds table&amp;#xD;&#xD;&#xA;&#x9;(&#x9;userName&#x9;&#x9;&#x9;&#x9;nvarchar(MAX),&amp;#xD;&#xD;&#xA;&#x9;&#x9;password&#x9;&#x9;&#x9;&#x9;nvarchar(MAX),&amp;#xD;&#xD;&#xA;&#x9;&#x9;credentialInfoXml   xml,&amp;#xD;&#xD;&#xA;&#x9;&#x9;flags&#x9;&#x9;&#x9;&#x9;int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;recordType&#x9;&#x9;&#x9;int )&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;INSERT INTO @Creds exec AppGetAssocToCMCredentials @credsAssocId, 0&amp;#xD;&#xD;&#xA;&#x9;SELECT @SMHostUserName = userName, @SMHostPassword = password FROM @Creds&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SELECT @DFMdataSetId, @extRelationId, @SMArrayId, @SMHostUserName, @SMHostPassword, @SMHostPortNumber&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_1" commented="0" originalStyle="" points="" sourceX="374" sourceY="136" status="0" style="defaultEdge" targetX="505" targetY="140" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360006067577" description="if/else based decision" displayName="Succeeded" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_7" waitSetting="0" width="101" x="743" y="86">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/ExecuteCommand_1/exitCode}==0&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="Script_6" commented="0" displayName="No" offsetX="13" offsetY="-13" originalStyle="" points="792.0,63.0" sourceX="793" sourceY="136" status="0" style="defaultEdge" targetX="605" targetY="59" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Decision_10" commented="0" displayName="Yes" offsetX="-2" offsetY="-1" originalStyle="" points="" sourceX="793" sourceY="136" status="0" style="defaultEdge" targetX="702" targetY="234" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360164938938" description="Execute a list of commands" displayName="Complete Master Process" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_3" waitSetting="0" width="197" x="42" y="223">

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;&gt;xpath:{/workflow/XPathQuery_2/result}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; /&gt;&lt;command class=&quot;java.lang.String&quot;&gt;LREPCoordinator&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot;&gt;-DFMJobStatus -DFMJob xpath:{/workflow/ExecuteCommand_1/commandOutput} -h xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[3]} -l xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[4]} -p xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[5]} -n xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[6]} -j xpath:{/workflow/system/jobId} -d xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[1]} -r xpath:{/workflow/CommServDBQuery_4/resultSets[1]/row[1]/col[2]} -s xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row[1]/col[1]} -cn xpath:{/workflow/XPathQuery_2/result}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_4" commented="0" originalStyle="" points="139.0,330.0" sourceX="140" sourceY="240" status="0" style="defaultEdge" targetX="301" targetY="343" transitionIndex="0" x="-81" y="6">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360165593630" description="activity to execute code snippets in the selected language" displayName="Raise Error" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_5" waitSetting="0" width="104" x="314" y="51">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;all backup jobs failed to start&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360165660652" description="activity to execute code snippets in the selected language" displayName="Raise Error" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_6" waitSetting="0" width="104" x="567" y="53">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to start master process&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1367426784839" description="if/else based decision" displayName="Have JobId" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_10" waitSetting="0" width="105" x="740" y="229">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/ExecuteCommand_1/commandOutput} != null &amp;amp;&amp;amp; xpath:{/workflow/ExecuteCommand_1/commandOutput}.length() &amp;gt; 0&lt;/expression&gt;&lt;/inputs&gt;" />

        <transition activity="CommServDBQuery_2" commented="0" displayName="Yes" originalStyle="" points="" sourceX="793" sourceY="292" status="0" style="defaultEdge" targetX="607" targetY="242" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="Script_9" commented="0" displayName="No" originalStyle="" points="" sourceX="792" sourceY="279" status="0" style="defaultEdge" targetX="791" targetY="398" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1367426834509" description="activity to execute code snippets in the selected language" displayName="Raise Error" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_9" waitSetting="0" width="104" x="735" y="377">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to retrieve dfm job id from executable&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1360165828288" description="creates a super process group" displayName="Catch Block" height="189" interactive="0" jobMode="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_2" waitSetting="0" width="864" x="646" y="637">

    <activitySchema>

      <inputs attribute="0" listType="0" name="inputs" required="1" />

      <outputs attribute="0" listType="0" name="outputs" required="1" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1360165828288" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_4" waitSetting="0" width="120" x="18" y="30">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="WorkflowEnd_7" commented="0" originalStyle="" points="" sourceX="78" sourceY="45" status="0" style="defaultEdge" targetX="210" targetY="40" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1360165863952" description="Ends the workflow" displayName="Set Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_7" waitSetting="0" width="119" x="182" y="28">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;FAILED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot;&gt;one or more error occured during execution&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1362408055101" description="" displayName="Get MA" height="34" interactive="0" jobMode="0" name="Execute" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=Execute" uniqueName="Execute_2" waitSetting="0" width="113" x="337" y="123">

    <inputs val="&lt;inputs&gt;&lt;inputXml class=&quot;java.lang.String&quot;&gt;&amp;lt;App_GetMediaAgentByAGCReq aGroupNumber=&quot;xpath:{/workflow/Script_10/output}&quot; clientId=&quot;2&quot; jobId=&quot;0&quot; copyId=&quot;0&quot; appId=&quot;0&quot;&amp;gt;&amp;lt;/App_GetMediaAgentByAGCReq&amp;gt;&lt;/inputXml&gt;&lt;commandArgs class=&quot;java.lang.String&quot; /&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

    <transition activity="XPathQuery_2" commented="0" originalStyle="" points="" sourceX="335" sourceY="135" status="0" style="defaultEdge" targetX="143" targetY="137" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1365523142067" description="retrieves a list of values from xml" displayName="MA Value" height="34" interactive="0" jobMode="0" name="XPathQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=XPathQuery" uniqueName="XPathQuery_2" waitSetting="0" width="110" x="205" y="123">

    <inputs val="&lt;inputs&gt;&lt;xml class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/Execute_2/outputXml}&lt;/xml&gt;&lt;xpath class=&quot;java.lang.String&quot;&gt;/App_GetMediaAgentByAGCResp/@mediaAgentName&lt;/xpath&gt;&lt;outputType class=&quot;workflow.types.SimpleType&quot;&gt;String&lt;/outputType&gt;&lt;outputAsList class=&quot;java.lang.Boolean&quot;&gt;true&lt;/outputAsList&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_1" commented="0" originalStyle="" points="" sourceX="145" sourceY="139" status="0" style="defaultEdge" targetX="139" targetY="209" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1367427393570" description="activity to execute code snippets in the selected language" displayName="Get ID" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_10" waitSetting="0" width="100" x="315" y="34">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;String sql = &amp;quot;Select id From archGroup with(NOLOCK) Where name = ''&amp;quot;+xpath:{/workflow/inputs/storagePolicy/storagePolicyName}+&amp;quot;''&amp;quot;;&amp;#xD;&amp;#xA;DataSet ds = csdb.execute(sql);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (ds.hasNext()) {&amp;#xD;&amp;#xA;    if (ds.get(&amp;quot;id&amp;quot;) != null &amp;amp;&amp;amp; ds.get(&amp;quot;id&amp;quot;) &amp;gt; 0) {&amp;#xD;&amp;#xA;        workflow.getJobManager().setArchGroupId(ds.get(&amp;quot;id&amp;quot;));&amp;#xD;&amp;#xA;        return ds.get(&amp;quot;id&amp;quot;);&amp;#xD;&amp;#xA;    }    &amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;String msg = &amp;quot;failed to find storage policy id for [&amp;quot; + xpath:{/workflow/inputs/storagePolicy/storagePolicyName} + &amp;quot;]&amp;quot;;&amp;#xD;&amp;#xA;logger.error(msg);&amp;#xD;&amp;#xA;workflow.setFailed(msg);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_8" commented="0" originalStyle="" points="" sourceX="341" sourceY="51" status="0" style="defaultEdge" targetX="501" targetY="51" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1372097675464" description="activity to execute code snippets in the selected language" displayName="Check Size" height="34" interactive="0" jobMode="0" maxRestarts="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_14" waitSetting="0" width="102" x="65" y="194">

    <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;if (xpath:{/workflow/CommServDBQuery_1/resultSets/rowCount} == 0) {&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;there are no subclients assigned to the storage policy&amp;quot;);&amp;#xD;&amp;#xA;}&quot; /&gt;&lt;/inputs&gt;" />

    <transition activity="Script_3" commented="0" originalStyle="" points="" sourceX="113" sourceY="217" status="0" style="defaultEdge" targetX="270" targetY="218" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1431512490503" description="executes queries against the commserv database" displayName="Get SPOS version" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_8" waitSetting="0" width="138" x="264" y="79">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE @SPOSVersion INT = 0;&amp;#xD;&#xD;&#xA;SET @SPOSVersion = (select SMHostOption from SMControlHost where ControlHostId = (select ControlHostId from ArchGroupControlHost where archgroupid=xpath:{/workflow/inputs/storagePolicy/storagePolicyId}));&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @SPOSVersion as SPOSVersion&amp;#xD;&#xD;&#xA;--@SPOSVersion = @SPOSVersion&amp;amp;64;&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_7" commented="0" originalStyle="" points="" sourceX="333" sourceY="96" status="0" style="defaultEdge" targetX="476" targetY="63" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1431512787733" description="if/else based decision" displayName="is C mode" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_11" waitSetting="0" width="100" x="575" y="221">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/CommServDBQuery_8/resultSets/row/col[@name=&quot;SPOSVersion&quot;]}==2&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

    <transition activity="ProcessBlock_1" commented="0" displayName="NO" originalStyle="" points="" sourceX="625" sourceY="271" status="0" style="defaultEdge" targetX="839" targetY="30" transitionIndex="0" value="false" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="ProcessBlock_3" commented="0" displayName="Yes" originalStyle="" points="" sourceX="625" sourceY="271" status="0" style="defaultEdge" targetX="671" targetY="930" transitionIndex="0" value="true" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="1" created="1431513517699" description="creates a super process group" displayName="Try Block" height="574" interactive="0" jobMode="0" maxRestarts="0" name="ProcessBlock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ProcessBlock_3" waitSetting="0" width="862" x="645" y="928">

    <activitySchema>

      <inputs attribute="0" listType="0" name="inputs" required="1" />

      <outputs attribute="0" listType="0" name="outputs" required="1" />

    </activitySchema>

    <inputs val="&lt;inputs&gt;&lt;inputs /&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1360165213581" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_6" waitSetting="0" width="84" x="20" y="121">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="Decision_13" commented="0" originalStyle="" points="" sourceX="62" sourceY="136" status="0" style="defaultEdge" targetX="160" targetY="135" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1359988497060" description="if/else based decision" displayName="Can Start?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_13" waitSetting="0" width="100" x="137" y="86">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/variables/backupJobs}.size()==0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Script_15" commented="0" displayName="No" offsetX="-4" offsetY="-12" originalStyle="" points="187.0,62.0" sourceX="147" sourceY="387" status="0" style="defaultEdge" targetX="161" targetY="520" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_10" commented="0" displayName="Yes" originalStyle="" points="" sourceX="187" sourceY="136" status="0" style="defaultEdge" targetX="328" targetY="137" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="1" created="1358606824238" description="Execute a list of commands" displayName="Cut destination snap" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_4" waitSetting="0" width="168" x="504" y="119">

        <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;&gt;xpath:{/workflow/XPathQuery_2/result}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; /&gt;&lt;command class=&quot;java.lang.String&quot;&gt;LREPCoordinator&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot;&gt;-Snap -h xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;SMArrayId&quot;]} -l xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;SMHostUserName&quot;]} -p xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;SMHostPassword&quot;]} -n xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;SMHostPortNumber&quot;]} -j xpath:{/workflow/system/jobId} -cn xpath:{/workflow/system/commCellName} -v xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;sVolume&quot;]} -ss xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;sSnapName&quot;]} -ph xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;vPhysicalServer&quot;]} -vs  xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;vServerName&quot;]}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;&gt;true&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_15" commented="0" originalStyle="" points="" sourceX="588" sourceY="192" status="0" style="defaultEdge" targetX="762" targetY="186" transitionIndex="0" x="-512" y="-32">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358607113676" description="executes queries against the commserv database" displayName="Send snap name to jobs" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_9" waitSetting="0" width="166" x="471" y="223">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;INSERT INTO JMMisc&amp;#xD;&#xD;&#xA;select xpath:{/workflow/system/jobId}, 0, 17, 0, 0, ''xpath:{/workflow/CommServDBQuery_10/resultSets/row/col[@name=&quot;sSnapName&quot;]}'', 2&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="WaitForJobCompletion_2" commented="0" originalStyle="" points="" sourceX="776" sourceY="423" status="0" style="defaultEdge" targetX="580" targetY="423" transitionIndex="0" x="-534" y="92">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857782341" description="waits until the list of jobs completes" displayName="Wait for backups" height="34" interactive="0" jobMode="0" name="WaitForJobCompletion" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WaitForJobCompletion" uniqueName="WaitForJobCompletion_2" waitSetting="0" width="159" x="278" y="223">

        <inputs val="&lt;inputs&gt;&lt;jobId class=&quot;java.lang.Integer&quot;&gt;xpath:{/workflow/variables/backupJobs}&lt;/jobId&gt;&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot;&gt;&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot;&gt;true&lt;/useImpersonatedAccount&gt;&lt;tokenFile class=&quot;java.lang.String&quot; /&gt;&lt;token class=&quot;java.lang.String&quot; /&gt;&lt;/sessionOptions&gt;&lt;/inputs&gt;" />

        <transition activity="Decision_14" commented="0" originalStyle="" points="" sourceX="357" sourceY="240" status="0" style="defaultEdge" targetX="251" targetY="304" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857806008" description="if/else based decision" displayName="Success?" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_14" waitSetting="0" width="100" x="197" y="280">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/WaitForJobCompletion_2/successful} &amp;amp;&amp;amp; xpath:{/workflow/variables/timeoutJobs}.size()==0 &amp;amp;&amp;amp; xpath:{/workflow/variables/failedClients}.size()==0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="WorkflowEnd_8" commented="0" displayName="Yes" offsetX="-3" offsetY="-2" originalStyle="" points="" sourceX="363" sourceY="687" status="0" style="defaultEdge" targetX="218" targetY="682" transitionIndex="0" value="true" x="-683" y="81">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="WorkflowEnd_9" commented="0" displayName="No" originalStyle="" points="" sourceX="247" sourceY="330" status="0" style="defaultEdge" targetX="256" targetY="453" transitionIndex="0" value="false" x="-171" y="5">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857832608" description="Ends the workflow" displayName="Completed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_8" waitSetting="0" width="119" x="374" y="313">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;COMPLETED&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1358857848434" description="Ends the workflow" displayName="Failed" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_9" waitSetting="0" width="119" x="190" y="421">

        <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;&gt;COMPLETED_WITH_ERRORS&lt;/completionStatus&gt;&lt;failureMessage class=&quot;java.lang.String&quot;&gt;one or more backup jobs failed to complete&lt;/failureMessage&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1359986336497" description="executes queries against the commserv database" displayName="Get Destination Snap details" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_10" waitSetting="0" width="189" x="304" y="119">

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;DECLARE @archGroupId INT = 0;&amp;#xD;&#xD;&#xA;DECLARE @archGroupCopyId INT = 0;&amp;#xD;&#xD;&#xA;DECLARE @SMRelationId INT = 0;&amp;#xD;&#xD;&#xA;DECLARE @ControlHostId INT = 0;&amp;#xD;&#xD;&#xA;DECLARE @SMArrayId NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @SMHostUserName NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @SMHostPassword NVARCHAR(2048)&amp;#xD;&#xD;&#xA;DECLARE @SMHostPortNumber INT&amp;#xD;&#xD;&#xA;DECLARE @sVolume NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @sSnapName1 NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @sSnapName NVARCHAR(1024)&amp;#xD;&#xD;&#xA;DECLARE @commcellId INT = 0;&amp;#xD;&#xD;&#xA;DECLARE @currentTime int = 0;&amp;#xD;&#xD;&#xA;SET @commcellId = (select id from APP_CommCell where aliasName=''xpath:{/workflow/system/commCellName}'');&amp;#xD;&#xD;&#xA;--SELECT @sSnapName &amp;#xD;&#xD;&#xA;--SET @currentTime = dbo.getunixtime(GETUTCDATE()); ''SP_'' + CAST(@commcellId as VARCHAR(40)); -- + ''_'' +&amp;#xD;&#xD;&#xA;--SET @sSnapName1 =   CAST(xpath:{/workflow/system/jobId} as VARCHAR(40)) ;&amp;#xD;&#xD;&#xA;SET @sSnapName = ''SP_'' + CAST(@commcellId as NVARCHAR(1024)) + ''_'' + CAST(xpath:{/workflow/system/jobId} as NVARCHAR(1024)) +''_'' + CAST(dbo.GetUnixTime(GETUTCDATE()) as NVARCHAR(1024));&amp;#xD;&#xD;&#xA;--logger.info (?The value of variable x is: [? + CAST(@commcellId as VARCHAR(40)) + &quot; Next&quot; + CAST(xpath:{/workflow/system/jobId} as VARCHAR(40)));&amp;#xD;&#xD;&#xA;--logger.info (?The value of variable x is: [? + @sSnapName1 );&amp;#xD;&#xD;&#xA;--+ CAST(@currentTime as NVARCHAR(24));&amp;#xD;&#xD;&#xA;SET @archGroupId = xpath:{/workflow/inputs/storagePolicy/storagePolicyId};&amp;#xD;&#xD;&#xA;SELECT @sSnapName&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @arrayNum INT = 0&amp;#xD;&#xD;&#xA;DECLARE @useTunneling INT = 0&amp;#xD;&#xD;&#xA;DECLARE @arrayClientId INT = 0&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @phyArrayNum INT = 0&amp;#xD;&#xD;&#xA;DECLARE @vServerName VARCHAR(1024) = ''''&amp;#xD;&#xD;&#xA;DECLARE @vPhysicalServer VARCHAR(1024) = ''''&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Get the archGroupCopyID&amp;#xD;&#xD;&#xA;SET @archGroupCopyId = (select defaultsnapcopy from archgroup where id=@archGroupId);&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--SELECT @archGroupCopyId &amp;#xD;&#xD;&#xA;--Get the SmrelationId&amp;#xD;&#xD;&#xA;SET @SMRelationId = (select smrelationid from smcopytorelationmap where ArchGroupCopyId=@archGroupCopyId);&amp;#xD;&#xD;&#xA;--SELECT @SMRelationId&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Select the vserver controlhostid&amp;#xD;&#xD;&#xA;SET @arrayNum =  (select vfilerid from SMRelationNode where SMRelationId = @SMRelationId);&amp;#xD;&#xD;&#xA;--SELECT  @arrayNum&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SET @sVolume = (select vFiler from SMRelationNode where SMRelationNodeId = (select SMRelationNodeid from SMRelationNode where SMRelationId=@SMRelationId));&amp;#xD;&#xD;&#xA;SELECT @arrayClientId = ClientId FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayNum&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;SET @useTunneling = (SELECT CONF.ValueInt &amp;#xD;&#xD;&#xA;                                  FROM SMControlHost HOST (NOLOCK) &amp;#xD;&#xD;&#xA;                    INNER JOIN SMConfigs CONF (NOLOCK) ON CONF.ArrayId = HOST.ControlHostId &amp;#xD;&#xD;&#xA;                                         AND CONF.AssocId = HOST.ControlHostId AND HOST.ControlHostId = @arrayNum&amp;#xD;&#xD;&#xA;                    INNER JOIN SMMasterConfigs MC(NOLOCK) ON MC.Id = CONF.MasterConfigId&amp;#xD;&#xD;&#xA;                        AND MC.KeyName = ''SMCONFIG_NAME_USE_TUNNELING'')&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;IF (@useTunneling = 1)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    SET @phyArrayNum = (SELECT HOST.ControlHostId FROM APP_VMToPMMap VMMAP (NOLOCK)&amp;#xD;&#xD;&#xA;                        INNER JOIN SMControlHost HOST(NOLOCK)&amp;#xD;&#xD;&#xA;                            ON VMMAP.PMClientId = HOST.ClientId AND VMMAP.VMClientId = @arrayClientId)&amp;#xD;&#xD;&#xA;                        &amp;#xD;&#xD;&#xA;    SET @vServerName = (SELECT PROP.attrVal FROM APP_ClientProp PROP&amp;#xD;&#xD;&#xA;                        WHERE PROP.componentNameId = @arrayClientId &amp;#xD;&#xD;&#xA;                        AND PROP.attrName = ''NAS vServer Name'')&amp;#xD;&#xD;&#xA;&#x9;&amp;#xD;&#xD;&#xA;      SELECT @SMarrayId=SMarrayId, @SMHostUserName=SMHostUserName, @SMHostPassword = SMHostPassword, @vServerName=@vServerName FROM SMControlHost (NOLOCK) WHERE ControlHostId = @phyArrayNum&amp;#xD;&#xD;&#xA;&#x9;  SET @vPhysicalServer = (SELECT SMarrayId FROM SMControlHost (NOLOCK) WHERE ControlHostId = @phyArrayNum)&amp;#xD;&#xD;&#xA;&#x9;  &amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;ELSE &amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;SELECT @SMarrayId=SMarrayId, @SMHostUserName=SMHostUserName, @SMHostPassword = SMHostPassword, @vServerName=@vServerName FROM SMControlHost (NOLOCK) WHERE ControlHostId = @arrayNum&amp;#xD;&#xD;&#xA;&#x9;   &amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;DECLARE @credsAssocId INT = -1&amp;#xD;&#xD;&#xA;DECLARE @ctrlHostId INT  = 0&amp;#xD;&#xD;&#xA;IF (@useTunneling = 1)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;SET @ctrlHostId = @phyArrayNum&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;ELSE&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;SET @ctrlHostId = @arrayNum&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;SET @credsAssocId = (SELECT CredentialId FROM SMControlHost WITH (NOLOCK) WHERE ControlHostId=@ctrlHostId) &amp;#xD;&#xD;&#xA;IF @credsAssocId &amp;gt; 0 --update credentials from credential manager&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;&#x9;DECLARE @Creds table&amp;#xD;&#xD;&#xA;&#x9;(&#x9;userName&#x9;&#x9;&#x9;&#x9;nvarchar(MAX),&amp;#xD;&#xD;&#xA;&#x9;&#x9;password&#x9;&#x9;&#x9;&#x9;nvarchar(MAX),&amp;#xD;&#xD;&#xA;&#x9;&#x9;credentialInfoXml   xml,&amp;#xD;&#xD;&#xA;&#x9;&#x9;flags&#x9;&#x9;&#x9;&#x9;int,&amp;#xD;&#xD;&#xA;&#x9;&#x9;recordType&#x9;&#x9;&#x9;int )&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;&#x9;INSERT INTO @Creds exec AppGetAssocToCMCredentials @credsAssocId, 0&amp;#xD;&#xD;&#xA;&#x9;SELECT @SMHostUserName = userName, @SMHostPassword = password FROM @Creds&amp;#xD;&#xD;&#xA;END&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;--Format the voluem naemm properly&amp;#xD;&#xD;&#xA;SET @sVolume = ''/'' + @vServerName + ''/'' + @sVolume&amp;#xD;&#xD;&#xA;&amp;#xD;&#xD;&#xA;select @SMArrayId As SMArrayId, @SMHostUserName As SMHostUserName, @SMHostPassword As SMHostPassword, @SMHostPortNumber As SMHostPortNumber, @sVolume As sVolume, @sSnapName As sSnapName, @vServerName As vServerName, @vPhysicalServer As vPhysicalServer&amp;#xD;&#xD;&#xA;&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="ExecuteCommand_4" commented="0" originalStyle="" points="" sourceX="374" sourceY="136" status="0" style="defaultEdge" targetX="505" targetY="140" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360006067577" description="if/else based decision" displayName="Succeeded" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_15" waitSetting="0" width="101" x="743" y="86">

        <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot;&gt;xpath:{/workflow/ExecuteCommand_4/exitCode}==0 &amp;amp;&amp;amp; xpath:{/workflow/ExecuteCommand_4/errorCode} == 0&lt;/expression&gt;&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;&gt;JAVA&lt;/scriptType&gt;&lt;/inputs&gt;" />

        <transition activity="Script_16" commented="0" displayName="No" offsetX="13" offsetY="-13" originalStyle="" points="792.0,63.0" sourceX="793" sourceY="136" status="0" style="defaultEdge" targetX="605" targetY="59" transitionIndex="0" value="false" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

        <transition activity="CommServDBQuery_9" commented="0" displayName="yes" originalStyle="" points="" sourceX="793" sourceY="136" status="0" style="defaultEdge" targetX="632" targetY="243" transitionIndex="0" value="true" x="0" y="0">

          <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360165593630" description="activity to execute code snippets in the selected language" displayName="Raise Error" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_15" waitSetting="0" width="104" x="314" y="51">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;all backup jobs failed to start&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1360165660652" description="activity to execute code snippets in the selected language" displayName="Raise Error" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_16" waitSetting="0" width="104" x="567" y="53">

        <inputs val="&lt;inputs&gt;&lt;script language=&quot;1&quot; script=&quot;workflow.setFailed(&amp;quot;failed to start master process&amp;quot;);&quot; /&gt;&lt;/inputs&gt;" />

      </Activity>

    </superProcess>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, flags = @flags

		WHERE Name = @name
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

