

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_SnapOperation.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_SnapOperation.script,v $ $Id: WFD_SnapOperation.script,v 1.5.2.4 2020/10/04 00:59:51 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @oldName nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.4 $'

SET @name = 'Snap-UserOperations'

SET @oldName = 'SnapOperation'

SET @description = 'Used for snapshot operations like mount, unmount, revert,  delete, and reconciliation.'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="0" 

	config="&lt;configuration />" 

	description="Used for snapshot operations like mount, unmount, revert,  delete, and reconciliation." 

	executeOnWeb="0" 

	inputs="&lt;inputs>&lt;jsoninput class=&quot;java.lang.String&quot; />&lt;basefol class=&quot;java.lang.String&quot; />&lt;instance class=&quot;java.lang.String&quot; />&lt;/inputs>" 

	interactive="0" 

	isHtmlDescription="0" 

	manualPercentageComplete="0" 

	name="Snap-UserOperations" 

	outputs="&lt;outputs />" 

	revision="$Revision: 1.5.2.4 $" 

	tags="" 

	uniqueGuid="818c0e79-a7e5-4f3f-90d5-cb823c51eb5d" 

	variables="&lt;variables>&lt;outmessage class=&quot;java.lang.String&quot; />&lt;errorcode class=&quot;java.lang.Integer&quot; />&lt;arguments class=&quot;java.lang.String&quot; />&lt;cmdToExecute class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/cmdToExecute>&lt;/variables>" 

	webHidden="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs" required="1" type=""/>

        <variables attribute="0" className="" listType="0" name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="outmessage" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="errorcode" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="arguments" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="cmdToExecute" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs" required="1" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="jsoninput" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="basefol" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instance" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="" type=""/>

    </schema>

    <Start breakpoint="0" commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="61" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="Script_2" commented="0" originalStyle="" points="" sourceX="75" sourceY="59" status="0" style="defaultEdge" targetX="115" targetY="152" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1409554036777" description="Execute a list of commands" displayName="ExecuteCommand" height="34" interactive="0" jobMode="0" maxRestarts="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" restartInterval="0" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="ExecuteCommand_1" waitSetting="0" width="147" x="227" y="65">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>java:{commvault.cte.workflow.WorkflowProperties.getInstance().getCommServClient()}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/basefol}&lt;/startUpPath>&lt;command class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/cmdToExecute}&lt;/command>&lt;arguments class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/arguments}&lt;/arguments>&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Script_1" commented="0" originalStyle="" points="" sourceX="300" sourceY="82" status="0" style="defaultEdge" targetX="250" targetY="235" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1409554195390" description="if/else based decision" displayName="Decision" height="100" interactive="0" jobMode="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_1" waitSetting="0" width="100" x="443" y="47">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteCommand_1/exitCode}==0 &amp;amp;&amp;amp; xpath:{/workflow/variables/errorcode}==0&lt;/expression>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_3" commented="0" displayName="No&#xd;&#xa;" originalStyle="" points="" sourceX="493" sourceY="97" status="0" style="defaultEdge" targetX="492" targetY="254" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="UpdateJobDescription_1" commented="0" originalStyle="" points="" sourceX="493" sourceY="97" status="0" style="defaultEdge" targetX="709" targetY="163" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1409554213606" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_2" waitSetting="0" width="119" x="776" y="48">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1409555162540" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_3" waitSetting="0" width="119" x="437" y="226">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/outmessage}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1412681618432" description="updates the job description for the workflow" displayName="UpdateJobDescription" height="34" interactive="0" jobMode="0" name="UpdateJobDescription" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=UpdateJobDescription" uniqueName="UpdateJobDescription_1" waitSetting="0" width="175" x="617" y="144">

        <inputs val="&lt;inputs>&lt;operation class=&quot;workflow.types.cmd.AppendOverwrite&quot;>overwrite&lt;/operation>&lt;jobDescription class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/outmessage}&lt;/jobDescription>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0" originalStyle="" points="" sourceX="704" sourceY="161" status="0" style="defaultEdge" targetX="813" targetY="60" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1412746605500" description="activity to execute code snippets in the selected language" displayName="Script" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_1" waitSetting="0" width="100" x="246" y="180">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;    &amp;#xD;&amp;#xA;    String outmsg = xpath:{/workflow/ExecuteCommand_1/commandOutput};&amp;#xD;&amp;#xA;    if(outmsg!=null || !outmsg.isEmpty())&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;       String[] outmsgarray = outmsg.split(&amp;quot;,&amp;quot;);&amp;#xD;&amp;#xA;       String msg=&amp;quot;&amp;quot;;&amp;#xD;&amp;#xA;       for(int i=1;i&amp;lt;outmsgarray.length;i++)&amp;#xD;&amp;#xA;            msg+=outmsgarray[i];&amp;#xD;&amp;#xA;       workflow.setVariable(&amp;quot;outmessage&amp;quot;,msg);&amp;#xD;&amp;#xA;       int ecode=Integer.parseInt(outmsgarray[0]);&amp;#xD;&amp;#xA;       xpath:{/workflow/ExecuteCommand_1/errorCode}=ecode;&amp;#xD;&amp;#xA;       workflow.setVariable(&amp;quot;errorcode&amp;quot;,ecode);&amp;#xD;&amp;#xA;   }&amp;#xD;&amp;#xA;   else&amp;#xD;&amp;#xA;   {&amp;#xD;&amp;#xA;     workflow.setVariable(&amp;quot;outmessage&amp;quot;,&amp;quot;Output of operation is NULL &amp;quot;);&amp;#xD;&amp;#xA;     workflow.setVariable(&amp;quot;errorcode&amp;quot;,1);&amp;#xD;&amp;#xA;   }&quot; />&lt;/inputs>"/>

        <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="251" sourceY="237" status="0" style="defaultEdge" targetX="493" targetY="92" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1426284933799" description="activity to execute code snippets in the selected language" displayName="Setting the command line arguments" height="34" interactive="0" jobMode="0" name="Script" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=Script" uniqueName="Script_2" waitSetting="0" width="200" x="108" y="6">

        <inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;String strJsonInput =  xpath:{/workflow/inputs/jsoninput};&amp;#xD;&amp;#xA;String strInstance = xpath:{/workflow/inputs/instance};&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if (strInstance== null || strInstance.isEmpty())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    workflow.setFailureReason(&amp;quot;Instance is not set properly.&amp;quot;);&amp;#xD;&amp;#xA;    workflow.setCompletedWithErrors(true);&amp;#x9;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;if (strJsonInput== null|| strJsonInput.isEmpty())&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;&amp;#x9;workflow.setFailureReason(&amp;quot;JSON file path is not set properly.&amp;quot;);&amp;#xD;&amp;#xA;&amp;#x9;workflow.setCompletedWithErrors(true);&amp;#x9;&amp;#x9;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;arguments&amp;quot;,&amp;quot;\&amp;quot;&amp;quot;+strJsonInput+&amp;quot;\&amp;quot; &amp;quot;+xpath:{/workflow/system/jobId}+&amp;quot; &amp;quot;+strInstance);&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;// By default keeping windows OS&amp;#xD;&amp;#xA;String osType = &amp;quot;windows&amp;quot;;&amp;#xD;&amp;#xA;String cmdToStore = &amp;quot;CvSnapOperation.exe&amp;quot;;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try{&amp;#xD;&amp;#xA;    DataSet ds = csdb.execute(&amp;quot;SELECT Type FROM simOperatingSystem WITH (READUNCOMMITTED) WHERE id = (SELECT simOperatingSystemId FROM APP_Client WITH (READUNCOMMITTED) WHERE id = 2)&amp;quot;);&amp;#xD;&amp;#xA;    &amp;#xD;&amp;#xA;    if (ds == null || ds.toString().equals(&amp;quot;&amp;quot;)) {&amp;#xD;&amp;#xA;        logger.info(&amp;quot;No result sent for CS host OS type&amp;quot;);&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Will try using default Windows.&amp;quot;);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        osType = ds.toString().toLowerCase();&amp;#xD;&amp;#xA;        logger.info(&amp;quot;Found OS Type: &amp;quot; + osType); &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;} catch(Exception e) {&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Failed to get the OS type for CS host.&amp;quot;);&amp;#xD;&amp;#xA;    logger.info(&amp;quot;Will try using default Windows.&amp;quot;);&amp;#xD;&amp;#xA;    logger.error(e.getMessage());&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;if(osType.equalsIgnoreCase(&amp;quot;unix&amp;quot;)){&amp;#xD;&amp;#xA;    cmdToStore = &amp;quot;CvSnapOperation&amp;quot;;&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;workflow.setVariable(&amp;quot;cmdToExecute&amp;quot;, cmdToStore);&amp;#xD;&amp;#xA;&quot; />&lt;/inputs>"/>

        <transition activity="ExecuteCommand_1" commented="0" originalStyle="" points="" sourceX="121" sourceY="149" status="0" style="defaultEdge" targetX="295" targetY="76" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

</workflow>'

IF not exists (select 1 from WF_Definition WITH (READUNCOMMITTED) where Name in  (@name, @oldName ))

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	DECLARE @currName nvarchar(255)

	IF exists (select 1 from WF_Definition WITH (READUNCOMMITTED) where Name =  @oldName )

	BEGIN

		SET @currName = @oldName

	END

	ELSE 

	BEGIN

		SET @currName = @name

	END

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision,'') From WF_Definition WITH (READUNCOMMITTED) WHERE Name = @currName

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision, name = @Name

		WHERE Name = @currName

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @Name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @currName, @description, @definition, @nowTime, 1)

	END

END

