

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_SearchEngineIndexUpgrader.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_SearchEngineIndexUpgrader.script,v $ $Id: WFD_SearchEngineIndexUpgrader.script,v 1.2 2015/07/08 18:55:25 aprasad Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER OFF

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.2 $'

SET @name = 'SearchEngineIndexUpgrader'

SET @description = 'Workflow to upgrade content indexed data to v11 version of solr'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" description="Workflow to upgrade content indexed data to v11 version of solr" inputs="&lt;inputs />" interactive="1" isHtmlDescription="0" name="SearchEngineIndexUpgrader" outputs="&lt;outputs />" revision="$Revision: 1.2 $" uniqueGuid="a244bf26-ea49-4f89-acf1-ff2c6739f00d" variables="&lt;variables>&lt;FailedNodes class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;SuccessNodes class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;RetryCount class=&quot;java.lang.Integer&quot;>2&lt;/RetryCount>&lt;bOptimizeComplete class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot; />&lt;/variables>">

    <Start breakpoint="0" commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="61" x="43" y="74">

        <transition activity="CommServDBQuery_2" commented="0" originalStyle="" points="" sourceX="73" sourceY="92" status="0" style="defaultEdge" targetX="315" targetY="137" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs />"/>

    </Start>

    <schema>

        <inputs attribute="0" className="" listType="0" name="inputs" required="1" type=""/>

        <outputs attribute="0" className="" listType="0" name="outputs" required="1" type=""/>

        <variables attribute="0" className="" listType="0" name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="FailedNodes" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="SuccessNodes" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="RetryCount" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.Boolean" controlType="5" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Boolean" listType="0" name="bOptimizeComplete" readOnly="0" required="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

        </variables>

    </schema>

    <formProperties css="" javaScript=""/>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430359795380" description="executes queries against the commserv database" displayName="Get All SearchEngine Clouds" height="34" interactive="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_2" waitSetting="0" width="200" x="175" y="97">

        <transition activity="PopupInput_1" commented="0" originalStyle="" points="" sourceX="362" sourceY="192" status="0" style="defaultEdge" targetX="365" targetY="312" transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;IF OBJECT_ID(''tempdb..#tmpSearchNodeList'', ''U'') IS NOT NULL&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;DROP TABLE #tmpSearchNodeList&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;CREATE TABLE #tmpSearchNodeList&amp;#xD;&#xd;&#xa;(&amp;#xD;&#xd;&#xa;   servername VARCHAR(250), &amp;#xD;&#xd;&#xa;   clientID INT,&amp;#xD;&#xd;&#xa;   clientName VARCHAR(250), &amp;#xD;&#xd;&#xa;   cloudId INT,&amp;#xD;&#xd;&#xa;   hostName VARCHAR(250), &amp;#xD;&#xd;&#xa;   basePort INT,&amp;#xD;&#xd;&#xa;   version  VARCHAR(250), &amp;#xD;&#xd;&#xa;   engineName VARCHAR(250)   &amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;INSERT INTO #tmpSearchNodeList(servername, clientID, clientName, cloudId, hostName, basePort, version, engineName)&amp;#xD;&#xd;&#xa;Exec appgetfastserverlist&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select distinct engineName from #tmpSearchNodeList&lt;/query>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430421020275" description="popups an input form for the user to fill out" displayName="Pick Search Cloud" height="34" interactive="0" name="PopupInput" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=PopupInput" uniqueName="PopupInput_1" waitSetting="0" width="134" x="200" y="178">

        <transition activity="AcquireLock_2" commented="0" originalStyle="" points="" sourceX="365" sourceY="312" status="0" style="defaultEdge" targetX="368" targetY="433" transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;inputs>&lt;Search_Cloud class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}&lt;/Search_Cloud>&lt;/inputs>&lt;subject>Pick Search Cloud&lt;/subject>&lt;formProperties />&lt;/inputs>"/>

        <activitySchema>

            <inputs attribute="0" className="" listType="0" name="inputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="Search_Cloud" readOnly="0" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}"/>

                </children>

            </inputs>

            <outputs attribute="0" className="" listType="0" name="outputs" required="1" type="">

                <children attribute="0" className="java.lang.String" controlType="2" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="Search_Cloud" readOnly="0" required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                    <options val="xpath:{/workflow/CommServDBQuery_2/resultSets/row/col}"/>

                </children>

                <children className="java.lang.Boolean" inputType="java.lang.Boolean" name="okClicked" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

                <children className="java.lang.String" inputType="java.lang.String" name="actionSelected" type="{http://www.w3.org/2001/XMLSchema}string"/>

            </outputs>

        </activitySchema>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430426181523" description="synchronizes a workflow per named parameter" displayName="AcquireLock" height="34" interactive="0" name="AcquireLock" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AcquireLock" uniqueName="AcquireLock_2" waitSetting="0" width="111" x="210" y="247">

        <transition activity="CommServDBQuery_4" commented="0" originalStyle="" points="" sourceX="265" sourceY="264" status="0" style="defaultEdge" targetX="264" targetY="385" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>xpath:{/workflow/system/workflow/workflowName}_xpath:{/workflow/PopupInput_1/Search_Cloud}&lt;/name>&lt;releaseLockOnCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/releaseLockOnCompletion>&lt;timeout class=&quot;java.lang.Integer&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430426273096" description="executes queries against the commserv database" displayName="Get SearchEngine Details" height="34" interactive="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_4" waitSetting="0" width="197" x="166" y="371">

        <transition activity="ForEach_1" commented="0" originalStyle="" points="" sourceX="365" sourceY="568" status="0" style="defaultEdge" targetX="1109" targetY="360" transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF OBJECT_ID(''tempdb..#tmpSearchEngine'', ''U'') IS NULL&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;CREATE TABLE #tmpSearchEngine&amp;#xD;&#xd;&#xa;(&amp;#xD;&#xd;&#xa;   servername VARCHAR(250), &amp;#xD;&#xd;&#xa;   clientID INT,&amp;#xD;&#xd;&#xa;   clientName VARCHAR(250), &amp;#xD;&#xd;&#xa;   cloudId INT,&amp;#xD;&#xd;&#xa;   hostName VARCHAR(250), &amp;#xD;&#xd;&#xa;   basePort INT,&amp;#xD;&#xd;&#xa;   version  VARCHAR(250), &amp;#xD;&#xd;&#xa;   engineName VARCHAR(250)   &amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;INSERT INTO #tmpSearchEngine(servername, clientID, clientName, cloudId, hostName, basePort, version, engineName)&amp;#xD;&#xd;&#xa;Exec appgetfastserverlist&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF OBJECT_ID(''tempdb..#TempList'', ''U'') IS NULL&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;CREATE TABLE #TempList&amp;#xD;&#xd;&#xa;(&amp;#xD;&#xd;&#xa;&#x9;id int identity(1,1),&amp;#xD;&#xd;&#xa;&#x9;SearchEngineName VARCHAR(250),&amp;#xD;&#xd;&#xa;&#x9;BasePort&#x9;&#x9; VARCHAR(10),&amp;#xD;&#xd;&#xa;&#x9;OptimizeLink&#x9; VARCHAR(300),&amp;#xD;&#xd;&#xa;&#x9;OccupiedSpace&#x9; bigint,&amp;#xD;&#xd;&#xa;&#x9;FreeSpace&#x9;&#x9; bigint,&amp;#xD;&#xd;&#xa;&#x9;IsOptimized      INT DEFAULT(0)&amp;#xD;&#xd;&#xa;)&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;INSERT INTO #TempList(SearchEngineName, BasePort)&amp;#xD;&#xd;&#xa;select hostName, baseport from #tmpSearchEngine where engineName=''xpath:{/workflow/PopupInput_1/Search_Cloud}''&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;UPDATE #TempList SET OptimizeLink=(select ''http://'' + searchengineName + '':'' + BasePort + ''/update?optimize=true'')&amp;#xD;&#xd;&#xa;UPDATE #TempList SET OccupiedSpace = d.OccupiedSpace, FreeSpace = d.FreeSpace  FROM DM2SearchServerCoreInfo d,#TempList t where d.ServiceLink like ''%'' + t.SearchEngineName + ''%''&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;select * from #TempList where IsOptimized=0&amp;#xD;&#xd;&#xa; &lt;/query>&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430427614863" description="iterates a group of activities over a list of values" displayName="ForEach" height="484" interactive="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0" width="796" x="699" y="65">

        <superProcess>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430444042576" description="performs http operations" displayName="Upgrade Index" height="34" interactive="0" name="HttpClient" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=HttpClient" uniqueName="HttpClient_1" waitSetting="0" width="128" x="534" y="294">

                <transition activity="Decision_2" commented="0" originalStyle="" points="" sourceX="544" sourceY="416" status="0" style="defaultEdge" targetX="398" targetY="441" transitionIndex="0" x="20" y="88">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/ForEach_1/row/col[@name=&quot;OptimizeLink&quot;]}&lt;/url>&lt;method>GET&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430447302482" description="if/else based decision" displayName="Does Node have enough Resource?" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1;whiteSpace=wrap" uniqueName="Decision_1" waitSetting="0" width="200" x="499" y="140">

                <transition activity="HttpClient_1" commented="0" displayName="Yes" originalStyle="" points="" sourceX="303" sourceY="293" status="0" style="defaultEdge" targetX="525" targetY="423" transitionIndex="0" value="true" x="20" y="88">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="AddToList_1" commented="0" displayName="No" originalStyle="" points="" sourceX="372" sourceY="265" status="0" style="defaultEdge" targetX="111" targetY="424" transitionIndex="0" value="false" x="20" y="88">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;FreeSpace&quot;]} &amp;gt; xpath:{/workflow/ForEach_1/row/col[@name=&quot;OccupiedSpace&quot;]}&lt;/expression>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430447546346" description="utility to add objects to a list" displayName="Failed Nodes" height="34" interactive="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_1" waitSetting="0" width="115" x="241" y="173">

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/FailedNodes}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;engineName&quot;]}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430447673188" description="if/else based decision" displayName="Index Upgrade State" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_2" waitSetting="0" width="167" x="216" y="277">

                <onExit language="1" script=" xpath:{/workflow/variables/bOptimizeComplete} = false;"/>

                <transition activity="AddToList_1" commented="0" displayName="Failed" originalStyle="" points="" sourceX="351" sourceY="428" status="0" style="defaultEdge" targetX="151" targetY="427" transitionIndex="0" value="false" x="20" y="88">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <transition activity="ExecuteScript_4" commented="0" displayName="Succeeded" originalStyle="" points="" sourceX="299" sourceY="327" status="0" style="defaultEdge" targetX="290" targetY="435" transitionIndex="0" value="true" x="0" y="0">

                    <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;> xpath:{/workflow/variables/bOptimizeComplete} == true&lt;/expression>&lt;/inputs>"/>

                <onEnter language="1" script="String ResponseText =  xpath:{/workflow/HttpClient_1/statusText};&#xd;&#xa;xpath:{/workflow/variables/bOptimizeComplete} = false;&#xd;&#xa;if ( ResponseText != null )&#xd;&#xa;{&#xd;&#xa;    if( ResponseText.indexOf(&quot;QTime&quot;) != -1 )&#xd;&#xa;    {&#xd;&#xa;    }&#xd;&#xa;    else&#xd;&#xa;    {&#xd;&#xa;        xpath:{/workflow/variables/bOptimizeComplete} = true;&#xd;&#xa;    }&#xd;&#xa;}"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430447796254" description="utility to add objects to a list" displayName="Success Nodes" height="34" interactive="0" name="AddToList" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=AddToList" uniqueName="AddToList_2" waitSetting="0" width="128" x="554" y="354">

                <transition activity="CommServDBQuery_6" commented="0" originalStyle="" points="" sourceX="618" sourceY="371" status="0" style="defaultEdge" targetX="636" targetY="443" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;addToList class=&quot;java.lang.String&quot;>xpath:{/workflow/variables/SuccessNodes}&lt;/addToList>&lt;itemToAdd class=&quot;java.lang.Object&quot;>xpath:{/workflow/ForEach_1/row/col[@name=&quot;engineName&quot;]}&lt;/itemToAdd>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430773560955" description="executes queries against the commserv database" displayName="Record Succeeded Node Info" height="34" interactive="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_6" waitSetting="0" width="200" x="527" y="434">

                <inputs val="&lt;inputs>&lt;commCell />&lt;query>update #TempList SET IsOptimized=1 where SearchEngineName = xpath:{/workflow/ForEach_1/row/col[&quot;name=engineName&quot;]}&lt;/query>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430842667410" description="" displayName="Disable Search Engine" height="34" interactive="0" name="ExecuteScript" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=ExecuteScript" uniqueName="ExecuteScript_3" waitSetting="0" width="157" x="520" y="65">

                <transition activity="Decision_1" commented="0" originalStyle="" points="" sourceX="599" sourceY="77" status="0" style="defaultEdge" targetX="599" targetY="150" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>DisableSearchEngineNode&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-si xpath:{/workflow/ForEach_1/row/col[@name=&quot;SearchEngineName&quot;]}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430842939872" description="" displayName="Enable Search Engine" height="34" interactive="0" name="ExecuteScript" namespaceUri="commvault.cte.workflow.activities.cmd.operation" originalStyle="" skipAttempt="0" style="label;image=ExecuteScript" uniqueName="ExecuteScript_4" waitSetting="0" width="153" x="222" y="428">

                <transition activity="AddToList_2" commented="0" originalStyle="" points="" sourceX="304" sourceY="445" status="0" style="defaultEdge" targetX="557" targetY="374" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs>&lt;scriptName class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>EnableSearchEngineNode&lt;/scriptName>&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>-si xpath:{/workflow/ForEach_1/row/col[@name=&quot;SearchEngineName&quot;]}&lt;/arguments>&lt;sessionOptions class=&quot;workflow.types.cmd.SessionOptions&quot; _list_=&quot;false&quot;>&lt;useImpersonatedAccount class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>true&lt;/useImpersonatedAccount>&lt;tokenFile class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;token class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/sessionOptions>&lt;/inputs>"/>

            </Activity>

            <Start breakpoint="0" commented="0" continueOnFailure="0" created="1430427614863" description="" displayName="Start" height="30" interactive="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2" waitSetting="0" width="120" x="339" y="67">

                <transition activity="ExecuteScript_3" commented="0" originalStyle="" points="" sourceX="383" sourceY="78" status="0" style="defaultEdge" targetX="548" targetY="72" transitionIndex="0" x="0" y="0">

                    <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

                </transition>

                <inputs val="&lt;inputs />"/>

            </Start>

        </superProcess>

        <transition activity="Decision_3" commented="0" originalStyle="" points="" sourceX="1097" sourceY="307" status="0" style="defaultEdge" targetX="780" targetY="638" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;name class=&quot;java.lang.String&quot;>row&lt;/name>&lt;values class=&quot;java.lang.Object&quot;>xpath:{/workflow/CommServDBQuery_4/resultSets/row}&lt;/values>&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot;>8&lt;/numberOfParallelExecutions>&lt;continueOnFailure class=&quot;java.lang.Boolean&quot;>true&lt;/continueOnFailure>&lt;/inputs>"/>

        <activitySchema>

            <inputs>

                <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer"/>

                <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            </inputs>

            <outputs name="outputs">

                <children className="workflow.types.data.DataRow" inputType="workflow.types.data.DataRow" listType="0" name="row" type="{workflow.types.data}DataRow">

                    <children className="java.lang.Object" inputType="java.lang.Object" listType="1" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType"/>

                </children>

            </outputs>

        </activitySchema>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430770180563" description="if/else based decision" displayName="Retry Needed?" height="100" interactive="0" name="Decision" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Decision_3" waitSetting="0" width="127" x="722" y="630">

        <transition activity="CommServDBQuery_4" commented="0" displayName="Yes" offsetX="-33" offsetY="137" originalStyle="" points="257.0,477.0" sourceX="785" sourceY="680" status="0" style="defaultEdge" targetX="331" targetY="355" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_8" commented="0" displayName="No" originalStyle="" points="" sourceX="785" sourceY="680" status="0" style="defaultEdge" targetX="994" targetY="680" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;> xpath:{/workflow/variables/RetryCount} == 0 &lt;/expression>&lt;/inputs>"/>

        <onEnter language="1" script="xpath:{/workflow/variables/RetryCount} = xpath:{/workflow/variables/RetryCount} - 1"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430770214502" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_1" waitSetting="0" width="119" x="977" y="732">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; />&lt;failureMessage class=&quot;java.lang.String&quot; />&lt;/inputs>"/>

    </Activity>

    <Activity breakpoint="0" commented="0" continueOnFailure="0" created="1430792039305" description="executes queries against the commserv database" displayName="Drop Temp Tables" height="34" interactive="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="CommServDBQuery_8" waitSetting="0" width="162" x="958" y="662">

        <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="1057" sourceY="677" status="0" style="defaultEdge" targetX="1055" targetY="787" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SET NOCOUNT ON&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF OBJECT_ID(''tempdb..#tmpSearchEngine'', ''U'') IS NOT NULL&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;DROP TABLE #tmpSearchEngine&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF OBJECT_ID(''tempdb..#TempList'', ''U'') IS NOT NULL&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;DROP TABLE #TempList&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&lt;/query>&lt;/inputs>"/>

    </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = revision From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END


