

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_ScheduleHTTPCallback.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/ 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_ScheduleHTTPCallback.script,v $ $Id: WFD_ScheduleHTTPCallback.script,v 1.1.2.5 2020/10/04 00:50:52 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @oldname nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.5 $'

SET @oldname = 'HTTPCallback'

SET @name = 'HTTP Callback'

SET @description = 'Schedule callback to REST API'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="0" description=""

    inputs="&lt;inputs>&lt;Url class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;ApiName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;Id class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="0" isHtmlDescription="0" name="HTTP Callback"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.5 $"

    uniqueGuid="c34554cd-5283-4535-a473-6bba03d0f91c"

    variables="&lt;variables />" workflowId="0">

	<schema>

		<outputs className="" name="outputs" type=""/>

		<variables className="" name="variables" type=""/>

		<inputs attribute="0" className="" name="inputs" type="">

			<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="Url" type="{http://www.w3.org/2001/XMLSchema}string"/>

			<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="ApiName" type="{http://www.w3.org/2001/XMLSchema}string"/>

			<children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="Id" type="{http://www.w3.org/2001/XMLSchema}string"/>

		</inputs>

	</schema>

	<Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="58" x="45" y="41">

		<inputs val="&lt;inputs />"/>

		<transition activity="RESTAPICall" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="80" targetY="185"

            transitionIndex="0" x="0" y="0">

			<condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

		</transition>

	</Start>

	<Activity commented="0" continueOnFailure="0"

        created="1462205451690" description="performs http operations"

        displayName="RESTAPICall" height="34" interactive="0"

        jobMode="0" name="HttpClient"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=HttpClient"

        uniqueName="RESTAPICall" waitSetting="0" width="100" x="30" y="168">

		<inputs val="&lt;inputs>&lt;request>&lt;url>xpath:{/workflow/inputs/Url}/xpath:{/workflow/inputs/ApiName}&lt;/url>&lt;method>POST&lt;/method>&lt;postType>Raw&lt;/postType>&lt;postContent>&lt;/postContent>&lt;postContentType>application/xml; charset=UTF-8&lt;/postContentType>&lt;parameters>&lt;name>Id&lt;/name>&lt;value>xpath:{/workflow/inputs/Id}&lt;/value>&lt;/parameters>&lt;parameters>&lt;name>jobId&lt;/name>&lt;value>xpath:{/workflow/system/jobId}&lt;/value>&lt;/parameters>&lt;headers>&lt;name>Authtoken&lt;/name>&lt;value>QSDKONLY xpath:{/workflow/system/token}&lt;/value>&lt;/headers>&lt;headers>&lt;name>Accept&lt;/name>&lt;value>application/json&lt;/value>&lt;/headers>&lt;/request>&lt;/inputs>"/>

			<transition activity="ValidateRestAPIOutput" commented="0"

            originalStyle="" points="" sourceX="80" sourceY="185"

            status="0" style="defaultEdge" targetX="90" targetY="268"

            transitionIndex="0" x="0" y="0">

				<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

			</transition>

		</Activity>

		<Activity commented="0" continueOnFailure="0"

        created="1430932650665"

        description="activity to execute code snippets in the selected language"

        displayName="ValidateRestAPIOutput" height="34" interactive="0"

        jobMode="0" name="Script"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=Script"

        uniqueName="ValidateRestAPIOutput" waitSetting="0" width="159"

        x="14" y="267">

			<inputs val="&lt;inputs>&lt;script language=&quot;1&quot; script=&quot;import commvault.msgs.DM2ContentIndexing.*;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLDecoder;&amp;#xD;&amp;#xA;import commvault.cte.common.xml.XMLEncoder;&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;try&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    Integer statusCode = new Integer(xpath:{/workflow/RESTAPICall/statusCode});&amp;#xD;&amp;#xA;&amp;#xD;&amp;#xA;    String sErrorMsg = &amp;quot;REST API[&amp;quot;+xpath:{/workflow/inputs/ApiName}+&amp;quot;]  &amp;quot;;&amp;#xD;&amp;#xA;    if ( statusCode != 200 )&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        sErrorMsg += &amp;quot;  Http call failed with code : &amp;quot;+ statusCode.toString() +  &amp;quot;  reason: &amp;quot; + xpath:{/workflow/RESTAPICall/statusText};&amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt; &amp;quot;+ sErrorMsg +&amp;quot; &amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        workflow.setFailed(sErrorMsg);&amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;    else&amp;#xD;&amp;#xA;    {&amp;#xD;&amp;#xA;        commvault.msgs.DM2ContentIndexing.Error oError = (commvault.msgs.DM2ContentIndexing.Error)XMLDecoder.decode(xpath:{/workflow/RESTAPICall/output});&amp;#xD;&amp;#xA;        Integer __NOERROR = new Integer(0);&amp;#xD;&amp;#xA;        Integer iErr = new Integer(oError.getErrorCode()); &amp;#xD;&amp;#xA;        logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;Error Code &amp;quot; + iErr.toString() +  &amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        &amp;#xD;&amp;#xA;        if(iErr.equals(__NOERROR))&amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt; call succeeded &amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;        }&amp;#xD;&amp;#xA;        else &amp;#xD;&amp;#xA;        {&amp;#xD;&amp;#xA;            sErrorMsg += oError.getErrLogMessage();&amp;#xD;&amp;#xA;            logger.info(&amp;quot;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt; &amp;quot;+sErrorMsg+&amp;quot; &amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;gt;&amp;quot;);&amp;#xD;&amp;#xA;            workflow.setFailed(sErrorMsg);&amp;#xD;&amp;#xA;        }    &amp;#xD;&amp;#xA;    }&amp;#xD;&amp;#xA;}&amp;#xD;&amp;#xA;catch(Exception e)&amp;#xD;&amp;#xA;{&amp;#xD;&amp;#xA;    workflow.setFailed(&amp;quot;Error while forming the request:&amp;quot;+ e.getMessage());     &amp;#xD;&amp;#xA;}&quot; />&lt;/inputs>"/>

				<transition activity="WorkflowEnd_1" commented="0"

            originalStyle="" status="0" style="defaultEdge"

            transitionIndex="0" x="0" y="0">

					<condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

				</transition>

			</Activity>

			<Activity commented="0" continueOnFailure="0"

        created="1464711536872" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd"

        uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="28" y="352">

				<inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/failureMessage>&lt;/inputs>"/>

				</Activity>

			</workflow>'

--first do name change operation to update workflow name old to new name

-- else old workflow continues to remain in system

--

IF exists (select * from WF_Definition where Name = @oldname)														

BEGIN

	IF not exists (select * from WF_Definition where Name = @name)

	BEGIN

		UPDATE WF_Definition 

		SET Name = @name where Name=@oldname 

	END

	ELSE

	BEGIN

		DELETE FROM WF_Definition Where Name = @oldname

	END

END

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

