

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_SQLServerRelocateTempDb.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_SQLServerRelocateTempDb.script,v $ $Id: WFD_SQLServerRelocateTempDb.script,v 1.1.2.1 2020/05/08 04:45:17 abilbrey Exp $";
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

GO

DECLARE @definition		XML

DECLARE @version		INT

DECLARE @flags			INT

DECLARE @guid			VARCHAR(40)

DECLARE @revision		NVARCHAR(255)

SET @revision = '$Revision: 1.1.2.1 $'

SET @version = 1

SET @flags = 6

SET @guid = 'CDA40278-BF0C-446C-B971-417D30F9990D'

SET @definition = '

<workflow apiMode="0" config="&lt;configuration />"

    description="The purpose of this Work Flow is to move the SQL Server TempDb from its current directory location to another directory location. &#xa;&#xa;Note after TempDb has successufly been reconfigured to a new directory location, the Commvault Services must be stopped and SQL Server restarted to complete the actual move of TempDb to the new directory location.&#xa;&#xa;The user must have Commcell Admin rights to execute this Work Flow.&#xa;"

    executeOnWeb="0"

    inputs="&lt;inputs>&lt;MovePath class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>&lt;/MovePath>&lt;/inputs>"

    interactive="0" isHtmlDescription="0" manualPercentageComplete="0"

    name="SQL Server Relocate TempDb" outputs="&lt;outputs />"

    revision="$Revision: 1.1.2.1 $" tags=""

    uniqueGuid="05df0180-cef6-4899-ad1b-0f4cb6490aee"

    variables="&lt;variables>&lt;NewTempDbPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;InputError class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;>false&lt;/InputError>&lt;ExeError class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;>0&lt;/ExeError>&lt;ExeMsg class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs className="" name="outputs" type=""/>

        <variables attribute="0" className="" name="variables" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="NewTempDbPath" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Boolean"

                controlType="5" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Boolean" listType="0"

                name="InputError" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}boolean"/>

            <children attribute="0" className="java.lang.Integer"

                controlType="0" defaultValue="" displayName=""

                documentation="" hidden="0"

                inputType="java.lang.Integer" listType="0"

                name="ExeError" readOnly="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.String" listType="0" name="ExeMsg" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </variables>

        <inputs className="" name="inputs" type="">

            <children alignment="1" attribute="0"

                className="java.lang.String" controlHidden="0"

                controlType="0" defaultValue=""

                displayName="Input new TempDb data and log file directory path"

                documentation="Directory must exist and contain no files."

                hidden="0" inputType="java.lang.String" listType="0"

                maximumValue="" minimumValue="" name="MovePath"

                readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

        <inputs val="&lt;inputs />"/>

        <transition activity="ImpersonateCreator_1" commented="0"

            originalStyle="" points="" sourceX="72" sourceY="59"

            status="0" style="defaultEdge" targetX="284" targetY="100"

            transitionIndex="0" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="0"

        created="1588093074712"

        description="impersonates the user who created the workflow"

        displayName="ImpersonateCreator" height="34" interactive="0"

        jobMode="0" name="ImpersonateCreator"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.ImpersonateCreator"

        uniqueName="ImpersonateCreator_1" waitSetting="0" width="145"

        x="212" y="83">

        <onExit language="1" script="String  path = xpath:{/workflow/inputs/MovePath};&#xd;&#xa;workflow.setVariable(&quot;NewTempDbPath&quot;, path);&#xd;&#xa;logger.info(&quot;NewTempDbPath [&quot; + path + &quot;]&quot;);&#xd;&#xa;"/>

        <inputs val="&lt;inputs />"/>

        <transition activity="CommServDBQuery_1" commented="0"

            originalStyle="" points="" sourceX="284" sourceY="100"

            status="0" style="defaultEdge" targetX="312" targetY="222"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1588093520733"

        description="executes queries against a commcell database"

        displayName="Move TempDb" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_1" waitSetting="0" width="143"

        x="241" y="205">

        <onExit language="1" script="Integer errCode = xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row/col[@name=&quot;errorCode&quot;]};&#xd;&#xa;String errMsg = xpath:{/workflow/CommServDBQuery_1/resultSets[1]/row/col[@name=&quot;errorMsg&quot;]};&#xd;&#xa;logger.info(&quot;DIAGRelocateTempDb error [&quot; + errCode.toString() + &quot;:&quot; + errMsg + &quot;]&quot;);&#xd;&#xa;workflow.setVariable(&quot;ExeError&quot;, errCode);&#xd;&#xa;workflow.setVariable(&quot;ExeMsg&quot;, errMsg);"/>

        <inputs val="&lt;inputs>&lt;commCell>&lt;/commCell>&lt;query>SET NOCOUNT ON;&amp;#xD;&#xd;&#xa;USE Commserv;&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Input Arguments&amp;#xD;&#xd;&#xa;DECLARE @TempDbPath NVARCHAR(512) = ?;&amp;#xD;&#xd;&#xa;DECLARE @userId INT = ?&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;-- Verify the executing user has CC Admin rights&amp;#xD;&#xd;&#xa;DECLARE @isUserAdmin INT = 0&amp;#xD;&#xd;&#xa;EXEC sec_isUserAdmin @i_userid=@userId, @o_isUserAdmin=@isUserAdmin OUTPUT&amp;#xD;&#xd;&#xa;&amp;#xD;&#xd;&#xa;IF (@isUserAdmin = 1)&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    -- Attenpt to relocate the TempDb now&amp;#xD;&#xd;&#xa;    DECLARE @rc INT = 0;&amp;#xD;&#xd;&#xa;    EXEC @rc = SQLServerRelocateTempDb @path=@TempDbPath&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;ELSE&amp;#xD;&#xd;&#xa;BEGIN&amp;#xD;&#xd;&#xa;    -- User is not CC Admin&amp;#xD;&#xd;&#xa;    SELECT 1 errorCode, ''Executing user is NOT a Commcell Admin.'' errorMsg&amp;#xD;&#xd;&#xa;END&amp;#xD;&#xd;&#xa;&lt;/query>&lt;parameters>&lt;value>xpath:{/workflow/variables/NewTempDbPath}&lt;/value>&lt;type>STRING&lt;/type>&lt;/parameters>&lt;parameters>&lt;value>xpath:{/workflow/system/executor/userId}&lt;/value>&lt;type>INTEGER&lt;/type>&lt;/parameters>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            displayName="SP Failure" originalStyle="" points=""

            sourceX="312" sourceY="222" status="0" style="defaultEdge"

            targetX="555" targetY="227" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/variables/ExeError} == 1;"/>

        </transition>

        <transition activity="WorkflowEnd_3" commented="0"

            displayName="SP Successful" originalStyle="" points=""

            sourceX="312" sourceY="222" status="0" style="defaultEdge"

            targetX="359" targetY="332" transitionIndex="0" x="0" y="0">

            <condition language="1" script="xpath:{/workflow/variables/ExeError} == 0;&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1588094625417" description="Ends the workflow"

        displayName="TempDb Move Failed" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="146" x="482" y="210">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/ExeMsg}&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1588094985849" description="Ends the workflow"

        displayName="TempDb Move Configured" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_3" waitSetting="0" width="175" x="272" y="315">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED_WITH_ERRORS&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Services must be shutdown and SQL Server restarted to complete the moving of TempDb data and log files to the new directory.&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>

'

DECLARE @wfName NVARCHAR(255)

SELECT

	@wfName = d.value('@name', 'NVARCHAR(255)')

FROM @definition.nodes('/workflow') w(d)

PRINT 'Updating Work Flow Definition: ' + @wfName

DECLARE @rc INT

EXEC @rc = WFDUpdateWorkFlowDefinition @guid, @version, @flags, @revision, @definition

