

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_SAPMAXDB.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.1.2.4 $'

SET @name = 'SAPMAXDB'

SET @description = 'Performs SAP MaxDB backup'

SET @version = 1

SET @flags = 30

SET @definition = '<workflow apiMode="0" config="&lt;configuration />"

    description="Performs SAP MaxDB backup" executeOnWeb="0"

    inputs="&lt;inputs>&lt;CV_MAXDB_CLIENT_NAME class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>&lt;clientName />&lt;clientId />&lt;/CV_MAXDB_CLIENT_NAME>&lt;CV_BACKUP_TYPE class=&quot;java.lang.String&quot; _list_=&quot;true&quot; />&lt;CV_MAXDB_SUPERDBA_USER class=&quot;java.lang.String&quot; />&lt;CV_MAXDB_SUPERDBA_PASSWORD class=&quot;workflow.types.EncryptedString&quot; />&lt;CV_DBMCLI_PATH class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>/opt/sdb/MaxDB/bin&lt;/CV_DBMCLI_PATH>&lt;CV_MAXDB_SUPERDBA_PASSWORD_CONFIRM class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; />&lt;CV_MAXDB_INSTANCE_NAME class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;/inputs>"

    interactive="0" isHtmlDescription="0" name="SAPMAXDB"

    outputs="&lt;outputs />" revision="$Revision: 1.1.2.4 $" tags=""

    uniqueGuid="26f6c549-0506-4121-949d-4d28c1daf5cc"

    variables="&lt;variables>&lt;DATA_PIPE class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;PAGES_PIPE class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;LOGS_PIPE class=&quot;java.lang.String&quot; _list_=&quot;false&quot; />&lt;NOT_SAVED class=&quot;java.lang.Float&quot; _list_=&quot;false&quot; />&lt;/variables>"

    webHidden="0" workflowId="0">

    <schema>

        <outputs attribute="0" className="" listType="0" name="outputs"

            required="1" type=""/>

        <variables attribute="0" className="" listType="0"

            name="variables" required="1" type="">

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="DATA_PIPE" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="PAGES_PIPE" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="0" defaultValue="" displayName=""

                hidden="0" inputType="java.lang.String" listType="0"

                name="LOGS_PIPE" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.Float"

                controlType="0" defaultValue="" hidden="0"

                inputType="java.lang.Float" listType="0"

                name="NOT_SAVED" type="{http://www.w3.org/2001/XMLSchema}float"/>

        </variables>

        <inputs attribute="0" className="" listType="0" name="inputs"

            required="1" type="">

            <children attribute="0"

                className="commvault.msgs.CvEntities.ClientEntity"

                controlHidden="0" controlType="2"

                displayName="Select your client" documentation=""

                hidden="0"

                inputType="commvault.msgs.CvEntities.ClientEntity"

                listType="0" maximumValue="" minimumValue=""

                name="CV_MAXDB_CLIENT_NAME" readOnly="0" required="1"

                searchable="0" type="{commvault.msgs.CvEntities}ClientEntity">

                <children attribute="0" className="java.lang.String"

                    inputType="java.lang.String" listType="0"

                    name="clientName" required="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

                <children attribute="0" className="java.lang.Integer"

                    inputType="java.lang.Integer" listType="0"

                    name="clientId" required="0" type="{http://www.w3.org/2001/XMLSchema}integer"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Enter the DB instance name"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="CV_MAXDB_INSTANCE_NAME" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0" className="java.lang.String"

                controlType="4" displayName="Select the backup type"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="1" name="CV_BACKUP_TYPE" readOnly="0"

                required="1" type="{http://www.w3.org/2001/XMLSchema}string">

                <options val="online_full"/>

                <options val="offline_full"/>

                <options val="online_incr"/>

                <options val="offline_incr"/>

                <options val="log_backup"/>

            </children>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0"

                displayName="Enter the username to connect to DB"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="CV_MAXDB_SUPERDBA_USER" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlHidden="0" controlType="0"

                displayName="Enter the password to connect to DB"

                documentation="" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                maximumValue="" minimumValue=""

                name="CV_MAXDB_SUPERDBA_PASSWORD" readOnly="0"

                required="1" searchable="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0"

                className="workflow.types.EncryptedString"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Confirm the password to connect to DB"

                documentation="" hidden="0"

                inputType="workflow.types.EncryptedString" listType="0"

                maximumValue="" minimumValue=""

                name="CV_MAXDB_SUPERDBA_PASSWORD_CONFIRM" readOnly="0"

                required="1" searchable="0" type="{workflow.types}EncryptedString"/>

            <children attribute="0" className="java.lang.String"

                controlHidden="0" controlType="0" defaultValue=""

                displayName="Enter the path to dbmcli executable"

                documentation="" hidden="0" inputType="java.lang.String"

                listType="0" maximumValue="" minimumValue=""

                name="CV_DBMCLI_PATH" readOnly="0" required="1"

                searchable="0" type="{http://www.w3.org/2001/XMLSchema}string"/>

        </inputs>

        <config className="" name="configuration" type=""/>

    </schema>

    <Start commented="0" continueOnFailure="0" created="0"

        description="" displayName="Start" height="36" interactive="0"

        jobMode="0" name="Start" originalStyle="" skipAttempt="0"

        style="image;image=/images/jgraphx/house.png"

        uniqueName="Start_1" waitSetting="0" width="61" x="-12" y="181">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_31" commented="0"

            originalStyle="" points="" sourceX="18" sourceY="199"

            status="0" style="defaultEdge" targetX="233" targetY="293"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Start>

    <Activity commented="0" continueOnFailure="1"

        created="1402940307561"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_1"

        waitSetting="0" width="162" x="1259" y="176">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/DATA_PIPE} Recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_1" commented="0"

            originalStyle="" points="" sourceX="1340" sourceY="193"

            status="0" style="defaultEdge" targetX="1517" targetY="73"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1402948451764" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_1" waitSetting="0" width="100" x="1735" y="4">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_1/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1370"

            sourceY="223" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1472" targetY="220" transitionIndex="0"

            value="false" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1384"

            sourceY="220" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="718" targetY="770" transitionIndex="0" value="true"

            x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403106254677" description="switch based decision"

        displayName="Switch" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_1" waitSetting="0" width="100" x="505" y="453">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE}&lt;/expression>&lt;/inputs>"/>

        <transition activity="LogEvent_1" commented="0"

            displayName="Online Full" originalStyle=""

            points="617.0,467.0;643.0,325.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="229" targetY="230" transitionIndex="0"

            value="online_full" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_2" commented="0"

            displayName="Online Incr" originalStyle=""

            points="619.0,485.0;643.0,394.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="227" targetY="378" transitionIndex="0"

            value="online_incr" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_4" commented="0"

            displayName="offline Full" originalStyle=""

            points="621.0,503.0;643.0,467.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="241" targetY="874" transitionIndex="0"

            value="offline_full" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_3" commented="0"

            displayName="Log Backup" originalStyle=""

            points="619.0,521.0;643.0,541.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="256" targetY="589" transitionIndex="0"

            value="log_backup" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_5" commented="0"

            displayName="offline_incr" originalStyle=""

            points="617.0,539.0;643.0,615.0" sourceX="99" sourceY="236"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="251" targetY="1119" transitionIndex="0"

            value="offline_incr" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1403109708427"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_2"

        waitSetting="0" width="163" x="1257" y="276">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/PAGES_PIPE} recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_2" commented="0"

            originalStyle="" points="" sourceX="1338" sourceY="293"

            status="0" style="defaultEdge" targetX="1509" targetY="201"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110057608" description="if/else based decision"

        displayName="Decision" height="83" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_3" waitSetting="0" width="79" x="1649" y="414">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_3/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_34" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1664"

            sourceY="392" status="0" style="defaultEdge" targetX="1760"

            targetY="400" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1381"

            sourceY="644" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1535" targetY="669" transitionIndex="0"

            value="true" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110158978"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online incr Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_2" waitSetting="0" width="200" x="656" y="376">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_2" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="393"

            status="0" style="defaultEdge" targetX="1029" targetY="350"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110488058"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_1" waitSetting="0" width="162" x="679" y="307">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online full backup of xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} on xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_1" commented="0"

            originalStyle="" points="" sourceX="760" sourceY="324"

            status="0" style="defaultEdge" targetX="992" targetY="267"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110605118"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Transaction Log Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_3" waitSetting="0" width="200" x="656" y="523">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting transaction log backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_33" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="540"

            status="0" style="defaultEdge" targetX="1103" targetY="503"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1403110729888"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Transaction Log Backup"

        height="34" interactive="0" jobMode="0" maxRestarts="0"

        name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_3"

        waitSetting="0" width="198" x="1242" y="479">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/LOGS_PIPE}&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_5" commented="0"

            originalStyle="" points="" sourceX="1341" sourceY="496"

            status="0" style="defaultEdge" targetX="1521" targetY="425"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1403110945748" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_2" waitSetting="0" width="100" x="1735" y="134">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_2/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1379"

            sourceY="424" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1575" targetY="425" transitionIndex="0"

            value="true" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1379"

            sourceY="424" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1376" targetY="536" transitionIndex="0"

            value="false" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404379598826"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline full backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_4" waitSetting="0" width="202" x="655" y="442">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline full backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_3" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="465"

            status="0" style="defaultEdge" targetX="1028" targetY="425"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404379752471" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_4" waitSetting="0" width="100" x="1735" y="264">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_4/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1407"

            sourceY="871" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1406" targetY="1017" transitionIndex="0"

            value="false" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1407"

            sourceY="871" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1529" targetY="858" transitionIndex="0"

            value="True" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1404380254893"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_4"

        waitSetting="0" width="187" x="1242" y="377">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/DATA_PIPE} Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_4" commented="0"

            originalStyle="" points="" sourceX="1335" sourceY="394"

            status="0" style="defaultEdge" targetX="1525" targetY="350"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404397428991"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline incr backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_5" waitSetting="0" width="202" x="655" y="590">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_5" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="613"

            status="0" style="defaultEdge" targetX="1060" targetY="609"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1404397440431"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_5"

        waitSetting="0" width="187" x="1246" y="612">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/PAGES_PIPE} Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_6" commented="0"

            originalStyle="" points="" sourceX="1335" sourceY="598"

            status="0" style="defaultEdge" targetX="1526" targetY="546"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1404397467359" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_5" waitSetting="0" width="100" x="1735" y="524">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_5/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1409"

            sourceY="1107" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1659" targetY="1187" transitionIndex="0"

            value="True" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1409"

            sourceY="1107" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1414" targetY="1209" transitionIndex="0"

            value="false" x="587" y="-15">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1454926568914"

        description="executes queries against a commcell database"

        displayName="Find Client OS Type" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=CommServDBQuery"

        uniqueName="CommServDBQuery_2" waitSetting="0" width="167"

        x="308" y="669">

        <onExit language="1" script="logger.info(&quot;Operating System Type of client is &quot; + xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]});"/>

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>SELECT sos.Type&amp;#xD;&#xd;&#xa;FROM [CommServ].[dbo].[APP_Client] client, simOperatingSystem sos&amp;#xD;&#xd;&#xa;WHERE client.[name] = ''xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}''&amp;#xD;&#xd;&#xa;AND sos.id = client.simOperatingSystemId&lt;/query>&lt;/inputs>"/>

        <transition activity="ExecuteScript_31" commented="0"

            displayName="UNIX" originalStyle="" points="" sourceX="139"

            sourceY="61" status="0"

            style="defaultEdge;noEdgeStyle=1;orthogonal=1" targetX="136"

            targetY="332" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]}.equals(&quot;Unix&quot;)"/>

        </transition>

        <transition activity="ExecuteScript_32" commented="0"

            displayName="Windows" originalStyle="" points=""

            sourceX="139" sourceY="61" status="0"

            style="defaultEdge;noEdgeStyle=1;orthogonal=1" targetX="202"

            targetY="838" transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;xpath:{/workflow/CommServDBQuery_2/resultSets[1]/row[1]/col[1]}.equals(&quot;Windows&quot;)"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807754"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_26"

        waitSetting="0" width="162" x="1259" y="668">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/DATA_PIPE} Recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_7" commented="0"

            originalStyle="" points="" sourceX="1340" sourceY="685"

            status="0" style="defaultEdge" targetX="1544" targetY="638"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807769" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_26" waitSetting="0" width="100" x="1735" y="654">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_26/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1493"

            sourceY="862" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="827" targetY="1412" transitionIndex="0"

            value="true" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1479"

            sourceY="865" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1581" targetY="862" transitionIndex="0"

            value="false" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807796" description="switch based decision"

        displayName="Switch" height="100" interactive="0" jobMode="0"

        name="Switch" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Switch_6" waitSetting="0" width="100" x="505" y="757">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE}&lt;/expression>&lt;/inputs>"/>

        <transition activity="LogEvent_27" commented="0"

            displayName="Online Full" originalStyle=""

            points="617.0,771.0;643.0,689.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="338" targetY="872" transitionIndex="0"

            value="online_full" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_26" commented="0"

            displayName="Online Incr" originalStyle=""

            points="619.0,789.0;643.0,757.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="336" targetY="1020" transitionIndex="0"

            value="online_incr" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_29" commented="0"

            displayName="offline Full" originalStyle=""

            points="621.0,807.0;643.0,831.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="350" targetY="1516" transitionIndex="0"

            value="offline_full" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_28" commented="0"

            displayName="Log Backup" originalStyle=""

            points="619.0,825.0;643.0,905.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="365" targetY="1231" transitionIndex="0"

            value="log_backup" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_30" commented="0"

            displayName="offline_incr" originalStyle=""

            points="617.0,843.0;643.0,979.0" sourceX="208" sourceY="878"

            status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="360" targetY="1761" transitionIndex="0"

            value="offline_incr" x="109" y="642">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807810"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Online Incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_27"

        waitSetting="0" width="163" x="1257" y="736">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/PAGES_PIPE} recovery&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_8" commented="0"

            originalStyle="" points="" sourceX="1338" sourceY="753"

            status="0" style="defaultEdge" targetX="1530" targetY="775"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807827" description="if/else based decision"

        displayName="Decision" height="69" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_27" waitSetting="0" width="79" x="1660" y="1052">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_28/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1490"

            sourceY="1286" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1644" targetY="1311" transitionIndex="0"

            value="true" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_35" commented="0"

            displayName="No" originalStyle="" points="" sourceX="1699"

            sourceY="1086" status="0" style="defaultEdge" targetX="1760"

            targetY="1072" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807842"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online incr Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_26" waitSetting="0" width="200" x="656" y="739">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_9" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="756"

            status="0" style="defaultEdge" targetX="1007" targetY="767"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807860"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Online Full Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_27" waitSetting="0" width="162" x="679" y="671">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting online full backup of xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} on xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_6" commented="0"

            originalStyle="" points="" sourceX="760" sourceY="688"

            status="0" style="defaultEdge" targetX="1057" targetY="714"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807877"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Transaction Log Backup" height="34"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_28" waitSetting="0" width="200" x="656" y="887">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting transaction log backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="ExecuteScript_34" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="904"

            status="0" style="defaultEdge" targetX="1012" targetY="918"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807893"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Transaction Log Backup"

        height="34" interactive="0" jobMode="0" maxRestarts="0"

        name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_28"

        waitSetting="0" width="198" x="1237" y="1013">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_warm&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/LOGS_PIPE}&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_10" commented="0"

            originalStyle="" points="" sourceX="1341" sourceY="890"

            status="0" style="defaultEdge" targetX="1544" targetY="996"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807921" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_28" waitSetting="0" width="100" x="1735" y="784">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_27/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1488"

            sourceY="1066" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1684" targetY="1067" transitionIndex="0"

            value="true" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1488"

            sourceY="1066" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1485" targetY="1178" transitionIndex="0"

            value="false" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807940"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline full backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_29" waitSetting="0" width="202" x="655" y="806">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline full backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_8" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="829"

            status="0" style="defaultEdge" targetX="1040" targetY="843"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807958" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_29" waitSetting="0" width="100" x="1735" y="914">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_29/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1516"

            sourceY="1513" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1515" targetY="1659" transitionIndex="0"

            value="false" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1516"

            sourceY="1513" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1638" targetY="1500" transitionIndex="0"

            value="True" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368807973"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline full Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_29"

        waitSetting="0" width="187" x="1242" y="805">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold &amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/DATA_PIPE} Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_9" commented="0"

            originalStyle="" points="" sourceX="1335" sourceY="822"

            status="0" style="defaultEdge" targetX="1530" targetY="865"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368807991"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent&#xa;Offline incr backup" height="46"

        interactive="0" jobMode="0" name="LogEvent"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="label;image=LogEvent"

        uniqueName="LogEvent_30" waitSetting="0" width="202" x="655" y="954">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot;>Starting offline incremental backup of MaxDB database xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}&lt;/message>&lt;/inputs>"/>

        <transition activity="DisableLogging_10" commented="0"

            originalStyle="" points="" sourceX="756" sourceY="977"

            status="0" style="defaultEdge" targetX="1018" targetY="981"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1460368808008"

        description="Execute a script on a remote machine"

        displayName="ExecuteScript&#xa;Offline incr Backup" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_30"

        waitSetting="0" width="187" x="1242" y="1088">

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} db_cold&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -uUTL -c backup_start xpath:{/workflow/variables/PAGES_PIPE} Migration&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="EnableLogging_11" commented="0"

            originalStyle="" points="" sourceX="1335" sourceY="1105"

            status="0" style="defaultEdge" targetX="1532" targetY="1100"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1460368808037" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_30" waitSetting="0" width="100" x="1735" y="1174">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_30/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="YES" originalStyle="" points="" sourceX="1518"

            sourceY="1749" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1768" targetY="1829" transitionIndex="0"

            value="True" x="696" y="626">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="NO" originalStyle="" points="" sourceX="1264"

            sourceY="1762" status="0"

            style="edgeStyle=mxEdgeStyle.EntityRelation;noEdgeStyle=1;orthogonal=1"

            targetX="1269" targetY="1864" transitionIndex="0"

            value="false" x="442" y="639">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510640975548" description="if/else based decision"

        displayName="DB_Password_validation" height="100"

        interactive="0" jobMode="0" name="Decision"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_31" waitSetting="0" width="200" x="138" y="278">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.equals(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD_CONFIRM})&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="CommServDBQuery_3" commented="0"

            displayName="Matches" originalStyle="" points=""

            sourceX="224" sourceY="328" status="0" style="defaultEdge"

            targetX="313" targetY="440" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_32" commented="0"

            displayName="Mismatch" originalStyle="" points=""

            sourceX="224" sourceY="328" status="0" style="defaultEdge"

            targetX="384" targetY="326" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510642367669"

        description="executes queries against a commcell database"

        displayName="MaxDB instance" height="34" interactive="0"

        jobMode="0" name="CommServDBQuery"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.CommServDBQuery"

        uniqueName="CommServDBQuery_3" waitSetting="0" width="143"

        x="150" y="427">

        <inputs val="&lt;inputs>&lt;commCell />&lt;query>select name from APP_InstanceName where id in (select instance from APP_application where clientid = (SELECT [id] FROM [CommServ].[dbo].[APP_Client] where name = ''xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}'') and apptypeid = 79) and name != ''defaultDummyInstanceForSAP'' and name = ''xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME}''&lt;/query>&lt;/inputs>"/>

        <transition activity="Decision_32" commented="0"

            originalStyle="" points="" sourceX="221" sourceY="444"

            status="0" style="defaultEdge" targetX="212" targetY="502"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510663160814" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_2" waitSetting="0" width="122" x="498" y="240">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Password Mismatch&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510663254750"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_32" waitSetting="0" width="100" x="377" y="307">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Workflow failed to execute because the DB Passwords did not match.&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_2" commented="0"

            originalStyle="" points="" sourceX="420" sourceY="325"

            status="0" style="defaultEdge" targetX="582" targetY="259"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510664170562" description="if/else based decision"

        displayName="Decision" height="100" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_32" waitSetting="0" width="100" x="162" y="493">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/CommServDBQuery_3/resultSets/rowCount}&amp;gt;0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="LogEvent_33" commented="0"

            displayName="Instance not present" originalStyle=""

            points="" sourceX="212" sourceY="543" status="0"

            style="defaultEdge" targetX="426" targetY="419"

            transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="CommServDBQuery_2" commented="0"

            displayName="Instance present" originalStyle="" points=""

            sourceX="211" sourceY="543" status="0" style="defaultEdge"

            targetX="319" targetY="690" transitionIndex="0" value="true"

            x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1510664220228"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_33" waitSetting="0" width="100" x="376" y="402">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>The instance with the name: xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} was not present in the client: xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_8" commented="0"

            originalStyle="" points="" sourceX="426" sourceY="419"

            status="0" style="defaultEdge" targetX="500" targetY="380"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1513321659482" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_4" waitSetting="0" width="122" x="2304" y="264">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE} backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} Failed&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1513321849257" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_7" waitSetting="0" width="122" x="2322" y="983">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>COMPLETED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/inputs/CV_BACKUP_TYPE} backup for instance xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} Completed&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017400418"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_1" waitSetting="0" width="117"

        x="983" y="251">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_1" commented="0"

            originalStyle="" points="" sourceX="1041" sourceY="268"

            status="0" style="defaultEdge" targetX="1276" targetY="187"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017498943"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_2" waitSetting="0" width="117"

        x="979" y="329">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_2" commented="0"

            originalStyle="" points="" sourceX="1045" sourceY="343"

            status="0" style="defaultEdge" targetX="1278" targetY="301"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017499806"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_3" waitSetting="0" width="117"

        x="981" y="418">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_4" commented="0"

            originalStyle="" points="" sourceX="1039" sourceY="435"

            status="0" style="defaultEdge" targetX="1300" targetY="396"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017500102"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_4" waitSetting="0" width="117"

        x="977" y="490">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_3" commented="0"

            originalStyle="" points="" sourceX="1132" sourceY="501"

            status="0" style="defaultEdge" targetX="1264" targetY="493"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017500350"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_5" waitSetting="0" width="117"

        x="979" y="619">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_5" commented="0"

            originalStyle="" points="" sourceX="1106" sourceY="609"

            status="0" style="defaultEdge" targetX="1243" targetY="587"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017500846"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_6" waitSetting="0" width="117"

        x="983" y="671">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_26" commented="0"

            originalStyle="" points="" sourceX="1085" sourceY="715"

            status="0" style="defaultEdge" targetX="1281" targetY="681"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521017501190"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_7" waitSetting="0" width="117"

        x="1251" y="948">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_28" commented="0"

            originalStyle="" points="" sourceX="1047" sourceY="921"

            status="0" style="defaultEdge" targetX="1276" targetY="895"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018392282"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_8" waitSetting="0" width="117"

        x="981" y="838">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_29" commented="0"

            originalStyle="" points="" sourceX="1057" sourceY="849"

            status="0" style="defaultEdge" targetX="1289" targetY="820"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018392970"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_9" waitSetting="0" width="117"

        x="980" y="756">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_27" commented="0"

            originalStyle="" points="" sourceX="1039" sourceY="773"

            status="0" style="defaultEdge" targetX="1298" targetY="748"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018408162"

        description="turns off all logging, except for errors, for current job"

        displayName="DisableLogging" height="34" interactive="0"

        jobMode="0" name="DisableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingDisable"

        uniqueName="DisableLogging_10" waitSetting="0" width="117"

        x="989" y="1016">

        <inputs val="&lt;inputs />"/>

        <transition activity="ExecuteScript_30" commented="0"

            originalStyle="" points="" sourceX="1064" sourceY="989"

            status="0" style="defaultEdge" targetX="1292" targetY="1112"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018535300"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_1" waitSetting="0" width="113"

        x="1511" y="58">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_1" commented="0" originalStyle=""

            points="" sourceX="1535" sourceY="76" status="0"

            style="defaultEdge" targetX="1798" targetY="53"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018543048"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_2" waitSetting="0" width="113"

        x="1515" y="171">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_2" commented="0" originalStyle=""

            points="" sourceX="1572" sourceY="188" status="0"

            style="defaultEdge" targetX="1748" targetY="188"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018543568"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_4" waitSetting="0" width="113"

        x="1522" y="309">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_4" commented="0" originalStyle=""

            points="" sourceX="1578" sourceY="326" status="0"

            style="defaultEdge" targetX="1746" targetY="307"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018543720"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_5" waitSetting="0" width="113"

        x="1518" y="423">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_3" commented="0" originalStyle=""

            points="" sourceX="1575" sourceY="440" status="0"

            style="defaultEdge" targetX="1742" targetY="450"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018543864"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_6" waitSetting="0" width="113"

        x="1513" y="548">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_5" commented="0" originalStyle=""

            points="" sourceX="1569" sourceY="565" status="0"

            style="defaultEdge" targetX="1748" targetY="576"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018544000"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_7" waitSetting="0" width="113"

        x="1519" y="683">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_26" commented="0"

            originalStyle="" points="" sourceX="1576" sourceY="700"

            status="0" style="defaultEdge" targetX="1742" targetY="707"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018544136"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_8" waitSetting="0" width="113"

        x="1527" y="816">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_28" commented="0"

            originalStyle="" points="" sourceX="1584" sourceY="833"

            status="0" style="defaultEdge" targetX="1744" targetY="817"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018544280"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_9" waitSetting="0" width="113"

        x="1528" y="947">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_29" commented="0"

            originalStyle="" points="" sourceX="1584" sourceY="964"

            status="0" style="defaultEdge" targetX="1740" targetY="959"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018544416"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_10" waitSetting="0" width="113"

        x="1528" y="1074">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_27" commented="0"

            originalStyle="" points="" sourceX="1584" sourceY="1091"

            status="0" style="defaultEdge" targetX="1790" targetY="1096"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1521018544560"

        description="turns on all logging for the current job"

        displayName="EnableLogging" height="34" interactive="0"

        jobMode="0" name="EnableLogging"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LoggingEnable"

        uniqueName="EnableLogging_11" waitSetting="0" width="113"

        x="1526" y="1213">

        <inputs val="&lt;inputs />"/>

        <transition activity="Decision_30" commented="0"

            originalStyle="" points="" sourceX="1583" sourceY="1230"

            status="0" style="defaultEdge" targetX="1748" targetY="1221"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1524825192750" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_8" waitSetting="0" width="122" x="497" y="350">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Wrong instance name provided. Specified instance does not exists.&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1529319712891" description="if/else based decision"

        displayName="Decision" height="78" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_34" waitSetting="0" width="79" x="1747" y="373">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_3/commandOutput}.contains(&quot;-123, No more log to save&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="No" originalStyle="" points="" sourceX="1784"

            sourceY="422" status="0" style="defaultEdge" targetX="1889"

            targetY="398" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1786"

            sourceY="412" status="0" style="defaultEdge" targetX="1935"

            targetY="435" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1529320963275" description="if/else based decision"

        displayName="Decision" height="78" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_35" waitSetting="0" width="79" x="1760" y="1031">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot;>xpath:{/workflow/ExecuteScript_28/commandOutput}.contains(&quot;-123, No more log to save&quot;)&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_4" commented="0"

            displayName="No" originalStyle="" points="" sourceX="1800"

            sourceY="1070" status="0" style="defaultEdge" targetX="1892"

            targetY="1079" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="WorkflowEnd_7" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1799"

            sourceY="1070" status="0" style="defaultEdge" targetX="1935"

            targetY="1106" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1567149529066"

        description="Execute a script on a remote machine"

        displayName="Get Pipe Names" height="34" interactive="0"

        jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_32"

        waitSetting="0" width="163" x="314" y="800">

        <onExit language="1" script="String s1=xpath:{/workflow/ExecuteScript_32/commandOutput};&#xd;&#xa;String[] pipes=s1.split(&quot;splitter&quot;);&#xd;&#xa;String[] data_pipes=pipes[0].split(&quot;\\\\&quot;);&#xd;&#xa;String[] pages_pipes=pipes[1].split(&quot;\\\\&quot;);&#xd;&#xa;String[] log_pipes=pipes[2].split(&quot;\\\\&quot;);&#xd;&#xa;workflow.setVariable(&quot;DATA_PIPE&quot;,data_pipes[0].replace(&quot;\&quot;&quot;,&quot;&quot;).trim());&#xd;&#xa;workflow.setVariable(&quot;PAGES_PIPE&quot;,pages_pipes[0].replace(&quot;\&quot;&quot;,&quot;&quot;).trim());&#xd;&#xa;workflow.setVariable(&quot;LOGS_PIPE&quot;,log_pipes[0].replace(&quot;\&quot;&quot;,&quot;&quot;).trim());"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>@ECHO OFF&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | findstr DATA | findstr PIPE&amp;#xD;echo &quot;splitter&quot;&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | findstr PAGES | findstr PIPE&amp;#xD;echo &quot;splitter&quot;&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | findstr LOG | findstr PIPE&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_37" commented="0"

            originalStyle="" points="" sourceX="395" sourceY="817"

            status="0" style="defaultEdge" targetX="400" targetY="888"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1567146472242"

        description="Execute a script on a remote machine"

        displayName="Get pipe names" height="34" interactive="0"

        jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_31"

        waitSetting="0" width="162" x="316" y="572">

        <onExit language="1" script="String s1=xpath:{/workflow/ExecuteScript_31/commandOutput};&#xd;&#xa;String[] words=s1.split(&quot;/&quot;);&#xd;&#xa;workflow.setVariable(&quot;DATA_PIPE&quot;,words[0]);&#xd;&#xa;workflow.setVariable(&quot;PAGES_PIPE&quot;,words[1]);&#xd;&#xa;workflow.setVariable(&quot;LOGS_PIPE&quot;,words[2]);"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;a=`dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | grep PIPE | grep DATA -m 1 | awk -F''\'' ''{print $1}''`&amp;#xD;b=`dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | grep PIPE | grep PAGES -m 1 | awk -F''\'' ''{print $1}''`&amp;#xD;c=`dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} medium_getall | grep PIPE | grep LOG -m 1 | awk -F''\'' ''{print $1}''`&amp;#xD;echo $a/$b/$c&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_36" commented="0"

            originalStyle="" points="" sourceX="397" sourceY="589"

            status="0" style="defaultEdge" targetX="524" targetY="634"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1567606520716" description="if/else based decision"

        displayName="Decision" height="73" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_37" waitSetting="0" width="79" x="359" y="870">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_32/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="LogEvent_34" commented="0"

            displayName="No" originalStyle=""

            points="230.0,868.6666666666666" sourceX="398" sourceY="906"

            status="0" style="defaultEdge" targetX="195" targetY="770"

            transitionIndex="0" value="false" x="10" y="10">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Switch_6" commented="0" displayName="Yes"

            originalStyle="" points="" sourceX="398" sourceY="906"

            status="0" style="defaultEdge" targetX="565" targetY="805"

            transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1567606554060"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_34" waitSetting="0" width="100" x="145" y="753">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>MINOR&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Unable to get the PIPE name from client&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_9" commented="0"

            originalStyle="" points="" sourceX="195" sourceY="770"

            status="0" style="defaultEdge" targetX="197" targetY="969"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1567606658837" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_9" waitSetting="0" width="122" x="136" y="952">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Unable to get the PIPE names from client&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1567606518031" description="if/else based decision"

        displayName="Decision" height="69" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_36" waitSetting="0" width="79" x="507" y="600">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_31/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Switch_1" commented="0" displayName="YES"

            originalStyle="" points="" sourceX="546" sourceY="634"

            status="0" style="defaultEdge" targetX="541" targetY="549"

            transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_34" commented="0"

            displayName="NO" originalStyle="" points="504.0,740.0"

            sourceX="546" sourceY="634" status="0" style="defaultEdge"

            targetX="236" targetY="761" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1568615982831"

        description="Execute a script on a remote machine"

        displayName="Check log backup needed" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_33"

        waitSetting="0" width="176" x="932" y="550">

        <onExit language="1" script="String s1=xpath:{/workflow/ExecuteScript_33/commandOutput};&#xd;&#xa;String[] words=s1.split(&quot;=&quot;);&#xd;&#xa;workflow.setVariable(&quot;NOT_SAVED&quot;,Float.parseFloat(words[1].trim()));"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>UnixShell&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>export PATH=xpath:{/workflow/inputs/CV_DBMCLI_PATH}:$PATH&amp;#xD;dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -c info log | grep &quot;Not Saved&quot; | grep &quot;KB&quot;&amp;#xD;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_38" commented="0"

            originalStyle="" points="" sourceX="1020" sourceY="567"

            status="0" style="defaultEdge" targetX="1169" targetY="596"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568616250230" description="if/else based decision"

        displayName="Decision" height="75" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_38" waitSetting="0" width="79" x="1130" y="559">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_33/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="LogEvent_35" commented="0"

            displayName="No" originalStyle="" points="" sourceX="1169"

            sourceY="597" status="0" style="defaultEdge" targetX="127"

            targetY="720" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="Decision_39" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1169"

            sourceY="596" status="0" style="defaultEdge" targetX="1280"

            targetY="555" transitionIndex="0" value="true" x="10" y="10">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568616496331"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_35" waitSetting="0" width="100" x="48" y="707">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>MINOR&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Unable to get Used page percent from client&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_10" commented="0"

            originalStyle="" points="" sourceX="98" sourceY="724"

            status="0" style="defaultEdge" targetX="101" targetY="933"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568616541808" description="Ends the workflow"

        displayName="WorkflowEnd" height="34" interactive="0"

        jobMode="0" name="WorkflowEnd"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.EndActivity"

        uniqueName="WorkflowEnd_10" waitSetting="0" width="122" x="40" y="916">

        <inputs val="&lt;inputs>&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot;>FAILED&lt;/completionStatus>&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Unable to get Used page percent from client&lt;/failureMessage>&lt;/inputs>"/>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568616296026" description="if/else based decision"

        displayName="Decision" height="75" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_39" waitSetting="0" width="79" x="1241" y="518">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/NOT_SAVED}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="DisableLogging_4" commented="0"

            displayName="Perform log backup" originalStyle="" points=""

            sourceX="1251" sourceY="557" status="0" style="defaultEdge"

            targetX="1073" targetY="521" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_36" commented="0"

            displayName="Skip log backup" originalStyle="" points=""

            sourceX="1280" sourceY="556" status="0" style="defaultEdge"

            targetX="1365" targetY="560" transitionIndex="0"

            value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568619330857"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_36" waitSetting="0" width="100" x="1493" y="507">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Log backup is skipped as there were no logs to backup.&amp;#xD;&#xd;&#xa;Used Size: xpath:{/workflow/ExecuteScript_33/commandOutput}&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            originalStyle="" points="" sourceX="1543" sourceY="524"

            status="0" style="defaultEdge" targetX="2373" targetY="1008"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="1"

        created="1568617533761"

        description="Execute a script on a remote machine"

        displayName="check log backup needed" height="34"

        interactive="0" jobMode="0" name="ExecuteScript"

        namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=ExecuteScript" uniqueName="ExecuteScript_34"

        waitSetting="0" width="175" x="972" y="915">

        <onExit language="1" script="String s1=xpath:{/workflow/ExecuteScript_34/commandOutput};&#xd;&#xa;String[] words=s1.split(&quot;=&quot;);&#xd;&#xa;workflow.setVariable(&quot;NOT_SAVED&quot;,Float.parseFloat(words[1].trim()));"/>

        <inputs val="&lt;inputs>&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot;>xpath:{/workflow/inputs/CV_MAXDB_CLIENT_NAME/clientName}&lt;/client>&lt;impersonateUserName class=&quot;java.lang.String&quot; />&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; />&lt;startUpPath class=&quot;java.lang.String&quot; />&lt;scriptType class=&quot;commvault.msgs.App.ScriptType&quot;>WindowsBatch&lt;/scriptType>&lt;script class=&quot;java.lang.String&quot;>@ECHO OFF&amp;#xD;xpath:{/workflow/inputs/CV_DBMCLI_PATH}\dbmcli -d xpath:{/workflow/inputs/CV_MAXDB_INSTANCE_NAME} -u xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_USER},java:{utils.decryptString(xpath:{/workflow/inputs/CV_MAXDB_SUPERDBA_PASSWORD}.getEncryptedText())} -c info log | findstr /I &quot;Not&quot; | findstr /I &quot;Saved&quot; | findstr /I &quot;KB&quot;&lt;/script>&lt;arguments class=&quot;java.lang.String&quot; />&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot;>true&lt;/waitForProcessCompletion>&lt;/inputs>"/>

        <transition activity="Decision_40" commented="0"

            originalStyle="" points="" sourceX="1059" sourceY="932"

            status="0" style="defaultEdge" targetX="1236" targetY="915"

            transitionIndex="0" x="10" y="10">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568626124586" description="if/else based decision"

        displayName="Decision" height="62" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_40" waitSetting="0" width="79" x="1197" y="884">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/ExecuteScript_34/exitCode}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="Decision_41" commented="0"

            displayName="Yes" originalStyle="" points="" sourceX="1236"

            sourceY="915" status="0" style="defaultEdge" targetX="1389"

            targetY="890" transitionIndex="0" value="true" x="10" y="10">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_35" commented="0"

            displayName="No" originalStyle=""

            points="1211.5942028985507,831.8840579710146" sourceX="1236"

            sourceY="915" status="0" style="defaultEdge" targetX="137"

            targetY="726" transitionIndex="0" value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568626130481" description="if/else based decision"

        displayName="Decision" height="61" interactive="0" jobMode="0"

        name="Decision" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1"

        uniqueName="Decision_41" waitSetting="0" width="79" x="1350" y="860">

        <inputs val="&lt;inputs>&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>xpath:{/workflow/variables/NOT_SAVED}==0&lt;/expression>&lt;scriptType class=&quot;workflow.types.ScriptType&quot; _list_=&quot;false&quot;>JAVA&lt;/scriptType>&lt;/inputs>"/>

        <transition activity="DisableLogging_7" commented="0"

            displayName="Backup log" originalStyle="" points=""

            sourceX="1383" sourceY="910" status="0" style="defaultEdge"

            targetX="1327" targetY="953" transitionIndex="0"

            value="false" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

        <transition activity="LogEvent_37" commented="0"

            displayName="Skipping log backup" originalStyle=""

            points="1452.1739130434785,952.1739130434784" sourceX="1389"

            sourceY="890" status="0" style="defaultEdge" targetX="1594"

            targetY="1021" transitionIndex="0" value="true" x="0" y="0">

            <condition script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <Activity commented="0" continueOnFailure="0"

        created="1568629925996"

        description="logs an event in the commcell console with the specified severity level"

        displayName="LogEvent" height="34" interactive="0" jobMode="0"

        name="LogEvent" namespaceUri="commvault.cte.workflow.activities"

        originalStyle="" skipAttempt="0"

        style="label;image=commvault.cte.workflow.activities.LogEventActivity"

        uniqueName="LogEvent_37" waitSetting="0" width="100" x="1544" y="1004">

        <inputs val="&lt;inputs>&lt;severity class=&quot;workflow.types.SeverityLevel&quot; _list_=&quot;false&quot;>INFO&lt;/severity>&lt;message class=&quot;java.lang.String&quot; _list_=&quot;false&quot;>Log backup is skipped as there were no logs to backup.&amp;#xD;&#xd;&#xa;Used Size: xpath:{/workflow/ExecuteScript_33/commandOutput}&lt;/message>&lt;/inputs>"/>

        <transition activity="WorkflowEnd_7" commented="0"

            originalStyle="" points="" sourceX="1594" sourceY="1021"

            status="0" style="defaultEdge" targetX="2350" targetY="1011"

            transitionIndex="0" x="0" y="0">

            <condition language="1" script="/*&#xa;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xa;activity.exitCode==0;&#xa;*/&#xa;"/>

        </transition>

    </Activity>

    <formProperties css="" formVersion="0" javaScript="" pageMode="0">

        <rules/>

    </formProperties>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	IF (@currentFlags & 4 > 0 OR @flags & 8 > 0 OR @flags & 16 > 0) AND (@currentRevision <> @revision)

	BEGIN

		SET @version = @version + 1

		UPDATE WF_Definition

		SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

		WHERE Name = @name

		IF (@flags & 8 > 0 OR @flags & 16 > 0)

		BEGIN

			UPDATE WF_Definition

			SET flags = @flags

			WHERE Name = @name

		END
		INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


		VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

	END

END

