

--  ------------  Generated from [../../../Source/CommServer/Db/TblScript/WFD_ReviewSetMigration.script] ---------- 


SET QUOTED_IDENTIFIER OFF

-- ALLOW_COMMENTS_BELOW_HERE:

-- ----------------------------------------------------------------------

--

--           Copyright \(c\) 1998  CommVault Systems, Inc.

--                  All rights reserved.

--

--

--        Systems, Inc. The copyright notice above does not evidence

--        any actual or intended publication of such source code.

-- ----------------------------------------------------------------------*/

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/TblScript/WFD_ReviewSetMigration.script,v $ $Id: WFD_ReviewSetMigration.script,v 1.5.2.5 2020/10/04 01:06:32 abilbrey Exp $";

--  WFD_ReviewSetMigration
-- TABLENAME WF_Definition

print '... inserting Table: WF_Definition'
GO ---Remove it in upgrade scripts
DECLARE @tblRetCode integer



-- TABLENAME WF_Definition

SET QUOTED_IDENTIFIER ON

DECLARE @nowTime int

SET @nowTime = datediff(second, '01/01/1970', getUTCDate())

DECLARE @name nvarchar(255)

DECLARE @description nvarchar(MAX)

DECLARE @definition nvarchar(MAX)

DECLARE @workflowId int

DECLARE @version INT

DECLARE @flags INT

DECLARE @currentFlags INT

DECLARE @revision nvarchar(255)

DECLARE @currentRevision nvarchar(255)

SET @revision = '$Revision: 1.5.2.5 $'

SET @name = 'ReviewSet Migration'

SET @description = 'Workflow to migrate reviewset for upgraded Webserver.'

SET @version = 1

SET @flags = 6

SET @definition = '<workflow apiMode="0" config="&lt;configuration /&gt;" description="Workflow to migrate reviewset for upgraded Webserver." inputs="&lt;inputs /&gt;" interactive="1" isHtmlDescription="0" name="ReviewSet Migration" outputs="&lt;outputs /&gt;" revision="$Revision: 1.5.2.5 $" uniqueGuid="ff49cb57-5dd4-48b9-9059-0f99a356abf7" variables="&lt;variables&gt;&lt;itemList class=&quot;java.lang.String&quot; _list_=&quot;true&quot; /&gt;&lt;totalUpgWSCount class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot; /&gt;&lt;instanceName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;clientName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/variables&gt;" webHidden="0" workflowId="90">

  <schema>

    <inputs className="" name="inputs" type="" />

    <variables attribute="0" className="" name="variables" type="">

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="1" name="itemList" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.Integer" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.Integer" listType="0" name="totalUpgWSCount" type="{http://www.w3.org/2001/XMLSchema}integer" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="instanceName" type="{http://www.w3.org/2001/XMLSchema}string" />

      <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" hidden="0" inputType="java.lang.String" listType="0" name="clientName" type="{http://www.w3.org/2001/XMLSchema}string" />

    </variables>

    <outputs className="" name="outputs" type="" />

    <config className="" name="" type="" />

  </schema>

  <formProperties css="" javaScript="" />

  <Start commented="0" continueOnFailure="0" created="0" description="" displayName="Start" height="36" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="image;image=/images/jgraphx/house.png" uniqueName="Start_1" waitSetting="0" width="55" x="45" y="41">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="getWSLists" commented="0" originalStyle="" points="" sourceX="72" sourceY="59" status="0" style="defaultEdge" targetX="192" targetY="60" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Start>

  <Activity commented="0" continueOnFailure="0" created="1431070118376" description="executes queries against a commcell database" displayName="Get Upgraded Webservers" height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="getWSLists" waitSetting="0" width="180" x="154" y="70">

    <onExit language="1" script="if (xpath:{/workflow/getWSLists/resultSets/rowCount} &gt; 0)    &#xD;&#xA;   workflow.setVariable(&quot;totalUpgWSCount&quot;,1);&#xD;&#xA;   else    &#xD;&#xA;   workflow.setVariable(&quot;totalUpgWSCount&quot;,0);&#xD;&#xA;" />

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;SELECT DISTINCT name + ''#'' +cpp.attrVal&amp;#xD;&#xD;&#xA;FROM  APP_Client  C WITH (NOLOCK)&amp;#xD;&#xD;&#xA;INNER JOIN simInstalledPackages S WITH (NOLOCK) ON C.id = S.ClientId&amp;#xD;&#xD;&#xA;INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = C.id&amp;#xD;&#xD;&#xA;INNER JOIN APP_ClientProp CPP WITH (NOLOCK) ON CPP.componentNameId = C.id&amp;#xD;&#xD;&#xA;INNER JOIN APP_ClientProp CP2 WITH (NOLOCK) ON CP2.componentNameId = C.id&amp;#xD;&#xD;&#xA;WHERE  S.simPackageID = 252  &amp;#xD;&#xD;&#xA;   AND ( CP.attrName= ''ReviewSetMigrationStatus'' AND cp.modified= 0 AND CP.attrVal NOT IN (''Completed'')&amp;#xD;&#xD;&#xA;      OR NOT EXISTS (SELECT 1 FROM  APP_ClientProp CPP WHERE CPP.componentNameId = CP.componentNameId AND CPP.attrName= ''ReviewSetMigrationStatus''))&amp;#xD;&#xD;&#xA;    AND  ( CPP.attrName= ''galaxy instance name'' AND cp.modified= 0 )&amp;#xD;&#xD;&#xA;   AND ( ( CP2.attrName= ''Previous release'' AND CP2.attrval IN (''14'',''15'') AND cp2.modified= 0 )&#x9;AND C.releaseId = 16)&#x9;&amp;#xD;&#xD;&#xA;ORDER BY name + ''#'' +cpp.attrVal &lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="Switch_1" commented="0" originalStyle="" points="" sourceX="284" sourceY="59" status="0" style="defaultEdge" targetX="317" targetY="185" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1431071775503" description="iterates a group of activities over a list of values" displayName="ForEach" height="346" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_1" waitSetting="0" width="812" x="588" y="107">

    <activitySchema>

      <inputs>

        <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

        <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

        <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

        <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

      </inputs>

      <outputs name="outputs">

        <children attribute="0" className="java.lang.Object" defaultValue="" hidden="0" inputType="java.lang.Object" listType="0" name="col" type="{http://www.w3.org/2001/XMLSchema}anyType" />

      </outputs>

    </activitySchema>

    <onEnter language="1" script=" workflow.setVariable(&quot;instanceIndex&quot;, -1);" />

    <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;col&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/getWSLists/resultSets[1]/row/col}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;1&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

    <superProcess>

      <Start commented="0" continueOnFailure="0" created="1431071775503" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_2" waitSetting="0" width="120" x="18" y="30">

        <inputs val="&lt;inputs /&gt;" />

        <transition activity="ParallelFector" commented="0" originalStyle="" points="" sourceX="78" sourceY="45" status="0" style="defaultEdge" targetX="162" targetY="206" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Start>

      <Activity commented="0" continueOnFailure="0" created="1431096002550" description="executes queries against a commcell database" displayName="Get Parallel Factor " height="34" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery" uniqueName="ParallelFector" waitSetting="0" width="143" x="119" y="114">

        <onExit language="1" script="String list1 = new String(&quot;&quot;);&#xD;&#xA;for (i = 0; i &lt; xpath:{/workflow/ParallelFector/resultSets/row/col} ; i++)&#xD;&#xA;{&#xD;&#xA;    if(i &gt; 0)&#xD;&#xA;        list1 += &quot;,&quot;;&#xD;&#xA;    list1 += &quot;1&quot;;&#xD;&#xA;}&#xD;&#xA;&#xD;&#xA;workflow.setVariable(&quot;itemList&quot;, list1.split(&quot;,&quot;));&#xD;&#xA;String clientInstance = xpath:{/workflow/ForEach_1/col};&#xD;&#xA;workflow.setVariable(&quot;clientName&quot;, clientInstance.split(&quot;#&quot;)[0]);&#xD;&#xA;workflow.setVariable(&quot;instanceName&quot;, clientInstance.split(&quot;#&quot;)[1]);" />

        <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;declare @parallelFactor INT&amp;#xD;&#xD;&#xA;SET  @parallelFactor = ISNULL((select value from GXGlobalParam where name = ''ParallelReviewSetMigrations'' and modified = 0),5)&amp;#xD;&#xD;&#xA;select @parallelFactor&lt;/query&gt;&lt;/inputs&gt;" />

        <transition activity="ForEach_3" commented="0" originalStyle="" points="" sourceX="171" sourceY="211" status="0" style="defaultEdge" targetX="474" targetY="66" transitionIndex="0" x="0" y="0">

          <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

        </transition>

      </Activity>

      <Activity commented="0" continueOnFailure="0" created="1431099485825" description="iterates a group of activities over a list of values" displayName="ForEach" height="231" interactive="0" jobMode="0" name="ForEach" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="swimlane" uniqueName="ForEach_3" waitSetting="0" width="310" x="415" y="55">

        <activitySchema>

          <inputs>

            <children className="java.lang.String" inputType="java.lang.String" name="name" type="{http://www.w3.org/2001/XMLSchema}string" />

            <children className="java.lang.Object" inputType="java.lang.Object" name="values" type="{http://www.w3.org/2001/XMLSchema}anyType" />

            <children className="java.lang.Integer" defaultValue="1" inputType="java.lang.Integer" name="numberOfParallelExecutions" type="{http://www.w3.org/2001/XMLSchema}integer" />

            <children className="java.lang.Boolean" defaultValue="false" inputType="java.lang.Boolean" name="continueOnFailure" type="{http://www.w3.org/2001/XMLSchema}boolean" />

          </inputs>

          <outputs name="outputs">

            <children attribute="0" className="java.lang.String" controlType="0" defaultValue="" displayName="" documentation="" hidden="0" inputType="java.lang.String" listType="0" name="itemList" type="{http://www.w3.org/2001/XMLSchema}string" />

          </outputs>

        </activitySchema>

        <inputs val="&lt;inputs&gt;&lt;name class=&quot;java.lang.String&quot;&gt;itemList&lt;/name&gt;&lt;values class=&quot;java.lang.Object&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/itemList}&lt;/values&gt;&lt;numberOfParallelExecutions class=&quot;java.lang.Integer&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/ParallelFector/resultSets/row/col}&lt;/numberOfParallelExecutions&gt;&lt;continueOnFailure class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;true&lt;/continueOnFailure&gt;&lt;/inputs&gt;" />

        <superProcess>

          <Start commented="0" continueOnFailure="0" created="1431099485825" description="" displayName="Start" height="30" interactive="0" jobMode="0" name="Start" originalStyle="" skipAttempt="0" style="label;fillColor=#FFFF33;gradientColor=#FFFF00" uniqueName="Start_4" waitSetting="0" width="120" x="18" y="30">

            <inputs val="&lt;inputs /&gt;" />

            <transition activity="RvSetMigratorTool" commented="0" originalStyle="" points="" sourceX="78" sourceY="45" status="0" style="defaultEdge" targetX="137" targetY="140" transitionIndex="0" x="0" y="0">

              <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

            </transition>

          </Start>

          <Activity commented="0" continueOnFailure="0" created="1431103731572" description="Execute a command on a remote machine" displayName="Run ReviewSet Migrator Tool" height="34" interactive="0" jobMode="0" name="ExecuteCommand" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=ExecuteCommand" uniqueName="RvSetMigratorTool" waitSetting="0" width="193" x="41" y="123">

            <onEnter language="1" script="logger.info(&quot;clientName:::&quot;+xpath:{/workflow/variables/clientName});&#xD;&#xA;logger.info(&quot;instanceName:::&quot;+ xpath:{/workflow/variables/instanceName});&#xD;&#xA;" />

            <inputs val="&lt;inputs&gt;&lt;client class=&quot;commvault.msgs.CvEntities.ClientEntity&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/clientName}&lt;/client&gt;&lt;impersonateUserName class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;impersonateUserPassword class=&quot;workflow.types.EncryptedString&quot; _list_=&quot;false&quot; /&gt;&lt;startUpPath class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;command class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;ReviewSetMigrator.exe&lt;/command&gt;&lt;arguments class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/instanceName}&lt;/arguments&gt;&lt;waitForProcessCompletion class=&quot;java.lang.Boolean&quot; _list_=&quot;false&quot;&gt;false&lt;/waitForProcessCompletion&gt;&lt;/inputs&gt;" />

          </Activity>

        </superProcess>

      </Activity>

    </superProcess>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1432196929016" description="switch based decision" displayName="Is Upgraded WSPresent?" height="80" interactive="0" jobMode="0" name="Switch" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="rhombus;fontStyle=1" uniqueName="Switch_1" waitSetting="0" width="173" x="145" y="168">

    <inputs val="&lt;inputs&gt;&lt;expression class=&quot;java.lang.String&quot; _list_=&quot;false&quot;&gt;xpath:{/workflow/variables/totalUpgWSCount}&lt;/expression&gt;&lt;/inputs&gt;" />

    <transition activity="CommServDBQuery_1" commented="0" displayName="False" originalStyle="" points="" sourceX="230" sourceY="175" status="0" style="defaultEdge" targetX="230" targetY="451" transitionIndex="0" value="0" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

    <transition activity="EndUserSession_2" commented="0" displayName="True" originalStyle="" points="" sourceX="231" sourceY="208" status="0" style="defaultEdge" targetX="461" targetY="204" transitionIndex="0" value="1" x="0" y="0">

      <condition script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1432196942610" description="Ends the workflow" displayName="WorkflowEnd" height="34" interactive="0" jobMode="0" name="WorkflowEnd" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=WorkflowEnd" uniqueName="WorkflowEnd_1" waitSetting="0" width="106" x="174" y="399">

    <inputs val="&lt;inputs&gt;&lt;completionStatus class=&quot;workflow.types.WorkflowCompletionStatus&quot; _list_=&quot;false&quot; /&gt;&lt;failureMessage class=&quot;java.lang.String&quot; _list_=&quot;false&quot; /&gt;&lt;/inputs&gt;" />

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1433414369170" description="executes queries against a commcell database" displayName="Disable ReviewSet Migrator schedule if ALL WS migrated" height="60" interactive="0" jobMode="0" name="CommServDBQuery" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=CommServDBQuery;whiteSpace=wrap" uniqueName="CommServDBQuery_1" waitSetting="0" width="200" x="135" y="297">

    <inputs val="&lt;inputs&gt;&lt;commCell /&gt;&lt;query&gt;--Check if any WS exists, which are not yet migrated / upgraded&amp;#xD;&#xD;&#xA;IF NOT EXISTS(SELECT distinct  C.name &amp;#xD;&#xD;&#xA;&#x9;FROM  APP_Client  C WITH (NOLOCK)&amp;#xD;&#xD;&#xA;&#x9;INNER JOIN simInstalledPackages S WITH (NOLOCK) ON C.id = S.ClientId&amp;#xD;&#xD;&#xA;&#x9;INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = C.id&amp;#xD;&#xD;&#xA;&#x9;INNER JOIN APP_ClientProp CP2 WITH (NOLOCK) ON CP2.componentNameId = C.id&amp;#xD;&#xD;&#xA;&#x9;WHERE  S.simPackageID = 252  &amp;#xD;&#xD;&#xA;&#x9;   AND ( CP.attrName= ''ReviewSetMigrationStatus'' AND cp.modified= 0 AND CP.attrVal NOT IN (''Completed'' ,''Started'')&amp;#xD;&#xD;&#xA;&#x9;&#x9;  OR NOT EXISTS (SELECT 1 FROM  APP_ClientProp CPP WHERE CPP.componentNameId = CP.componentNameId AND CPP.attrName= ''ReviewSetMigrationStatus''))    &amp;#xD;&#xD;&#xA;&#x9;&#x9;AND ( ( ( CP2.attrName= ''Previous release'' AND CP2.attrval IN (''14'',''15'') AND cp2.modified= 0 )&#x9;AND C.releaseId = 16) OR C.releaseId = 15)&amp;#xD;&#xD;&#xA;&#x9;&#x9;AND (C.status &amp;amp; 0x2) &amp;lt;&amp;gt; 0x2  --uninstalled&amp;#xD;&#xD;&#xA;&#x9;&#x9;AND (C.status &amp;amp; 0x4) &amp;lt;&amp;gt; 0x4  --deleted&amp;#xD;&#xD;&#xA;&#x9;)&amp;#xD;&#xD;&#xA;BEGIN&amp;#xD;&#xD;&#xA;    --Check if reviewset workflow migration present&#x9;&amp;#xD;&#xD;&#xA;&#x9;IF EXISTS (SELECT * FROM TM_Task WHERE (flags &amp;amp; 0x200) = 0x200)&amp;#xD;&#xD;&#xA;&#x9; BEGIN&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;UPDATE TM_Task&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;SET disabled =1&#x9;&#x9;&amp;#xD;&#xD;&#xA;&#x9;&#x9;&#x9;WHERE  (flags &amp;amp; 0x200) = 0x200&amp;#xD;&#xD;&#xA;&#x9;END&amp;#xD;&#xD;&#xA;END&lt;/query&gt;&lt;/inputs&gt;" />

    <transition activity="WorkflowEnd_1" commented="0" originalStyle="" points="" sourceX="337" sourceY="402" status="0" style="defaultEdge" targetX="161" targetY="525" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

  <Activity commented="0" continueOnFailure="0" created="1434629135317" description="ends the interactive user session" displayName="EndUserSession" height="34" interactive="0" jobMode="0" name="EndUserSession" namespaceUri="commvault.cte.workflow.activities" originalStyle="" skipAttempt="0" style="label;image=EndUserSession" uniqueName="EndUserSession_2" waitSetting="0" width="124" x="397" y="198">

    <inputs val="&lt;inputs /&gt;" />

    <transition activity="ForEach_1" commented="0" originalStyle="" points="" sourceX="459" sourceY="215" status="0" style="defaultEdge" targetX="619" targetY="121" transitionIndex="0" x="0" y="0">

      <condition language="1" script="/*&#xA;The expression should return a boolean. Use the variable name &quot;activity&quot; to refer to the previous activity object. Example:&#xA;activity.exitCode==0;&#xA;*/&#xA;" />

    </transition>

  </Activity>

</workflow>'

IF not exists (select * from WF_Definition where Name = @name)

BEGIN
	INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision)


	VALUES (@name, @description, @definition, @version, getUTCDate(), getUTCDate(), 1, @flags, @revision)

	SET @workflowId = @@IDENTITY
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

ELSE

BEGIN

	SELECT @workflowId = WorkflowId, @version = Version, @currentFlags = flags, @currentRevision = ISNULL(revision, '') From WF_Definition WHERE Name = @name

	SET @version = @version + 1

	UPDATE WF_Definition

	SET Description = @description, Definition = @definition, Version = @version, Modified = getUTCDate(), revision = @revision

	WHERE Name = @name

	IF (@flags & 8 > 0 OR @flags & 16 > 0)

	BEGIN

		UPDATE WF_Definition

		SET flags = @flags

		WHERE Name = @name

	END
	INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)


	VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)

END

